/* ACTIONS :
   -1 -> Aucune action
	0 -> Chevron gris (état shutdown)
	1 -> Aucune action (préférer -1)
	2 -> Chevron orange (warning)
	3 -> Chevron rouge	(error)
	4 -> Remonte la couleur on ou off en fonction de l'etat du bit
  > 4 -> Action spécifique à définir dans app.js>GIWIK.analyzeActions

ACTIONS SPÉCIFIQUES :
	101 -> Alignment
	102 -> Heave init
	103 -> Fine alignment
	104 -> FastAlignmnt
	105 -> IMO Alignment
	106 -> Optimal Alignment
	107 -> Strategic Alignment
	108 -> System Ready
	201 -> CRT invalide
	202 -> Saturation altitude
	203 -> Saturation vitesse
	204 -> Fast Alignment failure
	205 -> Wait for position


GROUPES DE STATUTS (facultatifs) -----------------------------------------------------------------------------------------------------------------------

Exemple de déclaration d'un groupe de statuts :
GIWIK.statusBitsInfo.setGroup({name:'gps', title:MSG(['ext_sensors','gps']), module:2, position:0, open:true});
-> les paramètres "position" et "open" sont optionnels

Exemple de déclaration d'un bit de statut avec affectation à un groupe :
GIWIK._status_bits_info[ 9 + 32*4] = {'msg':100, 'status_on': 1, 'status_off':-1, 'group':{name:'gps',position:0 }, 'action_on':-1, 'action_off':-1};
-> le paramètre "position" est optionnel

Exemple de déclaration d'un bit de statut sans affectation à un groupe :
GIWIK._status_bits_info[ 9 + 32*4] = {'msg':100, 'status_on': 1, 'status_off':-1, 'group':{name:'gps',position:0 }, 'action_on':-1, 'action_off':-1};
*/

// Définition des groupes de statuts
GIWIK.statusBitsInfo.set = function ()
{
	//-------- GROUPE DE STATUS ----------------------
	if (GIWIK.is_gyro === true)
	{
		// Groupes de statuts détaillés du module IO
		GIWIK.statusBitsInfo.setGroup({name:'inputs',  title:MSG(['shared','inputs']), module:0, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'outputs', title:MSG(['shared','outputs']), module:0, position:1, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'pulses_in',  title:MSG(['detailedstatus','pulses_in']), module:0, position:2, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'pulses_out',  title:MSG(['detailedstatus','pulses_out']), module:0, position:3, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'io_others',  title:MSG(['detailedstatus','io_others']), module:0, position:4, open:true});

		// Groupes de status détaillés du module System
		GIWIK.statusBitsInfo.setGroup({name:'navigation',  title:MSG(['detailedstatus','navigation']),  module:1, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'system',  title:MSG(['detailedstatus','system']),  module:1, position:1, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'sensors',  title:MSG(['detailedstatus','sensors']),  module:1, position:2, open:true});

		// Groupes de status détaillés du module Ext Sensors
		GIWIK.statusBitsInfo.setGroup({name:'position',     title:MSG(['detailedstatus','position']), module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'speed',    title:MSG(['detailedstatus','speed']), module:2, position:1, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'time',    title:MSG(['detailedstatus','time']),  module:2, position:2, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'ext_others',  title:MSG(['detailedstatus','io_others']), module:2, position:0, open:true, visible_when_empty:false});
	}
	else
	{
		// Groupes de statuts détaillés du module IO
		GIWIK.statusBitsInfo.setGroup({name:'inputs',  title:MSG(['shared','inputs']),            module:0, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'outputs', title:MSG(['shared','outputs']),           module:0, position:1, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'pulses_in',  title:MSG(['detailedstatus','pulses_in']), module:0, position:2, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'pulses_out',  title:MSG(['detailedstatus','pulses_out']), module:0, position:3, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'io_others',  title:MSG(['detailedstatus','io_others']), module:0, position:4, open:true});

		var pos = 0;
		
		// Groupes de status détaillés du module System
		GIWIK.statusBitsInfo.setGroup({name:'navigation',  title:MSG(['detailedstatus','navigation']),  	module:1, position:pos, open:true});
		if(GIWIK.is_advans){
			GIWIK.statusBitsInfo.setGroup({name:'navigationMode',  title:MSG(['detailedstatus','navigationMode']),  module:1, position:++pos, open:true});
		}
		GIWIK.statusBitsInfo.setGroup({name:'calibration',  title:MSG(['detailedstatus','calibration']),  	module:1, position:++pos, open:true, visible_when_empty:false});
		GIWIK.statusBitsInfo.setGroup({name:'system',  title:MSG(['detailedstatus','system']),  			module:1, position:++pos, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'sensors',  title:MSG(['detailedstatus','sensors']),  			module:1, position:++pos, open:true});

		// Groupes de statuts détaillés du module Ext. Sensors
		GIWIK.statusBitsInfo.setGroup({name:'altitude',     title:MSG(['shared','altitude']),          module:2, position:0, open:true, visible_when_empty:false});
		GIWIK.statusBitsInfo.setGroup({name:'zupt',    title:MSG(['detailedstatus','zupt']),         module:2, position:0, open:true, visible_when_empty:false});
		GIWIK.statusBitsInfo.setGroup({name:'manualdata',    title:MSG(['detailedstatus','manualdata']),         module:2, position:0, open:true, visible_when_empty:false});
		GIWIK.statusBitsInfo.setGroup({name:'gps',     title:MSG(['ext_sensors','gps']),          module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'gps2',    title:MSG(['ext_sensors','gps2']),         module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'lbl',     title:MSG(['ext_sensors','lbl']),          module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'dvl',     title:MSG(['ext_sensors','dvl']),          module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'dvl2',    title:MSG(['ext_sensors','dvl2']),         module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'logem',   title:MSG(['ext_sensors','logem']),        module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'logem2',  title:MSG(['ext_sensors','logem2']),       module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'usbl',    title:MSG(['ext_sensors','usbl']),         module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'usbl2',   title:MSG(['ext_sensors','usbl2']),        module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'usbl3',   title:MSG(['ext_sensors','usbl3']),        module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'ctd',     title:MSG(['ext_sensors','ctd']),          module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'depth',   title:MSG(['ext_sensors','depth']),        module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'odometer',title:MSG(['ext_sensors','odometer']),     module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'dov',     title:MSG(['ext_sensors','dov']),          module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'angles',  title:MSG(['ext_sensors','angles']),       module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'utc',     title:MSG(['ext_sensors','utc']),          module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'utc2',    title:MSG(['ext_sensors','utc2']),         module:2, position:0, open:true});
		GIWIK.statusBitsInfo.setGroup({name:'ntp',    title:MSG(['detailedstatus','ntp']),         module:2, position:0, open:true, visible_when_empty:false});
		GIWIK.statusBitsInfo.setGroup({name:'ext_others',  title:MSG(['detailedstatus','io_others']), module:2, position:0, open:true, visible_when_empty:false});
	}


	//-------- STATUS SYSTEM MODE GYRO----------------
	if (GIWIK.is_gyro === true)
	{
		switch (GIWIK.system_type)
		{
			// Surface: OCTANS MKII
			case 12:
			case 7: // QUADRANS
				//------- Sys1 Sys 2 -------
				/* Input A activity */		GIWIK._status_bits_info[12 + 32*4] = {'msg':103, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
				/* Input B activity */		GIWIK._status_bits_info[13 + 32*4] = {'msg':104, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
				/* Input C activity */		GIWIK._status_bits_info[14 + 32*4] = {'msg':106, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
				/* Input D activity */		GIWIK._status_bits_info[15 + 32*4] = {'msg':107, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
				/* Serial input A error */	GIWIK._status_bits_info[ 4 + 32*4] = {'msg':113, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
				/* Serial input B error */	GIWIK._status_bits_info[ 5 + 32*4] = {'msg':114, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
				/* Serial input C error */	GIWIK._status_bits_info[ 6 + 32*4] = {'msg':116, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
				/* Serial input D error */	GIWIK._status_bits_info[ 7 + 32*4] = {'msg':117, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
				break;

			// OCTANS NANO
			 case 14:
			 case 19: // OCTANS 3000
				//------- Sys1 Sys 2 -------
				/* Input A activity */		GIWIK._status_bits_info[ 9 + 32*4] = {'msg':100, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
				/* Input B activity */		GIWIK._status_bits_info[10 + 32*4] = {'msg':101, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
				/* Input C activity */		GIWIK._status_bits_info[11 + 32*4] = {'msg':102, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
				/* Input D activity */		GIWIK._status_bits_info[12 + 32*4] = {'msg':103, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
				/* Input E activity */		GIWIK._status_bits_info[13 + 32*4] = {'msg':104, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
				/* Serial input A error */	GIWIK._status_bits_info[ 1 + 32*4] = {'msg':110, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
				/* Serial input B error */	GIWIK._status_bits_info[ 2 + 32*4] = {'msg':111, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
				/* Serial input C error */	GIWIK._status_bits_info[ 3 + 32*4] = {'msg':112, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
				/* Serial input D error */	GIWIK._status_bits_info[ 4 + 32*4] = {'msg':113, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
				/* Serial input E error */	GIWIK._status_bits_info[ 5 + 32*4] = {'msg':114, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
				break;
			
			// //AHRS NON DEFINI
			// case 2:
				// //------- Sys1 Sys 2 -------
				// /* Input A activity */		GIWIK._status_bits_info[12 + 32*4] = {'msg':100, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
				// /* Input B activity */		GIWIK._status_bits_info[13 + 32*4] = {'msg':101, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
				// /* Serial input A error */	GIWIK._status_bits_info[ 4 + 32*4] = {'msg':110, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
				// /* Serial input B error */	GIWIK._status_bits_info[ 5 + 32*4] = {'msg':111, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
				// break;
		}

		//------- Sys1 Sys 2 -------
		/* Input R activity */				GIWIK._status_bits_info[ 8 + 32*4] = {'msg':105, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
		/* Serial input R error */			GIWIK._status_bits_info[ 0 + 32*4] = {'msg':115, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial output A full */			GIWIK._status_bits_info[17 + 32*4] = {'msg':200, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial output B full */			GIWIK._status_bits_info[18 + 32*4] = {'msg':201, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial output C full */			GIWIK._status_bits_info[19 + 32*4] = {'msg':202, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial output D full */			GIWIK._status_bits_info[20 + 32*4] = {'msg':203, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial output E full */			GIWIK._status_bits_info[21 + 32*4] = {'msg':204, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Ethernet output full */			GIWIK._status_bits_info[22 + 32*4] = {'msg':206, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial output R full */			GIWIK._status_bits_info[16 + 32*4] = {'msg':205, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Internal time used */			GIWIK._status_bits_info[24 + 32*4] = {'msg':602, 'status_on': 1, 'status_off': 0, 'group':{name:'time',position:0}, 'action_on':-1, 'action_off':-1};
		/* External time received */		GIWIK._status_bits_info[31 + 32*4] = {'msg':603, 'status_on': 1, 'status_off': 0, 'group':{name:'time',position:1}, 'action_on':-1, 'action_off':-1};
		/* External time synchronized */	GIWIK._status_bits_info[25 + 32*4] = {'msg':604, 'status_on': 1, 'status_off': 0, 'group':{name:'time',position:2}, 'action_on': 4, 'action_off':-1};
		/* External latitude received */	GIWIK._status_bits_info[23 + 32*4] = {'msg':605, 'status_on': 1, 'status_off': 0, 'group':{name:'position',position:0}, 'action_on': 4, 'action_off':-1};
		if(in_array(GIWIK.system_type, [7,12,19,14]))
		{
			/* External longitude received */	GIWIK._status_bits_info[45 + 32*4] = {'msg':609, 'status_on': 1, 'status_off': 0, 'group':{name:'position',position:0}, 'action_on': 4, 'action_off':-1};
		}
		/* External speed received */		GIWIK._status_bits_info[49 + 32*4] = {'msg':606, 'status_on': 1, 'status_off': 0, 'group':{name:'speed',position:0}, 'action_on': 4, 'action_off':-1};
		/* Pulse In A */					GIWIK._status_bits_info[27 + 32*4] = {'msg':120, 'status_on': 1, 'status_off':-1, 'group':{name:'pulses_in',position:0}, 'action_on': 4, 'action_off':-1};
		/* Pulse In B */					GIWIK._status_bits_info[28 + 32*4] = {'msg':121, 'status_on': 1, 'status_off':-1, 'group':{name:'pulses_in',position:0}, 'action_on':-1, 'action_off':-1};
		/* Pulse In C */					GIWIK._status_bits_info[29 + 32*4] = {'msg':122, 'status_on': 1, 'status_off':-1, 'group':{name:'pulses_in',position:0}, 'action_on':-1, 'action_off':-1};
		/* Pulse In D */					GIWIK._status_bits_info[30 + 32*4] = {'msg':123, 'status_on': 1, 'status_off':-1, 'group':{name:'pulses_in',position:0}, 'action_on':-1, 'action_off':-1};
		/* MPC overload */					GIWIK._status_bits_info[59 + 32*4] = {'msg':300, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on': 2, 'action_off':-1};
		/* Power failure */					GIWIK._status_bits_info[60 + 32*4] = {'msg':301, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on': 3, 'action_off':-1};
		/* Config saved */					GIWIK._status_bits_info[62 + 32*4] = {'msg':302, 'status_on': 1, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on':-1, 'action_off':-1};
		/* Incompatible DSP */				GIWIK._status_bits_info[50 + 32*4] = {'msg':304, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on': 3, 'action_off':-1};
		/* Polar Mode */					GIWIK._status_bits_info[23 + 32*5] = {'msg':313, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on':-1, 'action_off':-1};
		/* Internal Log */					GIWIK._status_bits_info[56 + 32*4] = {'msg':314, 'status_on': 1, 'status_off':-1, 'group':{name:'io_others',position:0}, 'action_on':-1, 'action_off':-1};
		/* Analog Failure */				GIWIK._status_bits_info[57 + 32*4] = {'msg':316, 'status_on': 3, 'status_off':-1, 'group':{name:'io_others',position:0}, 'action_on': 3, 'action_off':-1};
		/* Usine Mode */					GIWIK._status_bits_info[61 + 32*4] = {'msg':312, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on':-1, 'action_off':-1};
		/* Simulation mode */				GIWIK._status_bits_info[48 + 32*4] = {'msg':307, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on':-1, 'action_off':-1};

	}
	// ------- STATUS SYSTEM MODE INS -----------------
	else
	{

		//------- Sys1 Sys 2 -------
		/* Input A activity */			GIWIK._status_bits_info[ 9 + 32*4] = {'msg':100, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
		/* Input B activity */			GIWIK._status_bits_info[10 + 32*4] = {'msg':101, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
		/* Input C activity */			GIWIK._status_bits_info[11 + 32*4] = {'msg':102, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
		/* Input D activity */			GIWIK._status_bits_info[12 + 32*4] = {'msg':103, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
		/* Input E activity */			GIWIK._status_bits_info[13 + 32*4] = {'msg':104, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
		/* Input F activity */			GIWIK._status_bits_info[14 + 32*4] = {'msg':106, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
		/* Input G activity */			GIWIK._status_bits_info[15 + 32*4] = {'msg':107, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};
		/* Input R activity */			GIWIK._status_bits_info[ 8 + 32*4] = {'msg':105, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};

		/* Serial input A error */		GIWIK._status_bits_info[ 1 + 32*4] = {'msg':110, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0 }, 'action_on': 3, 'action_off':-1};
		/* Serial input B error */		GIWIK._status_bits_info[ 2 + 32*4] = {'msg':111, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial input C error */		GIWIK._status_bits_info[ 3 + 32*4] = {'msg':112, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial input D error */		GIWIK._status_bits_info[ 4 + 32*4] = {'msg':113, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial input E error */		GIWIK._status_bits_info[ 5 + 32*4] = {'msg':114, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial input F error */		GIWIK._status_bits_info[ 6 + 32*4] = {'msg':116, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial input G error */		GIWIK._status_bits_info[ 7 + 32*4] = {'msg':117, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial input R error */		GIWIK._status_bits_info[ 0 + 32*4] = {'msg':115, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on': 3, 'action_off':-1};

		/* Serial output A full */		GIWIK._status_bits_info[17 + 32*4] = {'msg':200, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial output B full */		GIWIK._status_bits_info[18 + 32*4] = {'msg':201, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial output C full */		GIWIK._status_bits_info[19 + 32*4] = {'msg':202, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial output D full */		GIWIK._status_bits_info[20 + 32*4] = {'msg':203, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial output E full */		GIWIK._status_bits_info[21 + 32*4] = {'msg':204, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Ethernet output full */		GIWIK._status_bits_info[22 + 32*4] = {'msg':206, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};
		/* Serial output R full */		GIWIK._status_bits_info[16 + 32*4] = {'msg':205, 'status_on': 3, 'status_off':-1, 'group':{name:'outputs',position:0}, 'action_on': 3, 'action_off':-1};

		/* Pulse In A */				GIWIK._status_bits_info[27 + 32*4] = {'msg':120, 'status_on': 1, 'status_off':-1, 'group':{name:'pulses_in',position:0}, 'action_on':-1, 'action_off':-1};
		/* Pulse In B */				GIWIK._status_bits_info[28 + 32*4] = {'msg':121, 'status_on': 1, 'status_off':-1, 'group':{name:'pulses_in',position:0}, 'action_on':-1, 'action_off':-1};
		/* Pulse In C */				GIWIK._status_bits_info[29 + 32*4] = {'msg':122, 'status_on': 1, 'status_off':-1, 'group':{name:'pulses_in',position:0}, 'action_on':-1, 'action_off':-1};
		/* Pulse In D */				GIWIK._status_bits_info[30 + 32*4] = {'msg':123, 'status_on': 1, 'status_off':-1, 'group':{name:'pulses_in',position:0}, 'action_on':-1, 'action_off':-1};

		/* UTC_synchro_detected */		GIWIK._status_bits_info[ 9 + 32*5] = {'msg':410, 'status_on': 1, 'status_off':-1, 'group':{name:'utc',position:0}, 'action_on':-1, 'action_off':-1};
		/* PPS_synchro_detected */		GIWIK._status_bits_info[11 + 32*5] = {'msg':411, 'status_on': 1, 'status_off':-1, 'group':{name:'utc',position:1}, 'action_on':-1, 'action_off':-1};
		/* GPS detected */				GIWIK._status_bits_info[ 2 + 32*5] = {'msg':420, 'status_on': 1, 'status_off':-1, 'group':{name:'gps',position:0}, 'action_on':-1, 'action_off':-1};
		/* GPS2 detected */				GIWIK._status_bits_info[ 3 + 32*5] = {'msg':520, 'status_on': 1, 'status_off':-1, 'group':{name:'gps2',position:0}, 'action_on':-1, 'action_off':-1};

		if (GIWIK.alti_depth)
		{
			if (in_array(GIWIK.system_type, [7,11]))
			{
		/* Altitude detected */			GIWIK._status_bits_info[10 + 32*5] = {'msg':430, 'status_on':-1, 'status_off':-1, 'group':{name:'altitude',position:0}, 'action_on':-1, 'action_off':-1};
			}
			else
			{
		/* Altitude detected */			GIWIK._status_bits_info[10 + 32*5] = {'msg':430, 'status_on': 1, 'status_off':-1, 'group':{name:'altitude',position:0}, 'action_on':-1, 'action_off':-1};
			}
		}
		/* DVL BT detected */			GIWIK._status_bits_info[ 0 + 32*5] = {'msg':440, 'status_on': 1, 'status_off':-1, 'group':{name:'dvl',position:0}, 'action_on':-1, 'action_off':-1};
		/* USBL detected */				GIWIK._status_bits_info[ 4 + 32*5] = {'msg':450, 'status_on': 1, 'status_off':-1, 'group':{name:'usbl',position:0}, 'action_on':-1, 'action_off':-1};
		/* Depth detected */			GIWIK._status_bits_info[ 6 + 32*5] = {'msg':460, 'status_on': 1, 'status_off':-1, 'group':{name:'depth',position:0}, 'action_on':-1, 'action_off':-1};
		/* LBL detected */				GIWIK._status_bits_info[ 5 + 32*5] = {'msg':470, 'status_on': 1, 'status_off':-1, 'group':{name:'lbl',position:0}, 'action_on':-1, 'action_off':-1};
		/* DVL WT detected */			GIWIK._status_bits_info[ 1 + 32*5] = {'msg':480, 'status_on': 1, 'status_off':-1, 'group':{name:'dvl',position:5}, 'action_on':-1, 'action_off':-1};
		/* EM LOG detected */			GIWIK._status_bits_info[ 7 + 32*5] = {'msg':490, 'status_on': 1, 'status_off':-1, 'group':{name:'logem',position:0}, 'action_on':-1, 'action_off':-1};
		/* ODO detected */				GIWIK._status_bits_info[ 8 + 32*5] = {'msg':530, 'status_on': 1, 'status_off':-1, 'group':{name:'odometer',position:0}, 'action_on':-1, 'action_off':-1};
		/* Position manuelle detected */GIWIK._status_bits_info[14 + 32*5] = {'msg':500, 'status_on': 1, 'status_off':-1, 'group':{name:'manualdata',position:0}, 'action_on':-1, 'action_off':-1};
		
		if(GIWIK._ext_sensors.angles){
			/* Angles detected */		GIWIK._status_bits_info[15 + 32*5] = {'msg':510, 'status_on': 1, 'status_off':-1, 'group':{name:'angles',position:0}, 'action_on':-1, 'action_off':-1};		
		}
		else{
			/* CTD detected */			GIWIK._status_bits_info[15 + 32*5] = {'msg':510, 'status_on': 1, 'status_off':-1, 'group':{name:'ctd',position:0}, 'action_on':-1, 'action_off':-1};
		}
		/* MPC overload */				GIWIK._status_bits_info[27 + 32*5] = {'msg':300, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on': 2, 'action_off':-1};
		/* Power failure */				GIWIK._status_bits_info[28 + 32*5] = {'msg':301, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on': 3, 'action_off':-1};
		/* Config saved */				GIWIK._status_bits_info[30 + 32*5] = {'msg':302, 'status_on': 1, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on':-1, 'action_off':-1};
		/* Incompatible DSP */			GIWIK._status_bits_info[18 + 32*5] = {'msg':304, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on': 3, 'action_off':-1};
		/* Simulation Mode */			GIWIK._status_bits_info[16 + 32*5] = {'msg':307, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on':-1, 'action_off':-1};
		/* Heading alert */				GIWIK._status_bits_info[19 + 32*5] = {'msg':305, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on': 4, 'action_off': 4};
		/* Position alert */			GIWIK._status_bits_info[20 + 32*5] = {'msg':306, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on': 4, 'action_off': 4};
		/* Wait for position */			GIWIK._status_bits_info[21 + 32*5] = {'msg':311, 'status_on': 2, 'status_off':-1, 'group':{name:'navigation',position:8}, 'action_on':205, 'action_off':-1};
		/* Polar Mode */				GIWIK._status_bits_info[23 + 32*5] = {'msg':313, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on':-1, 'action_off':-1};
		/* Internal Log */				GIWIK._status_bits_info[24 + 32*5] = {'msg':314, 'status_on': 1, 'status_off':-1, 'group':{name:'io_others',position:0}, 'action_on':-1, 'action_off':-1};
		/* DOV CORR */					GIWIK._status_bits_info[26 + 32*5] = {'msg':315, 'status_on': 1, 'status_off':-1, 'group':{name:'dov',position:0}, 'action_on':-1, 'action_off':-1};
		/* Usine Mode */				GIWIK._status_bits_info[29 + 32*5] = {'msg':312, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on':401, 'action_off':402};

		//------- System 3 --------
		/* UTC2_synchro_detected  */	GIWIK._status_bits_info[ 0 + 32*7] = {'msg':570, 'status_on': 1, 'status_off':-1, 'group':{name:'utc2',position:0}, 'action_on':-1, 'action_off':-1};
		/* PPS2_synchro_detected  */	GIWIK._status_bits_info[ 1 + 32*7] = {'msg':571, 'status_on': 1, 'status_off':-1, 'group':{name:'utc2',position:1}, 'action_on':-1, 'action_off':-1};
		/* Advanced Filtering ON  */	GIWIK._status_bits_info[ 2 + 32*7] = {'msg':572, 'status_on': 2, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':-1, 'action_off':-1};

		if (GIWIK._plugins.network.ntp)
		{
		/* NTP_in_progress  */			GIWIK._status_bits_info[ 3 + 32*7] = {'msg':573, 'status_on': 2, 'status_off':-1, 'group':{name:'ntp',position:0}, 'action_on':-1, 'action_off':-1};
		/* NTP_received  */				GIWIK._status_bits_info[ 4 + 32*7] = {'msg':574, 'status_on': 1, 'status_off':-1, 'group':{name:'ntp',position:1}, 'action_on':-1, 'action_off':-1};
		/* NTP_synchro  */				GIWIK._status_bits_info[ 5 + 32*7] = {'msg':575, 'status_on': 1, 'status_off':-1, 'group':{name:'ntp',position:2}, 'action_on':-1, 'action_off':-1};
		/* NTP_failed  */				GIWIK._status_bits_info[ 6 + 32*7] = {'msg':576, 'status_on': 3, 'status_off':-1, 'group':{name:'ntp',position:3}, 'action_on':-1, 'action_off':-1};
		}
		/* DVL2 BT detected */			GIWIK._status_bits_info[ 8+ 32*7] = {'msg':588, 'status_on': 1, 'status_off':-1, 'group':{name:'dvl2',position:0}, 'action_on':-1, 'action_off':-1};
		/* DVL2 WT detected */			GIWIK._status_bits_info[ 9+ 32*7] = {'msg':589, 'status_on': 1, 'status_off':-1, 'group':{name:'dvl2',position:5}, 'action_on':-1, 'action_off':-1};
		/* logem2 detected */			GIWIK._status_bits_info[ 10+ 32*7] = {'msg':535, 'status_on': 1, 'status_off':-1, 'group':{name:'logem2',position:0}, 'action_on':-1, 'action_off':-1};
		/* Angles Loss detected */		GIWIK._status_bits_info[ 11+ 32*7] = {'msg':511, 'status_on': 2, 'status_off':-1, 'group':{name:'angles',position:0}, 'action_on':2, 'action_off':-1};
		/* geoframe error */		    GIWIK._status_bits_info[ 12+ 32*7] = {'msg':577, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:1}, 'action_on':-1, 'action_off':-1};
		/* VTG1 detected*/				GIWIK._status_bits_info[ 13+ 32*7] = {'msg':525, 'status_on': 1, 'status_off':-1, 'group':{name:'gps',position:1}, 'action_on':-1, 'action_off':-1};
		/* VTG2 detected*/				GIWIK._status_bits_info[ 14+ 32*7] = {'msg':526, 'status_on': 1, 'status_off':-1, 'group':{name:'gps2',position:1}, 'action_on':-1, 'action_off':-1};
		/* Manual Attitude detected*/	GIWIK._status_bits_info[ 15+ 32*7] = {'msg':527, 'status_on': 1, 'status_off':-1, 'group':{name:'manualdata',position:5}, 'action_on':-1, 'action_off':-1};
		
		/* CAN error */					GIWIK._status_bits_info[ 16+ 32*7] = {'msg':118, 'status_on': 3, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':3, 'action_off':-1};
		/* CAN Detected */				GIWIK._status_bits_info[ 17+ 32*7] = {'msg':108, 'status_on': 1, 'status_off':-1, 'group':{name:'inputs',position:0}, 'action_on':-1, 'action_off':-1};

		/* System ready */ 				GIWIK._status_bits_info[ 18+ 32*7] = {'msg':643, 'status_on': -1, 'status_off': -1, 'group':{name:'navigation',position:6}, 'action_on': 108, 'action_off':-1};
		/* Logbook updated */ 			GIWIK._status_bits_info[ 19+ 32*7] = {'msg':662, 'status_on': 1, 'status_off': -1, 'group':{name:'io_others',position:0}, 'action_on': -1, 'action_off':-1};
		/* Manual pulse out A*/ 		GIWIK._status_bits_info[ 20+ 32*7] = {'msg':663, 'status_on': 1, 'status_off': -1, 'group':{name:'pulses_out',position:0}, 'action_on': -1, 'action_off':-1};
		/* Manual pulse out B*/ 		GIWIK._status_bits_info[ 21+ 32*7] = {'msg':664, 'status_on': 1, 'status_off': -1, 'group':{name:'pulses_out',position:0}, 'action_on': -1, 'action_off':-1};
	}

	// ---------- STATUS SYSTEM COMMUNS GYRO INS --------------





	//--------STATUS ALGO MODE GYRO----------------
	if (GIWIK.is_gyro === true)
	{
		/* Navigation mode */		GIWIK._status_bits_info[ 0 + 32*2] = {'msg':323, 'status_on':-1, 'status_off':-1, 'group':{name:'navigation',position:3}, 'action_on':-1, 'action_off':-1};
		/* Alignment */				GIWIK._status_bits_info[ 1 + 32*2] = {'msg':320, 'status_on': 2, 'status_off': 0, 'group':{name:'navigation',position:0}, 'action_on':101, 'action_off':-1};
		/* Fine alignment */		GIWIK._status_bits_info[ 2 + 32*2] = {'msg':324, 'status_on': 2, 'status_off':0, 'group':{name:'navigation',position:1}, 'action_on':103, 'action_off':-1};
		/* Fast Alignment */		GIWIK._status_bits_info[22 + 32*3] = {'msg':327, 'status_on':-1, 'status_off':-1, 'group':{name:'navigation',position:2}, 'action_on':-1, 'action_off':-1};
		/* IMO alignment */ 		GIWIK._status_bits_info[30 + 32*2] = {'msg':578, 'status_on': 2, 'status_off':-1, 'group':{name:'navigation',position:4}, 'action_on': -1, 'action_off':-1};
		/* Optimal alignment */ 	GIWIK._status_bits_info[31 + 32*2] = {'msg':579, 'status_on': 2, 'status_off':-1, 'group':{name:'navigation',position:5}, 'action_on': -1, 'action_off':-1};		

		/* Heave init */			if (GIWIK.heave) {GIWIK._status_bits_info[ 5 + 32*2] = {'msg':321, 'status_on': 2, 'status_off': 0, 'group':{name:'navigation',position:7}, 'action_on': 102, 'action_off':-1};}
		/* Manual latitude */		GIWIK._status_bits_info[ 7 + 32*2] = {'msg':600, 'status_on': 1, 'status_off': 0, 'group':{name:'navigation',position:9}, 'action_on': 4, 'action_off':-1};
		if (in_array(GIWIK.system_type, [12,19,14]))
		{
		/* Manual longitude */		GIWIK._status_bits_info[ 13 + 32*2] = {'msg':608, 'status_on': 1, 'status_off': 0, 'group':{name:'navigation',position:10}, 'action_on': 4, 'action_off':-1};
		}
		/* Manual speed */			GIWIK._status_bits_info[ 8 + 32*2] = {'msg':601, 'status_on': 1, 'status_off': 0, 'group':{name:'navigation',position:11}, 'action_on': 4, 'action_off':-1};
		// /* Latitude Comp */		GIWIK._status_bits_info[ 9 + 32*2] = {'msg':607, 'status_on': 1, 'status_off': 0, 'group':{name:'navigation',position:9}, 'action_on': 4, 'action_off':-1};
		/* CRT invalide */			GIWIK._status_bits_info[22 + 32*2] = {'msg':322, 'status_on': 2, 'status_off':-1, 'group':{name:'navigation',position:8}, 'action_on':201, 'action_off':-1};
		/* Saturation vitesse */	GIWIK._status_bits_info[29 + 32*2] = {'msg':326, 'status_on': 3, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':203, 'action_off':-1};

		/* Manual Coupling mode */	GIWIK._status_bits_info[ 10  + 32*2] = {'msg':340, 'status_on': 1, 'status_off': -1, 'group':{name:'system',position:0}, 'action_on': -1, 'action_off':-1};
		/* Position Coupling mode*/	GIWIK._status_bits_info[ 11 + 32*2] = {'msg':341, 'status_on': 1, 'status_off': -1, 'group':{name:'system',position:0}, 'action_on': -1, 'action_off':-1};
		/* Speed Coupling mode */	GIWIK._status_bits_info[ 12 + 32*2] = {'msg':342, 'status_on': 1, 'status_off': -1, 'group':{name:'system',position:0}, 'action_on': -1, 'action_off':-1};	
		/* Polar Data Validity */	GIWIK._status_bits_info[ 14 + 32*2] = {'msg':343, 'status_on': 2, 'status_off': -1, 'group':{name:'navigation',position:0}, 'action_on': -1, 'action_off':-1};

		/* Undefined Sensors */ 	GIWIK._status_bits_info[ 15 + 32*2] = {'msg':358, 'status_on': 3, 'status_off': -1, 'group':{name:'system',position:0}, 'action_on': -1, 'action_off':-1};
		/* System saturation */		GIWIK._status_bits_info[ 28 + 32*2] = {'msg':636, 'status_on': 3, 'status_off': -1, 'group':{name:'system',position:0}, 'action_on': 206, 'action_off':-1};	
		/* Inconsistent data */		GIWIK._status_bits_info[ 30 + 32*2] = {'msg':593, 'status_on': 3, 'status_off':-1, 'group':{name:'ext_others',position:0}, 'action_on':-1, 'action_off':-1};
	}

	//--------STATUS ALGO MODE INS----------------
	else
	{
		/* Alignment */					GIWIK._status_bits_info[ 1 + 32*2] = {'msg':320, 'status_on': 2, 'status_off': 0, 'group':{name:'navigation',position:0}, 'action_on':101, 'action_off':-1};
		
		if( GIWIK.is_advans )
		{
		/* Navigation mode */			GIWIK._status_bits_info[ 0 + 32*2] = {'msg':323, 'status_on': 1, 'status_off': 0, 'group':{name:'navigation',position:2}, 'action_on':100, 'action_off':-1};
		/* Fast Alignment */			GIWIK._status_bits_info[22 + 32*3] = {'msg':327, 'status_on': 2, 'status_off': 0, 'group':{name:'navigation',position:1}, 'action_on':104, 'action_off':-1};
			
			if( !GIWIK.is_mems) 
			{
				/* Fine alignment */			GIWIK._status_bits_info[ 2 + 32*2] = {'msg':324, 'status_on': 1, 'status_off': 0, 'group':{name:'navigation',position:1}, 'action_on':103, 'action_off':-1};
			}
		}
		if (in_array(GIWIK.system_type, [7,11]))
		{
		/* Navigation mode */			GIWIK._status_bits_info[ 0 + 32*2] = {'msg':323, 'status_on':-1, 'status_off':-1, 'group':{name:'navigation',position:3}, 'action_on':-1, 'action_off':-1};
		/* Fast Alignment */			GIWIK._status_bits_info[22 + 32*3] = {'msg':327, 'status_on':-1, 'status_off':-1, 'group':{name:'navigation',position:2}, 'action_on':-1, 'action_off':-1};
		/* Fine alignment */			GIWIK._status_bits_info[ 2 + 32*2] = {'msg':324, 'status_on':-1, 'status_off':-1, 'group':{name:'navigation',position:1}, 'action_on':-1, 'action_off':-1};
		}
		else
		{
			/* Navigation mode */			GIWIK._status_bits_info[ 0 + 32*2] = {'msg':323, 'status_on': 1, 'status_off': 0, 'group':{name:'navigation',position:2}, 'action_on':100, 'action_off':-1};
			/* Fast Alignment */			GIWIK._status_bits_info[22 + 32*3] = {'msg':327, 'status_on': 2, 'status_off': 0, 'group':{name:'navigation',position:1}, 'action_on':104, 'action_off':-1};
			/* Fine alignment */			GIWIK._status_bits_info[ 2 + 32*2] = {'msg':324, 'status_on': 1, 'status_off': 0, 'group':{name:'navigation',position:1}, 'action_on':103, 'action_off':-1};
		}
		
		/* Saturation altitude */		GIWIK._status_bits_info[28 + 32*2] = {'msg':325, 'status_on': 3, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':202, 'action_off':-1};
		/* Saturation vitesse */		GIWIK._status_bits_info[29 + 32*2] = {'msg':326, 'status_on': 3, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':203, 'action_off':-1};
		/* Dead reckoning */			GIWIK._status_bits_info[ 3 + 32*2] = {'msg':400, 'status_on': 2, 'status_off':-1, 'group':{name:'calibration',position:0}, 'action_on': -1, 'action_off':-1};
		if (GIWIK.heave)
		{
		/* Heave init */				GIWIK._status_bits_info[31 + 32*2] = {'msg':321, 'status_on': 2, 'status_off': 0, 'group':{name:'navigation',position:7}, 'action_on':102, 'action_off':-1};
		}

		if (GIWIK.alti_depth && GIWIK.altimode)
		{
			if (in_array(GIWIK.system_type, [7,11]))
			{
		/* Altitude GPS */				GIWIK._status_bits_info[ 4 + 32*2] = {'msg':401, 'status_on':-1, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':-1, 'action_off':-1};
		/* Altitude Depth */			GIWIK._status_bits_info[ 5 + 32*2] = {'msg':402, 'status_on':-1, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':-1, 'action_off':-1};
		/* Altitude stabilisée */		GIWIK._status_bits_info[ 6 + 32*2] = {'msg':403, 'status_on':-1, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':-1, 'action_off':-1};
		/* Altitude hydro */			GIWIK._status_bits_info[ 7 + 32*2] = {'msg':404, 'status_on':-1, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':-1, 'action_off':-1};
			}
			else
			{
		/* Altitude GPS */				GIWIK._status_bits_info[ 4 + 32*2] = {'msg':401, 'status_on': 1, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':-1, 'action_off':-1};
		/* Altitude Depth */			GIWIK._status_bits_info[ 5 + 32*2] = {'msg':402, 'status_on': 1, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':-1, 'action_off':-1};
		/* Altitude stabilisée */		GIWIK._status_bits_info[ 6 + 32*2] = {'msg':403, 'status_on': 1, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':-1, 'action_off':-1};
		/* Altitude hydro */			GIWIK._status_bits_info[ 7 + 32*2] = {'msg':404, 'status_on': 1, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':-1, 'action_off':-1};
			}
		}

		/* GPS reçu */					GIWIK._status_bits_info[12 + 32*2] = {'msg':421, 'status_on': 1, 'status_off':-1, 'group':{name:'gps',position:4}, 'action_on':-1, 'action_off':-1};
		/* GPS valide */				GIWIK._status_bits_info[13 + 32*2] = {'msg':422, 'status_on': 1, 'status_off':-1, 'group':{name:'gps',position:1}, 'action_on':-1, 'action_off':-1};
		/* GPS waiting */				GIWIK._status_bits_info[14 + 32*2] = {'msg':423, 'status_on': 2, 'status_off':-1, 'group':{name:'gps',position:2}, 'action_on':-1, 'action_off':-1};
		/* GPS rejeté */				GIWIK._status_bits_info[15 + 32*2] = {'msg':424, 'status_on': 3, 'status_off':-1, 'group':{name:'gps',position:3}, 'action_on':-1, 'action_off':-1};

		if (GIWIK.alti_depth)
		{
			if (in_array(GIWIK.system_type, [7,11]))
			{
		/* Altitude reçue */			GIWIK._status_bits_info[12 + 32*3] = {'msg':431, 'status_on':-1, 'status_off':-1, 'group':{name:'altitude',position:4}, 'action_on':-1, 'action_off':-1};
		/* Altitude valide */			GIWIK._status_bits_info[13 + 32*3] = {'msg':432, 'status_on':-1, 'status_off':-1, 'group':{name:'altitude',position:1}, 'action_on':-1, 'action_off':-1};
		/* Altitude waiting */			GIWIK._status_bits_info[14 + 32*3] = {'msg':433, 'status_on':-1, 'status_off':-1, 'group':{name:'altitude',position:2}, 'action_on':-1, 'action_off':-1};
		/* Altitude rejeté */			GIWIK._status_bits_info[15 + 32*3] = {'msg':434, 'status_on':-1, 'status_off':-1, 'group':{name:'altitude',position:3}, 'action_on':-1, 'action_off':-1};
			}
			else
			{
		/* Altitude reçue */			GIWIK._status_bits_info[12 + 32*3] = {'msg':431, 'status_on': 1, 'status_off':-1, 'group':{name:'altitude',position:4}, 'action_on':-1, 'action_off':-1};
		/* Altitude valide */			GIWIK._status_bits_info[13 + 32*3] = {'msg':432, 'status_on': 1, 'status_off':-1, 'group':{name:'altitude',position:1}, 'action_on':-1, 'action_off':-1};
		/* Altitude waiting */			GIWIK._status_bits_info[14 + 32*3] = {'msg':433, 'status_on': 2, 'status_off':-1, 'group':{name:'altitude',position:2}, 'action_on':-1, 'action_off':-1};
		/* Altitude rejeté */			GIWIK._status_bits_info[15 + 32*3] = {'msg':434, 'status_on': 3, 'status_off':-1, 'group':{name:'altitude',position:3}, 'action_on':-1, 'action_off':-1};
			}
		}
		/* DVL BT reçu */				GIWIK._status_bits_info[ 8 + 32*2] = {'msg':441, 'status_on': 1, 'status_off':-1, 'group':{name:(GIWIK._ext_sensors.dvl ? 'dvl' : 'odometer'),position:4}, 'action_on':-1, 'action_off':-1};
		/* DVL BT valide */				GIWIK._status_bits_info[ 9 + 32*2] = {'msg':442, 'status_on': 1, 'status_off':-1, 'group':{name:(GIWIK._ext_sensors.dvl ? 'dvl' : 'odometer'),position:1}, 'action_on':-1, 'action_off':-1};
		/* DVL BT waiting */			GIWIK._status_bits_info[10 + 32*2] = {'msg':443, 'status_on': 2, 'status_off':-1, 'group':{name:(GIWIK._ext_sensors.dvl ? 'dvl' : 'odometer'),position:2}, 'action_on':-1, 'action_off':-1};
		/* DVL BT rejeté */				GIWIK._status_bits_info[11 + 32*2] = {'msg':444, 'status_on': 3, 'status_off':-1, 'group':{name:(GIWIK._ext_sensors.dvl ? 'dvl' : 'odometer'),position:3}, 'action_on':-1, 'action_off':-1};

		/* USBL reçu */					GIWIK._status_bits_info[16 + 32*2] = {'msg':451, 'status_on': 1, 'status_off':-1, 'group':{name:'usbl',position:4}, 'action_on':-1, 'action_off':-1};
		/* USBL valide */				GIWIK._status_bits_info[17 + 32*2] = {'msg':452, 'status_on': 1, 'status_off':-1, 'group':{name:'usbl',position:1}, 'action_on':-1, 'action_off':-1};
		/* USBL waiting */				GIWIK._status_bits_info[18 + 32*2] = {'msg':453, 'status_on': 2, 'status_off':-1, 'group':{name:'usbl',position:2}, 'action_on':-1, 'action_off':-1};
		/* USBL rejeté */				GIWIK._status_bits_info[19 + 32*2] = {'msg':454, 'status_on': 3, 'status_off':-1, 'group':{name:'usbl',position:3}, 'action_on':-1, 'action_off':-1};
		/* Depth reçu */				GIWIK._status_bits_info[20 + 32*2] = {'msg':461, 'status_on': 1, 'status_off':-1, 'group':{name:'depth',position:4}, 'action_on':-1, 'action_off':-1};
		/* Depth valide */				GIWIK._status_bits_info[21 + 32*2] = {'msg':462, 'status_on': 1, 'status_off':-1, 'group':{name:'depth',position:1}, 'action_on':-1, 'action_off':-1};
		/* Depth waiting */				GIWIK._status_bits_info[22 + 32*2] = {'msg':463, 'status_on': 2, 'status_off':-1, 'group':{name:'depth',position:2}, 'action_on':-1, 'action_off':-1};
		/* Depth rejeté */				GIWIK._status_bits_info[23 + 32*2] = {'msg':464, 'status_on': 3, 'status_off':-1, 'group':{name:'depth',position:3}, 'action_on':-1, 'action_off':-1};
		/* LBL reçu */					GIWIK._status_bits_info[24 + 32*2] = {'msg':471, 'status_on': 1, 'status_off':-1, 'group':{name:'lbl',position:4}, 'action_on':-1, 'action_off':-1};
		/* LBL valide */				GIWIK._status_bits_info[25 + 32*2] = {'msg':472, 'status_on': 1, 'status_off':-1, 'group':{name:'lbl',position:1}, 'action_on':-1, 'action_off':-1};
		/* LBL waiting */				GIWIK._status_bits_info[26 + 32*2] = {'msg':473, 'status_on': 2, 'status_off':-1, 'group':{name:'lbl',position:2}, 'action_on':-1, 'action_off':-1};
		/* LBL rejeté */				GIWIK._status_bits_info[27 + 32*2] = {'msg':474, 'status_on': 3, 'status_off':-1, 'group':{name:'lbl',position:3}, 'action_on':-1, 'action_off':-1};
		/* DVL WT reçu */				GIWIK._status_bits_info[ 0 + 32*3] = {'msg':481, 'status_on': 1, 'status_off':-1, 'group':{name:'dvl',position:9}, 'action_on':-1, 'action_off':-1};
		/* DVL WT valide */				GIWIK._status_bits_info[ 1 + 32*3] = {'msg':482, 'status_on': 1, 'status_off':-1, 'group':{name:'dvl',position:6}, 'action_on':-1, 'action_off':-1};
		/* DVL WT waiting */			GIWIK._status_bits_info[ 2 + 32*3] = {'msg':483, 'status_on': 2, 'status_off':-1, 'group':{name:'dvl',position:7}, 'action_on':-1, 'action_off':-1};
		/* DVL WT rejeté */				GIWIK._status_bits_info[ 3 + 32*3] = {'msg':484, 'status_on': 3, 'status_off':-1, 'group':{name:'dvl',position:8}, 'action_on':-1, 'action_off':-1};
		/* GPS2 reçu */					GIWIK._status_bits_info[ 4 + 32*3] = {'msg':521, 'status_on': 1, 'status_off':-1, 'group':{name:'gps2',position:4}, 'action_on':-1, 'action_off':-1};
		/* GPS2 valide */				GIWIK._status_bits_info[ 5 + 32*3] = {'msg':522, 'status_on': 1, 'status_off':-1, 'group':{name:'gps2',position:1}, 'action_on':-1, 'action_off':-1};
		/* GPS2 waiting */				GIWIK._status_bits_info[ 6 + 32*3] = {'msg':523, 'status_on': 2, 'status_off':-1, 'group':{name:'gps2',position:2}, 'action_on':-1, 'action_off':-1};
		/* GPS2 rejeté */				GIWIK._status_bits_info[ 7 + 32*3] = {'msg':524, 'status_on': 3, 'status_off':-1, 'group':{name:'gps2',position:3}, 'action_on':-1, 'action_off':-1};
		/* Emulation Mode */			GIWIK._status_bits_info[23 + 32*3] = {'msg':308, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on':-1, 'action_off':-1};
		/* EM Log reçu */				GIWIK._status_bits_info[24 + 32*3] = {'msg':491, 'status_on': 1, 'status_off':-1, 'group':{name:'logem',position:4}, 'action_on':-1, 'action_off':-1};
		/* EM Log valide */				GIWIK._status_bits_info[25 + 32*3] = {'msg':492, 'status_on': 1, 'status_off':-1, 'group':{name:'logem',position:1}, 'action_on':-1, 'action_off':-1};
		/* EM Log waiting */			GIWIK._status_bits_info[26 + 32*3] = {'msg':493, 'status_on': 2, 'status_off':-1, 'group':{name:'logem',position:2}, 'action_on':-1, 'action_off':-1};
		/* EM Log rejeté */				GIWIK._status_bits_info[27 + 32*3] = {'msg':494, 'status_on': 3, 'status_off':-1, 'group':{name:'logem',position:3}, 'action_on':-1, 'action_off':-1};
		/* GPS Manuel reçu */			GIWIK._status_bits_info[28 + 32*3] = {'msg':501, 'status_on': 1, 'status_off':-1, 'group':{name:'manualdata',position:4}, 'action_on':-1, 'action_off':-1};
		/* GPS Manuel valide */			GIWIK._status_bits_info[29 + 32*3] = {'msg':502, 'status_on': 1, 'status_off':-1, 'group':{name:'manualdata',position:1}, 'action_on':-1, 'action_off':-1};
		/* GPS Manuel waiting */		GIWIK._status_bits_info[30 + 32*3] = {'msg':503, 'status_on': 2, 'status_off':-1, 'group':{name:'manualdata',position:2}, 'action_on':-1, 'action_off':-1};
		/* GPS Manuel rejeté */			GIWIK._status_bits_info[31 + 32*3] = {'msg':504, 'status_on': 3, 'status_off':-1, 'group':{name:'manualdata',position:3}, 'action_on':-1, 'action_off':-1};
		if (in_array(GIWIK.system_type, [7,11]))
		{
		/* ZUPT Activé */				GIWIK._status_bits_info[16 + 32*3] = {'msg':390, 'status_on':-1, 'status_off':-1, 'group':{name:'zupt',position:12}, 'action_on':312, 'action_off':-1};
		/* ZUPT Valide */				GIWIK._status_bits_info[17 + 32*3] = {'msg':391, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:13}, 'action_on':312, 'action_off':-1};
		}
		else
		{
		/* ZUPT Activé */				GIWIK._status_bits_info[16 + 32*3] = {'msg':390, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:12}, 'action_on':312, 'action_off':-1};
		/* ZUPT Valide */				GIWIK._status_bits_info[17 + 32*3] = {'msg':391, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:13}, 'action_on':312, 'action_off':-1};
		}
		
		/* RO-ZUPT Activé */			GIWIK._status_bits_info[18 + 32*3] = {'msg':392, 'status_on': 1, 'status_off':-1,	 'group':{name:'zupt',position:12}, 'action_on':312, 'action_off':-1};
		/* RO-ZUPT Valide */			GIWIK._status_bits_info[19 + 32*3] = {'msg':393, 'status_on': 1, 'status_off':-1,	 'group':{name:'zupt',position:13}, 'action_on':312, 'action_off':-1};
		
		// Algo3
		/* logem2 recu */				GIWIK._status_bits_info[ 4 + 32*6] = {'msg':531, 'status_on': 1, 'status_off':-1, 'group':{name:'logem2',position:4}, 'action_on':-1, 'action_off':-1};
		/* logem2 valide */				GIWIK._status_bits_info[ 5 + 32*6] = {'msg':532, 'status_on': 1, 'status_off':-1, 'group':{name:'logem2',position:1}, 'action_on':-1, 'action_off':-1};
		/* logem2 waiting */			GIWIK._status_bits_info[ 6 + 32*6] = {'msg':533, 'status_on': 2, 'status_off':-1, 'group':{name:'logem2',position:2}, 'action_on':-1, 'action_off':-1};
		/* logem2 rejeté */				GIWIK._status_bits_info[ 7 + 32*6] = {'msg':534, 'status_on': 3, 'status_off':-1, 'group':{name:'logem2',position:3}, 'action_on':-1, 'action_off':-1};
		/* USBL2 recu */				GIWIK._status_bits_info[ 8 + 32*6] = {'msg':540, 'status_on': 1, 'status_off':-1, 'group':{name:'usbl2',position:0}, 'action_on':-1, 'action_off':-1};
		/* USBL2 valide */				GIWIK._status_bits_info[ 9 + 32*6] = {'msg':542, 'status_on': 1, 'status_off':-1, 'group':{name:'usbl2',position:1}, 'action_on':-1, 'action_off':-1};
		/* USBL2 waiting */				GIWIK._status_bits_info[10 + 32*6] = {'msg':543, 'status_on': 2, 'status_off':-1, 'group':{name:'usbl2',position:2}, 'action_on':-1, 'action_off':-1};
		/* USBL2 rejeté */				GIWIK._status_bits_info[11 + 32*6] = {'msg':544, 'status_on': 3, 'status_off':-1, 'group':{name:'usbl2',position:3}, 'action_on':-1, 'action_off':-1};
		/* USBL3 recu */				GIWIK._status_bits_info[12 + 32*6] = {'msg':550, 'status_on': 1, 'status_off':-1, 'group':{name:'usbl3',position:0}, 'action_on':-1, 'action_off':-1};
		/* USBL3 valide */				GIWIK._status_bits_info[13 + 32*6] = {'msg':552, 'status_on': 1, 'status_off':-1, 'group':{name:'usbl3',position:1}, 'action_on':-1, 'action_off':-1};
		/* USBL3 waiting */				GIWIK._status_bits_info[14 + 32*6] = {'msg':553, 'status_on': 2, 'status_off':-1, 'group':{name:'usbl3',position:2}, 'action_on':-1, 'action_off':-1};
		/* USBL3 rejeté */				GIWIK._status_bits_info[15 + 32*6] = {'msg':554, 'status_on': 3, 'status_off':-1, 'group':{name:'usbl3',position:3}, 'action_on':-1, 'action_off':-1};
		/* VITMAN  recue */				GIWIK._status_bits_info[16 + 32*6] = {'msg':555, 'status_on': 2, 'status_off':-1, 'group':{name:'manualdata',position:4}, 'action_on':-1, 'action_off':-1};
		/* Calibration check */		    GIWIK._status_bits_info[17 + 32*6] = {'msg':556, 'status_on': 2, 'status_off':-1, 'group':{name:'calibration',position:0}, 'action_on':-1, 'action_off':-1};
		/* Restore Attitude Failed */	GIWIK._status_bits_info[18 + 32*6] = {'msg':557, 'status_on': 3, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':204, 'action_off':-1};
		
		if(!GIWIK.is_mems)
		{
			/* REL_SP-ZUPT Activé */		GIWIK._status_bits_info[19 + 32*6] = {'msg':558, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:12}, 'action_on':312, 'action_off':-1};
			/* REL_SP-ZUPT Valide */		GIWIK._status_bits_info[20 + 32*6] = {'msg':559, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:13}, 'action_on':312, 'action_off':-1};
		}
		
		/* Ext_Sensor_Outdated */		GIWIK._status_bits_info[21 + 32*6] = {'msg':560, 'status_on': 3, 'status_off':-1, 'group':{name:'ext_others',position:0}, 'action_on':-1, 'action_off':-1};
		/* Sensor used before calib */  GIWIK._status_bits_info[22 + 32*6] = {'msg':561, 'status_on': 2, 'status_off':-1, 'group':{name:'calibration',position:0}, 'action_on':-1, 'action_off':-1};
		/* Restore Att. Rejected.*/		GIWIK._status_bits_info[23 + 32*6] = {'msg':562, 'status_on': 3, 'status_off':-1, 'group':{name:'navigation',position:0}, 'action_on':-1, 'action_off':-1};
		/* Undefined Sensors */ 		GIWIK._status_bits_info[28 + 32*6] = {'msg':358, 'status_on': 3, 'status_off': -1, 'group':{name:'system',position:0}, 'action_on': -1, 'action_off':-1};
		
		if( !GIWIK.is_advans && !(GIWIK.system_type == 6)){ // TO COMPLETE WITH IMO SYSTEM TYPES
			/* IMO alignment */ 		    GIWIK._status_bits_info[29 + 32*6] = {'msg':578, 'status_on': 2, 'status_off': 0, 'group':{name:'navigation',position:4}, 'action_on': 105, 'action_off':-1};
		}
		if( !GIWIK.is_mems ) {
			/* Optimal alignment */ 		GIWIK._status_bits_info[30 + 32*6] = {'msg':579, 'status_on': 2, 'status_off': 0, 'group':{name:'navigation',position:5}, 'action_on': 106, 'action_off':-1};		
		}
		if( GIWIK.is_marins ){
			/* Strategic alignment */ 		GIWIK._status_bits_info[31 + 32*6] = {'msg':592, 'status_on': 2, 'status_off': 0, 'group':{name:'navigation',position:6}, 'action_on': 107, 'action_off':-1};
		}
		
		// Algo 4
		/* DVL2 BT reçu */				GIWIK._status_bits_info[0 + 32*8] = {'msg':580, 'status_on': 1, 'status_off':-1, 'group':{name:'dvl2',position:4}, 'action_on':-1, 'action_off':-1};
		/* DVL2 BT valide */			GIWIK._status_bits_info[1 + 32*8] = {'msg':581, 'status_on': 1, 'status_off':-1, 'group':{name:'dvl2',position:1}, 'action_on':-1, 'action_off':-1};
		/* DVL2 BT waiting */			GIWIK._status_bits_info[2 + 32*8] = {'msg':582, 'status_on': 2, 'status_off':-1, 'group':{name:'dvl2',position:2}, 'action_on':-1, 'action_off':-1};
		/* DVL2 BT rejeté */			GIWIK._status_bits_info[3 + 32*8] = {'msg':583, 'status_on': 3, 'status_off':-1, 'group':{name:'dvl2',position:3}, 'action_on':-1, 'action_off':-1};
		/* DVL2 WT reçu */				GIWIK._status_bits_info[4 + 32*8] = {'msg':584, 'status_on': 1, 'status_off':-1, 'group':{name:'dvl2',position:9}, 'action_on':-1, 'action_off':-1};
		/* DVL2 WT valide */			GIWIK._status_bits_info[5 + 32*8] = {'msg':585, 'status_on': 1, 'status_off':-1, 'group':{name:'dvl2',position:6}, 'action_on':-1, 'action_off':-1};
		/* DVL2 WT waiting */			GIWIK._status_bits_info[6 + 32*8] = {'msg':586, 'status_on': 2, 'status_off':-1, 'group':{name:'dvl2',position:7}, 'action_on':-1, 'action_off':-1};
		/* DVL2 WT rejeté */			GIWIK._status_bits_info[7 + 32*8] = {'msg':587, 'status_on': 3, 'status_off':-1, 'group':{name:'dvl2',position:8}, 'action_on':-1, 'action_off':-1};	
		/* MAN ATT valide */			GIWIK._status_bits_info[14 + 32*8] = {'msg':631, 'status_on': 1, 'status_off':-1, 'group':{name:'manualdata',position:6}, 'action_on':-1, 'action_off':-1};
		/* MAN ATT waiting */			GIWIK._status_bits_info[15 + 32*8] = {'msg':632, 'status_on': 2, 'status_off':-1, 'group':{name:'manualdata',position:7}, 'action_on':-1, 'action_off':-1};
		/* MAN ATT rejeté */			GIWIK._status_bits_info[16 + 32*8] = {'msg':633, 'status_on': 3, 'status_off':-1, 'group':{name:'manualdata',position:8}, 'action_on':-1, 'action_off':-1};
		
		/* Fixed Heading */			GIWIK._status_bits_info[17 + 32*8] = {'msg':634, 'status_on': 1, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on':-1, 'action_off':-1};
		/* Degraded Mode */			GIWIK._status_bits_info[18 + 32*8] = {'msg':635, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on':-1, 'action_off':-1};		
		/* System saturation */			GIWIK._status_bits_info[27 + 32*8] = {'msg':636, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:0}, 'action_on': 206, 'action_off':-1};	
		/* Inconsistent data */		    	GIWIK._status_bits_info[31 + 32*8] = {'msg':593, 'status_on': 3, 'status_off':-1, 'group':{name:'ext_others',position:1}, 'action_on':-1, 'action_off':-1};
		/* VTG valide */			GIWIK._status_bits_info[20 + 32*8] = {'msg':621, 'status_on': 1, 'status_off':-1, 'group':{name:'gps',position:0}, 'action_on':-1, 'action_off':-1};
		/* VTG waiting */			GIWIK._status_bits_info[21 + 32*8] = {'msg':622, 'status_on': 2, 'status_off':-1, 'group':{name:'gps',position:1}, 'action_on':-1, 'action_off':-1};
		/* VTG rejeté */			GIWIK._status_bits_info[22 + 32*8] = {'msg':623, 'status_on': 3, 'status_off':-1, 'group':{name:'gps',position:2}, 'action_on':-1, 'action_off':-1};		
		/* VTG2 valide */			GIWIK._status_bits_info[24 + 32*8] = {'msg':625, 'status_on': 1, 'status_off':-1, 'group':{name:'gps2',position:0}, 'action_on':-1, 'action_off':-1};
		/* VTG2 waiting */			GIWIK._status_bits_info[25 + 32*8] = {'msg':626, 'status_on': 2, 'status_off':-1, 'group':{name:'gps2',position:1}, 'action_on':-1, 'action_off':-1};
		/* VTG2 rejeté */			GIWIK._status_bits_info[26 + 32*8] = {'msg':627, 'status_on': 3, 'status_off':-1, 'group':{name:'gps2',position:2}, 'action_on':-1, 'action_off':-1};
		
		if(GIWIK.is_advans)
		{
			/* CINT Memory Write Error */	GIWIK._status_bits_info[28 + 32*8] = {'msg':637, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:1}, 'action_on':-1, 'action_off':-1};	
			/* CINT Memory Erase Error */	GIWIK._status_bits_info[29 + 32*8] = {'msg':638, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:1}, 'action_on':-1, 'action_off':-1};	
		}
		
		// Algo 5
		if(GIWIK.is_advans) 
		{
			/* Mode None 					GIWIK._status_bits_info[0 + 32*9] = {'msg':594, 'status_on': 1, 'status_off':-1, 'group':{name:'navigationMode',position:0}, 'action_on':-1, 'action_off':-1};*/
			/* Mode travelling */			GIWIK._status_bits_info[1 + 32*9] = {'msg':595, 'status_on': 1, 'status_off':-1, 'group':{name:'navigationMode',position:0}, 'action_on':-1, 'action_off':-1};
			/* Mode Firing */				GIWIK._status_bits_info[2 + 32*9] = {'msg':596, 'status_on': 1, 'status_off':-1, 'group':{name:'navigationMode',position:0}, 'action_on':-1, 'action_off':-1};
			/* Mode Firing on move */		GIWIK._status_bits_info[3 + 32*9] = {'msg':597, 'status_on': 1, 'status_off':-1, 'group':{name:'navigationMode',position:0}, 'action_on':-1, 'action_off':-1};
			/* Mode Aero transportation */	GIWIK._status_bits_info[4 + 32*9] = {'msg':598, 'status_on': 1, 'status_off':-1, 'group':{name:'navigationMode',position:0}, 'action_on':-1, 'action_off':-1};
			//...
			/* Relative pointing active */	GIWIK._status_bits_info[24 + 32*9] = {'msg':639, 'status_on': 1, 'status_off':-1, 'group':{name:'system',position:1}, 'action_on':-1, 'action_off':-1};
			/* Relative pointing degraded*/	GIWIK._status_bits_info[25 + 32*9] = {'msg':640, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:2}, 'action_on':-1, 'action_off':-1};
			/* CDSP Memory Write Error */	GIWIK._status_bits_info[26 + 32*9] = {'msg':641, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:1}, 'action_on':-1, 'action_off':-1};
			/* CDSP Memory Erase Error */	GIWIK._status_bits_info[27 + 32*9] = {'msg':642, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:2}, 'action_on':-1, 'action_off':-1};
			/* CINT Memory Virgin */		GIWIK._status_bits_info[28 + 32*9] = {'msg':643, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:1}, 'action_on':-1, 'action_off':-1};
			/* CDSP Memory Virgin */		GIWIK._status_bits_info[29 + 32*9] = {'msg':644, 'status_on': 2, 'status_off':-1, 'group':{name:'system',position:2}, 'action_on':-1, 'action_off':-1};
			/* CINT Memory Error */			GIWIK._status_bits_info[30 + 32*9] = {'msg':645, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:1}, 'action_on':-1, 'action_off':-1};
			/* CDSP Memory Error */			GIWIK._status_bits_info[31 + 32*9] = {'msg':646, 'status_on': 3, 'status_off':-1, 'group':{name:'system',position:2}, 'action_on':-1, 'action_off':-1};
		}
		
		/* TR-ZUPT Activé */			GIWIK._status_bits_info[20 + 32*9] = {'msg':648, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:12}, 'action_on':312, 'action_off':-1};
		/* TR-ZUPT Valide */			GIWIK._status_bits_info[21 + 32*9] = {'msg':649, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:13}, 'action_on':312, 'action_off':-1};
		/* PO-ZUPT Activé */			GIWIK._status_bits_info[22 + 32*9] = {'msg':650, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:12}, 'action_on':312, 'action_off':-1};
		/* PO-ZUPT Valide */			GIWIK._status_bits_info[23 + 32*9] = {'msg':651, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:13}, 'action_on':312, 'action_off':-1};
		
		/* ZUPT static 10m/s activé */			GIWIK._status_bits_info[512] = {'msg':652, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:0}, 'action_on':-1, 'action_off':-1};
		/* ZUPT static 0.1m/s activé */			GIWIK._status_bits_info[513] = {'msg':653, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:1}, 'action_on':-1, 'action_off':-1};
		/* ZUPT autostatic activé */			GIWIK._status_bits_info[514] = {'msg':654, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:2}, 'action_on':-1, 'action_off':-1};
		/* ZUPT autostatic bench activé */		GIWIK._status_bits_info[515] = {'msg':655, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:3}, 'action_on':-1, 'action_off':-1};
		/* ZUPT ANC activé */					GIWIK._status_bits_info[516] = {'msg':656, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:4}, 'action_on':-1, 'action_off':-1};
		/* ZUPT position activé */				GIWIK._status_bits_info[517] = {'msg':657, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:5}, 'action_on':-1, 'action_off':-1};
		/* ZUPT autostatic position activé */	GIWIK._status_bits_info[518] = {'msg':658, 'status_on': 1, 'status_off':-1, 'group':{name:'zupt',position:6}, 'action_on':-1, 'action_off':-1};

		/* ZUPT Activé & Valide */		GIWIK._status_bits_info[519] = {'msg':590, 'status_on': 1, 'status_off':-1,'group':{name:'zupt',position:7}, 'action_on':-1, 'action_off':-1};
		/* RO-ZUPT Activé & Valide */	GIWIK._status_bits_info[520] = {'msg':591, 'status_on': 1, 'status_off':-1,'group':{name:'zupt',position:8}, 'action_on':-1, 'action_off':-1};
		/* TR-ZUPT Activé & Valide */	GIWIK._status_bits_info[521] = {'msg':659, 'status_on': 1, 'status_off':-1,'group':{name:'zupt',position:9}, 'action_on':-1, 'action_off':-1};
		/* PO-ZUPT Activé & Valide */	GIWIK._status_bits_info[522] = {'msg':660, 'status_on': 1, 'status_off':-1,'group':{name:'zupt',position:10}, 'action_on':-1, 'action_off':-1};
		/* REL-ZUPT Activé & Valide */	GIWIK._status_bits_info[523] = {'msg':661, 'status_on': 1, 'status_off':-1,'group':{name:'zupt',position:11}, 'action_on':-1, 'action_off':-1};
	}
	//--------STATUS SENSEUR COMMUNS ----------------
	/* FOG X error */				GIWIK._status_bits_info[ 0 + 32*1] = {'msg':350, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:0}, 'action_on': 3, 'action_off':-1};
	/* FOG Y error */				GIWIK._status_bits_info[ 1 + 32*1] = {'msg':351, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:1}, 'action_on': 3, 'action_off':-1};
	/* FOG Z error */				GIWIK._status_bits_info[ 2 + 32*1] = {'msg':352, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:2}, 'action_on': 3, 'action_off':-1};
	/* Source error */				GIWIK._status_bits_info[ 3 + 32*1] = {'msg':353, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:3}, 'action_on': 3, 'action_off':-1};
	/* Acc X Error */				GIWIK._status_bits_info[ 4 + 32*1] = {'msg':354, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:4}, 'action_on': 3, 'action_off':-1};
	/* Acc Y error */				GIWIK._status_bits_info[ 5 + 32*1] = {'msg':355, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:5}, 'action_on': 3, 'action_off':-1};
	/* Acc Z error */				GIWIK._status_bits_info[ 6 + 32*1] = {'msg':356, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:6}, 'action_on': 3, 'action_off':-1};
	/* Temperature error */			GIWIK._status_bits_info[ 7 + 32*1] = {'msg':357, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:7}, 'action_on': 3, 'action_off':-1};
	/* DSP Overload */				GIWIK._status_bits_info[ 8 + 32*1] = {'msg':303, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:8}, 'action_on': 3, 'action_off':-1};
	/* Degraded Mode */				GIWIK._status_bits_info[30 + 32*1] = {'msg':309, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:9}, 'action_on': 3, 'action_off':-1};
	/* Failure Mode */				GIWIK._status_bits_info[31 + 32*1] = {'msg':310, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:10},'action_on': 3, 'action_off':-1};
	/* Models Version issue */		GIWIK._status_bits_info[12 + 32*1] = {'msg':359, 'status_on': 3, 'status_off':-1, 'group':{name:'sensors',position:11},'action_on': 3, 'action_off':-1};	
}