// PLUGIN EXPERTVIEW

GIWIK.init.js(['css','msg'], 'expertview');


HEADING.is_external_popup = true;


// Gestion dynamique de l'affichage des capteurs externes via SYSTEM.ExtSToSerial (Système standard, utilise SYSTEM._ext_sensors et pas SYSTEM._external_sensors)
HEADING.readConf._plugins.expertview = function ()
{	
	if (!window[system].ExtSToSerial)
	{
		return;
	}

	if (!HEADING.init.isdone)
	{
		var exts_input,tab,unit,col_with_min_height;

		// Nombre de colonnes
		if (!HEADING.num_cols) {HEADING.num_cols = 3;}

		// hauteur de chaque colonne (nombre de lignes pour chaque colonne)
		HEADING._cols_height = [];
		for (var i=1; i<=HEADING.num_cols; i++)
		{
			HEADING._cols_height[i] = 0;
			$('#col_'+i+' tr').each(function(j){
				if (this.style.display != 'none')
				{
					HEADING._cols_height[i]++;
				}
			});
		}
		//print_r(HEADING._cols_height);

		// Construction du tableau des capteurs externes qui va être lu par le foreach (tri décroissant du nombre de données pour un positionnement élégant à l'écran)
		var _ext_sensors_sorted_by_num_data = [];
		var _ext_sensors_added = [];
		
		for (var ext_s in GIWIK._ext_sensors){
			_ext_sensors_sorted_by_num_data[ext_s] = count(GIWIK._ext_sensors[ext_s]);
		}
		_ext_sensors_sorted_by_num_data = arsort(_ext_sensors_sorted_by_num_data);

		
		// Construction des blocs de données des capteurs externes
		// Step 1: Placement des groupes forcés via  GIWIK._ext_sensors_expertview_col
		// Step 2: Placement libre en fonction de la place restante au sein des colonnes 
		for (var step=1; step<=2; step++)
		{
			// No Sensor with forced position: Go to step 2
			if( step==1 && !GIWIK._ext_sensors_expertview_col ){
				continue;
			}
			
			// Sensors list depends on Step
			var ext_list = (step==1) ? GIWIK._ext_sensors_expertview_col : _ext_sensors_sorted_by_num_data;
			
			for (var ext_s in ext_list)
			{
				exts_input = window[system].ExtSToSerial[array_search(ext_s, GIWIK._extsensors_fulllist)];

				// Si le capteur externe est associé à un port et qu'il ne s'agit pas du cas particulier de l'UTC ou de l'UTC2 (qui ne sont pas affichés en tant que module)
				if (exts_input != 0 && !in_array(ext_s, ['utc','utc2']))
				{
					// Gestion des positions forcées en step 1
					if (step===1)
					{
						col_with_min_height = GIWIK._ext_sensors_expertview_col[ext_s];						
						
						// Ajout à la liste des capteurs ajoutés
						_ext_sensors_added.push(ext_s);					
										
					}
					// Gestion des positions libres
					else
					{
						// Capteur ajouté en step 1: on passe au suivant
						if( array_search(ext_s,_ext_sensors_added) )
							continue;
						
						// Récupération de la colonne la moins remplie
						col_with_min_height = array_search(min(HEADING._cols_height), HEADING._cols_height);					
					}			


					//nb_fields = 1;  // Nombre de lignes pour le groupe de données
					tab = ''

					+'<table class="expertview" id="'+ext_s+'_ctnr"'+'>\n'
						+'<tr>\n'
							+'<td colspan="2" class="col_s'+((col_with_min_height == HEADING.num_cols) ? '_last' : '')+'"><div id="'+ext_s+'_title" class="data_separator">'+MSG(['box',ext_s+'_title'])+'</div></td>\n'
						+'</tr>\n';

						for (var field in GIWIK._ext_sensors[ext_s])
						{
							tab += '<tr id="'+ext_s+'_'+field+'_info">\n'
								+'<td class="col_n"><div class="n"><span id="'+ext_s+'_'+field+'_label">'+MSG(['data',field],{'default':""})+'</span></div></td>\n'
								+'<td class="col_v"><div class="v"><div id="'+ext_s+'_'+field+'_data"><span id="'+ext_s+'_'+field+'"></span></div></div></td>\n'
							+'</tr>\n';
						}
					tab += '</table>\n';

					GIWIK.write('col_'+col_with_min_height,tab,'append');


					for (var i=1; i<=HEADING.num_cols; i++)
					{
						HEADING._cols_height[i] = 0;

						$('#col_'+i+' tr').each(
							function (j)
							{
								if (this.style.display != 'none')
								{
									HEADING._cols_height[i]++;
								}
							}
						);
					}
					//print_r(HEADING._cols_height);
				}
			}
		}

		// redimensionnement dynamique de la page en fonction du nombre maximal de lignes (hauteur max : 730px)
		GIWIK.window.resize();
	}
};

HEADING.readData._plugins.expertview = function ()
{
	if (window[system].ExtSToSerial)
	{
		var _new_extstoserial = '['+window[system].ExtSToSerial.join(',')+']';

		if (!HEADING._extstoserial)
		{
			HEADING._extstoserial = _new_extstoserial;
		}
		else
		{
			// Si au moins une association a changé, on reconstruit la page pour prendre ça en compte (affichage/masquage de capteurs)
			if (_new_extstoserial != HEADING._extstoserial)
			{
				HEADING._extstoserial = _new_extstoserial;

				window.location.reload(); return;
			}
		}
	}

	var sensor_state,
	    sensor_activated,
	    data_name,
	    data_value,
	    data_type
	    i;
	
	for (var ext_s in GIWIK._ext_sensors)
	{
		if (!window[system]._ext_sensors[ext_s])
		{
			continue;
		}

		sensor_activated = window[system]._ext_sensors[ext_s][0];

		if (typeof sensor_activated == 'boolean')
		{
			i=0;

			for (var data in GIWIK._ext_sensors[ext_s])
			{
				data_name = ext_s+'_'+data;
				data_type = GIWIK._ext_sensors[ext_s][data];

				if (sensor_activated === true)
				{
					data_value = window[system]._ext_sensors[ext_s][i+1]; // décalage d'1 index avec le booleen d'activité en index 0

					if (typeof data_value == 'undefined' || data_value==="N/A" )
					{
						data_value = "- - -";
						sensor_state = 0;
					}
					else
					{
						sensor_state = 1;
					}
				}
				else
				{
					data_value = "- - -";
					sensor_state = 0;
				}

				// Si le champ existe (cad qu'on n'est pas dans le cas où un capteur vient d'être coché sur la page inputs et que la page n'a pas encore été rafraîchie (--> champs pas encore construits)
				if (document.getElementById(data_name))
				{
					// console.log(data_name+', '+data_value);

					// Pas de processing quand la valeur vaut "- - -" pour éviter que la précision (calculée au 1er appel de GIWIK.data.process soit erronée)
					GIWIK.write(data_name, GIWIK.data.process(data_name, data_value, data_type));

					GIWIK.data.setStatus(sensor_state, data_name);
				}
				i++;
			}
		}
		sensor_state = null;
		sensor_activated = null;
		data_name = null;
		data_value = null;
		data_type = null;
	}
	// print_r (GIWIK.data.info);
};
