// PLUGIN INPUT_OUTPUT

GIWIK.init.js('msg', 'input_output')


// Spécifique IPD    // !!! à rendre compatible avec les produits APD
if (GIWIK.ihm_division == 'ipd')
{
	// Retourne les paramètres à récupérer en getConf de tous les ports I/O (la conf ethernet complète est nécessaire au test de validité "checkEthConf")
	HEADING.getIOConfParams = function ()
	{
		var _params = {},
			port;

		for (var i in GIWIK._input_ports)
		{
			port = GIWIK._input_ports[i];

			if ( !in_array(port,['X','R','CAN']) )
			{
				_params['PortConf'+port] = "";

				// Si le port gère l'ethernet
				if(in_array(2, GIWIK._input_ports_link[i]))
				{
					_params['EthConfI'+port] = "";
				}
			}
		}

		for (var i in GIWIK._output_ports)
		{
			port = GIWIK._output_ports[i];

			// Si le port gère l'ethernet
			if(in_array(2, GIWIK._output_ports_link[i]))
			{
				_params['EthConf'+port] = "";
			}
		}

		return _params;
	};

	// Retourne la configuration des ports configurés en ethernet
	HEADING.getEthConfIO = function ()
	{
		var _io_conf = {input:{}, output:{}},
			port, i, _ethconf, is_eth,
			way = HEADING.name.match(/inputs?$/i) ? 'input' : 'output';

		for (i in GIWIK._input_ports)
		{
			port = GIWIK._input_ports[i];


			// Si le port gère l'ethernet
			if (!in_array(port,['X','R','CAN']) && in_array(2, GIWIK._input_ports_link[i]))
			{
				// Configuration ethernet du port d'entrée
				_ethconf = window[system]['EthConfI'+port];

				// Le port est-il configuré en ethernet ?
				is_eth = in_array(_ethconf[0],[2,3]);

				// Si c'est le cas
				if (is_eth)
				{
					_io_conf.input[port] =
					{
						tlayer : _ethconf[1],
						ip     : _ethconf[2],
						port   : _ethconf[3]
					};
				}
			}
		}

		for (i in GIWIK._output_ports)
		{
			port = GIWIK._output_ports[i];

			// Si le port gère l'ethernet
			if (!in_array(port,['X','R','CAN']) && in_array(2, GIWIK._output_ports_link[i]))
			{
				// Configuration ethernet du port de sortie
				_ethconf = window[system]['EthConf'+port];

				// Le port est-il configuré en ethernet ?
				is_eth = in_array(_ethconf[0],[2,3]);

				// Si c'est le cas
				if (is_eth)
				{
					_io_conf.output[port] =
					{
						tlayer : _ethconf[1],
						ip     : _ethconf[2],
						port   : _ethconf[3]
					};
				}
			}
		}

		return _io_conf;
	};

	/*
		Vérification de la validité de la configuration ethernet en fonction de la configuration des autres ports I/O configurés en ethernet

						|     TCP client     |     TCP serveur    |     UDP entrée     |     UDP sortie
		----------------------------------------------------------------------------------------------------
		   TCP client	|         OK         |         OK         |         OK         | adresse ou port !=
		----------------------------------------------------------------------------------------------------
	 	   TCP server	|         OK         |       port !=      |       port !=      |         OK
	 	----------------------------------------------------------------------------------------------------
		   UDP entrée	|         OK         |       port !=      |       port !=      |         OK
		----------------------------------------------------------------------------------------------------
		   UDP sortie	| adresse ou port != |         OK         |         OK         |         OK
		----------------------------------------------------------------------------------------------------

		Arguments :
			curport : (string) lettre du port à tester
			curport_way : (string) input|output groupe du port à tester
			_curport : (object) {tlayer:(int), ip:(string), port:(int)} configuration du port à tester
			usermsg_objname : (string) nom de l'objet à utiliser pour afficher les messages utilisateur)

		Des exceptions spécifiques au produit peuvent être définies via le tableau GIWIK._plugins.input_output.eth_conflicts dans app.js
		Chaque exception est de la forme :
		{
			io    : 'input', 				// (optional) "input"|"output" : validité de l'exception en entrée ou sortie. (default: valable pour les 2)
			ip    : '192.168.1.2',			// (optional) adresse IP à tester
			port  : 8110,					// (optional) port à tester
			tlayer: 0, 						// (optional) couche de transport 0:"TCP Server", 1:"TCP Client", 2:"UDP", 3:"UDP Broadcast", 4:"UDP Multicast",
			info: {
				msg : MSG(['box','my_msg'),	// (optional) message utilisateur à afficher en cas de vérification de l'exception
				io_port: 'A'				// (optional) port IO concerné par cette exception (nécessaire si pas de message passé ci-dessus)
			}
		}
	*/
	HEADING.checkEthConf = function (curport, curport_way, _curport, usermsg_objname)
	{
		// Si la configuration du port n'est pas passée
		if (!_curport) {return true;}

			// Port courant (CurrentPort) ----------------------------------------------------------------------------------------------------------------
		var	curport            = (typeof curport !== 'undefined') ? curport : 0,
			curport_way        = in_array(curport_way,['input','output']) ? curport_way : (HEADING.name.match(/inputs?$/i) ? 'input' : 'output'),
			curport_udp        = in_array(_curport['tlayer'],[2,3,4],true), // ELCFI/OXList = ["TCP Server", "TCP Client", "UDP", "UDP Broadcast", "UDP Multicast"]
			curport_udp_input  = (curport_udp && curport_way === 'input'),
			curport_udp_output = (curport_udp && curport_way === 'output'),
			curport_tcp_server = _curport['tlayer'] === 0,
			curport_tcp_client = _curport['tlayer'] === 1,
			//--------------------------------------------------------------------------------------------------------------------------------------------
			_eth_conf_io = HEADING.getEthConfIO(),
			_port, port_udp, port_udp_input, port_udp_output, port_tcp_server, port_tcp_client,
			w,p,_io,_c, i, j, _conflicts = [],	conflict, conflict_type,
			_custom_conflicts = GIWIK._plugins.input_output.eth_conflicts || [],
			custom_conflict;

		// Gestion des conflits spécifiques produit ----------------------------------------------------------------------------------------------------
		for (i in _custom_conflicts)
		{
			custom_conflict = _custom_conflicts[i];
			custom_conflict.info = custom_conflict.info || {};
			j = null;

			if (in_array(custom_conflict.io, ['input',undefined], true))
			{
				j = custom_conflict.info.io_port ? custom_conflict.info.io_port : i;
				_eth_conf_io.input[j] = custom_conflict;
			}

			if (in_array(custom_conflict.io, ['output',undefined], true))
			{
				j = custom_conflict.info.io_port ? custom_conflict.info.io_port : i;
				_eth_conf_io.output[j] = custom_conflict;
			}
		}
		GIWIK.debug(_eth_conf_io);
		// -----------------------------------------------------------------------------------------------------------------------------------------------

		for (port_way in _eth_conf_io)
		{
			if (conflict) {break;}

			// config ethernet in ou out
			_io = _eth_conf_io[port_way];

			for (port in _io)
			{
				if (port_way === curport_way && port === curport) {continue;}

				// config ethernet du port à comparer
				_port           = _io[port];
				port_udp        = in_array(_port['tlayer'],[2,3,4],true);  // ELCFI/OXList = ["TCP Server", "TCP Client", "UDP", "UDP Broadcast", "UDP Multicast"]
				port_udp_input  = (port_udp && port_way === 'input');
				port_udp_output = (port_udp && port_way === 'output');
				port_tcp_server = _port['tlayer'] === 0;
				port_tcp_client = _port['tlayer'] === 1;

				if (((curport_tcp_client && port_udp_output) || (curport_udp_output && port_tcp_client))
						&& (_curport['ip'] === _port['ip'] && _curport['port'] === _port['port']))
				{
					conflict_type = 'ip_port';
				}
				else if (((curport_tcp_server || curport_udp_input) && (port_tcp_server || port_udp_input))
						&& (_curport['port'] === _port['port']))
				{
					conflict_type = 'port';
				}

				if (conflict_type)
				{
					conflict = (_port.info && _port.info.msg)
						? _port.info.msg
						: MSG(['box','usermsg_io_ethernet_conflict_'+port_way+'_'+conflict_type]).replace(/%port%/g, port);
					break;
				}
			}
		}

		if (conflict)
		{
			window[usermsg_objname].setStatus(3);
			window[usermsg_objname].setValue(conflict);
			window[usermsg_objname].show();

			return false;
		}
		else
		{
			return true;
		}
	};
}

// Trie les index des protocoles en fonction du tri alphabétique de leur noms ("first_value_is_none = true" permet de conserver un paramètre "None" en position 0)
GIWIK.sort_protocol_labels_and_indexes = function (_num, _list, first_value_is_none)
{
	var _list_without_none = (first_value_is_none) ? _list.slice(1, count(_list)) : array_copy(_list);

	// Construction de la chaine contenant l'éventuel label "None"
	var none_list = (first_value_is_none) ? "'"+_list[0]+"'," : "";

	// Tri du tableau des labels (l'éventuelle label "None" reste en position 0)
	var _list_sorted = eval("["+none_list+"'"+array_copy(_list_without_none).sort().join("','")+"']");
	var _num_sorted  = new Array();

	for (var i in _list_sorted)
	{
		_num_sorted.push(_num[array_search(_list_sorted[i], _list, true)]);
	}

	return  {_num : _num_sorted, _list : _list_sorted};
};

HEADING.showHideIP = function ()
{
	// Si TCP Client ou UDP (pas broadcast), ou UDP multicast on affiche l'IP
	if (in_array(window['Select_ELCF'+((HEADING.name == 'installation_inputs') ? 'I' : 'O')+'X'].getValue(), [1,2,4]))
	{
		$('#ip_ctnr').slideDown(200);
	}
	else
	{
		$('#ip_ctnr').slideUp(200);
	}
};

// Affiche/masque les groupes de paramètres serial & ethernet en fonction du choix "physical link"
HEADING.displaySerialNetworkParams = function (option_value)
{
	var option_value = parseFloat(option_value);

	switch (option_value)
	{
		// serial
		case 1:
			GIWIK.paramGroup.display('params_ethernet', 'displaynone', function () {
				GIWIK.paramGroup.display('params_serial', 'show');
			});
			break;

		// ethernet
		case 2:
			GIWIK.paramGroup.display('params_serial', 'displaynone', function () {
				GIWIK.paramGroup.display('params_ethernet', 'show');
			});
			break;

		// serial + ethernet (INS only)
		case 3:
			GIWIK.paramGroup.display('params_serial', 'show', function () {
				GIWIK.paramGroup.display('params_ethernet', 'show');
			});
			break;

		// none ou undefined
		default:
			GIWIK.paramGroup.display('params_serial', 'displaynone', function () {
				GIWIK.paramGroup.display('params_ethernet', 'displaynone');
			});
			break;
	}
};

switch (HEADING.name)
{
	case 'installation_inputs':
		break;

	case 'installation_outputs':
		// Spécifique APD
		HEADING.showHideFrequency = function ()
		{
			// Si le tableau définissant l'affichage du paramètre de fréquence en fonction du protocole existe
			if (typeof window[system].OProFrequency == 'object')
			{
				// S'il doit être affiché
				if (window[system].OProFrequency[window.Select_OPro.getValue()] || window.Select_OPro.getValue().toString().match(/^INS/))
				{
					window.Select_OProRate.show();
				}
				// Sinon
				else
				{
					window.Select_OProRate.hide();
				}
			}
		};
		break;
}
