GIWIK.init.js(['css','msg'], 'maintenance');

HEADING.readConf._plugins.maintenance = function (option)
{
	if (GIWIK._plugins.maintenance._soft_versions)
	{
		var serial_number = (typeof window[system].SerialNumber != 'undefined') ? window[system].SerialNumber : "";

		// Spécifique SSD : les valeurs sont isolées dans une propriété "val"
		if (typeof version != 'undefined' && typeof serial_number.val != 'undefined')
		{
			serial_number = serial_number.val;
		}

		if (serial_number !== "")
		{
			GIWIK.write('SerialNumber', serial_number);
		}
		else
		{
			$('#SerialNumber,#SerialNumber_label').css('display','none');
		}

		GIWIK.write('IHMVers', GIWIK._systems[GIWIK.system_type].maintenance()+' <span style="color:'+GIWIK.css.color_0+'">/</span> '+GIWIK.full_ihm_version);

		var version;
		for (var i in GIWIK._plugins.maintenance._soft_versions)
		{
			version = window[system][GIWIK._plugins.maintenance._soft_versions[i]];
			version = version.replace(".a","");
			version = version.replace(".tar.gz","");

			// Spécifique SSD : les valeurs sont isolées dans une propriété "val"
			if (typeof version != 'undefined' && typeof version.val != 'undefined')
			{
				version = version.val;
			}

			GIWIK.write(GIWIK._plugins.maintenance._soft_versions[i], version);
		}
	}

	// Gestion de la license du soft
	if (GIWIK._plugins.maintenance.license_activation)
	{
		if (window[system].LicenseState == "0")
		{
			window.LicenseState.setValue(MSG(['box','licensemissing_label']));
		}
		else
		{
			window.LicenseState.setValue(MSG(['box','licenseok_label']));
		}
		window.LicenseID.setValue(window[system].LicenseID);
		window.LicenseCode.enable();
		window.LicenseActivation.enable();
	}

	if (GIWIK._plugins.maintenance.statistics)
	{
		var time_val = 0;
		var msg = "";

		// Time since Manufacturing in hours
		// ---------------------------------------------
		time_val = (window[system].Statistics) ? window[system].Statistics[0] : 0;

		msg += time_val;
		msg += "&nbsp"+MSG(['units',(time_val>1) ? 'hours_long' : 'hour_long']);

		GIWIK.write('TimeSinceManufacturing', msg );

		// Errors List
		// --------------
		HEADING.errorsViewerParse();
	}

	if (GIWIK._plugins.maintenance.support)
	{
		// Récupération du numéro de série
		var serial_number = (typeof window[system].SerialNumber != 'undefined') ? window[system].SerialNumber : "unknown";

		// Spécifique SSD : les valeurs sont isolées dans une propriété "val"
		if (typeof serial_number.val != 'undefined')
		{
			serial_number = serial_number.val;
		}

		// Récupération du contenu de l'email (pas dans le !HEADING.init.isdone parce que Display() a été appelé lors du construct() (et a donc passé HEADING.init.isdone à true), pour garder la page accessible même en cas de plantage firmware
		var email_subject = encodeURIComponent(MSG(['contact_support','email_subject']));
		var email_content = encodeURIComponent(MSG(['contact_support','email_content']));

		var d = new Date();
		var subject_date = '';
		subject_date += d.getFullYear();
		if (d.getMonth()+1<10) {subject_date += '0';}
		subject_date += d.getMonth()+1+''+d.getDate()+''+d.getHours()+''+d.getMinutes()+''+d.getSeconds();

		email_subject += " "+serial_number+"/"+subject_date;

		email_content = email_content.replace(/%(25)?system_name%(25)?/gi, GIWIK._systems[GIWIK.system_type].maintenance().replace(/_+/gi, " "));
		email_content = email_content.replace(/%(25)?serial_number%(25)?/gi, serial_number);
		window.Btn_support.setAction('window.location.href="mailto:support@ixblue.com?subject='+email_subject+'&body='+email_content+'"');
		window.Btn_support.enable();
	}

	if (GIWIK._plugins.maintenance._soft_versions)
	{
		// Si gestion des versions logicielles sans fonction de mise à jour
		if (!GIWIK._plugins.maintenance.soft_update)
		{
			$("#software_versions")[(!HEADING.init.isdone) ? 'show' : 'slideDown']();
		}
	}
};

HEADING.sendConf._plugins.maintenance = function (action)
{
	var _params = {};

	switch (action)
	{
		case 'license_activation': _params['LicenseCode'] = window.LicenseCode.getValue();  break;
	}

	return _params;
};

HEADING.getConf._plugins.maintenance = function ()
{
	var _params = {};

	if (GIWIK._plugins.maintenance.serial_number !== false)
	{
		_params['SerialNumber'] = "";
	}

	if (GIWIK._plugins.maintenance._soft_versions)
	{
		for (var i in GIWIK._plugins.maintenance._soft_versions)
		{
			_params[GIWIK._plugins.maintenance._soft_versions[i]] = "";
		}
	}

	if (GIWIK._plugins.maintenance.license_activation)
	{
		_params['LicenseID'] = "";
		_params['LicenseState'] = "";
	}

	if (GIWIK._plugins.maintenance.statistics)
	{
		_params['Statistics'] = "";
		_params['ErrorsLog'] = "";
	}

	return _params;
};

// Construction du contenu de la rubrique
HEADING.construct._plugins.maintenance = function ()
{
	// Si pas définie, valeur par défaut de serial_number
	if (typeof GIWIK._plugins.maintenance.serial_number != 'boolean')
	{
		GIWIK._plugins.maintenance.serial_number = true;
	}

	var cnt = '';

	if (GIWIK._plugins.maintenance.restart_system)
	{
		cnt = ''
		+'<div id="restart_intro" class="box_leftintro"></div>'
		+'<div id="restart"></div>';

		$('#content').append(GIWIK.box(cnt, '', false, ['box_restart'], ['', 'box_content_nopadding']));
	}

	if (GIWIK._plugins.maintenance._soft_versions)
	{
		cnt = ''

		+'<div id="usermsg_updatemode"></div>'

		+'<div id="usermsg_update" class="displaynone"></div>'

		+'<div id="firmware_intro" class="displaynone"></div>'

		+'<div id="software_versions" class="displaynone">'

			+'<table id="software_versions_list" >'
					+'<tr>'
						+'<td><span id="SerialNumber_label" class="state_1 bold"></span></td>'
						+'<td><span id="SerialNumber"></span></td>'
					+'</tr>'
					+'<tr>'
						+'<td><span id="IHMVers_label" class="state_1 bold"></span></td>'
						+'<td><span id="IHMVers"></span></td>'
					+'</tr>';
					for (var i in GIWIK._plugins.maintenance._soft_versions)
					{
							cnt += '<tr>'
							+'<td><span id="'+GIWIK._plugins.maintenance._soft_versions[i]+'_label" class="state_1 bold"></span></td>'
							+'<td><span id="'+GIWIK._plugins.maintenance._soft_versions[i]+'"></span></td>'
						+'</tr>';
					}

					if (typeof(GIWIK._plugins.maintenance._soft_versions['KernelVers']) != 'undefined')
					{
						cnt += '<tr>'
							+'<td><span id="KernelVers_label" class="state_1 bold"></span></td>'
							+'<td><span id="KernelVers"></span></td>'
						+'</tr>';
					}
					cnt += '<tr>'
					+'<td><div id="firmware_last_updated_label_ctnr" class="displaynone"><span id="firmware_last_updated_label" class="state_1 bold"></span></div></td>'
					+'<td><div id="firmware_last_updated_ctnr" class="displaynone"><span id="firmware_last_updated"></span></div></td>'
					+'</tr>'

			+'</table>'

		+'</div>';

		if (GIWIK._plugins.maintenance.soft_update)
		{
			cnt += '<div id="firmware_ctnr">'

				+'<table id="tabfirmware">'
					+'<tr>'
						+'<td id="file_update_ctnr" class="tdleft">'
							+'<table>'
								+'<tr><td><div id="fileupdate_intro"></div></td></tr>'
								+'<tr><td><div id="file_update"></div></td></tr>'
							+'</table>'
						+'</td>'
						+'<td class="tdright">'
							+'<div id="updatesoft"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>';
		}

		$('#content').append(GIWIK.box(cnt, '', false, ['box_firmware'], ['', 'box_content_nopadding']));
	}

	// Gestion de la license du soft
	if (GIWIK._plugins.maintenance.license_activation)
	{
		cnt = ''
		+'<table><tr><td>'
		+'<div id="license_intro" class="box_leftintro"></div>'
		+'<div id="license_state" class="box_leftintro"></div>'
		+'<div id="license_id" class="box_leftintro"></div>'
		+'<div id="license_code" class="box_leftintro"></div>'
		+'</td><td valign="bottom">'
		+'<div id="license_activation"></div></td></tr>'
		+'</td></tr></table>';

		$('#content').append(GIWIK.box(cnt, '', false, ['box_license'], ['', 'box_content_nopadding']));

		$('#license_state,#license_id,#license_code').css('padding-top','0');
	}

	if (GIWIK._plugins.maintenance.reset_to_factory)
	{
		cnt = ''
		+'<div id="usermsg_resettofactory"></div>'
		+'<div id="resettofactory_intro" class="box_leftintro"></div>'
		+'<div id="resettofactory"></div>';

		$('#content').append(GIWIK.box(cnt, '', false, ['box_resettofactory'], ['', 'box_content_nopadding']));
	}

	if (GIWIK._plugins.maintenance.support)
	{
		cnt = ''
		+'<div id="createticket_ctnr">'
			+'<div id="box_support_intro" class="box_leftintro"></div>'
			+'<div id="box_support_button"></div>'
		+'</div>';

		if (GIWIK._plugins.maintenance.statistics)
		{
			cnt += '<div id="params_statistics">'
				+'<table id="statistics_ctnr">'
					+'<tr>'
						+'<td class="state_1 bold"><div id="statistics_time_since_manufacturing_label"></div></td>'
						+'<td class="state_1 bold"><div id="TimeSinceManufacturing"></td>'
					+'</tr>'
				+'</table>'
				+'<div id="statistics_errors_label" class="state_1 bold"></div>'
				+'<div id="errorsviewer_data"></div>'
			+'</div>';
		}

		$('#content').append(GIWIK.box(cnt, '', false, ['box_support'], ['', 'box_content_nopadding']));
	}


	// Coloration du label du menu
	$('#maintenance').css('color',GIWIK.css.color_top_menui);

	$('#content').css('margin-bottom','50px');


	// Gestion de la license du soft
	if (GIWIK._plugins.maintenance.license_activation)
	{
		GIWIK.write('box_license_title', MSG(['box','license_title']));
		GIWIK.write('license_intro', MSG(['box','license_intro']));

		window.LicenseState = new Input_text('LicenseState', true);
		window.LicenseState.margin = '15px 0 0 0';
		window.LicenseState.label_width = (GIWIK.lang == 'fr') ? 105 : 95;
		window.LicenseState.input_width = 180;
		window.LicenseState.readonly = true;
		window.LicenseState.text_align = 'left';
		window.LicenseState.construct('license_state','linear',MSG(['box','licensestate_label']),'',false);
		window.LicenseState.enable();
		window.LicenseState.show();

		window.LicenseID = new Input_text('LicenseID', true);
		window.LicenseID.margin = '5px 0 0 0';
		window.LicenseID.label_width = (GIWIK.lang == 'fr') ? 105 : 95;
		window.LicenseID.input_width = 180;
		window.LicenseID.readonly = true;
		window.LicenseID.text_align = 'left';
		window.LicenseID.construct('license_id','linear',MSG(['box','licenseid_label']),'',false);
		window.LicenseID.enable();
		window.LicenseID.show();

		window.LicenseCode = new Input_text('LicenseCode', true);
		window.LicenseCode.margin = '5px 0 10px 0';
		window.LicenseCode.label_width = (GIWIK.lang == 'fr') ? 105 : 95;
		window.LicenseCode.input_width = 180;
		window.LicenseCode.text_align = 'left';
		window.LicenseCode.construct('license_code','linear',MSG(['box','licensecode_label']),'',false);
		window.LicenseCode.disable();
		window.LicenseCode.show();

		window.LicenseActivation = new Button('LicenseActivation', true);
		window.LicenseActivation.construct('license_activation',MSG(['buttons','license_activation']));
		window.LicenseActivation.disable();
		window.LicenseActivation.setAction("HEADING.sendConf('license_activation');");
		window.LicenseActivation.show();
	}

	if (GIWIK._plugins.maintenance.restart_system)
	{
		GIWIK.write('box_restart_title', MSG(['box','restart_title']));
		GIWIK.write('restart_intro', MSG(['box','restart_intro']));

		// Bouton restart (toujours accessible)
		window.Restart = new Button('Restart', false);
		window.Restart.margin = 0;
		window.Restart.construct('restart',MSG(['buttons','restart']),'default',2);
		window.Restart.setAction("HEADING.restartSystem()");
		window.Restart.enable();
		window.Restart.show();
	}

	if (GIWIK._plugins.maintenance.support)
	{
		GIWIK.write('box_support_title', MSG(['box','support_title']));
		GIWIK.write('box_support_intro',
			MSG(['box',(typeof GIWIK._plugins.maintenance.support == 'string') ? GIWIK._plugins.maintenance.support.toLowerCase() : 'support_intro'])
			.replace(new RegExp('%'+GIWIK._plugins.maintenance.support+'%', 'gi'), GIWIK.cgifile+'?mode=3&'+GIWIK._plugins.maintenance.support+'='
				+'&FileName='+HEADING.constructSupportFileName(GIWIK._plugins.maintenance.support)));

		// Bouton de création d'un ticket de support
		window.Btn_support = new Button('Btn_support', false);
		// le bouton n'est pas ajouté à la liste des éléments pilotés par HEADING.setSettingsActivity() car il doit rester accessible tout le temps
		window.Btn_support.margin = 0;
		window.Btn_support.construct('box_support_button', MSG(['buttons','create_ticket']));
		window.Btn_support.enable();
		window.Btn_support.show();

		if (GIWIK._plugins.maintenance.statistics)
		{
			GIWIK.paramGroup.construct('params_statistics', MSG(['box','params_statistics_title']), 'hide');

			// Labels des paramètres Temps/Erreurs
			GIWIK.write('statistics_time_since_manufacturing_label', MSG(['box','statistics_time_since_manufacturing_label'])+' :&nbsp;');
			GIWIK.write('statistics_errors_label', MSG(['box','statistics_errors_label'])+' :');
		}
	}

	if (GIWIK._plugins.maintenance.reset_to_factory)
	{
		// Ecriture du titre et du contenu de la boite
		GIWIK.write('box_resettofactory_title', MSG(['box','reset_title']));
		GIWIK.write('resettofactory_intro', MSG(['box','reset_intro']));

		// Instanciation du message utilisateur
		window.Usermsg_resettofactory = new User_msg('Usermsg_resettofactory', false);
		window.Usermsg_resettofactory.margin = '5px 0 10px 0';
		window.Usermsg_resettofactory.construct(
			'usermsg_resettofactory',
			1,
			GIWIK._plugins.maintenance.reset_to_factory.msg_done ? GIWIK._plugins.maintenance.reset_to_factory.msg_done : MSG(['box','usermsg_resettofactory'])
			);
		window.Usermsg_resettofactory.hide();

		window.Resettofactory = new Button('Resettofactory', true);
		window.Resettofactory.margin = 0;
		window.Resettofactory.construct('resettofactory',MSG(['buttons','reset']),'default',2);
		window.Resettofactory.setAction("HEADING.restoreFactorySettings(function () {window.Resettofactory.disable();window.Usermsg_resettofactory.show();});");
		window.Resettofactory.enable();
		window.Resettofactory.show();
	}

	// Pour les IHM avec affichage des versions logicielles
	if (GIWIK._plugins.maintenance._soft_versions)
	{
		if (count(GIWIK._plugins.maintenance._soft_versions) > 0)
		{
			GIWIK.write('box_firmware_title', MSG(['box',GIWIK._plugins.maintenance.soft_update ? 'firmware_title' : 'softversions_title']));

			if (MSG(['box','firmware_intro']) != '')
			{
				GIWIK.write('firmware_intro', MSG(['box','firmware_intro']));
			}

			if (GIWIK._plugins.maintenance.serial_number)
			{
				GIWIK.write('SerialNumber_label',   MSG(['box','serialnumber_label'])+'&nbsp;:&nbsp;&nbsp;');
			}
			GIWIK.write('IHMVers_label',	MSG(['box','ihmvers_label'])+'&nbsp;:&nbsp;&nbsp;');

			for (var i in GIWIK._plugins.maintenance._soft_versions)
			{
				GIWIK.write(GIWIK._plugins.maintenance._soft_versions[i]+'_label',  MSG(['box',GIWIK._plugins.maintenance._soft_versions[i].toLowerCase()+'_label'])+'&nbsp;:&nbsp;&nbsp;');
			}
		}

		if (GIWIK._plugins.maintenance.soft_update)
		{
			// Mises à jour
			window.Input_file_update = new Input_file('Input_file_update', false);
			window.Input_file_update.label_width = 40;
			window.Input_file_update.construct('file_update', MSG(['parameters','file']), {form_name:'form_update',form_action:HEADING.constructFormAction(),input_name:(HEADING.input_file_html_name) ? HEADING.input_file_html_name : 'Filedata'}, false);
			window.Input_file_update.setAction("this.setFormAction(HEADING.constructFormAction());");
			window.Input_file_update.disable();
			window.Input_file_update.hide();

			// Instanciation du message utilisateur: Update State
			window.Usermsg_updatemode = new User_msg('Usermsg_updatemode', false);
			window.Usermsg_updatemode.margin = "10px 0 5px 0";
			window.Usermsg_updatemode.construct('usermsg_updatemode', 0, "");
			window.Usermsg_updatemode.hide();

			// Instanciation du message utilisateur: Update Result
			window.Usermsg_update = new User_msg('Usermsg_update', false);
			window.Usermsg_update.margin = "10px 0 10px 0";
			window.Usermsg_update.construct('usermsg_update');
			window.Usermsg_update.hide();

			// Update button
			window.Updatesoft = new Button('Updatesoft', false); // LE BOUTON DOIT ETRE TOUJOURS ACCESSIBLE, MEME AVEC LE SYSTEME NON DEMARRE
			window.Updatesoft.margin = 0;
			window.Updatesoft.construct('updatesoft', MSG(['buttons','loadfile']));
			window.Updatesoft.setAction("HEADING.updateSystem();");
			window.Updatesoft.enable();
			window.Updatesoft.show();
		}
	}

	// Pour que la page soit accessible même si le firmware a planté et ne répond pas au mode 3 initial (HEADING.init.isdone dans ce cas est resté à false)
	setTimeout("if (!HEADING.init.isdone){HEADING.display();}", GIWIK.update_timeout*10);
};

// Fonction appelée lors clic bouton "Update"
HEADING.updateSystem = function ()
{
	var filename = decodeURIComponent(window.Input_file_update.getValue());

	// On vérification qu'un fichier a bien été choisi
	if (!filename)
	{
		alert(MSG(['alerts','update_no_file']));
		return;
	}

	// On demande une confirmation pour l'action de mise à jour avec le fichier choisi
	if (HEADING.updateSystem.checkFileName(filename) && confirm(MSG(['confirm','update_with_file']).replace(/%file%/g,filename)))
	{
		// Envoi fichier
		HEADING.sendFirmware();
	}
};

// Fonction de contrôle du nom du fichier envoyé (à écraser le cas échéant dans le plugin division)
HEADING.updateSystem.checkFileName = function () {return true;};

// Chargement Firmware
HEADING.sendFirmware = function ()
{
	window.Statuschevron.setStatus(10);

	if (window.Updatesoft) {window.Updatesoft.disable();}
	if (window.Restart)    {window.Restart.disable();}

	HEADING.setSettingsActivity('disable');

	// Message "Sending Firmware"
	if (window.Usermsg_update)
	{
		window.Usermsg_update.setValue(MSG(['updatestatuscodes','sending_file']));
		window.Usermsg_update.setStatus(1);
		window.Usermsg_update.show();
	}
	HEADING.sending_file = true;

	HEADING.sendFirmware.specific();
};

// Action lors appui bouton restart
HEADING.restartSystem = function ()
{
	// Exécution de l'action "restart"
	GIWIK.getRestartAction()();
};

// Restore to Factory Settings
HEADING.restoreFactorySettings = function (optional_action)
{
	// Message de confirmation
	if (confirm((typeof GIWIK._plugins.maintenance.reset_to_factory.msg_confirm == 'string') ? GIWIK._plugins.maintenance.reset_to_factory.msg_confirm : MSG(['confirm','factorysettings'])))
	{
		if (typeof optional_action == 'function')
		{
			optional_action();
		}

		if (typeof GIWIK._plugins.maintenance.reset_to_factory.action == 'function')
		{
			// Reset to factory settings (commande non standard)
			GIWIK._plugins.maintenance.reset_to_factory.action();
		}
		// Cas standard
		else
		{
			// Reset to factory settings (commande standard) avec callback pour restart system
			GIWIK.ajax(GIWIK.cgifile+"?mode=5&cmd=3", {after_standard_callback: function () {GIWIK.ajax(GIWIK.cgifile+"?mode=5&cmd=1");}});
		}
	}
};

// Construction de l'url cible (CGI) pour l'action du formulaire
HEADING.constructFormAction = function ()
{
	// Cas standard : le paramètre URL permet de spécifier la redirection après prise en compte du fichier par le CGI
	return GIWIK.cgiuploader+'?url='+window.location.protocol+'//'+window.location.host+window.location.pathname;
};

HEADING.constructSupportFileName = function (param)
{
	return (GIWIK._systems[GIWIK.system_type].maintenance().replace(/[_\s]/,'-')+'_'+param+'_'+(new Date(Date.now()).toString().replace(/:/g,'.'))+'.txt').replace(/\s/g,'-');
};