// PLUGIN NETWORK

GIWIK.init.js(['css','msg'], 'mechanical');
GIWIK.init.js(['msg'], 'mechanical_ipd');

// Get System LVA frame for representation
HEADING.getSystemLVAFrame = function(TurretEnabled, SystemPosition)
{
	var SystemLVAFrame = "base";
	
	// Turret activated
	if (TurretEnabled===1)
	{
		switch (SystemPosition)
		{
			case 0:	SystemLVAFrame = "vehicule";	break;
			case 1:	SystemLVAFrame = "turret";		break;
			case 2:	SystemLVAFrame = "barrel";			break;
		}		
	}
	
	return SystemLVAFrame;
}

// Get Primary/Secondary output LVA frame for representation
HEADING.getOutputLVAFrame = function(TurretEnabled)
{
	var OutputLVAFrame = "base";
	
	// Turret activated
	if (TurretEnabled===1){
		OutputLVAFrame = "barrel";		
	}
	
	return OutputLVAFrame;
}

// Get Vehicule output Data LVA frame for representation
HEADING.getVehicleLVAFrame = function(TurretEnabled)
{
	var VehicleLVAFrame = "vehicule";
	
	return VehicleLVAFrame;
}

// Get Turret2Barrel LVA frame for representation
HEADING.getTurret2BarrelLVAFrame = function(TurretEnabled)
{
	var Turret2BarrelLVAFrame = "vehicule";
	
	return Turret2BarrelLVAFrame;
}

// Get Vehicule Type for representation
HEADING.getVehiculeType = function(TurretEnabled)
{
	var VehicleType = GIWIK.vehicule_type;
	
	if(TurretEnabled===1)
		VehicleType = "turret";
		
	return VehicleType;
}


if (HEADING.name === 'installation_mechanical')
{
	// Déduit les orientations des faces "logo" et "connecteurs" à partir du code retourné par SYSTEM.MesaOrient
	HEADING.setMesaorient = function (code,frame_type)
	{
		//if (!HEADING.init.isdone)
		{
			// Définition de l'image d'arrière plan (véhicule)
			$('#mesaorient_bg').css('background', ((!GIWIK._plugins.mechanical.rough_align) ? 'none' : 'no-repeat url('+GIWIK.directories.img_mecha+'/'+frame_type+GIWIK.css.night_suffix+'.gif)'));
		}

		code = eval(code);

		if (typeof code != 'number') {code = 0;} // Code 0 par défaut

		// Définition des index des illustrations sur lesquelles on voit le chevron -> dépend du type de boitier
		var _logo_visible = eval("["+HEADING._mechanical_img_with_visible_logo['mesaorient'].join(",")+"]");

		// Insertion dynamique du suffixe en fonction du code (en fonction de la visibilité du chevron)
		var color_suffix = (in_array(code, _logo_visible)) ? GIWIK.css.color_suffix : '';

		// Cas particulier du mode nuit des IHM à alignement grossier fixe
		var night_suffix = (!GIWIK._plugins.mechanical.rough_align) ? GIWIK.css.night_suffix : '';

		var bg_left = (frame_type == 'plane') ? '-10px' : (frame_type == 'car') ? '15px'  : (frame_type == 'turret') ? 'center' : 'center';
		var bg_top  = (frame_type == 'plane') ? '-35px' : (frame_type== 'car') ? '-85px' : (frame_type == 'turret') ? 'center'  : 'center';
		
		// Insertion de l'image correspondant au code
		$('#mesaorient_img').css('background', 'no-repeat '+bg_left+' '+bg_top+' url('+GIWIK.mechanical_case_img_dir+'/'+'mesaorient'+code+color_suffix+night_suffix+'.png)');
		
		var mg_in_top;
		
		switch(GIWIK.vehicule_type){
			case 'rov':
				mg_in_top = '-378';
				break;
			case 'auv':
				mg_in_top = '-358';
				break;
			default:
				mg_in_top = '-300';
		}
		
		$('#mesaorient_img').css('margin-top', mg_in_top + 'px');		

		var l = null;
		var c = null;
		var c_off1 = null;
		var c_off2 = null;

		switch (code)
		{
			case 0:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 4; c = 0;}
				else if (GIWIK.system_case_type == 'ins50_oem') 				{l = 1; c = 5;}
				else				  											{l = 0; c = 5;}
				window._misalignment_img          = ['fc_cv_lu','fl_cl_lu','fd_cd_lv'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fc_cv_lu','rotation':0},
					'pitch'  : {'code':'fl_cl_lu','rotation':0},
					'heading': {'code':'fd_cd_lv','rotation':0}
				};
				break;
			case 1:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 4; c = 3;}
				else if (GIWIK.system_case_type == 'ins50_oem') 				{l = 2; c = 5;}
				else				   											{l = 3; c = 5;}
				window._misalignment_img          = ['fc_cv_ll','fd_cl_li','fl_cd_ll'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fc_cv_lu','rotation':-90},
					'pitch'  : {'code':'fd_cd_li','rotation': 90},
					'heading': {'code':'fl_cl_lu','rotation':-90}
				};
				break;
			case 2:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 4; c = 1;}
				else if (GIWIK.system_case_type == 'ins50_oem') 				{l = 0; c = 5;}
				else				   											{l = 1; c = 5;}
				window._misalignment_img          = ['fc_cv_ld','fl_cl_ld','fd_cd_li'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fc_cv_lu','rotation':180},
					'pitch'  : {'code':'fl_cr_lu','rotation':180},
					'heading': {'code':'fd_cd_li','rotation':  0}
				};
				break;
			case 3:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 4; c = 2;}
				else if (GIWIK.system_case_type == 'ins50_oem') 				{l = 3; c = 5;}
				else				   											{l = 2; c = 5;}
				window._misalignment_img          = ['fc_cv_lr','fd_cl_lv','fl_cd_lr'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fc_cv_lu','rotation':90},
					'pitch'  : {'code':'fd_cd_lv','rotation':90},
					'heading': {'code':'fl_cr_lu','rotation':90}
				};
				break;
			case 4:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))	{l = 5; c = 0;}
				else if (GIWIK.system_case_type == 'ins50_oem') 				{l = 1; c = 4;}
				else				   											{l = 0; c = 4;}
				window._misalignment_img          = ['fc_ci_lu','fl_cr_lu','fd_cu_lv'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fc_ci_lu','rotation':  0},
					'pitch'  : {'code':'fl_cr_lu','rotation':  0},
					'heading': {'code':'fd_cd_lv','rotation':180}
				};
				break;
			case 5:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 5; c = 3;}
				else if (GIWIK.system_case_type == 'ins50_oem') 				{l = 2; c = 4;}
				else				   											{l = 3; c = 4;}
				window._misalignment_img          = ['fc_ci_ll','fd_cr_li','fl_cu_ll'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fc_ci_lu','rotation':-90},
					'pitch'  : {'code':'fd_cd_li','rotation':-90},
					'heading': {'code':'fl_cr_lu','rotation':-90}
				};
				break;
			case 6:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 5; c = 1;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 0; c = 4;}
				else				   											{l = 1; c = 4;}
				window._misalignment_img          = ['fc_ci_ld','fl_cr_ld','fd_cu_li'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fc_ci_lu','rotation':180},
					'pitch'  : {'code':'fl_cl_lu','rotation':180},
					'heading': {'code':'fd_cd_li','rotation':180}
				};
				break;
			case 7:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))	{l = 5; c = 2;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 3; c = 4;}
				else				   											{l = 2; c = 4;}
				window._misalignment_img          = ['fc_ci_lr','fd_cr_lv','fl_cu_lr'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fc_ci_lu','rotation': 90},
					'pitch'  : {'code':'fd_cd_lv','rotation':-90},
					'heading': {'code':'fl_cl_lu','rotation': 90}
				};
				break;
			case 8:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 2; c = 0;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 1; c = 3;}
				else				   											{l = 0; c = 3;}
				window._misalignment_img          = ['fl_cl_lu','fc_ci_lu','fd_cl_lv'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fl_cl_lu','rotation': 0},
					'pitch'  : {'code':'fc_ci_lu','rotation': 0},
					'heading': {'code':'fd_cd_lv','rotation':90}
				};
				break;
			case 9:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 0; c = 3;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 2; c = 1;}
				else				   											{l = 3; c = 1;}
				window._misalignment_img          = ['fl_cd_ll','fd_cd_li','fc_ci_ll'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fl_cl_lu','rotation':-90},
					'pitch'  : {'code':'fd_cd_li','rotation':  0},
					'heading': {'code':'fc_ci_lu','rotation':-90}
				};
				break;
			case 10:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 3; c = 1;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 0; c = 2;}
				else				   											{l = 1; c = 2;}
				window._misalignment_img          = ['fl_cr_ld','fc_cv_ld','fd_cr_li'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fl_cl_lu','rotation':180},
					'pitch'  : {'code':'fc_cv_lu','rotation':180},
					'heading': {'code':'fd_cd_li','rotation':-90}
				};
				break;
			case 11:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))	{l = 1; c = 2;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 3; c = 0;}
				else				   											{l = 2; c = 0;}
				window._misalignment_img          = ['fl_cu_lr','fd_cu_lv','fc_cv_lr'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fl_cl_lu','rotation': 90},
					'pitch'  : {'code':'fd_cd_lv','rotation':180},
					'heading': {'code':'fc_cv_lu','rotation': 90}
				};
				break;
			case 12:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 3; c = 0;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 1; c = 2;}
				else				   											{l = 0; c = 2;}
				window._misalignment_img          = ['fl_cr_lu','fc_cv_lu','fd_cr_lv'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fl_cr_lu','rotation':  0},
					'pitch'  : {'code':'fc_cv_lu','rotation':  0},
					'heading': {'code':'fd_cd_lv','rotation':-90}
				};
				break;
			case 13:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 1; c = 3;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 2; c = 0;}
				else				   											{l = 3; c = 0;}
				window._misalignment_img          = ['fl_cu_ll','fd_cu_li','fc_cv_ll'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fl_cr_lu','rotation':-90},
					'pitch'  : {'code':'fd_cd_li','rotation':180},
					'heading': {'code':'fc_cv_lu','rotation':-90}
				};
				break;
			case 14:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))	{l = 2; c = 1;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 0; c = 3;}
				else				  											{l = 1; c = 3;}
				window._misalignment_img          = ['fl_cl_ld','fc_ci_ld','fd_cl_li'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fl_cr_lu','rotation':180},
					'pitch'  : {'code':'fc_ci_lu','rotation':180},
					'heading': {'code':'fd_cd_li','rotation': 90}
				};
				break;
			case 15:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))	{l = 0; c = 2;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 3; c = 1;}
				else				   											{l = 2; c = 1;}
				window._misalignment_img          = ['fl_cd_lr','fd_cd_lv','fc_ci_lr'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fl_cr_lu','rotation':90},
					'pitch'  : {'code':'fd_cd_lv','rotation': 0},
					'heading': {'code':'fc_ci_lu','rotation':90}
				};
				break;
			case 16:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 3; c = 4;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 5; c = 2;}
				else				   											{l = 4; c = 2;}
				window._misalignment_img          = ['fd_cr_li','fc_cv_lr','fl_cr_lu'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fd_cd_li','rotation':-90},
					'pitch'  : {'code':'fc_cv_lu','rotation': 90},
					'heading': {'code':'fl_cr_lu','rotation':  0}
				};
				break;
			case 17:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))	{l = 1; c = 4;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 5; c = 0;}
				else				   											{l = 4; c = 0;}
				window._misalignment_img          = ['fd_cu_li','fl_cu_lr','fc_cv_lu'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fd_cd_li','rotation':180},
					'pitch'  : {'code':'fl_cl_lu','rotation': 90},
					'heading': {'code':'fc_cv_lu','rotation':  0}
				};
				break;
			case 18:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))	{l = 2; c = 4;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 5; c = 3;}
				else				  											{l = 4; c = 3;}
				window._misalignment_img          = ['fd_cl_li','fc_ci_lr','fl_cl_lu'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fd_cd_li','rotation':90},
					'pitch'  : {'code':'fc_ci_lu','rotation':90},
					'heading': {'code':'fl_cl_lu','rotation': 0}
				};
				break;
			case 19:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems'])) 	{l = 0; c = 4;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 5; c = 1;}
				else				   											{l = 4; c = 1;}
				window._misalignment_img          = ['fd_cd_li','fl_cd_lr','fc_ci_lu'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fd_cd_li','rotation': 0},
					'pitch'  : {'code':'fl_cr_lu','rotation':90},
					'heading': {'code':'fc_ci_lu','rotation': 0}
				};
				break;
			case 20:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))	{l = 2; c = 5;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 4; c = 3;}
				else				   											{l = 5; c = 3;}
				window._misalignment_img          = ['fd_cl_lv','fc_ci_ll','fl_cl_ld'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fd_cd_lv','rotation': 90},
					'pitch'  : {'code':'fc_ci_lu','rotation':-90},
					'heading': {'code':'fl_cr_lu','rotation':180}
				};
				break;
			case 21:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))	{l = 0; c = 5;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 4; c = 1;}
				else				   											{l = 5; c = 1;}
				window._misalignment_img          = ['fd_cd_lv','fl_cd_ll','fc_ci_ld'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fd_cd_lv','rotation':  0},
					'pitch'  : {'code':'fl_cl_lu','rotation':-90},
					'heading': {'code':'fc_ci_lu','rotation':180}
				};
				break;
			case 22:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))	{l = 3; c = 5;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 4; c = 2;}
				else				   											{l = 5; c = 2;}
				window._misalignment_img          = ['fd_cr_lv','fc_cv_ll','fl_cr_ld'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fd_cd_lv','rotation':-90},
					'pitch'  : {'code':'fc_cv_lu','rotation':-90},
					'heading': {'code':'fl_cl_lu','rotation':180}
				};
				break;
			case 23:
				if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))	{l = 1; c = 5;}
				else if (GIWIK.system_case_type == 'ins50_oem')					{l = 4; c = 0;}
				else				   											{l = 5; c = 0;}
				window._misalignment_img          = ['fd_cu_lv','fl_cu_ll','fc_cv_ld'];
				window._misalignment_img_rotation = {
					'roll'   : {'code':'fd_cd_lv','rotation':180},
					'pitch'  : {'code':'fl_cr_lu','rotation':-90},
					'heading': {'code':'fc_cv_lu','rotation':180}
				};
				break;
		}

		if (l == 0 || l == 1)
		{
			c_off1 = 0;
			c_off2 = 1;
		}
		if (l == 2 || l == 3)
		{
			c_off1 = 2;
			c_off2 = 3;
		}
		if (l == 4 || l == 5)
		{
			c_off1 = 4;
			c_off2 = 5;
		}

		for (var i=0; i<6; i++)
		{
			// Pour la face logo
			if (i == l)
			{
				document.getElementById('l'+i).checked = true;
				GIWIK.css.setClass('l'+i+'_ctnr', 'side_checked');
			}
			else
			{
				document.getElementById('l'+i).checked = false;
				GIWIK.css.setClass('l'+i+'_ctnr', 'side_on');
			}

			// Pour la face connecteurs
			if (i == c_off1 || i == c_off2)
			{
				document.getElementById('c'+i).checked = false;
				document.getElementById('c'+i).disabled = true;
				GIWIK.css.setClass('c'+i+'_ctnr', 'side_off');
			}
			else if (i == c)
			{
				document.getElementById('c'+i).checked = true;
				document.getElementById('c'+i).disabled = false;
				GIWIK.css.setClass('c'+i+'_ctnr', 'side_checked');
			}
			else
			{
				document.getElementById('c'+i).checked = false;
				document.getElementById('c'+i).disabled = false;
				GIWIK.css.setClass('c'+i+'_ctnr', 'side_on');
			}
		}

		if (GIWIK._plugins.mechanical.fine_align)
		{
			// Mise à jour des illustrations des mésalignements fins
			HEADING.displayMisalignImg('roll', window.Input_MesaCrtR.getValue());
			HEADING.displayMisalignImg('pitch', window.Input_MesaCrtP.getValue());
			HEADING.displayMisalignImg('heading', window.Input_MesaCrtH.getValue());
		}
	};

	// Déduit le code MesaOrient à retourner au CGI à partir des orientations des faces "logo" et "connecteurs"
	HEADING.getMesaorient = function ()
	{
		var code = null;
		var l = null;
		var c = null;

		// Récupération des 2 boutons radios cochés
		for (var i=0; i<6; i++)
		{
			if (document.getElementById('l'+i).checked == true){l = i};
			if (document.getElementById('c'+i).checked == true){c = i};
		}

		//document.title = l+" "+c;

		if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))
		{
			if      (l == 4 && c == 0){code = 0;}
			else if (l == 4 && c == 3){code = 1;}
			else if (l == 4 && c == 1){code = 2;}
			else if (l == 4 && c == 2){code = 3;}
			else if (l == 5 && c == 0){code = 4;}
			else if (l == 5 && c == 3){code = 5;}
			else if (l == 5 && c == 1){code = 6;}
			else if (l == 5 && c == 2){code = 7;}
			else if (l == 2 && c == 0){code = 8;}
			else if (l == 0 && c == 3){code = 9;}
			else if (l == 3 && c == 1){code = 10;}
			else if (l == 1 && c == 2){code = 11;}
			else if (l == 3 && c == 0){code = 12;}
			else if (l == 1 && c == 3){code = 13;}
			else if (l == 2 && c == 1){code = 14;}
			else if (l == 0 && c == 2){code = 15;}
			else if (l == 3 && c == 4){code = 16;}
			else if (l == 1 && c == 4){code = 17;}
			else if (l == 2 && c == 4){code = 18;}
			else if (l == 0 && c == 4){code = 19;}
			else if (l == 2 && c == 5){code = 20;}
			else if (l == 0 && c == 5){code = 21;}
			else if (l == 3 && c == 5){code = 22;}
			else if (l == 1 && c == 5){code = 23;}
		}
		else if(GIWIK.system_case_type == 'ins50_oem')
		{			
			if      (l == 1 && c == 5){code = 0;}
			else if (l == 2 && c == 5){code = 1;}
			else if (l == 0 && c == 5){code = 2;}
			else if (l == 3 && c == 5){code = 3;}
			else if (l == 1 && c == 4){code = 4;}
			else if (l == 2 && c == 4){code = 5;}
			else if (l == 0 && c == 4){code = 6;}
			else if (l == 3 && c == 4){code = 7;}
			else if (l == 1 && c == 3){code = 8;}
			else if (l == 2 && c == 1){code = 9;}
			else if (l == 0 && c == 2){code = 10;}
			else if (l == 3 && c == 0){code = 11;}
			else if (l == 1 && c == 2){code = 12;}
			else if (l == 2 && c == 0){code = 13;}
			else if (l == 0 && c == 3){code = 14;}
			else if (l == 3 && c == 1){code = 15;}
			else if (l == 5 && c == 2){code = 16;}
			else if (l == 5 && c == 0){code = 17;}
			else if (l == 5 && c == 3){code = 18;}
			else if (l == 5 && c == 1){code = 19;}
			else if (l == 4 && c == 3){code = 20;}
			else if (l == 4 && c == 1){code = 21;}
			else if (l == 4 && c == 2){code = 22;}
			else if (l == 4 && c == 0){code = 23;}	
		}			
		else
		{
			if      (l == 0 && c == 5){code = 0;}
			else if (l == 3 && c == 5){code = 1;}
			else if (l == 1 && c == 5){code = 2;}
			else if (l == 2 && c == 5){code = 3;}
			else if (l == 0 && c == 4){code = 4;}
			else if (l == 3 && c == 4){code = 5;}
			else if (l == 1 && c == 4){code = 6;}
			else if (l == 2 && c == 4){code = 7;}
			else if (l == 0 && c == 3){code = 8;}
			else if (l == 3 && c == 1){code = 9;}
			else if (l == 1 && c == 2){code = 10;}
			else if (l == 2 && c == 0){code = 11;}
			else if (l == 0 && c == 2){code = 12;}
			else if (l == 3 && c == 0){code = 13;}
			else if (l == 1 && c == 3){code = 14;}
			else if (l == 2 && c == 1){code = 15;}
			else if (l == 4 && c == 2){code = 16;}
			else if (l == 4 && c == 0){code = 17;}
			else if (l == 4 && c == 3){code = 18;}
			else if (l == 4 && c == 1){code = 19;}
			else if (l == 5 && c == 3){code = 20;}
			else if (l == 5 && c == 1){code = 21;}
			else if (l == 5 && c == 2){code = 22;}
			else if (l == 5 && c == 0){code = 23;}
		}

		// Si le code n'est pas valable (par la faute de la face "connecteurs") on le remplace par un valable (premier radio accessible pour les connecteurs)
		if (code === null && l>=0 && l<6)
		{
			if (in_array(GIWIK.system_case_type,['subsea','ursa_mems']))
			{
				if      (l == 0){code = 15;}
				else if (l == 1){code = 11;}
				else if (l == 2){code = 8;}
				else if (l == 3){code = 12;}
				else if (l == 4){code = 0;}
				else if (l == 5){code = 4;}
			}
			if (GIWIK.system_case_type == 'ins50_oem')
			{
				if 		(l == 0){code = 10;}
				else if (l == 1){code = 21;}
				else if (l == 2){code = 13;}
				else if (l == 3){code = 11;}
				else if (l == 4){code = 23;}				
				else if (l == 5){code = 17;}

			}				
			else
			{
				if      (l == 0){code = 21;}
				else if (l == 1){code = 10;}
				else if (l == 2){code = 11;}
				else if (l == 3){code = 13;}
				else if (l == 4){code = 17;}
				else if (l == 5){code = 23;}
			}
		}
		return code;
	};

	// Gestion de l'affichage des illustrations de mésalignement fin en fonction des valeurs CRT
	HEADING.displayMisalignImg = function (param, value)
	{
		if (!in_array(param, ['roll','pitch','heading'])) {return;}

		var type,
			element,
			bg_img,
			code_img,
			extension,
			color_suffix,
			code_label,
			label_left,
			label_top,
			code_img_rotation,
			img_rotation,
			system_axe_rotation,
			vehicule_axe_rotation,
			id_img,
			value_used;

		// Stockage des infos de rotation pour le cllback de l'animation de l'axe du système
		if (!HEADING._last_misalign_info)
		{
			HEADING._last_misalign_info = {};
		}

		// Gestion des conventions de sign
		value_used = value;
		switch (param)
		{
			case 'roll':	if (GIWIK._plugins.mechanical.roll_align_conv !== 'positive_left_up')		{value_used = -value;}	break;
			case 'pitch': 	if (GIWIK._plugins.mechanical.pitch_align_conv !== 'positive_front_down')	{value_used = -value;}	break;
			case 'heading': if (GIWIK._plugins.mechanical.heading_align_conv !== 'positive_clockwise')	{value_used = -value;}	break;
		}
		
		// Définition rotation
		if      (value_used > 0){type = 'p'; system_axe_rotation = -15;}
		else if (value_used < 0){type = 'm'; system_axe_rotation =  15;}
		else               		{type = 'z'; system_axe_rotation =   0;}

		code_img_rotation = window._misalignment_img_rotation[param].code;
		img_rotation      = window._misalignment_img_rotation[param].rotation + system_axe_rotation;

		switch (param)
		{
			case 'roll':
				code_img = window._misalignment_img[0];
				code_label = 2;
				if( GIWIK._plugins.mechanical.frame_convention === 'front_right_down')
				{
					label_left = 112;
					label_top = (type == 'p') ? 75 : 40;
					system_axe_rotation += 90;						// Axe vers droite
					vehicule_axe_rotation = 180;			// Axe vers droite
				}
				else
				{
					label_left = 0;
					label_top = (type == 'm') ? 75 : 40;
					system_axe_rotation -= 90;						// Axe vers gauche
					vehicule_axe_rotation = 0;				// Axe vers gauche
				}
				break;

			case 'pitch':
				code_img = window._misalignment_img[1];
				code_label = 1;
				label_left = 116;
				label_top = (type == 'p') ? 75 : 40;
				system_axe_rotation += 90; // axe orienté vers la droite
				vehicule_axe_rotation = 0;
				break;

			case 'heading':
				code_img = window._misalignment_img[2];
				code_label = 1;
				label_left = (type == 'm') ? 40 : 71;
				label_top = 0;
				system_axe_rotation += 0; // axe orienté vers le haut
				vehicule_axe_rotation = 0;
				break;
		}



		// DEBUG document.title = code_img;

		// Définition des codes des illustrations sur lesquelles on voit le chevron -> dépend du type de boitier
		var regexp = eval("/^("+HEADING._mechanical_img_with_visible_logo['misalignment'].join("|")+")/i");

		// Pour les images sur lesquelles le logo est visible, on appelle la version avec suffixe
		color_suffix = code_img.match(regexp) ? GIWIK.css.color_suffix : '';


		// Image du système ///////////////////////////////////////////////////////////////////
		id_img  = 'mis'+param+'_img';
		element = document.getElementById(id_img);
		bg_img  = 'url('+GIWIK.mechanical_case_img_dir+'/'+code_img+'_'+type+color_suffix+'.png)';
		bg_img_rotation = 'url('+GIWIK.mechanical_case_img_dir+'/'+code_img_rotation+'_z'+color_suffix+'.png)';

		$('#'+id_img).css({'z-index':1, 'background-image':bg_img_rotation});

		// Pour compatibilité IE8
		if (GIWIK._context.ie <= 8)
		{
			$('#'+id_img).stop().animate({'transform': 'rotate('+img_rotation+'deg)'});
		}
		else
		{
			$('#'+id_img).velocity('stop').velocity({'rotateZ': img_rotation+'deg'});
		}

		// Image de l'axe du porteur ///////////////////////////////////////////////////////////
		id_img  = 'mis'+param+'_img_vehicule_axe';
		element = document.getElementById(id_img);
		bg_img_rotation = 'url('+GIWIK.directories.img_lva+'/vehicule_axe_'+param+'.gif)';		
		
		$('#'+id_img).css({'z-index':3, 'background':bg_img_rotation});
		
		// Pour compatibilité IE8
		if (GIWIK._context.ie <= 8)
		{
			$('#'+id_img).stop().animate({'transform': 'rotate('+vehicule_axe_rotation+'deg)'});
		}
		else
		{
			$('#'+id_img).velocity('stop').velocity({'rotateZ': vehicule_axe_rotation+'deg'});
		}

		
		// Image de l'axe du système //////////////////////////////////////////////////////////
		id_img  = 'mis'+param+'_img_system_axe';
		element = document.getElementById(id_img);
		bg_img  = 'url('+GIWIK.directories.img_lva+'/system_axe_'+param+'_'+type+GIWIK.css.color_suffix+(GIWIK.css.graphic_charter == 'blue' ? GIWIK.css.night_suffix : ''	)+'.png)';
		bg_img_rotation = 'url('+GIWIK.directories.img_lva+'/system_axe'+GIWIK.css.color_suffix+(GIWIK.css.graphic_charter == 'blue' ? GIWIK.css.night_suffix : ''	)+'.png)';

		if (type === 'z')
		{
			if (!HEADING.init.isdone)
			{
				$('#'+id_img).hide();
			}
		}
		else
		{
			$('#'+id_img).show();
		}

		HEADING._last_misalign_info[param] = {'type':type, 'id_img':id_img};


		$('#'+id_img).css({'z-index':2, 'background-image':bg_img_rotation});

		// Pour compatibilité IE8
		if (GIWIK._context.ie <= 8)
		{
			$('#'+id_img).stop().animate({'transform': 'rotate('+system_axe_rotation+'deg)'}, function () {
				var id = $(this).attr('id');
				var param = (id.indexOf('roll') > -1) ? 'roll' : (id.indexOf('pitch') > -1) ? 'pitch' : 'heading';
				$(this)[(HEADING._last_misalign_info[param].type === 'z') ? 'hide' : 'show']();
			});
		}
		else
		{
			$('#'+id_img).velocity('stop').velocity({'rotateZ': system_axe_rotation+'deg'}, function () {
				var id = $(this).attr('id');
				var param = (id.indexOf('roll') > -1) ? 'roll' : (id.indexOf('pitch') > -1) ? 'pitch' : 'heading';
				$(this)[(HEADING._last_misalign_info[param].type === 'z') ? 'hide' : 'show']();
			});
		}

		// Image du label de l'axe du système /////////////////////////////////////////////////
		id_img  = 'mis'+param+'_img_system_axe_number';
		bg_img  = 'no-repeat '+label_left+'px '+label_top+'px url('+GIWIK.directories.img_lva+'/'+code_label+'.png)';

		$('#'+id_img).css({'z-index':3, 'background':bg_img});
	};


	// Gestion de la prise en compte du COG
	HEADING.enabledisable_COG = function(COG_enabled)
	{
		// COG enabled
		if( COG_enabled == 1)
		{
			for(var i=1;i<=3;i++)
			{
				// Enable COG input
				eval("window.Input_LeverArm3LV"+i+".enable();");
				eval("window.Input_LeverArm3LV"+i+".show();");

				// Disabled Main Lever Arm and Copy COG input to Main Lever Arm
				eval("window.Input_LeverArm1LV"+i+".setValue(window.Input_LeverArm3LV"+i+".getValue());");
				eval("window.Input_LeverArm1LV"+i+".disable();");

			}
			// Hide COG lever arms image
			$('#div_leverarms3_img').slideDown(200);
		}

		// COG Disabled
		else
		{
			for(var i=1;i<=3;i++)
			{
				// Disable and reset COG input
				eval("window.Input_LeverArm3LV"+i+".setValue(0);");
				eval("window.Input_LeverArm3LV"+i+".disable();");
				eval("window.Input_LeverArm3LV"+i+".hide();");


				// Enable Main Lever Arm
				eval("window.Input_LeverArm1LV"+i+".enable();");
			}
			// Show COG lever arms image
			$('#div_leverarms3_img').slideUp(200);
		}
	}


	// Gestion de la prise en compte des angles de tourelle
	HEADING.enabledisable_Turret = function(TurretEnabled,SystemPosition)
	{
		// Turret enabled
		if (TurretEnabled === 1)
		{		
			// Activate System Position
			window.Select_SystemPos.show();
			
			// Activate System to Turret LVA
			GIWIK.paramGroup.display('params_leverarms_systemturret', 'hide');
			
			if( GIWIK._plugins.mechanical.vehicleLVA )
			{
				// Activate LVA in for Turret Data
				GIWIK.paramGroup.display('params_leverarms4', 'hide');
			}
			
			if( GIWIK._plugins.mechanical.turret2barrelLVA )
			{
				// Activate LVA in for Turret 2 Barrel configuration
				GIWIK.paramGroup.display('params_leverarms5', 'hide');
			}
		}
		
		// Turret Disabled
		else
		{
			// Deactivate System Position
			window.Select_SystemPos.hide();
			
			// Deactivate INS to Turret LVA
			GIWIK.paramGroup.display('params_leverarms_systemturret', 'displaynone');

			if( GIWIK._plugins.mechanical.vehicleLVA )
			{			
				// Deactivate LVA in for Turret Data
				GIWIK.paramGroup.display('params_leverarms4', 'displaynone');				
			}

			if( GIWIK._plugins.mechanical.turret2barrelLVA )
			{
				// Deactivate LVA in for Turret 2 Barrel configuration
				GIWIK.paramGroup.display('params_leverarms5', 'displaynone');	
			}				
		}
		
		// Hide others LVA boxes for coherency
		GIWIK.paramGroup.display('params_leverarms1', 'hide');
		
		if (GIWIK._plugins.mechanical.lever_arms2){
			GIWIK.paramGroup.display('params_leverarms2', 'hide');
		}
		
		
		
		// Refresh LVA representation
		var OutputLVAFrame = HEADING.getOutputLVAFrame(TurretEnabled);
		var SystemLVAFrame = HEADING.getSystemLVAFrame(TurretEnabled,SystemPosition);
		var VehicleLVAFrame = HEADING.getVehicleLVAFrame(TurretEnabled);
		var Turret2BarrelLVAFrame = HEADING.getTurret2BarrelLVAFrame(TurretEnabled);
		
		// console.log( "enabledisable_Turret: TurretEnabled:"+TurretEnabled
					// +" SystemPosition:"+SystemPosition 
					// +" OutputLVAFrame:"+OutputLVAFrame
					// +" SystemLVAFrame:"+SystemLVAFrame
					// +" VehicleLVAFrame:"+VehicleLVAFrame);
					
		if (GIWIK._plugins.mechanical.lever_arms1){
			HEADING.displayLeverarmImg(1, window.Input_LeverArm1LV1.getValue(), window.Input_LeverArm1LV2.getValue(),  window.Input_LeverArm1LV3.getValue(), undefined, OutputLVAFrame);
		}
		
		if (GIWIK._plugins.mechanical.lever_arms2){
			HEADING.displayLeverarmImg(2, eval("window.Input_LeverArm2"+window.lv2_letter+"LV1").getValue(), eval("window.Input_LeverArm2"+window.lv2_letter+"LV2").getValue(),  eval("window.Input_LeverArm2"+window.lv2_letter+"LV3").getValue(), window.lv2_letter, OutputLVAFrame);
		}
		
		if (GIWIK._plugins.mechanical.lever_arms3){
			HEADING.displayLeverarmImg(3, window.Input_LeverArm3LV1.getValue(), window.Input_LeverArm3LV2.getValue(),  window.Input_LeverArm3LV3.getValue(), undefined, OutputLVAFrame);
		}
		
		if (GIWIK._plugins.mechanical.turret){
			HEADING.displayLeverarmImg(0, window.Input_LeverArmSystemLV1.getValue(), window.Input_LeverArmSystemLV2.getValue(),  window.Input_LeverArmSystemLV3.getValue(), undefined, SystemLVAFrame);
			
			if( GIWIK._plugins.mechanical.vehicleLVA )
			{
				HEADING.displayLeverarmImg(4, window.Input_LeverArm4LV1.getValue(), window.Input_LeverArm4LV1.getValue(),  window.Input_LeverArm4LV1.getValue(), undefined, VehicleLVAFrame);
			}
			if( GIWIK._plugins.mechanical.turret2barrelLVA )
			{
				HEADING.displayLeverarmImg(5, window.Input_LeverArm5LV1.getValue(), window.Input_LeverArm5LV1.getValue(),  window.Input_LeverArm5LV1.getValue(), undefined, Turret2BarrelLVAFrame);
			}
		}
		
		// Update Lever Arms Labels
		HEADING.updateLVALabels(TurretEnabled);
		
		// Update MesaOrient	
		HEADING.setMesaorient(window[system].MesaOrient, HEADING.getVehiculeType(window.CheckBox_TurretEnable.getValue()) );
		
	}


	// Update LVA Labels depending on turret configuration
	// - Turret activated: "Primary/Secondary LVA" => "Primary/Sec LVA (Barrel data)"
	// - "Turret output LVA" :(Vehicle data)
	HEADING.updateLVALabels = function(TurretEnabled)
	{
		/*var primary_lva_suffix = ((TurretEnabled === 1) ? (" " +MSG(['box','params_lever_arms_barrel_suffix'])) : "");
		var additionnal_lva_suffix = ((TurretEnabled === 1) ? (" " +MSG(['box','params_lever_arms_vehicle_suffix'])) : "");
		
		// Update Primary/Secondary Lever Arm Labels
		GIWIK.paramGroup.setLabel('params_leverarms1', (MSG(['box','params_lever_arms1'])+primary_lva_suffix) );
		
		if (GIWIK._plugins.mechanical.lever_arms2){
			GIWIK.paramGroup.setLabel('params_leverarms2', (MSG(['box','params_lever_arms2'])+primary_lva_suffix) );
		}
		
		// Update 
		GIWIK.paramGroup.setLabel('params_leverarms4', (MSG(['box','params_lever_arms_turret'])+additionnal_lva_suffix) );*/
		
		
		var primary_lva = ((TurretEnabled === 1) ? MSG(['box','params_lever_arms_barrel']) : MSG(['box','params_lever_arms1']));
		var secondary_lva = ((TurretEnabled === 1) ? MSG(['box','params_lever_arms2_barrel']) : MSG(['box','params_lever_arms2']));
		var vehicle_lva = MSG(['box','params_lever_arms_vehicle']);
		
		
		// Update Primary/Secondary Lever Arm Labels
		GIWIK.paramGroup.setLabel('params_leverarms1', primary_lva );
		
		if (GIWIK._plugins.mechanical.lever_arms2) {
			GIWIK.paramGroup.setLabel('params_leverarms2', secondary_lva );
		}
		
		// Update Vehicule LVA Label
		if (GIWIK._plugins.mechanical.vehicleLVA) {
			GIWIK.paramGroup.setLabel('params_leverarms4', vehicle_lva );
		}
	}


	HEADING.readConf._plugins.mechanical = function ()
	{
		if (GIWIK._plugins.mechanical.turret)
		{
			// Turret Activation
			window.CheckBox_TurretEnable.setValue(window[system].Turret);
		}
		
		// Mésalignement grossier & mésalignement fin
		HEADING.setMesaorient(window[system].MesaOrient, HEADING.getVehiculeType(typeof window.CheckBox_TurretEnable=='object' ? window.CheckBox_TurretEnable.getValue() : 0));

		// Mésalignement fin
		window.Input_MesaCrtH.setValue(window[system].MesaCrt[0]);
		window.Input_MesaCrtR.setValue(window[system].MesaCrt[1]);
		window.Input_MesaCrtP.setValue(window[system].MesaCrt[2]);

		// Definition repère pour bras de levier de sortie
		var LVA_frame = HEADING.getOutputLVAFrame(window[system].Turret);
		
		// Bras de levier primaire
		if (GIWIK._plugins.mechanical.lever_arms1)
		{
			window.Input_LeverArm1LV1.setValue(window[system].LVA[0]);
			window.Input_LeverArm1LV2.setValue(window[system].LVA[1]);
			window.Input_LeverArm1LV3.setValue(window[system].LVA[2]);

			HEADING.displayLeverarmImg(1, window.Input_LeverArm1LV1.getValue(), window.Input_LeverArm1LV2.getValue(),  window.Input_LeverArm1LV3.getValue(), undefined, LVA_frame);

			// Bras de levier secondaires
			if (GIWIK._plugins.mechanical.lever_arms2)
			{
				window.Input_LeverArm2ALV1.setValue(window[system].LVA[3]);
				window.Input_LeverArm2ALV2.setValue(window[system].LVA[4]);
				window.Input_LeverArm2ALV3.setValue(window[system].LVA[5]);

				window.Input_LeverArm2BLV1.setValue(window[system].LVA[6]);
				window.Input_LeverArm2BLV2.setValue(window[system].LVA[7]);
				window.Input_LeverArm2BLV3.setValue(window[system].LVA[8]);

				window.Input_LeverArm2CLV1.setValue(window[system].LVA[9]);
				window.Input_LeverArm2CLV2.setValue(window[system].LVA[10]);
				window.Input_LeverArm2CLV3.setValue(window[system].LVA[11]);

				HEADING.displayLeverarmImg(2, eval("window.Input_LeverArm2"+window.lv2_letter+"LV1").getValue(), eval("window.Input_LeverArm2"+window.lv2_letter+"LV2").getValue(),  eval("window.Input_LeverArm2"+window.lv2_letter+"LV3").getValue(), window.lv2_letter, LVA_frame);
			}
		}

		// COG
		if (GIWIK._plugins.mechanical.lever_arms3)
		{
			if( GIWIK._plugins.mechanical.lever_arms3_checkbox == true )
			{
				// No COG value = COG disabled
				if( window[system].COG[0]==0 && window[system].COG[1]==0 && window[system].COG[2]==0){
					window.CheckBox_LeverArm3Enable.setValue(0);
				}
				else{
					window.CheckBox_LeverArm3Enable.setValue(1);
				}
			}

			// COG Values
			window.Input_LeverArm3LV1.setValue(window[system].COG[0]);
			window.Input_LeverArm3LV2.setValue(window[system].COG[1]);
			window.Input_LeverArm3LV3.setValue(window[system].COG[2]);

			HEADING.displayLeverarmImg(3, window.Input_LeverArm3LV1.getValue(), window.Input_LeverArm3LV2.getValue(),  window.Input_LeverArm3LV3.getValue(), undefined, LVA_frame);

			if( GIWIK._plugins.mechanical.lever_arms3_checkbox == true )
			{
				// Update COG display
				HEADING.enabledisable_COG(window.CheckBox_LeverArm3Enable.getValue());
			}
		}
		
		if (GIWIK._plugins.mechanical.turret)
		{
			// System Position
			window.Select_SystemPos.setValue(window[system].SystemPos);
			
			// System to turret LVA
			window.Input_LeverArmSystemLV1.setValue(window[system].SystemLVA[0]);
			window.Input_LeverArmSystemLV2.setValue(window[system].SystemLVA[1]);
			window.Input_LeverArmSystemLV3.setValue(window[system].SystemLVA[2]);		
			
			if( GIWIK._plugins.mechanical.vehicleLVA )
			{
				// Turret output data main LVA
				window.Input_LeverArm4LV1.setValue(window[system].VehicleLVA[0]);
				window.Input_LeverArm4LV2.setValue(window[system].VehicleLVA[1]);
				window.Input_LeverArm4LV3.setValue(window[system].VehicleLVA[2]);
			}				

			if( GIWIK._plugins.mechanical.turret2barrelLVA )
			{
				// Turret 2 Barrel LVA
				window.Input_LeverArm5LV1.setValue(window[system].TurretBarrelLVA[0]); 
				window.Input_LeverArm5LV2.setValue(window[system].TurretBarrelLVA[1]);
				window.Input_LeverArm5LV3.setValue(window[system].TurretBarrelLVA[2]);	
			}
		}
	};

	HEADING.getConf._plugins.mechanical = function ()
	{
		var _params = {};

		_params['MesaOrient'] = "";
		_params['MesaCrt'] = "";

		if (GIWIK._plugins.mechanical.lever_arms1 || GIWIK._plugins.mechanical.lever_arms2)
		{
			_params['LVA'] = "";
		}

		if (GIWIK._plugins.mechanical.lever_arms3)
		{
			_params['COG'] = "";
		}

		if (GIWIK._plugins.mechanical.turret)
		{
			_params['Turret'] = "";
			_params['SystemLVA'] = "";
			_params['SystemPos'] = "";
			
			if( GIWIK._plugins.mechanical.vehicleLVA ){
				_params['VehicleLVA'] = "";
			}
			
			if( GIWIK._plugins.mechanical.turret2barrelLVA ){
				_params['TurretBarrelLVA'] = "";
			}
		}
		
		return _params;
	};

	HEADING.sendConf._plugins.mechanical = function ()
	{
		var _params = {};
		
		_params['MesaCrt']    = window.Input_MesaCrtH.getValue()+","+window.Input_MesaCrtR.getValue()+","+window.Input_MesaCrtP.getValue();
		_params['MesaOrient'] = HEADING.getMesaorient();

		if (GIWIK._plugins.mechanical.lever_arms1)
		{
			_params['LVA'] = window.Input_LeverArm1LV1.getValue()+","+window.Input_LeverArm1LV2.getValue()+","+window.Input_LeverArm1LV3.getValue();

			if (GIWIK._plugins.mechanical.lever_arms2)
			{
				_params['LVA'] += ","+window.Input_LeverArm2ALV1.getValue()+","+window.Input_LeverArm2ALV2.getValue()+","+window.Input_LeverArm2ALV3.getValue()
							   +  ","+window.Input_LeverArm2BLV1.getValue()+","+window.Input_LeverArm2BLV2.getValue()+","+window.Input_LeverArm2BLV3.getValue()
							   +  ","+window.Input_LeverArm2CLV1.getValue()+","+window.Input_LeverArm2CLV2.getValue()+","+window.Input_LeverArm2CLV3.getValue();
			}
		}

		if (GIWIK._plugins.mechanical.lever_arms3)
		{
			_params['COG'] = window.Input_LeverArm3LV1.getValue()+","+window.Input_LeverArm3LV2.getValue()+","+window.Input_LeverArm3LV3.getValue();
		}
		
		if (GIWIK._plugins.mechanical.turret)
		{
			_params['Turret'] = window.CheckBox_TurretEnable.getValue();
			_params['SystemLVA'] = window.Input_LeverArmSystemLV1.getValue()+","+window.Input_LeverArmSystemLV2.getValue()+","+window.Input_LeverArmSystemLV3.getValue();
			_params['SystemPos'] = window.Select_SystemPos.getValue();
			
			if( GIWIK._plugins.mechanical.vehicleLVA )
			{				
				_params['VehicleLVA'] = window.Input_LeverArm4LV1.getValue()+","+window.Input_LeverArm4LV2.getValue()+","+window.Input_LeverArm4LV3.getValue();
			}
			
			if( GIWIK._plugins.mechanical.turret2barrelLVA )
			{		
				_params['TurretBarrelLVA'] = window.Input_LeverArm5LV1.getValue()+","+window.Input_LeverArm5LV2.getValue()+","+window.Input_LeverArm5LV3.getValue();
			}
		}

		return _params;
	};

	HEADING.construct._plugins.mechanical = function ()
	{
		// Type de boitier par défaut
		if (typeof GIWIK.system_case_type != 'string')
		{
			GIWIK.system_case_type = 'surface';
		}

		// Chemin par défaut du dossier des illustrations méchaniques (fonds)
		if (typeof GIWIK.directories.img_mecha != 'string')
		{
			GIWIK.directories.img_mecha = GIWIK.directories.plugins+'/mechanical_'+GIWIK.ihm_division+'/img';	// Chemin relatif du dossier "img" du plugin "mechanical_xxx" (spécifique division)
		}

		// Chemin par défaut du dossier des illustrations méchaniques (boitiers)
		if (typeof GIWIK.mechanical_case_img_dir != 'string')
		{
			GIWIK.mechanical_case_img_dir = GIWIK.directories.img_mecha+"/"+GIWIK.system_case_type;
		}

		HEADING._mechanical_img_with_visible_logo = {'mesaorient' : [0], 'misalignment' : ['']};
		
		// Définition des illustrations avec logo visible en fonction du type de boitier (utile pour le preload et l'affichage des illustrations)
		//HEADING._mechanical_img_with_visible_logo =
		//{
			//'mesaorient'   : (!GIWIK._plugins.mechanical.rough_align) ? [0] : ((GIWIK.system_case_type == 'surface') ? [0,3,4,7,8,11,12,15,20,21,22,23] : [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23]),
			//'misalignment' : (!GIWIK._plugins.mechanical.rough_align) ? ['fc_cv_lu','fd_cd_lv','fl_cl_lu'] : ((GIWIK.system_case_type == 'surface') ? ['fd_cd_lv','fd_cl_lv','fd_cr_lv','fd_cu_lv'] : ['fc_ci_ld','fc_ci_ll','fc_ci_lr','fc_ci_lu','fc_cv_ld','fc_cv_ll','fc_cv_lr','fc_cv_lu','fd_cd_li','fd_cd_lv','fd_cl_li','fd_cl_lv','fd_cr_li','fd_cr_lv','fd_cu_li','fd_cu_lv','fl_cd_ll','fl_cd_lr','fl_cl_ld','fl_cl_lu','fl_cr_ld','fl_cr_lu','fl_cu_ll','fl_cu_lr'])
			
			if (!GIWIK._plugins.mechanical.rough_align){
				HEADING._mechanical_img_with_visible_logo.mesaorient = [0];
				HEADING._mechanical_img_with_visible_logo.misalignment = ['fc_cv_lu','fd_cd_lv','fl_cl_lu'];
			}
			else{
				switch(GIWIK.system_case_type){
					case 'surface':
						HEADING._mechanical_img_with_visible_logo.mesaorient = [0,3,4,7,8,11,12,15,20,21,22,23];
						HEADING._mechanical_img_with_visible_logo.misalignment = ['fd_cd_lv','fd_cl_lv','fd_cr_lv','fd_cu_lv'];
						break;
					case 'ins50_oem':
					case 'ursa_mems':
						HEADING._mechanical_img_with_visible_logo.mesaorient = [];
						HEADING._mechanical_img_with_visible_logo.misalignment = [];
						break;
					default:
						HEADING._mechanical_img_with_visible_logo.mesaorient = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23];
						HEADING._mechanical_img_with_visible_logo.misalignment = ['fc_ci_ld','fc_ci_ll','fc_ci_lr','fc_ci_lu','fc_cv_ld','fc_cv_ll','fc_cv_lr','fc_cv_lu','fd_cd_li','fd_cd_lv','fd_cl_li','fd_cl_lv','fd_cr_li','fd_cr_lv','fd_cu_li','fd_cu_lv','fl_cd_ll','fl_cd_lr','fl_cl_ld','fl_cl_lu','fl_cr_ld','fl_cr_lu','fl_cu_ll','fl_cu_lr'];
				}
			}
		//};

		var cnt = ''

		+'<div id="usermsg_restart"></div>';

		if(GIWIK._plugins.mechanical.turret)
		{
			cnt += '<div id="params_turret_enable">'
					+'<table id="tab_turret_params">'
						+'<tr>'
							+'<td>'
								+'<div id="checkbox_turret_enable"></div>'
							+'</td>'
						+'</tr>'
						+'<tr>'
							+'<td>'
								+'<div id="select_system_position"></div>'
							+'</td>'
						+'</tr>'
					+'</table>'
				+'</div>';
		}

		cnt += '<div id="params_orientation">'
				+'<table id="tab_mesaorient_params">'
					+'<tr>'
						+'<td id="mesaorient_params">'
							+'<div id="input_roughalign_logo"></div>'
							+'<div id="mask_roughalign_logo"></div>'

							+'<div id="input_roughalign_connectors"></div>'
							+'<div id="mask_roughalign_connectors"></div>'
						+'</td>'
						+'<td align="right">'
							+'<div id="mesaorient_img_ctnr">'
								+'<div id="mesaorient_bg"></div>'
							+'<div id="mesaorient_img" class="mesaorient_img_class"></div>'
							+'</div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>';

		if (GIWIK._plugins.mechanical.fine_align)
		{
			cnt += '<div id="params_finealign">'
				+'<table id="tab_finealign_params">'
					+'<tr>'
						+'<td align="center" class="tdimgleft">'
							+'<div id="input_mesacrtr"></div>'
							+'<div class="misalign_img_ctnr">'
								+'<div id="misroll_img" class="misalign_img"></div>'
								+'<div id="misroll_img_system_axe_number" class="misalign_img_axe"></div>'
								+'<div id="misroll_img_system_axe" class="misalign_img_axe"></div>'
								+'<div id="misroll_img_vehicule_axe" class="misalign_img_axe"></div>'
							+'</div>'
						+'</td>'
						+'<td align="center" class="tdseparatormisa">'
							+'<div class="separatormisa"></div>'
						+'</td>'
						+'<td align="center" class="tdimgcenter">'
							+'<div id="input_mesacrtp"></div>'
							+'<div class="misalign_img_ctnr">'
								+'<div id="mispitch_img" class="misalign_img"></div>'
								+'<div id="mispitch_img_system_axe_number" class="misalign_img_axe"></div>'
								+'<div id="mispitch_img_system_axe" class="misalign_img_axe"></div>'
								+'<div id="mispitch_img_vehicule_axe" class="misalign_img_axe"></div>'
							+'</div>'
						+'</td>'
						+'<td align="center" class="tdseparatormisa">'
							+'<div class="separatormisa"></div>'
						+'</td>'
						+'<td align="center" class="tdimgright">'
							+'<div id="input_mesacrth"></div>'
							+'<div class="misalign_img_ctnr">'
								+'<div id="misheading_img" class="misalign_img"></div>'
								+'<div id="misheading_img_system_axe_number" class="misalign_img_axe"></div>'
								+'<div id="misheading_img_system_axe" class="misalign_img_axe"></div>'
								+'<div id="misheading_img_vehicule_axe" class="misalign_img_axe"></div>'
							+'</div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>';
		}

		if (GIWIK._plugins.mechanical.turret)
		{
			cnt += '<div id="params_leverarms_systemturret">'

				+'<div><div id="leverarms_systemturret_help" class="leverarms_help"></div></div>'
				+'<div id="leverarms_systemturret_axes_img" class="leverarms_axes_img"><div class="close_leverarms_axes_ctnr"><div id="close_leverarms_systemturret_axes" class="close_leverarms_axes">&#215;</div></div></div>'

				+'<table id="tab_leverarms_systemturret_img" class="clearboth">'
					+'<tr>'
						+'<td>'
							+'<div class="leverarms_img1_ctnr">'
								+'<div class="leverarms0_img1"></div>'
								+'<div id="leverarms0_cross1" class="leverarms_cross1"></div>'
								+'<div id="leverarms0_syst1" class="leverarms_syst1"></div>'
								+'<div id="leverarms0_axe1" class="leverarms_axe1"></div>'
							+'</div>'
						+'</td>'
						+'<td>'
							+'<div class="leverarms_img1_ctnr">'
								+'<div class="leverarms0_img2"></div>'
								+'<div id="leverarms0_cross2" class="leverarms_cross2"></div>'
								+'<div id="leverarms0_syst2" class="leverarms_syst2"></div>'
								+'<div id="leverarms0_axe2" class="leverarms_axe2"></div>'
							+'</div>'
						+'</td>'
					+'</tr>'
				+'</table>'

				+'<table id="tab_leverarms_systemturret">'
					+'<tr>'
						+'<td align="center"><div id="input_leverarm_systemturret_xv1"></div></td>'
						+'<td align="center"><div id="input_leverarm_systemturret_xv2"></div></td>'
						+'<td align="center"><div id="input_leverarm_systemturret_xv3"></div></td>'
					+'</tr>'
				+'</table>'

			+'</div>';
		}

		if (GIWIK._plugins.mechanical.turret && GIWIK._plugins.mechanical.turret2barrelLVA)
		{
			cnt += '<div id="params_leverarms5">'

				+'<div><div id="leverarms5_help" class="leverarms_help"></div></div>'
				+'<div id="leverarms5_axes_img" class="leverarms_axes_img"><div class="close_leverarms_axes_ctnr"><div id="close_leverarms5_axes" class="close_leverarms_axes">&#215;</div></div></div>'

				+'<table id="tab_leverarms5_img" class="clearboth">'
					+'<tr>'
						+'<td>'
							+'<div class="leverarms_img1_ctnr">'
								+'<div class="leverarms5_img1"></div>'
								+'<div id="leverarms5_cross1" class="leverarms_cross1"></div>'
								+'<div id="leverarms5_axe1" class="leverarms_axe1"></div>'
							+'</div>'
						+'</td>'
						+'<td>'
							+'<div class="leverarms_img2_ctnr">'
								+'<div class="leverarms5_img2"></div>'
								+'<div id="leverarms5_cross2" class="leverarms_cross2"></div>'
								+'<div id="leverarms5_axe2" class="leverarms_axe2"></div>'
							+'</div>'
						+'</td>'
					+'</tr>'
				+'</table>'

				+'<table id="tab_leverarms5">'
					+'<tr>'
						+'<td align="center"><div id="input_leverarm5xv1"></div></td>'
						+'<td align="center"><div id="input_leverarm5xv2"></div></td>'
						+'<td align="center"><div id="input_leverarm5xv3"></div></td>'
					+'</tr>'
				+'</table>'

			+'</div>';
		}

		
		if (GIWIK._plugins.mechanical.lever_arms1)
		{
			cnt += '<div id="params_leverarms1">'

				+'<div><div id="leverarms1_help" class="leverarms_help"></div></div>'
				+'<div id="leverarms1_axes_img" class="leverarms_axes_img"><div class="close_leverarms_axes_ctnr"><div id="close_leverarms1_axes" class="close_leverarms_axes">&#215;</div></div></div>'

				+'<table id="tab_leverarms1_img" class="clearboth">'
					+'<tr>'
						+'<td>'
							+'<div class="leverarms_img1_ctnr">'
								+'<div class="leverarms1_img1"></div>'
								+'<div id="leverarms1_cross1" class="leverarms_cross1"></div>'
								+'<div id="leverarms1_axe1" class="leverarms_axe1"></div>'
							+'</div>'
						+'</td>'
						+'<td>'
							+'<div class="leverarms_img2_ctnr">'
								+'<div class="leverarms1_img2"></div>'
								+'<div id="leverarms1_cross2" class="leverarms_cross2"></div>'
								+'<div id="leverarms1_axe2" class="leverarms_axe2"></div>'
							+'</div>'
						+'</td>'
					+'</tr>'
				+'</table>'

				+'<table id="tab_leverarms1">'
					+'<tr>'
						+'<td align="center"><div id="input_leverarm1xv1"></div></td>'
						+'<td align="center"><div id="input_leverarm1xv2"></div></td>'
						+'<td align="center"><div id="input_leverarm1xv3"></div></td>'
					+'</tr>'
				+'</table>'

			+'</div>';
		}

		if (GIWIK._plugins.mechanical.lever_arms2)
		{
			cnt += '<div id="params_leverarms2">'

				+'<div><div id="leverarms2_help" class="leverarms_help"></div></div>'
				+'<div id="leverarms2_axes_img" class="leverarms_axes_img"><div class="close_leverarms_axes_ctnr"><div id="close_leverarms2_axes" class="close_leverarms_axes">&#215;</div></div></div>'

				+'<table id="tab_leverarms2_img" class="clearboth">'
					+'<tr>'
						+'<td>'
							+'<div class="leverarms_img1_ctnr">'
								+'<div class="leverarms2_img1"></div>'
								+'<div id="leverarms2_cross1" class="leverarms_cross1"></div>'
								+'<div id="leverarms2_crossletter1" class="leverarms_crossletter1"></div>'
								+'<div id="leverarms2_axe1" class="leverarms_axe1"></div>'
							+'</div>'
						+'</td>'
						+'<td>'
							+'<div class="leverarms_img2_ctnr">'
								+'<div class="leverarms2_img2"></div>'
								+'<div id="leverarms2_cross2" class="leverarms_cross2"></div>'
								+'<div id="leverarms2_crossletter2" class="leverarms_crossletter2"></div>'
								+'<div id="leverarms2_axe2" class="leverarms_axe2"></div>'
							+'</div>'
						+'</td>'
					+'</tr>'
				+'</table>'

				+'<table id="tab_leverarms2">'
					+'<tr>'
						+'<td valign=middle><div id="leverarm2a_title" class="leverarm2_title"></div></td>'
						+'<td><div id="input_leverarm2axv1"></div></td>'
						+'<td><div id="input_leverarm2axv2"></div></td>'
						+'<td><div id="input_leverarm2axv3"></div></td>'
					+'</tr>'
					+'<tr>'
						+'<td colspan="4"><div class="leverarms2_separator"></div></td>'
					+'</tr>'
					+'<tr>'
						+'<td valign=middle><div id="leverarm2b_title" class="leverarm2_title"></div></td>'
						+'<td><div id="input_leverarm2bxv1"></div></td>'
						+'<td><div id="input_leverarm2bxv2"></div></td>'
						+'<td><div id="input_leverarm2bxv3"></div></td>'
					+'</tr>'
					+'<tr>'
						+'<td colspan="4"><div class="leverarms2_separator"></div></td>'
					+'</tr>'
					+'<tr>'
						+'<td><div id="leverarm2c_title" class="leverarm2_title leverarm2_title_last"></div></td>'
						+'<td><div id="input_leverarm2cxv1"></div></td>'
						+'<td><div id="input_leverarm2cxv2"></div></td>'
						+'<td><div id="input_leverarm2cxv3"></div></td>'
					+'</tr>'
				+'</table>'

			+'</div>';
		}

		if (GIWIK._plugins.mechanical.turret && GIWIK._plugins.mechanical.vehicleLVA)
		{
			cnt += '<div id="params_leverarms4">'

				+'<div><div id="leverarms4_help" class="leverarms_help"></div></div>'
				+'<div id="leverarms4_axes_img" class="leverarms_axes_img"><div class="close_leverarms_axes_ctnr"><div id="close_leverarms4_axes" class="close_leverarms_axes">&#215;</div></div></div>'

				+'<table id="tab_leverarms4_img" class="clearboth">'
					+'<tr>'
						+'<td>'
							+'<div class="leverarms_img1_ctnr">'
								+'<div class="leverarms4_img1"></div>'
								+'<div id="leverarms4_cross1" class="leverarms_cross1"></div>'
								+'<div id="leverarms4_axe1" class="leverarms_axe1"></div>'
							+'</div>'
						+'</td>'
						+'<td>'
							+'<div class="leverarms_img2_ctnr">'
								+'<div class="leverarms4_img2"></div>'
								+'<div id="leverarms4_cross2" class="leverarms_cross2"></div>'
								+'<div id="leverarms4_axe2" class="leverarms_axe2"></div>'
							+'</div>'
						+'</td>'
					+'</tr>'
				+'</table>'

				+'<table id="tab_leverarms4">'
					+'<tr>'
						+'<td align="center"><div id="input_leverarm4xv1"></div></td>'
						+'<td align="center"><div id="input_leverarm4xv2"></div></td>'
						+'<td align="center"><div id="input_leverarm4xv3"></div></td>'
					+'</tr>'
				+'</table>'

			+'</div>';
		}
		
		// Bras de levier tertiaires (COG)
		if (GIWIK._plugins.mechanical.lever_arms3)
		{
			cnt += '<div id="params_leverarms3">';

				if( GIWIK._plugins.mechanical.lever_arms3_checkbox == true )
				{
					cnt += '<div id="params_leverarm3_enable">'
						+'<table>'
							+'<tr>'
								+'<td>'
									+'<div id="checkbox_leverarm3_enable"></div>'
								+'</td>'
							+'</tr>'
						+'</table>'
					+'</div>';
				}

				cnt += '<div id="div_leverarms3_img">'
					+'<div><div id="leverarms3_help" class="leverarms_help"></div></div>'
					+'<div id="leverarms3_axes_img" class="leverarms_axes_img"><div class="close_leverarms_axes_ctnr"><div id="close_leverarms3_axes" class="close_leverarms_axes">&#215;</div></div></div>'

					+'<table id="tab_leverarms3_img" class="clearboth">'
						+'<tr>'
							+'<td>'
								+'<div class="leverarms_img1_ctnr">'
									+'<div class="leverarms3_img1"></div>'
									+'<div id="leverarms3_cross1" class="leverarms_cross1"></div>'
									+'<div id="leverarms3_axe1" class="leverarms_axe1"></div>'
								+'</div>'
							+'</td>'
							+'<td>'
								+'<div class="leverarms_img2_ctnr">'
									+'<div class="leverarms3_img2"></div>'
									+'<div id="leverarms3_cross2" class="leverarms_cross2"></div>'
									+'<div id="leverarms3_axe2" class="leverarms_axe2"></div>'
								+'</div>'
							+'</td>'
						+'</tr>'
					+'</table>'
				+'</div>'

				+'<table id="tab_leverarms3">'
					+'<tr>'
						+'<td align="center"><div id="input_leverarm3xv1"></div></td>'
						+'<td align="center"><div id="input_leverarm3xv2"></div></td>'
						+'<td align="center"><div id="input_leverarm3xv3"></div></td>'
					+'</tr>'
				+'</table>'

			+'</div>';
		}


		$('#content').append(GIWIK.box(cnt, MSG(['box','mechanical_title']),true,[],['','box_content_nopaddingtop']));
		
// TO COMPLETE LBO ???
		$('.leverarms_axes_img').css({
			"background" : "no-repeat center center url("+GIWIK.directories.img_lva+"/"+GIWIK.vehicule_type+"_leverarms_axes"+GIWIK.css.color_suffix+GIWIK.css.night_suffix+".png)"
		});


		// Display Turret enable group
		if(GIWIK._plugins.mechanical.turret)
		{
			GIWIK.paramGroup.construct('params_turret_enable', MSG(['box','params_turret_enable']), 'show');
			
			// CheckBox Turret ON
			window.CheckBox_TurretEnable = new Input_checkbox('CheckBox_TurretEnable', true);
			window.CheckBox_TurretEnable.label_width = 100;
			window.CheckBox_TurretEnable.margin_left = 50;
			window.CheckBox_TurretEnable.construct('checkbox_turret_enable','linear',MSG(['parameters','turret_enable']),[0,1],true);
			window.CheckBox_TurretEnable.setAction("HEADING.enabledisable_Turret(window.CheckBox_TurretEnable.getValue(),window.Select_SystemPos.getValue());");
			window.CheckBox_TurretEnable.enable();
			window.CheckBox_TurretEnable.show();	

			// Select System Position
			window.Select_SystemPos = new Input_select('Select_SystemPos', true);
			window.Select_SystemPos.label_width = 100;
			window.Select_SystemPos.margin_left = 50;
			window.Select_SystemPos.construct('select_system_position','linear',MSG(['parameters','system_position']),[0,1,2],[MSG(['parameters','system_position_vehicule']),MSG(['parameters','system_position_turret']),MSG(['parameters','system_position_barrel'])],'',true);
			window.Select_SystemPos.setAction("HEADING.enabledisable_Turret(window.CheckBox_TurretEnable.getValue(),window.Select_SystemPos.getValue());", true);
			window.Select_SystemPos.show();
		}
		
		
		// Rough alignment
		GIWIK.paramGroup.construct('params_orientation', MSG(['box','params_rough_align']), 'show');

		window.mesa_orient = 0;

		window.Mask_roughalign_logo = new Mask('Mask_roughalign_logo', true);
		window.Mask_roughalign_logo.construct('mask_roughalign_logo', 125);

		window.Mask_roughalign_connectors = new Mask('Mask_roughalign_connectors', true);
		window.Mask_roughalign_connectors.construct('mask_roughalign_connectors', 125);

		var roughalign_logo;
		var roughalign_connectors;
		
		// Construction des boutons radio
		if(GIWIK.system_type === 15){
			roughalign_logo = '<div class="mecha_title">'+MSG(['parameters','roughalign_plate'])+'</div>';
			roughalign_connectors = '<div class="mecha_title">'+MSG(['parameters','roughalign_board'])+'</div>';			
		}
		else{
			roughalign_logo = '<div class="mecha_title">'+MSG(['parameters','roughalign_logo'])+'</div>';
			roughalign_connectors = '<div class="mecha_title">'+MSG(['parameters','roughalign_connectors'])+'</div>';
		}

		for (var i=0; i<6; i++)
		{
			roughalign_logo += '<div id="l'+i+'_ctnr"><input type="radio" id="l'+i+'" name="roughalign_logo" value="'+i+'" onclick="HEADING.setMesaorient(HEADING.getMesaorient(),HEADING.getVehiculeType(typeof window.CheckBox_TurretEnable==\'object\' ? window.CheckBox_TurretEnable.getValue() : 0));window.settings_modified=true" style="cursor:pointer" /><label for="l'+i+'" style="padding-left:4px;"> '+MSG(['parameters','orientation'+i])+'</label></div>';

			roughalign_connectors += '<div id="c'+i+'_ctnr"><input type="radio" id="c'+i+'" name="roughalign_connectors" value="'+i+'" onclick="HEADING.setMesaorient(HEADING.getMesaorient(),HEADING.getVehiculeType(typeof window.CheckBox_TurretEnable==\'object\' ? window.CheckBox_TurretEnable.getValue() : 0));window.settings_modified=true" style="cursor:pointer" /><label for="c'+i+'" style="padding-left:4px;"> '+MSG(['parameters','orientation'+i])+'</label></div>';
		}

		GIWIK.write('input_roughalign_logo', roughalign_logo);
		GIWIK.write('input_roughalign_connectors', roughalign_connectors);

		if (!GIWIK._plugins.mechanical.rough_align)
		{
			GIWIK.css.setClass('mesaorient_params', 'displaynone');


			// On n'affiche pas le titre des paramètres, car aucun paramètre ne peut être modifié
			GIWIK.css.setClass('params_orientation_title', 'displaynone');

			//document.getElementById('mesaorient_params').style.width = "0px";
			document.getElementById('tab_mesaorient_params').style.width = "350px";
		}

		// Alignement fin
		if (GIWIK._plugins.mechanical.fine_align)
		{
			GIWIK.paramGroup.construct('params_finealign', MSG(['box','params_fine_align']), 'hide');
			GIWIK.paramGroup.display('params_finealign', 'show');

			var specific_roll_conf = (typeof GIWIK._plugins.mechanical.fine_align.roll  == 'object') ? true : false;

			var roll_min      = (specific_roll_conf) ? GIWIK._plugins.mechanical.fine_align.roll.min   :
								(typeof GIWIK._plugins.mechanical.fine_align.min   == 'number') ? GIWIK._plugins.mechanical.fine_align.min   : -45;

			var roll_max      = (specific_roll_conf) ? GIWIK._plugins.mechanical.fine_align.roll.max   :
								(typeof GIWIK._plugins.mechanical.fine_align.max   == 'number') ? GIWIK._plugins.mechanical.fine_align.max   : 45;

			var roll_step     = (specific_roll_conf) ? GIWIK._plugins.mechanical.fine_align.roll.step  :
								(typeof GIWIK._plugins.mechanical.fine_align.step  == 'number') ? GIWIK._plugins.mechanical.fine_align.step  : 0.001;

			var roll_jumpstep = (specific_roll_conf) ? GIWIK._plugins.mechanical.fine_align.roll.jstep :
								(typeof GIWIK._plugins.mechanical.fine_align.jstep == 'number') ? GIWIK._plugins.mechanical.fine_align.jstep : 0.1;

			// Paramètre "Roll"
			window.Input_MesaCrtR = new Input_int('Input_MesaCrtR', true);
			window.Input_MesaCrtR.label_width = 55; // spécification d'une largeur inférieure à celle par défaut
			window.Input_MesaCrtR.construct('input_mesacrtr','default',MSG(['parameters','roll']),roll_step,roll_min,roll_max,MSG(['units','degree']),roll_jumpstep);
			window.Input_MesaCrtR.setAction("HEADING.displayMisalignImg('roll', window.Input_MesaCrtR.getValue());");
			window.Input_MesaCrtR.show();

			var specific_pitch_conf = (typeof GIWIK._plugins.mechanical.fine_align.pitch  == 'object') ? true : false;

			var pitch_min      = (specific_pitch_conf) ? GIWIK._plugins.mechanical.fine_align.pitch.min   :
								 (typeof GIWIK._plugins.mechanical.fine_align.min   == 'number') ? GIWIK._plugins.mechanical.fine_align.min   : -45;

			var pitch_max      = (specific_pitch_conf) ? GIWIK._plugins.mechanical.fine_align.pitch.max   :
								 (typeof GIWIK._plugins.mechanical.fine_align.max   == 'number') ? GIWIK._plugins.mechanical.fine_align.max   : 45;

			var pitch_step     = (specific_pitch_conf) ? GIWIK._plugins.mechanical.fine_align.pitch.step  :
								 (typeof GIWIK._plugins.mechanical.fine_align.step  == 'number') ? GIWIK._plugins.mechanical.fine_align.step  : 0.001;

			var pitch_jumpstep = (specific_pitch_conf) ? GIWIK._plugins.mechanical.fine_align.pitch.jstep :
								 (typeof GIWIK._plugins.mechanical.fine_align.jstep == 'number') ? GIWIK._plugins.mechanical.fine_align.jstep : 0.1;

			// Paramètre "Pitch"
			window.Input_MesaCrtP = new Input_int('Input_MesaCrtP', true);
			window.Input_MesaCrtP.label_width = 55; // spécification d'une largeur inférieure à celle par défaut
			window.Input_MesaCrtP.construct('input_mesacrtp','default',MSG(['parameters','pitch']),pitch_step,pitch_min,pitch_max,MSG(['units','degree']),pitch_jumpstep);
			window.Input_MesaCrtP.setAction("HEADING.displayMisalignImg('pitch', window.Input_MesaCrtP.getValue());");
			window.Input_MesaCrtP.show();

			var specific_heading_conf = (typeof GIWIK._plugins.mechanical.fine_align.heading  == 'object') ? true : false;

			var heading_min      = (specific_heading_conf) ? GIWIK._plugins.mechanical.fine_align.heading.min   :
								   (typeof GIWIK._plugins.mechanical.fine_align.min   == 'number') ? GIWIK._plugins.mechanical.fine_align.min   : -45;

			var heading_max      = (specific_heading_conf) ? GIWIK._plugins.mechanical.fine_align.heading.max   :
								   (typeof GIWIK._plugins.mechanical.fine_align.max   == 'number') ? GIWIK._plugins.mechanical.fine_align.max   : 45;

			var heading_step     = (specific_heading_conf) ? GIWIK._plugins.mechanical.fine_align.heading.step  :
								   (typeof GIWIK._plugins.mechanical.fine_align.step  == 'number') ? GIWIK._plugins.mechanical.fine_align.step  : 0.001;

			var heading_jumpstep = (specific_heading_conf) ? GIWIK._plugins.mechanical.fine_align.heading.jstep :
								   (typeof GIWIK._plugins.mechanical.fine_align.jstep == 'number') ? GIWIK._plugins.mechanical.fine_align.jstep : 0.1;

			// Paramètre "heading"
			window.Input_MesaCrtH = new Input_int('Input_MesaCrtH', true);
			window.Input_MesaCrtH.label_width = 55; // spécification d'une largeur inférieure à celle par défaut
			window.Input_MesaCrtH.construct('input_mesacrth','default',MSG(['parameters','heading']),heading_step,heading_min,heading_max,MSG(['units','degree']),heading_jumpstep);
			window.Input_MesaCrtH.setAction("HEADING.displayMisalignImg('heading', window.Input_MesaCrtH.getValue());");
			window.Input_MesaCrtH.show();

			// pour alignement exact avec l'axe 1 représenté juste dessous
			// window.Input_MesaCrtH.element_path.style.marginLeft = "1px";
		}

		// Paramètre "Lever Arms"
		var leverarm_min  = -1000;
		var leverarm_max  = 1000;
		var leverarm_step = 0.001;
		var leverarm_jumpstep = 0.1;
			
		// Bras de levier INS-turret
		if (GIWIK._plugins.mechanical.turret)
		{
			GIWIK.paramGroup.construct('params_leverarms_systemturret', MSG(['box','params_lever_arms_system']), 'show');

			GIWIK.write('leverarms_systemturret_help', MSG(['box','lever_arms_help']));
			GIWIK.setClick('leverarms_systemturret_help', "$('#leverarms_systemturret_axes_img').slideDown(200);");
			GIWIK.setClick('close_leverarms_systemturret_axes', "$('#leverarms_systemturret_axes_img').slideUp(200);");

			// Masquage de la définition des axes
			if (GIWIK._plugins.mechanical.axes_definition === false)
			{
				document.getElementById('leverarms_systemturret_help').style.visibility = 'hidden';
				document.getElementById('close_leverarms_systemturret_axes').style.visibility = 'hidden';
			}

			// Paramètre "Primary Lever Arm Main"
			for(var i=1; i<=3; i++)
			{
				eval("window.Input_LeverArmSystemLV"+i+" = new Input_int('Input_LeverArmSystemLV"+i+"', true );");
				eval("window.Input_LeverArmSystemLV"+i+".label_width = 55;"); // spécification d'une largeur inférieure à celle par défaut
				eval("window.Input_LeverArmSystemLV"+i+".margin = '10px 0 0 0';");
				eval("window.Input_LeverArmSystemLV"+i+".construct('input_leverarm_systemturret_xv"+i+"','default',MSG(['parameters','xv"+i+"']),leverarm_step,leverarm_min,leverarm_max,MSG(['units','meter']),leverarm_jumpstep);");
				eval("window.Input_LeverArmSystemLV"+i+".setAction('HEADING.displayLeverarmImg(0, window.Input_LeverArmSystemLV1.getValue(), window.Input_LeverArmSystemLV2.getValue(),  window.Input_LeverArmSystemLV3.getValue(), undefined, HEADING.getSystemLVAFrame(window.CheckBox_TurretEnable.getValue(),window.Select_SystemPos.getValue()));');");
				eval("window.Input_LeverArmSystemLV"+i+".show();");
			}
		}
		

		// Bras de levier Turret-Barrel
		if (GIWIK._plugins.mechanical.turret && GIWIK._plugins.mechanical.turret2barrelLVA )
		{
			GIWIK.paramGroup.construct('params_leverarms5', MSG(['box','params_lever_arms_turret2barrel']), 'show');

			GIWIK.write('leverarms5_help', MSG(['box','lever_arms_help']));
			GIWIK.setClick('leverarms5_help', "$('#leverarms5_axes_img').slideDown(200);");
			GIWIK.setClick('close_leverarms5_axes', "$('#leverarms5_axes_img').slideUp(200);");

			//Masquage de la définition des axes
			if (GIWIK._plugins.mechanical.axes_definition === false)
			{
				document.getElementById('leverarms5_help').style.visibility = 'hidden';
				document.getElementById('close_leverarms5_axes').style.visibility = 'hidden';
			}

			// Paramètre "Primary Lever Arm Main"
			for(var i=1; i<=3; i++)
			{
				eval("window.Input_LeverArm5LV"+i+" = new Input_int('Input_LeverArm5LV"+i+"', true );");
				eval("window.Input_LeverArm5LV"+i+".label_width = 55;"); // spécification d'une largeur inférieure à celle par défaut
				eval("window.Input_LeverArm5LV"+i+".margin = '10px 0 0 0';");
				eval("window.Input_LeverArm5LV"+i+".construct('input_leverarm5xv"+i+"','default',MSG(['parameters','xv"+i+"']),leverarm_step,leverarm_min,leverarm_max,MSG(['units','meter']),leverarm_jumpstep);");
				eval("window.Input_LeverArm5LV"+i+".setAction('HEADING.displayLeverarmImg(5, window.Input_LeverArm5LV1.getValue(), window.Input_LeverArm5LV2.getValue(),  window.Input_LeverArm5LV3.getValue(), undefined, HEADING.getTurret2BarrelLVAFrame(window.CheckBox_TurretEnable.getValue(),window.Select_SystemPos.getValue()));');");
				eval("window.Input_LeverArm5LV"+i+".show();");
			}
		}

		
		// Bras de levier Donnée Tourelle
		if (GIWIK._plugins.mechanical.turret && GIWIK._plugins.mechanical.vehicleLVA )
		{
			GIWIK.paramGroup.construct('params_leverarms4', MSG(['box','params_lever_arms_vehicle']), 'hide');

			GIWIK.write('leverarms4_help', MSG(['box','lever_arms_help']));
			GIWIK.setClick('leverarms4_help', "$('#leverarms4_axes_img').slideDown(200);");
			GIWIK.setClick('close_leverarms4_axes', "$('#leverarms4_axes_img').slideUp(200);");

			// Masquage de la définition des axes
			if (GIWIK._plugins.mechanical.axes_definition === false)
			{
				document.getElementById('leverarms4_help').style.visibility = 'hidden';
				document.getElementById('close_leverarms4_axes').style.visibility = 'hidden';
			 }

			// Paramètre "Primary Lever Arm Main"
			for(var i=1; i<=3; i++)
			{
				eval("window.Input_LeverArm4LV"+i+" = new Input_int('Input_LeverArm4LV"+i+"', true );");
				eval("window.Input_LeverArm4LV"+i+".label_width = 55;"); // spécification d'une largeur inférieure à celle par défaut
				eval("window.Input_LeverArm4LV"+i+".margin = '10px 0 0 0';");
				eval("window.Input_LeverArm4LV"+i+".construct('input_leverarm4xv"+i+"','default',MSG(['parameters','xv"+i+"']),leverarm_step,leverarm_min,leverarm_max,MSG(['units','meter']),leverarm_jumpstep);");
				eval("window.Input_LeverArm4LV"+i+".setAction('HEADING.displayLeverarmImg(4, window.Input_LeverArm4LV1.getValue(), window.Input_LeverArm4LV2.getValue(),  window.Input_LeverArm4LV3.getValue(), undefined, HEADING.getVehicleLVAFrame(window.CheckBox_TurretEnable.getValue()));');");
				eval("window.Input_LeverArm4LV"+i+".show();");
			}
		}
		
		// Bras de levier
		if (GIWIK._plugins.mechanical.lever_arms1)
		{
			GIWIK.paramGroup.construct('params_leverarms1', MSG((typeof GIWIK._plugins.mechanical.lever_arms1 == 'object' && GIWIK._plugins.mechanical.lever_arms1.msg) ? GIWIK._plugins.mechanical.lever_arms1.msg : ['box','params_lever_arms1']), 'hide');

			GIWIK.write('leverarms1_help', MSG(['box','lever_arms_help']));
			GIWIK.setClick('leverarms1_help', "$('#leverarms1_axes_img').slideDown(200);");
			GIWIK.setClick('close_leverarms1_axes', "$('#leverarms1_axes_img').slideUp(200);");

			// Masquage de la définition des axes
			if (GIWIK.css.graphic_charter == 'green' || GIWIK._plugins.mechanical.lever_arms1.axes_definition === false || GIWIK._plugins.mechanical.axes_definition === false)
			{
				document.getElementById('leverarms1_help').style.visibility = 'hidden';
				document.getElementById('close_leverarms1_axes').style.visibility = 'hidden';
			}

			// Paramètre "Primary Lever Arm"
			for(var i=1;i<=3;i++){
				eval("window.Input_LeverArm1LV"+i+" = new Input_int('Input_LeverArm1LV"+i+"', (GIWIK._plugins.mechanical.lever_arms3_checkbox ? false : true) );");
				eval("window.Input_LeverArm1LV"+i+".label_width = 55;");
				eval("window.Input_LeverArm1LV"+i+".margin = '10px 0 0 0';");
				eval("window.Input_LeverArm1LV"+i+".construct('input_leverarm1xv"+i+"','default',MSG(['parameters','xv"+i+"']),leverarm_step,leverarm_min,leverarm_max,MSG(['units','meter']),leverarm_jumpstep);");
				eval("window.Input_LeverArm1LV"+i+".setAction(\"HEADING.displayLeverarmImg(1, window.Input_LeverArm1LV1.getValue(), window.Input_LeverArm1LV2.getValue(),  window.Input_LeverArm1LV3.getValue(),undefined,HEADING.getOutputLVAFrame(typeof window.CheckBox_TurretEnable=='object' ? window.CheckBox_TurretEnable.getValue() : 0));\");");
				eval("window.Input_LeverArm1LV"+i+".show();");
			}
		}

		// Bras de levier secondaires
		if (GIWIK._plugins.mechanical.lever_arms2)
		{
			// Par défaut c'est la position du bras de levier secondaire A qui est affichée sur les 2 schémas
			window.lv2_letter = "A";

			GIWIK.paramGroup.construct('params_leverarms2', MSG(['box','params_lever_arms2']), 'hide');

			GIWIK.write('leverarm2a_title',MSG(['parameters','leverarm2a_title']));
			GIWIK.write('leverarm2b_title',MSG(['parameters','leverarm2b_title']));
			GIWIK.write('leverarm2c_title',MSG(['parameters','leverarm2c_title']));

			GIWIK.write('leverarms2_help', MSG(['box','lever_arms_help']));
			GIWIK.setClick('leverarms2_help', "$('#leverarms2_axes_img').slideDown(200);");
			GIWIK.setClick('close_leverarms2_axes', "$('#leverarms2_axes_img').slideUp(200);");

			if (GIWIK.css.graphic_charter == 'green' || GIWIK._plugins.mechanical.axes_definition === false)
			{
				document.getElementById('leverarms2_help').style.visibility = 'hidden';
				document.getElementById('close_leverarms2_axes').style.visibility = 'hidden';
			}

			// Paramètre "Secondary Lever Arms"
			var leverarmletter = ["A","B","C"];
			for(var l=0;l<3;l++){
				var X = leverarmletter[l];
				for(var i=1;i<=3;i++){
					eval("window.Input_LeverArm2"+X+"LV"+i+" = new Input_int('Input_LeverArm2"+X+"LV"+i+"', true);");
					eval("window.Input_LeverArm2"+X+"LV"+i+".label_width = 29;"); 
					eval("window.Input_LeverArm2"+X+"LV"+i+".margin = '12px 0 12px 0';");
					eval("window.Input_LeverArm2"+X+"LV"+i+".construct('input_leverarm2"+X.toLowerCase()+"xv"+i+"','default',MSG(['parameters','xv"+i+"']),leverarm_step,leverarm_min,leverarm_max,MSG(['units','meter']),leverarm_jumpstep);");
					eval("window.Input_LeverArm2"+X+"LV"+i+".setAction(\"HEADING.displayLeverarmImg(2, window.Input_LeverArm2"+X+"LV1.getValue(), window.Input_LeverArm2"+X+"LV2.getValue(),  window.Input_LeverArm2"+X+"LV3.getValue(), '"+X+"',HEADING.getOutputLVAFrame(typeof window.CheckBox_TurretEnable=='object' ? window.CheckBox_TurretEnable.getValue() : 0));\");");
					eval("window.Input_LeverArm2"+X+"LV"+i+".setActionOnFocus(window.Input_LeverArm2"+X+"LV"+i+".getAction());");
					eval("window.Input_LeverArm2"+X+"LV"+i+".show();");
				}
			}
		}

		// Bras de levier tertiaires (COG)
		if (GIWIK._plugins.mechanical.lever_arms3)
		{
			if (GIWIK.css.graphic_charter == 'green' || GIWIK._plugins.mechanical.axes_definition === false)
			{
				$('#leverarms3_help,#close_leverarms3_axes').css('visibility','hidden');
			}

			GIWIK.paramGroup.construct('params_leverarms3', MSG(['box','params_cog']), 'hide');

			GIWIK.write('leverarms3_help', MSG(['box','lever_arms_help']));
			GIWIK.setClick('leverarms3_help', "$('#leverarms3_axes_img').slideDown(200);");
			GIWIK.setClick('close_leverarms3_axes', "$('#leverarms3_axes_img').slideUp(200);");

			// Paramètre "COG"
			for(var i=1;i<=3;i++){
				eval("window.Input_LeverArm3LV"+i+" = new Input_int('Input_LeverArm3LV"+i+"', true);");
				eval("window.Input_LeverArm3LV"+i+".label_width = 55;");
				eval("window.Input_LeverArm3LV"+i+".margin = '10px 0 0 0';");
				eval("window.Input_LeverArm3LV"+i+".construct('input_leverarm3xv"+i+"','default',MSG(['parameters','xv"+i+"']),leverarm_step,leverarm_min,leverarm_max,MSG(['units','meter']),leverarm_jumpstep);");
				eval("window.Input_LeverArm3LV"+i+".setAction(\"HEADING.displayLeverarmImg(3, window.Input_LeverArm3LV1.getValue(), window.Input_LeverArm3LV2.getValue(),  window.Input_LeverArm3LV3.getValue(), undefined, HEADING.getOutputLVAFrame(typeof window.CheckBox_TurretEnable=='object' ? window.CheckBox_TurretEnable.getValue() : 0));\");");
				eval("window.Input_LeverArm3LV"+i+".show();");
			}

			if( GIWIK._plugins.mechanical.lever_arms3_checkbox == true )
			{
				window.CheckBox_LeverArm3Enable = new Input_checkbox('CheckBox_LeverArm3Enable', true);
				window.CheckBox_LeverArm3Enable.label_width = 100;
				window.CheckBox_LeverArm3Enable.construct('checkbox_leverarm3_enable','linear',MSG(['parameters','leverarm3_enable']),[0,1],true);
				window.CheckBox_LeverArm3Enable.setAction("HEADING.enabledisable_COG(window.CheckBox_LeverArm3Enable.getValue());");
				window.CheckBox_LeverArm3Enable.enable();
				window.CheckBox_LeverArm3Enable.show();
			}

		}


		// Construction du message d'avertissement invitant à redémarer le système après avoir changé la conf méchanique
		if (GIWIK._plugins.mechanical.restart_after_sendconf)
		{
			// Comportement par défaut
			var msg = MSG(['box','usermsg_restart']);
			var button_label = MSG(['buttons','restart']);
			var button_action = GIWIK.getRestartAction(function () {window.Usermsg_restart.hide();});
			var button_show = true;

			// Action sur le bouton send de la page
			var send_action = "window.Usermsg_restart.show();";

			// Comportement spécifique
			if (typeof GIWIK._plugins.mechanical.restart_after_sendconf == 'object')
			{
				// Si une condition à l'affichage de l'encart "restart" est nécessaire
				if (typeof GIWIK._plugins.mechanical.restart_after_sendconf.condition == 'string')
				{
					send_action = "if ("+GIWIK._plugins.mechanical.restart_after_sendconf.condition+"){"+send_action+"}";
				}

				// Message utilisateur
				if (typeof GIWIK._plugins.mechanical.restart_after_sendconf.msg == 'string')
				{
					msg = GIWIK._plugins.mechanical.restart_after_sendconf.msg;
				}

				// Si un bouton est défini
				if (typeof GIWIK._plugins.mechanical.restart_after_sendconf.button == 'object')
				{
					button_label = GIWIK._plugins.mechanical.restart_after_sendconf.button.label;
					button_action = GIWIK._plugins.mechanical.restart_after_sendconf.button.action;
				}
				else
				{
					button_show = false;
				}
			}

			window.Usermsg_restart = new User_msg('Usermsg_restart', true);
			window.Usermsg_restart.margin = '10px 0 10px 0';
			window.Usermsg_restart.construct('usermsg_restart', 2, msg, '<div id="restart"></div>');
			window.Usermsg_restart.hide();

			window.Restart = new Button('Restart', true);
			window.Restart.construct('restart',button_label,'default',2);
			window.Restart.setAction(button_action);
			window.Restart.disable();
			if (button_show)
			{
				window.Restart.show();
			}
			else
			{
				window.Restart.hide();
			}
		}

		// Mise à jour COG<->LVA
		if (GIWIK._plugins.mechanical.lever_arms3)
		{
			if( GIWIK._plugins.mechanical.lever_arms3_checkbox == true )
			{
				send_action += "HEADING.enabledisable_COG(window.CheckBox_LeverArm3Enable.getValue());";
			}
		}


		return {
			validation_buttons : {
				send   : {action : (send_action) ? send_action : ""}
			}
		};

	};
}
