// PLUGIN NETWORK

GIWIK.init.js(['css','msg'], 'network');


// Port part défaut utilisé pour l'enregistrement de données via l'applet Java "DataLogger"
if (typeof GIWIK._plugins.network.repeater_port != 'number'){GIWIK._plugins.network.repeater_port = 8110;}

// Par défaut, le paramètre DHCP est accessible
if (typeof GIWIK._plugins.network.dhcp == 'undefined'){GIWIK._plugins.network.dhcp = true;}


HEADING.activeVlan = function ()
{
	GIWIK.paramGroup.display('params_vlan1', (window.Checkbox_vlan.getValue() == 1)?'show':'displaynone');
	GIWIK.paramGroup.display('params_vlan2', (window.Checkbox_vlan.getValue() == 1)?'show':'displaynone');

	if(window.Checkbox_vlan.getValue() === 1)
	{
		$('#params_gateway').hide();
		$('#params_gateway_vlan').show();
	}
	else
	{
		$('#params_gateway').show();
		$('#params_gateway_vlan').hide();
	}
};

var ip2long = function(ip){
    var components;

    if(components = ip.match(/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/))
    {
        var iplong = 0;
        var power  = 1;
        for(var i=4; i>=1; i-=1)
        {
            iplong += power * parseInt(components[i]);
            power  *= 256;
        }
        return iplong;
    }
    else return -1;
};

var inSubNet = function(ip, subnet)
{   
    var mask, base_ip, long_ip = ip2long(ip);
    if( (mask = subnet.match(/^(.*?)\/(\d{1,2})$/)) && ((base_ip=ip2long(mask[1])) >= 0) )
    {
        var freedom = Math.pow(2, 32 - parseInt(mask[2]));
        return (long_ip > base_ip || long_ip === base_ip) && ((long_ip < base_ip + freedom - 1) || (long_ip === base_ip + freedom - 1));
    }
    else 
	{	
		return false;
	}
};

var CheckGatewayConfiguration = function ()
{
	if (GIWIK._plugins.network.gateway)
	{
		if(window.Checkbox_vlan.getValue() == 1)
		{
			var ip_gateway = window.Input_gateway_vlan_part1.getValue()  +"."+window.Input_gateway_vlan_part2.getValue()  +"."+window.Input_gateway_vlan_part3.getValue()  +"."+window.Input_gateway_vlan_part4.getValue();
			var ip_vlan    = window.Input_vlanipaddress1_part1.getValue()+"."+window.Input_vlanipaddress1_part2.getValue()+"."+window.Input_vlanipaddress1_part3.getValue()+"."+window.Input_vlanipaddress1_part4.getValue();
			var mask_vlan  = window.Input_vlannetmask1_part1.getValue()  +"."+window.Input_vlannetmask1_part2.getValue()  +"."+window.Input_vlannetmask1_part3.getValue()  +"."+window.Input_vlannetmask1_part4.getValue();
			//var maskNodes  = mask_vlan.match(/(\d+)/g);
			//var cidr       = 0;
			
			var ip_gateway_masked = (window.Input_gateway_vlan_part1.getValue() & window.Input_vlannetmask1_part1.getValue()) +"."+
			                        (window.Input_gateway_vlan_part2.getValue() & window.Input_vlannetmask1_part2.getValue()) +"."+
								    (window.Input_gateway_vlan_part3.getValue() & window.Input_vlannetmask1_part3.getValue()) +"."+
								    (window.Input_gateway_vlan_part4.getValue() & window.Input_vlannetmask1_part4.getValue());
								 
			var ip_vlan_masked = (window.Input_vlanipaddress1_part1.getValue() & window.Input_vlannetmask1_part1.getValue()) +"."+
			                     (window.Input_vlanipaddress1_part2.getValue() & window.Input_vlannetmask1_part2.getValue()) +"."+
								 (window.Input_vlanipaddress1_part3.getValue() & window.Input_vlannetmask1_part3.getValue()) +"."+
								 (window.Input_vlanipaddress1_part4.getValue() & window.Input_vlannetmask1_part4.getValue());
								 
			
			var result = (ip2long(ip_gateway_masked) === ip2long(ip_vlan_masked));
			
			return result;
				
			//for(var i in maskNodes)
			//{
			//	cidr += (((maskNodes[i] >>> 0).toString(2)).match(/1/g) || []).length;
			//}
			//ip_vlan += "/" + cidr;
			
			//return inSubNet(ip_gateway, ip_vlan);
		}
		else
		{
			return true;
		}
	}
	else
	{
		return true;
	}
};

var CheckVlanIdentifier = function()
{
	if(window.Input_vlanId1.getValue() != window.Input_vlanId2.getValue())
	{
		return true;
	}
	else return false;
};

	
if (HEADING.name == 'installation_network')
{
	HEADING.readConf._plugins.network = function ()
	{
		// Adresse IP
		window._current_ipaddress = window[system].EthIP[1].split('.');

		for (i=1; i<=4; i++)
		{
			eval("window.Input_ipaddress_part"+i+".setValue(window._current_ipaddress["+(i-1)+"]);");
			eval("window.Input_ipaddress_part"+i+".show();");
		}


		// Masque réseau
		window._current_netmask = window[system].EthIP[2].split('.');

		for (i=1; i<=4; i++)
		{
			eval("window.Input_netmask_part"+i+".setValue(window._current_netmask["+(i-1)+"]);");
			eval("window.Input_netmask_part"+i+".show();");
		}


		if (GIWIK._plugins.network.gateway)
		{
			// Gateway: Test présence Gateway ds réponse: Si non Gateway==AdresseIP
			if (window[system].EthIP.length >= 4)
			{
				window._current_gateway = window[system].EthIP[3].split('.');
			}
			else
			{
				window._current_gateway = window[system].EthIP[1].split('.');
			}

			for (i=1; i<=4; i++)
			{
				eval("window.Input_gateway_part"+i+".setValue(window._current_gateway["+(i-1)+"]);");
				eval("window.Input_gateway_part"+i+".show();");
			}
		}

		if (GIWIK._plugins.network.dns)
		{
			// DNS: Test présence DNS ds réponse: Si non DNS==AdresseIP (par ex.)
			if (window[system].EthIP.length >= 5)
			{
				window._current_dns = window[system].EthIP[4].split('.');
			}
			else
			{
				window._current_dns = window[system].EthIP[1].split('.');
			}

			for (i=1; i<=4; i++)
			{
				eval("window.Input_dns_part"+i+".setValue(window._current_dns["+(i-1)+"]);");
				eval("window.Input_dns_part"+i+".show();");
			}
		}

		// DHCP
		if (GIWIK._plugins.network.dhcp) // Si disponible
		{
			var dhcp = window[system].EthIP[0];
			window.Checkbox_dhcp.show();
		}
		else // Si pas disponible
		{
			var dhcp = 0;
			window.Checkbox_dhcp.hide();
		}
		// Le paramètre DHCP doit être envoyé même si le produit ne supporte pas (encore) le DHCP
		window.Checkbox_dhcp.setValue(dhcp);

		// PPP Server
		if (GIWIK._plugins.network.ppp_server)
		{
			window.Checkbox_ppp.setValue( window[system].PPP[0] );
			window.Checkbox_ppp.show();

			// PPP Port level
			window.Select_PPPStandard.setValue( window[system].PPP[1] );


			// PPP Server IP
			window._current_ppp_server_ip = window[system].PPP[2].split('.');

			for (i=1; i<=4; i++)
			{
				eval("window.Input_pppserveripaddress_part"+i+".setValue(window._current_ppp_server_ip["+(i-1)+"]);");
				eval("window.Input_pppserveripaddress_part"+i+".show();");
			}

			// PPP Client IP
			window._current_ppp_client_ip = window[system].PPP[3].split('.');

			for (i=1; i<=4; i++)
			{
				eval("window.Input_pppclientipaddress_part"+i+".setValue(window._current_ppp_client_ip["+(i-1)+"]);");
				eval("window.Input_pppclientipaddress_part"+i+".show();");
			}
		}

		// System Alias
		if (GIWIK._plugins.network.alias)
		{
			window.Input_alias.setValue(window[system].Alias);
		}

		// Broadcast
		if (GIWIK._plugins.network.broadcast)
		{
			window.Checkbox_broadcast.setValue(window[system].Broadcast);
		}
		
		// Vlan
		if (GIWIK._plugins.network.vlan)
		{
			// Global activation of the vlan functionality
			window.Checkbox_vlan.setValue(window[system].Vlan[0]);
			
			//VLAN1: Control Flow
			//Identifier
			if(window[system].Vlan[1] > 0)
			{
				window.Input_vlanId1.setValue(window[system].Vlan[1]);
			}
			
			// Vlan IP address
			if(window[system].Vlan[2] && window[system].Vlan[2].length > 0)
			{
				window.Current_vlanIp1 = window[system].Vlan[2].split('.');

				for (i=1; i<=4; i++)
				{
					eval("window.Input_vlanipaddress1_part"+i+".setValue(window.Current_vlanIp1["+(i-1)+"]);");
					eval("window.Input_vlanipaddress1_part"+i+".show();");
				}
			}
			
			if(window[system].Vlan[3] && window[system].Vlan[3].length > 0)
			{
				// Vlan Netmask
				window.Current_vlanNetmask1 = window[system].Vlan[3].split('.');

				for (i=1; i<=4; i++)
				{
					eval("window.Input_vlannetmask1_part"+i+".setValue(window.Current_vlanNetmask1["+(i-1)+"]);");
					eval("window.Input_vlannetmask1_part"+i+".show();");
				}
			}

			//----------------------------------------------------
			//VLAN2: Data Flow
			//Identifier
			if(window[system].Vlan[4] > 0)
			{
				window.Input_vlanId2.setValue(window[system].Vlan[4]);
			}
			
			// Vlan IP address
			if(window[system].Vlan[5] && window[system].Vlan[5].length > 0)
			{
				window.Current_vlanIp2 = window[system].Vlan[5].split('.');

				for (i=1; i<=4; i++)
				{
					eval("window.Input_vlanipaddress2_part"+i+".setValue(window.Current_vlanIp2["+(i-1)+"]);");
					eval("window.Input_vlanipaddress2_part"+i+".show();");
				}
			}

			// Vlan Netmask
			if(window[system].Vlan[6] && window[system].Vlan[6].length > 0)
			{
				window.Current_vlanNetmask2 = window[system].Vlan[6].split('.');

				for (i=1; i<=4; i++)
				{
					eval("window.Input_vlannetmask2_part"+i+".setValue(window.Current_vlanNetmask2["+(i-1)+"]);");
					eval("window.Input_vlannetmask2_part"+i+".show();");
				}
			}
			
			//Gateway
			if (GIWIK._plugins.network.gateway)
			{
				// Gateway: Test présence Gateway ds réponse: Si non Gateway==AdresseIP
				if (window[system].EthIP.length >= 4)
				{
					window._current_gateway = window[system].EthIP[3].split('.');
				}
				else
				{
					window._current_gateway = window[system].EthIP[1].split('.');
				}

				for (i=1; i<=4; i++)
				{
					eval("window.Input_gateway_vlan_part"+i+".setValue(window._current_gateway["+(i-1)+"]);");
					eval("window.Input_gateway_vlan_part"+i+".show();");
				}
			}
		}
		
	};

	HEADING.getConf._plugins.network = function ()
	{
		var _params = {};

		_params['EthIP'] = "";
		_params['SerialNumber'] = "";

		// PPP Server
		if (GIWIK._plugins.network.ppp_server)
		{
			_params['PPP'] = "";
		}

		if (GIWIK._plugins.network.broadcast)
		{
			_params['Broadcast'] = "";
		}
		
		if (GIWIK._plugins.network.vlan)
		{
			_params['Vlan'] = "";
		}

		return _params;
	};

	HEADING.sendConf._plugins.network = function ()
	{
		var _params = {};

		_params['EthIP'] = window.Checkbox_dhcp.getValue()
						 + ","+window.Input_ipaddress_part1.getValue()+"."+window.Input_ipaddress_part2.getValue()+"."+window.Input_ipaddress_part3.getValue()+"."+window.Input_ipaddress_part4.getValue()
						 + ","+window.Input_netmask_part1.getValue()+"."+window.Input_netmask_part2.getValue()+"."+window.Input_netmask_part3.getValue()+"."+window.Input_netmask_part4.getValue();

		// Gateway
		if (GIWIK._plugins.network.gateway)
		{
			if(GIWIK._plugins.network.vlan)
			{
				if(window.Checkbox_vlan.getValue() == 0)
				{
					_params['EthIP'] += ","+window.Input_gateway_part1.getValue()+"."+window.Input_gateway_part2.getValue()+"."+window.Input_gateway_part3.getValue()+"."+window.Input_gateway_part4.getValue();
				}
				else
				{
					_params['EthIP'] += ","+window.Input_gateway_vlan_part1.getValue()+"."+window.Input_gateway_vlan_part2.getValue()+"."+window.Input_gateway_vlan_part3.getValue()+"."+window.Input_gateway_vlan_part4.getValue();
				}
			}
			else{
				_params['EthIP'] += ","+window.Input_gateway_part1.getValue()+"."+window.Input_gateway_part2.getValue()+"."+window.Input_gateway_part3.getValue()+"."+window.Input_gateway_part4.getValue();
			}
		}

		// DNS
		if (GIWIK._plugins.network.dns)
		{
			_params['EthIP'] += ","+window.Input_dns_part1.getValue()+"."+window.Input_dns_part2.getValue()+"."+window.Input_dns_part3.getValue()+"."+window.Input_dns_part4.getValue();
		}

		// Alias
		if (GIWIK._plugins.network.alias)
		{
			_params['Alias'] = window.Input_alias.getValue();
		}

		// PPP Server
		if (GIWIK._plugins.network.ppp_server)
		{
			_params['PPP'] = window.Checkbox_ppp.getValue()
						   // PPP Port level
						   + ","+window.Select_PPPStandard.getValue()
						   // PPP Port level
						   + ","+window.Input_pppserveripaddress_part1.getValue()+"."+window.Input_pppserveripaddress_part2.getValue()+"."+window.Input_pppserveripaddress_part3.getValue()+"."+window.Input_pppserveripaddress_part4.getValue()
						   + ","+window.Input_pppclientipaddress_part1.getValue()+"."+window.Input_pppclientipaddress_part2.getValue()+"."+window.Input_pppclientipaddress_part3.getValue()+"."+window.Input_pppclientipaddress_part4.getValue();
		}

		if (GIWIK._plugins.network.broadcast)
		{
			_params['Broadcast'] = window.Checkbox_broadcast.getValue();
		}
		
		if (GIWIK._plugins.network.vlan)
		{
			if(window.Checkbox_vlan.getValue() == 1)
			{
				if(CheckGatewayConfiguration() === true)
				{
					_params['Vlan'] = window.Checkbox_vlan.getValue();
			
					if(CheckVlanIdentifier() === true)
					{
						_params['Vlan'] += ","+window.Input_vlanId1.getValue()
										+  ","+window.Input_vlanipaddress1_part1.getValue()+"."+window.Input_vlanipaddress1_part2.getValue()+"."+window.Input_vlanipaddress1_part3.getValue()+"."+window.Input_vlanipaddress1_part4.getValue()
										+  ","+window.Input_vlannetmask1_part1.getValue()  +"."+window.Input_vlannetmask1_part2.getValue()  +"."+window.Input_vlannetmask1_part3.getValue()  +"."+window.Input_vlannetmask1_part4.getValue()
										+  ","+window.Input_vlanId2.getValue()
										+  ","+window.Input_vlanipaddress2_part1.getValue()+"."+window.Input_vlanipaddress2_part2.getValue()+"."+window.Input_vlanipaddress2_part3.getValue()+"."+window.Input_vlanipaddress2_part4.getValue()
										+  ","+window.Input_vlannetmask2_part1.getValue()  +"."+window.Input_vlannetmask2_part2.getValue()  +"."+window.Input_vlannetmask2_part3.getValue()  +"."+window.Input_vlannetmask2_part4.getValue();
						window.Usermsg_error.hide();
					}
					else
					{
						//User message: VLAN identifier must be different
						window.Usermsg_restart.hide();
						window.Usermsg_error.setValue(MSG(['parameters','vlan_id_error']));
						window.Usermsg_error.setStatus(3);
						window.Usermsg_error.show();
					}
				}
				else
				{
					//User message: Gateway address is not in the right subnet
					window.Usermsg_restart.hide();
					window.Usermsg_error.setValue(MSG(['parameters','vlan_gateway_error']));
					window.Usermsg_error.setStatus(3);
					window.Usermsg_error.show();
				}
			}
			else
			{
				_params['Vlan'] = window.Checkbox_vlan.getValue();
				window.Usermsg_error.hide();
			}
		}

		return _params;
	};

	HEADING.construct._plugins.network = function ()
	{
		var cnt = ''

		+'<div id="usermsg_restart"></div>'
		+'<div id="usermsg_error"></div>'

			+'<div id="params_network">'
				+'<table class="params_init">'
					+'<tr>'
						+'<td align="left">'
							+'<div id="checkbox_dhcp"></div>'
							+'<div>'
								+'<table>'
								+'<tr>'
									+'<td><div id="input_ipaddress_part1"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_ipaddress_part2"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_ipaddress_part3"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_ipaddress_part4"></div></td>'
								+'</tr>'
								+'<tr>'
									+'<td><div id="input_netmask_part1"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_netmask_part2"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_netmask_part3"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_netmask_part4"></div></td>'
								+'</tr>';

							if (GIWIK._plugins.network.gateway)
							{
								cnt += '<tr id="params_gateway">'
									+'<td><div id="input_gateway_part1"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_gateway_part2"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_gateway_part3"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_gateway_part4"></div></td>'
								+'</tr>';
							}

							if (GIWIK._plugins.network.dns)
							{
								cnt += '<tr>'
									+'<td><div id="input_dns_part1"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_dns_part2"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_dns_part3"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_dns_part4"></div></td>'
								+'</tr>';
							}
							if (GIWIK._plugins.network.vlan)
							{
								cnt += '<div id="checkbox_vlan"></div>'
							}
							cnt +='</table>'
						+'</div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>';

			if (GIWIK._plugins.network.alias)
			{
				cnt +='<div id="params_alias">'

						+'<div class="params_init">'
							+'<div id="input_alias"></div>'
						+'</div>'

					+'</div>';
			}

			if (GIWIK._plugins.network.ppp_server)
			{
				cnt +='<div id="params_ppp">'

						+'<table class="params_init">'
							+'<tr>'
								+'<td align="left">'
									+'<div id="checkbox_ppp" class="params_init" ></div>'
									+ '<div id="select_mode_ppp" class="params_init" ></div>'

									+ '<table><tr>'
										+'<td><div id="input_pppserveripaddress_part1"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_pppserveripaddress_part2"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_pppserveripaddress_part3"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_pppserveripaddress_part4"></div></td>'
									+'</tr></table>'

									+ '<table><tr>'
										+'<td><div id="input_pppclientipaddress_part1"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_pppclientipaddress_part2"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_pppclientipaddress_part3"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_pppclientipaddress_part4"></div></td>'
									+'</tr></table>'

								 + '</td>'
							+'</tr>'
						+'</table>'

					+'</div>';
				}

			if (GIWIK._plugins.network.broadcast)
			{
				cnt +='<div id="params_broadcast">'

						+'<table class="params_init">'
							+'<tr>'
								+'<td align="left">'
									+'<div id="checkbox_broadcast" class="params_init" ></div>'
								+ '</td>'
							+'</tr>'
						+'</table>'

					+'</div>';
			}
			
			if (GIWIK._plugins.network.vlan)
			{	
				//VLAN1: control flow
				cnt +='<div id="params_vlan1" align="left">'
					+'<table class="params_init">'
						+'<tr>'
							+'<td align="left">'
								+'<div id="input_vlanId1"></div>'
								+ '<table><tr>'
									+'<td><div id="input_vlanipaddress1_part1"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlanipaddress1_part2"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlanipaddress1_part3"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlanipaddress1_part4"></div></td>'
								+'</tr></table>'

								+ '<table><tr>'
									+'<td><div id="input_vlannetmask1_part1"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlannetmask1_part2"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlannetmask1_part3"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlannetmask1_part4"></div></td>'
								+'</tr></table>';
								
								if (GIWIK._plugins.network.gateway)
								{
									cnt += '<table><tr id="params_gateway_vlan">'
										+'<td><div id="input_gateway_vlan_part1"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_gateway_vlan_part2"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_gateway_vlan_part3"></div></td>'
										+'<td class="param_ipdot">&bull;</td>'
										+'<td><div id="input_gateway_vlan_part4"></div></td>'
									+'</tr></table>';
								}
									
							 cnt += '</td>'
						+'</tr>'
					+'</table>'
				+'</div>';
				
				//VLAN 2: data flow
				cnt +='<div id="params_vlan2" align="left">'

					+'<table class="params_init">'
						+'<tr>'
							+'<td align="left">'
								+'<div id="input_vlanId2"></div>'
								+ '<table><tr>'
									+'<td><div id="input_vlanipaddress2_part1"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlanipaddress2_part2"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlanipaddress2_part3"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlanipaddress2_part4"></div></td>'
								+'</tr></table>'

								+ '<table><tr>'
									+'<td><div id="input_vlannetmask2_part1"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlannetmask2_part2"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlannetmask2_part3"></div></td>'
									+'<td class="param_ipdot">&bull;</td>'
									+'<td><div id="input_vlannetmask2_part4"></div></td>'
								+'</tr></table>'
								
							 + '</td>'
						+'</tr>'
					+'</table>'
				+'</div>';
			}
			
		// Construction de la boite
		$('#content').append(GIWIK.box(cnt, MSG(['box','network_title']),true,[],['', 'box_content_'+(GIWIK._plugins.network.alias ? 'no' : 'half')+'paddingtop']));

		var display_network_param = false;

		// Groupes de paramètres
		if (GIWIK._plugins.network.alias)
		{
			GIWIK.paramGroup.construct('params_alias',   MSG(['box','params_alias']), 'show');
			display_network_param = true;
		}

		if (GIWIK._plugins.network.ppp_server)
		{
			GIWIK.paramGroup.construct('params_ppp',     MSG(['box','params_ppp']), 'show');
			display_network_param = true;
		}

		if (GIWIK._plugins.network.broadcast)
		{
			GIWIK.paramGroup.construct('params_broadcast', MSG(['box','params_broadcast']), 'show');
			display_network_param = true;
		}

		if (GIWIK._plugins.network.vlan)
		{
			GIWIK.paramGroup.construct('params_vlan1', MSG(['box','params_vlan1']), 'displaynone');
			GIWIK.paramGroup.construct('params_vlan2', MSG(['box','params_vlan2']), 'displaynone');
		}
		
		if (display_network_param === true)
		{
			GIWIK.paramGroup.construct('params_network', MSG(['box','params_network']), 'show');
		}


		window.heading_labels_width = 75; 	// Définit la largeur des labels des paramètres de la page
		window.ip_input_width = 36; 		// Définit la largeur des champs des paramètres de la page


		if (GIWIK._plugins.network.ppp_server)
		{
			window.heading_labels_width = 85;

			// Paramètre "PPP"
			window.Checkbox_ppp = new Input_checkbox('Checkbox_ppp', true);
			window.Checkbox_ppp.label_width = window.heading_labels_width;
			window.Checkbox_ppp.height = 22;
			window.Checkbox_ppp.margin = '10px 0 0 0';
			window.Checkbox_ppp.construct('checkbox_ppp','linear',MSG(['parameters','ppp_label']),[0,1],true);
			window.Checkbox_ppp.hide();

			// Paramètres Mode PPP
			window.Select_PPPStandard = new Input_select('Select_PPPStandard', true);
			window.Select_PPPStandard.label_width = window.heading_labels_width;
			window.Select_PPPStandard.construct('select_mode_ppp','linear',MSG(['parameters','ppp_standard_label']),[0,1],['RS232','RS422'],'',true);
			window.Select_PPPStandard[(GIWIK._plugins.network.ppp_server.standard) ? 'show' : 'hide']();

			// Paramètres adresses IP
			min  = 0;
			max  = 255;
			step = 1;
			//----------------------
			for (i=1; i<=4; i++)
			{
				eval("window.Input_pppserveripaddress_part"+i+" = new Input_int('Input_pppserveripaddress_part"+i+"', true);");
				eval("window.Input_pppserveripaddress_part"+i+".label_width = window.heading_labels_width;");
				eval("window.Input_pppserveripaddress_part"+i+".input_width = window.ip_input_width;");
				eval("window.Input_pppserveripaddress_part"+i+".construct('input_pppserveripaddress_part"+i+"','linear',"+ (i==1 ? "MSG(['parameters','ppp_server_ip_label'])" : "''") +",step,min,max,'');");
			}
			for (i=1; i<=4; i++)
			{
				eval("window.Input_pppclientipaddress_part"+i+" = new Input_int('Input_pppclientipaddress_part"+i+"', true);");
				eval("window.Input_pppclientipaddress_part"+i+".label_width = window.heading_labels_width;");
				eval("window.Input_pppclientipaddress_part"+i+".input_width = window.ip_input_width;");
				eval("window.Input_pppclientipaddress_part"+i+".construct('input_pppclientipaddress_part"+i+"','linear',"+ (i==1 ? "MSG(['parameters','ppp_client_ip_label'])" : "''") +",step,min,max,'');");
			}

		}

		// Paramètre "DHCP"
		window.Checkbox_dhcp = new Input_checkbox('Checkbox_dhcp', true);
		window.Checkbox_dhcp.label_width = window.heading_labels_width;
		window.Checkbox_dhcp.height = 22;
		window.Checkbox_dhcp.margin = '10px 0 0 0';
		window.Checkbox_dhcp.construct('checkbox_dhcp','linear',MSG(['parameters','dhcp_label']),[0,1],true);
		window.Checkbox_dhcp.hide();


		var min  = 0;
		var max  = 255;
		var step = 1;

		// Paramètre "Adresse IP" (constitué de 4 Input_int)
		min  = 0;
		max  = 255;
		step = 1;
		//----------------------
		for (i=1; i<=4; i++)
		{
			eval("window.Input_ipaddress_part"+i+" = new Input_int('Input_ipaddress_part"+i+"', true);");
			eval("window.Input_ipaddress_part"+i+".label_width = window.heading_labels_width;");
			eval("window.Input_ipaddress_part"+i+".input_width = window.ip_input_width;");
			eval("window.Input_ipaddress_part"+i+".construct('input_ipaddress_part"+i+"','linear',"+ (i==1 ? "MSG(['parameters','ipaddress_label'])" : "''") +",step,min,max,'');");
		}


		// Paramètre "NetMask" (constitué de 4 Input_int)
		imin  = 0;
		max  = 255;
		step = 1;
		//----------------------
		for (i=1; i<=4; i++)
		{
			eval("window.Input_netmask_part"+i+" = new Input_int('Input_netmask_part"+i+"', true);");
			eval("window.Input_netmask_part"+i+".label_width = window.heading_labels_width;");
			eval("window.Input_netmask_part"+i+".input_width = window.ip_input_width;");
			eval("window.Input_netmask_part"+i+".construct('input_netmask_part"+i+"','linear',"+ (i==1 ? "MSG(['parameters','netmask_label'])" : "''") +",step,min,max,'');");
		}


		if (GIWIK._plugins.network.gateway)
		{
			// Paramètre "Gateway" (constitué de 4 Input_int)
			imin  = 0;
			max  = 255;
			step = 1;
			//----------------------
			for (i=1; i<=4; i++)
			{
				eval("window.Input_gateway_part"+i+" = new Input_int('Input_gateway_part"+i+"', true);");
				eval("window.Input_gateway_part"+i+".label_width = window.heading_labels_width;");
				eval("window.Input_gateway_part"+i+".input_width = window.ip_input_width;");
				eval("window.Input_gateway_part"+i+".construct('input_gateway_part"+i+"','linear',"+ (i==1 ? "MSG(['parameters','gateway_label'])" : "''") +",step,min,max,'');");
			}
		}


		if (GIWIK._plugins.network.dns)
		{
			// Paramètre "DNS" (constitué de 4 Input_int)
			imin  = 0;
			max  = 255;
			step = 1;
			//----------------------
			for (i=1; i<=4; i++)
			{
				eval("window.Input_dns_part"+i+" = new Input_int('Input_dns_part"+i+"', true);");
				eval("window.Input_dns_part"+i+".label_width = window.heading_labels_width;");
				eval("window.Input_dns_part"+i+".input_width = window.ip_input_width;");
				eval("window.Input_dns_part"+i+".construct('input_dns_part"+i+"','linear',"+ (i==1 ? "MSG(['parameters','dns_label'])" : "''") +",step,min,max,'');");
			}
		}


		if (GIWIK._plugins.network.alias)
		{
			window.Input_alias = new Input_text('Input_alias', true);
			window.Input_alias.margin = '10px 0 0 0';
			window.Input_alias.label_width = window.heading_labels_width;
			window.Input_alias.input_width = 189;
			window.Input_alias.text_align = 'left';
			window.Input_alias.construct('input_alias','linear',MSG(['parameters','alias']),'',true);
			window.Input_alias.enable();
			window.Input_alias.show();
		}


		// Construction du message d'avertissement invitant à redémarer le système après avoir changé la conf méchanique  (actif par défaut OU si spécifié par un objet "restart_after_sendconf" OU si explicitement demandé avec les paramètres par défaut)
		if (in_array(typeof GIWIK._plugins.network.restart_after_sendconf, ['undefined','object']) || typeof GIWIK._plugins.network.restart_after_sendconf === true)
		{
			// Comportement par défaut
			var msg = MSG(['box','usermsg_restart']);
			var button_label = MSG(['buttons','restart']);
			var button_action = GIWIK.getRestartAction(function () {window.Usermsg_restart.hide();});
			var button_show = true;

			// Action sur le bouton send de la page
			var send_action = "window.Usermsg_restart.show();";

			// Comportement spécifique
			if (typeof GIWIK._plugins.network.restart_after_sendconf == 'object')
			{
				// Si une condition à l'affichage de l'encart "restart" est nécessaire
				if (typeof GIWIK._plugins.network.restart_after_sendconf.condition == 'string')
				{
					send_action = "if ("+GIWIK._plugins.network.restart_after_sendconf.condition+"){"+send_action+"}";
				}

				// Message utilisateur
				if (typeof GIWIK._plugins.network.restart_after_sendconf.msg == 'string')
				{
					msg = GIWIK._plugins.network.restart_after_sendconf.msg;
				}

				// Si un bouton est défini
				if (typeof GIWIK._plugins.network.restart_after_sendconf.button == 'object')
				{
					button_label = GIWIK._plugins.network.restart_after_sendconf.button.label;
					button_action = GIWIK._plugins.network.restart_after_sendconf.button.action;
				}
				else
				{
					button_show = false;
				}
			}

			window.Usermsg_restart = new User_msg('Usermsg_restart', true);
			window.Usermsg_restart.margin = '10px 0 10px 0';
			window.Usermsg_restart.construct('usermsg_restart', 2, msg, '<div id="restart"></div>');
			window.Usermsg_restart.hide();

			window.Restart = new Button('Restart', true);
			window.Restart.construct('restart',button_label,'default',2);
			window.Restart.setAction(button_action);
			window.Restart.disable();
			if (button_show){window.Restart.show();}
			else{window.Restart.hide();}
		}

		if (GIWIK._plugins.network.broadcast)
		{
			window.Checkbox_broadcast = new Input_checkbox('Checkbox_broadcast', true);
			window.Checkbox_broadcast.label_width = window.heading_labels_width;
			window.Checkbox_broadcast.height = 22;
			window.Checkbox_broadcast.margin = '10px 0 0 0';
			window.Checkbox_broadcast.construct('checkbox_broadcast','linear',MSG(['parameters','broadcast_label']),[0,1],true);
		}

		if (GIWIK._plugins.network.vlan)
		{
			window.heading_labels_width = 85;

			// Activation Vlan functionality
			window.Checkbox_vlan = new Input_checkbox('Checkbox_vlan', true);
			window.Checkbox_vlan.label_width = window.heading_labels_width;
			window.Checkbox_vlan.height = 22;
			window.Checkbox_vlan.margin = '10px 0 0 0';
			window.Checkbox_vlan.construct('checkbox_vlan','linear',MSG(['parameters','vlan_label']),[0,1],true);
			window.Checkbox_vlan.setAction('HEADING.activeVlan()');
			

			for(i=1; i<=2 ; i++)
			{
				eval("window.Input_vlanId"+i+" = new Input_int('Input_vlanId"+i+"', true);");
				eval("window.Input_vlanId"+i+".margin = '10px 0 0 0';");
				eval("window.Input_vlanId"+i+".label_width = window.heading_labels_width;");
				eval("window.Input_vlanId"+i+".input_width = 50;");
				eval("window.Input_vlanId"+i+".text_align = 'left';");
				eval("window.Input_vlanId"+i+".construct('input_vlanId"+i+"','linear',MSG(['parameters','vlan_id_label']),1,1,4096,'');");
				eval("window.Input_vlanId"+i+".enable();");
				eval("window.Input_vlanId"+i+".show();");
			}
			
			// Paramètres adresses IP
			min  = 0;
			max  = 255;
			step = 1;
			//----------------------
			
			for (i=1; i<=4; i++)
			{
				eval("window.Input_vlanipaddress1_part"+i+" = new Input_int('Input_vlanipaddress1_part"+i+"', true);");
				eval("window.Input_vlanipaddress1_part"+i+".label_width = window.heading_labels_width;");
				eval("window.Input_vlanipaddress1_part"+i+".input_width = window.ip_input_width;");
				eval("window.Input_vlanipaddress1_part"+i+".construct('input_vlanipaddress1_part"+i+"','linear',"+ (i==1 ? "MSG(['parameters','ipaddress_label'])" : "''") +",step,min,max,'');");
			}
			for (i=1; i<=4; i++)
			{
				eval("window.Input_vlannetmask1_part"+i+" = new Input_int('Input_vlannetmask1_part"+i+"', true);");
				eval("window.Input_vlannetmask1_part"+i+".label_width = window.heading_labels_width;");
				eval("window.Input_vlannetmask1_part"+i+".input_width = window.ip_input_width;");
				eval("window.Input_vlannetmask1_part"+i+".construct('input_vlannetmask1_part"+i+"','linear',"+ (i==1 ? "MSG(['parameters','netmask_label'])" : "''") +",step,min,max,'');");
			}
			
			//----------------------
			for (i=1; i<=4; i++)
			{
				eval("window.Input_vlanipaddress2_part"+i+" = new Input_int('Input_vlanipaddress2_part"+i+"', true);");
				eval("window.Input_vlanipaddress2_part"+i+".label_width = window.heading_labels_width;");
				eval("window.Input_vlanipaddress2_part"+i+".input_width = window.ip_input_width;");
				eval("window.Input_vlanipaddress2_part"+i+".construct('input_vlanipaddress2_part"+i+"','linear',"+ (i==1 ? "MSG(['parameters','ipaddress_label'])" : "''") +",step,min,max,'');");
			}
			for (i=1; i<=4; i++)
			{
				eval("window.Input_vlannetmask2_part"+i+" = new Input_int('Input_vlannetmask2_part"+i+"', true);");
				eval("window.Input_vlannetmask2_part"+i+".label_width = window.heading_labels_width;");
				eval("window.Input_vlannetmask2_part"+i+".input_width = window.ip_input_width;");
				eval("window.Input_vlannetmask2_part"+i+".construct('input_vlannetmask2_part"+i+"','linear',"+ (i==1 ? "MSG(['parameters','netmask_label'])" : "''") +",step,min,max,'');");
			}
			
			if (GIWIK._plugins.network.gateway)
			{
				for (i=1; i<=4; i++)
				{
					eval("window.Input_gateway_vlan_part"+i+" = new Input_int('Input_gateway_vlan_part"+i+"', true);");
					eval("window.Input_gateway_vlan_part"+i+".label_width = window.heading_labels_width;");
					eval("window.Input_gateway_vlan_part"+i+".input_width = window.ip_input_width;");
					eval("window.Input_gateway_vlan_part"+i+".construct('input_gateway_vlan_part"+i+"','linear',"+ (i==1 ? "MSG(['parameters','gateway_label'])" : "''") +",step,min,max,'');");
				}
			}
			
			window.Usermsg_error = new User_msg('Usermsg_error', false);
			window.Usermsg_error.margin = "10px 0 5px 0";
			window.Usermsg_error.construct('usermsg_error', 0, "");
			window.Usermsg_error.hide();
		}
		
		return {
			validation_buttons : {
				send   : {action : (send_action) ? send_action : ""}
			}
		};
	};
}