// PLUGIN OPTIONS

GIWIK.init.js('msg', 'options');

/*
	MODES DE COORDONNEES :
	 0: LatLong (par défaut)
	 1: UTM
	 2: Polar

	- Gestion dynamique (le firmware gère --> GIWIK._plugins.options.get_coordinate_modes_from_firmware === true) :
	 1 Si les modes de coordonnées supportés ne sont pas définis en dur (dans app.js GIWIK._plugins.options._coordinate_modes undefined)
	   OU si le mode polaire est géré (dans app.js, par ex. GIWIK._plugins.options._coordinate_modes = [0,1,2])
	  --> le flag GIWIK._plugins.options.get_coordinate_modes_from_firmware est levé.
	      En attendant la réponse de l'embarqué, les modes de coordonnées et le mode de coordonnées courant sont lus dans les cookies si présents.
	 2 On demande au firmware CoordinateModesList et CoordinateMode
	 3 Si le mode polaire (2) est supporté, c'est l'embarqué qui gère le mode de coordonnées courant pour toutes les IHM connectées (CoordinateMode),
	   dans tous les autres cas, c'est l'IHM qui le gère.


	- Gestion statique (l'IHM gère --> GIWIK._plugins.options.get_coordinate_modes_from_firmware === false) :
	 1 - on lit dans les cookies la valeur du mode de coordonnées
	 2 - on interroge l'embarqué sur les modes de coordonnées gérés (CoordinateModesList)
	 3 - si l'embarqué gère le mode de coordonnées polaires, on vérifie que la valeur du mode courant stocké dans l'embarqué correspond bien à la valeur des cookies précédement lue

	NOTATIONS LATITUDE / LONGITUDE :
	 d   : degrés décimalaux	PAR DÉFAUT
	 dm  : degrés, minutes décimales
	 dms : degrés, minutes, secondes
*/

HEADING.readConf._plugins.options = function ()
{
	GIWIK.data.coordinates.setMode();
	GIWIK.data.coordinates.latlong.setNotation();

	// Gestion de la norme des écarts types
	if (GIWIK._plugins.options.stddev_pos_norm)
	{
		var stddev_pos_norm = STORAGE.get('stddev_pos_norm');

		if (!in_array(stddev_pos_norm,GIWIK.data.stddev._pos_norms))
		{
			stddev_pos_norm = GIWIK.data.stddev.pos_norm;

			STORAGE.setPermanent('stddev_pos_norm',stddev_pos_norm);
		}
		else
		{
			GIWIK.data.stddev.pos_norm = stddev_pos_norm;
		}
	}

	// Gestion des normes d'attitude
	if (GIWIK._plugins.options.attitude_norm)
	{
		var heading_sign_norm = STORAGE.get('heading_sign_norm');

		if (!in_array(heading_sign_norm,GIWIK.data.attitude_convention._heading_sign_norms))
		{
			heading_sign_norm = GIWIK.data.attitude_convention.heading_sign_norm;
			STORAGE.setPermanent('heading_sign_norm',heading_sign_norm);
		}
		else
		{
			GIWIK.data.attitude_convention.heading_sign_norm = heading_sign_norm;
		}

		var heading_range_norm = STORAGE.get('heading_range_norm');

		if (!in_array(heading_range_norm,GIWIK.data.attitude_convention._heading_range_norms))
		{
			heading_range_norm = GIWIK.data.attitude_convention.heading_range_norm;
			STORAGE.setPermanent('heading_range_norm',heading_range_norm);
		}
		else
		{
			GIWIK.data.attitude_convention.heading_range_norm = heading_range_norm;
		}

		var roll_sign_norm = STORAGE.get('roll_sign_norm');

		if (!in_array(roll_sign_norm,GIWIK.data.attitude_convention._roll_sign_norms))
		{
			roll_sign_norm = GIWIK.data.attitude_convention.roll_sign_norm;
			STORAGE.setPermanent('roll_sign_norm',roll_sign_norm);
		}
		else
		{
			GIWIK.data.attitude_convention.roll_sign_norm = roll_sign_norm;
		}


		var pitch_sign_norm = STORAGE.get('pitch_sign_norm');

		if (!in_array(pitch_sign_norm,GIWIK.data.attitude_convention._pitch_sign_norms))
		{
			pitch_sign_norm = GIWIK.data.attitude_convention.pitch_sign_norm;
			STORAGE.setPermanent('pitch_sign_norm',pitch_sign_norm);
		}
		else
		{
			GIWIK.data.attitude_convention.pitch_sign_norm = pitch_sign_norm;
		}
	}
};

HEADING.construct._plugins.options = function ()
{
	// Phase d'init : si les modes de coordonnées doivent-être demandés au firmware
	if (typeof GIWIK._plugins.options._coordinate_modes == 'undefined' || in_array(2,GIWIK._plugins.options._coordinate_modes))
	{
		GIWIK._plugins.options.get_coordinate_modes_from_firmware = true;
	}
};

// Sélection du mode d'affichage (day, night ou undefined -> bascule entre les 2)
// no_reload (boolean) bloque le rechargement de la page (utile pour la page options qui gère elle-même le rechargement)
GIWIK.setDisplayMode = function (mode, no_reload)
{
	var cookie_value;  // aujourd'hui correspond à la valeur night_mode (boolean)

	// Si le mode est défini à "day"
	if (mode === 'day')
	{
		cookie_value = false;
	}
	// Si le mode est défini à "night"
	else if (mode === 'night')
	{
		cookie_value = true;
	}
	// Autrement, fonctionnement en switch
	else
	{
		cookie_value = (STORAGE.get('night_mode') === true) ? false : true;
	}

	STORAGE.setPermanent('night_mode', cookie_value);

	// Pour les IHM dotées de courbes AM Charts, on lance la modif des fichiers xml de conf pour prendre en compte le mode nuit
	if (GIWIK._plugins.chartsview)
	{
		GIWIK.ajax(GIWIK.phpfile+"?mode=set_night_mode_in_amcharts&night_mode="+window.Select_nightmode.getValue());
	}

	if (!no_reload)
	{
		window.location.reload();
		return;
	}
};

if (HEADING.name == 'options')
{
	HEADING.readConf._plugins.options.specific = function ()
	{
		if (!HEADING.init.isdone)
		{
			// Construction du menu de coordonnées si différents modes de coordonnées sont disponibles
			if (count(GIWIK._plugins.options._coordinate_modes) >= 2)
			{
				GIWIK.paramGroup.construct('params_coordinates', MSG(['box','params_coordinates']), 'show');

				window.Select_llutm = new Input_select('Select_llutm', true);
				window.Select_llutm.margin_left = HEADING.input_margins;

				var _num = [], _list = [];

				if (in_array(0,GIWIK._plugins.options._coordinate_modes))
				{
					_num.push(0/*LatLong*/);
					_list.push(MSG(['lists','coordinate_mode',0]));
				}
				if (in_array(1,GIWIK._plugins.options._coordinate_modes))
				{
					_num.push(1/*UTM*/);
					_list.push(MSG(['lists','coordinate_mode',1]));
				}
				if (in_array(2,GIWIK._plugins.options._coordinate_modes))
				{
					_num.push(2/*Polar*/);
					_list.push(MSG(['lists','coordinate_mode',2]));
				}
				if (in_array(3,GIWIK._plugins.options._coordinate_modes))
				{
					_num.push(3/*ups*/);
					_list.push(MSG(['lists','coordinate_mode',3]));
				}
				if (in_array(4,GIWIK._plugins.options._coordinate_modes))
				{
					_num.push(4/*osgb*/);
					_list.push(MSG(['lists','coordinate_mode',4]));
				}
				if (in_array(5,GIWIK._plugins.options._coordinate_modes))
				{
					_num.push(5/*mgrs*/);
					_list.push(MSG(['lists','coordinate_mode',5]));
				}
				if (in_array(6,GIWIK._plugins.options._coordinate_modes))
				{
					_num.push(6/*georef*/);
					_list.push(MSG(['lists','coordinate_mode',6]));
				}
				if (in_array(7,GIWIK._plugins.options._coordinate_modes))
				{
					_num.push(7/*ecef*/);
					_list.push(MSG(['lists','coordinate_mode',7]));
				}
				window.Select_llutm.margin_left = HEADING.input_margins;
				window.Select_llutm.label_width = HEADING.input_label_width;
				window.Select_llutm.construct('select_llutm','linear',MSG(['parameters','system']),_num,_list,'',true);
				window.Select_llutm.setAction(function ()
				{
					if (in_array(window.Select_llutm.getValue(),[0/*LatLong*/,2/*Polar*/]))
					{
						window.Select_latlong_notation.show();
					}
					else
					{
						window.Select_latlong_notation.hide();
					}
				});
				window.Select_llutm.show();
			}

			if (GIWIK._plugins.options.latlong_notation)
			{
				if (count(GIWIK._plugins.options._coordinate_modes) === 1)
				{
					GIWIK.paramGroup.construct('params_latlong_notation', MSG(['box','params_latlong_notation']), 'show');
				}
				else
				{
					$('#params_latlong_notation').css('display','');
				}

				var _latlong_notation = MSG(['parameters','latlong_notation_list']);
				var _num = ['d'], _list = [_latlong_notation[0]];
				if (GIWIK.latlong_precision > 0) {_num.push('dm');  _list.push(_latlong_notation[1]);}
				if (GIWIK.latlong_precision > 3) {_num.push('dms'); _list.push(_latlong_notation[2]);}

				window.Select_latlong_notation = new Input_select('Select_latlong_notation', false);
				window.Select_latlong_notation.margin_left = HEADING.input_margins;
				window.Select_latlong_notation.label_width = HEADING.input_label_width;
				window.Select_latlong_notation.construct('select_latlong_notation','linear',MSG(['parameters','notation']),_num,_list,'',true);
				window.Select_latlong_notation.enable();
			}
		}

		if (GIWIK._plugins.options.latlong_notation)
		{
			window.Select_latlong_notation.setValue(GIWIK.latlong_notation);
		}
		if (GIWIK._plugins.options.language)
		{
			window.Select_language.setValue(GIWIK.lang);
		}
		if (GIWIK._plugins.options.display_mode)
		{
			window.Select_nightmode.setValue(GIWIK.css.night_mode);
		}
		if (count(GIWIK._plugins.options._coordinate_modes) >= 2)
		{
			window.Select_llutm.setValue(GIWIK.coordinate_mode);
		}
		if (GIWIK._plugins.options.stddev_pos_norm)
		{
			window.Select_stddev_pos_norm.setValue(STORAGE.get('stddev_pos_norm',GIWIK.data.stddev.pos_norm));
		}
		if (GIWIK._plugins.options.attitude_norm)
		{
			window.Select_heading_sign_norm.setValue(STORAGE.get('heading_sign_norm',GIWIK.data.attitude_convention.heading_sign_norm));
			window.Select_heading_range_norm.setValue(STORAGE.get('heading_range_norm',GIWIK.data.attitude_convention.heading_range_norm));
			window.Select_roll_sign_norm.setValue(STORAGE.get('roll_sign_norm',GIWIK.data.attitude_convention.roll_sign_norm));
			window.Select_pitch_sign_norm.setValue(STORAGE.get('pitch_sign_norm',GIWIK.data.attitude_convention.pitch_sign_norm));
		}

		// Gestion des unités
		if (GIWIK._plugins.options.units)
		{
			var unit, data,
				_units = STORAGE.get('units',{});

			for (data in GIWIK._plugins.options.units)
			{
				unit = (_units[data]) ? _units[data] : GIWIK.data.types[data]['default'](undefined,undefined,data);
				window['Select_'+data+'_unit'].setValue(unit);
			}
		}
	};

	HEADING.sendConf._plugins.options = function ()
	{
		var _params = {},
			reload  = false;

		// Sélection de la langue
		if (GIWIK._plugins.options.language)
		{
			if (window.Select_language.getValue() != GIWIK.lang)
			{
				// écriture du cookie (permanent)
				STORAGE.setPermanent('lang', window.Select_language.getValue());

				// La page doit être rechargée
				reload = true;
			}
		}

		if (count(GIWIK._plugins.options._coordinate_modes) > 1)
		{
			// Sélection du mode de coordonnées (LatLong/UTM/Polar)
			if (window.Select_llutm.getValue() != GIWIK.coordinate_mode)
			{
				// Cas particulier des INS gérant les coordonnées polaires : gestion par le firmware, pas par l'IHM
				// if (in_array(2,GIWIK._plugins.options._coordinate_modes))
				if (GIWIK._plugins.options.get_coordinate_modes_from_firmware)
				{
					_params['CoordinateMode'] = window.Select_llutm.getValue();
				}
				else
				{
					// écriture du cookie (permanent)
					STORAGE.setPermanent('coordinate_mode', window.Select_llutm.getValue());
				}

				// La page doit être rechargée
				reload = false;
			}
		}

		if (GIWIK._plugins.options.latlong_notation)
		{
			// Sélection du mode de coordonnées (Lat.Long./UTM/Polar)
			if (window.Select_latlong_notation.getValue() != GIWIK.latlong_notation)
			{
				// écriture du cookie (permanent)
				STORAGE.setPermanent('latlong_notation', window.Select_latlong_notation.getValue());

				// La page doit être rechargée
				reload = false;
			}
		}

		if (GIWIK._plugins.options.display_mode)
		{
			// Sélection du mode d'affichage (normal/nuit)
			if (window.Select_nightmode.getValue() !== GIWIK.css.night_mode)
			{
				// Appel de la fonction de sélection du mode d'affichage (true en 2nd param pour ne pas recharger la page qui le sera à la fin de ce script)
				GIWIK.setDisplayMode(window.Select_nightmode.getValue(), true);

				// La page doit être rechargée
				reload = true;
			}
		}

		if (GIWIK._plugins.options.units)
		{
			var _units = {},
				data;

			for (data in GIWIK._plugins.options.units)
			{
				_units[data] = window['Select_'+data+'_unit'].getValue();
			}

			GIWIK.data.units.setDataTypeUnits(_units);
		}

		if (GIWIK._plugins.options.stddev_pos_norm)
		{
			STORAGE.setPermanent('stddev_pos_norm',window.Select_stddev_pos_norm.getValue());
		}

		if (GIWIK._plugins.options.attitude_norm)
		{
			STORAGE.setPermanent('heading_sign_norm',window.Select_heading_sign_norm.getValue());
			STORAGE.setPermanent('heading_range_norm',window.Select_heading_range_norm.getValue());
			STORAGE.setPermanent('roll_sign_norm',window.Select_roll_sign_norm.getValue());
			STORAGE.setPermanent('pitch_sign_norm',window.Select_pitch_sign_norm.getValue());
		}

		if (reload)
		{
			// Rechargement de la page en cours
			setTimeout("window.location.reload()",200);
		}

		return _params;
	};

	HEADING.construct._plugins.options.specific = function ()
	{
		// Coloration du label du menu
		$('#options').css('color', GIWIK.css.color_top_menui);

		var cnt = ''

		+'<div id="params_display">'
			+'<div id="select_language"></div>'
			+'<div id="select_nightmode"></div>'
		+'</div>'

		+'</div>'
		+'<div id="params_coordinates">'
			+'<div id="select_llutm"></div>'
			+'<div id="params_latlong_notation">'
				+'<div id="select_latlong_notation"></div>'
			+'</div>'
		+'</div>'

		+'<div id="params_units">'
			// +'<div id="select_angle_unit"></div>'
			// +'<div id="select_speed_unit"></div>'
		+'</div>'

		+'<div id="params_norms">'
			+'<div id="select_stddev_pos_norm"></div>'
		+'</div>'
		+'<div id="params_att_conv">'
			+'<div id="heading_range_norm"></div>'
			+'<div id="heading_sign_norm"></div>'
			+'<div id="roll_sign_norm"></div>'
			+'<div id="pitch_sign_norm"></div>'
		+'</div>';

		$('#content').append(GIWIK.box(cnt, MSG(['box','options_title']), true, [], ['','box_content_nopaddingtop']));

		cnt = null;

		HEADING.input_margins = 100;
		HEADING.input_label_width = 60;

		GIWIK.paramGroup.construct('params_display',MSG(['box','params_display']), 'displaynone');
		GIWIK.paramGroup.construct('params_units',MSG(['box','params_units']), 'displaynone');
		GIWIK.paramGroup.construct('params_norms',MSG(['box','params_norms']), 'displaynone');
		GIWIK.paramGroup.construct('params_att_conv',MSG(['box','params_att_conv']), 'displaynone');

		if (GIWIK._plugins.options.language)
		{
			GIWIK.paramGroup.display('params_display', 'show');

			var _num  = [];
			var _list = [];

			for (var l in GIWIK._available_languages)
			{
				language_code = GIWIK._available_languages[l];
				language_label = MSG.language[language_code];

				_num.push(language_code);
				_list.push(language_label);
			}

			window.Select_language = new Input_select('Select_language', false);
			window.Select_language.margin_left = HEADING.input_margins;
			window.Select_language.label_width = HEADING.input_label_width;
			window.Select_language.construct('select_language','linear',MSG(['parameters','language'], {lang:'en'}),_num,_list,'',true);
			window.Select_language.enable();
		}

		if (GIWIK._plugins.options.display_mode)
		{
			GIWIK.paramGroup.display('params_display', 'show');

			window.Select_nightmode = new Input_select('Select_nightmode', false);
			window.Select_nightmode.margin_left = HEADING.input_margins;
			window.Select_nightmode.label_width = HEADING.input_label_width;
			window.Select_nightmode.construct('select_nightmode','linear',MSG(['parameters','mode']),[false,true],[MSG(['parameters','day']),MSG(['parameters','night'])],'',true);
			window.Select_nightmode.enable();
		}

		if (typeof GIWIK._plugins.options.units == 'object')
		{
			GIWIK.paramGroup.display('params_units', 'show');

			var unit, _num, _list;

			for (data_type in GIWIK._plugins.options.units)
			{
				_num  = GIWIK._plugins.options.units[data_type],
				_list = array_map(function(value){return MSG(['units',value]);}, _num);

				GIWIK.write('params_units', '<div id="select_'+data_type+'_unit"></div>', 'append');

				window['Select_'+data_type+'_unit'] = new Input_select('Select_'+data_type+'_unit', false);
				window['Select_'+data_type+'_unit'].margin_left = HEADING.input_margins;
				window['Select_'+data_type+'_unit'].label_width = HEADING.input_label_width;
				window['Select_'+data_type+'_unit'].construct('select_'+data_type+'_unit','linear',MSG(['parameters',data_type]),_num,_list,'',1);
				window['Select_'+data_type+'_unit'].enable();
				window['Select_'+data_type+'_unit'].show();
			}


			// if (GIWIK._plugins.options.units.angle)
			// {
			// 	var _num  = GIWIK._plugins.options.units.angle,
			// 		_list = array_map(function(value){return MSG(['units',value]);}, _num);

			// 	window.Select_angle_unit = new Input_select('Select_angle_unit', false);
			// 	window.Select_angle_unit.margin_left = HEADING.input_margins;
			// 	window.Select_angle_unit.label_width = HEADING.input_label_width;
			// 	window.Select_angle_unit.construct('select_angle_unit','linear',MSG(['parameters','angle']),_num,_list,'',1);
			// 	window.Select_angle_unit.enable();
			// 	window.Select_angle_unit.show();
			// }

			// if (GIWIK._plugins.options.units.speed)
			// {
			// 	var _num  = GIWIK._plugins.options.units.speed,
			// 		_list = array_map(function(value){return MSG(['units',value]);}, _num);

			// 	window.Select_speed_unit = new Input_select('Select_speed_unit', false);
			// 	window.Select_speed_unit.margin_left = HEADING.input_margins;
			// 	window.Select_speed_unit.label_width = HEADING.input_label_width;
			// 	window.Select_speed_unit.construct('select_speed_unit','linear',MSG(['parameters','speed']),_num,_list,'',1);
			// 	window.Select_speed_unit.enable();
			// 	window.Select_speed_unit.show();
			// }
		}

		if (GIWIK._plugins.options.stddev_pos_norm)
		{
			GIWIK.paramGroup.display('params_norms', 'show');

			window.Select_stddev_pos_norm = new Input_select('Select_stddev_pos_norm', false);
			window.Select_stddev_pos_norm.margin_left = HEADING.input_margins;
			window.Select_stddev_pos_norm.label_width = HEADING.input_label_width;
			window.Select_stddev_pos_norm.construct('select_stddev_pos_norm','linear',MSG(['parameters','position_stddev']),GIWIK.data.stddev._pos_norms,array_map(function(value){return MSG(['parameters',value]);}, GIWIK.data.stddev._pos_norms),'',true);
			window.Select_stddev_pos_norm.enable();
		}

		if (GIWIK._plugins.options.attitude_norm)
		{
			var input_label_width = (GIWIK.lang == 'fr') ? 100 : HEADING.input_label_width;

			GIWIK.paramGroup.display('params_att_conv', 'show');

			window.Select_heading_sign_norm = new Input_select('Select_heading_sign_norm', false);
			window.Select_heading_sign_norm.margin_left = HEADING.input_margins;
			window.Select_heading_sign_norm.label_width = input_label_width;
			window.Select_heading_sign_norm.construct('heading_sign_norm','linear',MSG(['parameters','heading_sign']),GIWIK.data.attitude_convention._heading_sign_norms,array_map(function(value){return MSG(['parameters',value]);}, GIWIK.data.attitude_convention._heading_sign_norms),'',true);
			window.Select_heading_sign_norm.hide();

			window.Select_heading_range_norm = new Input_select('Select_heading_range_norm', false);
			window.Select_heading_range_norm.margin_left = HEADING.input_margins;
			window.Select_heading_range_norm.label_width = input_label_width;
			window.Select_heading_range_norm.construct('heading_range_norm','linear',MSG(['parameters','heading_range']),GIWIK.data.attitude_convention._heading_range_norms,array_map(function(value){return MSG(['parameters',value]);}, GIWIK.data.attitude_convention._heading_range_norms),'',true);
			window.Select_heading_range_norm.enable();
			window.Select_heading_range_norm.hide();

			window.Select_roll_sign_norm = new Input_select('Select_roll_sign_norm', false);
			window.Select_roll_sign_norm.margin_left = HEADING.input_margins;
			window.Select_roll_sign_norm.label_width = input_label_width;
			window.Select_roll_sign_norm.construct('roll_sign_norm','linear',MSG(['parameters','roll_sign']),GIWIK.data.attitude_convention._roll_sign_norms,array_map(function(value){return MSG(['parameters',value]);}, GIWIK.data.attitude_convention._roll_sign_norms),'',true);
			window.Select_roll_sign_norm.enable();

			window.Select_pitch_sign_norm = new Input_select('Select_pitch_sign_norm', false);
			window.Select_pitch_sign_norm.margin_left = HEADING.input_margins;
			window.Select_pitch_sign_norm.label_width = input_label_width;
			window.Select_pitch_sign_norm.construct('pitch_sign_norm','linear',MSG(['parameters','pitch_sign']),GIWIK.data.attitude_convention._pitch_sign_norms,array_map(function(value){return MSG(['parameters',value]);}, GIWIK.data.attitude_convention._pitch_sign_norms),'',true);
			window.Select_pitch_sign_norm.enable();
		}
	};
}