// Plugin sensor_control

GIWIK.init.js(['css','msg'], 'sensor_control');

switch (HEADING.name)
{
	case 'sensor_control':
		HEADING.is_external_popup = true;

		HEADING.display._plugins.sensor_control = function ()
		{
			// Fait prendre toute la place disponible au champ de texte
			$('#sensor_data,#sensor_request').css({'width': $(window).width()-160,'min-width': 380});
			$('#sensor_data').css('height', $(window).height()-($('#sensor_request').length == 0 ? 200 : 382));

			if (GIWIK._context.ie)
			{
				$('#sensor_data').css('height', this.height()-5);
			}
		};

		// Activation Sensor Data: Timer pour récupération données senseur
		HEADING.sensorControlEnable = function ()
		{
			// Controle Senseur activé
			HEADING.sensorcontrolenabled = true;

			// Boutton utilisé pour déactivé controle senseur
			window.SensorControlEnable.setLabel(MSG(['buttons','stop_capture']));

			// Si aucune valeur définie pour le timer des capteurs externes
			if (typeof GIWIK._plugins.sensor_control.timeout == 'undefined')
			{
				GIWIK._plugins.sensor_control.timeout = 800;
			}

			// Timer: Get Sensor Data
			GIWIK.setTimer("HEADING.getSensorData();", GIWIK._plugins.sensor_control.timeout, 'window.sensortimer'+window._GET['port']);
		};

		// Désactivation Sensor data: Arret précedent Timer
		HEADING.sensorControlDisable = function ()
		{
			// Stop Timer use to get Sensor Data
			clearInterval(eval("window.sensortimer"+window._GET['port']));

			// Controle Senseur desactivé
			HEADING.sensorcontrolenabled = false;

			// Boutton utilisé pour réactivé controle senseur
			window.SensorControlEnable.setLabel(MSG(['buttons','start_capture']));
		};

		// Initialisation Sensor Data: Efface contenu
		HEADING.sensorControlInitData = function ()
		{
			// Efface contenu du <div> Sensor_Data
			document.getElementById("sensor_data").innerHTML = "";
		};

		// Initialisation Sensor Request: Efface contenu
		HEADING.sensorControlInitReq = function ()
		{
			if (GIWIK._plugins.sensor_control.send_request && window._GET['port']!='CAN' )
			{
				// Efface contenu du <div> Sensor_Req
				document.forms.sensorrequest_form.sensor_request.value = "";
			}
		};

		// GetSensor Data: Lecture données issues senseur (trames protocole)
		HEADING.getSensorData = function ()
		{
			var request = GIWIK.cgifile+"?mode=3"+"&SensorData"+window._GET['port']+"=";

			GIWIK.ajax(request);
		};

		// Set Sensor request: Envoi Requete vers senseur: Ligne par Ligne
		HEADING.setSensorRequest = function ()
		{
			if (GIWIK._plugins.sensor_control.send_request && window._GET['port']!='CAN')
			{
				// Envoi comande vers Firmware qui l'enverra vers senseur...
				var CR_LF = "";
				var request = GIWIK.cgifile+"?mode=4"+"&SensorRequest"+window._GET['port'];


				// Disable bouton lors transmission
				window.LaunchSensorRequest.disable();

				// Lecture Requete entrée par utilisateur
				var sensorrequest = document.forms.sensorrequest_form.sensor_request.value;
				var exp = new RegExp("[\n]","gi");

				// Découpage par ligne
				var _tabreq = sensorrequest.split(exp);


				if (_tabreq !== null && _tabreq.length > 0)
				{
					for (var i=0; i<_tabreq.length; i++)
					{
						// Saut de ligne: CR ( detecte puisque 1 ligne apres)
						if ( i<(_tabreq.length-1) )
						{
							if (window.Checkbox_LF.getValue() == '1')
							{
								CR_LF = "3"; //CR+LF
							}
							else
							{
								CR_LF = "1"; //CR if enter
							}
						}
						// Pas de saut de ligne(derniere ligne)
						else
						{
							CR_LF = "0";
						}

						// Une requete par ligne
						if (_tabreq[i] != "")
						{
							GIWIK.ajax(request + '=' + CR_LF + ',' + escape(_tabreq[i]), {eval_rtxt:true});
						}
					}
				}

				// Enable bouton suite transmission
				window.LaunchSensorRequest.enable();
			}
		};

		// Get Conf: reponse lecture data senseur
		HEADING.readConf._plugins.sensor_control = function ()
		{
			var sensordata = document.getElementById("sensor_data");
			var sensordatamaxsize = 5000;

			// Lecture Reponse Data Senseur
			var sensorframe = System_state['SensorData'+window._GET['port']];

			if (typeof sensorframe == 'undefined')
            {
                return;
            }

			// Décodage Reponse (codée par Firmware)
			sensorframe = unescape(sensorframe);

			// Gestion saut de ligne \r \n --> <br/>
			sensorframe = sensorframe.replace(/[\r\n]/g,"<br/>").replace(/<br\s*\/?><br\s*\/?>/g,"<br/>");


			// Ajout Sensor Datas au Txt du <div>
			sensordata.innerHTML = sensordata.innerHTML + sensorframe;

			// Nb Char borné !!
			if (sensordata.innerHTML.length > sensordatamaxsize)
			{
				// Récupération N dernier carcatères lus
				sensordata.innerHTML = sensordata.innerHTML.substr(sensordata.innerHTML.length-sensordatamaxsize, sensordatamaxsize);

				// Découpage propre au premier <br/>
				var br_pos = sensordata.innerHTML.indexOf("<br/>",0)+4;

				sensordata.innerHTML = sensordata.innerHTML.substr(br_pos, sensordata.innerHTML.length-br_pos);
			}
		};

		HEADING.construct._plugins.sensor_control = function ()
		{
			var cnt = ''

			// BoxSensor Data
			+'<table><tr>\n'
				+'<td>\n'
					+'<div id="sensor_data"></div>\n'
				+'</td>\n'
				+'<td>\n'
					+'<div id="sensorcontrol_enable"></div>\n'
					+'<div id="sensorcontrol_initdata"></div>\n'
				+'</td>\n'
			+'</tr></table>\n';

			// Info: Protocole et Port
			var info = "";
			info += MSG(['parameters','protocol']) + ": ";
			info += decodeURIComponent(window._GET['protocol']).replace(/_/g,' ');
			info += "   -   ";
			info += MSG(['parameters','port']) + ": ";
			info += GIWIK._input_ports_label[array_search(window._GET['port'], GIWIK._input_ports)];

			// Construction de la boite
			$('#content').append(GIWIK.box(cnt, MSG(['box','sensorcontroldata_title'])+' <span class="box_titleinfoi">'+info+'</span>', false, ['box_sensordata'], ['', 'box_content_nopadding']));


			if (GIWIK._plugins.sensor_control.send_request && window._GET['port']!='CAN')
			{
				// Box Sensor Request
				cnt = '<table>'
					+'<tr>'
						+'<td>'
							+'<div><form name="sensorrequest_form"><textarea id="sensor_request"></textarea></form></div>'
						+'</td>'
						+'<td>'
							+'<div id="sensorcontrol_request" class="displaynone"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
				+'<div id="checkbox_lf"></div>';

				// Construction de la boite
				$('#content').append(GIWIK.box(cnt, MSG(['box','sensorcontrolrequest_title']), false, ['box_sensorrequest'], ['', 'box_content_nopadding']));
			}

			cnt = null;



			// Enable Sensor Data Viewer Button
			window.SensorControlEnable = new Button('SensorControlEnable', true);
			window.SensorControlEnable.margin = '0px 0px 0px 5px';
			window.SensorControlEnable.construct('sensorcontrol_enable',MSG(['buttons','start_capture']),'mini');
			window.SensorControlEnable.setAction('if (HEADING.sensorcontrolenabled) {HEADING.sensorControlDisable();} else {HEADING.sensorControlEnable();}');
			window.SensorControlEnable.enable();
			window.SensorControlEnable.show();

			// Init Sensor Data button
			window.SensorControlInitData = new Button('SensorControlInitData', true);
			window.SensorControlInitData.margin = '20px 0px 0px 5px';
			window.SensorControlInitData.construct('sensorcontrol_initdata',MSG(['buttons','clear']),'mini');
			window.SensorControlInitData.setAction('HEADING.sensorControlInitData();');
			window.SensorControlInitData.enable();
			window.SensorControlInitData.show();


			if (GIWIK._plugins.sensor_control.send_request && window._GET['port']!='CAN')
			{
				// Paramètre Envoi LF vers senseur
				window.Checkbox_LF = new Input_checkbox('Checkbox_LF', true);
				window.Checkbox_LF.margin = '10px 0 0 8px';
				window.Checkbox_LF.construct('checkbox_lf','linear',MSG(['parameters','lf']),['0','1'],false);
				window.Checkbox_LF.label_path.style.fontWeight = 'normal';
				window.Checkbox_LF.setValue('1');
				window.Checkbox_LF.enable();
				window.Checkbox_LF.show();

				// Bouton pour envoi requête
				window.LaunchSensorRequest = new Button('LaunchSensorRequest', true);
				window.LaunchSensorRequest.margin = '12px 0px 0px 5px';
				window.LaunchSensorRequest.construct('sensorcontrol_request',MSG(['buttons','send_request']),'mini');
				window.LaunchSensorRequest.setAction('HEADING.setSensorRequest();HEADING.sensorControlInitReq();');
				window.LaunchSensorRequest.enable();
				window.LaunchSensorRequest.show();
			}



			// Par défaut: reset Sensor Control
			HEADING.sensorControlInitData();
			HEADING.sensorControlEnable();
		};
		break;

	default:
		// Ouverture du popup de contrôle du capteur externe
		HEADING.launchSensorControl = function (port, protocol_label)
		{
			var window_width;
			var window_height;

			if (GIWIK._plugins.sensor_control.send_request && window._GET['port']!='CAN')
			{
				window_width = 590;
				window_height = 545;
			}
			else
			{
				window_width = 590;
				window_height = 360;
			}


			// Ouverture Fenetre Sensor Control
			GIWIK.window.open("../sensor_control/?port="+window.current_port+"&protocol="+encodeURIComponent(protocol_label.trim()), GIWIK.system_name+"_sensor_control"+port, window_width, window_height, 10, (screen.width-(window_width+20)), "toolbar=0, menubar=0, status=0, resizable=1, scrollbars=1");
		};

		// Construction spécifique du groupe de paramètres pour l'ouverture du popup de contrôle du capteur externe
		HEADING.constructParamSensorControl = function (href_jscode)
		{
			GIWIK.paramGroup.construct('params_sensorcontrol', MSG(['box','params_sensorcontrol']), 'link:'+href_jscode);
		};
		break;
}
