// GIWIK CSS

// NOTES --------------------------------------------------------------------------------------------------------------------------------------------------------------------
// "night_mode" et "color_background" sont définies au plus tôt dans giwik.app.js > GIWIK.init.beforeLoadEvent
//   -> pour éviter un effet de flash au chargement de la page sous WebKit/Blink
// GIWIK.css.init('night_mode',                    (STORAGE.get('night_mode') === true) ? true : false);
// GIWIK.css.init('color_background',              (GIWIK.css.night_mode) ? GIWIK.css.RGBA(0,0,0,1) : GIWIK.css.RGBA(255,255,255,1));

// DÉFINITION DES COULEURS --------------------------------------------------------------------------------------------------------------------------------------------------

GIWIK.css.init('graphic_charter',                  'blue');

GIWIK.css.init('color_suffix',                     '_'+GIWIK.css.graphic_charter);
GIWIK.css.init('night_suffix',                     (GIWIK.css.night_mode) ? '_night' : '');

// Exécution de la fonction de surcharge css
GIWIK.init.css();

GIWIK.css.init('color_main',                       (GIWIK.css.graphic_charter == 'green') ? GIWIK.css.RGBA(87,107,13,1)   : ((GIWIK.css.night_mode) ? GIWIK.css.RGBA(0,123,165,1) : GIWIK.css.RGBA(0,81,146,1))); // ancien bleu 0,63,128
GIWIK.css.init('color_text_std',                   (GIWIK.css.night_mode)                 ? GIWIK.css.RGBA(215,215,215,1) : GIWIK.css.RGBA(51,51,51,1));
GIWIK.css.init('color_text_disabled',              (GIWIK.css.night_mode)                 ? GIWIK.css.RGBA(102,102,102,1) : GIWIK.css.RGBA(204,204,204,1));
GIWIK.css.init('color_text_param',                 (GIWIK.css.night_mode)                 ? GIWIK.css.RGBA(170,170,170,1) : GIWIK.css.RGBA(102,102,102,1));
GIWIK.css.init('color_bg_soft_grey',               (GIWIK.css.night_mode)                 ? GIWIK.css.RGBA(70,70,70,1)    : GIWIK.css.RGBA(230,230,230,1));
GIWIK.css.init('color_0',                          (GIWIK.css.night_mode)                 ? GIWIK.css.RGBA(100,100,100,1) : GIWIK.css.RGBA(153,153,153,1));
GIWIK.css.init('color_1',                          (GIWIK.css.graphic_charter == 'green' && GIWIK.css.night_mode) ? GIWIK.css.RGBA(131,159,20,1) : GIWIK.css.color_main);
GIWIK.css.init('color_2',                          GIWIK.css.RGBA(255,136,0,1));
GIWIK.css.init('color_3',                          GIWIK.css.RGBA(238,0,0,1));
GIWIK.css.init('color_top_bg',                     (GIWIK.css.graphic_charter == 'green') ? GIWIK.css.RGBA(87,107,13,1)   : ((GIWIK.css.night_mode) ? GIWIK.css.RGBA(55,55,55,1) : GIWIK.css.RGBA(126,124,131,1)));
GIWIK.css.init('color_top_menu',                   (GIWIK.css.night_mode) ? GIWIK.css.RGBA(215,215,215,1) : GIWIK.css.RGBA(238,238,238,1));
GIWIK.css.init('color_top_menui',                  (GIWIK.css.graphic_charter == 'green') ? GIWIK.css.RGBA(142,149,116,1) : GIWIK.css.color_1);
GIWIK.css.init('color_menu',                       (GIWIK.css.night_mode) ? GIWIK.css.RGBA(215,215,215,1) : GIWIK.css.RGBA(255,255,255,1));
GIWIK.css.init('color_mainmenu',                   GIWIK.css.color_menu);
GIWIK.css.init('color_mainmenu_bg',                (GIWIK.css.graphic_charter == 'green') ? GIWIK.css.RGBA(142,149,116,1) : ((GIWIK.css.night_mode) ? GIWIK.css.RGBA(65,65,65,1) : GIWIK.css.RGBA(153,153,153,1)));
GIWIK.css.init('color_subheading',                 GIWIK.css.color_menu);
GIWIK.css.init('color_subheading_bg',              (GIWIK.css.graphic_charter == 'green') ? GIWIK.css.RGBA(153,160,125,1) : ((GIWIK.css.night_mode) ? GIWIK.css.RGBA(68,68,68,1) : GIWIK.css.RGBA(170,170,170,1)));

GIWIK.css.init('color_button_bg',                  GIWIK.css.color_0);
GIWIK.css.init('color_button_text',                GIWIK.css.color_menu);
GIWIK.css.init('color_button_texti',               GIWIK.css.color_menu);

GIWIK.css.init('color_submenu',                    (GIWIK.css.night_mode) ? GIWIK.css.RGBA(204,204,204,1) : GIWIK.css.RGBA(255,255,255,1));
GIWIK.css.init('color_submenu_line',               (GIWIK.css.night_mode) ? GIWIK.css.RGBA(40,40,40,1)    : GIWIK.css.RGBA(220,220,220,1));
GIWIK.css.init('color_submenu_bg',                 (GIWIK.css.night_mode) ? GIWIK.css.RGBA(30,30,30,1)    : GIWIK.css.RGBA(180,180,180,1));

GIWIK.css.init('color_status_line',                (GIWIK.css.night_mode) ? GIWIK.css.RGBA(51,51,51,1)    : GIWIK.css.RGBA(221,221,221,1));

GIWIK.css.init('color_input_cells_bg',             (GIWIK.css.night_mode) ? GIWIK.css.RGBA(70,70,70,1)    : GIWIK.css.RGBA(221,221,221,1));
GIWIK.css.init('color_input_cells_over',           (GIWIK.css.night_mode) ? GIWIK.css.RGBA(204,204,204,1) : GIWIK.css.RGBA(240,240,240,1));

GIWIK.css.init('color_expertview_datagroup_bg',    (GIWIK.css.night_mode) ? GIWIK.css.RGBA(51,51,51,1)    : GIWIK.css.RGBA(233,233,233,1));
GIWIK.css.init('color_expertview_datagroup_label', (GIWIK.css.night_mode) ? GIWIK.css.RGBA(204,204,204,1) : GIWIK.css.RGBA(102,102,102,1));

GIWIK.css.init('color_input_box_shadow',           GIWIK.css.color_1.replace(/,[^,\)]+\)$/,',0.5)'));
GIWIK.css.init('input_box_shadow',                 'box-shadow: -3px  0px 4px '+GIWIK.css.color_input_box_shadow+','
														+' 0px -3px 4px '+GIWIK.css.color_input_box_shadow+','
														+' 3px  0px 4px '+GIWIK.css.color_input_box_shadow+','
														+' 0px  3px 4px '+GIWIK.css.color_input_box_shadow+';');

GIWIK.css.init('viewport',                         ((GIWIK._context.mobile_device)
													? ((GIWIK.css_compactmode) ? 630 : 810)
													: ((GIWIK._context.ipad) ? ((GIWIK.css_compactmode) ? 810 : 810)
													: false)));

document.write
(
	// Ecriture du favicon
	'<link rel="shortcut icon" href="'+GIWIK.directories.img+'/favicon.'+(GIWIK._context.ie <= 9 ? 'ico' : 'png')+'">'
	// Si défini, ajout de la balise meta "viewport" pour un zoom optimal
	+(GIWIK.css.viewport  ? '<meta name="viewport" content="width='+GIWIK.css.viewport+', user-scalable=no">' : '') //,height=device-height
	+(GIWIK._context.ios ? '<meta name="apple-mobile-web-app-capable" content="yes"><meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">'      : '')//
);


/// !!! Note : Chrome bug quand la déclaration de la variable "s" est trop longue --> on fragmente de temps en temps avec "window.giwik_css+='"

window.giwik_css = ''

+'@font-face'
+'{'
	+'font-family: \'Ethnocentric\';'
	+(GIWIK._context.ie < 9 ? 'src: url(\''+GIWIK.directories.fonts+'/ethnocentric.eot\');' : '') // IE8-
	+'src: url(\''+GIWIK.directories.fonts+'/ethnocentric.woff\') format(\'woff\');' // tous navigateurs et IE9+
	+'font-weight: normal;'
	+'font-style: normal;'
+'}'

+'@font-face'
+'{'
	+'font-family: \'Blair\';'
	+'src: url(\''+GIWIK.directories.fonts+'/blair.woff\') format(\'woff\');' // tous navigateurs et IE9+
	+'font-weight: bold;'
	+'font-style: normal;'
+'}'

// +'@viewport'
// +'{'
// 	+'zoom: 100%;'
// +'}'

// SUPPRESSION PAR DEFAUT DE TOUTES LES MARGES ET DES POINTILLÉS DE FOCUS *************************
+'* {margin:0; padding:0;outline:0;}'

+'input:focus,'
+'select:focus,'
+'textarea:focus'
+'{'
	+GIWIK.css.input_box_shadow
	+'outline:0;'
+'}'

// BALISES PRINCIPALES *********************************************************************************************************************************************
+'html'
+'{'
	+'width: 100%;'
	// +'-ms-zoom: 0.8;'
	+'color: '+GIWIK.css.color_text_std+';'
	+'font: 12px Arial, sans-serif;'
	+'overflow-y: scroll;'
	+'background: '+GIWIK.css.color_background+';'

	// Zoom de la page : à améliorer
	// +'zoom: 125%;'
	// +'transform:  scale(1.5);'
	// +'transform-origin: left top;'

	// BOX-SIZING à tester
	// +'box-sizing: border-box;'
+'}'

// BOX-SIZING à tester
// +'*, *:before, *:after {box-sizing: inherit;}'

+'body'
+'{'
	+'width: 100%;'

	+'min-width:480px;'
	+'background: '+GIWIK.css.color_background+';'
+'}'
+'#external_popup_padding'
+'{'
	+'padding: 10px 10px 0px 10px;'
+'}'

+'a:link'
+'{'
	+'color: '+GIWIK.css.color_text_std+';'
	+'text-decoration: none;'
+'}'
+'a:visited'
+'{'
	+'color: '+GIWIK.css.color_text_std+';'
	+'text-decoration: none;'
+'}'
+'a:hover'
+'{'
	+'color:'+GIWIK.css.color_1+';'
	+'text-decoration: none;'
+'}'

+'table,td'
+'{'
	+'border:solid 0px #000000;'
	+'border-collapse: collapse;'
+'}'

+'h1'
+'{'
	+'display: inline;'
+'}'

+'ul,li'
+'{'
	+'list-style-type: none;'
+'}'

+'a.underline:link		{color: '+GIWIK.css.color_text_std+'; text-decoration:underline;}'
+'a.underline:visited	{color: '+GIWIK.css.color_text_std+'; text-decoration:underline;}'
+'a.underline:hover		{color: '+GIWIK.css.color_1+'; text-decoration:underline;}'

// CLASSES D'ETAT D'ELEMENTS TEXTE ********************************************************************************************************************************

+'.status_0, .state_0 {color: '+GIWIK.css.color_0+';}'	// etat inactif
+'.status_1, .state_1 {color: '+GIWIK.css.color_1+';}'	// etat ok
+'.status_2, .state_2 {color: '+GIWIK.css.color_2+';}'  // etat warning
+'.status_3, .state_3 {color: '+GIWIK.css.color_3+';}'	// etat erreur

// LABEL DES PARAMETRES STATIQUES (qui n'utilisent pas les objets Input_X) *******************************************************************************************************
+'.parameter_label,'
+'.parameter_unit'
+'{'
	+'color:'+GIWIK.css.color_1+';'
	+'font: bold 12px/12px arial;'
+'}'

+'.parameter_value'
+'{'
	+'color:'+GIWIK.css.color_1+';'
	+'font: bold 15px/12px arial;'
+'}'

// CLASSES D'ETAT DE BORDURES ET FONDS D'ELEMENTS ********************************************************************************************************************************

+'.bg_status_0, .bg_state_0 {background-color: '+GIWIK.css.color_0+';}' // etat inactif
+'.bg_status_1, .bg_state_1 {background-color: '+GIWIK.css.color_1+';}' // etat ok
+'.bg_status_2, .bg_state_2 {background-color: '+GIWIK.css.color_2+';}' // etat warning
+'.bg_status_3, .bg_state_3 {background-color: '+GIWIK.css.color_3+';}' // etat erreur

// etat inactif
+'.border_status_0,'
+'.border_state_0'
+'{'
	+'border: solid 4px #BBBBBB;'
	+'border-radius: 10px;'
+'}'
	// bordure invisible
	+'.border_status_0inv,'
	+'.border_state_0inv'
	+'{'
		+'border: solid 4px transparent;'
	+'}'
// etat ok
+'.border_status_1,'
+'.border_state_1'
+'{'
	+'border: solid 4px '+GIWIK.css.color_1+';'
	+'border-radius: 10px;'
+'}'
	// bordure invisible
	+'.border_status_1inv,'
	+'.border_state_1inv'
	+'{'
		+'border: solid 4px transparent;'
	+'}'
// etat warning
+'.border_status_2,'
+'.border_state_2'
+'{'
	+'border: solid 4px '+GIWIK.css.color_2+';'
	+'border-radius: 10px;'
+'}'
	// bordure invisible
	+'.border_status_2inv,'
	+'.border_state_2inv'
	+'{'
		+'border: solid 4px transparent;'
	+'}'
// etat erreur
+'.border_status_3,'
+'.border_state_3'
+'{'
	+'border: solid 4px '+GIWIK.css.color_3+';'
	+'border-radius: 10px;'
+'}'
	// bordure invisible
	+'.border_status_3inv,'
	+'.border_state_3inv'
	+'{'
		+'border: solid 4px transparent;'
	+'}';


// CLASSES D'AFFICHAGE ET DE POSITIONNEMENT D'ELEMENTS ************************************************************************************************************
window.giwik_css += ''
+'.displaynone     {display: none;}'
+'.displaytable    {display: table;}'
+'.displayblock    {display: block;}'
+'.hidden          {visibility: hidden;}'
+'.visible         {visibility: visible;}'
+'.floatleft       {float: left;}'
+'.floatright      {float: right;}'
+'.clearboth       {clear: both;}'
+'.valignmiddle    {vertical-align: middle;}'
+'.fullwidth       {width: 100%;}'
+'.bold            {font-weight: bold;}'
+'.italic          {font-style: italic;}'
+'.underline       {text-decoration: underline;}'
+'.textaligncenter {text-align: center;}'
+'.backgroundnone  {background-color: #FF0000;}'

+'a.targetblank:link'
+'{'
	+'padding-right: 15px;'
	+'background: right 3px no-repeat url('+GIWIK.directories.img+'/target_blank'+GIWIK.css.night_suffix+'.gif);'
+'}'
+'a.targetblank:visited'
+'{'
	+'padding-right: 15px;'
	+'background: right 3px no-repeat url('+GIWIK.directories.img+'/target_blank'+GIWIK.css.night_suffix+'.gif);'
+'}'
+'a.targetblank:hover'
+'{'
	+'padding-right: 15px;'
	+'background: right 3px no-repeat url('+GIWIK.directories.img+'/target_blanki'+GIWIK.css.color_suffix+GIWIK.css.night_suffix+'.gif);'
+'}'

// NOTATIONS ******************************************************************************************************************************************************
// Notation d'écart type en ligne : (± xxxx) après une valeur
+'.stddev_inline'
+'{'
	+'padding-left:10px;'
	+'font: italic 11px arial;'
+'}'

// Notations d'écart type standard (sans marges)
+'.stddev'
+'{'
	+'font: italic 11px arial;'
+'}';

// SOUS MENUS *****************************************************************************************************************************************************
window.giwik_css += ''
+'#submenu'
+'{'
	//+'width:200px;'
	+'margin:30px auto 0 auto;'
	+'padding: 0px 0px 0px 0px;'
	+'text-align: center;'
	+'font: bold 12px/24px verdana;'
	+'text-transform: uppercase;'
	// +'border-left : solid 5px '+GIWIK.css.color_submenu_line+';'
	// +'border-right : solid 5px '+GIWIK.css.color_submenu_line+';'
	+'background:'+GIWIK.css.color_submenu_bg+';'
	+'position:absolute;'
	+'width:100%;'
	+'left:0;'
+'}'
+'#submenu a'
+'{'
	+'margin: 5px auto 5px auto;'
	+'display: table;'
	+'width:auto;'
	+'white-space:nowrap;'
	// +'min-width: 125px;'
	+'padding: 0 20px;'
	+'color:'+GIWIK.css.color_submenu+';'
	+'text-decoration: none;'
	// +'border-radius: 2px;'
	// +'background: '+GIWIK.css.color_submenu+';'
+'}'
	+'#submenu a:hover'
	+'{'
		+'color: '+GIWIK.css.color_1+';'
		+'text-decoration: none;'
	+'}'

+'.submenu_arrow'
+'{'
	+'font-size:15px;'
	+'line-height:10px;'
+'}';


// EN-TETE *********************************************************************************************************************************************************
window.giwik_css += ''
+'#header'
+'{'
	+'margin-bottom:11px;'
	+'box-shadow: 0px 5px 8px rgba(0,0,0,0.1);' // flat design'
+'}'

+'.header_full,'
+'.header_medium,'
+'.header_small'
+'{'
+'}'

+'#top_bg'
+'{'
	+'display: table;'
	+'width: 100%;'
	+'background: '+GIWIK.css.color_top_bg+';'
+'}'

+'#top_ctnr'
+'{'
	+'margin: 0px auto 0px auto;'
	+'cursor: default;' // VS curor text d'IE
+'}'

+'.top_ctnr_full'
+'{'
	+'width: 760px;'
	+'height: 39px;'
+'}'
+'.top_ctnr_fullcompact'
+'{'
	+'width: 616px;'
	+'height: 39px;'
+'}'
+'.top_ctnr_medium'
+'{'
	+'width: 100%;'
	+'height: 39px;'
+'}'
+'.top_ctnr_small,'
+'.top_ctnr_smallcompact'
+'{'
	+'height: 24px;'
+'}'

+'div.logoixblue_full,'
+'div.logoixblue_medium'
+'{'
	+'float: left;'
	+'width: 148px;'
	+'height: 20px;'
	+'margin: 9px 0px 0px 0px;'
+'}'
+'div.logoixblue_full img,'
+'div.logoixblue_medium img'
+'{'
	+'height: 20px;'
+'}'
+'div.logoixblue_small'
+'{'
	+'float: left;'
	+'width: 101px;'
	+'height: 15px;'
	+'margin: 4px 0px 0px 6px;'
+'}'
+'div.logoixblue_small img'
+'{'
	+'height: 15px;'
+'}'

+'#logoixblue img'
+'{'
	+(GIWIK.css.night_mode ? 'opacity: 0.8;' : '')
+'}';

// menu secondaire en haut a droite
window.giwik_css += ''
+'.topmenu_full,'
+'.topmenu_medium,'
+'.topmenu_small'
+'{'
	+'float: right;'
	+'display: table;'
	+'text-align: right;'
	+'color: #EEEEEE;'
	+'white-space: nowrap;'
+'}'
	+'.topmenu_full,'
	+'.topmenu_medium'
	+'{'
		+'font: normal 10px Verdana;'
		+'margin: 8px 0px 0px 0px;'
	+'}'
	+'.topmenu_small'
	+'{'
		+'font: normal 10px Arial;'
		+'margin: 4px 6px 0px 0px;'
	+'}'

	+'.topmenu_full .topmenu_spacer,'
	+'.topmenu_medium .topmenu_spacer,'
	+'.topmenu_small .topmenu_spacer'
	+'{'
		+'margin: 0px 5px 0px 5px;'
	+'}'
	+'#topmenu a'
	+'{'
		+'color: '+GIWIK.css.color_top_menu+';'
		+'text-decoration: none;'
		+'text-transform: lowercase;'
	+'}'
	+'#topmenu a:hover'
	+'{'
		+'color: '+GIWIK.css.color_top_menui+';'
	+'}'

+'.mainmenu_bg'
+'{'
	+'background: '+GIWIK.css.color_mainmenu_bg+';'
	+'height: 24px;'
	+'cursor: default;' // VS curor text d'IE
+'}'

+'.mainmenu_ctnr_full,'
+'.mainmenu_ctnr_fullcompact'
+'{'
	+'margin: 0px auto 0px auto;'
	+'padding: 4px 0px 6px 0px;'
+'}'
	+'.mainmenu_ctnr_full {width: 760px;}'
	+'.mainmenu_ctnr_fullcompact {width: 616px;}'

+'.mainmenu_ctnr_medium'
+'{'
	+'padding: 4px 0px 6px 0px;'
+'}'
+'.mainmenu_ctnr_small,.mainmenu_ctnr_smallcompact'
+'{'
	+'padding: 5px 0px 6px 0px;'
+'}'

+'.mainmenu_full,'
+'.mainmenu_medium,'
+'.mainmenu_small'
+'{'
	+'color: #FFFFFF;'
	+'text-align: center;'
	+'white-space: nowrap;'
	+'cursor: default;'
	+'margin: 0;'
+'}'

+'.mainmenu_full,'
+'.mainmenu_medium'
+'{'
	+'font: bold 12px Verdana;'
	+'cursor: default;'
+'}'
	+'.mainmenu_full span,'
	+'.mainmenu_medium span'
	+'{'
		+'font-weight: normal;'
		+'width: 5px;'
	+'}'
	+'.mainmenu_full a,'
	+'.mainmenu_medium a'
	+'{'
		+'padding: 4px 12px 6px 12px;'
	+'}'

+'.mainmenu_small'
+'{'
	+'font: bold 11px Arial;'
+'}'
	+'.mainmenu_small span'
	+'{'
		+'font: normal 11px Verdana;'
	+'}'
	+'.mainmenu_small a'
	+'{'
		+'padding: 5px 6px 7px 6px;'
	+'}'

+'#buttonright_ctnr>div'
+'{'
	+'float:right;'
+'}'

+'a.heading,'
+'a.headingactive'
+'{'
	+'color: '+GIWIK.css.color_mainmenu+';'
	+'text-decoration: none;'
	+'white-space: nowrap;'
	+'text-transform: uppercase;'
	+'cursor: pointer;'
+'}'
	+'a.heading:hover,a.headingactive {color: '+GIWIK.css.color_main+';}';

// SOUS-MENUS
window.giwik_css += ''
+'.subheading_full,'
+'.subheading_medium,'
+'.subheading_small'
+'{'
	+'display: table;'
	+'position: absolute;'
	+'top: 0px;'
	+'left: 0px;'
	+'font-weight: bold;'
	+'font-size: 11px;'
	+'background: '+GIWIK.css.color_subheading_bg+';'
	+'border-right: solid 1px #909090;'
	+'border-left: solid 1px #909090;'
	+'border-bottom: solid 1px #909090;'
	+'border-radius: 0 0 4px 4px;'
	+'box-shadow: 0px 5px 15px rgba(0,0,0,0.3);'
	+'text-transform: uppercase;'
	+'z-index: 2;'
  	+'opacity: 0.95;'
+'}'
	+'.subheading_full,'
	+'.subheading_medium'
	+'{'
		+'font-family: Verdana;'
	+'}'
	+'.subheading_small'
	+'{'
		+'font-family: Arial;'
	+'}'


+'a.subheading,a.subheading_last,'
+'a.subheadingi,a.subheadingi_last'
+'{'
	+'display: block;'
	+'color:'+GIWIK.css.color_subheading+';'
	+'text-decoration: none;'
	+'text-transform: uppercase;'
	+'padding: 8px 14px 4px 14px;'
+'}'
	+'a.subheading_last {border-radius: 0 0 4px 4px;padding-bottom:8px;}'
	+'a.subheading:hover,a.subheadingi,a.subheading_last:hover,a.subheadingi_last {color:'+GIWIK.css.color_1+';}';


// BALISE CONTENU (sous le logo produit) **************************************************************************************************************************
window.giwik_css += ''
+'.content'
+'{'
	+'margin: 0px auto 0px auto;'
	+'cursor: default;'
	+'text-align: center;'
+'}'

// CONTROLE PRINCIPAL *********************************************************************************************************************************************
//+'/*DEBUG*/ #contenttop{outline:solid 2px #0F0;}'
//+'/*DEBUG*/ #maincontrol_ctnr{outline:solid 2px red;}'

+'#contenttop'
+'{'
	+'display: table;'
	+'margin-left: auto;'
	+'margin-right: auto;'
	+'cursor: default;' // VS curseur texte d'IE7
	//background: #FFDDDD;
+'}'

/*+'#contenttop>table td:first-child'
+'{'
	+'background: orange;'
+'}'*/
+'.contenttop_full'
+'{'
	+'width: 760px;'
+'}'
+'.contenttop_fullcompact'
+'{'
	+'width: 616px;'
+'}'
+'.contenttop_medium'
+'{'
	+'width: 632px;'
+'}'
	+'.contenttop_full>table,'
	+'.contenttop_fullcompact>table,'
	+'.contenttop_medium>table'
	+'{'
		+'width:100%;'
		+'height:135px;'
		+'margin: 7px auto 10px auto;'
	+'}'
	+'.contenttop_medium>table'
	+'{'
		+'width:auto;'
		+'height:135px;'
		+'margin: 7px auto 10px auto;'
	+'}'
+'.contenttop_small'
+'{'
	+'width: 458px;'
+'}'
	+'.contenttop_small>table'
	+'{'
		+'width:auto;'
		//+'height:117px;'
		+'margin: 0px auto 0px auto;'
	+'}'
+'.contenttop_smallcompact'
+'{'
	+'width: 458px;'
	//+'/*DEBUG*/background:pink;'
+'}'
	+'.contenttop_smallcompact>table'
	+'{'
		+'width:100%;'
		+'margin: 0px auto 0px auto;'
	+'}'
+'.contenttop_mini'
+'{'
	+'width: 254px;'
	+'height:60px;'
+'}'
	+'.contenttop_mini>table'
	+'{'
		+'width:auto;'
		+'margin: 5px auto 0px auto;'
		//+'height:135px;'
	+'}'


+'#maincontrol'
+'{'
	+'vertical-align:bottom;'
	+'width: 1px;'
+'}'

// Chevron dans les popups externes
+'.external_popup_chevron'
+'{'
	+'width: 250px;'
	+'margin: 0px auto 0px auto;'
+'}'

// BOUTONS ********************************************************************************************************************************************************
+'.button_ctnr_full,'
+'.button_ctnr_medium'
+'{'
	+'width: 152px;'
	+'padding-top:20px;'
	+'vertical-align: middle;'
+'}'
+'.button_ctnr_small'
+'{'
	+'width: 125px;'
	+'padding-top:19px;'
	+'vertical-align: bottom;'
+'}'
+'.button_ctnr_mini'
+'{'
	+'width: 90px;'
	+'vertical-align: bottom;'
	+'padding-top:10px;'
+'}';
// pas de .button_ctnr_smaller parce que ce format de bouton n'est pas utilisé pour les boutons principaux de contrôle (autour du chevron)


// SWITCH *********************************************************************************************************************************************************
window.giwik_css += ''
+'.switch_0'
+'{'
	+'width: 63px;'
	+'height: 22px;'
	+'background: 0 2px no-repeat url('+GIWIK.directories.img+'/switch_0.gif);'
+'}'

+'.switch_1'
+'{'
	+'width: 63px;'
	+'height: 22px;'
	+'background: 0 2px no-repeat url('+GIWIK.directories.img+'/switch_1'+GIWIK.css.color_suffix+(GIWIK.css.graphic_charter == 'blue' ? GIWIK.css.night_suffix : '')+'.gif);'
+'}'

+'.switch_label,.switch_label_linear'
+'{'
	+'color: '+GIWIK.css.color_1+';'
	+'font: bold 12px arial;'
	+'white-space: nowrap;'
+'}'
	+'.switch_label'
	+'{'
		+'padding-bottom:5px;'
	+'}'
	+'.switch_label_linear'
	+'{'
		+'padding-right:8px;'
	+'}';

// LOGO PRODUIT ***************************************************************************************************************************************************
window.giwik_css += ''

+'#productlogo_ctnr'
+'{'
	+'clear:both;'
	+'text-align:center;'
	+'margin-bottom:5px;'
	//+'user-select: none;'		// pas encore implémenté par Firefox, commenté pour éviter une erreur css dans la console
	+'-moz-user-select: none;'
	+'-khtml-user-select: none;'
	+'-o-user-select: none;'
	+'-webkit-user-select: none;'
	+'-ms-user-select: none;'
	//+'background:pink;'
+'}'
	+'#productlogo_ctnr hr'
	+'{'
		+'position:absolute;'
		+'z-index:0;'
		+'width:100%;'
		+'height:1px;'
		+'border:0;'
		+'border-top:solid 1px '+GIWIK.css.color_main+';'
	+'}'
	+'#productlogo_ctnr span'
	+'{'
		+'position:relative;'
		+'z-index:1;'
		+'color:'+GIWIK.css.color_main+';'
		+'cursor: default;'
		+'font-family: Ethnocentric;'
		+'background-color:'+GIWIK.css.color_background+';'
		//+'background:yellow;'
	+'}'

	+'#productlogo_ctnr div'
	+'{'
		+'display:block;'
		+'margin: 2px auto -5px auto;'
		+'text-align: center;'
		+'font-family: Ethnocentric;'
		+'line-height:13px;'
		+'color:'+GIWIK.css.color_main+';'
		+'cursor: default;'
		//+'background:red;'
	+'}'

+'.productlogo_ctnr_full,'
+'.productlogo_ctnr_medium'
+'{'
	+'margin-top: 0px;' // La table contenant le chevron contient une marge basse pour ce mode
	+'margin-bottom: 2px;'
+'}'
	+'.productlogo_ctnr_full hr,'
	+'.productlogo_ctnr_medium hr'
	+'{'
		+'margin-top: 8px;'
	+'}'
	+'.productlogo_ctnr_full span,'
	+'.productlogo_ctnr_medium span'
	+'{'
		+'padding: 0 6px 0 8px;'
		+'font-size:22px;'
		+'line-height:22px;'
		+'letter-spacing:2px;'
	+'}'
	+'.productlogo_ctnr_full div,'
	+'.productlogo_ctnr_medium div'
	+'{'
		+'font-size:13px;'
		+'line-height:13px;'
		+'padding-top:1px;'
		+'letter-spacing:1px;'
		+'margin-left:10px;'
	+'}'

+'.productlogo_ctnr_small'
+'{'
	+'margin-top: 8px;'
+'}'
	+'.productlogo_ctnr_small hr'
	+'{'
		+'margin-top: 6px;'
	+'}'
	+'.productlogo_ctnr_small span'
	+'{'
		+'padding: 0 5px 0 6px;'
		+'font-size:18px;'
		+'line-height:18px;'
		+'letter-spacing:1px;'
	+'}'
	+'.productlogo_ctnr_small div'
	+'{'
		+'font-size:10px;'
		+'line-height:10px;'
		+'letter-spacing:1px;'
		+'margin-left:1px;'
	+'}'
+'.productlogo_ctnr_mini'
+'{'
	+'margin-top: 6px;'
+'}'
	+'.productlogo_ctnr_mini hr'
	+'{'
		+'margin-top: 6px;'
	+'}'
	+'.productlogo_ctnr_mini span'
	+'{'
		+'padding: 0 4px 0 5px;'
		+'font-size:15px;'
		+'line-height:15px;'
		+'letter-spacing:1px;'
	+'}'
	+'.productlogo_ctnr_mini div'
	+'{'
		+'font-size:10px;'
		+'line-height:10px;'
		+'letter-spacing:1px;'
		+'margin-left:10px;'
	+'}';



// BOITES *********************************************************************************************************************************************************
window.giwik_css += ''
+'.box'
+'{'
	+'margin: 10px auto 20px auto;'
+'}'
+'.box_expertview'
+'{'
	+'margin: 10px auto 0px auto;'
+'}'
+'.box_corner_tl'
+'{'
	+'padding-left: 10px;' // VS BUGS de redimensionnement de FF (a la place de width)
	+'height: 20px;'
	//+'background: '+GIWIK.css.color_background+' repeat-y 0px 9px url('+GIWIK.directories.img+'/box_corner_tl0.png)'
+'}'
+'.box_border_t'
+'{'
	+'padding: 2px 10px 1px 0px;'
	+'color: '+GIWIK.css.color_1+';'
	+'background: repeat-x 0px 9px url('+GIWIK.directories.img+'/box_border0.gif);'
	+'text-align:left;'
+'}'
	+'.box_title'
	+'{'
		+'padding: 0px 5px 3px 2px;'
		+'color: #666666;'
		+'font: bold 13px arial;'
		+'background: '+GIWIK.css.color_background+';'
		+'cursor: default;'
		+'text-transform:uppercase;'
	+'}'
	+'.box_titlei'
	+'{'
		+'padding: 0px 5px 3px 2px;'
		+'font: bold 13px arial;'
		+'color: '+GIWIK.css.color_1+';'
		+'background: '+GIWIK.css.color_background+';'
		+'cursor: default;'
		+'text-transform:uppercase;'
	+'}'
	+'.box_titleinfoi'
	+'{'
		+'padding: 0px 0px 3px 8px;'
		+'font-weight: normal;'
		+'text-transform:none;'
	+'}'
+'.box_corner_tr'
+'{'
	+'padding-left: 10px;'  // VS BUGS de redimensionnement de FF (a la place de width)
	+'background: '+GIWIK.css.color_background+' no-repeat left 9px url('+GIWIK.directories.img+'/box_corner_tr0.png);'
+'}'
+'.box_border_l'
+'{'
	+'padding-left: 10px;' // VS BUGS de redimensionnement de FF (a la place de width)
	+'background: repeat-y left 9px url('+GIWIK.directories.img+'/box_border0.gif);'
+'}'
// contenu d'une boite standard (n'ayant PAS un groupe de paramètre en 1er)
+'.box_content'
+'{'
	+'padding: 16px 0px 14px 0px;'
	+'vertical-align: top;'
	+'text-align:left;'
	+'width: 438px;'
+'}'
// contenu d'une boite ayant un groupe de paramètre en 1er (-> margintop inhérent aux groupes de paramètres)
+'.box_content_nopaddingtop'
+'{'
	+'padding: 2px 0px 14px 0px;'
	+'vertical-align: top;'
	+'text-align:left;'
	+'width: 438px;'
+'}'
// contenu d'une boite compacte (souvent une boite avec bouton à droite, genre boite maintenance restart)
+'.box_content_nopadding'
+'{'
	+'padding: 0px 0px 0px 0px;'
	+'vertical-align: top;'
	+'text-align:left;'
	+'width: 438px;'
+'}'
// contenu des boites avec peu de paramètres (sans groupe de paramètres, comme la page "network")
+'.box_content_halfpadding'
+'{'
	+'padding: 8px 0px 7px 0px;'
	+'vertical-align: top;'
	+'text-align:left;'
	+'width: 438px;'
+'}'
// contenu des boites avec un paramètres isolé en 1er et un groupe de paramètres en dernier
+'.box_content_halfpaddingtop'
+'{'
	+'padding: 8px 0px 14px 0px;'
	+'vertical-align: top;'
	+'text-align:left;'
	+'width: 438px;'
+'}'
// contenu des boites prenant une largeur supérieure
+'.box_content_full'
+'{'
	+'padding: 16px 0px 14px 0px;'
	+'vertical-align: top;'
	+'text-align:left;'
	+'width: 596px;'
+'}'
// contenu des boites s'adaptant à la largeur du contenu
+'.box_content_nowidth'
+'{'
	+'padding: 16px 15px 14px 15px;'
	+'vertical-align: top;'
	+'text-align:left;'
+'}'
// introduction des boites avec bouton à droite
+'.box_leftintro'
+'{'
	+'float:left;'
	+'padding-top: 20px;' // car cette classe s'utilise avec la classe box_content_nopadding
	+'text-align: left;'
	+'width: 330px;'
+'}'


// boite de confirmation
+'.box_content_confirm'
+'{'
	+'padding: 10px 0px 0px 0px;'
	+'vertical-align: top;'
	+'text-align:center;'
	+'width: 250px;'
+'}'
+'.tab_content_confirm_3buttons'
+'{'
	+'width: 344px;'
+'}'
	+'.tab_content_confirm_tdleft'
	+'{'
		+'width: 111px;'
		+'text-align: left;'
	+'}'
	+'.tab_content_confirm_tdcenter'
	+'{'
		+'width: 128px;'
		+'text-align: center;'
	+'}'
	+'.tab_content_confirm_tdright'
	+'{'
		+'width: 105px;'
		+'text-align: right;'
		+'border-left: dotted 1px #CCCCCC;'
	+'}'


+'.box_border_r'
+'{	'
	+'background: repeat-y 9px top url('+GIWIK.directories.img+'/box_border0.gif);'
+'}'
+'.box_corner_bl'
+'{'
	+'height:10px;'
	+'background: '+GIWIK.css.color_background+' no-repeat right top url('+GIWIK.directories.img+'/box_corner_bl0.png);'
+'}'
+'.box_border_b'
+'{'
	+'background: repeat-x left bottom url('+GIWIK.directories.img+'/box_border0.gif);'
+'}'
+'.box_corner_br'
+'{'
	+'background: '+GIWIK.css.color_background+' no-repeat left top url('+GIWIK.directories.img+'/box_corner_br0.png);'
+'}'

// séparateur horizontal pour les boutons cancel/send
+'.separator1'
+'{'
	+'margin: 10px 0px 10px 0px;'
	+'height: 1px;'
	+'border: solid 0px #CCCCCC;'
	+'border-top: dotted 1px #CCCCCC;'
+'}'
// version sans marge haute
+'.separator1_nomargintop'
+'{'
	+'margin: 0px 0px 10px 0px;'
	+'height: 1px;'
	+'border: solid 0px #CCCCCC;'
	+'border-top: dotted 1px #CCCCCC;'
+'}';


// SETTINGS ***********************************************************************************************************************************************
window.giwik_css += ''
+'.input_file_ctnr'
+'{'
	+'margin-top: 10px;'
+'}'
	+'.input_file_ctnr .label'
	+'{'
		+'vertical-align: middle;'
		+'text-align: left;'
		+'white-space:nowrap;'
		+'color:'+GIWIK.css.color_1+';'
		+'font-weight:bold;'
		+'padding-right: 8px;'
	+'}'
	+'.input_file_ctnr .input'
	+'{'
		+'vertical-align: middle;'
		+'text-align: left;'
		+'border-radius: 3px;'
	+'}'
	+'.input_file_ctnr .input_file'
	+'{'
		+'color:'+GIWIK.css.color_1+';'
		+'font-size:12px;'
	+'}'

+'.input_select'
+'{'
	+'color: '+GIWIK.css.color_1+';'
	+'font: bold 12px arial;'
+'}'
	+'.input_select .input_select_mask'
	+'{'
		+'display: none;'
	+'}'
	+'.input_select .label'
	+'{'
		+'padding-bottom: 10px;'
		+'text-align: center;'
		+'white-space: nowrap;'
		+'cursor: default;'
	+'}'
	+'.input_select .label_linear'
	+'{'
		+'padding-right: 8px;'
		+'vertical-align: middle;'
		+'cursor: default;'
		+'white-space: nowrap;'
	+'}'
	+'.input_select .input_select_ctnr'
	+'{'
		+'margin-top: 10px;'
	+'}'
	+'.input_select .input_select_btn_ctnr'
	+'{'
		+'width: 18px;'
		+'vertical-align:middle;'
	+'}'
	+'.input_select .input_select_prev'
	+'{'
		+'width: 18px;'
		+'height: 18px;'
		+'background: no-repeat 6px -2px url('+GIWIK.directories.img+'/input_prev1.gif);'
	+'}'
		+'.input_select .input_select_prev:hover'
		+'{'
			+'background: no-repeat 6px -2px url('+GIWIK.directories.img+'/input_prev1i.gif);'
		+'}'
	+'.input_select .input_select_next'
	+'{'
		+'width: 18px;'
		+'height: 18px;'
		+'background: no-repeat 0px -2px url('+GIWIK.directories.img+'/input_next1.gif);'
	+'}'
		+'.input_select .input_select_next:hover'
		+'{'
			+'background: no-repeat 0px -2px url('+GIWIK.directories.img+'/input_next1i.gif);'
		+'}'
	+'.input_select .input_select_select'
	+'{'
		+'font-weight: bold;'
		+'font-family: arial;'
		+'color: '+GIWIK.css.color_1+';'
		+'background-color: '+GIWIK.css.color_background+';'
		+'border: solid 1px '+GIWIK.css.color_1+';'
		+'border-radius: 3px;'
	+'}'
	+'.input_select .unit'
	+'{'
		+'padding-top: 8px;'
		+'text-align: center;'
		+'cursor: default;'
	+'}'
	+'.input_select .unit_linear'
	+'{'
		+'padding-left: 6px;'
		+'cursor: default;'
	+'}'
	// Firefox only : option groups
	+'.input_select optgroup'
	+'{'
		+'background:'+GIWIK.css.color_bg_soft_grey+';'
		+'color:'+GIWIK.css.color_text_param+';'

		+'font-style:normal;'	//
		+'margin-top:10px;'		//	better layout (Firefox only)
		+'margin-bottom:2px;'	//
		+'padding-left:4px;'	//
	+'}'

	// Cas particulier d'un groupe vide utilisé comme saut de ligne
	+'.input_select optgroup.linebreak'
	+'{'
		+'background:'+GIWIK.css.color_background+';'
		+'margin-top:0px;'		//	better layout (Firefox only)
	+'}'


+'.objmenu0'
+'{'
	+'font: bold 13px arial;'
+'}'
	+'.objmenu0 .mask'
	+'{'
		+'display: block;'
	+'}'
	+'.objmenu0 .separator'
	+'{'
		+'padding: 0px 5px 0px 5px;'
		+'cursor: default;'
	+'}'

+'.objmenu1'
+'{'
	+'font: bold 13px arial;'
+'}'
	+'.objmenu1 .mask'
	+'{'
		+'display: none;'
	+'}'
	+'.objmenu1 .separator'
	+'{'
		+'padding: 0px 5px 0px 5px;'
		+'cursor: default;'
	+'}'

// les arrondis sont gérés dans l'objet
+'a.objmenu,'
+'a.objmenui'
+'{'
	+'color:'+GIWIK.css.color_menu+';'
	+'border:none; display: block;'
	+'text-align: center;'
	+'white-space: nowrap;'
	+'text-decoration:none;'
	+'cursor:pointer;'
+'}'

+'.objmenu_subtitle'
+'{'
	+'font:normal 12px arial;'
	+'color:#888888;'
	+'text-align:center;'
+'}';


// ligne d'entête d'un groupe de paramètres
window.giwik_css += ''
+'.line_param'
+'{'
	+'width:100%;'
	+'margin: 16px 0px 0px 0px;'
	+'cursor: pointer;'
	+'clear:both;'
	//+'background:red;'
+'}'
	+'.line_param td'
	+'{'
		+'vertical-align: middle;'
		+'text-align: left;'
		+'white-space: nowrap;'
		+'color: '+GIWIK.css.color_text_param+';'
	+'}'
	+'.line_param td:hover'
	+'{'
		+'color: '+GIWIK.css.color_1+';'
	+'}'
	+'.line_param .line_param_picto'
	+'{'
		+'display: inline-table;'
		+'vertical-align: top;'
		+'text-align: center;'
		+'font: bold 11px/16px Arial;'
		//+'background:red;'
	+'}'
	+'.line_param .line_param_label'
	+'{'
		+'display: inline-table;'
		+'font: bold 13px Arial;'
		+'white-space: nowrap;'
		+'margin-left: 4px;'
	+'}'
	+'.line_param .line_param_separator'
	+'{'
		+'width: 100%;'
	+'}'
		+'.line_param .line_param_separator>div'
		+'{'
			+'height: 0;'
			+'border: 0;'
			+'margin-top: '+(GIWIK._context.webkit ? '-1px' : '1px')+';'
			+'margin-left: 5px;'
			+'border-bottom: dotted 1px '+GIWIK.css.color_text_param+';'
		+'}';


// tableaux contenant les paramètres
window.giwik_css += ''
+'.three_param_ctnr'
+'{'
	+'width: 100%;'
	+'margin: 0px 0px 0px 0px;'
+'}'
	+'.three_param_potentiometer_ctnr .param1'
	+'{'
		+'width: 45%;'
		+'padding-bottom: 10px;'
	+'}'
	+'.three_param_potentiometer_ctnr .param2'
	+'{'
		+'width: 10%;'
		+'padding-bottom: 10px;'
	+'}'
	+'.three_param_potentiometer_ctnr .param3'
	+'{'
		+'width: 45%;'
		+'padding-bottom: 10px;'
	+'}'

	+'.three_param_potentiometer_ctnr .param3>div'
	+'{'
		+'float: right;'
	+'}'

+'.three_param_potentiometer_ctnr'
+'{'
	+'width: 100%;'
	+'margin: 0px 0px 0px 0px;'
+'}'
	+'.three_param_ctnr .param1'
	+'{'
		+'width: 33%;'
		+'padding-bottom: 10px;'
	+'}'
	+'.three_param_ctnr .param2'
	+'{'
		+'width: 33%;'
		+'padding-bottom: 10px;'
	+'}'
	+'.three_param_ctnr .param3'
	+'{'
		+'width: 33%;'
		+'padding-bottom: 10px;'
	+'}		'

+'.two_param_ctnr'
+'{'
	+'width: 100%;'
	+'margin: 0px 0px 0px 0px;'
+'}'
	+'.two_param_potentiometer_ctnr .param1'
	+'{'
		+'width: 50%;'
		+'padding-bottom: 10px;'
	+'}'
	+'.two_param_potentiometer_ctnr .param2'
	+'{'
		+'width: 50%;'
		+'padding-bottom: 10px;'
	+'}'
+'	'
+'.two_param_potentiometer_ctnr'
+'{'
	+'width: 280px;'
	+'margin: 0px auto 0px auto;'
+'}'
	+'.two_param_potentiometer_ctnr .param1'
	+'{'
		+'width: 139px;'
		+'padding-bottom: 10px;'
	+'}'
	+'.two_param_potentiometer_ctnr .param2'
	+'{'
		+'width: 139px;'
		+'padding-bottom: 10px;'
	+'}'

+'.one_param_ctnr'
+'{'
	+'width: 100%;'
	+'margin: 0px 0px 0px 0px;'
+'}'
	+'.one_param_ctnr .param1'
	+'{'
		+'width: 100%;'
		+'padding-bottom: 10px;'
	+'}'

+'.one_param_linear_ctnr'
+'{'
	+'width: 100px;'
	+'margin: 0px auto 0px auto;'
+'}'
	+'.one_param_linear_ctnr .param1'
	+'{'
		+'width: 100px;'
		+'padding: 0px 67px 10px 0px;'
	+'}'

+'.one_param_potentiometer_ctnr'
+'{'
	+'width: 130px;'
	+'margin: 0px auto 0px auto;'
+'}'
	+'.three_param_ctnr .param1'
	+'{'
		+'width: 130px;'
		+'padding-bottom: 10px;'
	+'}';


// BOUTONS DE VALIDATION / ANNULATION ****************************************************************************************************************************
window.giwik_css += ''
+'#btn_cancel'
+'{'
	+'float: left;'
+'}'
+'#btn_validate'
+'{'
	+'float: right;'
+'}';


// MESSAGES UTILISATEUR ******************************************************************************************************************************************

// message de statut global sur la page control
window.giwik_css += ''
+'#global_msg'
+'{'
	+'padding-top:2px;'
	+'font: normal 12px arial;'
+'	'
+'}'
+'#detailed_msg'
+'{'
	+'position:absolute;'	// Contre les messages trop longs
	+'padding-top:2px;'
	+'font: italic 11px arial;'
	+'white-space: nowrap;' // on force les messages détaillés sur une seule ligne
+'}'

+'.usermsg'
+'{'
	// "text-align" est définit dans l'objet en fonction du paramètre passé
	+'font: bold 12px Arial;'
	+'line-height:20px;'
+'}'
+'.usermsg hr'
+'{'
	+'border:0;'
	+'border-top: solid 1px red;'
	+'margin:10px 0;'
+'}'
// structure du message
+'.usermsg_tab'
+'{'
	+'width: 100%;'
+'}'
	+'.usermsg_tab td'
	+'{'
		+'padding: 10px;'
	+'}'
	+'.usermsg_tab .td_msg'
	+'{'
		+'width: 100%;'
	+'}';


// MINI LED (VOYANT) *******************************************************************************************************************************************
window.giwik_css += ''
+'.led_mini'
+'{'
	+'float:left;'
	+'margin:2px 5px 0px 0px;'
	+'width:11px;'
	+'height:11px;'
	+'border-radius: 1px;'
+'}';


// PICTO NOW LOGGING *************************************************************************************************************************************************
window.giwik_css += ''
+'img.anim_log' // picto animé pour les phases de logging (control, datalogging)
+'{'
	+'vertical-align: top;'
	+'margin: -1px 6px 0px 0px;'
+'}';

// CAPTEURS *****************************************************************************************************************************************************

	window.giwik_css += ''
	+'.sensor,.sensor_0'
	+'{'
		+'margin: 5px 5px 5px 5px;'
	+'}'

	+'.sensor  .sensor_corner_tl,.sensor_0 .sensor_corner_tl'
	+'{'
		+'padding-left: 10px;' // VS BUGS de redimensionnement de FF (a la place de width)
		+'height:10px;'
		+'background: '+GIWIK.css.color_background+' no-repeat right bottom url('+GIWIK.directories.img+'/box_corner_tl0.png);'
	+'}'
	+'.sensor .sensor_border_t,.sensor_0 .sensor_border_t'
	+'{'
		+'padding-left: 115px;'  // VS BUGS de redimensionnement de FF (a la place de width)
		+'background: repeat-x left top url('+GIWIK.directories.img+'/box_border0.gif);'
	+'}'
	+'.sensor .sensor_corner_tr,.sensor_0 .sensor_corner_tr'
	+'{'
		+'padding-left: 10px;'  // VS BUGS de redimensionnement de FF (a la place de width)
		+'background: '+GIWIK.css.color_background+' no-repeat left bottom url('+GIWIK.directories.img+'/box_corner_tr0.png);'
	+'}'
	+'.sensor .sensor_border_l,.sensor_0 .sensor_border_l'
	+'{'
		+'background: repeat-y left top url('+GIWIK.directories.img+'/box_border0.gif);'
	+'}'
	+'.sensor .sensor_content,.sensor_0 .sensor_content'
	+'{'
		+'vertical-align: top;'
	+'}'
	+'.sensor .sensor_border_r,.sensor_0 .sensor_border_r'
	+'{	'
		+'background: repeat-y right top url('+GIWIK.directories.img+'/box_border0.gif);'
	+'}'
	+'.sensor .sensor_corner_bl,.sensor_0 .sensor_corner_bl'
	+'{'
		+'height:10px;'
		+'background: '+GIWIK.css.color_background+' no-repeat right top url('+GIWIK.directories.img+'/box_corner_bl0.png);'
	+'}'
	+'.sensor .sensor_border_b,.sensor_0 .sensor_border_b'
	+'{'
		+'background: repeat-x left bottom url('+GIWIK.directories.img+'/box_border0.gif);'
	+'}'
	+'.sensor .sensor_corner_br,.sensor_0 .sensor_corner_br'
	+'{'
		+'background: '+GIWIK.css.color_background+' no-repeat left top url('+GIWIK.directories.img+'/box_corner_br0.png);'
	+'}'

	+'.sensor_1'
	+'{'
		+'margin: 5px 5px 5px 5px;'
	+'}'

	+'.sensor_1 .sensor_corner_tl'
	+'{'
		+'padding-left: 10px;' // VS BUGS de redimensionnement de FF (a la place de width)
		+'height:10px;'
		+'background: no-repeat right bottom url('+GIWIK.directories.img+'/box_corner_tl1'+GIWIK.css.color_suffix+'.png);'
	+'}'
	+'.sensor_1 .sensor_border_t'
	+'{'
		+'padding-left: 115px;'  // VS BUGS de redimensionnement de FF (a la place de width)
		+'background: repeat-x left top url('+GIWIK.directories.img+'/box_border1'+GIWIK.css.color_suffix+'.gif);'
	+'}'
	+'.sensor_1 .sensor_corner_tr'
	+'{'
		+'padding-left: 10px;'  // VS BUGS de redimensionnement de FF (a la place de width)
		+'background: no-repeat left top url('+GIWIK.directories.img+'/box_corner_tr1'+GIWIK.css.color_suffix+'.png);'
	+'}'
	+'.sensor_1 .sensor_border_l'
	+'{'
		+'background: repeat-y left top url('+GIWIK.directories.img+'/box_border1'+GIWIK.css.color_suffix+'.gif);'
	+'}'
	+'.sensor_1 .sensor_content'
	+'{'
		+'vertical-align: top;'
	+'}'
	+'.sensor_1 .sensor_border_r'
	+'{	'
		+'background: repeat-y right top url('+GIWIK.directories.img+'/box_border1'+GIWIK.css.color_suffix+'.gif);'
	+'}'
	+'.sensor_1 .sensor_corner_bl'
	+'{'
		+'height:10px;'
		+'background: no-repeat right top url('+GIWIK.directories.img+'/box_corner_bl1'+GIWIK.css.color_suffix+'.png);'
	+'}'
	+'.sensor_1 .sensor_border_b'
	+'{'
		+'background: repeat-x left bottom url('+GIWIK.directories.img+'/box_border1'+GIWIK.css.color_suffix+'.gif);'
	+'}'
	+'.sensor_1 .sensor_corner_br'
	+'{'
		+'background: no-repeat left top url('+GIWIK.directories.img+'/box_corner_br1'+GIWIK.css.color_suffix+'.png);'
	+'}'

	+'.led0,.led1,.led2,.led3'
	+'{	'
		+'width: 42px;'
		+'height: 42px;'
		+'margin: 0 auto 0 auto;'
	+'}'
	+'.led0'
	+'{	'
		+'background: '+GIWIK.css.color_background+' no-repeat center top url('+GIWIK.directories.img+'/led0.png);'
	+'}'
	+'.led1'
	+'{	'
		+'background: '+GIWIK.css.color_background+' no-repeat center top url('+GIWIK.directories.img+'/led1'+GIWIK.css.color_suffix+'.png);'
	+'}'
	+'.led2'
	+'{	'
		+'background: '+GIWIK.css.color_background+' no-repeat center top url('+GIWIK.directories.img+'/led2.png);'
	+'}'
	+'.led3'
	+'{	'
		+'background: '+GIWIK.css.color_background+' no-repeat center top url('+GIWIK.directories.img+'/led3.png);'
	+'}'

	+'.led_mini0,.led_mini1,.led_mini2,.led_mini3'
	+'{	'
		+'width: 26px;'
		+'height: 26px;'
	+'}'
	+'.led_mini0'
	+'{	'
		+'background: '+GIWIK.css.color_background+' no-repeat center top url('+GIWIK.directories.img+'/led_mini0.png);'
	+'}'
	+'.led_mini1'
	+'{	'
		+'background: '+GIWIK.css.color_background+' no-repeat center top url('+GIWIK.directories.img+'/led_mini1'+GIWIK.css.color_suffix+'.png);'
	+'}'
	+'.led_mini2'
	+'{	'
		+'background: '+GIWIK.css.color_background+' no-repeat center top url('+GIWIK.directories.img+'/led_mini2.png);'
	+'}'
	+'.led_mini3'
	+'{	'
		+'background: '+GIWIK.css.color_background+' no-repeat center top url('+GIWIK.directories.img+'/led_mini3.png);'
	+'}'

	+'.sensor_name'
	+'{'
		+'text-align: center;'
		+'font: normal 12px Arial;'
		+'padding-top: 5px;'
	+'}'

	+'.sensor_mode'
	+'{'
		+'text-align: center;'
		+'font: italic 11px Arial;'
		+'padding-top: 2px;'
	+'}'

	+'.sensor_info_label'
	+'{'
		+'float: left;'
	+'}'
	+'.sensor_info_value'
	+'{'
		+'float: right;'
	+'}'

	// séparateur données/statuts
	+'.sensor_separator'
	+'{'
		+'margin:7px 0px 9px 0px;'
		+'border-top: dotted 1px #CCCCCC;'
	+'}'
	// Centrage horizontal des senseurs : l'affectation de la classe appropriee se fait dans la methode "Display()" de Heading

// Alerte si désactivation des cookies ****************************************************************************************************
+'#alert_cookies_ctnr'
+'{'
	+'margin:10px auto;'
	+'max-width:800px;'
	+'text-align:center;'
	+'padding:0 10px;'
+'}';


// Ecriture des styles
GIWIK.css.write(window.giwik_css);

// Indique que le chargement du fichier est terminé
GIWIK._files['giwik.css.js'].loaded = true;