/********************************************** GIWIK - Graphical & Interactive Web Interface Kernel *****************************************************/

// Déclaration de l'objet contenant toute la configuration dynamique de GIWIK
window.GIWIK = {};

// Version de GIWIK
GIWIK.giwik_version = "5.76.4";

// S'il s'agit de l'index.html racine
if (document.body) {window.location.replace('./control/?preload=');} else {

// Nom et version du navigateur utilisé pour la qualification
GIWIK._qualified_browser = {name:"firefox", version:37};

// Définition du mode preload
GIWIK.preload_mode = (window.location.search.indexOf('preload=') != -1) ? true : false;

// Définition du mode simulation (activation du simulateur de CGI)
GIWIK.simulation_mode = (document.URL.match(/^https?:\/\/((localhost|127\.0\.0\.1)(:\d+)?)|(([\d\.:]+)\/([^\/]+\/)*(Web_|ICONE[^\/]*\/))/i)) ? true : false;

GIWIK._ext_sensors                = {};		// Contient la liste des éventuels capteurs externes compatibles (pour tableau des entrées)
GIWIK._headings                   = [];		// Rubriques du menu principal
GIWIK._subheadings                = [];		// Sous rubriques du menu principal
GIWIK._secondary_headings         = [];		// Sous rubriques du menu secondaire
GIWIK._http_errors                = {};		// Tableau de stockage des paramètres de requêtes AJAX en cas d'erreur (code réponse HTTP autre que 200)

GIWIK.css 						  = {};		// Gestion des styles

GIWIK.directories                 = {};
GIWIK.directories.root			  = '..';													// Chemin relatif de la racine de l'IHM
GIWIK.directories.giwik			  = GIWIK.directories.root+'/_GIWIK_';						// Chemin relatif du dossier principal de GIWIK
GIWIK.directories.img			  = GIWIK.directories.giwik+'/img';							// Chemin relatif du dossier "img" de GIWIK
GIWIK.directories.img_lva		  = GIWIK.directories.giwik+'/_plugins_/lever_arms/img';	// Chemin relatif du dossier "img" du plugin "lever_arms" de GIWIK
GIWIK.directories.applets		  = GIWIK.directories.giwik+'/applets';						// Chemin relatif du dossier "applets" de GIWIK
GIWIK.directories.plugins_shared  = GIWIK.directories.giwik+'/_plugins_';					// Chemin relatif du dossier des plugins de GIWIK
GIWIK.directories.plugins		  = GIWIK.directories.root+'/_plugins_';					// Chemin relatif du dossier des plugins de la division (défini dans GIWIK.init pour le mode "TRONCS SVN")
GIWIK.directories.fonts			  = GIWIK.directories.giwik+'/fonts';						// Chemin relatif du dossier "fonts" de GIWIK
GIWIK.directories.ctrl			  = (GIWIK.preload_mode) ? './control' : '.';				// Chemin relatif vers le dossier "control"

// Liste des fichiers nécessaires au lancement de la phase d'init
GIWIK._files =
{
	'giwik.js':		{loaded:true },
	'giwik.app.js':	{loaded:false},
	'giwik.inc.js':	{loaded:false},
	'giwik.css.js':	{loaded:false},
	'giwik.msg.js':	{loaded:false},

	'app.js':		{loaded:false}
};

// Tableau des plugins
GIWIK._plugins = {};

// Doit être défini ici pour permettre la définition de GIWIK.init.app
GIWIK.init = function () {GIWIK.init.beforeLoadEvent();};

// Initialisation de la fonction GIWIK.init.app déclarée dans le fichier app.js
GIWIK.init.app = function () {};

// Initialisation de la fonction GIWIK.init.css (optionnelle) déclarée dans le fichier app.js pour la surcharge css
GIWIK.init.css = function () {};

// Initialisation de la propriété WebSocket (activée si plugin chargé)
GIWIK.websocket = {};

// GIWIK.debug : écriture dans la console JavaScript si GIWIK.debug.enabled == true (-> console.log conditionnel)
if (typeof console === 'undefined')	// Pour IE8
{
	GIWIK.debug = function () {};
}
else
{
	(function(){
		var oldLog = console.log;

		console.log = function (message) {

			if ((GIWIK.simulation_mode && GIWIK.debug.enabled) || GIWIK.debug.enabled == 'also_in_prod')
			{
				oldLog.apply(console, arguments);
			}
		};

		GIWIK.debug = console.log;
		console.log = oldLog;
	})();
}

// Si phase de preload, 1ère phase d'écriture pour l'animation de chargement (utile de séparer avec la suite pour être sûr que le logo et le picto loading s'affichent tout de suite, surtout sous WebKit)
if (GIWIK.preload_mode)
{
	GIWIK.preloadPage = function ()
	{
		document.body.innerHTML =
			 '<style>html{overflow-y:scroll;}</style>'
			+'<div id="preload_ctnr" style="position:absolute;top:50%;left:50%;margin:-50px 0 0 -110px;">'
				+'<div id="preload" style="border-radius: 30px;">' // box-shadow:4px 4px 12px rgba(0,0,0,0.3); flat design
					+'<div id="preload_logo" style="position:relative;z-index:3;background:no-repeat center 12px url('+GIWIK.directories.img+'/logo_ixblue.png) #BBBBBB;width:190px;height:44px;border-radius:30px;"></div>'
					+'<div id="preload_anim" style="position:relative;z-index:2;width:100px;height:44px;background:#DDDDDD;border-radius:30px;margin:-44px 0 0px 150px;">'
						+'<img src="'+GIWIK.directories.img+'/loading.gif" style="width:26px;height:26px;margin:9px 0 0 55px;" />'
					+'</div>'
				+'</div>'
				+'<div id="content" style="text-align:center;margin-top:50px;font:normal 13px arial"></div>'
			+'</div>';
	};

	document.title = "IXBLUE";

	if (window.addEventListener)
	{
		window.addEventListener('load', GIWIK.preloadPage, false);
	}
	else	// PLAN B pour IE<9
	{
		window.attachEvent('onload', GIWIK.preloadPage);
	}
}

// 2ème phase d'écriture avec tous les includes
document.write
(
	 '<script src="'+GIWIK.directories.root+'/app.js"></script>'
	+'<script src="'+GIWIK.directories.giwik+'/giwik.app.js"></script>'
);
}