<?php
// // Fonctions génériques, communes à tous les cgi_simulator PHP
// echo 11;
// // Test de la version de PHP (min 5.4)
// try {
//     $array = [];
//     unset($array);
// } catch (Exception $e) {
//     echo "Your PHP version (".phpversion().") is too old to run Web MMI in simulation mode. Please update Wampserver (or Mamp for Mac, Lamp for Linux).";
// }

// Applique des guillemets aux chaines (=> nombres, objets, tableaux, booléens, la valeur null et les strings déjà avec quotes sont exclus)
// Pour le stockage dans la session dous forme de chaine
// function set_quotes ($value)
// {
// 	return preg_match("`^([\"\{\[]|((-?\d+(\.\d+)?|true|false|null)$))`",trim($value)) ? $value : '"'.$value.'"';
// }

// Identifie un tableau PHP dont les clés ne se suivent pas et/ou ne commencent pas par 0.
// Utile pour la génération de code JS : {} à la place de [] si true  (cf. php_to_js_array())
function is_assoc_array ($_php_array)
{
	$is_assoc_array = false;

	if (is_array($_php_array))
	{
		$i = -1;
		foreach($_php_array as $key=>$value)
		{
			$i++;
			if ($key !== $i)
			{
				$is_assoc_array = true;
				break;
			}
		}
	}
	return $is_assoc_array;
}

// Transforme un tableau JavaScript sous formde chaîne en tableau PHP
function js_to_php_array ($_js_array)
{
	// Suppression des [ de début , et ]; de fin
	$_js_array = preg_replace("`^\[(.*)\];?$`","$1",$_js_array);

	$_tmp_array = explode(',',$_js_array);

	$_php_array = [];
	$in_object = false;

	foreach($_tmp_array as $key=>$value)
	{
		if ($in_object)
		{
			$tmp .= ",".$value;

			if (preg_match("`\}\s*$`",$value))
			{
				$in_object = false;
				$value = $tmp;
			}
			else
			{
				continue;
			}
		}
		else if (preg_match("`^\s*\{`",$value))
		{
			$tmp = $value;
			$in_object = true;	// marque qu'on est dans un objet et qu'il faut concaténer les valeurs suivantes
			continue;
		}
		$_php_array[] = js_to_php_value($value);
	}
	return $_php_array;
}

// Transforme un tableau PHP en tableau JavaScript sous forme de chaîne
function php_to_js_array ($_php_array)
{
	// S'il s'agit d'un tableau associatif, les clés doivent être explicitement déclarées
	$is_assoc_array = is_assoc_array($_php_array);

	if ($is_assoc_array)
	{
		$bracket1 = "{";
		$bracket2 = "}";
	}
	else
	{
		$bracket1 = "[";
		$bracket2 = "]";
	}

	foreach ($_php_array as $key=>$value)
	{
		$js_key = ($is_assoc_array) ? $key.":" : "";

		$_php_array[$key] = $js_key.php_to_js_value($value);
	}
	return $bracket1.implode(',',$_php_array).$bracket2;
}

// Génère une date
function rddate ()
{
	return date("d/m/Y");
}

// Génère une heure
function rdtime ()
{
	return date("H:i:s").".".ceil(rand (100, 999));
}

// Génère un nombre aléatoire formaté (int ou float)
function rdnum ($min,$max,$dec=0)
{
	return sprintf("%.".$dec."f", mt_rand($min, $max).'.'.mt_rand(0, pow(10,$dec))); // "%04.3f" pour un format du type "0251.860"
}

function init_param ($name, $value)
{
	if (@!isset($_SESSION[$name]))
	{
		set_param($name, $value);
	}
}

function get_param ($name, $value="", $default=null)
{
	if (@isset($_SESSION[$name]))
	{
		// Si la chaine d'arguments est une liste d'ids, on la transforme en tableau
		if (is_string($value) && $value !== "" && ((strrpos($value,",") !== false && preg_match("/^\d+(,\d+)+$/",$value)) || (is_array($_SESSION[$name]))))
		{
			$keep_string = false;

			if (is_array($_SESSION[$name]))
			{
				foreach ($_SESSION[$name] as $k => $v)
				{
					// Si une clé est de la forme ID1,ID2... on laisse la chaîne intacte
					if (preg_match("/,/", $k))
					{
						$keep_string = true;
						break;
					}
				}
			}

			// Si la chaîne doit être découpée
			if (!$keep_string)
			{
				$value = explode(",", $value);
			}
		}

		// Si un filtre est passé sous forme de tableau
		if (is_array($value) && !empty($value))
		{
			$_return = [];

			// Récupération de la valeur stockée pour chaque argument
			foreach ($value as $arg)
			{
				if (isset($_SESSION[$name][$arg]))
				{
					$_return[$arg] = $_SESSION[$name][$arg];
				}
			}
		}
		// Si un filtre est passé sous forme de chaine ou d'entier et que la
		else if ($value !== "" && isset($_SESSION[$name][$value]))
		{
			$_return[$value] = $_SESSION[$name][$value];
		}

		if ($value === "" || empty($_return))
		{
			$_return = $_SESSION[$name];
		}
	}
	else
	{
		$_return = $default;
	}
	return $_return;
}

function set_param ($name, $value=null)
{
	if ($value === null)
	{
		return;
	}

	if (isset($_SESSION[$name]))
	{
		$prev_value = $_SESSION[$name];

		if (is_array($prev_value) && !is_array($value))
		{
			$value = explode(",",$value);
		}
		else if (is_bool($prev_value) && !is_bool($value))
		{
			$value = ($value === "true") ? true : false;
		}
		else if (is_null($prev_value) && $value == "null")
		{
			$value = null;
		}
	}

	$_SESSION[$name] = $value;
}

function del_param ($name, $value=null)
{
	if (!isset($_SESSION[$name])) {return;}

	if (isset($value))
	{
		if (isset($_SESSION[$name][$value]))
		{
			unset($_SESSION[$name][$value]);
		}
	}
	else if (isset($_SESSION[$name]))
	{
		unset($_SESSION[$name]);
	}
}

function init($system_type=null,$application="javascript")
{
	$system_type = is_int($system_type) ? $system_type : get_system_type();

	start_session($system_type);

	global $mode;
	$mode = isset($_GET['mode']) && is_numeric($_GET['mode']) ? intval($_GET['mode']) : false;

	// Mode json forcé par le paramètre GET json=1. Par défaut le mode json est défini selon le header content-type de la requete HTTP
	if (isset($_GET['json']) && $_GET['json'] === "1")
	{
		$application = "json";
	}

	// Stockage de l'activité du mode json
	set_param('json', ($application == 'json') ? true : false);

	// Cas des modes 0,1,2 qui sont en fait un mode 3 DataGroup avec un argument
	if (in_array($mode, array(0,1,2), true))
	{
		// On introduit le paramètre Datagroup dans la variable GET
		$_GET['DataGroup'] = (string) $mode;

		// On force le mode à 3 (lecture)
		$mode = 3;
	}

	// Spécifique APD
	if ($mode === 3 && isset($_GET['DataGroup']))
	{
		tp_tracking();
	}


	header("Content-Type: application/$application; charset=utf-8");

	return $system_type;
}

function start_session ($system_type)
{
	if (!is_int($system_type))
	{
		$system_type = "";
	}
	$session_name = preg_replace("`[^a-z0-9]`i", "", $_SERVER['PHP_SELF'].$system_type);

	session_name($session_name);
	session_start();
}

// Récupération du type de système dans app.js
function get_system_type ()
{
	$handle = fopen("../app.js", "r");
	$contents = fread($handle, 5000);
	fclose($handle);

	preg_match("`(?<!//)GIWIK.system_type\s*=\s*(\d+)`i", $contents, $_matches);

	// Si system_type statique (en dur dans app.js), on prend la valeur, sinon false
	$system_type = (isset($_matches[1]) && is_numeric($_matches[1])) ? intval($_matches[1]) : false;

	return $system_type;
}

function get_file ($url)
{
	$handle = fopen($url, "r");
	$contents = fread($handle, filesize($url));
	fclose($handle);

	return $contents;
}


// Pour affichage en JavaScript de données stockées nativement en php sous forme de tableau (avec gestion des types) —————————————————————————————————————————————————————
// --> pour les systèmes non JSON à base de System_state
function php_to_js_value ($value)
{
	$return = "";

	switch (gettype($value))
	{
		case 'boolean': $return = ($value) ? "true" : "false";   break;
		case 'integer':
		case 'double' : $return = (string) $value;               break;
		case 'string' : $return = "\"$value\"";                  break;
		case 'NULL'   : $return = "null";                        break;
		case 'array'  :	$return = php_to_js_array($value); break;
	}

	return $return;
}

// Variante de set_quotes à utiliser dans le cadre d'un stockage natif PHP des données dans la session
function js_to_php_value ($value)
{
	return preg_match("`^(-?\d+(\.\d+)?|true|false|null)$`",trim($value)) ? eval("return $value;") : $value;
}

// Transforme un tableau associatif PHP en tableau JavasScript sous forme de chaîne
function js_encode ($_params,$prefix="System_state.")
{
	$output = "";

	foreach ($_params as $name => $value)
	{
		$output_name  = $name;
		$output_value = php_to_js_value($value);

		if (is_assoc_array($value))
		{
			foreach ($value as $key => $svalue)
			{
				$output_name = $name."[".(is_numeric($key) ? $key : "\"$key\"")."]";
				$output_value = php_to_js_value($svalue);

				$output .= $prefix.$output_name."=".$output_value.";\n";
			}
		}
		else
		{
			$output .= $prefix.$output_name."=".$output_value.";\n";
		}
	}
	return $output;
}

// Fonction de lecture/écriture de conf ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
function giwik_readconf ($_special_params)
{
	if (!is_array($_special_params['_parent_params'])) {$_special_params['_parent_params'] = [];}
	if (!is_array($_special_params['_file_params']))   {$_special_params['_file_params']   = [];}

	$return  = "";
	$_return = [];

	// Cas particulier des appels multiples "PortConfI, DeviceConfI et SerialConfI"
	foreach ($_GET as $param => $arg)
	{
		if (in_array($param, $_special_params['_parent_params']))
		{
			foreach($_SESSION as $sess_param => $sess_value)
			{
				// S'il s'agit d'un paramètre fils, on l'ajoute dans la variable GET
				if (preg_match("/^".$param."[A-Z]/", $sess_param))
				{
					$_GET[$sess_param] = "";
				}
			}
			unset($_GET[$param]);
		}
		// Paramètres devant être retournés sous forme de fichier
		else if (in_array($param, $_special_params['_file_params']))
		{
			header('Content-Type: application/octet-stream');
			header('Content-Disposition: attachment; filename = "'.(isset($_GET['FileName']) ? $_GET['FileName'] : 'Config.txt').'"');

			echo get_param($param);
			exit;
		}
	}

	// Pour chaque paramètre on recherche une fonction homonyme pour les traitements spécifiques
	foreach($_GET as $param => $arg)
	{
		// Exécution de la fonction GIWIK before si elle existe
		$giwik_function_before = "GIWIK_".$param;
		$giwik_func_return = null;
		if (function_exists($giwik_function_before))
		{
			$giwik_func_return = $giwik_function_before($arg);
		}

		// Exécution de la fonction locale si elle existe
		if (function_exists($param))
		{
			// Si une valeur a été retournée par la fonction GIWIK
			$param(isset($giwik_func_return) ? $giwik_func_return : $arg);
		}

		// Exécution de la fonction GIWIK before si elle existe
		$giwik_function_after = "GIWIK_".$param."_callback";
		if (function_exists($giwik_function_after))
		{
			$giwik_function_after(isset($giwik_func_return) ? $giwik_func_return : $arg);
		}
	}

	foreach ($_GET as $param => $arg)
	{
		// Si le paramètre doit être ignoré
		if (in_array($param,['mode','ms','json']))
		{
			continue;
		}
		else
		{
			// Cas particulier de DataGroup qui ne reprend pas le nom du paramètre dans la réponse (pas de DataGroup dans la réponse mais directement les paramètres)
			if ($param == "DataGroup")
			{
				foreach (get_param($param) as $dg_name => $dg_value)
				{
					$_return[$dg_name] = $dg_value;
				}
			}
			else
			{
				// L'argument est défini à null par GIWIK pour forcer un retour vide, sinon, on récupère la valeur stockée
				$_return[$param] = ($arg === null) ? [] : get_param($param, $arg);
			}
		}
	}

	//var_dump($_return);

	return giwik_output($_return);
}

function giwik_writeconf ()
{
	// Pour chaque paramètre on recherche une fonction homonyme pour les traitements spécifiques
	foreach($_GET as $param=>$value)
	{
		// Exécution de la fonction GIWIK before si elle existe
		$giwik_function_before = "GIWIK_".$param;
		$giwik_func_return = null;
		if (function_exists($giwik_function_before))
		{
			$giwik_func_return = $giwik_function_before($value);
		}

		// Exécution de la fonction locale si elle existe
		if (function_exists($param))
		{
			// Si une valeur a été retournée par la fonction GIWIK
			$param(isset($giwik_func_return) ? $giwik_func_return : $value);
		}

		// Exécution de la fonction GIWIK before si elle existe
		$giwik_function_after = "GIWIK_".$param."_callback";
		if (function_exists($giwik_function_after))
		{
			$giwik_function_after(isset($giwik_func_return) ? $giwik_func_return : $value);
		}
	}

	foreach($_GET as $param=>$value)
	{
		// Si le paramètre doit être ignoré
		if (in_array($param,['mode','ms','json','DataGroup']))
		{
			continue;
		}

		$value = (is_array(get_param($param))) ? array_map("js_to_php_value", explode(',', $value)) : js_to_php_value($value);

		set_param($param, $value);
	}
}

// Appelle la fonction de sortie adéquate en fonction du mode (js ou json)
function giwik_output ($_params)
{
	// Si le type "json" a été passé à la fonction init ou si un paramètre json=1 est passé en GET
	return (get_param('json') === true) ? json_encode($_params,  JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) : js_encode($_params);
}

// Fonctions transponders ———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	function giwik_mode6 ()
	{
		$_return = [];

		foreach($_GET as $param=>$value)
		{
			if (in_array($param,['mode','ms','json']))
			{
				continue;
			}

			if ($value !== "")
			{
				// Cas des paramètres transpondeur
				if (preg_match("/^Transp/i", $param))
				{
					$_split = explode(",", $value);

					foreach($_split as $k=>$v)
					{
						$_return[$param."_updated"] = [$v => get_param('updated')];
					}
				}
				else
				{
					$_return[$param."_updated"] = [$value => get_param('updated')];
				}
			}
			else
			{
				$_return[$param."_updated"] = get_param('updated');
			}
		}
		return giwik_output($_return);
	}

	// Fonction appelée lors des commandes start/stop tracking   (callback sous forme de string)
	function tp_tracking ($action=null, $callback=null)
	{
		if (get_param('is_tracking') === null)
		{
			set_param('is_tracking', false);
			set_param('start_tracking_asked', -1);
			set_param('stop_tracking_asked', -1);
		}

		switch ($action)
		{
			case "start":
				set_param('start_tracking_asked', 0);

				// Stockage du callback à exécuter une fois le start_tracking terminé
				if (function_exists($callback))
				{
					set_param('start_tracking_callback', $callback);
				}
				break;
			case "stop":
				set_param('stop_tracking_asked', 0);

				// Stockage du callback à exécuter une fois le stop_tracking terminé
				if (function_exists($callback))
				{
					set_param('stop_tracking_callback', $callback);
				}
				break;
			default:
				$start_tracking_asked = get_param('start_tracking_asked');
				$stop_tracking_asked  = get_param('stop_tracking_asked');

				// var_dump($_SESSION);

				if ($start_tracking_asked > -1)
				{
					if ($start_tracking_asked < 5) // 10 parce que le datalogger s'ouvre et accélère le compteur
					{
						set_param('start_tracking_asked', $start_tracking_asked+1);
					}
					else
					{
						set_param('is_tracking', true);
						set_param('start_tracking_asked', -1);

						// Gestion du callback spécifique produit
						$callback = get_param('start_tracking_callback');
						if ($callback !== null && function_exists($callback))
						{
							del_param('start_tracking_callback');
							$callback();
						}
					}
				}
				else if ($stop_tracking_asked > -1)
				{
					if ($stop_tracking_asked < 3)
					{
						set_param('stop_tracking_asked',$stop_tracking_asked+1);
					}
					else
					{
						set_param('is_tracking', false);
						set_param('stop_tracking_asked', -1);

						// Gestion du callback spécifique produit
						$callback = get_param('stop_tracking_callback');
						if ($callback !== null && function_exists($callback))
						{
							del_param('stop_tracking_callback');
							$callback();
						}
					}
				}
		}
	}

	function tp_set ($id, $status, $_conf)
	{
		$inuse = $_conf[0];

		$_TranspConf = get_param('TranspConf',"",[]);
		$_TranspData = get_param('TranspData',"",[]);
		$_ui_status  = get_param('_ui_status');

		// Si le transpondeur n'existe pas déjà, on le crée
		if (!isset($_TranspConf[$id]))
		{
			$_TranspConf[$id] = $_conf;
			set_param('TranspConf', $_TranspConf);

			$order = count($_TranspData);

			$_TranspData[$id] = [$inuse, $order];
			set_param('TranspData', $_TranspData);

			$_ui_status[] = $status;

			set_param('_ui_status', $_ui_status);
		}
	}

	function tp_init ($id, $status, $_conf)
	{
		if (get_param('init_isdone') !== true)
		{
			tp_set ($id, $status, $_conf);
		}
	}

	function tp_delete ($id)
	{
		usleep(500000);

		$_ids = is_string($id) ? explode(",",$id) : [$id];

		$_ui_status = get_param('_ui_status');

		// Si une distance inter-balises est définie (RAMSES)
		if (isset($_SESSION['InterTranspConf']))
		{
			foreach ($_SESSION['InterTranspConf'] as $ids => $value)
			{
				// Suppression du paramètre InterTranspConf (le nom de la clé est dynamique, de la forme "ID1,ID2")
				if (preg_match("/^$id,\d+$/", $ids) || preg_match("/^\d+,$id$/", $ids))
				{
					del_param('InterTranspConf',$ids);
				}
			}
		}

		$_TranspData = get_param('TranspData');

		// Pour chaque balise à supprimer
		foreach ($_ids as $id_delete)
		{
			// Ordre du transponder à supprimer (pour _ui_status)
			$tp_order_delete = $_TranspData[$id_delete][1];

			// Suppression de la balise
			unset($_TranspData[$id_delete]);

			del_param('TranspConf',$id_delete);
			del_param('TranspInitialPosition',$id_delete);

			foreach ($_TranspData as $tp_id => &$_tp_conf)
			{
				// Récupération de l'ordre de la balise
				$tp_order = $_tp_conf[1];

				// Si l'ordre est > à celui de la balise supprimée, on le décrémente
				if ($tp_order > $tp_order_delete)
				{
					$_tp_conf[1]--;
				}
			}
			// index à supprimer dans le tableau des statuts
			$ui_status_key_to_delete = get_param('ui_status_nb_int_for_system') + $tp_order_delete;

			unset($_ui_status[$ui_status_key_to_delete]);	// suppression du statut de la balise
			$_ui_status = array_values($_ui_status);		// réaffectation des clés
		}

		set_param('_ui_status', $_ui_status);
		set_param('TranspData', $_TranspData);
	}

	function tp_activity ($value, $int_inuse, $int_not_inuse)
	{
		$_explode = explode(",", $value);

		$id_transp  = intval($_explode[0]);
		$true_false = ($_explode[1] === 'true') ? true : false;

		$_TranspData = get_param('TranspData');
		$_TranspConf = get_param('TranspConf');

		$tp_order = $_TranspData[$id_transp][1];

		$_TranspData[$id_transp][0] = $true_false;
		$_TranspConf[$id_transp][0] = $true_false;

		$ui_index = get_param('ui_status_nb_int_for_system') + $tp_order;  // l'index est décalé par les n statuts système

		$_ui_status = get_param('_ui_status');
		$_ui_status[$ui_index] = ($true_false === true) ? $int_inuse : $int_not_inuse;

		set_param('_ui_status', $_ui_status);
		set_param('TranspData', $_TranspData);
		set_param('TranspConf', $_TranspConf);
	}

	function GIWIK_TranspConf ($args)
	{
		global $mode;

		switch ($mode)
		{
			case 3 :
				break;

			case 4 :
				$_return = [];
				$_args = ($args) ? array_map("js_to_php_value", explode(",", $args)) : [];

				// Récupération de l'id du transpondeur et suppression de celui-ci du tableau $_args
				$id = array_shift($_args);

				$_tp_conf = get_param('TranspConf');

				$_tp_conf[$id] = $_args;

				set_param('TranspConf',$_tp_conf);

				// Suppression du paramètre de la requête GET pour éviter la moulinette de sauvegarde automatique
				unset($_GET['TranspConf']);

				// var_dump(get_param('TranspConf'));
				break;
		}
	}

	function GIWIK_TranspData ($args)
	{
		$_args = ($args !== "") ? explode(",", $args) : [];

		$_TranspData = get_param('TranspData');

		// Récupération du filtre tp_inuse, 2 par défaut (0: only not inuse, 1: only inuse, 2: all)
		$tp_inuse = (isset($_args[0]) && in_array($_args[0],['0','1','2'],true)) ? intval($_args[0]) : 2;

		// Récupération du tp_mode, 0 par défaut
		$tp_mode = (isset($_args[1]) && in_array($_args[1],['0','1','2'],true)) ? intval($_args[1]) : 0;

		// Récupération des éventuels ID
		$_ids = (count($_args) > 2) ? array_slice($_args,2) : array_keys($_TranspData);

		// IDs filtrés (après vérification de cohérence des IDs avec le filtre tp_inuse)
		$_ids_filtered = [];

		foreach ($_ids as $id)
		{
			$inuse = $_TranspData[$id][0];

			if ((!$inuse && in_array($tp_inuse,[0,2],true)) || ($inuse && in_array($tp_inuse,[1,2],true)))
			{
				$_ids_filtered[] = $id;

				// On garde uniquement les deux 1ers paramètres "inuse" et "order"
				$_TranspData[$id] = array_slice($_TranspData[$id],0,2);
			}
		}

		// Sauvegarde des tableaux tronqués
		set_param('TranspData',$_TranspData);

		// Renvoi des paramètres à destination de la fonction locale TranspData
		$_return = [
			"tp_inuse" => $tp_inuse,
			"tp_mode"  => $tp_mode,
			"_ids"     => $_ids_filtered
		];

		return $_return;
	}

	function GIWIK_TranspData_callback ($args_from_GIWIK_TranspData)
	{
		global $mode;

		switch ($mode)
		{
			case 3 :
				// Cas ou aucun id filtré : le cgi ne doit rien retourner (le comportement par défaut fait tout renvoyer quand il n'y a pas d'argument)
				if (empty($args_from_GIWIK_TranspData['_ids']))
				{
					$_GET['TranspData'] = null;
				}
				else
				{
					// Suppression des filtres tp_inuse et tp_mode des arguments de TranspData pour entrer dans la mécanique normale de get_param avec une liste d'id en argument
					$_GET['TranspData'] = implode(",", $args_from_GIWIK_TranspData['_ids']);
				}
				break;

			case 4 :
				break;
		}
	}

	function GIWIK_TranspDelete ($value)
	{
		global $mode;

		switch ($mode)
		{
			case 3 : break;
			case 4 :
				tp_delete($value);
				unset($_GET['TranspDelete']);
				break;
		}
	}

	function GIWIK_TranspDelete_callback ($value)
	{
		global $mode;

		switch ($mode)
		{
			case 3 : break;
			case 4 :
				unset($_GET['TranspDelete']);
				break;
		}
	}

	function GIWIK_TranspActivity ($value)
	{
		global $mode;

		switch ($mode)
		{
			case 3 :
				break;
			case 4 :
				tp_activity($value, 6173/*int pour balise in use*/,0 /*int pour balise not in use*/);
				unset($_GET['TranspActivity']);
				break;
		}
	}

	function GIWIK_TranspNew ($value)
	{
		global $mode;

		switch ($mode)
		{
			case 3 :
				break;
			case 4 :
				usleep(500000);

				$_assoc = explode(";",$value);

				foreach ($_assoc as $couple)
				{
					if ($couple == "") {continue;}

					$_couple = explode(",", $couple);

					$id_transp   = intval($_couple[0]);
					$type_transp = intval($_couple[1]);

					// echo "création tp $id_transp de type $type_transp";

					tp_set(
						$id_transp,
						0,
						[false, 0, 0, 1, $type_transp,0,11500,317,"N/A",40,13,0.19,154.32,53.76,-34.87526,1.12,-123.65342,53.87,1,0,false,56.9384736,2.365,124.9384732,1.837,32.938,0.372]
					);
				}
				break;
		}
	}

	function GIWIK_SndVelProfile ($args)
	{
		global $mode;

		switch ($mode)
		{
			case 3 :
				break;
			case 4 :
				$_profile = array_map(function($value){return js_to_php_array($value);}, explode(";",$args));
				set_param('SndVelProfile',$_profile);
				unset($_GET['SndVelProfile']);
				break;
		}
	}

//———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

// Fonction JSON SSD ————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
// Lit dans la session tous les paramétres demandés et les retourne en JSON
function json_readconf ()
{
	global $_data_groups;

	$_return = array();

	foreach ($_GET as $param => $value)
	{
		if (in_array($param, array('mode','ms')))
		{
				continue;
		}
		// Si demande d'un groupe de données
		else if ($param == 'DataGroup')
		{
			if (!is_numeric($value))
			{
				continue;
			}

			$data_group = intval($value);

			for ($i=0; $i <= $data_group; $i++)
			{
				$_return = array_merge($_return, $_SESSION[$param][$i]);
			}
		}
		else if ($value !== "")
		{
			$_return = array_merge($_return, [$param => $_SESSION[$param][$value]]);
		}
		else
		{
			$_return = array_merge($_return, [$param => $_SESSION[$param]]);
		}
	}

	return json_encode($_return, JSON_PRETTY_PRINT);
}

// Ecrit dans la session tous le couples paramétre/valeur passés
function json_writeconf ($json_use_val = false)
{
	foreach($_GET as $param=>$value)
	{
		if (in_array($param, ['mode','ms','json','DataGroup']))
		{
			continue;
		}
		else
		{
			$value = js_to_php_value($value);
			if (is_string($value)) {$value = rawurldecode($value);}

			if (@$json_use_val)
			{
				$_SESSION[$param]['val'] = $value;
			}
			else
			{
				$_SESSION[$param] = $value;
			}

			// Cas particulier du survey sélectionné qui change la valeur courante de LineList
			if ($param == 'SelectedSurvey')
			{
				$_SESSION['LineList']['val'] = $_SESSION['_lines'][$value];
			}
		}
	}
	return "";
}

// Sauvegarde des paramétres par défaut dans le cookie de session
	// 2 façons de passer des paramètres :
	// $_params est un tableau associatif paramètre=>valeur
	// $_params est un string et $value est passé en plus pour la valeur du paramètre
function json_set_param ($_params, $value=null)
{
	// Si mode de passage (param, value)
	if (!is_array($_params))
	{
		$_params = array($_params => $value);
	}

	foreach($_params as $param=>$value)
	{
		if (!isset($_SESSION[$param]))
		{
			$_SESSION[$param] = $value;
		}
	}
}
