GIWIK.init.js('msg', 'maintenance_ipd');
// Balise "name" de l'input file
// Déclaration à la racine pour que HEADING.input_file_html_name soit disponible à l'exécution de HEADING.construct._plugins.maintenance
HEADING.input_file_html_name = 'Filedata';


HEADING.construct._plugins.maintenance.specific = function ()
{
	if (GIWIK._plugins.maintenance._soft_versions)
	{
		if (STORAGE.get('updatestate') == "firmwaremode" || window[system].is_started === true)
		{
			GIWIK.css.setClass('software_versions', 'displayblock');
		}
		else
		{
			GIWIK.css.setClass('software_versions', 'displaynone');
		}


		if (GIWIK._plugins.maintenance.soft_update)
		{
			// Actualisation de la Page en Mode: backtofirmwaremode
			// -> Utilisateur a changé de page: GIWIK a géré le reboot: on repasse en mode firm
			if (STORAGE.get('updatestate') == "backtofirmwaremode")
			{
				STORAGE.setSession('updatestate',"firmwaremode");
			}

			// FONCTIONS DE SUPPORT AVANCÉ ///////////////////////////////////////////////////////////////////////////////////////////////////////////
			window[system].init_stopped = 0;

			// Appel Fct centralisée affichage de la partie Update
			// - Appelée lors construct car apres chargement fichier, chargement page avec is_started=false dc pas de readconf()!!
			HEADING.displaySoftUpdate();
		}
	}
};

HEADING.readConf._plugins.maintenance.specific = function ()
{
	if (GIWIK._plugins.maintenance._soft_versions)
	{
		if (GIWIK._plugins.maintenance.packname)
		{	
			$('#IHMVers_label').parents('tr:first').before(
				'<tr>'
					+'<td><span id="PackName_label" class="state_1 bold"></span></td>'
					+'<td><span id="PackName"></span></td>'
				+'</tr>');

			GIWIK.write('PackName_label',   MSG(['box','packName_label'])+'&nbsp;:&nbsp;&nbsp;');
			
			if((window[system]["PackName"] === "") || (window[system]["PackName"] === "None"))
				GIWIK.write('PackName', "NA");
			else
				GIWIK.write('PackName', window[system]["PackName"]);
		}
	}
	
	if (GIWIK._plugins.maintenance._soft_versions && GIWIK._plugins.maintenance.soft_update)
	{
		HEADING.displaySoftUpdate();
	}
};

HEADING.getConf._plugins.maintenance.specific = function ()
{
	var _params = {};

	if (GIWIK._plugins.maintenance._soft_versions)
	{	
		if (GIWIK._plugins.maintenance.packname)
		{
			_params['PackName'] = "";
		}
	}

	return _params;
};

// Initialisation EventViewer: Efface contenu
HEADING.errorsViewerInitData = function ()
{
	// Si aucune valeur définie pour le nombre d'événements visualisables
	if (typeof GIWIK.errorsviewer_maxevents == 'undefined') {GIWIK.errorsviewer_maxevents = 20;}

	// Init Box
	HEADING.errorsViewerInit();

	// Paramètres Lecture
	window.ErrorsViewerIndex		= -1;
	window.ErrorsViewerNextPrevious	= 2;
	window.ErrorsViewerNumber		= 0;
};

// Activation Events: Timer pour récupération Erreurs
HEADING.errorsViewerEnable = function ()
{
	// Si aucune valeur définie pour le timer des capteurs externes
	GIWIK.errorsviewer_timeout = 5000;

	// Timer: Get Sensor Data: Period/10 durant le chargement des anciennes erreurs
	GIWIK.setTimer("HEADING.getErrorsLog();", GIWIK.errorsviewer_timeout/5, 'window.errorsviewertimer');
};

// GetErrors
HEADING.getErrorsLog = function ()
{
	// Error Log ssi Mode Firmware
	if ( window[system].is_started === true )
	{
		var request = GIWIK.cgifile+"?mode=3"+"&Statistics&ErrorsLog="+window.ErrorsViewerIndex+","+window.ErrorsViewerNextPrevious;

		GIWIK.ajax(request);
	}
};

// Parse GetError result
HEADING.errorsViewerParse = function ()
{
	// Construction Apres 1er readConf
	if (!HEADING.init.isdone)
	{
		// Init
		HEADING.errorsViewerInitData();
		HEADING.errorsViewerEnable();
		return;
	}

	// Pas de Nouvel Evenement: Remet la periode du timer à sa valeur par défaut
	if (window[system].ErrorsLog == "" && window.LastErrorsLog != "")
	{
		// Si aucune valeur définie pour le timer des capteurs externes
		GIWIK.errorsviewer_timeout = 5000;

		// Timer: Get Sensor Data: Period/2 durant le chargement des anciens evenements
		GIWIK.setTimer("HEADING.getErrorsLog();", GIWIK.errorsviewer_timeout, 'window.errorsviewertimer');
	}
	else
	{
		var error_time  = "";

		// Lecture Reponse Erreurs et Découpage
		var _taberrors = window[system].ErrorsLog.split("$");

		// Traitement de chaque erreur
		for (var i=0; i<_taberrors.length; i++)
		{
			// Découpage de la trame selon,
			// - Index, Sen1,Sen2,Alg1,Alg2,Sys1,Sys2,Alg3,HHH
			var _taberrordetails = _taberrors[i].split(",");
			if (_taberrordetails.length < 8){continue;}

			// Update Index
			window.ErrorsViewerIndex = _taberrordetails[0];

			// Passage Status vers Tableau Unifié
			var _statuserror = [];
			for (var j=0;j<window[system]._ui_status.length; j++){
				_statuserror[j] = (_taberrordetails[1+j] != "") ? _taberrordetails[1+j] : 0;
			}
			var unify_status = [];
			unify_status = GIWIK.statusBitsInfo.unify(_statuserror);


			// Lecture Heure
			// Rq Date identique au message précédent Date="" idem pour Heure
			if (_taberrordetails[1+window[system]._ui_status.length] != "")
			{
				error_time = _taberrordetails[1+window[system]._ui_status.length];
				error_time += " " + MSG(['units',(_taberrordetails[1+window[system]._ui_status.length]>1) ? 'hours_long' : 'hour_long']);
				error_time += " : ";
			}


			// Partie Spécifique: Message Status
			for (var j=0; j<32*window[system]._ui_status.length; j++)
			{
				// Pas d'Evenement sur ce Status OU pas de code associé
				if (!unify_status[j] || !GIWIK._status_bits_info[j])
				{
					continue;
				}

				if (GIWIK._status_bits_info[j].msg > 0)
				{
					// 1 message associé à ce Status
					if (error_message = MSG(['detailedstatuscodes',GIWIK._status_bits_info[j].msg]))
					{
					    error_state = 1; // Blue (not in red) //GIWIK._status_bits_info[j].status_on;

						// Cas Fenetre Vide: ReInit
						if (window.ErrorsViewerNumber === 0)
						{
							// Efface contenu du <div> EventsData
							HEADING.errorsViewerInit();
						}

						// Affichage Message
						HEADING.errorsViewerAdd('<span class="state_'+error_state+'"style="font-weight:normal">'+error_time+error_message+'</span>');
					}
				}
			}	// Chaq Status
		}	// Traitt Chaq Evt
	}
	// Méo Last Error log
	window.LastErrorsLog = window[system].ErrorsLog;

	// Check if viewer is empty
	HEADING.errorsViewerCheckEmpty();
};

// Init Content
HEADING.errorsViewerInit = function (Message)
{
	// Efface contenu du <div> EventsData
	document.getElementById("errorsviewer_data").innerHTML = "";
};

HEADING.errorsViewerAdd = function (Message)
{
	var errorslist = document.getElementById("errorsviewer_data");

	// Stockage evenement
	errorslist.innerHTML = Message + "<br/>" + errorslist.innerHTML;


	// Gestion Limitation Nombre d'événement stockés
	window.ErrorsViewerNumber += 1;
	if ( window.ErrorsViewerNumber > GIWIK.errorsviewer_maxevents )
	{
		// Découpage propre au dernier <br/>
		var br_pos = errorslist.innerHTML.lastIndexOf("<br/>");
		if (br_pos == -1){br_pos = errorslist.innerHTML.lastIndexOf("<br>");}

		errorslist.innerHTML = errorslist.innerHTML.substr(0, br_pos);

		window.ErrorsViewerNumber -= 1;
	}
};

// Check Content Event Viewer
HEADING.errorsViewerCheckEmpty = function (Message)
{
	// Si empty
	if (window.ErrorsViewerNumber === 0)
	{
		var errorslist = document.getElementById("errorsviewer_data");

		// Stockage evenement
		errorslist.innerHTML = '<span class="state_1" style="font-weight:normal">'+ MSG(['box','criticalerrorsnone_label'])+'</span>';
	}
};

// Appel périodique lors passage mode Loader
HEADING.startLoaderMode = function ()
{
	//TMPFAP pour test
	//window[system].init_stopped = 1;

	// Passage mode loader OK
	// - Enable update
	if (window[system].init_stopped == 1)
	{
		clearInterval(window.timer_loader);
		window.timer_loader = null;

		// Enable Chargement Fichier
		STORAGE.setSession('updatestate',"loadermodeok");

		// Maj Affichage
		HEADING.displaySoftUpdate();
	}
	// Attente mode loader
	// - Just wait ...
	else
	{
		// Requete Mode Loader
		GIWIK.ajax(GIWIK.cgifile+"?loader=0", {eval_rtxt:true});
	}
};

// Passage Mode Firmware
HEADING.startFirmwareMode = function ()
{
	// Pas de rechargement de la page
	STORAGE.setSession('refresh_on_next_restart', false);
	STORAGE.setSession('webpage_has_to_be_refreshed', false);

	// Mode firmware
	GIWIK.ajax(GIWIK.cgifile+"?loader=1", {eval_rtxt:true});
};

// Envoi du fichier
HEADING.sendFirmware.specific = function ()
{
	// Soumission du formulaire
	document.form_update.submit();
};

// construction de l'url cible (CGI) pour l'action du formulaire
HEADING.constructFormAction = function ()
{
	// Cas standard : le paramètre URL permet de spécifier la redirection après prise en compte du fichier par le CGI
	return GIWIK.cgiuploader+'?url='+window.location.protocol+'//'+window.location.host+window.location.pathname;
};

// Fonction appelée lors clic bouton "Update"
// - CINT Mode firmware: Passage Mode Loader
// - CINT Mode Loader: Chargement fichier
HEADING.updateSystem = function ()
{
	// Update enable: Mode loader
	// - Send firmware
	if (STORAGE.get('updatestate') == "loadermodeok")
	{
		if (!window.Input_file_update.getValue())
		{
			alert(MSG(['alerts','update_no_file']));
			return;
		}
		// Envoi fichier
		HEADING.sendFirmware();
	}

	// Update disable: Mode Firmware:
	// - Reboot
	// - Start Mode Loader
	else
	{
		// Message de confirmation
		if (confirm(MSG(['confirm','update'])))
		{
			// Passage Mode attente mode firmware
			STORAGE.setSession('updatestate',"waitingloadermode");

			STORAGE.setSession('refresh_on_next_restart', true);
			STORAGE.setSession('webpage_has_to_be_refreshed', true);

			// Reboot
			GIWIK.ajax(GIWIK.cgifile+'?mode=5&cmd=1');


			// Maj Affichage
			HEADING.displaySoftUpdate();

			// Timer: Check loader mode
			window.timer_loader = setInterval("HEADING.startLoaderMode();",2000);
		}
	}
};

// Action lors appui bouton restart
// - CINT Mode Loader: Passage Mode Firmware puis reboot
// - CINT Mode Firmware: Reboot
HEADING.restartSystem = function ()
{
	if (confirm((GIWIK._plugins.maintenance.restart_system.msg_confirm) ? GIWIK._plugins.maintenance.restart_system.msg_confirm : MSG(['confirm','restart'])))
	{
		// Mode Loader: Sortie de ce mode
		if ( STORAGE.get('updatestate') == "loadermodeok" )
		{
			// Retour mode firmware
			STORAGE.setSession('updatestate',"backtofirmwaremode");

			// Mise a jour affichage
			HEADING.displaySoftUpdate();

			// Passage mode firmware
			HEADING.startFirmwareMode();

			// Mémo demande de reboot en cas de changement de page intempestif: 3s
			STORAGE.setSession('reboot_scheduled',3000);

			//Reboot System after 5s
			window.setTimeout("HEADING.restartSystemExecute();",5000);
		}
		// Mode Firmware: reboot
		else
		{
			HEADING.rebootSystem();
		}
	}
};

HEADING.restartSystemExecute = function ()
{
	// Mise à Jour: Firmware State
	STORAGE.setSession('updatestate','firmwaremode');
	STORAGE.setSession('reboot_scheduled',false);

	// Ask for Reboot System
	HEADING.rebootSystem();

	// Bug FIREFOX: Blocage sur Commande Mode=0
	if (GIWIK._context.gecko)
	{
		window.setTimeout("window.location.reload();",20000);
	}
};

// Fct Reboot system
HEADING.rebootSystem = function ()
{
	// Reboot
	window.Statuschevron.setStatus(10);
	HEADING.setSettingsActivity('disable');

	if (window.Updatesoft) {window.Updatesoft.disable();}
	if (window.Restart)    {window.Restart.disable();}

	//if (STORAGE.get('refresh_on_next_restart'))
	//{
		STORAGE.setSession('refresh_on_next_restart', false);
		STORAGE.setSession('webpage_has_to_be_refreshed', true);
	//}

	GIWIK.ajax(GIWIK.cgifile+'?mode=5&cmd=1');
};

// Affichage de certains éléments en fonction du mode Loader/Firmware
// - Appelée lors du ReadConf
// - Appelée lors d'action spécifiques (Passage Mode Loader , Click bouton Update, Restart ...)
// - Appelée lors construct car apres chargement fichier, chargement page avec is_started=false dc pas de readconf()!!
HEADING.displaySoftUpdate = function ()
{
	if (!HEADING.init.isdone)
	{
		window.Updatesoft.setLabel(MSG(['buttons','update']));
	}

	// Attente Passage Modse loader
	if (STORAGE.get('updatestate') == "waitingloadermode")
	{
		// Chevron clignotant
		window.Statuschevron.setStatus(10);

		// Desactivation Boutons
		HEADING.setSettingsActivity("disable");
		window.Updatesoft.disable();
		if (window.Restart) {window.Restart.disable();}

		// Message UpdateMode: Passage Loader
		window.Usermsg_updatemode.setValue(MSG(['box','waiting_loader_mode']));
		window.Usermsg_updatemode.setStatus(1);
		window.Usermsg_updatemode.show();

		// Message Update
		// ...

		// On affiche plus les noms des firm
		$("#software_versions").slideUp();

		// On affiche plus le bouton de mise à jour
		$("#firmware_ctnr").slideUp();


		// Init Variable Passage mode Loader
		window.passagemodeloader = 0;
	}

	// Mode Loader: chargement fichier
	else if (STORAGE.get('updatestate') == "loadermodeok")
	{
		// Message Update intro efface
		GIWIK.write('fileupdate_intro', "");

		// Activation selection fichier
		window.Input_file_update.enable();
		window.Input_file_update.show();

		// Bouton pour chargement
		window.Updatesoft.setLabel(MSG(['buttons','loadfile']));
		window.Updatesoft.enable();

		// Message Mode loader
		window.Usermsg_updatemode.setValue(MSG(['box','loader_mode_ok']));
		window.Usermsg_updatemode.setStatus(1);
		window.Usermsg_updatemode.show();

		// Message Resultat chargement precedent
		var msg_code = false;
		var msg_state = 1;

		if (window._GET['error'] && window._GET['error'].match(/^[0-9]+$/gi))
		{
			msg_code = window._GET['error'];
			msg_state = MSG.defineState(msg_code);
		}
		else if (window._GET['type'])
		{
			var upload_type = window._GET['type'];

			switch (upload_type)
			{
				case 'IHM':	  msg_code = '1';
					// Ecriture dans le cookie de la variable indiquant que la page doit être rechargée lors du prochain restart
					STORAGE.setSession("refresh_on_next_restart", true);
					break;
				case 'FirmwareCINT': msg_code = '2'; break;
				case 'LoaderCINT':   msg_code = '3'; break;
				case 'FirmwareDSP':  msg_code = '4'; break;
				case 'LoaderDSP':    msg_code = '5'; break;
			}
		}

		if (MSG['updatestatuscodes'][msg_code])
		{
			window.Usermsg_update.setStatus(msg_state);
			window.Usermsg_update.setValue(MSG(['updatestatuscodes',msg_code]));
			window.Usermsg_update.show();
		}
		else
		{
			window.Usermsg_update.hide();
		}

		// On affiche pas les noms des firm
		$("#software_versions").slideUp();

		// On affiche le bouton de mise à jour
		$("#firmware_ctnr").slideDown();

		// Always Enable reboot button
		if (window.Restart)
		{
			window.Restart.enable();
			window.Restart.show();
		}

		// Reboot Hard lors procedure
		if (window[system].is_started === true && window.passagemodeloader==1)
		{
			STORAGE.setSession('updatestate',"firmwaremode");

			HEADING.sendConf();
		}

		// 1er passage mode loader
		window.passagemodeloader = 1;
	}

	// Mode redemarrage pour retour mode firmware
	else if (STORAGE.get('updatestate') == "backtofirmwaremode")
	{
		// Reboot in progress
		window.Statuschevron.setStatus(10);
		HEADING.setSettingsActivity('disable');

		window.Updatesoft.disable();
		if (window.Restart) {window.Restart.disable();}

		// Message Sortie Mode Loader + Reboot
		window.Usermsg_updatemode.setValue(MSG(['box','back_to_firmware_mode']));
		window.Usermsg_updatemode.setStatus(1);
		window.Usermsg_updatemode.show();

		// Efface message lié au chargement d'un fichier
		if (window.Usermsg_update) {window.Usermsg_update.hide();}


		// On affiche pas les noms des firm
		$("#software_versions").slideUp();

		// On affiche plus le bouton de mise à jour + selection fichier
		$("#firmware_ctnr").slideUp();
	}

	// Mode firmware:
	else
	{
		HEADING.setSettingsActivity('enable');

		// Message Update: CLick to update
		GIWIK.write('fileupdate_intro', MSG(['box','update_intro']));

		// Desactivation selection fichier
		window.Input_file_update.disable();
		window.Input_file_update.hide();

		window.Updatesoft.enable();

		// Bouton pour passage loader
		window.Updatesoft.setLabel(MSG(['buttons','update']));

		// Message Mode Loader OFF
		window.Usermsg_updatemode.hide();

		// On affiche les noms des firmwares
		$("#software_versions")[HEADING.init.isdone ? 'slideDown' : 'show']();

		// On affiche le bouton de mise à jour
		$("#firmware_ctnr")[HEADING.init.isdone ? 'slideDown' : 'show']();

		// Always Enable reboot button
		if (window.Restart)
		{
			window.Restart.enable();
			window.Restart.show();
		}
	}
};
