// PLUGIN SIMULATION

GIWIK.init.js(['css','msg'],'simulation');


HEADING.readConf._plugins.simulation = function ()
{
	if (!HEADING.init.isdone)
	{
		if (typeof System_state.SimuPositionUTM != 'undefined' || typeof System_state.SimuPosition != 'undefined')
		{
			// Paramètres Position
			if (GIWIK.coordinate_mode === 1)	// UTM
			{
				window.Input_northing = new Input_int('Input_northing', true);
				window.Input_northing.label_width = window.heading_labels_width;
				window.Input_northing.input_width= window.heading_input_width;
				window.Input_northing.construct('input_northing','linear',MSG(['parameters','utm_northing']),0.001,0,20000000,MSG(['units','meter']));
				window.Input_northing.setAction("window.PositionChanged=true;");
				window.Input_northing.show();

				window.Input_easting = new Input_int('Input_easting', true);
				window.Input_easting.label_width = window.heading_labels_width;
				window.Input_easting.input_width= window.heading_input_width;
				window.Input_easting.construct('input_easting','linear',MSG(['parameters','utm_easting']),0.001,0,1000000,MSG(['units','meter']));
				window.Input_easting.setAction("window.PositionChanged=true;");
				window.Input_easting.show();

				window.Input_zone = new Input_text('Input_zone', true);
				window.Input_zone.label_width = window.heading_labels_width;
				window.Input_zone.input_width= window.heading_input_width;
				window.Input_zone.construct('input_zone','linear',MSG(['parameters','utm_zone']),"");
				window.Input_zone.setAction("window.PositionChanged = true;");
				window.Input_zone.show();
			}
			else
			{
				window.Input_latitude = new Input_int('Input_latitude', true);
				window.Input_latitude.label_width = window.heading_labels_width;
				window.Input_latitude.input_width= window.heading_input_width;
				window.Input_latitude.construct('input_latitude','linear',MSG(['parameters','latitude']),0.000001,-90,90,MSG(['units','degree']));
				window.Input_latitude.setAction("window.PositionChanged=true;");
				window.Input_latitude.show();

				window.Input_longitude = new Input_int('Input_longitude', true);
				window.Input_longitude.label_width = window.heading_labels_width;
				window.Input_longitude.input_width= window.heading_input_width;
				window.Input_longitude.construct('input_longitude','linear',MSG(['parameters','longitude']),0.000001,0,360,MSG(['units','degree']));
				window.Input_longitude.setAction("window.PositionChanged=true;");
				window.Input_longitude.show();
			}

			// Ecarts types de position
			GIWIK.paramGroup.construct('params_positionstddev_inputs', MSG(['box','simu_params_position_stddev']), (GIWIK.stddev) ? 'show' : 'displaynone');

			if (GIWIK.coordinate_mode === 1)	// UTM
			{
				window.Input_northing_stddev = new Input_int('Input_northing_stddev', true);
				window.Input_northing_stddev.label_width = window.heading_labels_width;
				window.Input_northing_stddev.input_width= window.heading_input_width;
				window.Input_northing_stddev.construct('input_northing_stddev','linear',MSG(['parameters','utm_northing']),0.01,0,500,MSG(['units','meter']));
				window.Input_northing_stddev.setAction("window.PositionChanged=true;");
				window.Input_northing_stddev.show();

				window.Input_easting_stddev = new Input_int('Input_easting_stddev', true);
				window.Input_easting_stddev.label_width = window.heading_labels_width;
				window.Input_easting_stddev.input_width= window.heading_input_width;
				window.Input_easting_stddev.construct('input_easting_stddev','linear',MSG(['parameters','utm_easting']),0.01,0,500,MSG(['units','meter']));
				window.Input_easting_stddev.setAction("window.PositionChanged=true;");
				window.Input_easting_stddev.show();
			}
			else
			{
				window.Input_latitude_stddev = new Input_int('Input_latitude_stddev', true);
				window.Input_latitude_stddev.label_width = window.heading_labels_width;
				window.Input_latitude_stddev.input_width= window.heading_input_width;
				window.Input_latitude_stddev.construct('input_latitude_stddev','linear',MSG(['parameters','latitude']),0.01,0,500,MSG(['units','meter']));
				window.Input_latitude_stddev.setAction("window.PositionChanged=true;");
				window.Input_latitude_stddev.show();

				window.Input_longitude_stddev = new Input_int('Input_longitude_stddev', true);
				window.Input_longitude_stddev.label_width = window.heading_labels_width;
				window.Input_longitude_stddev.input_width= window.heading_input_width;
				window.Input_longitude_stddev.construct('input_longitude_stddev','linear',MSG(['parameters','longitude']),0.01,0,500,MSG(['units','meter']));
				window.Input_longitude_stddev.setAction("window.PositionChanged=true;");
				window.Input_longitude_stddev.show();
			}

			window.Input_altidepth_stddev = new Input_int('Input_altidepth_stddev', true);
			window.Input_altidepth_stddev.label_width = window.heading_labels_width;
			window.Input_altidepth_stddev.input_width= window.heading_input_width;
			window.Input_altidepth_stddev.construct('input_altidepth_stddev','linear',(GIWIK.alti_depth) ? MSG(['parameters',GIWIK.alti_depth]) : '',0.01,0,500, MSG(['units','meter']));
			window.Input_altidepth_stddev.setAction("window.PositionChanged=true;");
			window.Input_altidepth_stddev[(GIWIK.alti_depth) ? 'show' : 'hide']();

		}
	}


	// Simulation Mode Enable
	// -------------------------------
	window.Switch_enable_simulation_mode.setValue(System_state.SimuMode);

	if (typeof System_state.SimuAttitude != 'undefined')
	{
		// Attitude and Attitude Standard deviation
		// - Plus Attitude Wave form
		// ------------------------------------------------------
		window.Input_heading.setValue(System_state.SimuAttitude[0]);
		window.Input_roll.setValue(System_state.SimuAttitude[1]);
		window.Input_pitch.setValue(System_state.SimuAttitude[2]);
		window.Input_heading_stddev.setValue(System_state.SimuAttitude[3]);
		window.Input_roll_stddev.setValue(System_state.SimuAttitude[4]);
		window.Input_pitch_stddev.setValue(System_state.SimuAttitude[5]);
		window.Input_heading_period.setValue(System_state.SimuAttitude[6]);
		window.Input_heading_amplitude.setValue(System_state.SimuAttitude[7]);
		window.Input_roll_period.setValue(System_state.SimuAttitude[8]);
		window.Input_roll_amplitude.setValue(System_state.SimuAttitude[9]);
		window.Input_pitch_period.setValue(System_state.SimuAttitude[10]);
		window.Input_pitch_amplitude.setValue(System_state.SimuAttitude[11]);
	}

	if (typeof System_state.SimuPositionUTM != 'undefined' || typeof System_state.SimuPosition != 'undefined')
	{
		// Position
		// -----------
		if (GIWIK.coordinate_mode === 1)	// UTM
		{
			window.Input_northing.setValue(System_state.SimuPositionUTM[0]);
			window.Input_easting.setValue(System_state.SimuPositionUTM[1]);
			window.Input_altidepth.setValue(GIWIK.alti_depth_sign*System_state.SimuPositionUTM[2]);
			window.Input_zone.setValue(System_state.SimuPositionUTM[3]);
			window.Input_northing_stddev.setValue(System_state.SimuPositionUTM[4]);
			window.Input_easting_stddev.setValue(System_state.SimuPositionUTM[5]);
			window.Input_altidepth_stddev.setValue(System_state.SimuPositionUTM[6]);
		}
		else // Lat/Long / Polar
		{
			window.Input_latitude.setValue(System_state.SimuPosition[0]);
			window.Input_longitude.setValue(System_state.SimuPosition[1]);
			window.Input_altidepth.setValue(GIWIK.alti_depth_sign*System_state.SimuPosition[2]);
			window.Input_latitude_stddev.setValue(System_state.SimuPosition[3]);
			window.Input_longitude_stddev.setValue(System_state.SimuPosition[4]);
			window.Input_altidepth_stddev.setValue(System_state.SimuPosition[5]);
		}
	}

	if (typeof System_state.SimuSpeeds != 'undefined')
	{
		//  Vitesses
		// -------------
		window.Input_speed_xv1.setValue(System_state.SimuSpeeds[0]);
		window.Input_speed_xv2.setValue(System_state.SimuSpeeds[1]);
		window.Input_speed_xv3.setValue(System_state.SimuSpeeds[2]);
		window.Input_speed_xv1_stddev.setValue(System_state.SimuSpeeds[3]);
		window.Input_speed_xv2_stddev.setValue(System_state.SimuSpeeds[4]);
		window.Input_speed_xv3_stddev.setValue(System_state.SimuSpeeds[5]);
		window.Input_speed_xv1_period.setValue(System_state.SimuSpeeds[6]);
		window.Input_speed_xv1_amplitude.setValue(System_state.SimuSpeeds[7]);
		window.Input_speed_xv2_period.setValue(System_state.SimuSpeeds[8]);
		window.Input_speed_xv2_amplitude.setValue(System_state.SimuSpeeds[9]);
		window.Input_speed_xv3_period.setValue(System_state.SimuSpeeds[10]);
		window.Input_speed_xv3_amplitude.setValue(System_state.SimuSpeeds[11]);
	}

	if (typeof System_state.SimuHSS != 'undefined')
	{
		// Heave Surge Sway
		// ------------------------
		window.Input_surge.setValue(System_state.SimuHSS[0]);
		window.Input_sway.setValue(System_state.SimuHSS[1]);
		window.Input_heave.setValue(System_state.SimuHSS[2]);
	}

	if (typeof System_state.SimuAccRot != 'undefined')
	{
		// Acceleration/Rotation
		// -----------------------------
		window.Input_acc_xv1.setValue(System_state.SimuAccRot[0]);
		window.Input_acc_xv2.setValue(System_state.SimuAccRot[1]);
		window.Input_acc_xv3.setValue(System_state.SimuAccRot[2]);

		window.Input_rotrate_xv1.setValue(System_state.SimuAccRot[3]);
		window.Input_rotrate_xv2.setValue(System_state.SimuAccRot[4]);
		window.Input_rotrate_xv3.setValue(System_state.SimuAccRot[5]);
	}

	if (typeof System_state.SimuStatus != 'undefined')
	{
		// Status
		// --------
		window.Checkbox_FOGError.setValue(System_state.SimuStatus[0]);
		window.Checkbox_ACCError.setValue(System_state.SimuStatus[1]);
		window.Checkbox_SRCError.setValue(System_state.SimuStatus[2]);
		window.Checkbox_TEMPError.setValue(System_state.SimuStatus[3]);
		window.Checkbox_DegradedMode.setValue(System_state.SimuStatus[4]);
		window.Checkbox_FailureMode.setValue(System_state.SimuStatus[5]);

		window.Checkbox_StaticAlignment.setValue(System_state.SimuStatus[6]);
		
		if( GIWIK.ihm_codename == 'gyro' || GIWIK.is_gyro==true )
		{
			window.Checkbox_HRPUnvalid.setValue(System_state.SimuStatus[7]);
		}
		else
		{
			window.Checkbox_Navigation.setValue(System_state.SimuStatus[7]);
			window.Checkbox_AltitudeSaturation.setValue(System_state.SimuStatus[8]);
			window.Checkbox_SpeedSaturation.setValue(System_state.SimuStatus[9]);			
		}
	}

	// Init
	window.EnableSimulationChanged = false;
	window.AttitudeChanged = false;
	window.PositionChanged = false;
	window.SpeedsChanged = false;
	window.HeaveSurgeSwayChanged = false;
	window.AccelerationsChanged = false;
	window.RotationRatesChanged = false;
	window.StatusChanged = false;


};

HEADING.getConf._plugins.simulation = function ()
{
	var _params = {};

	_params['SimuMode'] = "";

	if (GIWIK._plugins.simulation.hrp)                   {_params['SimuAttitude'] = "";}
	if (GIWIK._plugins.simulation.position)              {_params['SimuPosition'] = ""; _params['SimuPositionUTM'] = "";}
	if (GIWIK._plugins.simulation.heave_surge_sway)      {_params['SimuHSS'] = "";}
	if (GIWIK._plugins.simulation.speed)                 {_params['SimuSpeeds'] = "";}
	if (GIWIK._plugins.simulation.acceleration_rotation) {_params['SimuAccRot'] = "";}
	if (GIWIK._plugins.simulation.status)                {_params['SimuStatus'] = "";}

	return _params;
};

HEADING.sendConf._plugins.simulation = function ()
{
	var _params = {};

	//A: Construction
	// --------------------

	// Simulation Mode Enable/Disable
	// ------------------------------------------
	if (window.Switch_enable_simulation_mode.getValue() !== System_state.SimuMode)
	{
		_params['SimuMode'] = window.Switch_enable_simulation_mode.getValue();

		window.EnableSimulationChanged = true;
	}


	// Changement Parametres simulation : Attitude
	// ---------------------------------------------------------
	if (window.AttitudeChanged)
	{
		_params['SimuAttitude'] = ""

		// Attitude
		+ window.Input_heading.getValue() + ","
		+ window.Input_roll.getValue() + ","
		+ window.Input_pitch.getValue() + ","

		// Attitude Standard Dev
		+ ((GIWIK.stddev) ? window.Input_heading_stddev.getValue() : 0) + ","
		+ ((GIWIK.stddev) ? window.Input_roll_stddev.getValue() : 0) + ","
		+ ((GIWIK.stddev) ? window.Input_pitch_stddev.getValue() : 0) + ","

		// Attitude wave form
		+ window.Input_heading_period.getValue() + ","
		+ window.Input_heading_amplitude.getValue() + ","
		+ window.Input_roll_period.getValue() + ","
		+ window.Input_roll_amplitude.getValue() + ","
		+ window.Input_pitch_period.getValue() + ","
		+ window.Input_pitch_amplitude.getValue();

	}

	// Changement Parametres simulation : Position
	// ---------------------------------------------------------
	if (window.PositionChanged)
	{
		// Coordonnées UTM
		if (GIWIK.coordinate_mode === 1)
		{
			_params['SimuPositionUTM'] = ""

		   // Position  UTM
		   + window.Input_northing.getValue() + ","
		   + window.Input_easting.getValue() + ","
		   + eval(GIWIK.alti_depth_sign*window.Input_altidepth.getValue()) + ","
		   + window.Input_zone.getValue() + ","

		   // Standard dev
		   + ((GIWIK.stddev) ? window.Input_northing_stddev.getValue() : 0) + ","
		   + ((GIWIK.stddev) ? window.Input_easting_stddev.getValue() : 0) + ","
		   + ((GIWIK.stddev) ? window.Input_altidepth_stddev.getValue() : 0);
		}
		// Lat/Long
		else
		{
			_params['SimuPosition'] = ""

			// Position Lat/Long
			+ window.Input_latitude.getValue() + ","
			+ window.Input_longitude.getValue() + ","
			+ GIWIK.alti_depth_sign*window.Input_altidepth.getValue() + ","

			// Standard dev
			+ ((GIWIK.stddev) ? window.Input_latitude_stddev.getValue() : 0) + ","
			+ ((GIWIK.stddev) ? window.Input_longitude_stddev.getValue() : 0) + ","
			+ ((GIWIK.stddev) ? window.Input_altidepth_stddev.getValue() : 0);
		}
	}

	// Speeds and Standard deviation
	// ----------------------------------------
	if (window.SpeedsChanged)
	{
		_params['SimuSpeeds'] = ""

		// Speeds
		+ window.Input_speed_xv1.getValue() + ","
		+ window.Input_speed_xv2.getValue() + ","
		+ window.Input_speed_xv3.getValue() + ","

		// Speeds Standard Dev
		+ (GIWIK.stddev ? window.Input_speed_xv1_stddev.getValue() : 0) + ","
		+ (GIWIK.stddev ? window.Input_speed_xv2_stddev.getValue() : 0) + ","
		+ (GIWIK.stddev ? window.Input_speed_xv3_stddev.getValue() : 0) + ","

		// Speeds wave form
		+ window.Input_speed_xv1_period.getValue() + ","
		+ window.Input_speed_xv1_amplitude.getValue() + ","
		+ window.Input_speed_xv2_period.getValue() + ","
		+ window.Input_speed_xv2_amplitude.getValue() + ","
		+ window.Input_speed_xv3_period.getValue() + ","
		+ window.Input_speed_xv3_amplitude.getValue();
	}

	// Heave Surge and Sway
	// ------------------------------
	if (window.HeaveSurgeSwayChanged)
	{
		_params['SimuHSS'] = ""

		// HSS
		+ window.Input_surge.getValue() + ","
		+ window.Input_sway.getValue() + ","
		+ window.Input_heave.getValue();
	}

	// Acc Rot Rate
	// -----------------
	if (window.AccelerationsChanged || window.RotationRatesChanged)
	{
		_params['SimuAccRot'] = ""

		// Acc
		+ window.Input_acc_xv1.getValue() + ","
		+ window.Input_acc_xv2.getValue() + ","
		+ window.Input_acc_xv3.getValue() + ","

		// Rotation rate
		+ window.Input_rotrate_xv1.getValue() + ","
		+ window.Input_rotrate_xv2.getValue() + ","
		+ window.Input_rotrate_xv3.getValue();
	}

	// Status
	// --------
	if (window.StatusChanged)
	{
		_params['SimuStatus'] = ""

		// Sensor2 Status
		+ window.Checkbox_FOGError.getValue() + ","
		+ window.Checkbox_ACCError.getValue() + ","
		+ window.Checkbox_SRCError.getValue() + ","
		+ window.Checkbox_TEMPError.getValue() + ","
		+ window.Checkbox_DegradedMode.getValue() + ","
		+ window.Checkbox_FailureMode.getValue() + ","

		// Algo1 Status
		+ window.Checkbox_StaticAlignment.getValue() + ",";
		
		
		if( GIWIK.ihm_codename == 'gyro' || GIWIK.is_gyro==true )
		{
			_params['SimuStatus'] += window.Checkbox_HRPUnvalid.getValue() + ",0,0";	
		}
		else
		{
			_params['SimuStatus'] += window.Checkbox_Navigation.getValue() + ","
								  + window.Checkbox_AltitudeSaturation.getValue() + ","
								  + window.Checkbox_SpeedSaturation.getValue();		
		}
		

	}

	// B: Envoi
	// ----------
	if (window.EnableSimulationChanged
		|| window.AttitudeChanged
		|| window.PositionChanged
		|| window.SpeedsChanged
		|| window.HeaveSurgeSwayChanged
		|| window.AccelerationsChanged
		|| window.RotationRatesChanged
		|| window.StatusChanged)
	{
		window.EnableSimulationChanged = false;
		window.AttitudeChanged = false;
		window.PositionChanged = false;
		window.SpeedsChanged = false;
		window.HeaveSurgeSwayChanged = false;
		window.AccelerationsChanged = false;
		window.RotationRatesChanged = false;
		window.StatusChanged = false;

		return _params;
	}

};

HEADING.construct._plugins.simulation = function ()
{
	var cnt = '';

	// Enable Simulation Mode
	cnt += '<div class="params_simu">'
		+'<div id="switch_enable_simulation_mode"></div>'
	+'</div>'

	+'<div id="simulation_params_ctnr" style="display:none">'

		// Parametres entrées Attitude Heading
		+'<div id="params_attitude_heading_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_heading"></div>'
				+'<div id="input_heading_period"></div>'
				+'<div id="input_heading_amplitude"></div>'
			+'</div>'
		+'</div>'

		// Parametres entrées Attitude Roll
		+'<div id="params_attitude_roll_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_roll"></div>'
				+'<div id="input_roll_period"></div>'
				+'<div id="input_roll_amplitude"></div>'
			+'</div>'
		+'</div>'

		// Parametres entrées Attitude Pitch
		+'<div id="params_attitude_pitch_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_pitch"></div>'
				+'<div id="input_pitch_period"></div>'
				+'<div id="input_pitch_amplitude"></div>'
			+'</div>'
		+'</div>'

		// Parametres entrées Attitude Standart Deviation
		+'<div id="params_attitudestddev_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_heading_stddev"></div>'
				+'<div id="input_roll_stddev"></div>'
				+'<div id="input_pitch_stddev"></div>'
			+'</div>'
		+'</div>'

		// Parametres entrées Position
		+'<div id="params_position_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_latitude"></div>'
				+'<div id="input_longitude"></div>'
				+'<div id="input_northing"></div>'
				+'<div id="input_easting"></div>'
				+'<div id="input_zone"></div>'
				+'<div id="input_altidepth"></div>'
			+'</div>'
		+'</div>'

		// Parametres entrées Position Standart Deviation
		+'<div id="params_positionstddev_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_latitude_stddev"></div>'
				+'<div id="input_longitude_stddev"></div>'
				+'<div id="input_northing_stddev"></div>'
				+'<div id="input_easting_stddev"></div>'
				+'<div id="input_altidepth_stddev"></div>'
			+'</div>'
		+'</div>'

		// Parametres Speeds XV1
		+'<div id="params_speeds_xv1_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_speed_xv1"></div>'
				+'<div id="input_speed_xv1_period"></div>'
				+'<div id="input_speed_xv1_amplitude"></div>'
			+'</div>'
		+'</div>'

		// Parametres Speeds XV2
		+'<div id="params_speeds_xv2_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_speed_xv2"></div>'
				+'<div id="input_speed_xv2_period"></div>'
				+'<div id="input_speed_xv2_amplitude"></div>'
			+'</div>'
		+'</div>'

		// Parametres Speeds XV3
		+'<div id="params_speeds_xv3_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_speed_xv3"></div>'
				+'<div id="input_speed_xv3_period"></div>'
				+'<div id="input_speed_xv3_amplitude"></div>'
			+'</div>'
		+'</div>'

		// Parametres Speeds Standard dev
		+'<div id="params_speedsstddev_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_speed_xv1_stddev"></div>'
				+'<div id="input_speed_xv2_stddev"></div>'
				+'<div id="input_speed_xv3_stddev"></div>'
			+'</div>'
		+'</div>'

			// Parametres Heave Surge Sway
		+ '<div id="params_heavesurgesway_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_surge"></div>'
				+'<div id="input_sway"></div>'
				+'<div id="input_heave"></div>'
			+'</div>'
		+'</div>';
		
		// Parametres Accelerations
		cnt += '<div id="params_accelerations_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_acc_xv1"></div>'
				+'<div id="input_acc_xv2"></div>'
				+'<div id="input_acc_xv3"></div>'
			+'</div>'
		+'</div>'

		// Parametres Rotation Rate
		+'<div id="params_rotationrates_inputs">'
			+'<div class="params_simu">'
				+'<div id="input_rotrate_xv1"></div>'
				+'<div id="input_rotrate_xv2"></div>'
				+'<div id="input_rotrate_xv3"></div>'
			+'</div>'
		+'</div>'

		// Parametres Status Sensor
		+'<div id="params_sensorstatus_inputs">'
			+'<div class="params_simu">'
				+'<div id="checkbox_FOGError"></div>'
				+'<div id="checkbox_ACCError"></div>'
				+'<div id="checkbox_SRCError"></div>'
				+'<div id="checkbox_TEMPError"></div>'
				+'<div id="checkbox_DegradedMode"></div>'
				+'<div id="checkbox_FailureMode"></div>'
			+'</div>'
		+'</div>'

		// Parametres Status Algo
		+'<div id="params_algostatus_inputs">'
			+'<div class="params_simu">'
				+'<div id="checkbox_StaticAlignment"></div>'
				+'<div id="checkbox_Navigation"></div>'
				+'<div id="checkbox_HRPUnvalid"></div>'
				+'<div id="checkbox_AltitudeSaturation"></div>'
				+'<div id="checkbox_SpeedSaturation"></div>'
			+'</div>'
		+'</div>'

	+'</div>';


	// Construction Box
	$('#content').append(GIWIK.box(cnt, MSG(['box','simulation_mode_title']), true, [], ['', 'box_content_nopaddingtop']));


	window.heading_labels_width = 160; 	// Définit la largeur des labels des paramètres de la page
	window.heading_input_width  = 100; 	// Définit la largeur des inputs des paramètres de la page


	// Groupes de paramètres
	GIWIK.paramGroup.construct('params_attitude_heading_inputs', MSG(['parameters','heading']), (GIWIK._plugins.simulation.hrp) ? 'show' : 'displaynone');
	GIWIK.paramGroup.construct('params_attitude_roll_inputs', MSG(['box','simu_params_attitude']) +": "+ MSG(['parameters','roll']), (GIWIK._plugins.simulation.hrp) ? 'show' : 'displaynone');
	GIWIK.paramGroup.construct('params_attitude_pitch_inputs', MSG(['box','simu_params_attitude']) +": "+ MSG(['parameters','pitch']), (GIWIK._plugins.simulation.hrp) ? 'show' : 'displaynone');

	GIWIK.paramGroup.construct('params_position_inputs', MSG(['box','simu_params_position']), (GIWIK._plugins.simulation.position) ? 'show' : 'displaynone');

	GIWIK.paramGroup.construct('params_speeds_xv1_inputs', MSG(['box','simu_params_speed']) +": "+ MSG(['parameters','speed_xv1_label']), (GIWIK._plugins.simulation.speed) ? 'show' : 'displaynone');
	GIWIK.paramGroup.construct('params_speeds_xv2_inputs', MSG(['box','simu_params_speed']) +": "+ MSG(['parameters','speed_xv2_label']), (GIWIK._plugins.simulation.speed) ? 'show' : 'displaynone');
	GIWIK.paramGroup.construct('params_speeds_xv3_inputs', MSG(['box','simu_params_speed']) +": "+ MSG(['parameters','speed_xv3_label']), (GIWIK._plugins.simulation.speed) ? 'show' : 'displaynone');

	GIWIK.paramGroup.construct('params_heavesurgesway_inputs', MSG(['box','simu_params_heavesurgesway']), (GIWIK._plugins.simulation.heave_surge_sway) ? 'show' : 'displaynone');

	GIWIK.paramGroup.construct('params_accelerations_inputs', MSG(['box','simu_params_acceleration']), (GIWIK._plugins.simulation.acceleration_rotation) ? 'show' : 'displaynone');
	GIWIK.paramGroup.construct('params_rotationrates_inputs', MSG(['box','simu_params_rotationrate']), (GIWIK._plugins.simulation.acceleration_rotation) ? 'show' : 'displaynone');

	GIWIK.paramGroup.construct('params_sensorstatus_inputs', MSG(['box','simu_params_sensorstatus']), (GIWIK._plugins.simulation.status) ? 'show' : 'displaynone');

	GIWIK.paramGroup.construct('params_algostatus_inputs', MSG(['box','simu_params_algostatus']), (GIWIK._plugins.simulation.status) ? 'show' : 'displaynone');


	// Paramètre "Enable Simulation Mode"
	window.Switch_enable_simulation_mode = new Switch('Switch_enable_simulation_mode', true);
	window.Switch_enable_simulation_mode.label_width = window.heading_labels_width;
	window.Switch_enable_simulation_mode.construct('switch_enable_simulation_mode', 'linear', MSG(['parameters','enable_simu_mode_label']), [0,1], true);
	window.Switch_enable_simulation_mode.setAction("$('#simulation_params_ctnr')['slide'+((window.Switch_enable_simulation_mode.getValue() === 1) ? 'Down' : 'Up')]();", false);
	window.Switch_enable_simulation_mode.show();


	// Paramètres Attitude Heading
	window.Input_heading = new Input_int('Input_heading', true);
	window.Input_heading.label_width = window.heading_labels_width;
	window.Input_heading.input_width= window.heading_input_width;
	window.Input_heading.construct('input_heading','linear',MSG(['parameters','mean_value_label']),0.001,0,360,MSG(['units','degree']));
	window.Input_heading.setAction("window.AttitudeChanged=true;",false);
	window.Input_heading.show();

	window.Input_heading_period = new Input_int('Input_heading_period', true);
	window.Input_heading_period.label_width = window.heading_labels_width;
	window.Input_heading_period.input_width= window.heading_input_width;
	window.Input_heading_period.construct('input_heading_period','linear',MSG(['parameters','period_label']),0.01,0,1000,MSG(['units','second']));
	window.Input_heading_period.setAction("window.AttitudeChanged=true;",false);
	window.Input_heading_period.show();

	window.Input_heading_amplitude = new Input_int('Input_heading_amplitude', true);
	window.Input_heading_amplitude.label_width = window.heading_labels_width;
	window.Input_heading_amplitude.input_width= window.heading_input_width;
	window.Input_heading_amplitude.construct('input_heading_amplitude','linear',MSG(['parameters','amplitude_label']),0.001,0,360,MSG(['units','degree']));
	window.Input_heading_amplitude.setAction("window.AttitudeChanged=true;",false);
	window.Input_heading_amplitude.show();


	// Attitude Roll
	window.Input_roll = new Input_int('Input_roll', true);
	window.Input_roll.label_width = window.heading_labels_width;
	window.Input_roll.input_width= window.heading_input_width;
	window.Input_roll.construct('input_roll','linear',MSG(['parameters','mean_value_label']),0.001,-180,180,MSG(['units','degree']));
	window.Input_roll.setAction("window.AttitudeChanged=true;",false);
	window.Input_roll.show();

	window.Input_roll_period = new Input_int('Input_roll_period', true);
	window.Input_roll_period.label_width = window.heading_labels_width;
	window.Input_roll_period.input_width= window.heading_input_width;
	window.Input_roll_period.construct('input_roll_period','linear',MSG(['parameters','period_label']),0.01,0,1000,MSG(['units','second']));
	window.Input_roll_period.setAction("window.AttitudeChanged=true;",false);
	window.Input_roll_period.show();

	window.Input_roll_amplitude = new Input_int('Input_roll_amplitude', true);
	window.Input_roll_amplitude.label_width = window.heading_labels_width;
	window.Input_roll_amplitude.input_width= window.heading_input_width;
	window.Input_roll_amplitude.construct('input_roll_amplitude','linear',MSG(['parameters','amplitude_label']),0.001,0,360,MSG(['units','degree']));
	window.Input_roll_amplitude.setAction("window.AttitudeChanged=true;",false);
	window.Input_roll_amplitude.show();


	// Attitude Pitch
	window.Input_pitch = new Input_int('Input_pitch', true);
	window.Input_pitch.label_width = window.heading_labels_width;
	window.Input_pitch.input_width= window.heading_input_width;
	window.Input_pitch.construct('input_pitch','linear',MSG(['parameters','mean_value_label']),0.001,-90,90,MSG(['units','degree']));
	window.Input_pitch.setAction("window.AttitudeChanged=true;",false);
	window.Input_pitch.show();

	window.Input_pitch_period = new Input_int('Input_pitch_period', true);
	window.Input_pitch_period.label_width = window.heading_labels_width;
	window.Input_pitch_period.input_width= window.heading_input_width;
	window.Input_pitch_period.construct('input_pitch_period','linear',MSG(['parameters','period_label']),0.01,0,1000,MSG(['units','second']));
	window.Input_pitch_period.setAction("window.AttitudeChanged=true;",false);
	window.Input_pitch_period.show();

	window.Input_pitch_amplitude = new Input_int('Input_pitch_amplitude', true);
	window.Input_pitch_amplitude.label_width = window.heading_labels_width;
	window.Input_pitch_amplitude.input_width= window.heading_input_width;
	window.Input_pitch_amplitude.construct('input_pitch_amplitude','linear',MSG(['parameters','amplitude_label']),0.001,0,180,MSG(['units','degree']));
	window.Input_pitch_amplitude.setAction("window.AttitudeChanged=true;",false);
	window.Input_pitch_amplitude.show();


	window.Input_altidepth = new Input_int('Input_altidepth', true);
	window.Input_altidepth.label_width = window.heading_labels_width;
	window.Input_altidepth.input_width= window.heading_input_width;
	window.Input_altidepth.construct('input_altidepth','linear',(GIWIK.alti_depth) ? MSG(['parameters',GIWIK.alti_depth]) : '',0.01,-15000,15000,MSG(['units','meter']));
	window.Input_altidepth.setAction("window.PositionChanged=true;");
	window.Input_altidepth[(GIWIK.alti_depth) ? 'show' : 'hide']();


	// Parametres Linear Speeds: XV1,2,3
	for ( var i=1; i<=3; i++ )
	{
		eval( "window.Input_speed_xv"+i+" = new Input_int('Input_speed_xv"+i+"', true); ");
		eval( "window.Input_speed_xv"+i+".label_width = window.heading_labels_width; ");
		eval( "window.Input_speed_xv"+i+".input_width= window.heading_input_width; ");
		eval( "window.Input_speed_xv"+i+".construct('input_speed_xv"+i+"','linear',MSG(['parameters','mean_value_label']),0.01,-250,250,MSG(['units','meter_per_second'])); ");
		eval( "window.Input_speed_xv"+i+".setAction('window.SpeedsChanged=true;'); ");
		eval( "window.Input_speed_xv"+i+".show(); ");

		eval( "window.Input_speed_xv"+i+"_period = new Input_int('Input_speed_xv"+i+"_period', true); ");
		eval( "window.Input_speed_xv"+i+"_period.label_width = window.heading_labels_width; ");
		eval( "window.Input_speed_xv"+i+"_period.input_width= window.heading_input_width; ");
		eval( "window.Input_speed_xv"+i+"_period.construct('input_speed_xv"+i+"_period','linear',MSG(['parameters','period_label']),0.01,0,1000,MSG(['units','second'])); ");
		eval( "window.Input_speed_xv"+i+"_period.setAction('window.SpeedsChanged=true;'); ");
		eval( "window.Input_speed_xv"+i+"_period.show(); ");

		eval( "window.Input_speed_xv"+i+"_amplitude = new Input_int('Input_speed_xv"+i+"_amplitude', true); ");
		eval( "window.Input_speed_xv"+i+"_amplitude.label_width = window.heading_labels_width; ");
		eval( "window.Input_speed_xv"+i+"_amplitude.input_width= window.heading_input_width; ");
		eval( "window.Input_speed_xv"+i+"_amplitude.construct('input_speed_xv"+i+"_amplitude','linear',MSG(['parameters','amplitude_label']),0.01,0,250,MSG(['units','meter_per_second'])); ");
		eval( "window.Input_speed_xv"+i+"_amplitude.setAction('window.SpeedsChanged=true;'); ");
		eval( "window.Input_speed_xv"+i+"_amplitude.show(); ");
	}


	// Parametres Heave, Surge, Sway
	window.Input_surge = new Input_int('Input_surge', true);
	window.Input_surge.label_width = window.heading_labels_width;
	window.Input_surge.input_width= window.heading_input_width;
	window.Input_surge.construct('input_surge','linear',MSG(['parameters','surge']),0.01,-10,10,MSG(['units','meter']));
	window.Input_surge.setAction("window.HeaveSurgeSwayChanged=true;");
	window.Input_surge.show();

	window.Input_sway = new Input_int('Input_sway', true);
	window.Input_sway.label_width = window.heading_labels_width;
	window.Input_sway.input_width= window.heading_input_width;
	window.Input_sway.construct('input_sway','linear',MSG(['parameters','sway']),0.01,-10,10,MSG(['units','meter']));
	window.Input_sway.setAction("window.HeaveSurgeSwayChanged=true;");
	window.Input_sway.show();

	window.Input_heave = new Input_int('Input_heave', true);
	window.Input_heave.label_width = window.heading_labels_width;
	window.Input_heave.input_width= window.heading_input_width;
	window.Input_heave.construct('input_heave','linear',MSG(['parameters','heave']),0.01,-10,10,MSG(['units','meter']));
	window.Input_heave.setAction("window.HeaveSurgeSwayChanged=true;");
	window.Input_heave.show();


	// Accelerations
	for ( var i=1; i<=3; i++ )
	{
		eval( "window.Input_acc_xv"+i+" = new Input_int('Input_acc_xv"+i+"', true); ");
		eval( "window.Input_acc_xv"+i+".label_width = window.heading_labels_width; ");
		eval( "window.Input_acc_xv"+i+".input_width= window.heading_input_width; ");
		eval( "window.Input_acc_xv"+i+".construct('input_acc_xv"+i+"','linear',MSG(['parameters','acc_xv"+i+"_label']),0.01,-300,300,MSG(['units','meter_per_second2'])); ");
		eval( "window.Input_acc_xv"+i+".setAction('window.AccelerationsChanged=true;'); ");
		eval( "window.Input_acc_xv"+i+".show();	 ");
	}

	// Rotation Rate
	for ( var i=1; i<=3; i++ )
	{
		eval( "window.Input_rotrate_xv"+i+" = new Input_int('Input_rotrate_xv"+i+"', true); ");
		eval( "window.Input_rotrate_xv"+i+".label_width = window.heading_labels_width; ");
		eval( "window.Input_rotrate_xv"+i+".input_width= window.heading_input_width; ");
		eval( "window.Input_rotrate_xv"+i+".construct('input_rotrate_xv"+i+"','linear',MSG(['parameters','rotrate_xv"+i+"_label']),0.001,-750,750,MSG(['units','degree_per_second'])); ");
		eval( "window.Input_rotrate_xv"+i+".setAction('window.RotationRatesChanged=true;'); ");
		eval( "window.Input_rotrate_xv"+i+".show(); ");
	}

	// Status
	window.Checkbox_FOGError = new Input_checkbox('Checkbox_FOGError', true);
	window.Checkbox_FOGError.label_width = window.heading_labels_width + window.heading_input_width/2 - 5;
	window.Checkbox_FOGError.height = 22;
	window.Checkbox_FOGError.construct('checkbox_FOGError','linear',MSG(['parameters','status_FOGerror_label']),[0,1],true);
	window.Checkbox_FOGError.setAction("window.StatusChanged=true;");
	window.Checkbox_FOGError.show();

	window.Checkbox_ACCError = new Input_checkbox('Checkbox_ACCError', true);
	window.Checkbox_ACCError.label_width = window.heading_labels_width + window.heading_input_width/2 - 5;
	window.Checkbox_ACCError.height = 22;
	window.Checkbox_ACCError.construct('checkbox_ACCError','linear',MSG(['parameters','status_ACCerror_label']),[0,1],true);
	window.Checkbox_ACCError.setAction("window.StatusChanged=true;");
	window.Checkbox_ACCError.show();

	window.Checkbox_SRCError = new Input_checkbox('Checkbox_SRCError', true);
	window.Checkbox_SRCError.label_width = window.heading_labels_width + window.heading_input_width/2 - 5;
	window.Checkbox_SRCError.height = 22;
	window.Checkbox_SRCError.construct('checkbox_SRCError','linear',MSG(['parameters','status_SRCerror_label']),[0,1],true);
	window.Checkbox_SRCError.setAction("window.StatusChanged=true;");
	window.Checkbox_SRCError.show();

	window.Checkbox_TEMPError = new Input_checkbox('Checkbox_TEMPError', true);
	window.Checkbox_TEMPError.label_width = window.heading_labels_width + window.heading_input_width/2 - 5;
	window.Checkbox_TEMPError.height = 22;
	window.Checkbox_TEMPError.construct('checkbox_TEMPError','linear',MSG(['parameters','status_TEMPerror_label']),[0,1],true);
	window.Checkbox_TEMPError.setAction("window.StatusChanged=true;");
	window.Checkbox_TEMPError.show();


	window.Checkbox_DegradedMode = new Input_checkbox('Checkbox_DegradedMode', true);
	window.Checkbox_DegradedMode.label_width = window.heading_labels_width + window.heading_input_width/2 - 5;
	window.Checkbox_DegradedMode.height = 22;
	window.Checkbox_DegradedMode.construct('checkbox_DegradedMode','linear',MSG(['parameters','status_degradedmode_label']),[0,1],true);
	window.Checkbox_DegradedMode.setAction("window.StatusChanged=true;");
	window.Checkbox_DegradedMode.show();

	window.Checkbox_FailureMode = new Input_checkbox('Checkbox_FailureMode', true);
	window.Checkbox_FailureMode.label_width = window.heading_labels_width + window.heading_input_width/2 - 5;
	window.Checkbox_FailureMode.height = 22;
	window.Checkbox_FailureMode.construct('checkbox_FailureMode','linear',MSG(['parameters','status_failuremode_label']),[0,1],true);
	window.Checkbox_FailureMode.setAction("window.StatusChanged=true;");
	window.Checkbox_FailureMode.show();

	window.Checkbox_StaticAlignment = new Input_checkbox('Checkbox_StaticAlignment', true);
	window.Checkbox_StaticAlignment.label_width = window.heading_labels_width + window.heading_input_width/2 - 5;
	window.Checkbox_StaticAlignment.height = 22;
	window.Checkbox_StaticAlignment.construct('checkbox_StaticAlignment','linear',MSG(['parameters','status_staticalignement_label']),[0,1],true);
	window.Checkbox_StaticAlignment.setAction("window.StatusChanged=true;");
	window.Checkbox_StaticAlignment.show();

	if( GIWIK.ihm_codename == 'gyro' || GIWIK.is_gyro==true )
	{
		window.Checkbox_HRPUnvalid = new Input_checkbox('Checkbox_HRPUnvalid', true);
		window.Checkbox_HRPUnvalid.label_width = window.heading_labels_width + window.heading_input_width/2 - 5;
		window.Checkbox_HRPUnvalid.height = 22;
		window.Checkbox_HRPUnvalid.construct('checkbox_HRPUnvalid','linear',MSG(['parameters','status_HRPunvalid_label']),[0,1],true);
		window.Checkbox_HRPUnvalid.setAction("window.StatusChanged=true;");
		window.Checkbox_HRPUnvalid.show();
	}
	else
	{
		window.Checkbox_Navigation = new Input_checkbox('Checkbox_Navigation', true);
		window.Checkbox_Navigation.label_width = window.heading_labels_width + window.heading_input_width/2 - 5;
		window.Checkbox_Navigation.height = 22;
		window.Checkbox_Navigation.construct('checkbox_Navigation','linear',MSG(['parameters','status_navigation_label']),[0,1],true);
		window.Checkbox_Navigation.setAction("window.StatusChanged=true;");
		window.Checkbox_Navigation.show();
	
		window.Checkbox_AltitudeSaturation = new Input_checkbox('Checkbox_AltitudeSaturation', true);
		window.Checkbox_AltitudeSaturation.label_width = window.heading_labels_width + window.heading_input_width/2 - 5;
		window.Checkbox_AltitudeSaturation.height = 22;
		window.Checkbox_AltitudeSaturation.construct('checkbox_AltitudeSaturation','linear',MSG(['parameters','status_altitudesaturation_label']),[0,1],true);
		window.Checkbox_AltitudeSaturation.setAction("window.StatusChanged=true;");
		window.Checkbox_AltitudeSaturation.show();

		window.Checkbox_SpeedSaturation = new Input_checkbox('Checkbox_SpeedSaturation', true);
		window.Checkbox_SpeedSaturation.label_width = window.heading_labels_width + window.heading_input_width/2 - 5;
		window.Checkbox_SpeedSaturation.height = 22;
		window.Checkbox_SpeedSaturation.construct('checkbox_SpeedSaturation','linear',MSG(['parameters','status_speedsaturation_label']),[0,1],true);
		window.Checkbox_SpeedSaturation.setAction("window.StatusChanged=true;");
		window.Checkbox_SpeedSaturation.show();
	}

	// Ecarts types
	GIWIK.paramGroup.construct('params_attitudestddev_inputs', MSG(['box','simu_params_heading_and_attitude_stddev']), (GIWIK.stddev) ? 'show' : 'displaynone');
	GIWIK.paramGroup.construct('params_speedsstddev_inputs', MSG(['box','simu_params_speed_stddev']), (GIWIK.stddev) ? 'show' : 'displaynone');

	// Paramètres Attitude Standart Dev
	window.Input_heading_stddev = new Input_int('Input_heading_stddev', true);
	window.Input_heading_stddev.label_width = window.heading_labels_width;
	window.Input_heading_stddev.input_width= window.heading_input_width;
	window.Input_heading_stddev.construct('input_heading_stddev','linear',MSG(['parameters','heading']),0.01,0,5,MSG(['units','degree']));
	window.Input_heading_stddev.setAction("window.AttitudeChanged=true;",false);
	window.Input_heading_stddev.show();

	window.Input_roll_stddev = new Input_int('Input_roll_stddev', true);
	window.Input_roll_stddev.label_width = window.heading_labels_width;
	window.Input_roll_stddev.input_width= window.heading_input_width;
	window.Input_roll_stddev.construct('input_roll_stddev','linear',MSG(['parameters','roll']),0.01,0,5,MSG(['units','degree']));
	window.Input_roll_stddev.setAction("window.AttitudeChanged=true;",false);
	window.Input_roll_stddev.show();

	window.Input_pitch_stddev = new Input_int('Input_pitch_stddev', true);
	window.Input_pitch_stddev.label_width = window.heading_labels_width;
	window.Input_pitch_stddev.input_width= window.heading_input_width;
	window.Input_pitch_stddev.construct('input_pitch_stddev','linear',MSG(['parameters','pitch']),0.01,0,5,MSG(['units','degree']));
	window.Input_pitch_stddev.setAction("window.AttitudeChanged=true;",false);
	window.Input_pitch_stddev.show();


	// Parametres Linear Speeds Satndard deviation
	for ( var i=1; i<=3; i++ )
	{
		eval( "window.Input_speed_xv"+i+"_stddev = new Input_int('Input_speed_xv"+i+"_stddev', true); ");
		eval( "window.Input_speed_xv"+i+"_stddev.label_width = window.heading_labels_width; ");
		eval( "window.Input_speed_xv"+i+"_stddev.input_width= window.heading_input_width; ");
		eval( "window.Input_speed_xv"+i+"_stddev.construct('input_speed_xv"+i+"_stddev','linear',MSG(['parameters','speed_xv"+i+"_label']),0.01,0,10,MSG(['units','meter_per_second'])); ");
		eval( "window.Input_speed_xv"+i+"_stddev.setAction('window.SpeedsChanged=true;'); ");
		eval( "window.Input_speed_xv"+i+"_stddev.show(); ");
	}

	// Init
	window.EnableSimulationChanged = false;
	window.AttitudeChanged = false;
	window.PositionChanged = false;
	window.SpeedsChanged = false;
	window.HeaveSurgeSwayChanged = false;
	window.AccelerationsChanged = false;
	window.RotationRatesChanged = false;
	window.StatusChanged = false;
};