<?php

// Appel de l'include de GIWIK contenant les fonctions génériques de simulation ————————————————————————————————————————————————————————————————
$giwik_dir = "../_GIWIK_/php/cgi_simulator.inc.php";
require (is_file($giwik_dir) ? $giwik_dir : "../".$giwik_dir);
//——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

// Définition du type de système
$system_type = init();

init_param('is_started',true);

if (get_param('is_started') === false)
{
	if (get_param('is_started_count') > 5)
	{
		set_param('is_started',true);
		set_param('is_started_count',0);
	}
	else
	{
		set_param('is_started_count',get_param('is_started_count')+1);
	}
}

// ui_status: 				uiSor1Status, 	uiSor2Status,	uiAlg1Status, 	uiAlg2Status, 	uiSys1Status, 	uiSys2Status, 	uiAlg3Status, 	uiSys3Status, 	uiAlg4Status,	uiAlg5Status
//set_param('_ui_status',[	0x00000000,		0xf0000000,		0x00000000,		0x00000000,		0x00000000,		0x00000000,		0x00000000,		0x00000000,		0x0000FFFF]);
//set_param('_ui_status',[	0x00000000,		0x00000000,		0x00000004,		0x00000000,		0x00000000,		0x00000000,		0x00000000,		0x00000000,		0x00000400]);
set_param('_ui_status',[	0x00000000,		0x00000000,		0x00000002,		0x20009000,		0x00000000,		0x00000000,		0x00000000,		0x00000000,		0x00000200, 	0x00000002]);
                // tous les bits "[0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF]";
				// system ready : [0,0,1,0,0,0,0,0]
				// system ready avec GPS 1 valid et GPS 2 valid : [0,0,8193,32,0,0,0,0]
				// alignement : [0,0,6,0,0,0,0,0]
				// alignement fin : [0,0,4,0,0,0,0,0]
				// saturation altitude : [0,0,268435456,0,0,0,0,0]
				// saturation vitesse : [0,0,536870912,0,0,0,0,0]
				// test SAMS avec DVL rejeté
				//$_ui_status = "[0,0,0x901,0,0xFFFFFFFF,0,0,0]";	// INS ready avec DVL rejeté
				//$_ui_status = "[0,0,0x900,0x400000,0xFFFFFFFF,0,0,0]";	// alignement avec DVL rejeté
				// system ready et synchro_UTC2 et synchro_PPS2: [0,0,1,0,0,0,0,3]
				// alignement rapide rejeté  [0,0,0,0,0,0,0x40000,0]

// DEBUG ------------------------------------------------------------------------------------------------------------------------
 //set_param('_ui_status',[0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF]);
//-------------------------------------------------------------------------------------------------------------------------------

//license Product
init_param('LicenseID','A3D6F534127DDFE4');
init_param('LicenseCode','F839E5D243A59FE9D');  // direct le bon code pour être tranquille en simulation !

if (get_param('LicenseCode') == 'F839E5D243A59FE9C')
{
	set_param('LicenseState',1);
}
else
{
	set_param('LicenseState',0);
}

//Upgrade Product
init_param('UpgradeLicenseID','0019-8c30-2313-2313');
init_param('UpgradeLicenseCode','F839E5D243A59FE9C');  // direct le bon code pour être tranquille en simulation !

if (get_param('UpgradeLicenseCode') == 'F839E5D243A59FE9C')
{
	set_param('UpgradeLicenseState',"1");
}
else
{
	set_param('UpgradeLicenseState',"0");	
}

// Rajout pour page DP (Dynamic Positionning)
init_param('DP_State',[0,0]);
init_param('DP_GpsFilterParams',[0.030000,0.000000]);
init_param('DP_GpsModes',[1,1,1,1,1]);
init_param('DP_GpsOutQF',0);
init_param('DP_PosPrio',0);
init_param('DP_UsblFilterParams',[0.030000,0.000000]);
init_param('DP_EmlogSpeedStdDev',0.5);
init_param('DP_SpeedsStdDev',[0.050000,0.500000]);
init_param('DP_DepthStdDev',1.0);
init_param('DP_SpeedSaturation', 20.0);

init_param('ALERTCNF',[0.000, 0.000, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]);
init_param('KFMExtSensor',[1,1,2,1,1,1,1,1,1,1,1,1,0,1,1,1,1]);
init_param('MANPOS',[48.89910021,2.06350177,0.00]);
init_param('MANGPS',[48.89910021,2.06350177,0.00,0.00,0.00,0.00,0]);
init_param('MANPOSUTM',[5416662.03,431364.31,0.00,"U31"]);
init_param('MANGPSUTM',[5416662.03,431364.31,0.00,"U31",0.00,0.00,0.00,0]);
init_param('UtmZoneMode',0);
init_param('speed_norm',0);
init_param('ModeZUP',[0,0]);
init_param('ModeAlti',2);
init_param('DVLTAM',[10800.000,1.000]);
init_param('HeaveConf',1);
init_param('heading',180);
init_param('rotation_sign',1);
init_param('rotation_count',0);

init_param('MesaOrient',0);
init_param('MesaCrt',[0.000,0.000,0.000,1,0]);	//Cap, Roulis, Tangage, mesa usine utilisable(1:pion, 2:miroir, 3:les deux), mesa utilisateur (0:pion de centrage, 1:mirroir)
init_param('LVA',[0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000]);
init_param('COG',["0.000","0.000","0.000"]);
init_param('ModeStart',1);
init_param('ModeNavigation',1);
init_param('ManualSpeed',0.000);
init_param('ManualAttitude',[60.0,10.0,10.0,0.5,0.1,0.1]);
init_param('ModeDynamic',1);
init_param('ManualDataUpdate',[0,0]);
init_param('BackupSensors',0);
init_param('Turret',0);
init_param('SystemLVA',["0.000","0.000","0.000"]);
init_param('VehicleLVA',["0.000","0.000","0.000"]);
init_param('TurretBarrelLVA',["0.000","0.000","0.000"]);
init_param('SystemPos',0);
init_param('GPSPos',[0,0]);
init_param('ANGLESConv',[0,0,0]);
init_param('GeoidalSep',0.000);
init_param('ANGLESLatency',0.000000);

init_param('SimuMode',0);
init_param('SimuAttitude',[0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000]);
init_param('SimuPosition',[0.000000,0.000000,0.000,0.000,0.000,0.000]);
init_param('SimuPositionUTM',[0.000000,166021.443179,0.000,"N31",0.000,0.000,0.000]);
init_param('SimuSpeeds',[0.000,0.000,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00]);
init_param('SimuHSS',[0.00,0.00,0.00]);
init_param('SimuAccRot',[0.000,0.000,0.000,0.000,0.000,0.000]);
init_param('SimuStatus',[0,0,0,0,0,0,0,0,0,0]);

init_param('Passwords',["Navigator",0,"Operator",0,"Administrator",0,1]);

init_param('OPulseList',["None","OUT A Envelope","OUT B Envelope","OUT C Envelope","OUT D Envelope","OUT E Envelope","Dst trv rising","Dst trv falling","PPS Like","Timer rising","Timer falling"]);
init_param('OPulseParamType',[0,0,0,0,0,0,1,1,0,2,2]);

//init_param('OProList',["XC_2", "XC_1", "XC_0", "NONE            ","PAHRS", "Octans Standard ","From the library","PostProcessing    ","HETHS_HEROT   ","Motion Sensor 1 ","Motion Sensor 2 ","IMU Binary ","IMU ASCII"]);
init_param('OProList',["NONE            ","PHINS STANDARD  ","POSTPROCESSING  ","HALLIBURTON SAS ","DORADO          ","CONTROL NO G    ","NAVIGATION SHORT","NAVIGATION LONG ","GPS LIKE        ","IMU ASCII       ","IMU BINARY      ","NAV BINARY      ","VTG GGA         ","HEHDT           ","HEHDT FIXED     ","OCTANS STANDARD ","GYROCOMPASS     ","GYROCOMPASS 2   ","SOC AUTOSUB     ","SEAPATH         ","LONG BINARY NAV ","BUC             ","EMT SDV CGS     ","HDMS            ","SIMRAD EM       ","SIMRAD EM TSS   ","SIMRAD EM HEAVE2","HYDROGRAPHY     ","TECHSAS         ","TECHSAS TSS     ","PRDID           ","PRDID TSS       ","NAVIGATION      ","TSS1 DMS        ","TSS335B         ","TMS CCV IMBAT   ","POSIDONIA       ","NAV BHO         ","NAV BHO LONG    ","INDYN           ","DOLOG HRP       ","SENSOR RD       ","NAV AND CTD     ","EXT SENSOR BIN  ","DCN STD NAV1    ","DCN STD NAV10   ","SPERRY ATT      ","RIEGL LAS SCAN  ","AUVG3000        ","IXSEA TAH       ","SENIN           ","BROADCAST A     ","BROADCAST B     ","BROADCAST C     ","BROADCAST D     ","BROADCAST E     ","HEHDT HEROT     ","RDI SYNC        ","VTG GGU         ","LONG BIN NAV HR ","IXSEA ICCB1     ","RDI PD11        ","NAV BINARY HR   ","TUS             ","STOLT OFFSHORE2 ","GPS LIKE SHORT  ","POS MV GRP111   ","SEATEX DHEAVE   ","HEAVE POSTPRO   ","CONTROL         ","GAPS BIN        ","NAVIGATION HDLC ","DCN NAV1 FLF    ","SEROUT A RTC    ","SEROUT B RTC    ","SEROUT C RTC    ","SEROUT D RTC    ","SEROUT E RTC    ","SUBMERGENCE A   ","SUBMERGENCE B   ","PTNL GGK        ","NAV BINARY 1    ","KVH EXTENDED    ","POLAR NAV      ","INHDT           ","S40 NAV10       ","S40 NAV100      ","ANSCHUTZ STD20  ","DCN NAV1 FAA    ","DCN FAA         ","LRS10 78 IIC    ","LRS10 78 IC     ","LRS100 32 IIC   ","LRS100 32 IC    ","LRS100 35 IIC   ","LRS100 35 IC    ","SAS 2           ","MDL TRIM CUBE   ","PEGASE NAV      ","PEGASE CMS      ","PRECISE ZDA     ","LONG BIN NAV SM ","SAS 2B          ","SEANAV ID1      ","TOKIMEC PTVF    ","RDI PING        ","IMU RAW DATA    ","AIPOV           ","LONG BIN NAV HR 2","HETHS HEROT     ","RTCM SIGIL      ","KINETIC SCIENTIFIC","IXBLUE STD BIN V2","SPERRY ATT STAN ","STOLT OFFSHORE  ","IXBLUE STD BIN V3","STANDARD 2      ","INSITU          ","LRS10 61 IIC    ","LRS10 61 IC     ","LRS100 33 IIC   ","LRS100 33 IC    ","BHO GRAVI       ","MINIFOG OTG MSG8","NAV BHO2M       ","MDL 2           ","KM BINARY ","EVENT MARKER    ","NOT USE 44","NOT USE 45","NOT USE 46","NOT USE 47","NOT USE 48","NOT USE 49","NOT USE 50","NOT USE 51","NOT USE 52","NOT USE 53","NOT USE 54","NOT USE 55","NOT USE 56","NOT USE 57","NOT USE 58","NOT USE 59","NOT USE 60","NOT USE 61","NOT USE 62","NOT USE 63","NOT USE 64","NOT USE 65","NOT USE 66","NOT USE 67","NOT USE 68"]);
init_param('EDIRIXList',["None            ","Serial only     ","Ethernet only   "]);
init_param('EDIROXList',["None            ","Serial only     ","Ethernet only   ","Serial+Ethernet "]);
init_param('ParityList',["None","Even","Odd"]);
init_param('StopbitsList',["0.5 bitstop","1.0 bitstop","1.5 bitstop","2.0 bitstop"]);
init_param('LevelList',["RS232","RS422"]);
init_param('BaudrateList',["600 bauds","1.2 kbauds","2.4 kbauds","4.8 kbauds","9.6 kbauds","19.2 kbauds","38.4 kbauds","57.6 kbauds","115.2 kbauds","230.4 kbauds","460.8 kbauds"]);
init_param('ELCFIXList',["TCP Server      ","TCP Client      ","UDP             ","UDP BroadCast   ","UDP MultiCast   "]);
init_param('ELCFOXList',["TCP Server           ","TCP Client           ","UDP                  ","UDP Broadcast        ","UDP MultiCast        ","UDP Network Broadcast"]);
init_param('HeaveList',["Real Time Heave","Smart Heave (100s Delayed)"]);
init_param('LevelLvaList',["Primary         ","Secondary A     ","Secondary B     ","Secondary C     "]);
init_param('ModeZUPList',["None","Static 10m/s","Static 0.1m/s","AutoStatic","AutoStatic Bench","Position"]);
init_param('ModeAltiList',["Stabilization","GPS altitude","Depth sensor","Hydro altitude"]);
init_param('ModeHeaveList',["Slight Sea (<1.2m)","Moderate Sea (<2.5m)","Rough Sea (>2.5m)","Harbors and Channels"]);
init_param('AltiRefList',["Geoid (MSL)     ","Ellipsoid       "]);
init_param('ModeStartList',["Immediate run","Wait for position","Restore Position","Restore Attitude","Emulation mode"]);
init_param('ModeDynamicList',["Car","Plane"]);
init_param('ModeNavigationList',["None","Navigation","Firing","Firing on the Move","Aero Transportation","Travel Lock"]);
init_param('HRPConvList',["IXBLUE","STANAG","OTAN  "]);

// Configuration des ports
/*
0	Indice du protocole de sortie (voir OProList)
1	Indice du bras de levier de sortie (voir LevelLvaList)
2	Fréquence de sortie du protocole en ms :
3	Type de heave (voir HeaveList)
4	Sortie ou non de la ZDA (valeurs 0 ou 1) (Octans only)
5	Indice du protocole d’entrée (voir IProList)
6	Timeout pour l’entrée (automatic ou valeur entière positive) (non pris en compte)
7	Parité (voir ParityList) (I/O pr CINT1 et Out pr CINT2)
8	Bits de stop (voir StopBitList) (I/O pr CINT1 et Out pr CINT2)
9	Niveau (voir LevelList) (I/O pr CINT1 et Out pr CINT2)
10	Baudrate (voir BaudrateList) (I/O pr CINT1 et CINT2)
11	ExtraTime (outputs uniquement ?)
12  Parite Out (CINT2 only)
13  Bits de Stop Out (CINT2 only)
14  Niveau Out (RFU)
15  Baudrate (CINT2 only)
*/

init_param('PortConfR',[1,0,200,0,0,0,0,2,3,0,7,0,0]);
init_param('PortConfA',[0,0,0,0,0,0,0,0,1,0,4,0,0]);
init_param('PortConfB',[0,0,0,0,0,0,0,0,1,0,4,0,0]);
init_param('PortConfC',[0,0,0,0,0,0,0,0,1,0,4,0,0]);
init_param('PortConfD',[0,0,0,0,0,0,0,0,1,0,4,0,0]);
init_param('PortConfE',[0,0,0,0,0,0,0,0,1,0,4,0,0]);
init_param('PortConfF',[0,0,0,0,0,0,0,0,1,0,4,0,0]);
init_param('PortConfG',[0,0,0,0,0,0,0,0,1,0,4,0,0]);

// HB
init_param('HBConfA',[0]);
init_param('HBConfB',[0]);
init_param('HBConfC',[0]);
init_param('HBConfD',[0]);
init_param('HBConfE',[0]);
// END HB
// IMO
init_param('AlarmConfA',[0]);
init_param('AlarmConfB',[0]);
init_param('AlarmConfC',[0]);
init_param('AlarmConfD',[0]);
init_param('AlarmConfE',[0]);
// END IMO
init_param('EthConfR', [3,0,"192.168.36.102",8110]);
init_param('EthConfA', [0,0,"192.168.36.102",8111]);
init_param('EthConfB', [0,0,"192.168.36.102",8112]);
init_param('EthConfC', [0,0,"192.168.36.102",8113]);
init_param('EthConfD', [0,0,"192.168.36.102",8114]);
init_param('EthConfE', [0,0,"192.168.36.102",8115]);
init_param('EthConfIA',[0,0,"192.168.36.102",8117]);
init_param('EthConfIB',[0,0,"192.168.36.102",8118]);
init_param('EthConfIC',[0,0,"192.168.36.102",8119]);
init_param('EthConfID',[0,0,"192.168.36.102",8120]);
init_param('EthConfIE',[0,0,"192.168.36.102",8121]);
init_param('EthConfIF',[0,0,"192.168.36.102",8122]);
init_param('EthConfIG',[0,0,"192.168.36.102",8123]);

init_param('PULSEOAConf',[0,0.000000]);
init_param('PULSEOBConf',[0,0.000000]);

init_param('PULSEIAConf',[0,0.000000,0]);
init_param('PULSEIBConf',[0,0.000000,0]);
init_param('PULSEICConf',[0,0.000000,0]);
init_param('PULSEIDConf',[0,0.000000,0]);

init_param('UTCINTConf',[0,0]);

//[NTP, freq NTP, "serveur1", port server1, "serveur2", port serveur2, "serveur3", port serveur3]
//init_param('NTP',[1,1,"0.pool.ntp.org","92.243.3.48","2.pool.ntp.org"]);
init_param('NTP',[1,0,"0.0.0.0","0.0.0.0","0.0.0.0"]);

//[DHCP, "IP", "masque", "passerelle", "DNS", "IP GPS interne"]
init_param('EthIP',[0,"192.168.36.113","255.255.255.0","192.168.36.1","192.168.36.1","192.168.36.99"]);
init_param('Alias',"PH-2313");

init_param('PPP',[0,0,"192.168.100.201","192.168.100.202"]);
init_param('SaveSettings',"www/Conf/SaveSettingsFile.txt");
init_param('RestoreSettings',"RestoreSettingsEnable");
init_param('Broadcast',1);
init_param('Vlan',[0,1,"10.1.1.1","255.255.255.0",2,"10.2.2.2","255.255.255.0"]);

init_param('SerialNumber',"PH-2313");
init_param('LoaderDSPVers',"LoaderDSP4_3_10");
init_param('FirmDSPVers',"FrmWDSP4_INS_6_43_5_6");
init_param('LoaderCINTVers',"LoaderCINT_5_22");
init_param('FirmCINTVers',"FrmWCINT_INS_6_55_3_1_8");
init_param('FirmIMUVers',"IMU_v1_0_1");
init_param('KernelVers',"QNX v2.23 ");
init_param('GPSConfVers',"1.0.8");

init_param('UDPConfA','NMEA GPS');
init_param('UDPConfB','NMEA GGA');
init_param('UDPConfC','None');
init_param('UDPConfD','NMEA GPS');
init_param('UDPConfE','NMEA GPS');
init_param('UDPConfF','NMEA GPS');
init_param('UDPConfG','NMEA GPS');

/*init_param('OProFilterA',[0,0]);
init_param('OProFilterB',[0,1]);
init_param('OProFilterC',[1,0]);
init_param('OProFilterD',[1,1]);
init_param('OProFilterE',[1,1]);*/


// ['utc', 'gps', 'gps2', 'depth', 'dvl', 'ctd', 'logem', 'logem2', 'lbl', 'usbl', 'usbl2', 'usbl3', 'odometer', 'angles', 'dov', 'utc2', 'dvl2']
init_param('ExtSToSerial',[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]);

// ['gps', 'gps2', 'gpsm', 'depth', 'dvlbt', 'dvlwt', 'logem', 'logem2', 'lbl', 'usbl','usbl2','usbl3','odometer','angles','dov','dvl2bt', 'dvl2wt', 'vtg1', vtg2']
init_param('KFMExtSensor',[1,1,2,1,1,1,1,1,1,1,1,1,0,1,1,1,1]);

// init_param('IProList',["NONE","RDI PD0         ","RDI PD3         ","RDI PD4            ","RDI PD6           ","NMEA          ","DCN STD NAV 1      ","DCN LOCH  "]);
//init_param('IProList',["NONE            ","NMEA_STD", "GPS             ","EM LOG VBW      ","SKIPPER DL 850  ","SENIN           ","RDI PD6         ","RDI PD4         ","MICRO SVT-P     ","SVP70           ","PAROSCIENTIFIC  ","SOCAUTOSUB      ","EXT SENSOR BIN  ","SEAKING 700     ","EM LOG VHW      ","VBW             ","MINISVS         ","SBE 37SI        ","RDI PD0         ","SVX2            ","DCN STD LOCH    ","BAE             "]);
init_param('IProList',["NONE            ","RDI PD6         ","RDI PD4         ","GPS             ","MICRO SVT-P     ","SVP70           ","EM LOG VBW      ","PAROSCIENTIFIC  ","APOS PSIM SSB   ","HALLIBURTON     ","USBL LBL CTD    ","SOCAUTOSUB      ","EXT SENSOR BIN  ","POSIDONIA       ","IXSEA USBL INS 1","SEAKING 700     ","EM LOG VHW      ","VBW             ","AUVG3000        ","SENIN           ","MINISVS         ","SBE 37SI        ","GAPS            ","RDI PD0         ","SVX2            ","EIVA            ","DCN STD LOCH    ","IXSEA AUV       ","APOS PSIM LBP   ","RAMSES POSTPRO  ","USBL BOX POSTPRO","RDI PD3         ","RDI PD3 RT      ","PRESSURE SENSOR ","SBF SIGIL       ","NMEA STANDARD  ","IXBLUE STD BIN  ","SBE49           ","NORTEK DF21 22        ","TERPS8000         "]);
init_param('IProNum_GPS',[3,9,11,12,18,19,22,27,34,35,36]);							// [3,1,9,11,12,13,5]
init_param('IProNum_Depth',[1,4,5,7,10,11,12,15,18,19,20,21,23,24,27,29,33,36,37,38,39]);	// [1,4,5,7,10,11,12]
init_param('IProNum_DVL',[1,2,6,11,12,17,18,23,27,31,32,36,38]);				// Supported protocole for : DVL.
init_param('IProNum_CTD',[4,5,10,15,20,21,24,27,29,36,37,39]);						// [1,4,5,10]
init_param('IProNum_LogEM',[6,16,17,19,26,35,36]);						// [6,5]
init_param('IProNum_LBL',[9,10,27,29,36]);
init_param('IProNum_USBL',[8,9,10,13,14,18,22,25,27,28,29,30,36]);
init_param('IProNum_UTC',[3,9,19,22,27,34,35,36]);									// [3,1,9,11,12,13,5]
init_param('IProNum_Odometer',[36]);
init_param('IProNum_Angles',[36]);
init_param('IProNum_DOV',[]);
init_param('OProNum_RealTimeHeave',[1,2,3,11,15,17,19,20,22,27,28,33,34,35,37,38,44,45,49,66,67,68,70,71,72,81,85,88,90,91,96,102,103,118,119,124]);
init_param('OProNum_DelayedHeave',[]);

init_param('IPulseList',["None            ","PPS Rising+Time ","PPS Falling+Time","Time+PPS Rising ","Time+PPS Falling","SerOut A Synchro","SerOut B Synchro","SerOut C Synchro","SerOut D Synchro","SerOut E Synchro","Ev Marker Rising","Ev Marker Falling","Ev Marker Rising PostPro","Ev Marker Falling PostPro","Travel Lock Nav High","Travel Lock Nav Low"]);

// CAPTEURS EXTERNES : Bras de levier
init_param('GPSLVA',["0.000","0.000","0.000"]);
init_param('GPS2LVA',["0.000","0.000","0.000"]);
init_param('GPSMLVA',["0.000","0.000","0.000"]);
init_param('DepthLVA',["0.000","0.000","0.000"]);
init_param('USBL0LVA',["0.000","0.000","0.000"]);
init_param('USBL1LVA',["0.000","0.000","0.000"]);
init_param('USBL2LVA',["0.000","0.000","0.000"]);
init_param('LBLLVA',["0.000","0.000","0.000"]);
init_param('ODOLVA',["0.000","0.000","0.000"]);
init_param('DVLLVA',["0.000","0.000","0.000"]);
init_param('DVLCAL',["0.000","0.000","-0.000","0.0000"]);
init_param('DVL2LVA',["0.000","0.000","0.000"]);
init_param('DVL2CAL',["0.000","0.000","-0.000","0.0000"]);
init_param('ODOCAL',["0.000","0.000","0.000","0.0000"]);
init_param('LEMLVA',["0.000","0.000","0.000"]);
init_param('LEMCAL',["0.000","0.000","0.000","0.0000"]);
init_param('LEM2LVA',["0.000","0.000","0.000"]);
init_param('LEM2CAL',["0.000","0.000","0.000","0.0000"]);
init_param('DDRECK',[0,0.000,0.000,0.000,0.000,0.000,180.000,0.000,0.000,0.0,0]);
init_param('CALCHK',[0,0.000,0.000,0.000,0.000,0.000]);
init_param('USBL0Conf',"");
init_param('USBL1Conf',"");
init_param('USBL2Conf',"");

// CAPTEURS EXTERNES :  Mode du filtre de rejection
init_param('USBL1Forced',0);
init_param('USBL2Forced',0);
init_param('USBL3Forced',0);
init_param('GPS1Forced',0);
init_param('GPS2Forced',0);
init_param('VTG1Forced',0);
init_param('VTG2Forced',0);
init_param('LEM1Forced',0);
init_param('LEM2Forced',0);
init_param('LBLForced',0);
init_param('DVLWTForced',0);
init_param('DVLBTForced',0);
init_param('DVL2WTForced',0);
init_param('DVL2BTForced',0);
init_param('DepthForced',0);
init_param('OdometerForced',1);
init_param('DepthOffset', [0.000,0.000]);
init_param('WaterParams', [0,1000.0]);
init_param('DVLCplMode',1);
init_param('DVL2CplMode',1);
init_param('DVLTypes',[0,0]);
init_param('DVLTriggerPulse',0);
init_param('DVL2TriggerPulse',0);

init_param('GPS1VTG',0);
init_param('GPS2VTG',1);

//Evt Markers
init_param('EventMarkerA',[1,0]);
init_param('EventMarkerB',[2,1]);
init_param('EventMarkerC',[0,0]);

init_param('SensorDataA',"\$SENSOR_A: First Test Frame: 01,02,03*\\n\$SENSOR_A: Second Test Frame,04,05,06*\\n");
init_param('SensorDataB',"\$SENSOR_B: First Test Frame: 01,02,03*\\n\$SENSOR_B: Second Test Frame,04,05,06*\\n");
init_param('SensorDataC',"\$SENSOR_C: First Test Frame: 01,02,03*\\n\$SENSOR_C: Second Test Frame,04,05,06*\\n");
init_param('SensorDataD',"\$SENSOR_D: First Test Frame: 01,02,03*\\n\$SENSOR_D: Second Test Frame,04,05,06*\\n");
init_param('SensorDataE',"\$SENSOR_E: First Test Frame: 01,02,03*\\n\$SENSOR_E: Second Test Frame,04,05,06*\\n");
init_param('SensorDataCAN',"\$VEHICLE_POSITION - 00FEF300 - 00BF419A00A25C7E\\n\$TRANSMISSION_OUTPUT_SHAFT_SPEED - 00F00200 - 00018E0000000000\\n\$TRANSMISSION_OUTPUT_SHAFT_SPEED - 00F00200 - 00018E0000\\n");

init_param('SensorRequestA',"");
init_param('SensorRequestB',"");
init_param('SensorRequestC',"");
init_param('SensorRequestD',"");
init_param('SensorRequestE',"");


init_param('EventsLog',"$0,,,2147483714,8388608,,,1572864,,060101,000148$0,,,2147483714,8388608,,,1572864,,060101,000148");
init_param('ErrorsLog',"$0,4294967295,4294967295,,,,,,,500$1,4294967295,4294967295,,,,,,,1000$2,4294967295,4294967295,,,,,,,1500");


init_param('listdir',"Folder_A*Folder_B*Folder_C");
init_param('listfile',"File_A*File_B*File_C");
init_param('listfilesize',"10k*20k*30k");
init_param('basedir',"/log/");
init_param('removedir','1');
init_param('removefile','1');
init_param('createdir','1');

//init_param('InternalLogInfos',[1,0,50,"/","Root_File_Name_",1,"",1,"",0,"",0,"",0,""]');
init_param('InternalLogInfos',[0,0,-1,0,0,"//","",0,0,0,"REPEATER",0,"NONE",0,"NONE",0,"NONE",0,"NONE",0,"NONE",0,"",0,"",0,"REPEATER",0,"NONE",0,"NONE",0,"NONE",0,"NONE",0,"NONE",0,"NONE",0,"NONE"]);

init_param('CoordinateMode',0);
init_param('CoordinateModesList',[0,1,2]); // Gestion des modes latlong, utm, polar latlong, ups, osgb, mgrs, georef, ecef

init_param('TravelledDist',10.2);

init_param('Statistics',[3039]);
	
init_param('SystemTime',["31/01/2017","16:07:50"]);	

init_param('ProtoListBlockConfA',["Attitude and Heading",1,"Attitude and Heading Std. Dev.",1,"Real Time Heave to surge and sway",1,"Smart Heave",1]);
init_param('ProtoListBlockConfB',[]);
init_param('ProtoListBlockConfC',["Attitude and Heading",0,"Attitude and Heading Std. Dev.",0,"Real Time Heave to surge and sway",0,"Smart Heave",0,"Heading Roll and Pitch",0,"Rot. Rate in Vessel Frame Compensated from Earth Rot.",0,"Accel. in Vessel Frame Compensated from gravity",0,"Position",0,"Position Std. Dev.",0,"Speed in Geographic Frame",0,"Current in Geographic Frame",0,"Current Std. Dev. in Geographic Frame",0,"System Date",0,"INS/AHRS Sensor Status",0,"INS Algorithm Status",0,"INS System Status",0,"INS User Status",0,"AHRS Algorithm Status",0,"AHRS System Status",0,"AHRS User Status",0,"Heave Surge and Sway Speed",0,"Speed in Vessel Frame",0,"Accel. in Geographic Frame not Compensated from Gravity",0,"Course and Speed Over Ground",0,"Temperatures (ACC/FOG/ANA)",0,"Attitude Quaternion Data",0,"Attitude Quaternion Std. Dev.",0,"Raw Accel. in Vessel Frame not Compensated from Gravity",0,"Accel. Std Dev. in Vessel Frame",0,"Rot. Rate std. Dev. in Vessel Frame",0,"Rotation accelerations in vessel frame",0,"Rotation acceleration Std. Dev.",0,"Raw rot. Rate in Vessel Frame not Comp. from Earth Rot.",0,"Vehicle Attitude and Heading",0,"Vehicle Attitude and Heading Std Dev",0,"Vehicle Position",0,"Vehicle Position Std Dev",0,"UTC",0,"GPS1",0,"GPS2",0,"Manual GPS",0,"EMLOG1",0,"EMLOG2",0,"USBL1",0,"USBL2",0,"USBL3",0,"Depth",0,"DVL Ground Speed",0,"DVL Water Speed",0,"Sound Velocity",0,"DMI",0,"LBL1",0,"LBL2",0,"LBL3",0,"LBL4",0,"Event Marker A",0,"Event Marker B",0,"Event Marker C",0,"DVL2 Ground Speed",0,"DVL2 Water Speed",0]);
init_param('ProtoListBlockConfD',["Attitude and Heading",0,"Attitude and Heading Std. Dev.",0,"Real Time Heave to surge and sway",0,"Smart Heave",0,"Heading Roll and Pitch",0,"Rot. Rate in Vessel Frame Compensated from Earth Rot.",0,"Accel. in Vessel Frame Compensated from gravity",0,"Position",0,"Position Std. Dev.",0,"Speed in Geographic Frame",0,"Current in Geographic Frame",0,"Current Std. Dev. in Geographic Frame",0,"System Date",0,"INS/AHRS Sensor Status",0,"INS Algorithm Status",0,"INS System Status",0,"INS User Status",0,"AHRS Algorithm Status",0,"AHRS System Status",0,"AHRS User Status",0,"Heave Surge and Sway Speed",0,"Speed in Vessel Frame",0,"Accel. in Geographic Frame not Compensated from Gravity",0,"Course and Speed Over Ground",0,"Temperatures (ACC/FOG/ANA)",0,"Attitude Quaternion Data",0,"Attitude Quaternion Std. Dev.",0,"Raw Accel. in Vessel Frame not Compensated from Gravity",0,"Accel. Std Dev. in Vessel Frame",0,"Rot. Rate std. Dev. in Vessel Frame",0,"Rotation accelerations in vessel frame",0,"Rotation acceleration Std. Dev.",0,"Raw rot. Rate in Vessel Frame not Comp. from Earth Rot.",0,"Vehicle Attitude and Heading",0,"Vehicle Attitude and Heading Std Dev",0,"Vehicle Position",0,"Vehicle Position Std Dev",0,"UTC",0,"GPS1",0,"GPS2",0,"Manual GPS",0,"EMLOG1",0,"EMLOG2",0,"USBL1",0,"USBL2",0,"USBL3",0,"Depth",0,"DVL Ground Speed",0,"DVL Water Speed",0,"Sound Velocity",0,"DMI",0,"LBL1",0,"LBL2",0,"LBL3",0,"LBL4",0,"Event Marker A",0,"Event Marker B",0,"Event Marker C",0,"DVL2 Ground Speed",0,"DVL2 Water Speed",0]);
init_param('ProtoListBlockConfE',["Attitude and Heading",0,"Attitude and Heading Std. Dev.",0,"Real Time Heave to surge and sway",0,"Smart Heave",0,"Heading Roll and Pitch",0,"Rot. Rate in Vessel Frame Compensated from Earth Rot.",0,"Accel. in Vessel Frame Compensated from gravity",0,"Position",0,"Position Std. Dev.",0,"Speed in Geographic Frame",0,"Current in Geographic Frame",0,"Current Std. Dev. in Geographic Frame",0,"System Date",0,"INS/AHRS Sensor Status",0,"INS Algorithm Status",0,"INS System Status",0,"INS User Status",0,"AHRS Algorithm Status",0,"AHRS System Status",0,"AHRS User Status",0,"Heave Surge and Sway Speed",0,"Speed in Vessel Frame",0,"Accel. in Geographic Frame not Compensated from Gravity",0,"Course and Speed Over Ground",0,"Temperatures (ACC/FOG/ANA)",0,"Attitude Quaternion Data",0,"Attitude Quaternion Std. Dev.",0,"Raw Accel. in Vessel Frame not Compensated from Gravity",0,"Accel. Std Dev. in Vessel Frame",0,"Rot. Rate std. Dev. in Vessel Frame",0,"Rotation accelerations in vessel frame",0,"Rotation acceleration Std. Dev.",0,"Raw rot. Rate in Vessel Frame not Comp. from Earth Rot.",0,"Vehicle Attitude and Heading",0,"Vehicle Attitude and Heading Std Dev",0,"Vehicle Position",0,"Vehicle Position Std Dev",0,"UTC",0,"GPS1",0,"GPS2",0,"Manual GPS",0,"EMLOG1",0,"EMLOG2",0,"USBL1",0,"USBL2",0,"USBL3",0,"Depth",0,"DVL Ground Speed",0,"DVL Water Speed",0,"Sound Velocity",0,"DMI",0,"LBL1",0,"LBL2",0,"LBL3",0,"LBL4",0,"Event Marker A",0,"Event Marker B",0,"Event Marker C",0,"DVL2 Ground Speed",0,"DVL2 Water Speed",0]);

init_param('PackName',"INS_Pack_12_2_1");

init_param('CAN_SpecList',["CAN_2A","CAN_2B"]);
init_param('CAN_NormList',["NONE","J1939"]);
init_param('CAN_SpeedList',["250K","500K","1M"]);
init_param('CAN_Conf',[1,1,1]);
set_param('CAN_ExtS',[[959,960,961,1601,1602,963,962,964],[],[584,585],[],[191,524],[]]); // FORCED because modification does not work in simulation mode
init_param('CAN_DataBlocksList',["NONE",0,"VEHICLE_POSITION-LATITUDE",584,"VEHICLE_POSITION-LONGITUDE",585,"VEHICULE_DISTANCE-TRIP_DISTANCE",244,"VEHICULE_DISTANCE-TOTAL_DISTANCE",245,"VEHICULE_DISTANCE_HIGH_RES-TRIP_DISTANCE",917,"VEHICULE_DISTANCE_HIGH_RES-TOTAL_DISTANCE",918,"TRANSMISSION_OUTPUT_SHAFT_SPEED-SHAFT_SPEED",191,"TRANSMISSION_SELECTED_GEAR-SELECTED_GEAR",524,"TIME_AND_DATE-SECONDS",959,"TIME_AND_DATE-MINUTES",960,"TIME_AND_DATE-HOURS",961,"TIME_AND_DATE-MONTH",963,"TIME_AND_DATE-DAY",962,"TIME_AND_DATE-YEAR",964,"TIME_AND_DATE-MINUTES_OFFSET",1601,"TIME_AND_DATE-HOURS_OFFSET",1602,"USER_PGN-USER_SPN",500]);

// LBO page usine
//if ($is_started == "false")
{
	init_param('init_stopped',1);
	init_param('target','loader');
	init_param('SAVE','');
	init_param('RAZ_','');

	init_param('QGF_', ["+0.21103801","-0.21149601","-0.21116700"]);
	init_param('QGF0', ["1.01406598","1.01338994","1.00946903"]);
	init_param('QGF1', ["-8.56689834","-8.20121765","-5.40122985"]);
	init_param('QGF2', ["1.24424195","0.74457693","0.00000000"]);
	init_param('QGF3', ["0.00000000","0.00000000","9.00000009"]);

	init_param('QGB_', ["0.15728498","-0.76391296","-0.62939891"]);
	init_param('QGB0', ["0.99999713","1.00000000","1.00000095"]);
	init_param('QGB1', ["-978.84619140","-737.97766113","-839.21447753"]);
	init_param('QGB2', ["205.08221435","131.77006530","161.92926025"]);
	init_param('QGB3', ["0.00000000","0.00000000","0.00000000"]);

	init_param('QGS_', ["25.08605384","-47.05984497","-22.10428237"]);
	init_param('QGS0', ["1.00000000","1.00000000","1.00000000"]);
	init_param('QGS1', ["-799.67285156","-738.92114257","-782.83129882"]);
	init_param('QGS2', ["138.70346069","127.44442749","134.87484741"]);
	init_param('QGS3', ["0.00000000","0.00000000","0.00000000"]);

	init_param('QAF_', ["4.35028791","-4.50884199","4.50277900"]);
	init_param('QAF0', ["1.01445901","1.01253604","1.02044200"]);
	init_param('QAF1', ["3.49785113","4.91413211","0.27600903"]);
	init_param('QAF2', ["-2.73965001","-3.01317000","-2.32392501"]);
	init_param('QAF3', ["0.00000000","0.00000000","0.00000000"]);

	init_param('QAB_', ["-22.94396209","22.26042556","-18.77866935"]);
	init_param('QAB0', ["1.00000000","1.00000000","1.00000000"]);
	init_param('QAB1', ["-292.80834960","-251.41419982","-272.93289184"]);
	init_param('QAB2', ["52.15232086","51.57377243","59.67020034"]);
	init_param('QAB3', ["0.00000000","0.00000000","0.00000000"]);

	init_param('QGM_', ["1.00001096"]);	//pour le DSP correspond à QGM_,0,0
	init_param('QGM0', ["0.00000000"]);	//pour le DSP correspond à QGM_,0,1
	init_param('QGM1', ["0.00000000"]);	//...
	init_param('QGM2', ["-0.00182500"]);
	init_param('QGM3', ["1.00000202"]);
	init_param('QGM4', ["0.00000000"]);
	init_param('QGM5', ["-0.00085600"]);
	init_param('QGM6', ["0.00000098"]);
	init_param('QGM7', ["0.99997701"]);	//pour le DSP correspond à QGM_,2,2

	init_param('QGMB', ["0.00000001","0.00000002","0.00000003"]);

	init_param('QAM_', ["0.99998226"]);
	init_param('QAM0', ["0.00059900"]);
	init_param('QAM1', ["0.00276100"]);
	init_param('QAM2', ["-0.00197700"]);
	init_param('QAM3', ["0.99999103"]);
	init_param('QAM4', ["0.00091499"]);
	init_param('QAM5', ["0.00017500"]);
	init_param('QAM6', ["-0.00118097"]);
	init_param('QAM7', ["0.99997596"]);

	init_param('QAMB', ["0.03369899","-0.03290000","-0.04639200"]);

	init_param('CRT_', ["-0.15899996","0.09600000","-0.03299999","0","7.15899996","8.09600000","9.03299999","1"]); //mesalignement pion CRT + validité + mesalignement miroir + validité
	init_param('CSOR', ["400","0.000708","0"]);						// Freq IT, shift TOP cumul, rien
	init_param('HARD', ["1","1","1"]); 								// MECA, FOG, ACC
	init_param('ALGO', ["1","2","0"]);								// type algo, type saturation, rien
	init_param('TFOG', ["30.00000","150.00000","0.00000000"]);		//time-constant, gradians time-constant
	init_param('TACC', ["30.00000","150.00000","0.00000000"]);		//time-constant, gradians time-constant
	init_param('TANA', ["30.00000","150.00000","0.00000000"]);		//time-constant, gradians time-constant
	init_param('FREQ', ["100","200","0.00000000"]);					// freq algo, freq write sect 1, rien
	init_param('TFCT', ["0.200000","0.2500000","3.00000000"]);		// modeling (s), navigation, cooling models (s)
	init_param('TMOD', ["3.0000000","30.0000000","0.002500000"]);	// compensation shupe, derived from temp, filter of the temp

	init_param('QA2_', ["0.00000001","0.00000002","0.00000003"]);
	init_param('QA20', ["0.00000001","0.00000002","0.00000003"]);
	init_param('QA21', ["0.00000001","0.00000002","0.00000003"]);
	init_param('QA22', ["0.00000001","0.00000002","0.00000003"]);
	init_param('QA23', ["0.00000001","0.00000002","0.00000003"]);

	init_param('QA3_', ["0.00000001","0.00000002","0.00000003"]);
	init_param('QA30', ["0.00000001","0.00000002","0.00000003"]);
	init_param('QA31', ["0.00000001","0.00000002","0.00000003"]);
	init_param('QA32', ["0.00000001","0.00000002","0.00000003"]);
	init_param('QA33', ["0.00000001","0.00000002","0.00000003"]);

	init_param('CAB_', ["0.00000001","0.00000002","0.00000003"]);
	init_param('CAB0', ["0.00000001","0.00000002","0.00000003"]);
	init_param('CAB1', ["0.00000001","0.00000002","0.00000003"]);
	init_param('CAB2', ["0.00000001","0.00000002","0.00000003"]);
	init_param('CAB3', ["0.00000001","0.00000002","0.00000003"]);

	init_param('CAT_', ["10.00000001","0.00000002","0.00000003"]);
	init_param('CAT0', ["0.00000001","0.00000002","0.00000003"]);
	init_param('CAT1', ["0.00000001","0.00000002","0.00000003"]);
	init_param('CAT2', ["0.00000001","0.00000002","0.00000003"]);
	init_param('CAT3', ["0.00000001","0.00000002","11.00000003"]);

	init_param('QAT_', ["12.00000001","0.00000002","0.00000003"]);
	init_param('QAT0', ["0.00000001","0.00000002","0.00000003"]);
	init_param('QAT1', ["0.00000001","0.00000002","0.00000003"]);
	init_param('QAT2', ["0.00000001","0.00000002","0.00000003"]);
	init_param('QAT3', ["0.00000001","0.00000002","13.00000003"]);

	init_param('WAKE', ["LDSP4vX","FDSP4vX","PH-384","9","0"]);

	init_param('WKO3', ["LCINTvX","FCINTvX","PH-384","09","LDSPvX","FDSPvX"]);
	init_param('NET_', ["192.168.34.184","00198C300384","0","1","255.255.0.0"]);
	init_param('MODE', [0,1]); 									// usine, inde/chine
	init_param('GPS_', 1);

	init_param('SaveSystem',"toto");
	init_param('SaveModels',"toto");
	init_param('RestoreSystem',"toto");
	init_param('RestoreModels',"toto");

}
// FIN page usine

if (get_param('DDRECK')[0] == 0)
{
    set_param('distance_cal',0);
    set_param('DDRECK',[0,0,0,0,0,0,0,0,0,0,get_param('DDRECK')[1]]);
}
else
{
    set_param('distance_cal', get_param('distance_cal') + 1);
    set_param('DDRECK', [
    	get_param('DDRECK')[0],
    	ceil(rand (0, 90)).'.'.ceil(mt_rand (100, 999)),
    	ceil(rand (0, 90)).'.'.ceil(mt_rand (100, 999)),
    	ceil(rand (0, 90)).".".ceil(mt_rand (100, 999)),
    	ceil(rand (0, 90)).".".ceil(mt_rand (100, 999)),
    	/*ceil(rand (0, 90)).'.'.ceil(mt_rand (100, 999)),*/
		"0.196",
    	/*ceil(rand (0, 90)).'.'.ceil(mt_rand (100, 999)),*/
		"0.08",
    	ceil(rand (0, 90)).".".ceil(mt_rand (100, 999)),
    	ceil(rand (0, 90)).".".ceil(mt_rand (100, 999)),
    	get_param('distance_cal'),
		get_param('DDRECK')[1]
    ]);
}

if (get_param('CALCHK')[0] == 0)
{
    set_param('distance_cal',0);
    set_param('CALCHK',[0,0,0,0,0,0]);
}
else
{
	set_param('calchk_distance', get_param('calchk_distance') + 1);
	set_param('calchk_herror',   get_param('calchk_herror') + 2);
	set_param('calchk_verror',   get_param('calchk_verror') + 3);
	set_param('calchk_herrorpc', get_param('calchk_verrorpc') + 4);
	set_param('calchk_verrorpc', get_param('calchk_verrorpc') + 5);
    set_param('CALCHK', [
    	1,
    	get_param('calchk_distance'),
    	get_param('calchk_herror'),
    	get_param('calchk_verror'),
    	get_param('calchk_herrorpc'),
    	get_param('calchk_verrorpc')
    ]);
}

function DataGroup ($args=0)
{
	global $mode,$system_type;

	switch ($mode)
	{
		case 3 :
			$group = (is_string($args)) ? intval($args) : $args;

			//sleep(1);

			$_data = [];

			$_data['is_started'] = get_param('is_started');

			if ($_data['is_started'] === true)
			{
				$_data['_ui_status'] = get_param('_ui_status');

				if ($group > 0)
				{
					if (get_param('heading') <= 0)
					{
						set_param('heading',0);
						set_param('rotation_count',get_param('rotation_count')+1);

					}
					else if (get_param('heading') >= 360)
					{
						set_param('heading',360);
						set_param('rotation_count',get_param('rotation_count')+1);
					}

					if (get_param('rotation_count') > 3)
					{
						set_param('rotation_sign',-get_param('rotation_sign'));
						set_param('rotation_count',0);
					}

					$heading  = 1.0;//floatval(get_param('heading') + (rdnum(10,20,5) * get_param('rotation_sign')));

					if ($heading > 360) {$heading = 0;}
					else if ($heading < 0) {$heading = 360;}

					// DEBUG : Forcer une valeur de cap ----------
					// $heading = 227.16279;
					// -------------------------------------------

					set_param('heading', $heading);

					$heading  = number_format($heading,5);

					$_data['latitude']             = (string) rdnum(0,90,8);
					$_data['longitude']            = (string) rdnum(00,360,8);
					$_data['polar_latitude']       = (string) rdnum(0,90,8);
					$_data['polar_longitude']      = (string) rdnum(300,360,8);
					$_data['heading']              = $heading;
					$_data['polar_heading']        = $heading;
					$_data['roll']                 = (string) rdnum(-3,3,5);
					$_data['pitch']                = (string) rdnum(-3,3,5);
					$_data['heave']                = (string) rdnum(-3,3,3);
					$_data['altitude']             = (string) rdnum(1,30,3);
					$_data['depth']                = (string) rdnum(3,30,3);
					$_data['speed_norm']           = (string) rdnum(0,3,2);
					$_data['heading_stddev']       = (string) rdnum(-200,200,3);
					$_data['polar_heading_stddev'] = (string) rdnum(-200,200,3);
					$_data['position_stddev']      = (string) rdnum(-200,200,3);
					$_data['remain_algnt_time']    = date("00:i:s");
					$_data['utm_zone']             = "32N";
					$_data['utm_north']            = (string) rdnum(-200,200,3);
					$_data['utm_east']             = (string) rdnum(-200,200,3);	

					$_data['vehicle_heading']      = (string) rdnum(-3,3,5);
					$_data['vehicle_pitch']        = (string) rdnum(-3,3,5);
					$_data['vehicle_roll']         = (string) rdnum(-3,3,5);
					$_data['vehicle_latitude']     = $_data['latitude']; 
					$_data['vehicle_longitude']    = $_data['longitude'];
					$_data['vehicle_altitude']     = $_data['altitude']; 					
					$_data['vehicle_utm_zone']     = $_data['utm_zone'];
					$_data['vehicle_utm_north']    = $_data['utm_north'];
					$_data['vehicle_utm_east']     = $_data['utm_east'];
					
					$_data['_gps_modes']           = [5,2];
					$_data['is_heave']             = 1;
					//UPS
					$_data['ups_zone']             = "N";
					$_data['ups_north']            = (string) rdnum(-200,200,3);
					$_data['ups_east']             = (string) rdnum(-200,200,3);
					//OSGB
					$_data['osgb_zone']            = "HZ";
					$_data['osgb_north']           = (string) rdnum(-200,200,3);
					$_data['osgb_east']            = (string) rdnum(-200,200,3);
					$_data['osgb_altitude']        = (string) rdnum(-200,200,3);
					//MGRS
					$_data['mgrs_zone']            = "31UDQ";
					$_data['mgrs_north']           = (string) rdnum(-200,200,3);
					$_data['mgrs_east']            = (string) rdnum(-200,200,3);
					$_data['mgrs_altitude']        = (string) rdnum(-200,200,3);
					//GEOREF
					$_data['georef_zone']          = "NKCD";
					$_data['georef_north']         = (string) rdnum(-200,200,3);
					$_data['georef_east']          = (string) rdnum(-200,200,3);
					$_data['georef_altitude']      = (string) rdnum(-200,200,3);
					//ECEF
					$_data['ecef_x']               = (string) rdnum(-200,200,3);
					$_data['ecef_y']               = (string) rdnum(-200,200,3);
					$_data['ecef_z']               = (string) rdnum(-200,200,3);
				}

				if ($group === 2)
				{
					$_data['roll_stddev']          	     = (string) rdnum(0,11,3);
					$_data['pitch_stddev']         	     = (string) rdnum(0,11,3);
					$_data['north_current']        	     = (string) rdnum(-200,200,3);
					$_data['east_current']         	     = (string) rdnum(-200,200,3);
					$_data['north_current_stddev'] 	     = (string) rdnum(0,11,3);
					$_data['east_current_stddev']  	     = (string) rdnum(0,11,3);
					$_data['latitude_stddev']      	     = (string) rdnum(0,11,3);
					$_data['longitude_stddev']     	     = (string) rdnum(0,11,3);
					$_data['polar_latitude_stddev']      = (string) rdnum(0,11,3);
					$_data['polar_longitude_stddev']     = (string) rdnum(0,11,3);
					$_data['depth_stddev']         	     = (string) rdnum(0,11,3);
					$_data['altitude_stddev']      	     = (string) rdnum(0,11,3);
					$_data['north_speed']          	     = (string) rdnum(-200,200,3);
					$_data['east_speed']           	     = (string) rdnum(-200,200,3);
					$_data['polar_north_speed']    	     = (string) rdnum(-200,200,3);
					$_data['polar_east_speed']     	     = (string) rdnum(-200,200,3);
					$_data['vert_speed']           	     = (string) rdnum(-200,200,3);
					$_data['speed_norm']           	     = (string) rdnum(-200,200,3);
					$_data['north_speed_stddev']   	     = (string) rdnum(0,11,3);
					$_data['east_speed_stddev']    	     = (string) rdnum(0,11,3);
					$_data['polar_north_speed_stddev']   = (string) rdnum(0,11,3);
					$_data['polar_east_speed_stddev']    = (string) rdnum(0,11,3);
					$_data['vert_speed_stddev']    	     = (string) rdnum(0,11,3);
					$_data['systime']              	     = date("H:i:s.m");
					$_data['systimedays']          	     = "02";
					$_data['utctime']              	     = date("H:i:s.m");
					$_data['surge']                	     = (string) rdnum(-200,200,3);
					$_data['sway']                 	     = (string) rdnum(-200,200,3);
					$_data['north_current_stddev'] 	     = (string) rdnum(0,11,3);
					$_data['east_current_stddev']  	     = (string) rdnum(0,11,3);
					$_data['travelled_dist']			 = (string) rdnum(0,11,3);

					$_data['vehicle_heading_stddev']     = $_data['heading_stddev'];
					$_data['vehicle_pitch_stddev']       = $_data['pitch_stddev'];
					$_data['vehicle_roll_stddev']        = $_data['roll_stddev'];
					$_data['vehicle_latitude_stddev']    = $_data['latitude_stddev'];
					$_data['vehicle_longitude_stddev']   = $_data['longitude_stddev'];
					$_data['vehicle_altitude_stddev']    = $_data['altitude_stddev'];
					
					$_data['ExtSToSerial']         	     = get_param('ExtSToSerial');  // ['utc', 'gps', 'gps2', 'depth', 'dvl', 'ctd', 'logem', 'logem2', 'lbl', 'usbl', 'usbl2', 'usbl3', 'odometer', 'angles', 'dov', 'utc2']

					$_data['_ext_sensors'] = [];

					if ($_data['ExtSToSerial'][15]  ||  // L'utc2 n'est jamais renvoyé par l'embarqué, tout se passe dans "utc"
						$_data['ExtSToSerial'][0])  {$_data['_ext_sensors']['utc']      = [true, date("H:i:s")];}
					if ($_data['ExtSToSerial'][1])  {$_data['_ext_sensors']['gps']      = [true, (string) rdnum(-90,90,3), (string) rdnum(-180,180,3), (string) rdnum(-200,200,3), "Float RTK", (string) rdnum(0,10,2), "N/A", "N/A", date("H:i:s"), 5, 0.120];}
					if ($_data['ExtSToSerial'][2])  {$_data['_ext_sensors']['gps2']     = [true, (string) rdnum(-90,90,3), (string) rdnum(-180,180,3), (string) rdnum(-200,200,3), "Differential", (string) rdnum(0,10,2), "N/A", "N/A", date("H:i:s"), 2, 0.2];}
					if ($_data['ExtSToSerial'][8])  {$_data['_ext_sensors']['lbl']      = [true, (string) rdnum(1,100), (string) rdnum(-90,90,3,3), (string) rdnum(-180,180,3), (string) rdnum(-200,200,3), (string) rdnum(-200,200,3), date("H:i:s")];}
					if ($_data['ExtSToSerial'][3])  {$_data['_ext_sensors']['depth']    = [true, (string) rdnum(-200,200,3), date("H:i:s")];}
					if ($_data['ExtSToSerial'][6])  {$_data['_ext_sensors']['logem']    = [true, (string) rdnum(-200,200,3), date("H:i:s")];}
					if ($_data['ExtSToSerial'][7])  {$_data['_ext_sensors']['logem2']   = [true, (string) rdnum(-200,200,3), date("H:i:s")];}
					if ($_data['ExtSToSerial'][4])  {$_data['_ext_sensors']['dvl']      = [	true,	
																							(string) rdnum(-200,200,3),		// Longitudinal Bottom Speed
																							(string) rdnum(-200,200,3),		// Transverse Bottom Speed
																							(string) rdnum(-200,200,3),		// Vertical Bottom Speed
																							(string) rdnum(-200,200,3),		// Longitudinal Water Speed
																							(string) rdnum(-200,200,3),		// Transverse Water Speed
																							(string) rdnum(-200,200,3),		// Vertical Water Speed
																							(string) rdnum(-200,200,3),		// Range to Bottom
																							(string) rdnum(-200,200,3),		// Speed of Sound
																							date("H:i:s"),				// Time
																							(string) rdnum(-200,200,3)		// Delay
																							];}			
					if ($_data['ExtSToSerial'][16])  {$_data['_ext_sensors']['dvl2']    = [true, (string) rdnum(-200,200,3), (string) rdnum(-200,200,3), (string) rdnum(-200,200,3), (string) rdnum(-200,200,3), (string) rdnum(-200,200,3) , (string) rdnum(-200,200,3), (string) rdnum(-200,200,3), (string) rdnum(-200,200,3), date("H:i:s")];}
					if ($_data['ExtSToSerial'][5])  {$_data['_ext_sensors']['ctd']      = [true, (string) rdnum(1400,1600,2)];}
					if ($_data['ExtSToSerial'][9])  {$_data['_ext_sensors']['usbl']     = [true, (string) rdnum(1,100), (string) rdnum(1,100), (string) rdnum(-90,90,3), (string) rdnum(-180,180,3), (string) rdnum(-200,200,3), (string) rdnum(-200,200,3), date("H:i:s")];}
					if ($_data['ExtSToSerial'][10]) {$_data['_ext_sensors']['usbl2']    = [true, (string) rdnum(1,100), (string) rdnum(1,100), (string) rdnum(-90,90,3), (string) rdnum(-180,180,3), (string) rdnum(-200,200,3), (string) rdnum(-200,200,3), date("H:i:s")];}
					if ($_data['ExtSToSerial'][11]) {$_data['_ext_sensors']['usbl3']    = [true, (string) rdnum(1,100), (string) rdnum(1,100), (string) rdnum(-90,90,3), (string) rdnum(-180,180,3), (string) rdnum(-200,200,3), (string) rdnum(-200,200,3), date("H:i:s")];}
					if ($_data['ExtSToSerial'][12]) {$_data['_ext_sensors']['odometer'] = [true, (string) rdnum(-200,200,3), (string) 12.5, date("H:i:s"), (string)(1)];}
					if ($_data['ExtSToSerial'][13]) {$_data['_ext_sensors']['angles']   = [true, (string) rdnum(-100,100,3), (string) rdnum(-100,100,3),(string) rdnum(-100,100,3), date("H:i:s"), 0.002];}
					if ($_data['ExtSToSerial'][14]) {$_data['_ext_sensors']['dov']      = [true, (string) rdnum(-100,100,3), (string) rdnum(-100,100,3),(string) rdnum(-100,100,3), date("H:i:s")];}

					if (count($_data['_ext_sensors']) == 0)
					{
						unset($_data['_ext_sensors']);
					}
				}
			}
			set_param('DataGroup',$_data);
			break;

		case 4 :
			break;
	}
}

function Passwords ()
{
	global $mode;

	switch ($mode)
	{
		case 3: break;
		case 4: unset($_GET['Passwords']); break;
	}
}

// MODES //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if (in_array($mode, [3,9], true))
{
	echo giwik_readconf([
		"_parent_params"  => [],
		"_file_params"    => [],
	]);
}
else if ($mode === 4)
{
	giwik_writeconf([
		"_readonly_params" => ['DataGroup']
	]);
}
else if ($mode === 5)
{
	switch ($_GET['cmd'])
	{
		case 1:
		set_param('is_started',false);
		set_param('is_started_count',0);
		break;
	}
}

// Marque la fin de la phase d'init
set_param('init_isdone',true);
?>