// MESSAGES DE STTAU INS
	MSG.statuscodes[1502] = {
		en: "Waiting for Position",
		fr: "Attente position"
	};

// MESSAGES DE STATUT DÉTAILLÉ ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	if (typeof MSG.detailedstatus != 'object'){MSG.detailedstatus = {};}

	MSG.detailedstatus.pulses_in = {
		en: "Pulses In",
		fr: "Pulses d'entrée"
	};
	MSG.detailedstatus.io_others = {
		en: "Others",
		fr: "Autres"
	};	
	MSG.detailedstatus.navigation = {
		en: "Navigation",
		fr: "Navigation"
	};
	MSG.detailedstatus.navigationMode = {
		en: "Navigation mode",
		fr: "Mode de navigation"
	};	
	MSG.detailedstatus.calibration = {
		en: "Calibration",
		fr: "Calibration"
	};
	MSG.detailedstatus.position = {
		en: "Position",
		fr: "Position"
	};
	MSG.detailedstatus.speed = {
		en: "Speed",
		fr: "Vitesse"
	};
	MSG.detailedstatus.time = {
		en: "Time",
		fr: "Temps"
	};
	MSG.detailedstatus.zupt = {
		en: "Zupt",
		fr: "Zupt"
	};
	MSG.detailedstatus.ntp = {
		en: "NTP",
		fr: "NTP"
	};
	MSG.detailedstatus.manualdata= {
		en: "Manual Data",
		fr: "Données Manuelles"
	};
	MSG.detailedstatus.altitude = {
		en: "Altitude",
		fr: "Altitude"
	};
	MSG.detailedstatus.system = {
		en: "System",
		fr: "Système"
	};
		
	MSG.detailedstatus.sensors = {
		en: "Sensors",
		fr: "Senseurs"
	};
	MSG.detailedstatus.alignmentphase = {
		en: "Alignment phase",
		fr: "Phase d'alignement"
	};
	
	if (typeof MSG.detailedstatuscodes != 'object'){MSG.detailedstatuscodes = {};}

		//module input

    if (GIWIK.system_type === 6 || GIWIK.system_type === 7)
    {
  		MSG.detailedstatuscodes[100] = {
			en: function () {return (GIWIK.gnss) ? "Internal GNSS" : "Internal GPS";},
			fr: function () {return (GIWIK.gnss) ? "GNSS interne" : "GPS interne";}
		};
  		MSG.detailedstatuscodes[101] = {
			en: function () {return (GIWIK.gnss) ? "Internal GNSS PP" : "Internal GPS PP";},
			fr: function () {return (GIWIK.gnss) ? "PP GNSS interne" : "PP GPS interne";}
		};
    }
    else
    {
		MSG.detailedstatuscodes[100] = {
			en: "Input A",
			fr: "Entrée A"
		};
		MSG.detailedstatuscodes[101] = {
			en: "Input B",
			fr: "Entrée B"};
     }

	MSG.detailedstatuscodes[102] = {
		en: "Input C",
		fr: "Entrée C"
	};

	if(in_array(GIWIK.system_type, [6,7,11,12,16]))
    {
  		MSG.detailedstatuscodes[103] = {
  			en: "Input A",
  			fr: "Entrée A"
		};
  		MSG.detailedstatuscodes[104] = {
  			en: "Input B",
  			fr: "Entrée B"};

		MSG.detailedstatuscodes[106] = {
			en: "Input C",
			fr: "Entrée C"
		};
		MSG.detailedstatuscodes[107] = {
			en: "Input D",
			fr: "Entrée D"
		};
    }
    else
    {
		MSG.detailedstatuscodes[103] = {
			en: "Input D",
			fr: "Entrée D"
		};
		MSG.detailedstatuscodes[104] = {
			en: "Input E",
			fr: "Entrée E"};

		MSG.detailedstatuscodes[106] = {
			en: "Input F",
			fr: "Entrée F"
		};
		MSG.detailedstatuscodes[107] = {
			en: "Input G",
			fr: "Entrée G"
		};
	}


	MSG.detailedstatuscodes[105] = {
		en: "Input R",
		fr: "Entrée R"
	};

	MSG.detailedstatuscodes[108] = {
		en: "Input CAN",
		fr: "Entrée CAN"
	};
	
    if (GIWIK.system_type === 6 || GIWIK.system_type === 7)
    {
		MSG.detailedstatuscodes[110] = {
			en: function () {return (GIWIK.gnss) ? "GNSS Input error" : "GPS Input error";},
			fr: function () {return (GIWIK.gnss) ? "Erreur entrée GNSS" : "Erreur entrée GPS";}
		};
		MSG.detailedstatuscodes[111] = {
			en: function () {return (GIWIK.gnss) ? "GNSS PP Input error" : "GPS PP Input error";},
			fr: function () {return (GIWIK.gnss) ? "Erreur entrée GNSS PP" : "Erreur entrée GPS PP";}
		};
    }
    else
    {
		MSG.detailedstatuscodes[110] = {
			en: "Input A error",
			fr: "Erreur entrée A"
		};
		MSG.detailedstatuscodes[111] = {
			en: "Input B error",
			fr: "Erreur entrée B"
		};
    }

	MSG.detailedstatuscodes[112] = {
		en: "Input C error",
		fr: "Erreur entrée C"
	};


    if(in_array(GIWIK.system_type, [6,7,11,12,16]))
    {
		MSG.detailedstatuscodes[113] = {
			en: "Input A error",
			fr: "Erreur entrée A"
		};
		MSG.detailedstatuscodes[114] = {
			en: "Input B error",
			fr: "Erreur entrée B"
		};
		MSG.detailedstatuscodes[116] = {
			en: "Input C error",
			fr: "Erreur entrée C"
		};
		MSG.detailedstatuscodes[117] = {
			en: "Input D error",
			fr: "Erreur entrée D"
		};
    }
    else
    {
		MSG.detailedstatuscodes[113] = {
			en: "Input D error",
			fr: "Erreur entrée D"
		};
		MSG.detailedstatuscodes[114] = {
			en: "Input E error",
			fr: "Erreur entrée E"};

		MSG.detailedstatuscodes[116] = {
			en: "Input F error",
			fr: "Erreur entrée F"
		};
		MSG.detailedstatuscodes[117] = {
			en: "Input G error",
			fr: "Erreur entrée G"
		};
	}


		MSG.detailedstatuscodes[115] = {
			en: "Input R error",
			fr: "Erreur entrée R"
		};

		MSG.detailedstatuscodes[118] = {
			en: "Input CAN error",
			fr: "Erreur entrée CAN"
		};
		
		
		MSG.detailedstatuscodes[120] = {
			en: "Pulse In A",
			fr: "Pulse A"
		};
		MSG.detailedstatuscodes[121] = {
			en: "Pulse In B",
			fr: "Pulse B"
		};
		MSG.detailedstatuscodes[122] = {
			en: "Pulse In C",
			fr: "Pulse C"
		};
    if (GIWIK.system_type === 6 || GIWIK.system_type === 7)
    {
		MSG.detailedstatuscodes[123] = {
			en: "PPS Pulse activity",
			fr: "Activité Pulse PPS"
		};
    }
    else
    {
		MSG.detailedstatuscodes[123] = {
			en: "Pulse In D",
			fr: "Pulse D"
		};
    }


			//module output
		MSG.detailedstatuscodes[200] = {
			en: "Output A full",
			fr: "Surcharge sortie A"
		};
		MSG.detailedstatuscodes[201] = {
			en: "Output B full",
			fr: "Surcharge sortie B"
		};
		MSG.detailedstatuscodes[202] = {
			en: "Output C full",
			fr: "Surcharge sortie C"
		};
    if (GIWIK.system_type === 6 || GIWIK.system_type === 7)
    {
		MSG.detailedstatuscodes[203] = {
			en: function () {return (GIWIK.gnss) ? "GNSS PP Output full" : "GPS PP Output full";},
			fr: function () {return (GIWIK.gnss) ? "Surcharge sortie GNSS PP" : "Surcharge sortie GPS PP";}
		};
		MSG.detailedstatuscodes[204] = {
			en: "PP Output full",
			fr: "Surcharge sortie PP"
		};
    }
    else
    {
		MSG.detailedstatuscodes[203] = {
			en: "Output D full",
			fr: "Surcharge sortie D"
		};
		MSG.detailedstatuscodes[204] = {
			en: "Output E full",
			fr: "Surcharge sortie E"
		};
    }

		MSG.detailedstatuscodes[205] = {
			en: "Output R full",
			fr: "Surcharge sortie R"
		};
		MSG.detailedstatuscodes[206] = {
			en: "Ethernet Output full",
			fr: "Surcharge sortie Ethernet"
		};
		//system
		MSG.detailedstatuscodes[300] = {
			en: "Latency Warning",
			fr: "Avertissement latence"
		};
		MSG.detailedstatuscodes[301] = {
			en: "Power failure",
			fr: "Pb alim. elec."
		};
		MSG.detailedstatuscodes[302] = {
			en: "Configuration saved",
			fr: "Conf. sauvegardée"
		};
		MSG.detailedstatuscodes[303] = {
			en: "DSP overload",
			fr: "Surcharge DSP"
		};
		MSG.detailedstatuscodes[304] = {
			en: "Incompatible DSP firmware",
			fr: "Firmware DSP incompatible"
		};
		MSG.detailedstatuscodes[305] = {
			en: "Heading accuracy",
			fr: "Précision du cap"
		};
		MSG.detailedstatuscodes[306] = {
			en: "Position accuracy",
			fr: "Précision de position"
		};
		MSG.detailedstatuscodes[307] = {
			en: "Simulation mode",
			fr: "Mode simulation"
		};
		MSG.detailedstatuscodes[308] = {
			en: "Emulation mode",
			fr: "Mode emulation"
		};
		MSG.detailedstatuscodes[309] = {
			en: function () {return (GIWIK.is_mems===true) ? "Warning Mode" : "Degraded Mode";},
			fr: function () {return (GIWIK.is_mems===true) ? "Mode Warning" : "Mode dégradé";},
		};
		MSG.detailedstatuscodes[310] = {
			en: "Failure mode",
			fr: "Mode panne"
		};
		MSG.detailedstatuscodes[311] = {
			en: "Waiting for position",
			fr: "Attente position"
		};
		MSG.detailedstatuscodes[312] = {
			en: "Usine Mode",
			fr: "Mode Usine"
		};
		MSG.detailedstatuscodes[313] = {
			en: "Polar Mode",
			fr: "Mode polaire"
		};
		MSG.detailedstatuscodes[314] = {
			en: "Internal Logging",
			fr: "Enregistrement interne"
		};
		MSG.detailedstatuscodes[315] = {
			en: "Gravity corr. reception",
			fr: "Réception corr. gravité"
		};
		MSG.detailedstatuscodes[316] = {
			en: "Analog Outputs Failure",
			fr: "Erreur sorties analogiques"
		};
		MSG.detailedstatuscodes[317] = {
			en: "Incompatible IMU",
			fr: "IMU Incompatible"
		};
			
		MSG.detailedstatuscodes[320] = {
			en: "Coarse alignment",
			fr: "Alignement grossier"
		};
		MSG.detailedstatuscodes[321] = {
			en: "Heave Init",
			fr: "Init. heave"
		};
		MSG.detailedstatuscodes[322] = {
			en: "HRP not valid",
			fr: "CRT invalide"
		};
		MSG.detailedstatuscodes[323] = {
			en: function () {return (GIWIK.is_mems===true) ? "Full performance mode" : "Navigation mode";},
			fr: function () {return (GIWIK.is_mems===true) ? "Mode pleine performance" : "Mode navigation";},
		};
		MSG.detailedstatuscodes[324] = {
			en: "Fine alignment",
			fr: "Alignement fin"
		};
		MSG.detailedstatuscodes[325] = {
			en: "Altitude exceeded",
			fr: "Saturation altitude"
		};
		MSG.detailedstatuscodes[326] = {
			en: "Speed exceeded",
			fr: "Saturation vitesse"
		};
		MSG.detailedstatuscodes[327] = {
			en: function () {return (GIWIK.is_mems===true) ? "Restore attitude" : "Fast alignment";},
			fr: function () {return (GIWIK.is_mems===true) ? "Restauration d'attitude" : "Alignement rapide";},
		};

		MSG.detailedstatuscodes[340] = {
			en: "Manual coupling",
			fr: "Couplage manuel"
		};
		MSG.detailedstatuscodes[341] = {
			en: "Position coupling",
			fr: "Couplage position"
		};
		MSG.detailedstatuscodes[342] = {
			en: "Speed coupling",
			fr: "Couplage vitesse"
		};

		MSG.detailedstatuscodes[343] = {
			en: "Polar Heading not valid",
			fr: "Cap polaire invalide"
		};

		MSG.detailedstatuscodes[350] = {
			en: function () {return (GIWIK.is_mems===true) ? "GYRO X Error" : "FOG X Error";},
			fr: function () {return (GIWIK.is_mems===true) ? "Erreur GYRO X" : "Erreur FOG X";}
		};
		MSG.detailedstatuscodes[351] = {			
			en: function () {return (GIWIK.is_mems===true) ? "GYRO Y Error" : "FOG Y Error";},
			fr: function () {return (GIWIK.is_mems===true) ? "Erreur GYRO Y" : "Erreur FOG Y";}

		};
		MSG.detailedstatuscodes[352] = {			
			en: function () {return (GIWIK.is_mems===true) ? "GYRO Z Error" : "FOG Z Error";},
			fr: function () {return (GIWIK.is_mems===true) ? "Erreur GYRO Z" : "Erreur FOG Z";}

		};
		MSG.detailedstatuscodes[353] = {
			en: "Source Error",
			fr: "Err. source"
		};
		MSG.detailedstatuscodes[354] = {
			en: "ACC X Error",
			fr: "Erreur ACC X"
		};
		MSG.detailedstatuscodes[355] = {
			en: "ACC Y Error",
			fr: "Erreur ACC Y"
		};
		MSG.detailedstatuscodes[356] = {
			en: "ACC Z Error",
			fr: "Erreur ACC Z"
		};
		MSG.detailedstatuscodes[357] = {
			en: "Temperature Alarm",
			fr: "Alarme température"
		};

		MSG.detailedstatuscodes[358] = {
			en: "Incompatible firmwares",
			fr: "Firmwares incompatibles"
		};

		MSG.detailedstatuscodes[359] = {
			en: "Modelisation issue",
			fr: "Erreur modélisation"
		};
		
		MSG.detailedstatuscodes[360] = {
			en: "Configuration issue",
			fr: "Erreur configuration"
		};

		MSG.detailedstatuscodes[361] = {
			en: "Sensor board detection issue",
			fr: "Erreur détection carte senseur"
		};

		MSG.detailedstatuscodes[641] = {
			en: "Degraded mode",
			fr: "mode degradé"
		};
		
		MSG.detailedstatuscodes[642] = {
			en: "System saturation",
			fr: "Saturation système"
		};
		
    if ((GIWIK.system_type === 7) || (GIWIK.system_type === 11))
    {
		// Mode ZUPT remplacé par vitesse manuelle sur QUADRANS
		MSG.detailedstatuscodes[391] = {
			en: "Manual speed",
			fr: "Vitesse manuelle"
		};
	}
	else
	{
		// Modes ZUPT
		MSG.detailedstatuscodes[390] = {
			en: "ZUPT Mode enabled",
			fr: "Mode ZUPT activé"
		};
		MSG.detailedstatuscodes[391] = {
			en: "ZUPT Mode valid",
			fr: "Mode ZUPT valide"
		};
	}

		MSG.detailedstatuscodes[392] = {
			en: "Bench ZUPT Mode enabled",
			fr: "Mode ZUPT bench activé"
		};
		MSG.detailedstatuscodes[393] = {
			en: "Bench ZUPT Mode valid",
			fr: "Mode ZUPT bench valide"
		};
		MSG.detailedstatuscodes[590] = {
			en: "ZUPT ANC enabled",
			fr: "ZUPT ANC activé"
		};
		MSG.detailedstatuscodes[591] = {
			en: "ZUPT ANC valid",
			fr: "ZUPT ANC valide"
		};

		// ext. sensors GYRO
		MSG.detailedstatuscodes[600] = {
			en: "Manual latitude",
			fr: "Latitude manuelle"
		};
		MSG.detailedstatuscodes[601] = {
			en: "Manual speed",
			fr: "Vitesse manuelle"
		};
		MSG.detailedstatuscodes[602] = {
			en: "Internal time",
			fr: "Temps interne"
		};
		MSG.detailedstatuscodes[603] = {
			en: "Ext. time received",
			fr: "Temps externe reçu"
		};
		MSG.detailedstatuscodes[604] = {
			en: "Ext. time sync.",
			fr: "Temps ext. sync."
		};
		MSG.detailedstatuscodes[605] = {
			en: "Latitude received",
			fr: "Latitude reçue"
		};
		MSG.detailedstatuscodes[606] = {
			en: "Speed received",
			fr: "Vitesse reçue"
		};
		MSG.detailedstatuscodes[607] = {
			en: "Latitude Computation",
			fr: "Détermination Latitude"
		};
		MSG.detailedstatuscodes[608] = {
			en: "Manual longitude",
			fr: "Longitude manuelle"
		};
		MSG.detailedstatuscodes[609] = {
			en: "Longitude received",
			fr: "Longitude reçue"
		};

		//ext. sensors
		MSG.detailedstatuscodes[400] = {
			en: function () {return (GIWIK._ext_sensors.dvl) ? (GIWIK._ext_sensors.dvl2 ? "DVL1 Calibration" : "DVL Calibration") : "DMI Calibration";},
			fr: function () {return (GIWIK._ext_sensors.dvl) ? (GIWIK._ext_sensors.dvl2 ? "Calibration DVL1" : "Calibration DVL") : "Calibration odomètre";}
		};
		MSG.detailedstatuscodes[401] = {
			en: function () {return (GIWIK.gnss) ? "GNSS altitude" : "GPS altitude";},
			fr: function () {return (GIWIK.gnss) ? "Altitude GNSS" : "Altitude GPS";}
		};
		MSG.detailedstatuscodes[402] = {
			en: "Depth altitude",
			fr: "Altitude depth"
		};
		MSG.detailedstatuscodes[403] = {
			en: "Stabilization",
			fr: "Altitude stabilisée"
		};
		MSG.detailedstatuscodes[404] = {
			en: "Altitude hydro",
			fr: "Altitude hydro"
		};
		MSG.detailedstatuscodes[410] = {
			en: function () {return (GIWIK._ext_sensors.utc2) ? "UTC1 synchro" : "UTC synchro";},
			fr: function () {return (GIWIK._ext_sensors.utc2) ? "Synchro UTC1" : "Synchro UTC";}
		};
		MSG.detailedstatuscodes[411] = {
			en: function () {return (GIWIK._ext_sensors.utc2) ? "PPS1 synchro" : "PPS synchro";},
			fr: function () {return (GIWIK._ext_sensors.utc2) ? "Synchro PPS1" : "Synchro PPS";}
		};

		// GPS detected: Different from GPS2
		MSG.detailedstatuscodes[420] = {
            en: function () {return (GIWIK._ext_sensors.gps2) ? (GIWIK.gnss ? "GNSS1 reception" : "GPS1 reception") : (GIWIK.gnss ? "GNSS reception" : "GPS reception");},
            fr: function () {return (GIWIK._ext_sensors.gps2) ? (GIWIK.gnss ? "Réception GNSS1" : "Réception GPS1") : (GIWIK.gnss ? "Réception GNSS" : "Réception GPS");}
        };

		//MSG.detailedstatuscodes[421] = {
		//	en: function () {return (GIWIK._ext_sensors.gps2) ? "GPS1 received" : "GPS received";},
		//	fr: function () {return (GIWIK._ext_sensors.gps2) ? "GPS1 reçu" : "GPS reçu";}
		//};

		MSG.detailedstatuscodes[422] = {
			en: function () {return (GIWIK._ext_sensors.gps2) ? (GIWIK.gnss ? "GNSS1 valid" : "GPS1 valid") : (GIWIK.gnss ? "GNSS valid" : "GPS valid");},
            fr: function () {return (GIWIK._ext_sensors.gps2) ? (GIWIK.gnss ? "GNSS1 valide" : "GPS1 valide") : (GIWIK.gnss ? "GNSS valide" : "GPS valide");}
		};

		MSG.detailedstatuscodes[423] = {
			en: function () {return (GIWIK._ext_sensors.gps2) ? (GIWIK.gnss ? "GNSS1 waiting" : "GPS1 waiting") : (GIWIK.gnss ? "GNSS waiting" : "GPS waiting");},
            fr: function () {return (GIWIK._ext_sensors.gps2) ? (GIWIK.gnss ? "GNSS1 en attente" : "GPS1 en attente") : (GIWIK.gnss ? "GNSS en attente" : "GPS en attente");}
		};
		MSG.detailedstatuscodes[424] = {
			en: function () {return (GIWIK._ext_sensors.gps2) ? (GIWIK.gnss ? "GNSS1 rejected" : "GPS1 rejected") : (GIWIK.gnss ? "GNSS rejected" : "GPS rejected");},
            fr: function () {return (GIWIK._ext_sensors.gps2) ? (GIWIK.gnss ? "GNSS1 rejeté" : "GPS1 rejeté") : (GIWIK.gnss ? "GNSS rejeté" : "GPS rejeté");}
		};

		// Altitude
		MSG.detailedstatuscodes[430] = {
			en: "Altitude reception",
			fr: "Réception altitude"
		};
//		MSG.detailedstatuscodes[431] = new Array();
//		MSG.detailedstatuscodes[431].en = "Altitude received";
//		MSG.detailedstatuscodes[431].fr = "Altitude reçue";

		MSG.detailedstatuscodes[432] = {
			en: "Altitude valid",
			fr: "Altitude valide"
		};
		MSG.detailedstatuscodes[433] = {
			en: "Altitude waiting",
			fr: "Altitude en attente"
		};
		MSG.detailedstatuscodes[434] = {
			en: "Altitude rejected",
			fr: "Altitude rejetée"
		};

		// DVL BT - ODO
		MSG.detailedstatuscodes[440] = {
			en: function () {return (GIWIK._ext_sensors.dvl) ? (GIWIK._ext_sensors.dvl2 ? "DVL1 BT reception" : "DVL BT reception" ) : "DMI reception";},
			fr: function () {return (GIWIK._ext_sensors.dvl) ? (GIWIK._ext_sensors.dvl2 ? "Reception DVL1 BT" : "Reception DVL BT" ) : "Réception odomètre";}
		};

		MSG.detailedstatuscodes[442] = {
			en: function () {return (GIWIK._ext_sensors.dvl) ? (GIWIK._ext_sensors.dvl2 ? "DVL1 BT valid" : "DVL BT valid" ) : "DMI valid";},
			fr: function () {return (GIWIK._ext_sensors.dvl) ? (GIWIK._ext_sensors.dvl2 ? "DVL1 BT valide" : "DVL BT valide" ) : "Odomètre valide";}
		};

		MSG.detailedstatuscodes[443] = {
			en: function () {return (GIWIK._ext_sensors.dvl) ? (GIWIK._ext_sensors.dvl2 ? "DVL1 BT waiting" : "DVL BT waiting" ) : "DMI waiting";},
			fr: function () {return (GIWIK._ext_sensors.dvl) ? (GIWIK._ext_sensors.dvl2 ? "DVL1 BT en attente" : "DVL BT en attente" ) : "Odomètre en attente";}
		};

		MSG.detailedstatuscodes[444] = {
			en: function () {return (GIWIK._ext_sensors.dvl) ? (GIWIK._ext_sensors.dvl2 ? "DVL1 BT rejected" : "DVL BT rejected") : "DMI rejected";},
			fr: function () {return (GIWIK._ext_sensors.dvl) ? (GIWIK._ext_sensors.dvl2 ? "DVL1 BT rejeté" : "DVL BT rejeté") : "Odomètre rejeté";}
		};


		// DVL2 BT: => Use Sys Status
		/*MSG.detailedstatuscodes[580] = {
			en: "DVL2 BT reception",
			fr: "Reception DVL2 BT"
		};*/

		MSG.detailedstatuscodes[581] = {
			en: "DVL2 BT valid",
			fr: "DVL2 BT valide"
		};

		MSG.detailedstatuscodes[582] = {
			en: "DVL2 BT waiting",
			fr: "DVL2 BT en attente"
		};

		MSG.detailedstatuscodes[583] = {
			en: "DVL2 BT rejected",
			fr: "DVL2 BT rejeté"
		};

		// DVL2 WT: => Use Sys Status
		/*MSG.detailedstatuscodes[584] = {
			en: "DVL2 WT reception",
			fr: "Reception DVL2 WT"
		};*/

		MSG.detailedstatuscodes[585] = {
			en: "DVL2 WT valid",
			fr: "DVL2 WT valide"
		};

		MSG.detailedstatuscodes[586] = {
			en: "DVL2 WT waiting",
			fr: "DVL2 WT en attente"
		};

		MSG.detailedstatuscodes[587] = {
			en: "DVL2 WT rejected",
			fr: "DVL2 WT rejeté"
		};


		// DVL2 BT: Sys Status
		MSG.detailedstatuscodes[588] = {
			en: "DVL2 BT reception",
			fr: "Reception DVL2 BT"
		};

		// DVL2 WT: Sys Status
		MSG.detailedstatuscodes[589] = {
			en: "DVL2 WT reception",
			fr: "Reception DVL2 WT"
		};

		//NAVIGATION MODE : None
		MSG.detailedstatuscodes[592] = {
			en: "None Mode",
			fr: "Mode none"
		};
		
		//NAVIGATION MODE : Traveling
		MSG.detailedstatuscodes[593] = {
			en: "Traveling Mode",
			fr: "Traveling Mode"	//en anglais aussi pour être cohérent du contenu de la liste déroulante "mode de navigation"
		};
		
		//NAVIGATION MODE : Firing
		MSG.detailedstatuscodes[594] = {
			en: "Firing Mode",
			fr: "Firing Mode"		//en anglais aussi pour être cohérent du contenu de la liste déroulante "mode de navigation"
		};

		//NAVIGATION MODE : Firing on move
		MSG.detailedstatuscodes[595] = {
			en: "Firing on Move Mode",
			fr: "Firing on Move Mode"//en anglais aussi pour être cohérent du contenu de la liste déroulante "mode de navigation"
		};

		//NAVIGATION MODE : Aero transportation
		MSG.detailedstatuscodes[596] = {
			en: "Aero Transportation Mode",
			fr: "Aero Transportation Mode"//en anglais aussi pour être cohérent du contenu de la liste déroulante "mode de navigation"
		};

		//NAVIGATION MODE : Custom
		MSG.detailedstatuscodes[597] = {
			en: "Travel Lock Mode",
			fr: "Travel Lock Mode"//en anglais aussi pour être cohérent du contenu de la liste déroulante "mode de navigation"
		};		
		
		// USBL Detectio: Same for USBL 1,2 and 3
		MSG.detailedstatuscodes[450] = {
			en: "USBL reception",
			fr: "Reception USBL"
		};
		//MSG.detailedstatuscodes[451] = {
		//	en: function () {return (GIWIK._ext_sensors.usbl2) ? "USBL1 received" : "USBL received";},
		//	fr: function () {return (GIWIK._ext_sensors.usbl2) ? "USBL1 reçu" : "USBL reçu";}
		//};

		MSG.detailedstatuscodes[452] = {
			en: function () {return (GIWIK._ext_sensors.usbl2) ? "USBL1 valid" : "USBL valid";},
			fr: function () {return (GIWIK._ext_sensors.usbl2) ? "USBL1 valide" : "USBL valide";}
		};
		MSG.detailedstatuscodes[453] = {
			en: function () {return (GIWIK._ext_sensors.usbl2) ? "USBL1 waiting" : "USBL waiting";},
			fr: function () {return (GIWIK._ext_sensors.usbl2) ? "USBL1 en attente" : "USBL en attente";}
		};
		MSG.detailedstatuscodes[454] = {
			en: function () {return (GIWIK._ext_sensors.usbl2) ? "USBL1 rejected" : "USBL rejected";},
			fr: function () {return (GIWIK._ext_sensors.usbl2) ? "USBL1 rejeté" : "USBL rejeté";}
		};

		// Profondimètre
		MSG.detailedstatuscodes[460] = {
			en: "Depth reception",
			fr: "Réception profondimètre"
		};
//		MSG.detailedstatuscodes[461] = new Array();
//		MSG.detailedstatuscodes[461].en = "Depth received";
//		MSG.detailedstatuscodes[461].fr = "Profondimètre reçu";

		MSG.detailedstatuscodes[462] = {
			en: "Depth valid",
			fr: "Profondimètre valide"
		};
		MSG.detailedstatuscodes[463] = {
			en: "Depth waiting",
			fr: "Profondimètre en attente"
		};
		MSG.detailedstatuscodes[464] = {
			en: "Depth rejected",
			fr: "Profondimètre rejeté"
		};

		// LBL
		MSG.detailedstatuscodes[470] = {
			en: "LBL reception",
			fr: "Reception LBL"
		};
//		MSG.detailedstatuscodes[471] = new Array();
//		MSG.detailedstatuscodes[471].en = "LBL received";
//		MSG.detailedstatuscodes[471].fr = "LBL reçu";

		MSG.detailedstatuscodes[472] = {
			en: "LBL valid",
			fr: "LBL valide"
		};
		MSG.detailedstatuscodes[473] = {
			en: "LBL waiting",
			fr: "LBL en attente"
		};
		MSG.detailedstatuscodes[474] = {
			en: "LBL rejected",
			fr: "LBL rejeté"
		};
		// DVL WT
		MSG.detailedstatuscodes[480] = {
			en: function () {return (GIWIK._ext_sensors.dvl2) ? "DVL1 WT reception" : "DVL WT reception"; },
			fr: function () {return (GIWIK._ext_sensors.dvl2) ? "Réception DVL1 WT" : "Réception DVL WT"; },
		};
//		MSG.detailedstatuscodes[481] = new Array();
//		MSG.detailedstatuscodes[481].en = "DVL WT received";
//		MSG.detailedstatuscodes[481].fr = "DVL WT reçu";

		MSG.detailedstatuscodes[482] = {
			en: function () {return (GIWIK._ext_sensors.dvl2) ? "DVL1 WT valid" : "DVL WT valid";},
			fr: function () {return (GIWIK._ext_sensors.dvl2) ? "DVL1 WT valide" : "DVL WT valide" ;}
		};
		MSG.detailedstatuscodes[483] = {
			en: function () {return (GIWIK._ext_sensors.dvl2) ? "DVL1 WT waiting" : "DVL WT waiting" ;},
			fr: function () {return (GIWIK._ext_sensors.dvl2) ? "DVL1 WT en attente" : "DVL WT en attente" ;}
		};
		MSG.detailedstatuscodes[484] = {
			en: function () {return (GIWIK._ext_sensors.dvl2) ? "DVL1 WT rejected" : "DVL WT rejected" ;},
			fr: function () {return (GIWIK._ext_sensors.dvl2) ? "DVL1 WT rejeté" : "DVL WT rejeté" ;}
		};

		// EM LOG1 Detected
		MSG.detailedstatuscodes[490] = {
			en: function () {return (GIWIK._ext_sensors.logem2) ? "EMLog1 reception" : "EMLog reception";},
			fr: function () {return (GIWIK._ext_sensors.logem2) ? "Réception LochEM1" : "Réception LochEM";}
		};

		MSG.detailedstatuscodes[530] = {
			en: "DMI reception",
			fr: "Réception Odomètre"
		};


		MSG.detailedstatuscodes[492] = {
			en: function () {return (GIWIK._ext_sensors.logem2) ? "EMLog1 valid" : "EMLog valid";},
			fr: function () {return (GIWIK._ext_sensors.logem2) ? "LochEM1 valide" : "LochEM valide";}
		};
		MSG.detailedstatuscodes[493] = {
			en: function () {return (GIWIK._ext_sensors.logem2) ? "EMLog1 waiting" : "EMLog waiting";},
			fr: function () {return (GIWIK._ext_sensors.logem2) ? "LochEM1 en attente" : "LochEM en attente";}
		};
		MSG.detailedstatuscodes[494] = {
			en: function () {return (GIWIK._ext_sensors.logem2) ? "EMLog1 rejected" : "EMLog rejected";},
			fr: function () {return (GIWIK._ext_sensors.logem2) ? "LochEM1 rejeté" : "LochEM rejeté";}
		};

		// GPS MANUEL
		MSG.detailedstatuscodes[500] = {
			en: "Manual position reception",
			fr: "Réception position manuelle"
		};
//		MSG.detailedstatuscodes[501] = new Array();
//		MSG.detailedstatuscodes[501].en = "Manual position received";
//		MSG.detailedstatuscodes[501].fr = "Position manuelle reçue";

		MSG.detailedstatuscodes[502] = {
			en: "Manual position valid",
			fr: "Position manuelle valide"
		};
		MSG.detailedstatuscodes[503] = {
			en: "Manual position waiting",
			fr: "Position manuelle en attente"
		};
		MSG.detailedstatuscodes[504] = {
			en: "Manual position rejected",
			fr: "Position manuelle rejetée"
		};
		MSG.detailedstatuscodes[510] = {
			en: function () {return (GIWIK._ext_sensors.ctd) ? "Sound velocity reception" : ( (GIWIK._ext_sensors.angles) ? ( MSG.ext_sensors.angles.en() + " reception") : "");},
			fr: function () {return (GIWIK._ext_sensors.ctd) ? "Réception vitesse du son" : ( (GIWIK._ext_sensors.angles) ? ("Réception " + MSG.ext_sensors.angles.fr()) : "");}
		}
		MSG.detailedstatuscodes[511] = {
			en: function () {return (GIWIK._ext_sensors.angles) ? (MSG.ext_sensors.angles.en() + " loss") : "";},
			fr: function () {return (GIWIK._ext_sensors.angles) ? ("Perte " + MSG.ext_sensors.angles.fr()) : "";}
		}
		
	       // GPS2
		MSG.detailedstatuscodes[520] = {
			en: function () {return (GIWIK.gnss) ? "GNSS2 reception" : "GPS2 reception";},
			fr: function () {return (GIWIK.gnss) ? "Reception GNSS2" : "Reception GPS2";}
		};
//		MSG.detailedstatuscodes[521] = new Array();
//		MSG.detailedstatuscodes[521].en = "GPS2 received";
//		MSG.detailedstatuscodes[521].fr = "GPS2 reçu";

		MSG.detailedstatuscodes[522] = {
			en: function () {return (GIWIK.gnss) ? "GNSS2 valid" : "GPS2 valid";},
			fr: function () {return (GIWIK.gnss) ? "GNSS2 valide" : "GPS2 valide";}
		};
		MSG.detailedstatuscodes[523] = {
			en: function () {return (GIWIK.gnss) ? "GNSS2 waiting" : "GPS2 waiting";},
			fr: function () {return (GIWIK.gnss) ? "GNSS2 en attente" : "GPS2 en attente";}
		};
		MSG.detailedstatuscodes[524] = {
			en: function () {return (GIWIK.gnss) ? "GNSS2 rejected" : "GPS2 rejected";},
			fr: function () {return (GIWIK.gnss) ? "GNSS2 rejeté" : "GPS2 rejeté";}
		};

		// VTG
		MSG.detailedstatuscodes[525] = {
			en: function () {return (GIWIK._ext_sensors.vtg2) ? "VTG1 reception" : "VTG reception";},
			fr: function () {return (GIWIK._ext_sensors.vtg2) ? "Reception VTG1" : "Reception VTG";}
		};
		MSG.detailedstatuscodes[526] = {
			en: "VTG2 reception",
			fr: "Reception VTG2"
		};
	
		MSG.detailedstatuscodes[621] = {
			en: function () {return (GIWIK._ext_sensors.vtg2) ? "VTG1 valid" : "VTG valid";},
            fr: function () {return (GIWIK._ext_sensors.vtg2) ? "VTG1 valide" : "VTG valide";}
		};
		MSG.detailedstatuscodes[622] = {
			en: function () {return (GIWIK._ext_sensors.vtg2) ? "VTG1 waiting" : "VTG waiting";},
            fr: function () {return (GIWIK._ext_sensors.vtg2) ? "VTG1 en attente" : "VTG en attente";}
		};
		MSG.detailedstatuscodes[623] = {
			en: function () {return (GIWIK._ext_sensors.vtg2) ? "VTG1 rejected" : "VTG rejected";},
            fr: function () {return (GIWIK._ext_sensors.vtg2) ? "VTG1 rejeté" : "VTG rejeté";}
		};
		MSG.detailedstatuscodes[625] = {
			en: function () {return "VTG2 valid"},
            fr: function () {return "VTG2 valide"}
		};
		MSG.detailedstatuscodes[626] = {
			en: function () {return "VTG2 waiting"},
            fr: function () {return "VTG2 en attente"}
		};
		MSG.detailedstatuscodes[627] = {
			en: function () {return "VTG2 rejected"},
            fr: function () {return "VTG2 rejeté"}	
		};
		// Manual Attitude
		MSG.detailedstatuscodes[527] = {
			en: "Manual attitude reception",
			fr: "Réception attitude manuelle"
		};

		MSG.detailedstatuscodes[631] = {
			en: "Manual attitude valid",
			fr: "Attitude manuelle valide"
		};
		MSG.detailedstatuscodes[632] = {
			en: "Manual attitude waiting",
			fr: "Attitude manuelle en attente"
		};
		MSG.detailedstatuscodes[633] = {
			en: "Manual attitude rejected",
			fr: "Attitude manuelle rejetée"
		};
		
		// Use Sys Status
		/*MSG.detailedstatuscodes[531] = {
			en: "EMLog2 reception",
			fr: "Réception LochEM2"}; */

		MSG.detailedstatuscodes[532] = {
			en: "EMLog2 valid",
			fr: "LochEM2 valide"
		};
		MSG.detailedstatuscodes[533] = {
			en: "EMLog2 waiting",
			fr: "LochEM2 en attente"
		};
		MSG.detailedstatuscodes[534] = {
			en: "EMLog2 rejected",
			fr: "LochEM2 rejeté"
		};
		// EM LOG2
		MSG.detailedstatuscodes[535] = {
			en: "EMLog2 reception",
			fr: "Réception LochEM2"
		};
		// USBL 2
		MSG.detailedstatuscodes[540] = {
			en: "USBL2 reception",
			fr: "Reception USBL2"
		};
		/*MSG.detailedstatuscodes[541] = {
			en: "USBL2 reception",
			fr: "Reception USBL2"}; */

		MSG.detailedstatuscodes[542] = {
			en: "USBL2 valid",
			fr: "USBL2 valide"
		};
		MSG.detailedstatuscodes[543] = {
			en: "USBL2 waiting",
			fr: "USBL2 en attente"
		};
		MSG.detailedstatuscodes[544] = {
			en: "USBL2 rejected",
			fr: "USBL2 rejeté"
		};
		// USBL 3
		MSG.detailedstatuscodes[550] = {
			en: "USBL3 reception",
			fr: "Reception USBL3"
		};
		/*MSG.detailedstatuscodes[551] = {
			en: "USBL3 reception",
			fr: "Reception USBL3"}; */

		MSG.detailedstatuscodes[552] = {
			en: "USBL3 valid",
			fr: "USBL3 valide"
		};
		MSG.detailedstatuscodes[553] = {
			en: "USBL3 waiting",
			fr: "USBL3 en attente"
		};
		MSG.detailedstatuscodes[554] = {
			en: "USBL3 rejected",
			fr: "USBL3 rejeté"
		};
        MSG.detailedstatuscodes[555] = {
			en: "Manual speed reception",
			fr: "Reception vitesse manuelle"
		};
		MSG.detailedstatuscodes[556] = {
			en: "Calibration Check",
			fr: "Vérification Calibration"
		};
		MSG.detailedstatuscodes[557] = {
			en: function () {return (GIWIK.is_mems===true) ? "Restore attitude failed" : "Fast alignment failed";},
			fr: function () {return (GIWIK.is_mems===true) ? "Echec restauration d'attitude" : "Echec alignement rapide";}
		};
		MSG.detailedstatuscodes[558] = {
			en: "Relative ZUPT Mode enabled",
			fr: "Mode ZUPT relatif activé"
		};

		MSG.detailedstatuscodes[559] = {
			en: "Relative ZUPT Mode valid",
			fr: "Mode ZUPT relatif valide"
		};

		MSG.detailedstatuscodes[560] = {
			en: "Timing Issue",
			fr: "Problème Datation"
		};

		MSG.detailedstatuscodes[561] = {
			en: "Sensor used before calibration",
			fr: "Capteur utilisé avant calibration"
		};
		MSG.detailedstatuscodes[562] = {
			en: function () {return (GIWIK.is_mems===true) ? "Restore attitude rejected" : "Fast alignment rejected";},
			fr: function () {return (GIWIK.is_mems===true) ? "Restauration d'attitude rejetée" : "Alignement rapide rejeté";}
		};

		MSG.detailedstatuscodes[570] = {
			en: "UTC2 synchro",
			fr: "Synchro UTC2"
		};

		MSG.detailedstatuscodes[571] = {
			en: "PPS2 synchro",
			fr: "Synchro PPS2"
		};

		MSG.detailedstatuscodes[572] = {
			en: "Advanced filtering mode",
			fr: "Mode filtrage avancé"
		};

		MSG.detailedstatuscodes[573] = {
			en: "NTP synchro in progress",
			fr: "Synchro NTP en cours"
		};

		MSG.detailedstatuscodes[574] = {
			en: "NTP received",
			fr: "Reception NTP"
		};

		MSG.detailedstatuscodes[575] = {
			en: "NTP synchro",
			fr: "Synchro NTP"
		};

		MSG.detailedstatuscodes[576] = {
			en: "NTP synchro failed",
			fr: "Echec synchro NTP"
		};

		MSG.detailedstatuscodes[577] = {
			en: "Geographic frame out of range",
			fr: "Convention géodésique hors zone"
		};
		
		MSG.detailedstatuscodes[578] = {
			en: "IMO alignment",
			fr: "Alignement IMO"
		};
		
		MSG.detailedstatuscodes[579] = {
			en: "Optimal alignment",
			fr: "Alignement optimal"
		};

		MSG.detailedstatuscodes[580] = {
			en: "Strategic alignment",
			fr: "Alignement stratégique"
		};
		
		MSG.detailedstatuscodes[581] = {
			en: "System full performance",
			fr: "Système pleine performance"
		};
		
		MSG.detailedstatuscodes[582] = {
			en: "Strategic performance",
			fr: "Performance stratégique"
		};
		
		MSG.detailedstatuscodes[643] = {
			en: "System ready",
			fr: "Système ok"
		};		
		MSG.detailedstatuscodes[647] = {
			en: "Config error",
			fr: "Erreur de config"
		};	
		MSG.detailedstatuscodes[592] = {
			en: "Inconsistent data",
			fr: "Donnée incohérente"
		};
		

// LABELS DES BOUTONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


		// [page calibration]
		MSG.buttons.calibration_start = {
			en: "Start<br/>Calibration",
			fr: "Démarrer<br/>la calibration"
		};
		MSG.buttons.calibration_stop = {
			en: "Stop<br/>Calibration",
			fr: "Arrêter<br/>la calibration"
		};
		MSG.buttons.calibration_update_conf = {
			en: "Update<br/>Parameters",
			fr: "Utiliser les<br/>paramètres"
		};
		MSG.buttons.calibration_cancel_conf = {
			en: "Clear<br/>Values",
			fr: "Effacer les<br/>valeurs"
		};
		MSG.buttons.calchk_start = {
			en: "Start<br/>Calibration<br/>Check",
			fr: "Démarrer<br/>la vérification"
		};
		MSG.buttons.calchk_stop = {
			en: "Stop<br/>Calibration<br/>Check",
			fr: "Arrêter<br/>la vérification"
		};
    // Page input
		MSG.buttons.zero_depth = {
			en: "Use Current<br/>Depth",
			fr: "Profondeur<br/>courante"
		};
		
		MSG.buttons.backup_sensors_enable = {
			en: "Enable Backup Sensors",
			fr: "Activer les capteurs de secours"
		};
		MSG.buttons.backup_sensors_disable = {
			en: "Disable Backup Sensors",
			fr: "Désactiver les capteurs de secours"
		};
		
	// Pade Adavnce Setting
		MSG.buttons.restore_default_advancedsettings = {
			en: "Default<br/>Values",
			fr: "Valeurs<br/>par défaut"
		};
		
	// Page Navigation
		MSG.buttons.reset_travelled_distance = {
			en: "Reset",
			fr: "Initialiser"
		};

// LABELS DES MESURES ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
		// Spécifique DVL
		MSG.data.bottom_speedx = {
			en: "Longitudinal Bottom Speed",
			fr: "Vitesse fond longitudinale"
		};
		MSG.data.bottom_speedy = {
			en: "Transverse Bottom Speed",
			fr: "Vitesse fond transversale"
		};
		MSG.data.bottom_speedz = {
			en: "Vertical Bottom Speed",
			fr: "Vitesse fond verticale"
		};
		MSG.data.water_speedx = {
			en: "Longitudinal Water Speed",
			fr: "Vitesse eau longitudinale"
		};
		MSG.data.water_speedy = {
			en: "Transverse Water Speed",
			fr: "Vitesse eau transversale"
		};
		MSG.data.water_speedz = {
			en: "Vertical Water Speed",
			fr: "Vitesse eau verticale"
		};
		MSG.data.sound_speed = {
			en: "Speed of Sound",
			fr: "Vitesse du son "
		};
		MSG.data.range_tobottom = {
			en: "Range to Bottom",
			fr: "Distance au fond"
		};

		MSG.data.dov_chi = {
			en: "Deflection Chi",
			fr: "Déviation Chi"
		};
		MSG.data.dov_eta = {
			en: "Deflection Eta",
			fr: "Déviation Eta"
		};
		MSG.data.dov_norm = {
			en: "Gravity Anormality",
			fr: "Anormalité de gravité"
		};

		// Spécifique Bathymetry (CTD)
		MSG.data.ctd_sound_speed = {
			en: "Speed of Sound",
			fr: "Vitesse son CTD"
		};

		// Spécifique USBL
		MSG.data.tpcode = {
			en: "TP Code",
			fr: "Code TP"
		};
		MSG.data.delay = {
			en: "Delay",
			fr: "Retard"
		};
		
		MSG.data.dvl_delay = {
			en: "Delay",
			fr: "Retard"
		};

		// Temps d'alignement restant
		MSG.data.remain_algnt_time = {
			en: "Remaining Alignment Time: -",
			fr: "Temps alignement restant : -",
			ru: "Оставшееся время выравнивания : -"
		};

		// Polar data
		MSG.data.polar_north_speed = {
			en: "Polar North Speed",
			fr: "Vitesse Nord Polaire"
		};
		MSG.data.polar_east_speed = {
			en: "Polar East Speed",
			fr: "Vitesse Est Polaire"
		};

		MSG.data.raw_speed = {
			en: "Measure",
			fr: "Mesure"
		};
		
		// Angles Turret
		MSG.data.angles_heading = {
			en: function(){ return GIWIK._plugins.mechanical.turret===true ? "Bearing" : "Drift";},
			fr: function(){ return GIWIK._plugins.mechanical.turret===true ? "Gisement" : "Drift";}
		};	
		MSG.data.angles_roll = {
			en: function(){ return GIWIK._plugins.mechanical.turret===true ? "Roll" : "Roll";},
			fr: function(){ return GIWIK._plugins.mechanical.turret===true ? "Roulis" : "Roulis";}
		};		
		MSG.data.angles_pitch = {
			en: function(){ return GIWIK._plugins.mechanical.turret===true ? "Elevation" : "Pitch";},
			fr: function(){ return GIWIK._plugins.mechanical.turret===true ? "Site" : "Tangage";}
		};	

		MSG.data.vtg_speed = {
			en: "Speed",
			fr: "Vitesse"
		};
		
		MSG.data.vtg_course = {
			en: "Course",
			fr: "Course"
		};

		
// LABELS DES RUBRIQUES /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
		MSG.headings.installation_initialposition = {
			en: "Initial Position",
			fr: "Position initiale"
		};
		MSG.headings.setup_navigation = {
			en: "Navigation Parameters",
			fr: "Parametres de navigation"
		};
		MSG.headings.setup_positionfix = {
			en: "Position Fix",
			fr: "Correction de position"
		};
		MSG.headings.setup_manualfix = {
			en: "Manual Fixes",
			fr: "Corrections manuelles"
		};
		MSG.headings.setup_calibration = {
			en: "DVL Calibration",
			fr: "Calibration DVL",
			ru: "Калибровка DVL"
		};
		MSG.headings.setup_calibration_odo = {
			en: "DMI Calibration",
			fr: "Calibration odomètre"
		};
		MSG.headings.setup_dynamicpositioning = {
			en: "Advanced Position Filtering",
			fr: "Filtrage avancé de position"
		};
		MSG.headings.setup_time = {
			en: "SYSTEM TIME",
			fr: "HEURE SYSTÈME"
		};
// BOITES ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


	MSG.box.positionfix_title = MSG.headings.setup_positionfix;

	MSG.box.manualfix_title = MSG.headings.setup_manualfix;

	MSG.box.navigation_title = {
		en: "Navigation Parameters",
		fr: "Paramètres de navigation"
	};

	// [page installation/initialization]
		// Titre de la boite
		MSG.box.init_title = {
			en: "Init and Update",
			fr: "Init et recalage"
		};
		MSG.box.params_initialposition = {
			en: "Manual Position",
			fr: "Position manuelle"
		};
		MSG.box.params_advancedmode = {
			en: "Advanced Mode",
			fr: "Mode avancé"
		};
		MSG.box.params_zupt = {
			en: "ZUPT Mode",
			fr: "Mode ZUPT"
		};
		MSG.box.params_alti = {
			en: "Altitude Mode",
			fr: "Mode d'altitude"
		};
		MSG.box.params_heave = {
			en: "Heave Parameters",
			fr: "Paramètres pilonnement"
		};

		MSG.box.params_current = {
			en: "Parameters of the Current",
            fr: "Paramètres du courant"
		};
		MSG.box.params_start = {
			en: "Starting Mode",
	 		fr: "Mode de démarrage"
		};
		MSG.box.params_navigation = {
			en: "Navigation Mode",
	 		fr: "Mode de navigation"
		};
		MSG.box.params_dynamic = {
			en: "Application",
	 		fr: "Application"
		};
		MSG.box.params_travelled_dist = {
			en: "Travelled Distance",
	 		fr: "Distance parcourure"
		};
		MSG.box.params_manualspeed = {
			en: "Manual Speed",
            fr: "Vitesse manuelle"
		};
		MSG.box.params_manualattitude = {
			en: "Manual Attitude",
            fr: "Attitude manuelle"
		};
		MSG.box.params_depth = {
			en: "Depth",
			fr: "Immersion",
			ru: "Глубина"
		};
		MSG.box.params_watertype_selection = {
			en: "Water Type Selection",
			fr: "Sélection du type d'eau",
			ru: "Выбор типа воды"
		};
		MSG.box.params_utmzone = {
			en: "UTM Zone Mode",
            fr: "Mode Zone UTM"
        };
		MSG.box.params_coupling_mode = {
			en: "DVL Coupling Mode",
			fr: "Mode de couplage DVL",
			ru: "Режим DVL подключения"
		};
		MSG.box.params_dvl_type = {
			en: "DVL Type",
			fr: "Type de DVL"
		};
		MSG.box.params_geoid = {
			en: "Geoidal Separation",
			fr: "Séparation géoïdale"
		};	
		// [page setup/warnings]
		// Titre de la boite
		MSG.box.warnings_title = {
			en: "WARNING CONFIGURATION",
			fr: "CONFIGURATION DES ALERTES",
			ru: "Настройки предупреждений"
		};
		MSG.box.params_synchroloss_utc = {
			en: "UTC Synchronization Loss Management",
			fr: "Gestion de la perte de synchronisation UTC"
		};
		MSG.box.params_synchroloss_position = {
			en: "Position Sensor Loss Management",
			fr: "Gestion de la perte d'un capteur de position"
		};
		MSG.box.params_synchroloss_speed = {
			en: "Speed Sensor Loss Management",
			fr: "Gestion de la perte d'un capteur de vitesse"
		};
		MSG.box.params_heading_stdev_header = {
			en: "Heading Standard Deviation Management",
			fr: "Gestion de l'écart-type de cap"
		};
		MSG.box.params_position_stdev_header = {
			en: "Position Standard Deviation Management",
			fr: "Gestion de l'écart-type de position"
		};

	// [page setup/dvl calibration]
		// Titre de la boite
		MSG.box.dvl_calibration_title = {
			en: "DVL CALIBRATION",
			fr: "CALIBRATION DVL"
		};
		MSG.box.params_dvl_sensor_id = {
			en: "DVL Selection",
			fr: "Sélection DVL"
		};
		MSG.box.params_dvl_misalignments = {
			en: "DVL Misalignments",
			fr: "Mésalignements DVL"
		};
		MSG.box.odo_calibration_title = {
			en: "DMI CALIBRATION",
			fr: "CALIBRATION ODOMETRE"
		};
		MSG.box.params_odo_misalignments = {
			en: "DMI Misalignments",
			fr: "Mésalignements odomètre"
		};
		MSG.box.params_dvl_calchk = {
			en: "DVL Calibration Check",
			fr: "Vérification calibration DVL"
		};
		MSG.box.params_odo_calchk = {
			en: "DMI Calibration Check",
			fr: "Vérification calibration odomètre"
		};

	// [page dynamic positionning]
		MSG.box.dynamicpositionning_title = {
			en: "Advanced Position Filtering",
			fr: "Filtrage avancé de position"};

		MSG.box.params_position_priority = {
			en: "Position Input Priority",
			fr: "Priorité de la donnée de position en entrée"};

		MSG.box.params_gps_inputfilter = {
			en: function () {return (GIWIK.gnss) ? "GNSS Input Filtering and Smoothing" : "GPS Input Filtering and Smoothing";},
			fr: function () {return (GIWIK.gnss) ? "Filtrage et lissage GNSS en entrée" : "Filtrage et lissage GPS en entrée";}
		};

		MSG.box.params_usbl_inputfilter = {
			en: "USBL Input Filtering and Smoothing",
			fr: "Filtrage et lissage USBL en entrée"};

		MSG.box.params_speedsstddev_input = {
			en: "Adjustment of DVL Input Speed Standard Deviation",
			fr: "Réglage écart type de vitesse DVL en entrée"};

		MSG.box.params_depthstddev_input = {
			en: "Adjustment of Input Depth Standard Deviation",
			fr: "Réglage écart type de profondeur en entrée"
		};

		MSG.box.params_gps_outputfilter = {
			en: "INS Output Mode Control",
			fr: "Contrôle du mode en sortie INS"
		};

		MSG.box.params_speed_saturation = {
			en: "Adjustment of Speed Saturation",
			fr: "Ajustement de la Saturation de vitesse"
		};		
		
		MSG.box.params_restore_default = {
			en: "Restore default Settings",
			fr: "Retour paramètres par défaut"
		};

		MSG.box.params_emlogsstddev_input = {
			en: "Adjustment of EM LOG Input Speed Standard Deviation",
			fr: "Réglage écart type de vitesse EM LOCH en entrée"
		};

	// [page installation/initial position]
		MSG.box.initialposition_title = MSG.headings.installation_initialposition;

	// [page setup/external sensors]
		// Titre de la boite de configuration
		MSG.box.params_utctime = {
			en: "UTC Time",
			fr: "Temps UTC",
			ru: "Время UTC"
		};
		// Titre de la boite de configuration
		MSG.box.params_log = {
			en: "Log (Pulse In D)",
			fr: "Log (Entrée pulse D)",
			ru: "Лаг (импульсный вход D)"
		};
		/*MSG.box.params_eventmarker = {
			en: "Event marker",
			fr: "Event marker"
		};*/

	// [page navigation data]
		MSG.box.dov_title = {
			en: "Vertical Deflection",
			fr: "Déviation de verticale"
		};

		// Titre des paramètres de heave
		MSG.box.params_heave = {
			en: "Heave Output",
			fr: "Sortie du pilonnement"
		};

	// maintenance
		MSG.box.gpsconfvers_label = {
			en: "GPS Configuration",
			fr: "Configuration GPS"
		};
		
	// Options
	MSG.box.params_display = {
		en: "General",
		fr: "Générales"
	};
	MSG.box.options_title = {
		en: "MMI DISPLAY OPTIONS",
		fr: "OPTIONS D'AFFICHAGE INTERFACE WEB"
	};
	
	// Expert view
	MSG.box.travelled_dist_title = {
		en: "Distance",
		fr: "Distance"
		// ru ??
	};
	MSG.box.travelled_dist = {
		en: "Travelled Distance",
		fr: "Distance parcourue"
		// ru ??
	};
	
	// GPS Position
	MSG.box.params_sensorpos = {
		en: "Position",
		fr: "Position"
	};	
	
	// Message utilisateur pour signaler que la configuration ethernet du flux est incompatible avec la configuration ethernet (ip + port) d'une autre entrée
	MSG.box.usermsg_io_ethernet_conflict_repeater_port = {
		en: "Impossible to save configuration, repeater output is configured with port "+GIWIK._plugins.network.repeater_port+".",
		fr: "Impossible de sauvegarder la configuration, l'entrée repeater est configurée avec le même port "+GIWIK._plugins.network.repeater_port+"."
	};
	
	// [page systemtime]
	// Titre de la boite de configuration
	MSG.box.systemtime_title = {
		en: "SYSTEM TIME",
		fr: "DATE ET HEURE DU SYSTÈME"
	};

// CAPTEURS (popup des statuts détaillés)////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	MSG.sensors.input = {
		en: "Input",
		fr: "Entrées"
	};
	MSG.sensors.inputs = {
		en: "Inputs",
		fr: "Entrées"
	};
	/*MSG.sensors.evm = {
		en: "Event Markers",
		fr: "Event Markers"
	};*/

	MSG.sensors.output = {
		en: "Output",
		fr: "Sorties"
	};

	MSG.sensors.input_output = {
		en: "Input / Output",
		fr: "Entrées / Sorties"
	};
	MSG.sensors.system = {
		en: "System",
		fr: "Système"
	};
	MSG.sensors.externalsensors = {
		en: "Ext. Sensors",
		fr: "Capteurs ext."
	};

// PARAMETRES /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// [Control]
	MSG.parameters.forced = MSG.shared.forced;

	// [Installation] Inputs
	MSG.parameters.repeater = {
		en: "Repeater",
		fr: "Répéteur"
	},
	MSG.parameters.can = {
		en: "CAN",
		fr: "CAN"
	},	
	MSG.parameters.depthoffset = {
		en: "Depth Offset",
		fr: "Offset profondeur",
		ru: "Поправка глубины"
	};
	MSG.parameters.watertype_label = {
		en: "Water Type",
		fr: "Type d'eau",
		ru: "Тип воды"
	};
	MSG.parameters.saltwatertype_label = {
		en: "Salt Water",
		fr: "Eau salée",
		ru: "соленая вода"
	};
	MSG.parameters.freshwatertype_label = {
		en: "Fresh Water",
		fr: "Eau douce",
		ru: "пресная вода"
	};
	MSG.parameters.waterdensity_label = {
		en: "Density",
		fr: "Densité",
		ru: "плотность"
	};
	MSG.parameters.serial_status = {
		en: "Check the baudrate or the output rate",
		fr: "Vérifier le débit ou la fréquence de sortie"
	};
	MSG.parameters.geoid = {
		en: "Geoidal Separation",
		fr: "Séparation géoïdale"
	};
	
	// [Installation] Outputs
	MSG.parameters.altiref = {
		en: "Altitude<br/>Reference",
		fr: "Référence<br/>d'altitude",
		ru: "Референция высоты"
	};
	MSG.parameters.zda = {
		en: "Timestamp (ZDA)",
		fr: "Datation (ZDA)"
	};
	// [Setup] External Sensors
	MSG.parameters.beacon_label = {
		en: "Beacon ID",
		fr: "N° Transpondeur"
	};
	MSG.parameters.beacon_prefix = {
		en: "Beacon ",
		fr: "Transpondeur "
	};
	MSG.parameters.tpcode_label = {
		en: "TP Code",
		fr: "Code transpondeur"
	};
	// [Setup] Warnings
	MSG.parameters.params_heading_stdev_warning = {
		en: "Generate a warning if heading standard deviation is above:",
		fr: "Générer une alerte si l'écart-type de cap dépasse :"
	};
	MSG.parameters.params_position_stdev_warning = {
		en: "Generate a warning if position standard deviation is above:",
		fr: "Générer une alerte si l'écart-type de position dépasse :"
	};
	// [Setup] Initial position
	MSG.parameters.waypoint_list_label = {
		en: "Shortcuts",
		fr: "Raccourcis"
	};
	MSG.parameters.waypoint_remove = {
		en: "Delete",
		fr: "Supprimer"
	};
	MSG.parameters.waypoint_label = {
		en: "Label",
		fr: "Label"
	};
	MSG.parameters.waypoint_delete = {
		en: "Delete shortcut",
		fr: "Supprimer un raccourci"
	};
	MSG.parameters.waypoint_current = {
		en: "Replace<br/>By Current<br/>Position",
		fr: "Utiliser<br/>la position<br/>courante"
	};
	MSG.parameters.always_true = {
		en: "Manual position forced",
		fr: "Position manuelle forcée"
	};
	MSG.parameters.always_used = {
		en: "Forced Mode",
		fr: "Mode Forcé"
	};
	MSG.parameters.trigger_pulse = {
		en: "Input Pulse<br/>for Triggering DVL",
		fr: "Pulse d'entrée<br/>pour trigger DVL"
	};	
	
	MSG.parameters.manualdata_update = {
		en: "Automatically update with last received position",
		fr: "Mise à jour auto. avec la dernière position reçue"
	};	
	MSG.parameters.dvlwt_always_used = {
		en: "WT Forced Mode",
		fr: "WT Mode forcé"
	};
	MSG.parameters.dvlbt_always_used = {
		en: "BT Forced Mode",
		fr: "BT Mode forcé"
	};
	MSG.parameters.vtg_always_used = {
		en: "VTG Forced Mode",
		fr: "VTG Mode forcé"
	};	
	MSG.parameters.force_utm_zone = {
		en: "Extend current UTM Zone",
		fr: "Etendre la Zone UTM courante"
	};
	MSG.parameters.zup_mode = {
		en: "ZUPT Mode",
		fr: "Mode ZUPT"
	};
	MSG.parameters.alti_mode = {
		en: "Altitude Mode",
		fr: "Mode<br/>d'altitude"
	};
	MSG.parameters.heave_mode = {
		en: "Sea State",
		fr: "Etat de mer"
	};
	MSG.parameters.start_mode_label = {
		en: "Starting Mode",
		fr: "Mode<br/> de démarrage"
	};
	MSG.parameters.navigation_mode_label = {
		en: "Navigation<br/>Mode",
		fr: "Mode<br/>de navigation"
	};
	MSG.parameters.dynamic_mode_label = {
		en: "Vehicle type",
		fr: "Type de véhicule"
	};
	MSG.parameters.initial_position = {
		en: "Initial Position",
		fr: "Position initiale"
	};
	MSG.parameters.stddev_label = {
		en: "Precision",
    	fr: "Précision"
	};
	MSG.parameters.time_label = {
    	en: "Time",
    	fr: "Temps"
	};
	MSG.parameters.amplitude_label = {
    	en: "Amplitude",
    	fr: "Amplitude"
	};
	// [Setup] Calibration
	MSG.parameters.cal_distance = {
		en: "Line Length",
		fr: "Distance<br/>parcourue"
	};
	// [Setup] Coupling mode
	MSG.parameters.coupling_mode = {
		en: "DVL coupled<br/>to System",
		fr: "DVL couplé<br/>au système"
	};
	// [Setup] DVL Type
	MSG.parameters.dvl_type = {
		en: "DVL Type",
		fr: "Type de DVL"
	};
	MSG.parameters.dvl_type_standard = {
		en: "Standard",
		fr: "Standard"
	};
	MSG.parameters.dvl_type_phasedarray = {
		en: "Phased Array",
		fr: "Phased Array"
	};	
	// [Setup] Calibration/Verification status
	MSG.parameters.calchk_status = {
		en: "Status",
		fr: "Statut"
	};

	// [Setup] Navigation - Travelled Distance
	MSG.parameters.travelled_distance = {
		en: "Distance",
		fr: "Distance"
	};
	
	// [Setup] Advanced Configuration
	MSG.parameters.enable_advanced_settings_label = {
		en: "Filtering Mode",
		fr: "Mode de filtrage"};

	MSG.parameters.acceptedgpsmode = {
		en: function () {return (GIWIK.gnss) ? "Accepted GNSS Modes" : "Accepted GPS Modes";},
		fr: function () {return (GIWIK.gnss) ? "Modes GNSS acceptés" : "Modes GPS acceptés";}
	};

	MSG.parameters.usestddev = {
		en: "Enable",
		fr: "Activer"};

	MSG.parameters.maxstddev = {
		en: "Reject if Standard Deviation is above",
		fr: "Rejeter si Ecart-Type supérieur à"};

	MSG.parameters.minstddev = {
		en: "Limit Standard Deviation to at least",
		fr: "Limitation de l'Ecart-Type minimum à"};

	MSG.parameters.lambda = {
		en: "Rejection Factor",
		fr: "Facteur de réjection"};

	MSG.parameters.bottomspeed_stddev = {
		en: "Bottom Speed Input Standard Deviation",
		fr: "Ecart type de vitesse fond"};

	MSG.parameters.waterspeed_stddev = {
		en: "Water Speed Input Standard Deviation",
		fr: "Ecart type de vitesse surface"};

	MSG.parameters.depth_stddev = {
		en: "Depth Input Standard Deviation",
		fr: "Ecart type de profondeur"};

	MSG.parameters.speed_saturation = {
		en: "Speed Saturation",
		fr: "Saturation de vitesse"};
		
	MSG.parameters.gpsmodenat = {
		en: "Natural (1)",
		fr: "Naturel (1)"};

	MSG.parameters.gpsmodedif = {
		en: "Differential (2)",
		fr: "Différentiel (2)"};

	MSG.parameters.gpsmodemil = {
		en: "Military (3)",
		fr: "Militaire (3)"};

	MSG.parameters.gpsmodertk = {
		en: "RTK (4)",
		fr: "RTK (4)"};

	MSG.parameters.gpsmodertf = {
		en: "Float RTK (5)",
		fr: "Float RTK (5)"};

	MSG.parameters.radio_gpsQF0 = {
		en: function () {return (GIWIK.gnss) ? "Limit GNSS Quality to Differential(2) or Natural(1)" : "Limit GPS Quality to Differential(2) or Natural(1)";},
		fr: function () {return (GIWIK.gnss) ? "Limiter le facteur de qualité GNSS à Différentiel(2) ou Naturel(1)" : "Limiter le facteur de qualité GPS à Différentiel(2) ou Naturel(1)";}
	};
	MSG.parameters.radio_gpsQF1 = {
		en: function () {return (GIWIK.gnss) ? "Force GNSS Quality Factor to Natural(1)" : "Force GPS Quality Factor to Natural(1)";},
		fr: function () {return (GIWIK.gnss) ? "Forcer le facteur de qualité GNSS à Naturel(1)" : "Forcer le facteur de qualité GPS à Naturel(1)";}
	};
	MSG.parameters.radio_gpsQF2 = {
		en: function () {return (GIWIK.gnss) ? "Force GNSS Quality Factor to Differential (2)" : "Force GPS Quality Factor to Differential (2)";},
		fr: function () {return (GIWIK.gnss) ? "Forcer le facteur de qualité GNSS à Différentiel (2)" : "Forcer le facteur de qualité GPS à Différentiel (2)";}
	};
	MSG.parameters.radio_gpsQF3 = {
		en: function () {return (GIWIK.gnss) ? "Force GNSS Quality Factor to RTK(4)" : "Force GPS Quality Factor to RTK(4)";},
		fr: function () {return (GIWIK.gnss) ? "Forcer le facteur de qualité GNSS à RTK(4)" : "Forcer le facteur de qualité GPS à RTK(4)";}
	};
	MSG.parameters.radio_gpsQF4 = {
		en: function () {return (GIWIK.gnss) ? "Copy input GNSS Quality Factor" : "Copy input GPS Quality Factor";},
		fr: function () {return (GIWIK.gnss) ? "Recopier le facteur de qualité GNSS en entrée" : "Recopier le facteur de qualité GPS en entrée";}
	};
	MSG.parameters.radio_gpsQF5 = {
		en: "None",
		fr: "Aucun"};
	MSG.parameters.radio_posprio0 = {
		en: function () {return (GIWIK.gnss) ? "GNSS" : "GPS";},
		fr: function () {return (GIWIK.gnss) ? "GNSS" : "GPS";}
	};
	MSG.parameters.radio_posprio1 = {
		en: "USBL",
		fr: "USBL"};
	MSG.parameters.radio_posprio2 = {
		en: "None",
		fr: "Aucun"};

	MSG.parameters.emlochstddev = {
		en: "Longitudinal Speed Input Standard Deviation",
		fr: "Ecart type de vitesse longitudinale"};

	// [Setup] Calibration
	MSG.parameters.dvl_id = {
		en: "DVL Id",
		fr: "Id DVL"
	};
	MSG.parameters.calchk_distance_label = {
		en: "Line length",
		fr: "Distance<br/>parcourue"
	};
	MSG.parameters.calchk_hdrift_label = {
		en: "Horizontal<br/>Drift",
		fr: "Ecart<br/>Horizontal"
	};
	MSG.parameters.calchk_vdrift_label = {
		en: "Vertical<br/>Drift",
		fr: "Ecart<br/>Vertical"
	};
	MSG.parameters.calchk_herror_label = {
		en: "Horizontal<br/>Error",
		fr: "Erreur<br/>Horizontale"
	};
	MSG.parameters.calchk_verror_label = {
		en: "Vertical<br/>Error",
		fr: "Erreur<br/>Verticale"
	};
	MSG.parameters.dvlcalib_idle_state = {
		en: "Idle",
		fr: "Repos"
	};
	MSG.parameters.dvlcalib_wait_state = {
		en: "Waiting for alignment",
		fr: "Attente d'alignement"
	};
	MSG.parameters.dvlcalib_rough_state = {
		en: "Rough calibration",
		fr: "Calibration grossière"
	};
	MSG.parameters.dvlcalib_fine_state = {
		en: "Fine calibration",
		fr: "Calibration fine"
	};
	MSG.parameters.dvlcalib_calibration_state = {
		en: "Calibration in progress",
		fr: "Calibration en cours"
	};
	MSG.parameters.dvlcalib_end_state = {
		en: "End calibration",
		fr: "Calibration finie"
	};
	MSG.parameters.dvlchk_idle_state = {
		en: "Idle",
		fr: "Repos"
	};
	MSG.parameters.dvlchk_progress_state = {
		en: "Verification in progress",
		fr: "Vérification en cours"
	};
	//EVM
	MSG.parameters.eventmarker_0_label = {
		en: "Not used",
		fr: "Non utilisé"
	};
	MSG.parameters.eventmarker_1_label = {
		en: "Output in real time",
		fr: "Sortie en temps réel"
	};
	MSG.parameters.eventmarker_2_label = {
		en: "Output in post processing",
		fr: "Sortie dans le post processing"
	};
	MSG.parameters.pulseedge_label = {
		en: "Trigger",
		fr: "Déclencheur"
	};
	
	// Turret
	MSG.parameters.turret_heading_sign = {
		en: MSG.data.angles_heading.en,
		fr: MSG.data.angles_heading.fr
	};
	MSG.parameters.turret_roll_sign = {
		en: MSG.data.angles_roll.en,
		fr: MSG.data.angles_roll.fr
	};
	MSG.parameters.turret_pitch_sign = {
		en: MSG.data.angles_pitch.en,
		fr: MSG.data.angles_pitch.fr
	};	

// [system time]
MSG.parameters.synchronise_with_pc_clock = {
	en: "Synchronize With PC Clock",
	fr: "Synchroniser avec l'heure du PC"
};

// MESSAGES DE STATUTS LIES AUX ENTRÉES, SORTIES ET PULSES /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MSG.pulses_pro =
{
	 0: {
		en:'None',
		fr:'Aucun'
	},
	10: {
		en:"Event Marker Rising",
		fr:"Front Montant"
	},
	11: {
		en:"Event Marker Falling",
		fr:"Front Descendant"
	},
	14: {
		en:"Travel Lock",
		fr:"Travel Lock"
	}
};

// CAPTEURS EXTERNES SPECIFIQUES INS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Pour des raisons historiques, les INS utilisent "logem" à la place de "emlog"
MSG.ext_sensors.logem  = MSG.ext_sensors.emlog;
MSG.ext_sensors.logem2 = MSG.ext_sensors.emlog2;

MSG.ext_sensors.dov = {
	en: "DOV",
	fr: "DOV"
};

MSG.ext_sensors.utc = {
	en: function () {
		if( GIWIK.is_gyro==true ){
			return ((GIWIK._ext_sensors.utc2) ? 'Time' : 'Time');
		}else{
			return (GIWIK._ext_sensors.utc2) ? 'UTC 1' : 'UTC';
		}
	},
	fr: function () {
		if( GIWIK.is_gyro==true ){
			return ((GIWIK._ext_sensors.utc2) ? 'Temps' : 'Temps');
		}else{
			return (GIWIK._ext_sensors.utc2) ? 'UTC 1' : 'UTC';
		}
	}
};
MSG.ext_sensors.utc2 = {
	en: function () {
		if( GIWIK.is_gyro==true ){
			return ((GIWIK._backup_sensors) ? 'Backup Time' : 'Time 2');
		}else{
			return 'UTC 2';
		}
	},
	fr: function () {
		if( GIWIK.is_gyro==true ){
			return ((GIWIK._backup_sensors) ? 'Temps de secours' : 'Temps 2');
		}else{
			return 'UTC 2';
		}
	}
};

MSG.ext_sensors.gps ={
	en: function () {
		if( GIWIK.is_gyro==true ){
			return ((GIWIK._ext_sensors.gps2) ? 'Position' : 'Position');
		}else{
			return (GIWIK.gnss) ? MSG.ext_sensors.gnss.en() : ((GIWIK._ext_sensors.gps2) ? 'GPS 1' : 'GPS');
		}
	},
	fr: function () {
		if( GIWIK.is_gyro==true ){
				return ((GIWIK._ext_sensors.gps2) ? 'Position' : 'Position');
		}else{
			return (GIWIK.gnss) ? MSG.ext_sensors.gnss.fr() : ((GIWIK._ext_sensors.gps2) ? 'GPS 1' : 'GPS');
		}
	},
};

MSG.ext_sensors.gps2 = {
	en: function () {
		if( GIWIK.is_gyro==true ){
			return ((GIWIK._backup_sensors) ? 'Backup Position' : 'Position');
		}else{
			return (GIWIK.gnss) ? MSG.ext_sensors.gnss2.en : "GPS 2";
		}
	},
	fr: function () {
		if( GIWIK.is_gyro==true ){
			return ((GIWIK._backup_sensors) ? "Position de secours" : 'Position 2');
		}else{
			return (GIWIK.gnss) ? MSG.ext_sensors.gnss2.en : "GPS 2";
		}
	}
};

MSG.ext_sensors.logem = {
	en: function () {
		if( GIWIK.is_gyro==true ){
			return (GIWIK._ext_sensors.logem2) ? 'Speed'  : 'Speed';
		}else{
			return (GIWIK._ext_sensors.logem2) ? 'EM Log 1'  : 'EM Log';
		}
	},
	fr: function () {
		if( GIWIK.is_gyro==true ){
			return (GIWIK._ext_sensors.logem2) ? 'Vitesse'  : 'Vitesse';
		}else{
			return (GIWIK._ext_sensors.logem2) ? 'Loch EM 1' : 'Loch EM';
		}
	}
};

MSG.ext_sensors.logem2 = {
	en: function () {
		if( GIWIK.is_gyro==true ){
			return ((GIWIK._backup_sensors) ? 'Backup Speed' : 'Speed 2');
		}else{
			return 'EM Log 2';
		}
	},
	fr: function () {
		if( GIWIK.is_gyro==true ){
			return ((GIWIK._backup_sensors) ? 'Vitesse de secours' : 'Vitesse 2');
		}else{
			return 'Loch EM 2';
		}
	}
};

MSG.ext_sensors.angles = {
		en: function () { return GIWIK._plugins.mechanical.turret===true ? MSG.ext_sensors.turret.en : "Angles"; },
		fr: function () { return GIWIK._plugins.mechanical.turret===true ? MSG.ext_sensors.turret.fr : "Angles"; },
		ru: "Углы"
	}, 
	
MSG.ext_sensors.turret = {
	en: "Turret",
	fr: "Tourelle",
};
	

MSG.ext_sensors.external_position = {
    en: function () {return ("External " + MSG(['ext_sensors','gps'])).replace("1","");},
	fr: function () {return (MSG(['ext_sensors','gps'])+" externe" ).replace("1","");}
};
MSG.ext_sensors.external_position2 = {
    en: function () {return "External " + MSG(['ext_sensors','gps2']);},
	fr: function () {return MSG(['ext_sensors','gps2']).replace("2","externe 2");}
};

MSG.ext_sensors.external_speed = {
    en: function () {return ("External " + MSG(['ext_sensors','logem'])).replace("1","");},
	fr: function () {return (MSG(['ext_sensors','logem'])+" externe" ).replace("1","");}
};
MSG.ext_sensors.external_speed2 = {
    en: function () {return "External " + MSG(['ext_sensors','logem2']);},
	fr: function () {return MSG(['ext_sensors','logem2']).replace("2","externe 2");}
};

	
// UNITS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
MSG.units.volumetric_mass_density = {
		en: "kg/m3",
		fr: "kg/m3",
		ru: "kg/m3"
};
MSG.units.pulses_s = {
		en: "pulses/s",
		fr: "pulses/s"
};