//Dynamic Positionning Page (DP page)
GIWIK.init.js('css');

HEADING.Show_StandardDeviation = function()
{
	// GPS STANDARD DEVIATION
	//MIN
	if(window.Checkbox_Gpsminstddev.getValue() == 1)
	{
		window.Input_gpsminstddev.enable();
	}
	else
	{
		window.Input_gpsminstddev.disable();
		window.Input_gpsminstddev.setValue(0);
	}
	// MAX
	if(window.Checkbox_Gpsmaxstddev.getValue() == 1)
	{
		window.Input_gpsmaxstddev.enable();
	}
	else
	{
		window.Input_gpsmaxstddev.disable();
		window.Input_gpsmaxstddev.setValue(0);
	}
	
	//USBL STANDARD DEVIATION
	//MIN
	if(window.Checkbox_Usblminstddev.getValue() == 1)
	{
		window.Input_usblminstddev.enable();
	}
	else
	{
		window.Input_usblminstddev.disable();
		window.Input_usblminstddev.setValue(0);
	}
	//MAX
	if(window.Checkbox_Usblmaxstddev.getValue() == 1)
	{
		window.Input_usblmaxstddev.enable();
	}
	else
	{
		window.Input_usblmaxstddev.disable();
		window.Input_usblmaxstddev.setValue(0);
	}
}

HEADING.Enable_AdvancedSetting = function(enable)
{
	// Slide Parametres
	$('#advancedsettings_params_ctnr')['slide'+((enable === 1) ? 'Down' : 'Up')]();

	// Dispay/Hide restore Button
	if( enable === 1){
		window.Button_restore_default.enable();
		window.Button_restore_default.show();
	}
	else{
		window.Button_restore_default.disable();
		window.Button_restore_default.hide();	
	}
	
	// Enable Changed
	window.EnableSettingsChanged  = true;
}


HEADING.Restore_DefaultAdvancedSetting = function()
{
	// Restore Request
	window.RestoreSettingsChanged = true;
	
	// Send Conf
	HEADING.sendConf();
}

HEADING.setSettingsActivity.local = function (action)
{
	if (action == 'enable')
	{
		HEADING.Enable_AdvancedSetting(window.Switch_enable_advanced_settings.getValue());
		HEADING.Show_StandardDeviation();
	}
};

HEADING.readConf.local = function()
{
	if(!HEADING.init.isdone)
	{
		// GPS input filter [Min]: Checkbox used to know if the field is used or not
		window.Checkbox_Gpsminstddev = new Input_checkbox('Checkbox_Gpsminstddev', true);
		window.Checkbox_Gpsminstddev.label_width = HEADING.activate_label_width;
		window.Checkbox_Gpsminstddev.construct('checkbox_gpsminstddev','linear',MSG(['parameters','usestddev']),[0,1], true);
		window.Checkbox_Gpsminstddev.setAction("HEADING.Show_StandardDeviation();window.GpsFilterParamsChanged=true;", true);
		window.Checkbox_Gpsminstddev.show();

		// GPS input filter [Max]: Checkbox used to know if the field is used or not
		window.Checkbox_Gpsmaxstddev = new Input_checkbox('Checkbox_Gpsmaxstddev', true);
		window.Checkbox_Gpsmaxstddev.label_width = HEADING.activate_label_width;
		window.Checkbox_Gpsmaxstddev.construct('checkbox_gpsmaxstddev','linear',MSG(['parameters','usestddev']),[0,1], true);
		window.Checkbox_Gpsmaxstddev.setAction("HEADING.Show_StandardDeviation();window.GpsFilterParamsChanged=true;", true);
		window.Checkbox_Gpsmaxstddev.show();

		// GPS  input filter
		window.Input_gpsmaxstddev = new Input_int('Input_gpsmaxstddev', true);
		window.Input_gpsmaxstddev.label_width = HEADING.heading_labels_width;
		window.Input_gpsmaxstddev.input_width = HEADING.heading_input_width;
		window.Input_gpsmaxstddev.construct('input_gpsmaxstddev','linear',MSG(['parameters','maxstddev']),0.01,0.0,100,MSG(['units','meter']));
		window.Input_gpsmaxstddev.setAction("window.GpsFilterParamsChanged=true;", true);
		window.Input_gpsmaxstddev.show();

        window.Input_gpsminstddev = new Input_int('Input_gpsminstddev', true);
		window.Input_gpsminstddev.label_width = HEADING.heading_labels_width;
		window.Input_gpsminstddev.input_width = HEADING.heading_input_width;
		window.Input_gpsminstddev.construct('input_gpsminstddev','linear',MSG(['parameters','minstddev']),0.01,0.0,100,MSG(['units','meter']));
		window.Input_gpsminstddev.setAction("window.GpsFilterParamsChanged=true;", true);
		window.Input_gpsminstddev.show();

/*		//PHSUR-614: Remove lambda parameter setting
        HEADING.GpsLambdaList = [0.5,1,2,3,4,5,6];
		window.Select_GpsLambda = new Input_select('Select_GpsLambda', true);
		window.Select_GpsLambda.label_width = HEADING.heading_labels_width;
		window.Select_GpsLambda.input_width = HEADING.heading_input_width;
		window.Select_GpsLambda.text_align = 'center';
		window.Select_GpsLambda.construct('input_gpslambda','linear',MSG(['parameters','lambda']),HEADING.GpsLambdaList,HEADING.GpsLambdaList, '','',true);
		window.Select_GpsLambda.setAction("window.GpsFilterParamsChanged=true;", true);
		window.Select_GpsLambda.show();
*/
		// Input speed std
		window.Input_bottomspeed_stddev = new Input_int('Input_bottomspeed_stddev', true);
		window.Input_bottomspeed_stddev.label_width = HEADING.heading_labels_width;
		window.Input_bottomspeed_stddev.input_width = HEADING.heading_input_width;
		window.Input_bottomspeed_stddev.construct('input_bottomspeed_stddev','linear',MSG(['parameters','bottomspeed_stddev']),0.001,0.025,10.0,MSG(['units','meter_per_second']));
		window.Input_bottomspeed_stddev.setAction("window.SpeedsStdDevChanged=true;", true);
		window.Input_bottomspeed_stddev.show();

		window.Input_waterspeed_stddev = new Input_int('Input_waterspeed_stddev', true);
		window.Input_waterspeed_stddev.label_width = HEADING.heading_labels_width;
		window.Input_waterspeed_stddev.input_width = HEADING.heading_input_width;
		window.Input_waterspeed_stddev.construct('input_waterspeed_stddev','linear',MSG(['parameters','waterspeed_stddev']),0.001,0.025,10.0,MSG(['units','meter_per_second']));
		window.Input_waterspeed_stddev.setAction("window.SpeedsStdDevChanged=true;", true);
		window.Input_waterspeed_stddev.show();

		// Input depth std
		window.Input_depth_stddev = new Input_int('Input_depth_stddev', true);
		window.Input_depth_stddev.label_width = HEADING.heading_labels_width;
		window.Input_depth_stddev.input_width = HEADING.heading_input_width;
		window.Input_depth_stddev.construct('input_depth_stddev','linear',MSG(['parameters','depth_stddev']),0.01,0.01,100.0,MSG(['units','meter']));
		window.Input_depth_stddev.setAction("window.DepthStdDevChanged=true;", true);
		window.Input_depth_stddev.show();

		if(GIWIK.speed_saturation){
			// Input Speed Saturation
			window.Input_speed_saturation = new Input_int('Input_speed_saturation', true);
			window.Input_speed_saturation.label_width = HEADING.heading_labels_width;
			window.Input_speed_saturation.input_width = HEADING.heading_input_width;
			window.Input_speed_saturation.construct('input_speed_saturation','linear',MSG(['parameters','speed_saturation']),1,2,40,MSG(['units','meter_per_second']));
			window.Input_speed_saturation.setAction("window.SpeedSaturationChanged=true;", true);
			window.Input_speed_saturation.show();
		}
		// GPS mode
			// qualité Natural
		window.Checkbox_GpsModeNat = new Input_checkbox('Checkbox_GpsModeNat', true);
		window.Checkbox_GpsModeNat.label_width = HEADING.gps_label_width;
		window.Checkbox_GpsModeNat.construct('checkbox_gpsmodenat','linear',MSG(['parameters','gpsmodenat']),[0,1], true);
		window.Checkbox_GpsModeNat.setAction("window.GpsModesChanged=true;");
		window.Checkbox_GpsModeNat.show();

			// qualité Diff.
		window.Checkbox_GpsModeDif = new Input_checkbox('Checkbox_GpsModeDif', true);
		window.Checkbox_GpsModeDif.label_width = HEADING.gps_label_width;
		window.Checkbox_GpsModeDif.construct('checkbox_gpsmodedif','linear',MSG(['parameters','gpsmodedif']),[0,1], true);
		window.Checkbox_GpsModeDif.setAction("window.GpsModesChanged=true;");
		window.Checkbox_GpsModeDif.show();

			// qualité Militaire
		window.Checkbox_GpsModeMil = new Input_checkbox('Checkbox_GpsModeMil', true);
		window.Checkbox_GpsModeMil.label_width = HEADING.gps_label_width;
		window.Checkbox_GpsModeMil.construct('checkbox_gpsmodemil','linear',MSG(['parameters','gpsmodemil']),[0,1], true);
		window.Checkbox_GpsModeMil.setAction("window.GpsModesChanged=true;");
		window.Checkbox_GpsModeMil.show();

			// qualité RTK
		window.Checkbox_GpsModeRtk = new Input_checkbox('Checkbox_GpsModeRtk', true);
		window.Checkbox_GpsModeRtk.label_width = HEADING.gps_label_width;
		window.Checkbox_GpsModeRtk.construct('checkbox_gpsmodertk','linear',MSG(['parameters','gpsmodertk']),[0,1], true);
		window.Checkbox_GpsModeRtk.setAction("window.GpsModesChanged=true;");
		window.Checkbox_GpsModeRtk.show();

			// qualité Float RTK
		window.Checkbox_GpsModeRtf = new Input_checkbox('Checkbox_GpsModeRtf', true);
		window.Checkbox_GpsModeRtf.label_width = HEADING.gps_label_width;
		window.Checkbox_GpsModeRtf.construct('checkbox_gpsmodertf','linear',MSG(['parameters','gpsmodertf']),[0,1], true);
		window.Checkbox_GpsModeRtf.setAction("window.GpsModesChanged=true;");
		window.Checkbox_GpsModeRtf.show();

		// Usbl input filter [Min]: Checkbox used to know if the field is used or not
		window.Checkbox_Usblminstddev = new Input_checkbox('Checkbox_Usblminstddev', true);
		window.Checkbox_Usblminstddev.label_width = HEADING.activate_label_width;
		window.Checkbox_Usblminstddev.construct('checkbox_usblminstddev','linear',MSG(['parameters','usestddev']),[0,1], true);
		window.Checkbox_Usblminstddev.setAction("HEADING.Show_StandardDeviation();window.UsblFilterParamsChanged=true;", true);
		window.Checkbox_Usblminstddev.show();

		// Usbl input filter [Max]: Checkbox used to know if the field is used or not
		window.Checkbox_Usblmaxstddev = new Input_checkbox('Checkbox_Usblmaxstddev', true);
		window.Checkbox_Usblmaxstddev.label_width = HEADING.activate_label_width;
		window.Checkbox_Usblmaxstddev.construct('checkbox_usblmaxstddev','linear',MSG(['parameters','usestddev']),[0,1], true);
		window.Checkbox_Usblmaxstddev.setAction("HEADING.Show_StandardDeviation();window.UsblFilterParamsChanged=true;", true);
		window.Checkbox_Usblmaxstddev.show();

		// Usbl input filter
        window.Input_usblmaxstddev = new Input_int('Input_usblmaxstddev', true);
		window.Input_usblmaxstddev.label_width = HEADING.heading_labels_width;
		window.Input_usblmaxstddev.input_width = HEADING.heading_input_width;
		window.Input_usblmaxstddev.construct('input_usblmaxstddev','linear',MSG(['parameters','maxstddev']),0.01,0.0,100,MSG(['units','meter']));
		window.Input_usblmaxstddev.setAction("window.UsblFilterParamsChanged=true;", true);
		window.Input_usblmaxstddev.show();

		window.Input_usblminstddev = new Input_int('Input_usblminstddev', true);
		window.Input_usblminstddev.label_width = HEADING.heading_labels_width;
		window.Input_usblminstddev.input_width = HEADING.heading_input_width;
		window.Input_usblminstddev.construct('input_usblminstddev','linear',MSG(['parameters','minstddev']),0.01,0.0,100,MSG(['units','meter']));
		window.Input_usblminstddev.setAction("window.UsblFilterParamsChanged=true;", true);
		window.Input_usblminstddev.show();

/*		//PHSUR-614: Remove lambda parameter setting
        HEADING.UsblLambdaList = [0.5,1,2,3,4,5,6];
		window.Select_UsblLambda = new Input_select('Select_UsblLambda', true);
		window.Select_UsblLambda.label_width = 226;
		window.Select_UsblLambda.input_width = HEADING.heading_input_width;
		window.Select_UsblLambda.text_align = 'center';
		window.Select_UsblLambda.construct('input_usbllambda','linear',MSG(['parameters','lambda']),HEADING.UsblLambdaList,HEADING.UsblLambdaList, '','',true);
		window.Select_UsblLambda.setAction("window.UsblFilterParamsChanged=true;", true);
		window.Select_UsblLambda.show();
*/
	    window.Input_emlochstddev = new Input_int('Input_emlochstddev', true);
		window.Input_emlochstddev.label_width = HEADING.heading_labels_width;
		window.Input_emlochstddev.input_width = HEADING.heading_input_width;
		window.Input_emlochstddev.construct('input_emlochstddev','linear',MSG(['parameters','emlochstddev']),0.001,0.015,10.0,MSG(['units','meter_per_second']));
		window.Input_emlochstddev.setAction("window.EmLochStdDevChanged=true;", true);
		window.Input_emlochstddev.show();
	}

	//  Mode Enable
	window.Switch_enable_advanced_settings.setValue(System_state.DP_State[0]);

	// GPS Input filter
	if(eval(System_state.DP_GpsFilterParams[0]) == 0)
	{
		window.Checkbox_Gpsminstddev.setValue(0);
	}
	else
	{
		window.Checkbox_Gpsminstddev.setValue(1);
		window.Input_gpsminstddev.setValue(eval(System_state.DP_GpsFilterParams[0]));
	}

	if(eval(System_state.DP_GpsFilterParams[1]) == 0)
	{
		window.Checkbox_Gpsmaxstddev.setValue(0);
	}
	else
	{
		window.Checkbox_Gpsmaxstddev.setValue(1);
		window.Input_gpsmaxstddev.setValue(eval(System_state.DP_GpsFilterParams[1]));
	}

/*	//PHSUR-614: Suppress lambda parameter setting
	window.Select_GpsLambda.setValue(eval(System_state.DP_GpsFilterParams[2]));
*/
	window.GpsFilterParamsChanged = false;

	window.Checkbox_GpsModeNat.setValue(eval(System_state.DP_GpsModes[0]));
	window.Checkbox_GpsModeDif.setValue(eval(System_state.DP_GpsModes[1]));
	window.Checkbox_GpsModeMil.setValue(eval(System_state.DP_GpsModes[2]));
	window.Checkbox_GpsModeRtk.setValue(eval(System_state.DP_GpsModes[3]));
	window.Checkbox_GpsModeRtf.setValue(eval(System_state.DP_GpsModes[4]));
	window.GpsModesChanged = false;

	// USBL Input filter
	if(eval(System_state.DP_UsblFilterParams[0]) == 0)
	{
		window.Checkbox_Usblminstddev.setValue(0);
	}
	else
	{
		window.Checkbox_Usblminstddev.setValue(1);
		window.Input_usblminstddev.setValue(eval(System_state.DP_UsblFilterParams[0]));
	}
	
	if(eval(System_state.DP_UsblFilterParams[1]) == 0)
	{
		window.Checkbox_Usblmaxstddev.setValue(0);
	}
	else
	{
		window.Checkbox_Usblmaxstddev.setValue(1);
		window.Input_usblmaxstddev.setValue(eval(System_state.DP_UsblFilterParams[1]));
	}
	
	window.UsblFilterParamsChanged = false;
	// Input speeds std dev
	window.Input_bottomspeed_stddev.setValue(eval(System_state.DP_SpeedsStdDev[0]));
	window.Input_waterspeed_stddev.setValue(eval(System_state.DP_SpeedsStdDev[1]));
	window.SpeedsStdDevChanged = false;

	// Input depth std dev
	window.Input_depth_stddev.setValue(eval(System_state.DP_DepthStdDev));
	window.DepthStdDevChanged = false;

	// Output GPS Quality
	for(i=0;i<6;i++){
		eval("window.Radio_gpsQF"+i+".setValue(System_state.DP_GpsOutQF);");
	}
	// Position Sensor Priority
	for(i=0;i<3;i++){
		eval("window.Radio_posprio"+i+".setValue(System_state.DP_PosPrio);");
	}
	
	//EMLOG speed std dev
	window.Input_emlochstddev.setValue(eval(System_state.DP_EmlogSpeedStdDev));
	window.EmLochStdDevChanged = false;
	
	if(GIWIK.speed_saturation){
		// Speed Saturation
		window.Input_speed_saturation.setValue(eval(System_state.DP_SpeedSaturation));
		window.SpeedSaturationChanged = false;
	}
};

HEADING.getConf.local = function()
{
	var _params = {};

	_params['DP_State']            = "";
	_params['DP_PosPrio']          = "";
	_params['DP_GpsOutQF']         = "";
	_params['DP_GpsFilterParams']  = "";
	_params['DP_GpsModes']         = "";
	_params['DP_UsblFilterParams'] = "";
	_params['DP_EmlogSpeedStdDev'] = "";
	_params['DP_SpeedsStdDev']     = "";
	_params['DP_DepthStdDev']      = "";
	if(GIWIK.speed_saturation){
		_params['DP_SpeedSaturation']  = "";
	}
	
	return _params;
};

HEADING.sendConf.local = function()
{
	var _params = {};

	// Mode Enable/Disable + Restore
	if (window.EnableSettingsChanged==true || window.RestoreSettingsChanged == true)
	{
		_params['DP_State'] = window.Switch_enable_advanced_settings.getValue()+",";
		_params['DP_State'] += window.RestoreSettingsChanged == true ? 1 : 0;
	}

	if(window.RestoreSettingsChanged != true)
	{
		_params['DP_GpsOutQF'] = window.Radio_gpsQF0.getValue();
		_params['DP_PosPrio'] = window.Radio_posprio0.getValue();

		if(window.GpsFilterParamsChanged==true)
		{
			_params['DP_GpsFilterParams'] = window.Input_gpsminstddev.getValue()+","+
											window.Input_gpsmaxstddev.getValue();
		}

		if(window.GpsModesChanged==true)
		{
			_params['DP_GpsModes'] = window.Checkbox_GpsModeNat.getValue()+","+
									window.Checkbox_GpsModeDif.getValue()+","+
									window.Checkbox_GpsModeMil.getValue()+","+
									window.Checkbox_GpsModeRtk.getValue()+","+
									window.Checkbox_GpsModeRtf.getValue();
		}

		if(window.UsblFilterParamsChanged==true)
		{
			_params['DP_UsblFilterParams'] = window.Input_usblminstddev.getValue()+","+
											window.Input_usblmaxstddev.getValue();
		}

		if(window.EmLochStdDevChanged == true)
		{
			_params['DP_EmlogSpeedStdDev'] = window.Input_emlochstddev.getValue();
		}
		
		if(window.SpeedsStdDevChanged == true)
		{
			_params['DP_SpeedsStdDev'] = window.Input_bottomspeed_stddev.getValue()+","+
											   window.Input_waterspeed_stddev.getValue();
		}

		if(window.DepthStdDevChanged == true)
		{
			_params['DP_DepthStdDev'] = window.Input_depth_stddev.getValue();
		}
		
		if(GIWIK.speed_saturation){
			if(window.SpeedSaturationChanged == true)
			{
				_params['DP_SpeedSaturation'] = window.Input_speed_saturation.getValue();			
			}
		}
	}

	// Init Flags
	window.EnableSettingsChanged   = false;
	window.RestoreSettingsChanged  = false;
	window.GpsFilterParamsChanged  = false;
	window.GpsModesChanged         = false;
	window.UsblFilterParamsChanged = false;
	window.EmLochStdDevChanged     = false;
	window.SpeedsStdDevChanged     = false;
	window.DepthStdDevChanged      = false;
	if(GIWIK.speed_saturation){
		window.SpeedSaturationChanged  = false;
	}

	return _params;
};

HEADING.construct.local = function()
{
	var cnt = '';

	// Enable / Restore
	cnt += '<div id="advancedsettings_enable_ctnr" class="params_dp" >'
		+'<table class="params_restore_default">'
			+'<tr>'
				+'<td class="left">'
					+'<div id="switch_enable_advanced_settings"></div>'
				+'</td>'
				+'<td class="right">'
					+'<div id="button_restore_default"></div>'
				+'</td>'
			+'</tr>'
		+'</table>'
	+'</div>'

	// Param
	+'<div id="advancedsettings_params_ctnr" style="display:none">'

		+ '<div id="params_position_priority">'
		+ '<div id="params_position_priority">'
			+'<table class="params_gpsqualityfactor">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="radio_posprio0"></div>'
						+'<div id="radio_posprio1"></div>'
						+'<div id="radio_posprio2"></div>'
						+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>'

		+ '<div id="params_gps_inputfilter">'
			+'<table class="params_dp">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_gpsmaxstddev"></div>'
					+'</td>'
					+'<td class="right">'
						+'<div id="checkbox_gpsmaxstddev"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'

			+'<table class="params_dp">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="label_acceptedgpsmode" class="label_acceptedgpsmode"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'

			+'<div class="params_gpsqualitymode">'
				+'<div id="checkbox_gpsmodenat"></div>'
				+'<div id="checkbox_gpsmodedif"></div>'
				+'<div id="checkbox_gpsmodemil"></div>'
				+'<div id="checkbox_gpsmodertk"></div>'
				+'<div id="checkbox_gpsmodertf"></div>'
			+'</div>'
			+'<table class="params_dp">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_gpsminstddev"></div>'
/*	//PHSUR-614: Suppress lambda parameter setting
						+'<div id="input_gpslambda"></div>'
*/
					+'</td>'
					+'<td class="right">'
						+'<div id="checkbox_gpsminstddev"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>'

		+ '<div id="params_usbl_inputfilter">'
			+'<table class="params_dp">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_usblmaxstddev"></div>'
/*	//PHSUR-614: Suppress lambda parameter setting
						+'<div id="input_usbllambda"></div>'
*/
					+'</td>'
					+'<td class="right">'
						+'<div id="checkbox_usblmaxstddev"></div>'
					+'</td>'
				+'</tr>'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_usblminstddev"></div>'
					+'</td>'
					+'<td class="right">'
						+'<div id="checkbox_usblminstddev"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>'

		+ '<div id="params_emlogsstddev_input">'
			+'<table class="params_dp">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_emlochstddev"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>'
		
		+ '<div id="params_speedsstddev_input">'
			+'<table class="params_dp">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_bottomspeed_stddev"></div>'
						+'<div id="input_waterspeed_stddev"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>'

		+ '<div id="params_depthstddev_input">'
			+'<table class="params_dp">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="input_depth_stddev"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>'

		+ '<div id="params_gps_outputfilter">'
			+'<table class="params_gpsqualityfactor">'
				+'<tr>'
					+'<td align="left">'
						+'<div id="radio_gpsQF0"></div>'
						+'<div id="radio_gpsQF1"></div>'
						+'<div id="radio_gpsQF2"></div>'
						+'<div id="radio_gpsQF3"></div>'
						+'<div id="radio_gpsQF4"></div>'
						+'<div id="radio_gpsQF5"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';
		
		if(GIWIK.speed_saturation){
			cnt+= '<div id="params_speed_saturation">'
				+'<table class="params_dp">'
					+'<tr>'
						+'<td align="left">'
							+'<div id="input_speed_saturation"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>';
		}		


	cnt+='</div>';


	HEADING.heading_labels_width = 226;	// Définit la largeur des labels des paramètres de la page
	HEADING.heading_input_width  = 70;	// Définit la largeur des inputs des paramètres de la page

	HEADING.gps_label_width      = 85;	// Définit la largeur des checkbox gps
	HEADING.activate_label_width = 10;	// Définit la largeur des labels "Activate"

	//construct_heading_box(cnt, MSG(['box','dynamicpositionning_title']), true, [], ['', 'box_content_nopaddingtop']);
	$('#content').append(GIWIK.box(cnt, MSG(['box','dynamicpositionning_title']),true,[],['', 'box_content_nopaddingtop']));


	$('#label_acceptedgpsmode').html(MSG(['parameters','acceptedgpsmode']));

	// Groupes de paramètres
	GIWIK.paramGroup.construct('params_position_priority', MSG(['box','params_position_priority']), 'show');
	GIWIK.paramGroup.construct('params_gps_inputfilter', MSG(['box','params_gps_inputfilter']), 'show');
	GIWIK.paramGroup.construct('params_usbl_inputfilter', MSG(['box','params_usbl_inputfilter']), 'show');
	GIWIK.paramGroup.construct('params_emlogsstddev_input', MSG(['box','params_emlogsstddev_input']), 'show');
	GIWIK.paramGroup.construct('params_speedsstddev_input', MSG(['box','params_speedsstddev_input']), 'show');
	GIWIK.paramGroup.construct('params_depthstddev_input', MSG(['box','params_depthstddev_input']), 'show');
	GIWIK.paramGroup.construct('params_gps_outputfilter', MSG(['box','params_gps_outputfilter']), 'show');
	if(GIWIK.speed_saturation){
		GIWIK.paramGroup.construct('params_speed_saturation', MSG(['box','params_speed_saturation']), 'show');
	}
	//GIWIK.paramGroup.construct('params_restore_default', MSG(['box','params_restore_default']), 'show');

	// Paramètre "Enable"
	window.Switch_enable_advanced_settings = new Switch('Switch_enable_advanced_settings', true);
	window.Switch_enable_advanced_settings.label_width = 95;
	window.Switch_enable_advanced_settings.margin = "0 0 0 70px";
	window.Switch_enable_advanced_settings.construct('switch_enable_advanced_settings', 'linear', MSG(['parameters','enable_advanced_settings_label']), [0,1], true);
	window.Switch_enable_advanced_settings.setAction("HEADING.Enable_AdvancedSetting(window.Switch_enable_advanced_settings.getValue());", false);
	window.Switch_enable_advanced_settings.show();

	// Restore Default Button
	window.Button_restore_default = new Button('Button_restore_default', false);
	// window.Button_restore_default.margin = "0px 0px 0px 100px";
	window.Button_restore_default.construct('button_restore_default',MSG(['buttons','restore_default_advancedsettings']),'small');
	window.Button_restore_default.setAction("HEADING.Restore_DefaultAdvancedSetting();");


	// Boutons radios pour le choix de la qualite GPS en sortie
	var Radio_gpsQF_List=[1,2,3,4,5,0];
	for( i=0;i<6;i++)
	{
		eval("window.Radio_gpsQF"+i+" = new Input_radio('Radio_gpsQF"+i+"', true);");
		eval("window.Radio_gpsQF"+i+".padding_label_linear = 5;");
		eval("window.Radio_gpsQF"+i+".construct('radio_gpsQF"+i+"','gpsQF','linear',MSG(['parameters','radio_gpsQF"+i+"']),"+Radio_gpsQF_List[i]+",true);");
		eval("window.Radio_gpsQF"+i+".show();");
	}


	// Boutons radios pour le choix de la priorité de la donnée position en entrée
	var Radio_posprio_List=[1,2,0];
	for( i=0;i<3;i++)
	{
		eval("window.Radio_posprio"+i+" = new Input_radio('Radio_posprio"+i+"', true);");
		eval("window.Radio_posprio"+i+".padding_label_linear = 5;");
		eval("window.Radio_posprio"+i+".construct('radio_posprio"+i+"','posprio','linear',MSG(['parameters','radio_posprio"+i+"']),"+Radio_posprio_List[i]+",true);");
		eval("window.Radio_posprio"+i+".show();");
	}

};