GIWIK.init.js('css');


HEADING.saveWaypoint = function ()
{
	if(typeof Input_label !== 'undefined')
	{
		if (Input_label.getValue() != "")
		{
			// Set a new waypoint
			var i, wpt_val;

			wpt_val = Input_label.getValue() + "," +
			System_state.MANGPS[0]+"," +
			System_state.MANGPS[1]+ "," +
			System_state.MANGPSUTM[0]+","+
			System_state.MANGPSUTM[1]+","+
			System_state.MANGPSUTM[3]+","+
			System_state.MANGPSUTM[2]+","+
			System_state.MANGPSUTM[4];

			// Check for existing label
			for (i=0; i<window.WaypointNb;i++)
			{
				if (window.WaypointLabel[i] == Input_label.getValue())
				{
					window.Waypoint[i] = wpt_val;
					STORAGE.setPermanent("Wpt" + i, wpt_val);
					break;
				}
			}
			if (i == window.WaypointNb)
			{
				// No matching label => add a new label at the end.
				window.Waypoint[window.WaypointNb] = wpt_val;
				window.WaypointLabel[window.WaypointNb] = Input_label.getValue();
				STORAGE.setPermanent("Wpt" + window.WaypointNb, wpt_val);
				window.WaypointNb++;
				STORAGE.setPermanent("WptNb", window.WaypointNb);
			}
			window.Input_waypoint_list.setList(array_keys(window.WaypointLabel),window.WaypointLabel);
			window.Input_waypoint_list.setValue(i);
		}
	}
};


HEADING.setWaypoint = function (waypoint_id)
{
	window.ManPositionChanged = true;

	var wpt = window.Waypoint[waypoint_id].split(",");

	window.Input_label.setValue(wpt[0]);

	if (GIWIK.coordinate_mode === 1/*UTM*/)
	{
		window.Input_northing.setValue(wpt[3]);
		window.Input_easting.setValue(wpt[4]);
		window.Input_zone.setValue(wpt[5]);
	}
	else
	{
		window.Input_latitude.setValue(wpt[1]);
		window.Input_longitude.setValue(wpt[2]);
	}
	if (GIWIK.alti_depth!=false)window['Input_'+GIWIK.alti_depth].setValue(GIWIK.alti_depth_sign*wpt[6]);
	window.Select_stddev.setValue(eval(wpt[7]));
};


HEADING.useCurrentPosition = function ()
{
	window.ManPositionChanged = true;

	if (GIWIK.coordinate_mode === 1/*UTM*/)
	{
		window.Input_northing.setValue(System_state.utm_north);
		window.Input_easting.setValue(System_state.utm_east);
		window.Input_zone.setValue(System_state.utm_zone);
	}
	else
	{
		var latitude  = parseFloat(System_state.latitude);
		var longitude = parseFloat(System_state.longitude);

		// Pour les firmwares qui renvoient des lat/long sur 0->180 et 0->360 (au lieu de -90->90 et -180->180)
		if (latitude > 90)   {latitude = -180 + latitude;}
		if (longitude > 180) {longitude = -360 + longitude;}

		window.Input_latitude.setValue(latitude);
		window.Input_longitude.setValue(longitude);
	}
	if (GIWIK.alti_depth!=false)window['Input_'+GIWIK.alti_depth].setValue(System_state[GIWIK.alti_depth]);

	window.settings_modified = true;
};


HEADING.updateManualInputs = function ()
{
	var request = GIWIK.cgifile+"?mode=3";
	var request_to_send = 0;

	// Speed
	if (GIWIK.manualspeed)
	{
		// Unification des statuts dans un tableau
		//var _ui_status_unified = GIWIK.statusBitsInfo.unify(System_state._ui_status);

		// Ask for speed periodically
		//if (_ui_status_unified[49+4*32])
		{
			request += "&ManualSpeed";
			request_to_send = 1;
		}
	}

	// Do not manage Update
	if( GIWIK.manualposition_update )
	{
		// Position
		if (!GIWIK.is_marins)
		{
			request += "&MANPOS";
			request += "&MANPOSUTM";
		}
		request += "&MANGPS";
		request += "&MANGPSUTM";
		request_to_send = 1;
	}

	// Manual Inputs Request
	if (request_to_send)
	{
		// Indicates manualinputs_update_request
		window.manualinputs_update_request = 1;

		// Send Request
		GIWIK.ajax(request);
	}
}

HEADING.readData.local = function ()
{
	if (GIWIK.is_gyro === true)
	{
		if (System_state._ui_status[2]&0x40000000)
		{
			//Manual position: rejected due to inconsistent data
			window.Input_ManPosStatus.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[94].msg]));
			window.Input_ManPosStatus.setStatus(3);
			window.Input_ManPosStatus.show();
		}
		else
		{
			window.Input_ManPosStatus.hide();
		}
	}
	else
	{
		/* PHSUR-628: Add manual position rejection status on this page */
		if (System_state._ui_status[8]&0x80000000)
		{
			//Manual position: rejected due to inconsistent data
			window.Input_ManPosStatus.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[287].msg]));
			window.Input_ManPosStatus.setStatus(3);
			window.Input_ManPosStatus.show();
		}
		else if (System_state._ui_status[3]&0x80000000)
		{
			//Manual position: rejected
			window.Input_ManPosStatus.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[127].msg]));
			window.Input_ManPosStatus.setStatus(3);
			window.Input_ManPosStatus.show();

			HEADING.waiting_for_position_processing = false;
			clearTimeout(HEADING.waiting_for_position_timeout);
		}
		else if(System_state._ui_status[3]&0x40000000)
		{
			//Manual position: waiting
			window.Input_ManPosStatus.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[126].msg]));
			window.Input_ManPosStatus.setStatus(2);
			window.Input_ManPosStatus.show();
		}
		else if(System_state._ui_status[3]&0x20000000)
		{
			//Manual position: valide
			window.Input_ManPosStatus.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[125].msg]));
			window.Input_ManPosStatus.setStatus(1);
			window.Input_ManPosStatus.show();

			HEADING.waiting_for_position_processing = false;
			clearTimeout(HEADING.waiting_for_position_timeout);
		}
		else
		{
			window.Input_ManPosStatus.hide();
		}
		
		if(System_state._ui_status[3]&0x00008000)
		{
			//Manual position: rejected
			window.Input_ManAltStatus.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[111].msg]));
			window.Input_ManAltStatus.setStatus(3);
			window.Input_ManAltStatus.show();

			HEADING.waiting_for_position_processing = false;
			clearTimeout(HEADING.waiting_for_position_timeout);
		}
		else if(System_state._ui_status[3]&0x00004000)
		{
			//Manual position: waiting
			window.Input_ManAltStatus.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[110].msg]));
			window.Input_ManAltStatus.setStatus(2);
			window.Input_ManAltStatus.show();
		}
		else if(System_state._ui_status[3]&0x00002000)
		{
			//Manual position: valide
			window.Input_ManAltStatus.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[109].msg]));
			window.Input_ManAltStatus.setStatus(1);
			window.Input_ManAltStatus.show();

			HEADING.waiting_for_position_processing = false;
			clearTimeout(HEADING.waiting_for_position_timeout);
		}
		else
		{
			window.Input_ManAltStatus.hide();
		}
	}
};

HEADING.readConf.local = function ()
{
	if (HEADING.waypoint_set == 1)
	{
		HEADING.waypoint_set = 0;
		HEADING.saveWaypoint();
	}

	if (!HEADING.init.isdone)
	{
		if (GIWIK.coordinate_mode === 1/*UTM*/)
		{
			// Paramètre "Northing"
			window.Input_northing = new Input_int('Input_northing', true);
			window.Input_northing.label_width = window.heading_labels_width;
			window.Input_northing.input_width= window.heading_input_width;
			window.Input_northing.construct('input_northing','linear',MSG(['parameters','utm_northing']),0.01,0,20000000,MSG(['units','meter']));
			window.Input_northing.setAction("window.ManPositionChanged=true;");
			window.Input_northing.show();

			// Paramètre "Easting"
			window.Input_easting = new Input_int('Input_easting', true);
			window.Input_easting.label_width = window.heading_labels_width;
			window.Input_easting.input_width= window.heading_input_width;
			window.Input_easting.construct('input_easting','linear',MSG(['parameters','utm_easting']),0.01,0,1000000,MSG(['units','meter']));
			window.Input_easting.setAction("window.ManPositionChanged=true;");
			window.Input_easting.show();

			// Paramètre "Zone"
			window.Input_zone = new Input_text('Input_zone', true);
			window.Input_zone.label_width = window.heading_labels_width;
			window.Input_zone.input_width= window.heading_input_width;
			window.Input_zone.construct('input_zone','linear',MSG(['parameters','utm_zone']),"");
			window.Input_zone.setAction("window.ManPositionChanged = true;");
			window.Input_zone.show();

		}
		else
		{
			// Paramètre "Latitude"
			window.Input_latitude = new Input_latlong('Input_latitude', true);
			window.Input_latitude.label_width = window.heading_labels_width;
			window.Input_latitude.construct('input_latitude', MSG(['parameters','latitude']), Math.pow(10,-6), 'latitude');
			window.Input_latitude.setAction("window.ManPositionChanged=true;");//,true);
			window.Input_latitude.show();

			// Paramètre "Longitude"
			window.Input_longitude = new Input_latlong('Input_longitude', true);
			window.Input_longitude.label_width = window.heading_labels_width;
			window.Input_longitude.construct('input_longitude', MSG(['parameters','longitude']), Math.pow(10,-6), 'longitude');
			window.Input_longitude.setAction("window.ManPositionChanged=true;");
			window.Input_longitude.show();
		}

		if (GIWIK.enable_forced_sensor)
		{
			// Paramètre "Always true"
			window.Input_always_true = new Input_checkbox('Input_always_true', true);
			window.Input_always_true.label_width = window.heading_labels_width;
			window.Input_always_true.construct('input_always_true','linear',MSG(['parameters','always_true']),[0,1], true);
			window.Input_always_true.setAction("window.ManPositionChanged=true;");
			window.Input_always_true.show();
		}

		// First time => create manual speed
		if (GIWIK.manualspeed)
		{
			window.Input_ManualSpeed = new Input_int('Input_ManualSpeed', true);
			window.Input_ManualSpeed.label_width = window.heading_labels_width;
			window.Input_ManualSpeed.input_width = 133;
			window.Input_ManualSpeed.construct('input_manualspeed','linear',MSG(['parameters','speed']),0.01,-300,300,MSG(['units','meter_per_second']));
			window.Input_ManualSpeed.setAction("window.ManSpeedChanged=true;", true);
			window.Input_ManualSpeed.show();
		}

		
		// First time => create manual atttitude
		if (GIWIK.manualattitude)
		{
			window.Input_ManualHeading = new Input_int('Input_ManualHeading', true);
			window.Input_ManualHeading.label_width = window.heading_labels_width;
			window.Input_ManualHeading.input_width = 133;
			window.Input_ManualHeading.construct('input_manualheading','linear',MSG(['parameters','heading']),0.01,0,360,MSG(['units','degree']));
			window.Input_ManualHeading.setAction("window.ManAttitudeChanged=true;", true);
			window.Input_ManualHeading.show();

			window.Input_ManualHeading_Sd = new Input_int('Input_ManualHeading_Sd', true);
			window.Input_ManualHeading_Sd.label_width = window.heading_labels_width;
			window.Input_ManualHeading_Sd.input_width = 133;
			window.Input_ManualHeading_Sd.construct('input_manualheading_sd','linear',MSG(['parameters','stddev_label']),0.01,0,90,MSG(['units','degree']));
			window.Input_ManualHeading_Sd.setAction("window.ManAttitudeChanged=true;", true);
			window.Input_ManualHeading_Sd.show();
		}
		
		
		// Init Conf Changed Flags
		window.ManPositionChanged = false;
		window.ManSpeedChanged = false;
		window.ManUpdateChanged = false;

		window.Input_ManPosStatus = new User_msg('Input_ManPosStatus', false);
		window.Input_ManPosStatus.margin = "10px 0 5px 0";
		window.Input_ManPosStatus.construct('input_manposstatus', 0, "");
		window.Input_ManPosStatus.hide();
		
		window.Input_ManAltStatus = new User_msg('Input_ManAltStatus', false);
		window.Input_ManAltStatus.margin = "10px 0 5px 0";
		window.Input_ManAltStatus.construct('input_manaltstatus', 0, "");
		window.Input_ManAltStatus.hide();
	}

	// Values relaoded only after a position sendconf
	if( window.ManPositionChanged!=true )
	{
		if (GIWIK.coordinate_mode === 1/*UTM*/)
		{
			window.Input_northing.setValue(System_state.MANGPSUTM[0]);
			window.Input_easting.setValue(System_state.MANGPSUTM[1]);
			window.Input_zone.setValue(System_state.MANGPSUTM[3]);
			window.Select_stddev.setValue((System_state.MANGPSUTM[4] == 0) ? 10 : System_state.MANGPSUTM[5]);	// 10m par défaut
			if (GIWIK.MANGPSUTM){
				window.Input_always_true.setValue(System_state.MANGPSUTM[7]);
			}
		}
		else
		{
			window.Input_latitude.setValue(System_state.MANGPS[0]);
			window.Input_longitude.setValue(System_state.MANGPS[1]);
			window.Select_stddev.setValue((System_state.MANGPS[3] == 0) ? 10 : System_state.MANGPS[3]);		// 10m par défaut
			if (GIWIK.enable_forced_sensor){
				window.Input_always_true.setValue(System_state.MANGPS[6]);
			}
		}

		if (GIWIK.alti_depth)
		{
			window['Input_'+GIWIK.alti_depth].setValue(GIWIK.alti_depth_sign*System_state.MANGPS[2]);
		}

		// Init Conf Changed Flags
		window.ManPositionChanged = false;
	}

	// Values reloaded when loading page and periodically (except if user is modifying it)
	if (GIWIK.manualspeed)
	{
		if( window.ManSpeedChanged!=true )
		{
			window.Input_ManualSpeed.setValue(eval(System_state.ManualSpeed));

			// Init Conf Changed Flags
			window.ManSpeedChanged = false;
		}
	}

	// Manual Attitude	
	if (GIWIK.manualattitude)
	{
		window.Input_ManualHeading.setValue(eval(System_state.ManualAttitude[0]));
		window.Input_ManualHeading_Sd.setValue(eval(System_state.ManualAttitude[3]));
	}
	
	// Manual Auto Update
	if (GIWIK.manualposition_update)
	{
		if( window.ManUpdateChanged!=true )
		{
			window.Input_ManualData_Update.setValue(eval(System_state.ManualDataUpdate[0]));

			// Init Conf Changed Flags
			window.ManUpdateChanged = false;
		}
	}

	if( !HEADING.init.isdone )
	{
		// Timer: Relecture Entrées Manuelles
		setInterval("HEADING.updateManualInputs();", 5000);
	}

	// Init manualinputs_update_request
	window.manualinputs_update_request = 0;
};

HEADING.getConf.local = function ()
{
	var _params = {};

	_params['MANGPS'] = "";
	_params['MANGPSUTM'] = "";
	
	if (!GIWIK.is_marins)
	{
		_params['MANPOS'] = "";
		_params['MANPOSUTM'] = "";
	}

	if (GIWIK.manualspeed) {
		_params['ManualSpeed'] = "";
	}

	if (GIWIK.manualattitude) {
		_params['ManualAttitude'] = "";
	}
	
	if (GIWIK.manualposition_update) {
		_params['ManualDataUpdate'] = "";
	}

	return _params;
};

HEADING.sendConf.local = function ()
{
	var _params = {};

	// Set a new waypoint
	var wpt_val;

	if (GIWIK.manualposition_update)
	{
		_params['ManualDataUpdate'] = window.Input_ManualData_Update.getValue()+",1";
		window.ManUpdateChanged = false;
	}
	if (GIWIK.manualspeed)
	{
		if (window.ManSpeedChanged)
		{
			_params['ManualSpeed'] = window.Input_ManualSpeed.getValue()
			window.ManSpeedChanged = false;
		}
	}
	if (GIWIK.manualattitude)
	{
		if (window.ManAttitudeChanged)
		{
			_params['ManualAttitude'] = window.Input_ManualHeading.getValue() + ',' + '0.0' + ',' + '0.0' 
										+ ',' + window.Input_ManualHeading_Sd.getValue() + ',' + '0.0' + ',' + '0.0' ;
			window.ManAttitudeChanged = false;
		}
	}
	if (!GIWIK.is_marins && window.Input_remove.getValue() === 1)
	{
		// Delete waypoint
		var i, j;

		// Check for existing label
		for (i=0; i<window.WaypointNb;i++)
		{
			if (window.WaypointLabel[i] == Input_label.getValue())
			{
				if (i != window.WaypointNb-1)
				{
					window.Waypoint[i]=window.Waypoint[window.WaypointNb-1];
					window.WaypointLabel[i]=window.WaypointLabel[window.WaypointNb-1];
					STORAGE.setPermanent("Wpt" + i, window.Waypoint[i]);
				}
				window.WaypointNb--;
				STORAGE.setPermanent("WptNb", window.WaypointNb);
				window.Waypoint.pop();
				window.WaypointLabel.pop();
				window.Input_waypoint_list.setList(array_keys(window.WaypointLabel),window.WaypointLabel);
				window.Input_waypoint_list.setValue(-1);
				window.Input_label.setValue("");
				break;
			}
		}
		window.Input_remove.setValue(0);
	}
	else
	{
		if (window.ManPositionChanged)
		{
			HEADING.waypoint_set = 1;

			var depth = (GIWIK.alti_depth != false) ? GIWIK.alti_depth_sign*window['Input_'+GIWIK.alti_depth].getValue() : "";

			// Only send position if real change (not label rename / delete)
			if (GIWIK.coordinate_mode === 1/*UTM*/)
			{
				if (!GIWIK.is_marins)
				{
					_params['MANPOSUTM'] =
						  window.Input_northing.getValue() + ","
						+ window.Input_easting.getValue() + ","
						+ depth + ","
						+ window.Input_zone.getValue();
				}

				_params['MANGPSUTM'] =
					  window.Input_northing.getValue() + ","
					+ window.Input_easting.getValue() + ","
					+ depth + ","
					+ window.Input_zone.getValue() + ","
					+ window.Select_stddev.getValue() + ","
					+ window.Select_stddev.getValue() + ","
					+ window.Select_stddev.getValue() + ",";

					if (GIWIK.enable_forced_sensor){
						_params['MANGPSUTM'] += window.Input_always_true.getValue();
					}
			}
			else
			{
				if (!GIWIK.is_marins)
				{
					_params['MANPOS'] =
						  window.Input_latitude.getValue() + ","
						+ window.Input_longitude.getValue() + ","
						+ depth;
				}

				_params['MANGPS'] =
					  window.Input_latitude.getValue() + ","
					+ window.Input_longitude.getValue() + ","
					+ depth + ","
					+ window.Select_stddev.getValue() + ","
					+ window.Select_stddev.getValue() + ","
					+ window.Select_stddev.getValue() + ",";

					if (GIWIK.enable_forced_sensor){
						_params['MANGPS'] += window.Input_always_true.getValue();
					}
			}
			window.ManPositionChanged = false;
		}
	}
	return _params;
};

HEADING.construct.local = function ()
{
	if (GIWIK.is_marins)
	{
		// Disable "Save to PROM" automatic command
		GIWIK.save_to_prom_needed = false;
	}

	var cnt = ''
		+'<div id="params_initial_position">'
			+'<table class="params_position">'
				+'<tr>'
					+'<div id="input_manposstatus"></div>'				
					+'<div id="input_manaltstatus"></div>'				
					+'<td class="left">'
						+'<div id="input_manualdata_update"></div>'
						+'<div id="input_latitude"></div>'
						+'<div id="input_longitude"></div>'
						+'<div id="input_northing"></div>'
						+'<div id="input_easting"></div>'
						+'<div id="input_'+GIWIK.alti_depth+'"></div>'
						+'<div id="input_zone"></div>'
						+'<div id="input_stddev"></div>';
						if (!GIWIK.is_marins)
						{
							cnt += '<div id="input_label"></div>'
							+'<div id="input_waypoint_list"></div>'
								+'<div id="input_remove"></div>';
						}
					cnt += '</td>'
					+'<td class="right">'
					    +'<div id="use_system_position" class="displaynone"></div>'
					+'</td>'
				+'</tr>'
			+'</table>'
		+'</div>';

	if (GIWIK.enable_forced_sensor)
	{
		cnt += ''
			+'<div id="params_advanced_mode">'
				+'<table class="params_position">'
					+'<tr>'
						+'<td class="left">'
							+'<div id="input_always_true"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>';
	}

	if (GIWIK.manualspeed)
	{
		cnt += ''
			+'<div id="params_manualspeed">'
				+'<table class="params_position">'
					+'<tr>'
						+'<td align="left">'
							+'<div id="input_manualspeed"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>';
	}

	if (GIWIK.manualattitude)
	{
		cnt += ''
			+'<div id="params_manualattitude">'
				+'<table class="params_position">'
					+'<tr>'
						+'<td align="left">'
							+'<div id="input_manualheading"></div>'
							+'<div id="input_manualheading_sd"></div>'
						+'</td>'
					+'</tr>'
				+'</table>'
			+'</div>';
	}
	
	// Main Labal
	if(GIWIK.manualspeed || GIWIK.manualattitude){
		$('#content').append(GIWIK.box(cnt, MSG(['box','manualfix_title']), true, [], ['', 'box_content_nopaddingtop']));
	}
	else{
		$('#content').append(GIWIK.box(cnt, MSG(['box','positionfix_title']), true, [], ['', 'box_content_nopaddingtop']));
	}

	window.heading_labels_width = 63; 	// Définit la largeur des labels des paramètres de la page
	window.heading_input_width = 140; 	// Définit la largeur des inputs des paramètres de la page

	// Groupes de paramètres
	GIWIK.paramGroup.construct('params_initial_position', MSG(['box','params_initialposition']), 'show');
	if (GIWIK.enable_forced_sensor){GIWIK.paramGroup.construct('params_advanced_mode', MSG(['box','params_advancedmode']), 'show');}
	// Manual Speed
	if (GIWIK.manualspeed) {GIWIK.paramGroup.construct('params_manualspeed', MSG(['box','params_manualspeed']), 'show');}
	// Manual Attitude 
	if(GIWIK.manualattitude) {GIWIK.paramGroup.construct('params_manualattitude', MSG(['box','params_manualattitude']), 'show');}
	
	// Si la fonctionnalité "Waypoints" est disponible
	if (!GIWIK.is_marins)
	{
		window.Waypoint = new Array();
		window.WaypointLabel = new Array();
		window.WaypointNb = STORAGE.get("WptNb", 0);

		for (var i=0; i<window.WaypointNb ;i++)
		{
			var wpt, wpt_ar;

			wpt = STORAGE.get("Wpt" + i, "");
			if (wpt != "")
			{
				wpt_ar = wpt.split(",");
				window.Waypoint[i] = wpt;
				window.WaypointLabel[i] = wpt_ar[0];
			}
		}

		// Paramètre "Waypoint list"
		window.Input_waypoint_list = new Input_select('Input_waypoint_list', true);
		window.Input_waypoint_list.label_width = window.heading_labels_width;
		window.Input_waypoint_list.input_width = window.heading_input_width;
		window.Input_waypoint_list.construct('input_waypoint_list','linear',MSG(['parameters','waypoint_list_label']),array_keys(window.WaypointLabel),window.WaypointLabel,'',true);
		window.Input_waypoint_list.setAction("HEADING.setWaypoint(window.Input_waypoint_list.getValue());", true);
		window.Input_waypoint_list.setValue(-1);
		window.Input_waypoint_list.show();

		// Paramètre "Waypoint label"
		window.Input_label = new Input_text('Input_label', true);
		window.Input_label.label_width = window.heading_labels_width;
		window.Input_label.input_width = window.heading_input_width;
		window.Input_label.text_align = 'left';
		window.Input_label.construct('input_label','linear',MSG(['parameters','waypoint_label']),'');
		window.Input_label.setAction("window.ManPositionChanged=true;");
		window.Input_label.show();

		// Paramètre "Waypoint remove"
		window.Input_remove = new Input_checkbox('Input_remove', true);
		window.Input_remove.label_width = window.heading_labels_width;
		window.Input_remove.construct('input_remove','linear',MSG(['parameters','waypoint_remove']),[0,1],true);
		window.Input_remove.show();
	}

	if (GIWIK.alti_depth)
	{
		// Paramètre "Depth / Altitude"
		window['Input_'+GIWIK.alti_depth] = new Input_int('Input_'+GIWIK.alti_depth, true);
		window['Input_'+GIWIK.alti_depth].label_width = window.heading_labels_width;
		window['Input_'+GIWIK.alti_depth].input_width= window.heading_input_width;
		window['Input_'+GIWIK.alti_depth].construct('input_'+GIWIK.alti_depth,'linear',MSG(['parameters',GIWIK.alti_depth]),0.01,(GIWIK.alti_depth=="depth" ? -GIWIK._max_alt[1] : GIWIK._max_alt[0]),(GIWIK.alti_depth=="depth" ? -GIWIK._max_alt[0] : GIWIK._max_alt[1]),MSG(['units','meter']));
		window['Input_'+GIWIK.alti_depth].setAction("window.ManPositionChanged=true;");
		window['Input_'+GIWIK.alti_depth].show();
	}

	HEADING.std_dev_list = [1000, 100, 10, 1, 0.1];

	// Paramètre "StdDev"
	window.Select_stddev = new Input_select('Select_stddev', true);
	window.Select_stddev.label_width = window.heading_labels_width;
	window.Select_stddev.input_width = window.heading_input_width;
	window.Select_stddev.text_align = 'center';
	window.Select_stddev.low_fontsize = false;
	window.Select_stddev.construct('input_stddev','linear',MSG(['parameters','stddev_label']),HEADING.std_dev_list,HEADING.std_dev_list, MSG(['units','meter']),true);
	window.Select_stddev.setAction("window.ManPositionChanged=true;", true);
	window.Select_stddev[(GIWIK.stddev) ? 'show' : 'hide']();

	window.SetCurrentPosition = new Button('SetCurrentPosition', false);
	window.SetCurrentPosition.margin = "0 5px 0 0";
	window.SetCurrentPosition.construct('use_system_position',MSG(['parameters','waypoint_current']),'small');
	window.SetCurrentPosition.setAction('HEADING.useCurrentPosition();');
	window.SetCurrentPosition.enable();
	window.SetCurrentPosition.show();

	// Paramètre "Always True"
	if (GIWIK.enable_forced_sensor)
	{
		window.Input_always_true = new Input_checkbox('Input_always_true', true);
		window.Input_always_true.label_width = window.heading_labels_width;
		window.Input_always_true.construct('input_always_true','linear',MSG(['parameters','always_true']),[0,1], true);
		window.Input_always_true.enable();
		window.Input_always_true.show();
	}

	// Paramètre Manual Data Update
	if (GIWIK.manualposition_update)
	{
		window.Input_ManualData_Update = new Input_checkbox('Input_ManualData_Update', true);
		window.Input_ManualData_Update.label_width = window.heading_labels_width;
		window.Input_ManualData_Update.construct('input_manualdata_update','linear',MSG(['parameters','manualdata_update']),[0,1], true);
		window.Input_ManualData_Update.setAction("window.ManUpdateChanged=true;");
		window.Input_ManualData_Update.enable();
		window.Input_ManualData_Update.show();
	}

	// Force mode 1 to get current position
	HEADING.data_mode = 1;
	HEADING.waypoint_set = 0;


	// When cancelling: Back to Last Manual Speed
	var cancel_action = "window.ManPositionChanged=false;";
	if (GIWIK.manualspeed) 
	{
		cancel_action += "window.ManSpeedChanged=false;"
	}
	if (GIWIK.manualattitude) 
	{
		cancel_action += "window.ManAttitudeChanged=false;"
	}
	if (GIWIK.manualposition_update) 
	{
		cancel_action += "window.ManUpdateChanged=false;"
	}
	
	// When validating
	var send_action = ""
		+"if (GIWIK.is_marins || GIWIK.is_advans) {window.ManPositionChanged=true;}"
		+"HEADING.waiting_for_position_processing = true;"										// Pour désactivation du bouton OK
		+"HEADING.waiting_for_position_timeout = setTimeout(function () {HEADING.waiting_for_position_processing = false}, 3000);";	// Réactivation auto du bouton au bout de 3s

	return {
		validation_buttons : {
			cancel : {
				action : (cancel_action) ? cancel_action : ""
			},
			send : {
				action : (send_action) ? send_action : ""// ,
				// always_on : true
			}
		}
	};
};

// Gestion spécifique du comportement du bouton OK
GIWIK.validationButtons.display.specific = function ()
{
	if (GIWIK.is_marins || GIWIK.is_advans){
		return {
			// cancel_state:'enable',
			validate_state: (HEADING.waiting_for_position_processing === true) ? 'disable' : 'enable'
		}
	}
};