/*
 * Decompiled with CFR 0.152.
 */
package org.ixsea.datamanager;

import java.applet.Applet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Timer;
import netscape.javascript.JSObject;
import org.ixsea.datamanager.DataManager;
import org.ixsea.datamanager.DataWriter;
import org.ixsea.datamanager.Decoder;
import org.ixsea.datamanager.OctansStandard;
import org.ixsea.datamanager.PhinsStandard;

public class EthReceiver
extends Thread {
    boolean TestMode = false;
    JSObject win;
    BufferedReader input;
    DataInputStream input_bin;
    ServerSocket ServerSocket = null;
    Socket ClientSocket = null;
    DatagramSocket UDPSocket = null;
    DatagramPacket UDPpaquet = null;
    MulticastSocket UDPMultiCastSocket = null;
    DataManager itsDtMngr;
    DataWriter itsDtWrtr;
    String productIP;
    int port;
    Timer xTimer = null;
    Decoder decoder;
    String filename;
    String filenamecurrent;
    int ifileNum = 1;
    int iCreateNewFile = 1;
    long lCurrentLogSize = 0L;
    long lTotalLogSize = 0L;
    int iCurrentLogTime = 0;
    int iTotalLogTime = 0;
    int iDecimationCounter = 0;

    EthReceiver(DataManager d_, String productIP_, String port_, String file_, boolean _TestMode) {
        this.itsDtMngr = d_;
        this.productIP = productIP_;
        this.port = Integer.parseInt(port_);
        this.TestMode = _TestMode;
        System.out.println("IP product : " + this.productIP + " ; " + productIP_ + " / " + this.port);
        this.InitFileName(file_);
        switch (this.itsDtMngr.getMode()) {
            case 0: {
                this.decoder = new OctansStandard();
                break;
            }
            case 1: {
                this.decoder = new PhinsStandard();
                break;
            }
            default: {
                this.decoder = null;
            }
        }
    }

    public void EthReceiver_Stop() {
        this.iCreateNewFile = 0;
    }

    @Override
    public void run() {
        boolean NewFileNeeded = true;
        String temp = "";
        int iNbBytes = 0;
        byte[] cbuf = new byte[10000];
        boolean bEthConnectError = false;
        if (!this.TestMode) {
            this.win = JSObject.getWindow((Applet)this.itsDtMngr);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block5 : switch (EthReceiver.this.itsDtMngr.getProtocole()) {
                    case 0: {
                        try {
                            EthReceiver.this.ClientSocket = new Socket(EthReceiver.this.productIP, EthReceiver.this.port);
                        }
                        catch (IOException e) {
                            System.out.println(e);
                            EthReceiver.this.ClientSocket = null;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            EthReceiver.this.ServerSocket = new ServerSocket(EthReceiver.this.port);
                            EthReceiver.this.ServerSocket.bind(null);
                        }
                        catch (IOException e) {
                            System.out.println(e);
                        }
                        try {
                            while (true) {
                                EthReceiver.this.ClientSocket = EthReceiver.this.ServerSocket.accept();
                                if (EthReceiver.this.ClientSocket.getInetAddress().equals(InetAddress.getByName(EthReceiver.this.productIP))) break block5;
                                EthReceiver.this.ClientSocket.close();
                                EthReceiver.this.ClientSocket = null;
                            }
                        }
                        catch (IOException e) {
                            System.out.println(e);
                            EthReceiver.this.ClientSocket = null;
                            break;
                        }
                    }
                    case 2: 
                    case 3: {
                        try {
                            EthReceiver.this.UDPSocket = new DatagramSocket(EthReceiver.this.port);
                            EthReceiver.this.UDPSocket.bind(null);
                        }
                        catch (Exception e) {
                            System.out.println(e);
                        }
                        break;
                    }
                    case 4: {
                        try {
                            EthReceiver.this.UDPMultiCastSocket = new MulticastSocket(EthReceiver.this.port);
                            System.out.println(EthReceiver.this.itsDtMngr.getIPLog());
                            EthReceiver.this.UDPMultiCastSocket.joinGroup(InetAddress.getByName(EthReceiver.this.itsDtMngr.getIPLog()));
                        }
                        catch (IOException e) {
                            System.out.println(e);
                        }
                        break;
                    }
                    default: {
                        System.out.println("Connexion de Type inconnu " + EthReceiver.this.itsDtMngr.getProtocole());
                    }
                }
                return null;
            }
        });
        if (this.ClientSocket == null && this.UDPSocket == null && this.UDPMultiCastSocket == null) {
            if (this.TestMode) {
                System.out.println("datamanager_error(2301)");
            } else {
                this.win.eval("datamanager_error(2301)");
            }
            this.itsDtMngr.threadEthReceiverStopped();
            return;
        }
        if (this.TestMode) {
            System.out.println("datamanager_connected");
        } else {
            this.win.call("datamanager_connected", null);
        }
        try {
            switch (this.itsDtMngr.getProtocole()) {
                case 0: 
                case 1: {
                    if (this.itsDtMngr.getMode() != 2) {
                        this.input = new BufferedReader(new InputStreamReader(this.ClientSocket.getInputStream()));
                        break;
                    }
                    this.input_bin = new DataInputStream(this.ClientSocket.getInputStream());
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.UDPpaquet = new DatagramPacket(new byte[2048], 2048);
                }
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        this.InitLogSize();
        this.InitLogTime();
        while (this.iCreateNewFile == 1) {
            this.UpdateFileName(this.ifileNum);
            NewFileNeeded = false;
            this.InitCurrentLogSize();
            this.InitCurrentLogTime();
            this.itsDtWrtr = new DataWriter(this.GetCurrentFileName());
            int res = this.itsDtWrtr.FlowOpen();
            if (res < 0) {
                if (res == -1) {
                    if (this.TestMode) {
                        System.out.println("datamanager_error(2302)");
                    } else {
                        this.win.eval("datamanager_error(2302)");
                    }
                }
                if (res == -2) {
                    if (this.TestMode) {
                        System.out.println("datamanager_error(2303)");
                    } else {
                        this.win.eval("datamanager_error(2303)");
                    }
                }
                this.itsDtMngr.threadEthReceiverStopped();
                return;
            }
            if (this.decoder != null) {
                this.decoder.GetHeader(this.itsDtMngr.getSerialNumber(), this.itsDtMngr.getProductName(), this.itsDtMngr.getDecimation());
                this.itsDtWrtr.write(this.decoder.GetHeaderFrame());
            }
            do {
                block50: {
                    try {
                        if (this.itsDtMngr.getProtocole() == 2 || this.itsDtMngr.getProtocole() == 3) {
                            System.out.println("Reception UDP/UDP Broadcast");
                            this.UDPSocket.setSoTimeout(15000);
                            this.UDPSocket.receive(this.UDPpaquet);
                            if (this.UDPpaquet.getLength() == 0) {
                                this.iCreateNewFile = 0;
                            }
                            iNbBytes = 0;
                            System.out.println("IP Paquet " + this.UDPpaquet.getAddress().toString());
                            System.out.println("IP product : " + this.productIP);
                            if (this.UDPpaquet.getAddress().equals(InetAddress.getByName(this.productIP))) {
                                iNbBytes = this.UDPpaquet.getLength();
                                this.itsDtWrtr.write(this.UDPpaquet.getData(), this.UDPpaquet.getLength());
                            }
                            break block50;
                        }
                        if (this.itsDtMngr.getProtocole() == 4) {
                            System.out.println("Reception UDP Multicast");
                            this.UDPMultiCastSocket.setSoTimeout(15000);
                            this.UDPMultiCastSocket.receive(this.UDPpaquet);
                            if (this.UDPpaquet.getLength() == 0) {
                                this.iCreateNewFile = 0;
                            }
                            iNbBytes = 0;
                            System.out.println("IP Paquet " + this.UDPpaquet.getAddress().toString());
                            System.out.println("IP product : " + this.productIP);
                            if (this.UDPpaquet.getAddress().equals(InetAddress.getByName(this.productIP))) {
                                iNbBytes = this.UDPpaquet.getLength();
                                this.itsDtWrtr.write(this.UDPpaquet.getData(), this.UDPpaquet.getLength());
                            }
                            break block50;
                        }
                        if (this.itsDtMngr.getMode() != 2) {
                            try {
                                temp = this.input.readLine();
                                if (temp == null) {
                                    this.iCreateNewFile = 0;
                                    break;
                                }
                                iNbBytes = 0;
                                if (this.decoder.Decode(temp) != 0) break block50;
                                ++this.iDecimationCounter;
                                if (this.iDecimationCounter < this.itsDtMngr.getDecimation()) break block50;
                                this.iDecimationCounter = 0;
                                this.itsDtWrtr.write(this.decoder.GetDecodedFrame());
                                iNbBytes = this.decoder.GetDecodedFrame().length();
                                break block50;
                            }
                            catch (IOException e) {
                                if (this.TestMode) {
                                    System.out.println("datamanager_disconnected");
                                } else {
                                    this.win.call("datamanager_disconnected", null);
                                }
                                this.iCreateNewFile = 0;
                                break;
                            }
                        }
                        try {
                            iNbBytes = this.input_bin.read(cbuf);
                            if (iNbBytes == -1) {
                                this.iCreateNewFile = 0;
                                break;
                            }
                            this.itsDtWrtr.write(cbuf, iNbBytes);
                            break block50;
                        }
                        catch (IOException e) {
                            if (this.TestMode) {
                                System.out.println("datamanager_disconnected");
                            } else {
                                this.win.call("datamanager_disconnected", null);
                            }
                            this.iCreateNewFile = 0;
                        }
                    }
                    catch (SocketTimeoutException ste) {
                        if (this.TestMode) {
                            System.out.println("datamanager_error(2304)");
                        } else {
                            this.win.eval("datamanager_error(2304)");
                        }
                        bEthConnectError = true;
                        System.out.println("In EthReceiver.java line 462 - Error type:" + ste);
                        this.iCreateNewFile = 0;
                    }
                    catch (IOException e) {
                        System.out.println(e);
                        this.iCreateNewFile = 0;
                    }
                    break;
                }
                this.UpdateLogSize(iNbBytes);
                if (!this.CreateNewFile()) continue;
                NewFileNeeded = true;
                break;
            } while (this.iCreateNewFile != 0);
            if (NewFileNeeded) {
                this.itsDtWrtr.FlowClose();
                this.itsDtWrtr = null;
            }
            ++this.ifileNum;
        }
        if (this.itsDtWrtr != null) {
            this.itsDtWrtr.FlowClose();
            this.itsDtWrtr = null;
        }
        if (!bEthConnectError) {
            if (this.TestMode) {
                System.out.println("datamanager_disconnected");
            } else {
                this.win.call("datamanager_disconnected", null);
            }
        }
        this.itsDtMngr.threadEthReceiverStopped();
    }

    public void exit() {
        if (this.ClientSocket != null) {
            try {
                this.ClientSocket.close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        if (this.ServerSocket != null) {
            try {
                this.ServerSocket.close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        if (this.UDPSocket != null) {
            try {
                this.UDPSocket.close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        if (this.UDPMultiCastSocket != null) {
            try {
                this.UDPMultiCastSocket.leaveGroup(InetAddress.getByName(this.itsDtMngr.getIPLog()));
                this.UDPMultiCastSocket.close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        if (this.itsDtWrtr != null) {
            this.itsDtWrtr.FlowClose();
        }
    }

    private boolean CreateNewFile() {
        if (this.itsDtMngr.getTimeMax() > 0 && this.GetCurrentLogTime() > this.itsDtMngr.getTimeMax()) {
            return true;
        }
        return this.itsDtMngr.getSizeMax() > 0L && this.GetCurrentLogSize() > this.itsDtMngr.getSizeMax();
    }

    private void InitFileName(String filename) {
        this.filename = filename;
    }

    private void UpdateFileName(int filenumber) {
        if (this.itsDtMngr.getSizeMax() == 0L && this.itsDtMngr.getTimeMax() == 0) {
            this.filenamecurrent = this.filename;
        } else if (this.filename.contains(".log")) {
            this.filenamecurrent = this.filename.replace(".log", "_" + filenumber + ".log");
        } else if (this.filename.contains(".txt")) {
            this.filenamecurrent = this.filename.replace(".txt", "_" + filenumber + ".txt");
        }
    }

    public String GetCurrentFileName() {
        return this.filenamecurrent;
    }

    public int GetFileNumber() {
        if (this.itsDtMngr.getSizeMax() == 0L && this.itsDtMngr.getTimeMax() == 0) {
            return 1;
        }
        return this.ifileNum;
    }

    private void UpdateLogSize(long Lenght) {
        this.lCurrentLogSize += Lenght;
        this.lTotalLogSize += Lenght;
    }

    private void InitLogSize() {
        this.lCurrentLogSize = 0L;
        this.lTotalLogSize = 0L;
    }

    private void InitCurrentLogSize() {
        this.lCurrentLogSize = 0L;
    }

    public long GetCurrentLogSize() {
        return this.lCurrentLogSize;
    }

    public long GetCurrentLogSizeinko() {
        return this.lCurrentLogSize / 1024L;
    }

    public long GetTotalLogSize() {
        return this.lTotalLogSize;
    }

    public long GetTotalLogSizeinko() {
        return this.lTotalLogSize / 1024L;
    }

    private void UpdateLogTime(int Time) {
        this.iCurrentLogTime += Time;
        this.iTotalLogTime += Time;
    }

    private void InitLogTime() {
        this.iCurrentLogTime = 0;
        this.iTotalLogTime = 0;
        this.xTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EthReceiver.this.UpdateLogTime(1);
            }
        });
        this.xTimer.start();
    }

    private void InitCurrentLogTime() {
        this.iCurrentLogTime = 0;
    }

    public int GetCurrentLogTime() {
        return this.iCurrentLogTime;
    }

    public int GetTotalLogTime() {
        return this.iTotalLogTime;
    }
}

