/*
 * Decompiled with CFR 0.152.
 */
package org.ixsea.datamanager;

import java.util.Date;
import org.ixsea.datamanager.Decoder;

public class OctansStandard
extends Decoder {
    Object[][] tab_header = new Object[][]{{new Integer(15), "Octans4 - HH:MM:SS.SSS"}, {new Integer(0), "Heading (deg)"}, {new Integer(3), "Roll (deg)"}, {new Integer(1), "Pitch (deg)"}, {new Integer(5), "Heave (m)"}, {new Integer(6), "Surge (m)"}, {new Integer(7), "Sway (m)"}, {new Integer(11), "Latitude (deg)"}, {new Integer(13), "Speed (knots)"}, {new Integer(14), "User Status"}, {new Integer(28), "High level Status"}, {new Integer(22), "System Status 1"}, {new Integer(23), "System Status 2"}, {new Integer(24), "Algorithm Status 1"}, {new Integer(25), "Algorithm Status 2"}, {new Integer(26), "Sensor Status 1"}, {new Integer(27), "Sensor Status 2"}};

    public OctansStandard() {
        this.Init(29);
    }

    @Override
    public void GetHeader(String sSerialNum, String sProductName, int iDecimation) {
        Date DateCourante = new Date();
        Integer iSamplePeriod = 200 * iDecimation;
        this.Header_Frame = "";
        this.Header_Frame = this.Header_Frame.concat("Serial number " + sProductName + " :\t" + sSerialNum + "\r\n");
        this.Header_Frame = this.Header_Frame.concat("Created the   :\t" + this.Formatjour.format(DateCourante) + "\t\tTime :\t" + this.Formatheure.format(DateCourante) + "\r\n");
        this.Header_Frame = this.Header_Frame.concat("Sample period :\t" + iSamplePeriod.toString() + "ms" + "\r\n");
        this.Header_Frame = this.Header_Frame.concat("Pc - HH:MM:SS.SSS\t");
        for (int i = 0; i < this.tab_header.length; ++i) {
            this.Header_Frame = this.Header_Frame.concat((String)this.tab_header[i][1]);
            if (i == this.tab_header.length - 1) continue;
            this.Header_Frame = this.Header_Frame.concat("\t");
        }
    }

    @Override
    public int Decode(String s) {
        int ret = -1;
        String sVal = s.substring(7, s.length() - 3);
        if (s.regionMatches(0, "$HEHDT,", 0, 7) && !this.HETHS_Detected) {
            sVal = this.a_headingNewValue;
            this.a_headingNewValue = s.substring(7, s.length() - 3);
            this.do_line(sVal, 1, "0", "0");
            return this.do_final();
        }
        if (s.regionMatches(0, "$HETHS,", 0, 7)) {
            this.HETHS_Detected = true;
            sVal = this.a_headingNewValue;
            this.a_headingNewValue = s.substring(7, s.length() - 3);
            this.do_line(sVal, 1, "0", "0");
            return this.do_final();
        }
        if (s.regionMatches(0, "$PHTRO,", 0, 7)) {
            this.do_line(sVal, 4, "0,1,2,3", "1,2,3,4");
        } else if (s.regionMatches(0, "$PHLIN,", 0, 7)) {
            this.do_line(sVal, 3, "0,1,2", "6,7,5");
        } else if (s.regionMatches(0, "$PHSPD,", 0, 7)) {
            this.do_line(sVal, 3, "0,1,2", "8,9,10");
        } else if (s.regionMatches(0, "$PHCMP,", 0, 7)) {
            this.do_line(sVal, 3, "0,1,2", "11,12,13");
        } else if (s.regionMatches(0, "$PHINF,", 0, 7)) {
            this.do_line(sVal, 1, "0", "14");
        } else if (s.regionMatches(0, "$TIME_,", 0, 7)) {
            this.do_line(sVal, 1, "0", "15");
        } else if (s.regionMatches(0, "$PHZDA,", 0, 7)) {
            this.do_line(sVal, 6, "0,1,2,3,4,5", "16,17,18,19,20,21");
        } else if (s.regionMatches(0, "$STSYS,", 0, 7)) {
            this.do_line(sVal, 2, "0,1", "22,23");
        } else if (s.regionMatches(0, "$STALG,", 0, 7)) {
            this.do_line(sVal, 2, "0,1", "24,25");
        } else if (s.regionMatches(0, "$STSOR,", 0, 7)) {
            this.do_line(sVal, 2, "0,1", "26,27");
        } else if (s.regionMatches(0, "$ST_HL,", 0, 7)) {
            this.do_line(sVal, 1, "0", "28");
        }
        return ret;
    }

    private void do_line(String s, int iNbParam, String siInLine, String siInVal) {
        String[] tab_siInLine = siInLine.split(",");
        String[] tab_siInVal = siInVal.split(",");
        String[] sTmp = s.split(",", Integer.parseInt(tab_siInLine[iNbParam - 1] + 2));
        for (int i = 0; i < iNbParam; ++i) {
            this.tab_sVal[Integer.parseInt((String)tab_siInVal[i])] = sTmp[Integer.parseInt(tab_siInLine[i])];
            this.tab_iValid[Integer.parseInt((String)tab_siInVal[i])] = 1;
        }
    }

    private int do_final() {
        int ret = -1;
        ++this.RepeaterBlockCount;
        if (this.RepeaterBlockCount > 5) {
            Date DateCourante = new Date();
            this.Decoded_Frame = "";
            this.Decoded_Frame = this.Decoded_Frame.concat(this.Formatheure.format(DateCourante) + "\t");
            if (this.tab_sVal[2].startsWith("M")) {
                this.tab_sVal[1] = Float.toString(-Float.parseFloat(this.tab_sVal[1]));
            }
            if (this.tab_sVal[4].startsWith("B")) {
                this.tab_sVal[3] = Float.toString(-Float.parseFloat(this.tab_sVal[3]));
            }
            int iLatitude = Integer.parseInt(this.tab_sVal[11].substring(0, 2));
            float fLatitude = Float.parseFloat(this.tab_sVal[11].substring(2));
            fLatitude = (float)((double)fLatitude / 60.0 + (double)iLatitude);
            if (this.tab_sVal[12].startsWith("S")) {
                fLatitude = -fLatitude;
            }
            this.tab_sVal[11] = Float.toString(fLatitude);
            this.tab_sVal[15] = this.tab_sVal[15].substring(0, 2) + ":" + this.tab_sVal[15].substring(2, 4) + ":" + this.tab_sVal[15].substring(4);
            for (int i = 0; i < this.tab_header.length; ++i) {
                this.Decoded_Frame = this.Decoded_Frame.concat(this.tab_sVal[(Integer)this.tab_header[i][0]]);
                if (i == this.tab_header.length - 1) continue;
                this.Decoded_Frame = this.Decoded_Frame.concat("\t");
            }
            ret = 0;
        }
        return ret;
    }
}

