/*
 * Decompiled with CFR 0.152.
 */
package org.ixsea.datamanager;

import java.util.Date;
import org.ixsea.datamanager.Decoder;

public class PhinsStandard
extends Decoder {
    long logging_mask;
    static final long TIME = 1L;
    static final long HRP = 2L;
    static final long POSITION = 4L;
    static final long ALTITUDE = 8L;
    static final long SPEED = 16L;
    static final long HEAVE = 32L;
    static final long STDDEV = 64L;
    static final long CURRENT = 128L;
    static final long STATUS = 256L;
    static final long CALIBRATION = 512L;
    static final long DVL = 1024L;
    static final long EMLOG1 = 2048L;
    static final long EMLOG2 = 4096L;
    static final long GPS1 = 8192L;
    static final long GPS2 = 16384L;
    static final long GPSM = 32768L;
    static final long LBL = 65536L;
    static final long USBL = 131072L;
    static final long DMI = 262144L;
    static final long DEPTH = 524288L;
    static final long ALG_ST3 = 0x100000L;
    static final long BIAS = 0x200000L;

    public PhinsStandard() {
        this.Init(fieldInfos.values().length);
    }

    void SetLoggingMask(String sProductName) {
        this.logging_mask = 2138391L;
        if (sProductName.compareTo("PHINS") == 0 || sProductName.compareTo("PHINS 6000") == 0) {
            this.logging_mask |= 0xE8L;
            this.logging_mask |= 0xB5E00L;
        } else if (sProductName.compareTo("ROVINS") == 0) {
            this.logging_mask |= 0xE8L;
            this.logging_mask |= 0xB4600L;
        } else if (sProductName.compareTo("QUADRANS") == 0) {
            this.logging_mask |= 0x20L;
            this.logging_mask |= 0x800L;
        } else if (sProductName.compareTo("HYDRINS") == 0) {
            this.logging_mask |= 0x68L;
            this.logging_mask |= 0x4000L;
        } else if (sProductName.compareTo("MARINS") == 0) {
            this.logging_mask |= 0xE8L;
            this.logging_mask |= 0x85E00L;
        } else if (sProductName.contains("MARINS") && sProductName.contains("EXPORT")) {
            this.logging_mask |= 0xE8L;
            this.logging_mask |= 0x84800L;
        } else if (sProductName.contains("MARINS") && (sProductName.contains("BKB") || sProductName.contains("BK-B"))) {
            this.logging_mask |= 0xE8L;
            this.logging_mask |= 0x85800L;
        } else {
            this.logging_mask = sProductName.compareTo("AIRINS") == 0 ? (this.logging_mask |= 0x48L) : (sProductName.compareTo("LANDINS") == 0 || sProductName.compareTo("LANDINS_NG") == 0 || sProductName.compareTo("ATLANS") == 0 || sProductName.compareTo("ADVANS") == 0 ? (this.logging_mask |= 0x140248L) : -1L);
        }
    }

    @Override
    public void GetHeader(String sSerialNum, String sProductName, int iDecimation) {
        Integer iSamplePeriod = 200 * iDecimation;
        Date DateCourante = new Date();
        this.sProductName = this.sProductName.concat(sProductName);
        this.Header_Frame = "";
        this.Header_Frame = this.Header_Frame.concat("Serial number " + sProductName + " :\t" + sSerialNum + "\r\n");
        this.Header_Frame = this.Header_Frame.concat("Created the   :\t" + this.Formatjour.format(DateCourante) + "\t\tTime :\t" + this.Formatheure.format(DateCourante) + "\r\n");
        this.Header_Frame = this.Header_Frame.concat("Sample period :\t" + iSamplePeriod.toString() + " ms" + "\r\n");
        this.SetLoggingMask(sProductName);
        this.Header_Frame = this.Header_Frame.concat("Pc - HH:MM:SS.SSS\t");
        for (fieldInfos f : fieldInfos.values()) {
            boolean bVertSpeedQuadrans;
            long field_mask = f.field_mask;
            boolean bl = bVertSpeedQuadrans = f.toString().equals("E_VERT_SPEED") && sProductName.compareTo("QUADRANS") == 0;
            if ((field_mask &= this.logging_mask) != f.field_mask && !bVertSpeedQuadrans) continue;
            this.Header_Frame = this.Header_Frame.concat(f.a_Name);
            this.Header_Frame = this.Header_Frame.concat("\t");
        }
    }

    @Override
    public int Decode(String s) {
        if (s.regionMatches(0, "$HEHDT,", 0, 5) && !this.HETHS_Detected) {
            String sVal = this.a_headingNewValue;
            this.a_headingNewValue = s.substring(7, s.length() - 3);
            this.do_line(sVal, 1, "0", fieldInfos.E_HEADING);
            return this.do_final();
        }
        if (s.regionMatches(0, "$HEHDT,", 0, 5) && this.HETHS_Detected) {
            return -1;
        }
        if (s.regionMatches(0, "$HETHS,", 0, 5)) {
            this.HETHS_Detected = true;
            String sVal = this.a_headingNewValue;
            this.a_headingNewValue = s.substring(7, s.length() - 3);
            this.do_line(sVal, 1, "0", fieldInfos.E_HEADING);
            return this.do_final();
        }
        String sVal = s.substring(14, s.length() - 3);
        if (s.regionMatches(7, "ATITUD,", 0, 5)) {
            this.do_line(sVal, 2, "0,1", fieldInfos.E_ROLL, fieldInfos.E_PITCH);
        } else if (s.regionMatches(7, "POSITI,", 0, 5)) {
            this.do_line(sVal, 3, "0,1,2", fieldInfos.E_LATITUDE, fieldInfos.E_LONGITUDE, fieldInfos.E_ALTITUDE);
        } else if (s.regionMatches(7, "SPEED_,", 0, 5)) {
            this.do_line(sVal, 3, "0,1,2", fieldInfos.E_EAST_SPEED, fieldInfos.E_NORTH_SPEED, fieldInfos.E_VERT_SPEED);
        } else if (s.regionMatches(7, "UTMWGS,", 0, 5)) {
            this.do_line(sVal, 5, "0,1,2,3,4", fieldInfos.E_ZONE_C, fieldInfos.E_ZONE_I, fieldInfos.E_UTM_EAST, fieldInfos.E_UTM_NORTH, fieldInfos.E_UTM_ALTITUDE);
        } else if (s.regionMatches(7, "HEAVE_,", 0, 5)) {
            this.do_line(sVal, 3, "0,1,2", fieldInfos.E_SURGE, fieldInfos.E_SWAY, fieldInfos.E_HEAVE);
        } else if (s.regionMatches(7, "STDHRP,", 0, 5)) {
            this.do_line(sVal, 3, "0,1,2", fieldInfos.E_HEADING_STD, fieldInfos.E_ROLL_STD, fieldInfos.E_PITCH_STD);
        } else if (s.regionMatches(7, "STDPOS,", 0, 5)) {
            this.do_line(sVal, 3, "0,1,2", fieldInfos.E_LATITUDE_STD, fieldInfos.E_LONGITUDE_STD, fieldInfos.E_ALTITUDE_STD);
        } else if (s.regionMatches(7, "STDSPD,", 0, 5)) {
            this.do_line(sVal, 3, "0,1,2", fieldInfos.E_NORTH_SPEED_STD, fieldInfos.E_EAST_SPEED_STD, fieldInfos.E_VERT_SPEED_STD);
        } else if (s.regionMatches(7, "TIME__,", 0, 5)) {
            this.do_line(sVal, 1, "0", fieldInfos.E_SYSTEM);
        } else if (s.regionMatches(7, "STATUS,", 0, 5)) {
            this.do_line(sVal, 2, "0,1", fieldInfos.E_SYSTEM_STATUS_1, fieldInfos.E_SYSTEM_STATUS_2);
        } else if (s.regionMatches(7, "ALGSTS,", 0, 5)) {
            this.do_line(sVal, 2, "0,1,2", fieldInfos.E_ALGO_STATUS_1, fieldInfos.E_ALGO_STATUS_2, fieldInfos.E_ALGO_STATUS_3);
        } else if (s.regionMatches(7, "SORSTS,", 0, 5)) {
            this.do_line(sVal, 2, "0,1", fieldInfos.E_SENSOR_STATUS_1, fieldInfos.E_SENSOR_STATUS_2);
        } else if (s.regionMatches(7, "DDRECK,", 0, 5)) {
            this.do_line(sVal, 3, "3,4,5", fieldInfos.E_CALIBRATION_HEAD, fieldInfos.E_CALIBRATION_SCALE_F, fieldInfos.E_CALIBRATION_PITCH);
        } else if (s.regionMatches(7, "ODRECK,", 0, 5)) {
            this.do_line(sVal, 3, "3,4,5", fieldInfos.E_CALIBRATION_HEAD, fieldInfos.E_CALIBRATION_SCALE_F, fieldInfos.E_CALIBRATION_PITCH);
        } else if (s.regionMatches(7, "HT_STS,", 0, 5)) {
            this.do_line(sVal, 1, "0", fieldInfos.E_HIGH_LEVEL_STATUS);
        } else if (s.regionMatches(7, "CALCHK,", 0, 5)) {
            this.do_line(sVal, 3, "0,1,2", fieldInfos.E_CALIBRATION_CHECK_DIST, fieldInfos.E_CALIBRATION_CHECK_VERR, fieldInfos.E_CALIBRATION_CHECK_HERR);
        } else if (s.regionMatches(7, "GPSIN_,", 0, 5)) {
            this.do_line(sVal, 5, "0,1,2,3,4", fieldInfos.E_GPS_LAT, fieldInfos.E_GPS_LONG, fieldInfos.E_GPS_ALT, fieldInfos.E_GPS_TIME, fieldInfos.E_GPS_MODE);
        } else if (s.regionMatches(7, "GP2IN_,", 0, 5)) {
            this.do_line(sVal, 5, "0,1,2,3,4", fieldInfos.E_GPS_LAT2, fieldInfos.E_GPS_LONG2, fieldInfos.E_GPS_ALT2, fieldInfos.E_GPS_TIME2, fieldInfos.E_GPS_MODE2);
        } else if (s.regionMatches(7, "LOGIN_,", 0, 5)) {
            this.do_line(sVal, 4, "0,1,2,4", fieldInfos.E_DVL_BOTTOM_SPEED_X, fieldInfos.E_DVL_BOTTOM_SPEED_Y, fieldInfos.E_DVL_BOTTOM_SPEED_Z, fieldInfos.E_DVL_TIME);
        } else if (s.regionMatches(7, "ODOIN_,", 0, 5)) {
            this.do_line(sVal, 2, "0,4", fieldInfos.E_DMI_PULSE, fieldInfos.E_DMI_TIME);
        } else if (s.regionMatches(7, "LOGWAT,", 0, 5)) {
            this.do_line(sVal, 7, "0,1,2,3,4,5,6", fieldInfos.E_DVL_WATER_SPEED_X, fieldInfos.E_DVL_WATER_SPEED_Y, fieldInfos.E_DVL_WATER_SPEED_Z, fieldInfos.E_NORTH_CURRENT, fieldInfos.E_EAST_CURRENT, fieldInfos.E_NORTH_CURRENT_STD, fieldInfos.E_EAST_CURRENT_STD);
        } else if (s.regionMatches(7, "LOGDVL,", 0, 5)) {
            this.do_line(sVal, 3, "0,1,2", fieldInfos.E_DVL_SOUND_SPEED, fieldInfos.E_SOUND_SPEED, fieldInfos.E_DVL_TIME);
        } else if (s.regionMatches(7, "DEPIN_,", 0, 5)) {
            this.do_line(sVal, 2, "0,1", fieldInfos.E_DEPTH, fieldInfos.E_DEPTH_TIME);
        } else if (s.regionMatches(7, "LMNIN_,", 0, 5)) {
            this.do_line(sVal, 6, "0,1,2,3,4,5", fieldInfos.E_LOCH_SPEED, fieldInfos.E_NORTH_CURRENT, fieldInfos.E_EAST_CURRENT, fieldInfos.E_NORTH_CURRENT_STD, fieldInfos.E_EAST_CURRENT_STD, fieldInfos.E_LOCH_TIME);
        } else if (s.regionMatches(7, "USBIN_,", 0, 5)) {
            this.do_line(sVal, 7, "0,1,2,3,4,5,6", fieldInfos.E_USBL_LAT, fieldInfos.E_USBL_LONG, fieldInfos.E_USBL_ALT, fieldInfos.E_USBL_DELAY, fieldInfos.E_USBL_TIME, fieldInfos.E_USBL_ID, fieldInfos.E_USBL_CODE);
        } else if (s.regionMatches(7, "LBLIN_,", 0, 5)) {
            this.do_line(sVal, 6, "0,1,2,3,4,5", fieldInfos.E_LBL_LAT, fieldInfos.E_LBL_LONG, fieldInfos.E_LBL_ALT, fieldInfos.E_LBL_ID, fieldInfos.E_LBL_RANGE, fieldInfos.E_LBL_TIME);
        } else if (s.regionMatches(7, "GPMIN_,", 0, 5)) {
            this.do_line(sVal, 3, "0,1,2", fieldInfos.E_MGPS_LAT, fieldInfos.E_MGPS_LONG, fieldInfos.E_MGPS_ALT);
        } else if (s.regionMatches(7, "FOGEST,", 0, 5)) {
            this.do_line(sVal, 3, "0,1,2", fieldInfos.E_FOGX_BIAS, fieldInfos.E_FOGY_BIAS, fieldInfos.E_FOGZ_BIAS);
        } else if (s.regionMatches(7, "ACCEST,", 0, 5)) {
            this.do_line(sVal, 3, "0,1,2", fieldInfos.E_ACCX_BIAS, fieldInfos.E_ACCY_BIAS, fieldInfos.E_ACCZ_BIAS);
        }
        return -1;
    }

    private void do_line(String s, int iNbParam, String siInLine, fieldInfos ... vals) {
        String[] tab_siInLine = siInLine.split(",");
        String[] sTmp = s.split(",", Integer.parseInt(tab_siInLine[iNbParam - 1] + 2));
        for (int i = 0; i < iNbParam; ++i) {
            this.tab_sVal[vals[i].ordinal()] = sTmp[Integer.parseInt(tab_siInLine[i])];
            this.tab_iValid[vals[i].ordinal()] = 1;
        }
    }

    private int do_final() {
        int ret = -1;
        ++this.RepeaterBlockCount;
        if (this.RepeaterBlockCount > 2) {
            Date DateCourante = new Date();
            this.Decoded_Frame = "";
            this.Decoded_Frame = this.Decoded_Frame.concat(this.Formatheure.format(DateCourante) + "\t");
            double speed_north = Double.parseDouble(this.tab_sVal[fieldInfos.E_NORTH_SPEED.ordinal()]);
            double speed_east = Double.parseDouble(this.tab_sVal[fieldInfos.E_EAST_SPEED.ordinal()]);
            double speed_norm = speed_north * speed_north + speed_east * speed_east;
            speed_norm = Math.sqrt(speed_norm);
            speed_norm *= 1000.0;
            speed_norm = Math.round(speed_norm);
            this.tab_sVal[fieldInfos.E_NORM_SPEED.ordinal()] = Double.toString(speed_norm /= 1000.0);
            if (this.tab_iValid[fieldInfos.E_CALIBRATION_SCALE_F.ordinal()] == 1) {
                double dvl_scale_factor = Double.parseDouble(this.tab_sVal[fieldInfos.E_CALIBRATION_SCALE_F.ordinal()]);
                this.tab_sVal[fieldInfos.E_CALIBRATION_SCALE_F.ordinal()] = Double.toString(dvl_scale_factor *= 100.0);
            }
            this.tab_sVal[fieldInfos.E_SYSTEM.ordinal()] = this.parseTime(this.tab_sVal[fieldInfos.E_SYSTEM.ordinal()]);
            if (this.tab_iValid[fieldInfos.E_GPS_TIME.ordinal()] == 1) {
                this.tab_sVal[fieldInfos.E_GPS_TIME.ordinal()] = this.parseTime(this.tab_sVal[fieldInfos.E_GPS_TIME.ordinal()]);
            }
            if (this.tab_iValid[fieldInfos.E_GPS_TIME2.ordinal()] == 1) {
                this.tab_sVal[fieldInfos.E_GPS_TIME2.ordinal()] = this.parseTime(this.tab_sVal[fieldInfos.E_GPS_TIME2.ordinal()]);
            }
            if (this.tab_iValid[fieldInfos.E_DVL_TIME.ordinal()] == 1) {
                this.tab_sVal[fieldInfos.E_DVL_TIME.ordinal()] = this.parseTime(this.tab_sVal[fieldInfos.E_DVL_TIME.ordinal()]);
            }
            if (this.tab_iValid[fieldInfos.E_DEPTH_TIME.ordinal()] == 1) {
                this.tab_sVal[fieldInfos.E_DEPTH_TIME.ordinal()] = this.parseTime(this.tab_sVal[fieldInfos.E_DEPTH_TIME.ordinal()]);
            }
            if (this.tab_iValid[fieldInfos.E_LOCH_TIME.ordinal()] == 1) {
                this.tab_sVal[fieldInfos.E_LOCH_TIME.ordinal()] = this.parseTime(this.tab_sVal[fieldInfos.E_LOCH_TIME.ordinal()]);
            }
            if (this.tab_iValid[fieldInfos.E_USBL_TIME.ordinal()] == 1) {
                this.tab_sVal[fieldInfos.E_USBL_TIME.ordinal()] = this.parseTime(this.tab_sVal[fieldInfos.E_USBL_TIME.ordinal()]);
            }
            if (this.tab_iValid[fieldInfos.E_LBL_TIME.ordinal()] == 1) {
                this.tab_sVal[fieldInfos.E_LBL_TIME.ordinal()] = this.parseTime(this.tab_sVal[fieldInfos.E_LBL_TIME.ordinal()]);
            }
            if (this.tab_iValid[fieldInfos.E_DMI_TIME.ordinal()] == 1) {
                this.tab_sVal[fieldInfos.E_DMI_TIME.ordinal()] = this.parseTime(this.tab_sVal[fieldInfos.E_DMI_TIME.ordinal()]);
            }
            for (fieldInfos f : fieldInfos.values()) {
                boolean bVertSpeedQuadrans;
                long field_mask = f.field_mask;
                boolean bl = bVertSpeedQuadrans = f.toString().equals("E_VERT_SPEED") && this.sProductName.compareTo("QUADRANS") == 0;
                if ((field_mask &= this.logging_mask) == f.field_mask || bVertSpeedQuadrans) {
                    this.Decoded_Frame = this.Decoded_Frame.concat(this.tab_sVal[f.ordinal()]);
                    this.Decoded_Frame = this.Decoded_Frame.concat("\t");
                }
                this.tab_iValid[f.ordinal()] = 0;
            }
            ret = 0;
        }
        return ret;
    }

    private String parseTime(String sIn) {
        String sResult = "";
        try {
            sResult = sIn.substring(0, 2) + ":" + sIn.substring(2, 4) + ":" + sIn.substring(4);
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println(e);
        }
        return sResult;
    }

    public static enum fieldInfos {
        E_SYSTEM("System - HH:MM:SS.SSS", 1L),
        E_HEADING("Heading (deg)", 2L),
        E_ROLL("Roll (deg)", 2L),
        E_PITCH("Pitch (deg)", 2L),
        E_HEADING_STD("Heading std. dev. (deg)", 64L),
        E_ROLL_STD("Roll std. dev. (deg)", 64L),
        E_PITCH_STD("Pitch std. dev. (deg)", 64L),
        E_NORTH_SPEED("North speed (m/s)", 16L),
        E_EAST_SPEED("East speed (m/s)", 16L),
        E_VERT_SPEED("Vert. speed (m/s)", 24L),
        E_NORM_SPEED("Speed norm (m/s)", 16L),
        E_NORTH_SPEED_STD("North speed std. dev. (m/s)", 80L),
        E_EAST_SPEED_STD("East speed std. dev. (m/s)", 80L),
        E_VERT_SPEED_STD("Vert. speed std. dev. (m/s)", 88L),
        E_LATITUDE("Latitude (deg)", 4L),
        E_LONGITUDE("Longitude (deg)", 4L),
        E_ALTITUDE("Altitude (m)", 8L),
        E_LATITUDE_STD("Latitude std. dev. (m)", 68L),
        E_LONGITUDE_STD("Longitude std. dev. (m)", 68L),
        E_ALTITUDE_STD("Altitude std. dev. (m)", 72L),
        E_ZONE_I("Zone I", 4L),
        E_ZONE_C("Zone C", 4L),
        E_UTM_NORTH("UTM North (m)", 4L),
        E_UTM_EAST("UTM East (m)", 4L),
        E_UTM_ALTITUDE("UTM altitude  (m)", 8L),
        E_NORTH_CURRENT("North current (m/s)", 128L),
        E_EAST_CURRENT("East current (m/s)", 128L),
        E_NORTH_CURRENT_STD("North current std. dev. (m/s)", 192L),
        E_EAST_CURRENT_STD("East current std. dev. (m/s)", 192L),
        E_HEAVE("Heave (m)", 32L),
        E_SURGE("Surge (m)", 32L),
        E_SWAY("Sway (m)", 32L),
        E_HIGH_LEVEL_STATUS("High level status", 256L),
        E_SYSTEM_STATUS_1("System status 1", 256L),
        E_SYSTEM_STATUS_2("System status 2", 256L),
        E_ALGO_STATUS_1("Algo status 1", 256L),
        E_ALGO_STATUS_2("Algo status 2", 256L),
        E_ALGO_STATUS_3("Algo status 3", 0x100000L),
        E_SENSOR_STATUS_1("Sensor status 1", 256L),
        E_SENSOR_STATUS_2("Sensor status 2", 256L),
        E_GPS_LAT("GPS - Latitude (deg)", 8192L),
        E_GPS_LONG("GPS - Longitude (deg)", 8192L),
        E_GPS_ALT("GPS - Altitude (m)", 8192L),
        E_GPS_MODE("GPS - Mode", 8192L),
        E_GPS_TIME("GPS - Time", 8192L),
        E_GPS_LAT2("GPS2 - Latitude (deg)", 16384L),
        E_GPS_LONG2("GPS2 - Longitude (deg)", 16384L),
        E_GPS_ALT2("GPS2 - Altitude (m)", 16384L),
        E_GPS_MODE2("GPS2 - Mode", 16384L),
        E_GPS_TIME2("GPS2 - Time", 16384L),
        E_DVL_BOTTOM_SPEED_X("DVL - Bottom speedX (m/s)", 1024L),
        E_DVL_BOTTOM_SPEED_Y("DVL - Bottom speedY (m/s)", 1024L),
        E_DVL_BOTTOM_SPEED_Z("DVL - Bottom speedZ (m/s)", 1024L),
        E_DVL_WATER_SPEED_X("DVL - Water speedX (m/s)", 1024L),
        E_DVL_WATER_SPEED_Y("DVL - Water speedY (m/s)", 1024L),
        E_DVL_WATER_SPEED_Z("DVL - Water speedZ (m/s)", 1024L),
        E_DVL_SOUND_SPEED("DVL - Sound speed (m/s)", 1024L),
        E_DVL_TIME("DVL - Time", 1024L),
        E_SOUND_SPEED("Sound speed - Sound speed (m/s)", 1024L),
        E_DEPTH("Depth - Depth (m)", 524288L),
        E_DEPTH_TIME("Depth - Time", 524288L),
        E_LOCH_SPEED("LochEM - Speed norm (m/s)", 2048L),
        E_LOCH_TIME("LochEM - Time", 2048L),
        E_USBL_ID("USBL - Beacon ID", 131072L),
        E_USBL_CODE("USBL - TpCode", 131072L),
        E_USBL_LAT("USBL - Latitude (deg)", 131072L),
        E_USBL_LONG("USBL - Longitude (deg)", 131072L),
        E_USBL_ALT("USBL - Altitude (m)", 131072L),
        E_USBL_DELAY("USBL - Delay (s)", 131072L),
        E_USBL_TIME("USBL - Time", 131072L),
        E_LBL_ID("LBL - Beacon ID", 65536L),
        E_LBL_LAT("LBL - Latitude (deg)", 65536L),
        E_LBL_LONG("LBL - Longitude (deg)", 65536L),
        E_LBL_ALT("LBL - Altitude (m)", 65536L),
        E_LBL_RANGE("LBL - Range (m)", 65536L),
        E_LBL_TIME("LBL - Time", 65536L),
        E_MGPS_LAT("Manual GPS - Latitude (deg)", 32768L),
        E_MGPS_LONG("Manual GPS - Longitude (deg)", 32768L),
        E_MGPS_ALT("Manual GPS - Altitude (m)", 32768L),
        E_DMI_PULSE("DMI - (Pulses/s)", 262144L),
        E_DMI_TIME("DMI - Time", 262144L),
        E_CALIBRATION_HEAD("Calibration - Heading (deg)", 512L),
        E_CALIBRATION_PITCH("Calibration - Pitch (deg)", 512L),
        E_CALIBRATION_SCALE_F("Calibration - Scale factor (%)", 512L),
        E_CALIBRATION_CHECK_DIST("Calibration Check - Distance (m)", 512L),
        E_CALIBRATION_CHECK_VERR("Calibration Check - VError (m)", 512L),
        E_CALIBRATION_CHECK_HERR("Calibration Check - HError (m)", 512L),
        E_FOGX_BIAS("FOG X bias (mdeg/h)", 0x200000L),
        E_FOGY_BIAS("FOG Y bias (mdeg/h)", 0x200000L),
        E_FOGZ_BIAS("FOG Z bias (mdeg/h)", 0x200000L),
        E_ACCX_BIAS("ACC X bias (ug)", 0x200000L),
        E_ACCY_BIAS("ACC Y bias (ug)", 0x200000L),
        E_ACCZ_BIAS("ACC Z bias (ug)", 0x200000L);

        String a_Name;
        long field_mask;

        private fieldInfos(String name, long mask) {
            this.a_Name = name;
            this.field_mask = mask;
        }
    }
}

