/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import Tools.ConvertTool;

public class Protocol_DCN_STD_LOCH_Encoder
extends ProtocolEncoder {
    public Protocol_DCN_STD_LOCH_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 0, _Info);
        this.EncoderFramesNames[0] = "LOCH";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        if (this.GetEncoderFrameEnable(0, OutputId)) {
            this.BINTool.Initialize(1);
            if (this.EMLOG_Info.Get_Validity() == 1) {
                this.BINTool.Byte_to_1UINT8(0);
            } else {
                this.BINTool.Byte_to_1UINT8(128);
            }
            double dSpeed = this.EMLOG_Info.Get_LongWaterSpeed(ConvertTool.UNITS.UNITE_KNOTS);
            int iSpeed = (int)(Math.abs(dSpeed) / 30.0 * Math.pow(2.0, 14.0));
            byte[] array = new byte[]{(byte)(iSpeed >>> 8 & 0x7F), (byte)(iSpeed & 0xFF)};
            if (dSpeed < 0.0) {
                array[0] = (byte)(array[0] | 0x80);
            }
            this.BINTool.Byte_to_1UINT8(array[0]);
            this.BINTool.Byte_to_1UINT8(array[1]);
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
    }

    @Override
    public void EncodeFrame1Hz(int OutputId) {
    }
}

