/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import Tools.ASCII_EncodeTool;
import Tools.ConvertTool;

public class Protocol_GPS_Encoder
extends ProtocolEncoder {
    int GPS_cptr = 0;
    private static final int UTC_TELEGRAM_INDEX = 0;
    private static final int ZDA_TELEGRAM_INDEX = 1;
    private static final int GGA_TELEGRAM_INDEX = 2;
    private static final int GST_TELEGRAM_INDEX = 3;
    private static final int VTG_TELEGRAM_INDEX = 4;
    private static final int GLL_TELEGRAM_INDEX = 5;
    private static final int RMC_TELEGRAM_INDEX = 6;
    private static final int GSV_TELEGRAM_INDEX = 7;

    public Protocol_GPS_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 1, _Info);
        this.EncoderFramesNames[0] = "UTC Telegram";
        this.EncoderFramesNames[1] = "ZDA Telegram";
        this.EncoderFramesNames[2] = "GGA Telegram";
        this.EncoderFramesNames[3] = "GST Telegram";
        this.EncoderFramesNames[4] = "VTG Telegram";
        this.EncoderFramesNames[5] = "GLL Telegram";
        this.EncoderFramesNames[6] = "RMC Telegram";
        this.EncoderFramesNames[7] = "GSV Telegram";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        double Longitude;
        double Latitude;
        if (this.GetEncoderFrameEnable(2, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$GPGGA,");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetHours(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMinutes(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.FloatToASCII(this.TIMETool.GetSeconds(), 2, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            Latitude = this.GPS_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Latitude >= 0.0) {
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",N,");
            } else {
                Latitude = -Latitude;
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",S,");
            }
            Longitude = this.GPS_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Longitude > 0.0) {
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",E,");
            } else {
                Longitude = -Longitude;
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",W,");
            }
            this.ASCIITool.IntegerToASCII(this.GPS_Info.Get_Quality(), 1, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.IntegerToASCII(10, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(0.0, 1, 1, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Altitude(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",M,");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_GeoidalSep(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",M,");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Latency(ConvertTool.UNITS.UNITE_S), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat("000");
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
        if (this.GetEncoderFrameEnable(3, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$GPGST,");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetHours(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMinutes(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.FloatToASCII(this.TIMETool.GetSeconds(), 2, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat("0.0,");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_EllipseMajorAxis(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_EllipseMinorAxis(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_EllipseAngle(ConvertTool.UNITS.UNITE_DEGREE), 0, 1, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_LatitudeStd(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_LongitudeStd(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_AltitudeStd(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
        if (this.GetEncoderFrameEnable(5, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$GPGLL,");
            Latitude = this.GPS_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Latitude >= 0.0) {
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",N,");
            } else {
                Latitude = -Latitude;
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",S,");
            }
            Longitude = this.GPS_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Longitude >= 0.0) {
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",E,");
            } else {
                Longitude = -Longitude;
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",W,");
            }
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetHours(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMinutes(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.FloatToASCII(this.TIMETool.GetSeconds(), 2, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat(this.GPS_Info.Get_Validity() == 1 ? "A," : "V,");
            switch (this.GPS_Info.Get_OperatingMode()) {
                case 0: {
                    this.ASCIITool.Concat("A");
                    break;
                }
                case 1: {
                    this.ASCIITool.Concat("D");
                    break;
                }
                case 2: {
                    this.ASCIITool.Concat("E");
                    break;
                }
                case 3: {
                    this.ASCIITool.Concat("M");
                    break;
                }
                case 4: {
                    this.ASCIITool.Concat("S");
                    break;
                }
                default: {
                    this.ASCIITool.Concat("N");
                }
            }
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
        if (this.GetEncoderFrameEnable(4, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$GPVTG,");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Course(ConvertTool.UNITS.UNITE_DEGREE), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",T,");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Course(ConvertTool.UNITS.UNITE_DEGREE), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",M,");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Speed(ConvertTool.UNITS.UNITE_KNOTS), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",N,");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Speed(ConvertTool.UNITS.UNITE_KM_H), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",K,");
            switch (this.GPS_Info.Get_OperatingMode()) {
                case 0: {
                    this.ASCIITool.Concat("A");
                    break;
                }
                case 1: {
                    this.ASCIITool.Concat("D");
                    break;
                }
                case 2: {
                    this.ASCIITool.Concat("E");
                    break;
                }
                case 3: {
                    this.ASCIITool.Concat("M");
                    break;
                }
                case 4: {
                    this.ASCIITool.Concat("S");
                    break;
                }
                default: {
                    this.ASCIITool.Concat("N");
                }
            }
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
        if (this.GetEncoderFrameEnable(6, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$GPRMC,");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetHours(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMinutes(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.FloatToASCII(this.TIMETool.GetSeconds(), 2, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat(this.GPS_Info.Get_Validity() == 1 ? "A," : "V,");
            Latitude = this.GPS_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Latitude < 0.0) {
                Latitude = -Latitude;
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",S,");
            } else {
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",N,");
            }
            Longitude = this.GPS_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Longitude < 0.0) {
                Longitude = -Longitude;
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",W,");
            } else {
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",E,");
            }
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Speed(ConvertTool.UNITS.UNITE_KNOTS), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Course(ConvertTool.UNITS.UNITE_DEGREE), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetDayInMonth(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMonthInYear(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetYear() - 2000, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Course(ConvertTool.UNITS.UNITE_DEGREE), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",E,");
            switch (this.GPS_Info.Get_OperatingMode()) {
                case 0: {
                    this.ASCIITool.Concat("A");
                    break;
                }
                case 1: {
                    this.ASCIITool.Concat("D");
                    break;
                }
                case 2: {
                    this.ASCIITool.Concat("E");
                    break;
                }
                case 3: {
                    this.ASCIITool.Concat("M");
                    break;
                }
                case 4: {
                    this.ASCIITool.Concat("S");
                    break;
                }
                default: {
                    this.ASCIITool.Concat("N");
                }
            }
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
        if (this.GetEncoderFrameEnable(7, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$GPGSV,2,1,08,01,40,083,46,02,17,308,41,12,07,344,39,14,22,228,45");
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
    }

    @Override
    public void EncodeFrame1Hz(int OutputId) {
        if (this.GetEncoderFrameEnable(0, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("UTC ");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetYear() - 2000, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(".");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMonthInYear(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(".");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetDayInMonth(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(" ");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetHours(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(":");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMinutes(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(":");
            this.ASCIITool.IntegerToASCII((int)this.TIMETool.GetSeconds(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(" ");
            this.ASCIITool.Concat("0");
            this.ASCIITool.Concat("0");
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
        if (this.GetEncoderFrameEnable(1, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$GPZDA,");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetHours(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMinutes(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.FloatToASCII(this.TIMETool.GetSeconds(), 2, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetDayInMonth(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMonthInYear(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetYear(), 4, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.IntegerToASCII(0, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.IntegerToASCII(0, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
    }
}

