/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import SimulatorPackage.SimulatorFrame;
import Tools.ConvertTool;

public class Protocol_IXBLUE_STD_BIN_Encoder
extends ProtocolEncoder {
    private static final int V2 = 0;
    private static final int V3 = 1;
    private static final int UTC1 = 2;
    private static final int UTC2 = 3;
    private static final int GPS = 4;
    private static final int EMLOG = 5;
    private static final int USBL = 6;
    private static final int DEPTH = 7;
    private static final int DVL_BT = 8;
    private static final int DVL_WT = 9;
    private static final int CTD = 10;
    private static final int DMI = 11;
    private static final int LBL = 12;
    private static final int HDR_LEN_V2 = 21;
    private static final int HDR_LEN_V3 = 25;
    public static final int UTC_BLK_LEN = 5;
    public static final int GPS_BLK_LEN = 46;
    public static final int EMLOG_BLK_LEN = 13;
    public static final int USBL_BLK_LEN = 49;
    public static final int DEPTH_BLK_LEN = 12;
    public static final int DVLBT_BLK_LEN = 37;
    public static final int DVLWT_BLK_LEN = 33;
    public static final int SNDVEL_BLK_LEN = 8;
    public static final int DMI_BLK_LEN = 8;
    public static final int LBL_BLK_LEN = 41;
    public static final int DW_BIT00 = 1;
    public static final int DW_BIT01 = 2;
    public static final int DW_BIT02 = 4;
    public static final int DW_BIT03 = 8;
    public static final int DW_BIT04 = 16;
    public static final int DW_BIT05 = 32;
    public static final int DW_BIT06 = 64;
    public static final int DW_BIT07 = 128;
    public static final int DW_BIT08 = 256;
    public static final int DW_BIT09 = 512;
    public static final int DW_BIT10 = 1024;
    public static final int DW_BIT11 = 2048;
    public static final int DW_BIT12 = 4096;
    public static final int DW_BIT13 = 8192;
    public static final int DW_BIT14 = 16384;
    public static final int DW_BIT15 = 32768;
    public static final int DW_BIT16 = 65536;
    public static final int DW_BIT17 = 131072;
    public static final int DW_BIT18 = 262144;
    public static final int DW_BIT19 = 524288;
    public static final int DW_BIT20 = 0x100000;
    public static final int DW_BIT21 = 0x200000;
    public static final int DW_BIT22 = 0x400000;
    public static final int DW_BIT23 = 0x800000;
    public static final int DW_BIT24 = 0x1000000;
    public static final int DW_BIT25 = 0x2000000;
    public static final int DW_BIT26 = 0x4000000;
    public static final int DW_BIT27 = 0x8000000;
    public static final int DW_BIT28 = 0x10000000;
    public static final int DW_BIT29 = 0x20000000;
    public static final int DW_BIT30 = 0x40000000;
    public static final int DW_BIT31 = Integer.MIN_VALUE;

    public Protocol_IXBLUE_STD_BIN_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 0, _Info);
        this.EncoderFramesNames[0] = "OUTPUT_V2";
        this.EncoderFramesNames[1] = "OUTPUT_V3";
        this.EncoderFramesNames[2] = "UTC1";
        this.EncoderFramesNames[3] = "UTC2";
        this.EncoderFramesNames[4] = "GPS";
        this.EncoderFramesNames[5] = "EMLOG";
        this.EncoderFramesNames[6] = "USBL";
        this.EncoderFramesNames[7] = "DEPTH";
        this.EncoderFramesNames[8] = "DVL_BT";
        this.EncoderFramesNames[9] = "DVL_WT";
        this.EncoderFramesNames[10] = "CTD";
        this.EncoderFramesNames[11] = "DMI";
        this.EncoderFramesNames[12] = "LBL";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        int ExtData_BitMask = 0;
        int Telegram_Size = 0;
        float UTCTime = 0.0f;
        int Ext_TimeRef = 0;
        int Version = 0;
        int NavData_BitMask = 0;
        int ExtendedData_BitMask = 0;
        if (this.GetEncoderFrameEnable(0, OutputId) && this.GetEncoderFrameEnable(1, OutputId)) {
            return;
        }
        if (this.GetEncoderFrameEnable(0, OutputId) || this.GetEncoderFrameEnable(1, OutputId)) {
            int i;
            int FrameLength;
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(73);
            this.BINTool.Byte_to_1UINT8(88);
            if (SimulatorFrame.jCheckBoxActivateSimStim.isSelected()) {
                NavData_BitMask |= 1;
                Telegram_Size += 12;
                NavData_BitMask |= 0x20;
                Telegram_Size += 12;
                NavData_BitMask |= 0x80;
                Telegram_Size += 20;
                NavData_BitMask |= 0x200;
                Telegram_Size += 12;
                NavData_BitMask |= 0x800000;
                Telegram_Size += 12;
            }
            if (this.GetEncoderFrameEnable(0, OutputId)) {
                Version = 2;
                this.BINTool.Byte_to_1UINT8(2);
                this.BINTool.DWord_to_4UINT8(NavData_BitMask);
            } else {
                Version = 3;
                this.BINTool.Byte_to_1UINT8(Version);
                this.BINTool.DWord_to_4UINT8(NavData_BitMask);
                this.BINTool.DWord_to_4UINT8(ExtendedData_BitMask);
            }
            if (this.GetEncoderFrameEnable(2, OutputId) || this.GetEncoderFrameEnable(3, OutputId)) {
                ExtData_BitMask |= 1;
                Telegram_Size += 5;
            }
            if (this.GetEncoderFrameEnable(4, OutputId)) {
                switch (this.GPS_Info.Get_Id()) {
                    case 0: {
                        ExtData_BitMask |= 2;
                        Telegram_Size += 46;
                        break;
                    }
                    case 1: {
                        ExtData_BitMask |= 4;
                        Telegram_Size += 46;
                    }
                }
            }
            if (this.GetEncoderFrameEnable(5, OutputId)) {
                switch (this.EMLOG_Info.Get_Id()) {
                    case 0: {
                        ExtData_BitMask |= 0x10;
                        Telegram_Size += 13;
                        break;
                    }
                    case 1: {
                        ExtData_BitMask |= 0x20;
                        Telegram_Size += 13;
                    }
                }
            }
            if (this.GetEncoderFrameEnable(6, OutputId)) {
                switch (this.USBL_Info.Get_Id()) {
                    case 0: {
                        ExtData_BitMask |= 0x40;
                        Telegram_Size += 49;
                        break;
                    }
                    case 1: {
                        ExtData_BitMask |= 0x80;
                        Telegram_Size += 49;
                        break;
                    }
                    case 2: {
                        ExtData_BitMask |= 0x100;
                        Telegram_Size += 49;
                    }
                }
            }
            if (this.GetEncoderFrameEnable(7, OutputId)) {
                ExtData_BitMask |= 0x200;
                Telegram_Size += 12;
            }
            if (this.GetEncoderFrameEnable(8, OutputId)) {
                switch (this.DVL_Info.Get_Id()) {
                    case 0: {
                        ExtData_BitMask |= 0x400;
                        Telegram_Size += 37;
                        break;
                    }
                    case 1: {
                        ExtData_BitMask |= 0x200000;
                        Telegram_Size += 37;
                    }
                }
            }
            if (this.GetEncoderFrameEnable(9, OutputId)) {
                switch (this.DVL_Info.Get_Id()) {
                    case 0: {
                        ExtData_BitMask |= 0x800;
                        Telegram_Size += 33;
                        break;
                    }
                    case 1: {
                        ExtData_BitMask |= 0x400000;
                        Telegram_Size += 33;
                    }
                }
            }
            if (this.GetEncoderFrameEnable(10, OutputId)) {
                ExtData_BitMask |= 0x1000;
                Telegram_Size += 8;
            }
            if (this.GetEncoderFrameEnable(11, OutputId)) {
                ExtData_BitMask |= 0x2000;
                Telegram_Size += 8;
            }
            if (this.GetEncoderFrameEnable(12, OutputId)) {
                switch (this.LBL_Info.Get_Id()) {
                    case 0: {
                        ExtData_BitMask |= 0x4000;
                        Telegram_Size += 41;
                        break;
                    }
                    case 1: {
                        ExtData_BitMask |= 0x8000;
                        Telegram_Size += 41;
                        break;
                    }
                    case 2: {
                        ExtData_BitMask |= 0x10000;
                        Telegram_Size += 41;
                        break;
                    }
                    case 3: {
                        ExtData_BitMask |= 0x20000;
                        Telegram_Size += 41;
                    }
                }
            }
            this.BINTool.DWord_to_4UINT8(ExtData_BitMask);
            if (Version == 3) {
                FrameLength = 25 + Telegram_Size + 4;
                this.BINTool.Word_to_2UINT8(FrameLength);
            } else {
                FrameLength = 21 + Telegram_Size + 4;
                this.BINTool.Word_to_2UINT8(FrameLength);
            }
            this.BINTool.Byte_to_1UINT8(Ext_TimeRef);
            for (i = 0; i < 7; ++i) {
                this.BINTool.Byte_to_1UINT8(0);
            }
            if (SimulatorFrame.jCheckBoxActivateSimStim.isSelected()) {
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.GetHeading(ConvertTool.UNITS.UNITE_DEGREE));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.GetRoll(ConvertTool.UNITS.UNITE_DEGREE));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.GetPitch(ConvertTool.UNITS.UNITE_DEGREE));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.Get_RotationRate_X(ConvertTool.UNITS.UNITE_DEGREE_PER_S));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.Get_RotationRate_Y(ConvertTool.UNITS.UNITE_DEGREE_PER_S));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.Get_RotationRate_Z(ConvertTool.UNITS.UNITE_DEGREE_PER_S));
                this.BINTool.Double_to_8UINT8(this.SIMSTIM_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE));
                this.BINTool.Double_to_8UINT8(this.SIMSTIM_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.Get_Altitude(ConvertTool.UNITS.UNITE_M));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.Get_Speed_North(ConvertTool.UNITS.UNITE_M_S));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.Get_Speed_North(ConvertTool.UNITS.UNITE_M_S));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.Get_Speed_North(ConvertTool.UNITS.UNITE_M_S));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.Get_Acceleration_X(ConvertTool.UNITS.UNITE_M_S2));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.Get_Acceleration_Y(ConvertTool.UNITS.UNITE_M_S2));
                this.BINTool.Float_to_4UINT8(this.SIMSTIM_Info.Get_Acceleration_Z(ConvertTool.UNITS.UNITE_M_S2));
            }
            if (this.GetEncoderFrameEnable(2, OutputId)) {
                this.BINTool.DWord_to_4UINT8((long)this.TIMETool.GetTime_100US());
                this.BINTool.Byte_to_1UINT8(0);
            } else if (this.GetEncoderFrameEnable(3, OutputId)) {
                this.BINTool.DWord_to_4UINT8((long)this.TIMETool.GetTime_100US());
                this.BINTool.Byte_to_1UINT8(1);
            }
            if (this.GetEncoderFrameEnable(4, OutputId)) {
                this.BINTool.Long_to_4UINT8((long)this.TIMETool.GetTime_100US());
                this.BINTool.Byte_to_1UINT8(this.GPS_Info.Get_Id());
                this.BINTool.Byte_to_1UINT8(this.GPS_Info.Get_Quality());
                this.BINTool.Double_to_8UINT8(this.GPS_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE));
                this.BINTool.Double_to_8UINT8(this.GPS_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE));
                this.BINTool.Float_to_4UINT8((float)this.GPS_Info.Get_Altitude(ConvertTool.UNITS.UNITE_M));
                this.BINTool.Float_to_4UINT8((float)this.GPS_Info.Get_LatitudeStd(ConvertTool.UNITS.UNITE_M));
                this.BINTool.Float_to_4UINT8((float)this.GPS_Info.Get_LongitudeStd(ConvertTool.UNITS.UNITE_M));
                this.BINTool.Float_to_4UINT8((float)this.GPS_Info.Get_AltitudeStd(ConvertTool.UNITS.UNITE_M));
                this.BINTool.Float_to_4UINT8((float)this.GPS_Info.Get_LatLongCov(ConvertTool.UNITS.UNITE_M2));
                this.BINTool.Float_to_4UINT8((float)this.GPS_Info.Get_GeoidalSep(ConvertTool.UNITS.UNITE_M));
            }
            if (this.GetEncoderFrameEnable(5, OutputId)) {
                this.BINTool.Long_to_4UINT8((long)this.TIMETool.GetTime_100US());
                this.BINTool.Byte_to_1UINT8(this.EMLOG_Info.Get_Id());
                this.BINTool.Float_to_4UINT8((float)this.EMLOG_Info.Get_LongWaterSpeed(ConvertTool.UNITS.UNITE_M_S));
                this.BINTool.Float_to_4UINT8((float)this.EMLOG_Info.Get_LongWaterSpeedStd(ConvertTool.UNITS.UNITE_M_S));
            }
            if (this.GetEncoderFrameEnable(6, OutputId)) {
                this.BINTool.Long_to_4UINT8((long)this.TIMETool.GetTime_100US());
                this.BINTool.Byte_to_1UINT8(this.USBL_Info.Get_Id());
                if (this.USBL_Info.Get_BeaconCodeId().length() > 8) {
                    for (i = 0; i < 8; ++i) {
                        this.BINTool.Byte_to_1UINT8((byte)this.USBL_Info.Get_BeaconCodeId().charAt(i));
                    }
                } else {
                    for (i = 0; i < this.USBL_Info.Get_BeaconCodeId().length(); ++i) {
                        this.BINTool.Byte_to_1UINT8((byte)this.USBL_Info.Get_BeaconCodeId().charAt(i));
                    }
                    for (i = 0; i < 8 - this.USBL_Info.Get_BeaconCodeId().length(); ++i) {
                        this.BINTool.Byte_to_1UINT8(0);
                    }
                }
                this.BINTool.Double_to_8UINT8(this.USBL_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE));
                this.BINTool.Double_to_8UINT8(this.USBL_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE));
                this.BINTool.Float_to_4UINT8(-((float)this.USBL_Info.Get_Depth(ConvertTool.UNITS.UNITE_M)));
                this.BINTool.Float_to_4UINT8((float)this.USBL_Info.Get_LatitudeStd(ConvertTool.UNITS.UNITE_M));
                this.BINTool.Float_to_4UINT8((float)this.USBL_Info.Get_LongitudeStd(ConvertTool.UNITS.UNITE_M));
                this.BINTool.Float_to_4UINT8((float)this.USBL_Info.Get_LatLongCov(ConvertTool.UNITS.UNITE_M2));
                this.BINTool.Float_to_4UINT8((float)this.USBL_Info.Get_DepthStd(ConvertTool.UNITS.UNITE_M));
            }
            if (this.GetEncoderFrameEnable(7, OutputId)) {
                this.BINTool.Long_to_4UINT8((long)this.TIMETool.GetTime_100US());
                this.BINTool.Float_to_4UINT8((float)this.DEPTH_Info.Get_Depth(ConvertTool.UNITS.UNITE_M));
                this.BINTool.Float_to_4UINT8((float)this.DEPTH_Info.Get_DepthStd(ConvertTool.UNITS.UNITE_M));
            }
            if (this.DVL_Info.Get_Id() == 0) {
                if (this.GetEncoderFrameEnable(8, OutputId)) {
                    this.BINTool.Long_to_4UINT8((long)this.TIMETool.GetTime_100US());
                    this.BINTool.Byte_to_1UINT8(this.DVL_Info.Get_Id());
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS1Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS2Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS3Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_SoundSpeed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_Altitude(ConvertTool.UNITS.UNITE_M));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS1SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS2SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS3SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                }
                if (this.GetEncoderFrameEnable(9, OutputId)) {
                    this.BINTool.Long_to_4UINT8((long)this.TIMETool.GetTime_100US());
                    this.BINTool.Byte_to_1UINT8(this.DVL_Info.Get_Id());
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS1Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS2Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS3Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_SoundSpeed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS1SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS2SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS3SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                }
            }
            if (this.GetEncoderFrameEnable(10, OutputId)) {
                this.BINTool.Long_to_4UINT8((long)this.TIMETool.GetTime_100US());
                this.BINTool.Float_to_4UINT8((float)this.CTD_Info.Get_SoundSpeed(ConvertTool.UNITS.UNITE_M_S));
            }
            if (this.GetEncoderFrameEnable(11, OutputId)) {
                this.BINTool.Long_to_4UINT8((long)this.TIMETool.GetTime_100US());
                this.BINTool.Long_to_4UINT8((long)this.DMI_Info.Get_PulseCount());
            }
            if (this.GetEncoderFrameEnable(12, OutputId)) {
                this.BINTool.Long_to_4UINT8((long)this.TIMETool.GetTime_100US());
                this.BINTool.Byte_to_1UINT8(this.LBL_Info.Get_Id());
                if (this.LBL_Info.Get_BeaconCodeId().length() > 8) {
                    for (i = 0; i < 8; ++i) {
                        this.BINTool.Byte_to_1UINT8((byte)this.LBL_Info.Get_BeaconCodeId().charAt(i));
                    }
                } else {
                    for (i = 0; i < this.LBL_Info.Get_BeaconCodeId().length(); ++i) {
                        this.BINTool.Byte_to_1UINT8((byte)this.LBL_Info.Get_BeaconCodeId().charAt(i));
                    }
                    for (i = 0; i < 8 - this.LBL_Info.Get_BeaconCodeId().length(); ++i) {
                        this.BINTool.Byte_to_1UINT8(0);
                    }
                }
                this.BINTool.Double_to_8UINT8(this.LBL_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE));
                this.BINTool.Double_to_8UINT8(this.LBL_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE));
                this.BINTool.Float_to_4UINT8(-((float)this.LBL_Info.Get_Depth(ConvertTool.UNITS.UNITE_M)));
                this.BINTool.Float_to_4UINT8((float)this.LBL_Info.Get_Range(ConvertTool.UNITS.UNITE_M));
                this.BINTool.Float_to_4UINT8((float)this.LBL_Info.Get_RangeStd(ConvertTool.UNITS.UNITE_M));
            }
            if (this.DVL_Info.Get_Id() == 1) {
                if (this.GetEncoderFrameEnable(8, OutputId)) {
                    this.BINTool.Long_to_4UINT8((long)this.TIMETool.GetTime_100US());
                    this.BINTool.Byte_to_1UINT8(this.DVL_Info.Get_Id());
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS1Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS2Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS3Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_SoundSpeed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_Altitude(ConvertTool.UNITS.UNITE_M));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS1SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS2SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_BT_XS3SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                }
                if (this.GetEncoderFrameEnable(9, OutputId)) {
                    this.BINTool.Long_to_4UINT8((long)this.TIMETool.GetTime_100US());
                    this.BINTool.Byte_to_1UINT8(this.DVL_Info.Get_Id());
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS1Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS2Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS3Speed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_SoundSpeed(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS1SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS2SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                    this.BINTool.Float_to_4UINT8((float)this.DVL_Info.Get_WT_XS3SpeedStd(ConvertTool.UNITS.UNITE_M_S));
                }
            }
            int Checksum2 = 0;
            byte[] EncodedFrame = this.BINTool.GetBinaryFrame();
            for (int i2 = 0; i2 < this.BINTool.GetBinaryFrameLenght(); ++i2) {
                Checksum2 += EncodedFrame[i2] & 0xFF;
            }
            this.BINTool.DWord_to_4UINT8(Checksum2);
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
    }

    @Override
    public void EncodeFrame1Hz(int OutputId) {
    }
}

