/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import Tools.ASCII_EncodeTool;
import Tools.ConvertTool;

public class Protocol_Minifog_Gps_Msg_Encoder
extends ProtocolEncoder {
    private static final int MINIFOG_GPS_TELEGRAM_INDEX = 0;

    public Protocol_Minifog_Gps_Msg_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 1, _Info);
        this.EncoderFramesNames[0] = "MINIFOG_GPS_MSG Telegram";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        if (this.GetEncoderFrameEnable(0, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("G");
            double Latitude = this.GPS_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Latitude < 0.0) {
                Latitude = -Latitude;
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.IntegerToASCII((int)(1000000.0 * (Latitude - (double)((int)Latitude))), 6, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat("S");
            } else {
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.IntegerToASCII((int)(1000000.0 * (Latitude - (double)((int)Latitude))), 6, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat("N");
            }
            double Longitude = this.GPS_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Longitude < 0.0) {
                Longitude = -Longitude;
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.IntegerToASCII((int)(1000000.0 * (Longitude - (double)((int)Longitude))), 6, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat("W");
            } else {
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.IntegerToASCII((int)(1000000.0 * (Longitude - (double)((int)Longitude))), 6, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat("E");
            }
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
    }

    @Override
    public void EncodeFrame1Hz(int OutputId) {
    }
}

