/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import Tools.ASCII_EncodeTool;
import Tools.ConvertTool;

public class Protocol_SVX2_Encoder
extends ProtocolEncoder {
    private static final int FORMAT1_TELEGRAM_INDEX = 0;
    private static final int FORMAT2_TELEGRAM_INDEX = 1;
    private static final int USE_M_INDEX = 0;
    private static final int USE_DBAR_INDEX = 1;
    private static final int USE_FEET_INDEX = 2;

    public Protocol_SVX2_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 1, _Info);
        this.EncoderFramesNames[0] = "Format 1";
        this.EncoderFramesNames[1] = "Format 2";
        this.EncoderOptionsNames[0] = "Unit METER";
        this.EncoderOptionsNames[1] = "Unit DBAR";
        this.EncoderOptionsNames[2] = "Unit FEET";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        for (int i = 0; i <= 1; ++i) {
            if (!this.GetEncoderFrameEnable(i, OutputId)) continue;
            this.Generate_Formats(i, OutputId);
        }
    }

    @Override
    public void EncodeFrame1Hz(int OutputId) {
    }

    private void Generate_Formats(int OutputFormat, int OutputId) {
        this.ASCIITool.Initialize();
        if (this.GetEncoderOptionEnable(2, OutputId)) {
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_SoundSpeed(ConvertTool.UNITS.UNITE_FEET_S), 4, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat("\t");
            this.ASCIITool.Concat("F/S");
            this.ASCIITool.Concat("\t");
        } else {
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_SoundSpeed(ConvertTool.UNITS.UNITE_M_S), 4, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat("\t");
            this.ASCIITool.Concat("M/SEC");
            this.ASCIITool.Concat("\t");
        }
        if (this.GetEncoderOptionEnable(1, OutputId)) {
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Pressure(ConvertTool.UNITS.UNITE_DBAR), 4, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat("\t");
            this.ASCIITool.Concat("DBAR");
            this.ASCIITool.Concat("\t");
        } else if (this.GetEncoderOptionEnable(2, OutputId)) {
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Depth(ConvertTool.UNITS.UNITE_FEET), 4, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat("\t");
            this.ASCIITool.Concat("F");
            this.ASCIITool.Concat("\t");
        } else {
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Depth(ConvertTool.UNITS.UNITE_M), 4, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat("\t");
            this.ASCIITool.Concat("M");
            this.ASCIITool.Concat("\t");
        }
        this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Temperature(ConvertTool.UNITS.UNITE_DEGCEL), 4, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
        this.ASCIITool.Concat("\t");
        this.ASCIITool.Concat("C");
        this.ASCIITool.Concat("\t");
        this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Conductivity(ConvertTool.UNITS.UNITE_S_m) * 10.0, 4, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
        this.ASCIITool.Concat("\t");
        this.ASCIITool.Concat("MS/CM");
        this.ASCIITool.Concat("\t");
        if (OutputFormat == 1) {
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Salinity(ConvertTool.UNITS.UNITE_PSU), 4, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat("\t");
            this.ASCIITool.Concat("PSU");
            this.ASCIITool.Concat("\t");
        }
        this.ASCIITool.Concat("\r\n");
        this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
    }
}

