/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import Tools.ConvertTool;

public class Protocol_TERPS8000_Encoder
extends ProtocolEncoder {
    private static final int TERPS8000_TELEGRAM_INDEX = 0;
    private static final int USE_BAR_INDEX = 0;
    private static final int USE_MBAR_INDEX = 1;

    public Protocol_TERPS8000_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 1, _Info);
        this.EncoderFramesNames[0] = "TERPS8000 Telegram";
        this.EncoderOptionsNames[0] = "Unit Bar";
        this.EncoderOptionsNames[1] = "Unit mBar";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        String frame = "";
        int frame_length = 0;
        double pressure = 0.0;
        String unit = "";
        if (this.GetEncoderFrameEnable(0, OutputId)) {
            pressure = this.DEPTH_Info.Get_Pressure(ConvertTool.UNITS.UNITE_DBAR);
            if (this.DEPTH_Info.Get_CompensatedData() == 0) {
                pressure -= 10.1325;
            }
            pressure = (unit = this.GetEncoderOptionEnable(1, OutputId) ? "mBar" : "Bar").matches("mBar") ? (pressure *= 100.0) : (pressure /= 10.0);
            frame = Double.toString(pressure);
            for (int i = frame_length = frame.length(); i < 7; ++i) {
                frame = frame + '0';
            }
            frame = frame.substring(0, 7);
            frame = frame + " ";
            frame = frame + unit;
            frame = frame + "\r\n";
            this.EncodeFrameSetReady(frame);
        }
    }
}

