/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import Tools.ASCII_EncodeTool;
import Tools.ConvertTool;

public class Protocol_USBL_LBL_CTD_Encoder
extends ProtocolEncoder {
    private static final int BFUSBL = 0;
    private static final int BFLBL = 1;
    private static final int BFCTD = 2;

    public Protocol_USBL_LBL_CTD_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 1, _Info);
        this.EncoderFramesNames[0] = "BFUSBL";
        this.EncoderFramesNames[1] = "BFLBL";
        this.EncoderFramesNames[2] = "BFCTD";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        double Longitude;
        double Latitude;
        if (this.GetEncoderFrameEnable(0, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$BFUSBL,");
            Latitude = this.USBL_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Latitude >= 0.0) {
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",N,");
            } else {
                Latitude = -Latitude;
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",S,");
            }
            Longitude = this.USBL_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Longitude >= 0.0) {
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",E,");
            } else {
                Longitude = -Longitude;
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",W,");
            }
            this.ASCIITool.FloatToASCII(this.USBL_Info.Get_Depth(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS_PLUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.USBL_Info.Get_LatitudeStd(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.USBL_Info.Get_LongitudeStd(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.USBL_Info.Get_LatLongCov(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.USBL_Info.Get_DepthStd(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.USBL_Info.Get_Latency(ConvertTool.UNITS.UNITE_S), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
        if (this.GetEncoderFrameEnable(1, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$BFLBL,");
            Latitude = this.LBL_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE);
            this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(Latitude >= 0.0 ? ",N," : ",S,");
            Longitude = this.LBL_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE);
            this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 8, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(Longitude >= 0.0 ? ",E," : ",W,");
            this.ASCIITool.FloatToASCII(this.LBL_Info.Get_Depth(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS_PLUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat(this.LBL_Info.Get_BeaconCodeId());
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.LBL_Info.Get_Range(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.LBL_Info.Get_RangeStd(ConvertTool.UNITS.UNITE_M), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.LBL_Info.Get_Latency(ConvertTool.UNITS.UNITE_S), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
        if (this.GetEncoderFrameEnable(2, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$BFCTD,");
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Conductivity(ConvertTool.UNITS.UNITE_S_m) * 10.0, 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS_PLUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Temperature(ConvertTool.UNITS.UNITE_DEGCEL), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS_PLUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Pressure(ConvertTool.UNITS.UNITE_DBAR), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS_PLUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetHours(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(":");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMinutes(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(":");
            this.ASCIITool.FloatToASCII(this.TIMETool.GetSeconds(), 2, 0, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(" ");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMonthInYear(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat("-");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetDayInMonth(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat("-");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetYear(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Salinity(ConvertTool.UNITS.UNITE_PSU), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS_PLUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_SoundSpeed(ConvertTool.UNITS.UNITE_M_S), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS_PLUS);
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
    }

    @Override
    public void EncodeFrame1Hz(int OutputId) {
        this.ASCIITool.Initialize();
    }
}

