/*
 * Decompiled with CFR 0.152.
 */
package FlowReaderWriterPackage;

import FlowReaderWriterPackage.FlowReaderWriter;
import InfosPackage.OutputFlowInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class FlowEthernetReaderWriter
extends FlowReaderWriter {
    ServerSocket ServerSocket = null;
    Socket ClientSocket = null;
    DatagramSocket UDPSocket = null;
    DatagramPacket UDPpaquet = null;
    MulticastSocket UDPMultiCastSocket = null;
    InetAddress group = null;

    public FlowEthernetReaderWriter(OutputFlowInfo _FlowInfo) {
        super.FlowReaderWriter(_FlowInfo);
    }

    @Override
    public int TryConnect() {
        int _Connection_State = 1;
        switch (this.Info.GetEthernetConnType()) {
            case 0: {
                try {
                    System.out.println("EthernetFlow: TCP Client TRY TO CONNECT");
                    this.ClientSocket = new Socket();
                    this.ClientSocket.connect(new InetSocketAddress(this.Info.GetEthernetIPAdress(), Integer.parseInt(this.Info.GetEthernetIPPort())), 500);
                    this.ClientSocket.setTcpNoDelay(true);
                    this.ClientSocket.setPerformancePreferences(0, 1, 0);
                    this._InputStream = this.ClientSocket.getInputStream();
                    this._BufferedInputStream = new BufferedInputStream(this._InputStream);
                    this._DataInputStream = new DataInputStream(this._BufferedInputStream);
                    this._OutputStream = this.ClientSocket.getOutputStream();
                    this._BufferedOutputStream = new BufferedOutputStream(this._OutputStream);
                    this._DataOutputStream = new DataOutputStream(this._BufferedOutputStream);
                    System.out.println("EthernetFlow: CONNECTION OK");
                    _Connection_State = 0;
                }
                catch (SocketTimeoutException ex_to) {
                    try {
                        System.out.println("EthernetFlow: CONNECTION TIMEOUT");
                        this.ClientSocket.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException e) {
                    System.out.println("EthernetFlow: TCP Client Connection ERR");
                }
                break;
            }
            case 1: {
                try {
                    this.ServerSocket = new ServerSocket(Integer.parseInt(this.Info.GetEthernetIPPort()));
                    this.ServerSocket.setPerformancePreferences(0, 1, 0);
                    this.ServerSocket.setSoTimeout(500);
                }
                catch (IOException e) {
                    System.out.println("EthernetFlow: TCP Server Connection ERR");
                }
                try {
                    this.ClientSocket = this.ServerSocket.accept();
                    this.ClientSocket.setTcpNoDelay(true);
                    this.ClientSocket.setPerformancePreferences(0, 1, 0);
                    this._InputStream = this.ClientSocket.getInputStream();
                    this._BufferedInputStream = new BufferedInputStream(this._InputStream);
                    this._DataInputStream = new DataInputStream(this._BufferedInputStream);
                    this._OutputStream = this.ClientSocket.getOutputStream();
                    this._BufferedOutputStream = new BufferedOutputStream(this._OutputStream);
                    this._DataOutputStream = new DataOutputStream(this._BufferedOutputStream);
                    System.out.println("EthernetFlow: TCP Serveur Connection OK");
                    _Connection_State = 0;
                }
                catch (SocketTimeoutException e) {
                }
                catch (IOException e) {
                    System.out.println("EthernetFlow: TCP Client Connection ERR");
                }
                break;
            }
            case 2: {
                try {
                    this.UDPSocket = new DatagramSocket();
                    this.UDPSocket.setSoTimeout(500);
                    this.UDPpaquet = new DatagramPacket(new byte[2048], 2048);
                    this.UDPpaquet.setSocketAddress(new InetSocketAddress(this.Info.GetEthernetIPAdress(), Integer.parseInt(this.Info.GetEthernetIPPort())));
                    System.out.println("EthernetFlow: UDP Connection OK");
                    _Connection_State = 0;
                }
                catch (Exception e) {
                    System.out.println("EthernetFlow: UDP Connection ERR");
                }
                break;
            }
            case 3: {
                try {
                    this.UDPMultiCastSocket = new MulticastSocket(Integer.parseInt(this.Info.GetEthernetIPPort()));
                    this.group = InetAddress.getByName(this.Info.GetEthernetIPAdress());
                    this.UDPMultiCastSocket.joinGroup(this.group);
                    this.UDPMultiCastSocket.setSoTimeout(500);
                    this.UDPpaquet = new DatagramPacket(new byte[2048], 2048);
                    System.out.println("EthernetFlow: UDP MultiCast Connection OK");
                    _Connection_State = 0;
                }
                catch (Exception e) {
                    System.out.println("EthernetFlow: UDP MultiCast Connection ERR");
                }
                break;
            }
        }
        return _Connection_State;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int FlowRead(byte[] Bytes_Read) {
        int Nb_Bytes = 0;
        if (this.Info.GetEthernetConnType() == 2) {
            try {
                this.UDPSocket.receive(this.UDPpaquet);
                if (this.UDPpaquet.getLength() == 0) return Nb_Bytes;
                Nb_Bytes = this.UDPpaquet.getLength();
                byte[] Bytes = this.UDPpaquet.getData();
                int i = 0;
                while (i < Nb_Bytes) {
                    Bytes_Read[i] = Bytes[i];
                    ++i;
                }
                return Nb_Bytes;
            }
            catch (SocketTimeoutException Bytes) {
                return Nb_Bytes;
            }
            catch (IOException ex) {
                return -1;
            }
        } else if (this.Info.GetEthernetConnType() == 3) {
            try {
                this.UDPMultiCastSocket.receive(this.UDPpaquet);
                if (this.UDPpaquet.getLength() == 0) return Nb_Bytes;
                Nb_Bytes = this.UDPpaquet.getLength();
                byte[] Bytes = this.UDPpaquet.getData();
                int i = 0;
                while (i < Nb_Bytes) {
                    Bytes_Read[i] = Bytes[i];
                    ++i;
                }
                return Nb_Bytes;
            }
            catch (SocketTimeoutException Bytes) {
                return Nb_Bytes;
            }
            catch (IOException ex) {
                return -1;
            }
        } else {
            try {
                return this._DataInputStream.read(Bytes_Read);
            }
            catch (Exception e) {
                return -1;
            }
        }
    }

    @Override
    public int FlowWrite(byte[] Bytes_Read, int Lenght) {
        int Nb_Bytes = 0;
        if (this.Info.GetEthernetConnType() == 2) {
            this.UDPpaquet.setData(Bytes_Read, 0, Lenght);
            try {
                this.UDPSocket.send(this.UDPpaquet);
                Nb_Bytes = Lenght;
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException ex) {
                Nb_Bytes = -1;
            }
        } else if (this.Info.GetEthernetConnType() == 3) {
            this.UDPpaquet.setData(Bytes_Read, 0, Lenght);
            this.UDPpaquet.setAddress(this.group);
            this.UDPpaquet.setPort(new Integer(this.Info.GetEthernetIPPort()));
            try {
                this.UDPMultiCastSocket.send(this.UDPpaquet);
                Nb_Bytes = Lenght;
            }
            catch (SocketTimeoutException ex) {
            }
            catch (IOException ex) {
                Nb_Bytes = -1;
            }
        } else {
            try {
                this._DataOutputStream.write(Bytes_Read, 0, Lenght);
                this._DataOutputStream.flush();
                Nb_Bytes = Lenght;
            }
            catch (Exception e) {
                Nb_Bytes = -1;
            }
        }
        return Nb_Bytes;
    }

    @Override
    public int TryDisconnect() {
        if (this.ClientSocket != null) {
            try {
                this.ClientSocket.close();
                System.out.println("EthernetFlow: Client Disconnection");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.ServerSocket != null) {
            try {
                this.ServerSocket.close();
                System.out.println("EthernetFlow: Server Disconnection");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.UDPSocket != null) {
            try {
                this.UDPSocket.close();
                System.out.println("EthernetFlow: UDP Diconnection");
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        if (this.UDPMultiCastSocket != null) {
            try {
                this.UDPMultiCastSocket.leaveGroup(this.group);
                this.UDPMultiCastSocket.close();
                System.out.println("EthernetFlow: UDP Diconnection");
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return 1;
    }
}

