/*
 * Decompiled with CFR 0.152.
 */
package InfosPackage;

import Tools.ConvertTool;
import java.util.prefs.Preferences;

public class ExternalSensorInfo {
    Preferences prefs;
    private ConvertTool t;
    String Name = "";
    int Id = 0;
    private int Validity = 0;
    private double Latitude_deg = 0.0;
    private double Longitude_deg = 0.0;
    private double UTM_East_m = 0.0;
    private double UTM_North_m = 0.0;
    private String UTM_Zone = "U32";
    private double Altitude_m = 0.0;
    private double LatitudeStd_m = 0.0;
    private double LongitudeStd_m = 0.0;
    private double AltitudeStd_m = 0.0;
    private double LatLongCov_m = 0.0;
    private double EllipseMajorAxis_m = 0.0;
    private double EllipseMinorAxis_m = 0.0;
    private double EllipseAngle_d = 0.0;
    private double Latency_us = 0.0;
    private double GeoidalSep_m = 0.0;
    private int Quality = 0;
    private int OperatingMode = 0;
    private double Course_deg = 0.0;
    private double Speed_ms = 0.0;
    private String BeaconCodeId = "TpC";
    private int BeaconNumId = 22;
    private double Depth_m = 0.0;
    private double DepthStd_m = 0.0;
    private double Range_m = 0.0;
    private double RangeStd_m = 0.0;
    private double SoundSpeed_m_s = 0.0;
    private int CoordinateVelocities = 0;
    private double BT_XS1Speed_m_s = 0.0;
    private double BT_XS2Speed_m_s = 0.0;
    private double BT_XS3Speed_m_s = 0.0;
    private double BT_XS1SpeedStd_m_s = 0.0;
    private double BT_XS2SpeedStd_m_s = 0.0;
    private double BT_XS3SpeedStd_m_s = 0.0;
    private double BT_SoundSpeed_m_s = 0.0;
    private double BT_Altitude_m = 0.0;
    private int BT_Validity = 0;
    private int CompensatedData = 1;
    private double BT_Latency_us = 0.0;
    private double WT_XS1Speed_m_s = 0.0;
    private double WT_XS2Speed_m_s = 0.0;
    private double WT_XS3Speed_m_s = 0.0;
    private double WT_XS1SpeedStd_m_s = 0.0;
    private double WT_XS2SpeedStd_m_s = 0.0;
    private double WT_XS3SpeedStd_m_s = 0.0;
    private double WT_SoundSpeed_m_s = 0.0;
    private double WT_Altitude_m = 0.0;
    private int WT_Validity = 0;
    private double WT_Latency_us = 0.0;
    private double LongWaterSpeed_m_s = 0.0;
    private double LongWaterSpeedStd_m_s = 0.0;
    private double TransWaterSpeed_m_s = 0.0;
    private double LongGroundSpeed_m_s = 0.0;
    private double TransGroundSpeed_m_s = 0.0;
    private double Conductivity_s_m = 0.0;
    private double Temperature_degcel = 0.0;
    private double Pressure_dbar = 0.0;
    private double Salinity_psu = 0.0;
    private double PulseCount = 0.0;
    private double MajorAxis = 0.0;
    private double MinorAxis = 0.0;
    private double MajorAxisDir_deg = 0.0;
    private double Deflection_Xi_secarc = 0.0;
    private double Deflection_Eta_secarc = 0.0;
    private double Deviation_Norm_milligal = 0.0;
    private double Roll_deg = 0.0;
    private double Pitch_deg = 0.0;
    private double Heading_deg = 0.0;
    private double SpeedNorth_m_s = 0.0;
    private double SpeedEast_m_s = 0.0;
    private double SpeedUp_m_s = 0.0;
    private double RotRateX_deg_s = 0.0;
    private double RotRateY_deg_s = 0.0;
    private double RotRateZ_deg_s = 0.0;
    private double AccelX_m_s2 = 0.0;
    private double AccelY_m_s2 = 0.0;
    private double AccelZ_m_s2 = 0.0;
    private int AltitudeRef = 0;
    private double[] Pos = new double[3];
    private double[] Orient = new double[3];
    private int Status;
    private int DvlNtk_Id = 27;
    private int DvlNtk_NbOfBeam = 4;
    private double[] DvlNtk_DistanceBeam = new double[4];
    private double[] DvlNtk_VelocityAxis = new double[4];
    private double[] DvlNtk_FOMAxis = new double[4];
    private double[] DvlNtk_DT1Axis = new double[4];
    private double[] DvlNtk_DT2Axis = new double[4];
    private static final String REG_SENSOR_ID = "id";
    private static final String REG_SENSOR_VALIDITY = "validity";
    private static final String REG_SENSOR_LATITUDE = "latitude";
    private static final String REG_SENSOR_LONGITUDE = "longitude";
    private static final String REG_SENSOR_UTM_EAST = "utmeast";
    private static final String REG_SENSOR_UTM_NORTH = "utmnorth";
    private static final String REG_SENSOR_UTM_ZONE = "utmzone";
    private static final String REG_SENSOR_ALTITUDE = "altitude";
    private static final String REG_SENSOR_LATITUDESTD = "latitudestd";
    private static final String REG_SENSOR_LONGITUDESTD = "longitudestd";
    private static final String REG_SENSOR_ALTITUDESTD = "altitudestd";
    private static final String REG_SENSOR_LATLONGCOV = "latlongcov";
    private static final String REG_SENSOR_ELLIPSEMAJORAXIS = "ellipsemajoraxis";
    private static final String REG_SENSOR_ELLIPSEMINORAXIS = "ellipseminoraxis";
    private static final String REG_SENSOR_ELLIPSEANGLE = "ellipseangle";
    private static final String REG_SENSOR_LATENCY = "latency";
    private static final String REG_SENSOR_GEOIDALSEP = "geoidalsep";
    private static final String REG_SENSOR_QUALITY = "quality";
    private static final String REG_OPERATING_MODE = "operatingmode";
    private static final String REG_SENSOR_COURSE = "truecourse";
    private static final String REG_SENSOR_SPEED = "speed";
    private static final String REG_SENSOR_BEACONCODEID = "beaconcodeid";
    private static final String REG_SENSOR_BEACONNUMID = "beaconnumid";
    private static final String REG_SENSOR_DEPTH = "depth";
    private static final String REG_SENSOR_DEPTHSTD = "depthstd";
    private static final String REG_SENSOR_RANGE = "range";
    private static final String REG_SENSOR_RANGESTD = "rangestd";
    private static final String REG_SENSOR_SOUNDSPEED = "soundspeed";
    private static final String REG_SENSOR_COORDINATEVELOCITIES = "coordinatevelocities";
    private static final String REG_SENSOR_BTXS1SPEED = "btxs1speed";
    private static final String REG_SENSOR_BTXS2SPEED = "btxs2speed";
    private static final String REG_SENSOR_BTXS3SPEED = "btxs3speed";
    private static final String REG_SENSOR_BTXS1SPEEDSTD = "btxs1speedstd";
    private static final String REG_SENSOR_BTXS2SPEEDSTD = "btxs2speedstd";
    private static final String REG_SENSOR_BTXS3SPEEDSTD = "btxs3speedstd";
    private static final String REG_SENSOR_BTSOUNDSPEED = "btsoundspeed";
    private static final String REG_SENSOR_BTALTITUDE = "btaltitude";
    private static final String REG_SENSOR_BTLATENCY = "btlatency";
    private static final String REG_SENSOR_BTVALIDITY = "btvalidity";
    private static final String REG_SENSOR_COMPENSATED_DATA = "compensateddata";
    private static final String REG_SENSOR_WTXS1SPEED = "wtxs1speed";
    private static final String REG_SENSOR_WTXS2SPEED = "wtxs2speed";
    private static final String REG_SENSOR_WTXS3SPEED = "wtxs3speed";
    private static final String REG_SENSOR_WTXS1SPEEDSTD = "wtxs1speedstd";
    private static final String REG_SENSOR_WTXS2SPEEDSTD = "wtxs2speedstd";
    private static final String REG_SENSOR_WTXS3SPEEDSTD = "wtxs3speedstd";
    private static final String REG_SENSOR_WTSOUNDSPEED = "wtsoundspeed";
    private static final String REG_SENSOR_WTALTITUDE = "wtaltitude";
    private static final String REG_SENSOR_WTLATENCY = "wtlatency";
    private static final String REG_SENSOR_WTVALIDITY = "wtvalidity";
    private static final String REG_SENSOR_LONGWATERSPEED = "longwaterspeed";
    private static final String REG_SENSOR_LONGWATERSPEEDSTD = "longwaterspeedstd";
    private static final String REG_SENSOR_TRANSWATERSPEED = "transwaterspeed";
    private static final String REG_SENSOR_LONGGROUNDSPEED = "longgroundspeed";
    private static final String REG_SENSOR_TRANSGROUNDSPEED = "transgroundspeed";
    private static final String REG_SENSOR_CONDUCTIVITY = "conductivity";
    private static final String REG_SENSOR_TEMPERATURE = "temperature";
    private static final String REG_SENSOR_PRESSURE = "pressure";
    private static final String REG_SENSOR_SALINITY = "salinity";
    private static final String REG_SENSOR_DEFLECTION_XI = "deflectionxi";
    private static final String REG_SENSOR_DEFLECTION_ETA = "deflectioneta";
    private static final String REG_SENSOR_DEVIATION_NORM = "deviationnorm";
    private static final String REG_SENSOR_POSITION = "position";
    private static final String REG_SENSOR_ORIENTATION = "orientation";
    private static final String REG_SENSOR_STATUS = "status";
    private static final String REG_SENSOR_PULSECOUNT = "pulsecount";
    private static final String REG_SENSOR_ROLL = "roll";
    private static final String REG_SENSOR_PITCH = "pitch";
    private static final String REG_SENSOR_HEADING = "heading";
    private static final String REG_STIM_SPEED_NORTH = "speednorth";
    private static final String REG_STIM_SPEED_EAST = "speedeast";
    private static final String REG_STIM_SPEED_UP = "speedup";
    private static final String REG_STIM_ROTRATE_X = "rotrate_x";
    private static final String REG_STIM_ROTRATE_Y = "rotrate_y";
    private static final String REG_STIM_ROTRATE_Z = "rotrate_z";
    private static final String REG_STIM_ACCEL_X = "accel_x";
    private static final String REG_STIM_ACCEL_Y = "accel_y";
    private static final String REG_STIM_ACCEL_Z = "accel_z";
    private static final String REG_SENSOR_ALTITUDE_REF = "altituderef";
    private static final String REG_SENSOR_DVL_NTK_IDENTIFIER = "dvlntkident";
    private static final String REG_SENSOR_DVL_NTK_NBOFBEAMS = "dvlntknbbeam";
    private static final String REG_SENSOR_DVL_NTK_DISTANCEBEAM_0 = "dvlntkdstbm0";
    private static final String REG_SENSOR_DVL_NTK_DISTANCEBEAM_1 = "dvlntkdstbm1";
    private static final String REG_SENSOR_DVL_NTK_DISTANCEBEAM_2 = "dvlntkdstbm2";
    private static final String REG_SENSOR_DVL_NTK_DISTANCEBEAM_3 = "dvlntkdstbm3";
    private static final String REG_SENSOR_DVL_NTK_VELOCITY_0 = "dvlntkdstvel0";
    private static final String REG_SENSOR_DVL_NTK_VELOCITY_1 = "dvlntkdstvel1";
    private static final String REG_SENSOR_DVL_NTK_VELOCITY_2 = "dvlntkdstvel2";
    private static final String REG_SENSOR_DVL_NTK_VELOCITY_3 = "dvlntkdstvel3";
    private static final String REG_SENSOR_DVL_NTK_FOM_0 = "dvlntkdstfom0";
    private static final String REG_SENSOR_DVL_NTK_FOM_1 = "dvlntkdstfom1";
    private static final String REG_SENSOR_DVL_NTK_FOM_2 = "dvlntkdstfom2";
    private static final String REG_SENSOR_DVL_NTK_FOM_3 = "dvlntkdstfom3";
    private static final String REG_SENSOR_DVL_NTK_DT1_0 = "dvlntkdstdt10";
    private static final String REG_SENSOR_DVL_NTK_DT1_1 = "dvlntkdstdt11";
    private static final String REG_SENSOR_DVL_NTK_DT1_2 = "dvlntkdstdt12";
    private static final String REG_SENSOR_DVL_NTK_DT1_3 = "dvlntkdstdt13";
    private static final String REG_SENSOR_DVL_NTK_DT2_0 = "dvlntkdstdt20";
    private static final String REG_SENSOR_DVL_NTK_DT2_1 = "dvlntkdstdt21";
    private static final String REG_SENSOR_DVL_NTK_DT2_2 = "dvlntkdstdt22";
    private static final String REG_SENSOR_DVL_NTK_DT2_3 = "dvlntkdstdt23";
    public static final int INSTRUMENT_COORDINATE_VELOCITIES = 64;
    public static final int SHIP_COORDINATE_VELOCITIES = 128;

    public ExternalSensorInfo(String _Name, int _Id) {
        this.Name = _Name;
        this.Id = _Id;
        this.t = new ConvertTool();
        this.prefs = Preferences.userRoot().node("ixsea/genericsimulator/externalsensor/" + _Name + "/" + Integer.toString(_Id));
        this.Set_Validity(this.prefs.getInt(REG_SENSOR_VALIDITY, 1));
        this.Set_Latitude(this.prefs.getDouble(REG_SENSOR_LATITUDE, 48.8), ConvertTool.UNITS.UNITE_DEGREE);
        this.Set_Longitude(this.prefs.getDouble(REG_SENSOR_LONGITUDE, 2.0), ConvertTool.UNITS.UNITE_DEGREE);
        this.Set_UTM_East(this.prefs.getDouble(REG_SENSOR_UTM_EAST, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_UTM_North(this.prefs.getDouble(REG_SENSOR_UTM_NORTH, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_UTM_Zone(this.prefs.get(REG_SENSOR_UTM_ZONE, "U32"));
        this.Set_Altitude(this.prefs.getDouble(REG_SENSOR_ALTITUDE, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_LatitudeStd(this.prefs.getDouble(REG_SENSOR_LATITUDESTD, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_LongitudeStd(this.prefs.getDouble(REG_SENSOR_LONGITUDESTD, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_AltitudeStd(this.prefs.getDouble(REG_SENSOR_ALTITUDESTD, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_EllipseMajorAxis(this.prefs.getDouble(REG_SENSOR_ELLIPSEMAJORAXIS, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_EllipseMinorAxis(this.prefs.getDouble(REG_SENSOR_ELLIPSEMINORAXIS, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_EllipseAngle(this.prefs.getDouble(REG_SENSOR_ELLIPSEANGLE, 0.0), ConvertTool.UNITS.UNITE_DEGREE);
        this.Set_LongWaterSpeed(this.prefs.getDouble(REG_SENSOR_LONGWATERSPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_TransWaterSpeed(this.prefs.getDouble(REG_SENSOR_TRANSWATERSPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_LongGroundSpeed(this.prefs.getDouble(REG_SENSOR_LONGGROUNDSPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_TransGroundSpeed(this.prefs.getDouble(REG_SENSOR_TRANSGROUNDSPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_LongWaterSpeedStd(this.prefs.getDouble(REG_SENSOR_LONGWATERSPEEDSTD, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_LatLongCov(this.prefs.getDouble(REG_SENSOR_LATLONGCOV, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_GeoidalSep(this.prefs.getDouble(REG_SENSOR_GEOIDALSEP, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_Quality(this.prefs.getInt(REG_SENSOR_QUALITY, 1));
        this.Set_OperatingMode(this.prefs.getInt(REG_OPERATING_MODE, 1));
        this.Set_Course(this.prefs.getDouble(REG_SENSOR_COURSE, 0.0), ConvertTool.UNITS.UNITE_DEGREE);
        this.Set_Speed(this.prefs.getDouble(REG_SENSOR_SPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_Depth(this.prefs.getDouble(REG_SENSOR_DEPTH, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_DepthStd(this.prefs.getDouble(REG_SENSOR_DEPTHSTD, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_Latency(this.prefs.getDouble(REG_SENSOR_LATENCY, 0.0), ConvertTool.UNITS.UNITE_US);
        this.Set_CoordinateVelocities(this.prefs.getInt(REG_SENSOR_COORDINATEVELOCITIES, 0));
        this.Set_BT_XS1Speed(this.prefs.getDouble(REG_SENSOR_BTXS1SPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_BT_XS2Speed(this.prefs.getDouble(REG_SENSOR_BTXS2SPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_BT_XS3Speed(this.prefs.getDouble(REG_SENSOR_BTXS3SPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_BT_XS1SpeedStd(this.prefs.getDouble(REG_SENSOR_BTXS1SPEEDSTD, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_BT_XS2SpeedStd(this.prefs.getDouble(REG_SENSOR_BTXS2SPEEDSTD, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_BT_XS3SpeedStd(this.prefs.getDouble(REG_SENSOR_BTXS3SPEEDSTD, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_BT_SoundSpeed(this.prefs.getDouble(REG_SENSOR_BTSOUNDSPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_BT_Altitude(this.prefs.getDouble(REG_SENSOR_BTALTITUDE, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_BT_Validity(this.prefs.getInt(REG_SENSOR_BTVALIDITY, 1));
        this.Set_CompensatedData(this.prefs.getInt(REG_SENSOR_COMPENSATED_DATA, 1));
        this.Set_BT_Latency(this.prefs.getDouble(REG_SENSOR_BTLATENCY, 0.0), ConvertTool.UNITS.UNITE_US);
        this.Set_WT_XS1Speed(this.prefs.getDouble(REG_SENSOR_WTXS1SPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_WT_XS2Speed(this.prefs.getDouble(REG_SENSOR_WTXS2SPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_WT_XS3Speed(this.prefs.getDouble(REG_SENSOR_WTXS3SPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_WT_XS1SpeedStd(this.prefs.getDouble(REG_SENSOR_WTXS1SPEEDSTD, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_WT_XS2SpeedStd(this.prefs.getDouble(REG_SENSOR_WTXS2SPEEDSTD, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_WT_XS3SpeedStd(this.prefs.getDouble(REG_SENSOR_WTXS3SPEEDSTD, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_WT_SoundSpeed(this.prefs.getDouble(REG_SENSOR_WTSOUNDSPEED, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_WT_Altitude(this.prefs.getDouble(REG_SENSOR_WTALTITUDE, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_WT_Validity(this.prefs.getInt(REG_SENSOR_WTVALIDITY, 1));
        this.Set_WT_Latency(this.prefs.getDouble(REG_SENSOR_WTLATENCY, 0.0), ConvertTool.UNITS.UNITE_US);
        this.Set_BeaconCodeId(this.prefs.get(REG_SENSOR_BEACONCODEID, "TpC"));
        this.Set_BeaconNumId(this.prefs.getInt(REG_SENSOR_BEACONNUMID, 1234));
        this.Set_Range(this.prefs.getDouble(REG_SENSOR_RANGE, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_RangeStd(this.prefs.getDouble(REG_SENSOR_RANGESTD, 0.0), ConvertTool.UNITS.UNITE_M);
        this.Set_Conductivity(this.prefs.getDouble(REG_SENSOR_CONDUCTIVITY, 0.0), ConvertTool.UNITS.UNITE_S_m);
        this.Set_Temperature(this.prefs.getDouble(REG_SENSOR_TEMPERATURE, 20.0), ConvertTool.UNITS.UNITE_DEGCEL);
        this.Set_Pressure(this.prefs.getDouble(REG_SENSOR_PRESSURE, 0.0), ConvertTool.UNITS.UNITE_DBAR);
        this.Set_Salinity(this.prefs.getDouble(REG_SENSOR_SALINITY, 0.0), ConvertTool.UNITS.UNITE_PSU);
        this.Set_SoundSpeed(this.prefs.getDouble(REG_SENSOR_SOUNDSPEED, 1500.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_Deflection_Xi(this.prefs.getDouble(REG_SENSOR_DEFLECTION_XI, 0.0), ConvertTool.UNITS.UNITE_SEC_ARC);
        this.Set_Deflection_Eta(this.prefs.getDouble(REG_SENSOR_DEFLECTION_ETA, 0.0), ConvertTool.UNITS.UNITE_SEC_ARC);
        this.Set_Deviation_Norm(this.prefs.getDouble(REG_SENSOR_DEVIATION_NORM, 0.0), ConvertTool.UNITS.UNITE_MILLIGAL);
        for (int Id = 0; Id < 3; ++Id) {
            this.Set_Pos(Id, this.prefs.getDouble(REG_SENSOR_POSITION.concat(Integer.toString(Id)), 0.0), ConvertTool.UNITS.UNITE_M);
            this.Set_Orient(Id, this.prefs.getDouble(REG_SENSOR_ORIENTATION.concat(Integer.toString(Id)), 0.0), ConvertTool.UNITS.UNITE_DEGREE);
        }
        this.Set_Status(this.prefs.getInt(REG_SENSOR_STATUS, 0));
        this.Set_Roll(this.prefs.getDouble(REG_SENSOR_ROLL, 0.0), ConvertTool.UNITS.UNITE_DEGREE);
        this.Set_Pitch(this.prefs.getDouble(REG_SENSOR_PITCH, 0.0), ConvertTool.UNITS.UNITE_DEGREE);
        this.Set_Heading(this.prefs.getDouble(REG_SENSOR_HEADING, 0.0), ConvertTool.UNITS.UNITE_DEGREE);
        this.Set_Speed_North(this.prefs.getDouble(REG_STIM_SPEED_NORTH, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_Speed_East(this.prefs.getDouble(REG_STIM_SPEED_EAST, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_Speed_Up(this.prefs.getDouble(REG_STIM_SPEED_UP, 0.0), ConvertTool.UNITS.UNITE_M_S);
        this.Set_RotationRate_X(this.prefs.getDouble(REG_STIM_ROTRATE_X, 0.0), ConvertTool.UNITS.UNITE_DEGREE_PER_S);
        this.Set_RotationRate_Y(this.prefs.getDouble(REG_STIM_ROTRATE_Y, 0.0), ConvertTool.UNITS.UNITE_DEGREE_PER_S);
        this.Set_RotationRate_Z(this.prefs.getDouble(REG_STIM_ROTRATE_Z, 0.0), ConvertTool.UNITS.UNITE_DEGREE_PER_S);
        this.Set_Acceleration_X(this.prefs.getDouble(REG_STIM_ACCEL_X, 0.0), ConvertTool.UNITS.UNITE_M_S2);
        this.Set_Acceleration_Y(this.prefs.getDouble(REG_STIM_ACCEL_Y, 0.0), ConvertTool.UNITS.UNITE_M_S2);
        this.Set_Acceleration_Z(this.prefs.getDouble(REG_STIM_ACCEL_Z, 0.0), ConvertTool.UNITS.UNITE_M_S2);
        this.Set_AltitudeReference(this.prefs.getInt(REG_SENSOR_ALTITUDE_REF, 0));
        this.Set_DvlNtkId(this.prefs.getInt(REG_SENSOR_DVL_NTK_IDENTIFIER, 27));
        this.Set_DvlNtkNbOfBeams(this.prefs.getInt(REG_SENSOR_DVL_NTK_NBOFBEAMS, 4));
        this.Set_DvlNtkDistanceBeam(0, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DISTANCEBEAM_0, 0.0));
        this.Set_DvlNtkDistanceBeam(1, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DISTANCEBEAM_1, 0.0));
        this.Set_DvlNtkDistanceBeam(2, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DISTANCEBEAM_2, 0.0));
        this.Set_DvlNtkDistanceBeam(3, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DISTANCEBEAM_3, 0.0));
        this.Set_DvlNtkVelocity(0, this.prefs.getDouble(REG_SENSOR_DVL_NTK_VELOCITY_0, 0.0));
        this.Set_DvlNtkVelocity(1, this.prefs.getDouble(REG_SENSOR_DVL_NTK_VELOCITY_1, 0.0));
        this.Set_DvlNtkVelocity(2, this.prefs.getDouble(REG_SENSOR_DVL_NTK_VELOCITY_2, 0.0));
        this.Set_DvlNtkVelocity(3, this.prefs.getDouble(REG_SENSOR_DVL_NTK_VELOCITY_3, 0.0));
        this.Set_DvlNtkFOM(0, this.prefs.getDouble(REG_SENSOR_DVL_NTK_FOM_0, 0.0));
        this.Set_DvlNtkFOM(1, this.prefs.getDouble(REG_SENSOR_DVL_NTK_FOM_1, 0.0));
        this.Set_DvlNtkFOM(2, this.prefs.getDouble(REG_SENSOR_DVL_NTK_FOM_2, 0.0));
        this.Set_DvlNtkFOM(3, this.prefs.getDouble(REG_SENSOR_DVL_NTK_FOM_3, 0.0));
        this.Set_DvlNtkDT1(0, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DT1_0, 0.0));
        this.Set_DvlNtkDT1(1, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DT1_1, 0.0));
        this.Set_DvlNtkDT1(2, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DT1_2, 0.0));
        this.Set_DvlNtkDT1(3, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DT1_3, 0.0));
        this.Set_DvlNtkDT2(0, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DT2_0, 0.0));
        this.Set_DvlNtkDT2(1, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DT2_1, 0.0));
        this.Set_DvlNtkDT2(2, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DT2_2, 0.0));
        this.Set_DvlNtkDT2(3, this.prefs.getDouble(REG_SENSOR_DVL_NTK_DT2_3, 0.0));
    }

    public void Set_Validity(int _Validity) {
        this.Validity = _Validity;
        this.prefs.putInt(REG_SENSOR_VALIDITY, _Validity);
    }

    public void Set_Latitude(double _Latitude, ConvertTool.UNITS unite) {
        this.Latitude_deg = this.t.unite2deg(_Latitude, unite);
        this.prefs.putDouble(REG_SENSOR_LATITUDE, this.Latitude_deg);
    }

    public void Set_Longitude(double _Longitude, ConvertTool.UNITS unite) {
        this.Longitude_deg = this.t.unite2deg(_Longitude, unite);
        this.prefs.putDouble(REG_SENSOR_LONGITUDE, this.Longitude_deg);
    }

    public void Set_UTM_East(double _UTM_Est, ConvertTool.UNITS unite) {
        this.UTM_East_m = this.t.unite2m(_UTM_Est, unite);
        this.prefs.putDouble(REG_SENSOR_UTM_EAST, this.UTM_East_m);
    }

    public void Set_UTM_North(double _UTM_Nord, ConvertTool.UNITS unite) {
        this.UTM_North_m = this.t.unite2m(_UTM_Nord, unite);
        this.prefs.putDouble(REG_SENSOR_UTM_NORTH, this.UTM_North_m);
    }

    public void Set_UTM_Zone(String _UTM_Zone) {
        this.UTM_Zone = _UTM_Zone;
        this.prefs.put(REG_SENSOR_UTM_ZONE, this.UTM_Zone);
    }

    public void Set_Altitude(double _Altitude, ConvertTool.UNITS unite) {
        this.Altitude_m = this.t.unite2m(_Altitude, unite);
        this.prefs.putDouble(REG_SENSOR_ALTITUDE, this.Altitude_m);
    }

    public void Set_AltitudeReference(int _AltitudeRef) {
        this.AltitudeRef = _AltitudeRef;
        this.prefs.putInt(REG_SENSOR_ALTITUDE_REF, this.AltitudeRef);
    }

    public void Set_LatitudeStd(double _LatitudeStd, ConvertTool.UNITS unite) {
        this.LatitudeStd_m = this.t.unite2m(_LatitudeStd, unite);
        this.prefs.putDouble(REG_SENSOR_LATITUDESTD, this.LatitudeStd_m);
    }

    public void Set_LongitudeStd(double _LongitudeStd, ConvertTool.UNITS unite) {
        this.LongitudeStd_m = this.t.unite2m(_LongitudeStd, unite);
        this.prefs.putDouble(REG_SENSOR_LONGITUDESTD, this.LongitudeStd_m);
    }

    public void Set_AltitudeStd(double _AltitudeStd, ConvertTool.UNITS unite) {
        this.AltitudeStd_m = this.t.unite2m(_AltitudeStd, unite);
        this.prefs.putDouble(REG_SENSOR_ALTITUDESTD, this.AltitudeStd_m);
    }

    public void Set_LatLongCov(double _LatLongCov, ConvertTool.UNITS unite) {
        this.LatLongCov_m = this.t.unite2m(_LatLongCov, unite);
        this.prefs.putDouble(REG_SENSOR_LATLONGCOV, this.LatLongCov_m);
    }

    public void Set_EllipseMajorAxis(double _MajorAxis, ConvertTool.UNITS unite) {
        this.EllipseMajorAxis_m = this.t.unite2m(_MajorAxis, unite);
        this.prefs.putDouble(REG_SENSOR_ELLIPSEMAJORAXIS, this.EllipseMajorAxis_m);
    }

    public void Set_EllipseMinorAxis(double _MinorAxis, ConvertTool.UNITS unite) {
        this.EllipseMinorAxis_m = this.t.unite2m(_MinorAxis, unite);
        this.prefs.putDouble(REG_SENSOR_ELLIPSEMINORAXIS, this.EllipseMinorAxis_m);
    }

    public void Set_EllipseAngle(double _Angle, ConvertTool.UNITS unite) {
        this.EllipseAngle_d = this.t.unite2deg(_Angle, unite);
        this.prefs.putDouble(REG_SENSOR_ELLIPSEANGLE, this.EllipseAngle_d);
    }

    public void Set_Latency(double _Latency, ConvertTool.UNITS unite) {
        this.Latency_us = this.t.unite2us(_Latency, unite);
        this.prefs.putDouble(REG_SENSOR_LATENCY, this.Latency_us);
    }

    public void Set_GeoidalSep(double _GeoidalSep, ConvertTool.UNITS unite) {
        this.GeoidalSep_m = this.t.unite2m(_GeoidalSep, unite);
        this.prefs.putDouble(REG_SENSOR_GEOIDALSEP, this.GeoidalSep_m);
    }

    public void Set_Quality(int _Quality) {
        this.Quality = _Quality;
        this.prefs.putInt(REG_SENSOR_QUALITY, _Quality);
    }

    public void Set_Id(int Id) {
        this.Id = Id;
        this.prefs.putInt(REG_SENSOR_ID, Id);
    }

    public void Set_OperatingMode(int _OperatingMode) {
        this.OperatingMode = _OperatingMode;
        this.prefs.putInt(REG_OPERATING_MODE, _OperatingMode);
    }

    public void Set_CoordinateVelocities(int _CoordinateVelocities) {
        this.CoordinateVelocities = _CoordinateVelocities;
        this.prefs.putInt(REG_SENSOR_COORDINATEVELOCITIES, _CoordinateVelocities);
    }

    public void Set_Course(double _Course, ConvertTool.UNITS unite) {
        this.Course_deg = this.t.unite2deg(_Course, unite);
        this.prefs.putDouble(REG_SENSOR_COURSE, this.Course_deg);
    }

    public void Set_Speed(double _Speed, ConvertTool.UNITS unite) {
        this.Speed_ms = this.t.unite2MS(_Speed, unite);
        this.prefs.putDouble(REG_SENSOR_SPEED, this.Speed_ms);
    }

    public void Set_BeaconCodeId(String _BeaconCodeId) {
        this.BeaconCodeId = _BeaconCodeId;
        this.prefs.put(REG_SENSOR_BEACONCODEID, _BeaconCodeId);
    }

    public void Set_BeaconNumId(int _BeaconNumId) {
        this.BeaconNumId = _BeaconNumId;
        this.prefs.putInt(REG_SENSOR_BEACONNUMID, _BeaconNumId);
    }

    public void Set_Depth(double _Depth, ConvertTool.UNITS unite) {
        this.Depth_m = this.t.unite2m(_Depth, unite);
        this.prefs.putDouble(REG_SENSOR_DEPTH, this.Depth_m);
    }

    public void Set_DepthStd(double _DepthStd, ConvertTool.UNITS unite) {
        this.DepthStd_m = this.t.unite2m(_DepthStd, unite);
        this.prefs.putDouble(REG_SENSOR_DEPTHSTD, this.DepthStd_m);
    }

    public void Set_Range(double _Range, ConvertTool.UNITS unite) {
        this.Range_m = this.t.unite2m(_Range, unite);
        this.prefs.putDouble(REG_SENSOR_RANGE, this.Range_m);
    }

    public void Set_RangeStd(double _RangeStd, ConvertTool.UNITS unite) {
        this.RangeStd_m = this.t.unite2m(_RangeStd, unite);
        this.prefs.putDouble(REG_SENSOR_RANGESTD, this.RangeStd_m);
    }

    public void Set_SoundSpeed(double _SoundSpeed, ConvertTool.UNITS unite) {
        this.SoundSpeed_m_s = this.t.unite2MS(_SoundSpeed, unite);
        this.prefs.putDouble(REG_SENSOR_SOUNDSPEED, this.SoundSpeed_m_s);
    }

    public void Set_BT_XS1Speed(double _BT_XS1Speed, ConvertTool.UNITS unite) {
        this.BT_XS1Speed_m_s = this.t.unite2MS(_BT_XS1Speed, unite);
        this.prefs.putDouble(REG_SENSOR_BTXS1SPEED, this.BT_XS1Speed_m_s);
    }

    public void Set_BT_XS2Speed(double _BT_XS2Speed, ConvertTool.UNITS unite) {
        this.BT_XS2Speed_m_s = this.t.unite2MS(_BT_XS2Speed, unite);
        this.prefs.putDouble(REG_SENSOR_BTXS2SPEED, this.BT_XS2Speed_m_s);
    }

    public void Set_BT_XS3Speed(double _BT_XS3Speed, ConvertTool.UNITS unite) {
        this.BT_XS3Speed_m_s = this.t.unite2MS(_BT_XS3Speed, unite);
        this.prefs.putDouble(REG_SENSOR_BTXS3SPEED, this.BT_XS3Speed_m_s);
    }

    public void Set_BT_XS1SpeedStd(double _BT_XS1SpeedStd, ConvertTool.UNITS unite) {
        this.BT_XS1SpeedStd_m_s = this.t.unite2MS(_BT_XS1SpeedStd, unite);
        this.prefs.putDouble(REG_SENSOR_BTXS1SPEEDSTD, this.BT_XS1SpeedStd_m_s);
    }

    public void Set_BT_XS2SpeedStd(double _BT_XS2SpeedStd, ConvertTool.UNITS unite) {
        this.BT_XS2SpeedStd_m_s = this.t.unite2MS(_BT_XS2SpeedStd, unite);
        this.prefs.putDouble(REG_SENSOR_BTXS2SPEEDSTD, this.BT_XS2SpeedStd_m_s);
    }

    public void Set_BT_XS3SpeedStd(double _BT_XS3SpeedStd, ConvertTool.UNITS unite) {
        this.BT_XS3SpeedStd_m_s = this.t.unite2MS(_BT_XS3SpeedStd, unite);
        this.prefs.putDouble(REG_SENSOR_BTXS3SPEEDSTD, this.BT_XS3SpeedStd_m_s);
    }

    public void Set_BT_SoundSpeed(double _BT_SoundSpeed, ConvertTool.UNITS unite) {
        this.BT_SoundSpeed_m_s = this.t.unite2MS(_BT_SoundSpeed, unite);
        this.prefs.putDouble(REG_SENSOR_BTSOUNDSPEED, this.BT_SoundSpeed_m_s);
    }

    public void Set_BT_Altitude(double _BT_Altitude, ConvertTool.UNITS unite) {
        this.BT_Altitude_m = this.t.unite2m(_BT_Altitude, unite);
        this.prefs.putDouble(REG_SENSOR_BTALTITUDE, this.BT_Altitude_m);
    }

    public void Set_BT_Validity(int _BT_Validity) {
        this.BT_Validity = _BT_Validity;
        this.prefs.putInt(REG_SENSOR_BTVALIDITY, _BT_Validity);
    }

    public void Set_CompensatedData(int _Type) {
        this.CompensatedData = _Type;
        this.prefs.putInt(REG_SENSOR_COMPENSATED_DATA, _Type);
    }

    public void Set_BT_Latency(double _BT_Latency, ConvertTool.UNITS unite) {
        this.BT_Latency_us = this.t.unite2us(_BT_Latency, unite);
        this.prefs.putDouble(REG_SENSOR_BTLATENCY, this.BT_Latency_us);
    }

    public void Set_WT_XS1Speed(double _WT_XS1Speed, ConvertTool.UNITS unite) {
        this.WT_XS1Speed_m_s = this.t.unite2MS(_WT_XS1Speed, unite);
        this.prefs.putDouble(REG_SENSOR_WTXS1SPEED, this.WT_XS1Speed_m_s);
    }

    public void Set_WT_XS2Speed(double _WT_XS2Speed, ConvertTool.UNITS unite) {
        this.WT_XS2Speed_m_s = this.t.unite2MS(_WT_XS2Speed, unite);
        this.prefs.putDouble(REG_SENSOR_WTXS2SPEED, this.WT_XS2Speed_m_s);
    }

    public void Set_WT_XS3Speed(double _WT_XS3Speed, ConvertTool.UNITS unite) {
        this.WT_XS3Speed_m_s = this.t.unite2MS(_WT_XS3Speed, unite);
        this.prefs.putDouble(REG_SENSOR_WTXS3SPEED, this.WT_XS3Speed_m_s);
    }

    public void Set_WT_XS1SpeedStd(double _WT_XS1SpeedStd, ConvertTool.UNITS unite) {
        this.WT_XS1SpeedStd_m_s = this.t.unite2MS(_WT_XS1SpeedStd, unite);
        this.prefs.putDouble(REG_SENSOR_WTXS1SPEEDSTD, this.WT_XS1SpeedStd_m_s);
    }

    public void Set_WT_XS2SpeedStd(double _WT_XS2SpeedStd, ConvertTool.UNITS unite) {
        this.WT_XS2SpeedStd_m_s = this.t.unite2MS(_WT_XS2SpeedStd, unite);
        this.prefs.putDouble(REG_SENSOR_WTXS2SPEEDSTD, this.WT_XS2SpeedStd_m_s);
    }

    public void Set_WT_XS3SpeedStd(double _WT_XS3SpeedStd, ConvertTool.UNITS unite) {
        this.WT_XS3SpeedStd_m_s = this.t.unite2MS(_WT_XS3SpeedStd, unite);
        this.prefs.putDouble(REG_SENSOR_WTXS3SPEEDSTD, this.WT_XS3SpeedStd_m_s);
    }

    public void Set_WT_SoundSpeed(double _WT_SoundSpeed, ConvertTool.UNITS unite) {
        this.WT_SoundSpeed_m_s = this.t.unite2MS(_WT_SoundSpeed, unite);
        this.prefs.putDouble(REG_SENSOR_WTSOUNDSPEED, this.WT_SoundSpeed_m_s);
    }

    public void Set_WT_Altitude(double _WT_Altitude, ConvertTool.UNITS unite) {
        this.WT_Altitude_m = this.t.unite2m(_WT_Altitude, unite);
        this.prefs.putDouble(REG_SENSOR_WTALTITUDE, this.WT_Altitude_m);
    }

    public void Set_WT_Validity(int _WT_Validity) {
        this.WT_Validity = _WT_Validity;
        this.prefs.putInt(REG_SENSOR_WTVALIDITY, _WT_Validity);
    }

    public void Set_WT_Latency(double _WT_Latency, ConvertTool.UNITS unite) {
        this.WT_Latency_us = this.t.unite2us(_WT_Latency, unite);
        this.prefs.putDouble(REG_SENSOR_WTLATENCY, this.WT_Latency_us);
    }

    public void Set_LongWaterSpeed(double _LongWaterSpeed, ConvertTool.UNITS unite) {
        this.LongWaterSpeed_m_s = this.t.unite2MS(_LongWaterSpeed, unite);
        this.prefs.putDouble(REG_SENSOR_LONGWATERSPEED, this.LongWaterSpeed_m_s);
    }

    public void Set_TransWaterSpeed(double _TransWaterSpeed, ConvertTool.UNITS unite) {
        this.TransWaterSpeed_m_s = this.t.unite2MS(_TransWaterSpeed, unite);
        this.prefs.putDouble(REG_SENSOR_TRANSWATERSPEED, this.TransWaterSpeed_m_s);
    }

    public void Set_LongWaterSpeedStd(double _LongWaterSpeedStd, ConvertTool.UNITS unite) {
        this.LongWaterSpeedStd_m_s = this.t.unite2MS(_LongWaterSpeedStd, unite);
        this.prefs.putDouble(REG_SENSOR_LONGWATERSPEEDSTD, this.LongWaterSpeedStd_m_s);
    }

    public void Set_LongGroundSpeed(double _LongGroundSpeed, ConvertTool.UNITS unite) {
        this.LongGroundSpeed_m_s = this.t.unite2MS(_LongGroundSpeed, unite);
        this.prefs.putDouble(REG_SENSOR_LONGGROUNDSPEED, this.LongGroundSpeed_m_s);
    }

    public void Set_TransGroundSpeed(double _TransGroundSpeed, ConvertTool.UNITS unite) {
        this.TransGroundSpeed_m_s = this.t.unite2MS(_TransGroundSpeed, unite);
        this.prefs.putDouble(REG_SENSOR_TRANSGROUNDSPEED, this.TransGroundSpeed_m_s);
    }

    public void Set_Conductivity(double _Conductivity, ConvertTool.UNITS unite) {
        this.Conductivity_s_m = this.t.unite2s_m(_Conductivity, unite);
        this.prefs.putDouble(REG_SENSOR_CONDUCTIVITY, this.Conductivity_s_m);
    }

    public void Set_Temperature(double _Temperature, ConvertTool.UNITS unite) {
        this.Temperature_degcel = this.t.unite2degcel(_Temperature, unite);
        this.prefs.putDouble(REG_SENSOR_TEMPERATURE, this.Temperature_degcel);
    }

    public void Set_Pressure(double _Pressure, ConvertTool.UNITS unite) {
        this.Pressure_dbar = this.t.unite2dbar(_Pressure, unite);
        this.prefs.putDouble(REG_SENSOR_PRESSURE, this.Pressure_dbar);
    }

    public void Set_Salinity(double _Salinity, ConvertTool.UNITS unite) {
        this.Salinity_psu = this.t.unite2psu(_Salinity, unite);
        this.prefs.putDouble(REG_SENSOR_SALINITY, this.Salinity_psu);
    }

    public void Set_MajorAxis(double _MajorAxis) {
        this.MajorAxis = _MajorAxis;
        this.prefs.putDouble(REG_SENSOR_ELLIPSEMAJORAXIS, _MajorAxis);
    }

    public void Set_MinorAxis(double _MinorAxis) {
        this.MinorAxis = _MinorAxis;
        this.prefs.putDouble(REG_SENSOR_ELLIPSEMINORAXIS, _MinorAxis);
    }

    public void Set_MajorAxisDir(double _MajorAxisDir, ConvertTool.UNITS unite) {
        this.MajorAxisDir_deg = this.t.unite2deg(_MajorAxisDir, unite);
        this.prefs.putDouble(REG_SENSOR_ELLIPSEANGLE, _MajorAxisDir);
    }

    public void Set_PulseCount(double _PulseCount) {
        this.PulseCount = _PulseCount;
        this.prefs.putDouble(REG_SENSOR_PULSECOUNT, this.PulseCount);
    }

    public void Set_Deflection_Xi(double _Xi, ConvertTool.UNITS unite) {
        this.Deflection_Xi_secarc = _Xi;
        this.prefs.putDouble(REG_SENSOR_DEFLECTION_XI, _Xi);
    }

    public void Set_Deflection_Eta(double _Eta, ConvertTool.UNITS unite) {
        this.Deflection_Eta_secarc = _Eta;
        this.prefs.putDouble(REG_SENSOR_DEFLECTION_ETA, _Eta);
    }

    public void Set_Deviation_Norm(double _Norm, ConvertTool.UNITS unite) {
        this.Deviation_Norm_milligal = _Norm;
        this.prefs.putDouble(REG_SENSOR_DEVIATION_NORM, _Norm);
    }

    public void Set_Pos(int Id, double _Pos, ConvertTool.UNITS unite) {
        this.Pos[Id] = this.t.unite2m(_Pos, unite);
        this.prefs.putDouble(REG_SENSOR_POSITION.concat(Integer.toString(Id)), this.Pos[Id]);
    }

    public void Set_Orient(int Id, double _Orient, ConvertTool.UNITS unite) {
        this.Orient[Id] = this.t.unite2deg(_Orient, unite);
        this.prefs.putDouble(REG_SENSOR_ORIENTATION.concat(Integer.toString(Id)), this.Orient[Id]);
    }

    public void Set_Status(int _Status) {
        this.Status = _Status;
        this.prefs.putInt(REG_SENSOR_STATUS, this.Status);
    }

    public void Set_Roll(double _Roll, ConvertTool.UNITS unite) {
        this.Roll_deg = this.t.unite2deg(_Roll, unite);
        this.prefs.putDouble(REG_SENSOR_ROLL, this.Roll_deg);
    }

    public void Set_Pitch(double _Pitch, ConvertTool.UNITS unite) {
        this.Pitch_deg = this.t.unite2deg(_Pitch, unite);
        this.prefs.putDouble(REG_SENSOR_PITCH, this.Pitch_deg);
    }

    public void Set_Heading(double _Heading, ConvertTool.UNITS unite) {
        this.Heading_deg = this.t.unite2deg(_Heading, unite);
        this.prefs.putDouble(REG_SENSOR_HEADING, this.Heading_deg);
    }

    public void Set_Speed_North(double _SpeedNorth, ConvertTool.UNITS unite) {
        this.SpeedNorth_m_s = _SpeedNorth;
        this.prefs.putDouble(REG_STIM_SPEED_NORTH, this.SpeedNorth_m_s);
    }

    public void Set_Speed_East(double _SpeedEast, ConvertTool.UNITS unite) {
        this.SpeedEast_m_s = _SpeedEast;
        this.prefs.putDouble(REG_STIM_SPEED_EAST, this.SpeedEast_m_s);
    }

    public void Set_Speed_Up(double _SpeedUp, ConvertTool.UNITS unite) {
        this.SpeedUp_m_s = _SpeedUp;
        this.prefs.putDouble(REG_STIM_SPEED_UP, this.SpeedUp_m_s);
    }

    public double Get_Speed_North(ConvertTool.UNITS unite) {
        return this.SpeedNorth_m_s;
    }

    public double Get_Speed_East(ConvertTool.UNITS unite) {
        return this.SpeedEast_m_s;
    }

    public double Get_Speed_Up(ConvertTool.UNITS unite) {
        return this.SpeedUp_m_s;
    }

    public void Set_RotationRate_X(double _RotRateX, ConvertTool.UNITS unite) {
        this.RotRateX_deg_s = _RotRateX;
        this.prefs.putDouble(REG_STIM_ROTRATE_X, this.RotRateX_deg_s);
    }

    public void Set_RotationRate_Y(double _RotRateY, ConvertTool.UNITS unite) {
        this.RotRateY_deg_s = _RotRateY;
        this.prefs.putDouble(REG_STIM_ROTRATE_Y, this.RotRateY_deg_s);
    }

    public void Set_RotationRate_Z(double _RotRateZ, ConvertTool.UNITS unite) {
        this.RotRateZ_deg_s = _RotRateZ;
        this.prefs.putDouble(REG_STIM_ROTRATE_Z, this.RotRateZ_deg_s);
    }

    public double Get_RotationRate_X(ConvertTool.UNITS unite) {
        return this.RotRateX_deg_s;
    }

    public double Get_RotationRate_Y(ConvertTool.UNITS unite) {
        return this.RotRateY_deg_s;
    }

    public double Get_RotationRate_Z(ConvertTool.UNITS unite) {
        return this.RotRateZ_deg_s;
    }

    public void Set_Acceleration_X(double _AccelX, ConvertTool.UNITS unite) {
        this.AccelX_m_s2 = _AccelX;
        this.prefs.putDouble(REG_STIM_ACCEL_X, this.AccelX_m_s2);
    }

    public void Set_Acceleration_Y(double _AccelY, ConvertTool.UNITS unite) {
        this.AccelY_m_s2 = _AccelY;
        this.prefs.putDouble(REG_STIM_ACCEL_Y, this.AccelY_m_s2);
    }

    public void Set_Acceleration_Z(double _AccelZ, ConvertTool.UNITS unite) {
        this.AccelZ_m_s2 = _AccelZ;
        this.prefs.putDouble(REG_STIM_ACCEL_Z, this.AccelZ_m_s2);
    }

    public double Get_Acceleration_X(ConvertTool.UNITS unite) {
        return this.AccelX_m_s2;
    }

    public double Get_Acceleration_Y(ConvertTool.UNITS unite) {
        return this.AccelY_m_s2;
    }

    public double Get_Acceleration_Z(ConvertTool.UNITS unite) {
        return this.AccelZ_m_s2;
    }

    public int Get_Id() {
        return this.Id;
    }

    public double GetHeading(ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.Heading_deg, unite);
    }

    public double GetRoll(ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.Roll_deg, unite);
    }

    public double GetPitch(ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.Pitch_deg, unite);
    }

    public int Get_Validity() {
        return this.Validity;
    }

    public double Get_Latitude(ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.Latitude_deg, unite);
    }

    public double Get_Longitude(ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.Longitude_deg, unite);
    }

    public double Get_UTM_East(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.UTM_East_m, unite);
    }

    public double Get_UTM_North(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.UTM_North_m, unite);
    }

    public String Get_UTM_Zone() {
        return this.UTM_Zone;
    }

    public double Get_Altitude(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.Altitude_m, unite);
    }

    public int Get_AltitudeReference() {
        return this.AltitudeRef;
    }

    public double Get_LatitudeStd(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.LatitudeStd_m, unite);
    }

    public double Get_LongitudeStd(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.LongitudeStd_m, unite);
    }

    public double Get_AltitudeStd(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.AltitudeStd_m, unite);
    }

    public double Get_LatLongCov(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.LatLongCov_m, unite);
    }

    public double Get_EllipseMajorAxis(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.EllipseMajorAxis_m, unite);
    }

    public double Get_EllipseMinorAxis(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.EllipseMinorAxis_m, unite);
    }

    public double Get_EllipseAngle(ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.EllipseAngle_d, unite);
    }

    public double Get_Latency(ConvertTool.UNITS unite) {
        return this.t.us2unite(this.Latency_us, unite);
    }

    public double Get_GeoidalSep(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.GeoidalSep_m, unite);
    }

    public int Get_Quality() {
        return this.Quality;
    }

    public int Get_OperatingMode() {
        return this.OperatingMode;
    }

    public double Get_Course(ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.Course_deg, unite);
    }

    public double Get_Speed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.Speed_ms, unite);
    }

    public String Get_BeaconCodeId() {
        return this.BeaconCodeId;
    }

    public int Get_BeaconNumId() {
        return this.BeaconNumId;
    }

    public double Get_Depth(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.Depth_m, unite);
    }

    public double Get_DepthStd(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.DepthStd_m, unite);
    }

    public double Get_Range(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.Range_m, unite);
    }

    public double Get_RangeStd(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.RangeStd_m, unite);
    }

    public double Get_SoundSpeed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.SoundSpeed_m_s, unite);
    }

    public int Get_CoordinateVelocities() {
        return this.CoordinateVelocities;
    }

    public double Get_BT_XS1Speed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.BT_XS1Speed_m_s, unite);
    }

    public double Get_BT_XS2Speed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.BT_XS2Speed_m_s, unite);
    }

    public double Get_BT_XS3Speed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.BT_XS3Speed_m_s, unite);
    }

    public double Get_BT_XS1SpeedStd(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.BT_XS1SpeedStd_m_s, unite);
    }

    public double Get_BT_XS2SpeedStd(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.BT_XS2SpeedStd_m_s, unite);
    }

    public double Get_BT_XS3SpeedStd(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.BT_XS3SpeedStd_m_s, unite);
    }

    public double Get_BT_SoundSpeed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.BT_SoundSpeed_m_s, unite);
    }

    public double Get_BT_Altitude(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.BT_Altitude_m, unite);
    }

    public int Get_BT_Validity() {
        return this.BT_Validity;
    }

    public int Get_CompensatedData() {
        return this.CompensatedData;
    }

    public double Get_PulseCount() {
        return this.PulseCount;
    }

    public double Get_BT_Latency(ConvertTool.UNITS unite) {
        return this.t.us2unite(this.BT_Latency_us, unite);
    }

    public double Get_WT_XS1Speed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.WT_XS1Speed_m_s, unite);
    }

    public double Get_WT_XS2Speed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.WT_XS2Speed_m_s, unite);
    }

    public double Get_WT_XS3Speed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.WT_XS3Speed_m_s, unite);
    }

    public double Get_WT_XS1SpeedStd(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.WT_XS1SpeedStd_m_s, unite);
    }

    public double Get_WT_XS2SpeedStd(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.WT_XS2SpeedStd_m_s, unite);
    }

    public double Get_WT_XS3SpeedStd(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.WT_XS3SpeedStd_m_s, unite);
    }

    public double Get_WT_SoundSpeed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.WT_SoundSpeed_m_s, unite);
    }

    public double Get_WT_Altitude(ConvertTool.UNITS unite) {
        return this.t.m2unite(this.WT_Altitude_m, unite);
    }

    public int Get_WT_Validity() {
        return this.WT_Validity;
    }

    public double Get_WT_Latency(ConvertTool.UNITS unite) {
        return this.t.us2unite(this.WT_Latency_us, unite);
    }

    public double Get_LongWaterSpeed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.LongWaterSpeed_m_s, unite);
    }

    public double Get_LongWaterSpeedStd(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.LongWaterSpeedStd_m_s, unite);
    }

    public double Get_TransWaterSpeed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.TransWaterSpeed_m_s, unite);
    }

    public double Get_LongGroundSpeed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.LongGroundSpeed_m_s, unite);
    }

    public double Get_TransGroundSpeed(ConvertTool.UNITS unite) {
        return this.t.MS2unite(this.TransGroundSpeed_m_s, unite);
    }

    public double Get_Conductivity(ConvertTool.UNITS unite) {
        return this.t.s_m2unite(this.Conductivity_s_m, unite);
    }

    public double Get_Temperature(ConvertTool.UNITS unite) {
        return this.t.degcel2unite(this.Temperature_degcel, unite);
    }

    public double Get_Pressure(ConvertTool.UNITS unite) {
        return this.t.dbar2unite(this.Pressure_dbar, unite);
    }

    public double Get_Salinity(ConvertTool.UNITS unite) {
        return this.t.psu2unite(this.Salinity_psu, unite);
    }

    public double Get_MajorAxis() {
        return this.MajorAxis;
    }

    public double Get_MinorAxis() {
        return this.MinorAxis;
    }

    public double Get_MajorAxisDir(ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.MajorAxisDir_deg, unite);
    }

    public double Get_Deflection_Xi(ConvertTool.UNITS unite) {
        return this.Deflection_Xi_secarc;
    }

    public double Get_Deflection_Eta(ConvertTool.UNITS unite) {
        return this.Deflection_Eta_secarc;
    }

    public double Get_Deviation_Norm(ConvertTool.UNITS unite) {
        return this.Deviation_Norm_milligal;
    }

    public double Get_Pos(int Id, ConvertTool.UNITS unite) {
        return this.t.m2unite(this.Pos[Id], unite);
    }

    public double Get_Orient(int Id, ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.Orient[Id], unite);
    }

    public int Get_Status() {
        return this.Status;
    }

    public double Get_Heading(ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.Heading_deg, unite);
    }

    public double Get_Roll(ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.Roll_deg, unite);
    }

    public double Get_Pitch(ConvertTool.UNITS unite) {
        return this.t.deg2unite(this.Pitch_deg, unite);
    }

    public void Set_DvlNtkId(int _DvlId) {
        this.DvlNtk_Id = _DvlId;
        this.prefs.putInt(REG_SENSOR_DVL_NTK_IDENTIFIER, this.DvlNtk_Id);
    }

    public int Get_DvlNtkId() {
        return this.DvlNtk_Id;
    }

    public void Set_DvlNtkNbOfBeams(int _NbOfBeam) {
        this.DvlNtk_NbOfBeam = _NbOfBeam;
        this.prefs.putInt(REG_SENSOR_DVL_NTK_NBOFBEAMS, this.DvlNtk_NbOfBeam);
    }

    public int Get_DvlNtkNbOfBeams() {
        return this.DvlNtk_NbOfBeam;
    }

    public void Set_DvlNtkDistanceBeam(int _BeamId, double _Distance) {
        String sString;
        this.DvlNtk_DistanceBeam[_BeamId] = _Distance;
        switch (_BeamId) {
            default: {
                sString = REG_SENSOR_DVL_NTK_DISTANCEBEAM_0;
                break;
            }
            case 1: {
                sString = REG_SENSOR_DVL_NTK_DISTANCEBEAM_1;
                break;
            }
            case 2: {
                sString = REG_SENSOR_DVL_NTK_DISTANCEBEAM_2;
                break;
            }
            case 3: {
                sString = REG_SENSOR_DVL_NTK_DISTANCEBEAM_3;
            }
        }
        this.prefs.putDouble(sString, this.DvlNtk_DistanceBeam[_BeamId]);
    }

    public double Get_DvlNtkDistanceBeam(int _BeamId) {
        return this.DvlNtk_DistanceBeam[_BeamId];
    }

    public void Set_DvlNtkVelocity(int _AxisId, double _Velocity) {
        String sString;
        switch (_AxisId) {
            default: {
                sString = REG_SENSOR_DVL_NTK_VELOCITY_0;
                break;
            }
            case 1: {
                sString = REG_SENSOR_DVL_NTK_VELOCITY_1;
                break;
            }
            case 2: {
                sString = REG_SENSOR_DVL_NTK_VELOCITY_2;
                break;
            }
            case 3: {
                sString = REG_SENSOR_DVL_NTK_VELOCITY_3;
            }
        }
        this.DvlNtk_VelocityAxis[_AxisId] = _Velocity;
        this.prefs.putDouble(sString, this.DvlNtk_VelocityAxis[_AxisId]);
    }

    public double Get_DvlNtkVelocity(int _AxisId) {
        return this.DvlNtk_VelocityAxis[_AxisId];
    }

    public void Set_DvlNtkFOM(int _AxisId, double _FOM) {
        String sString;
        switch (_AxisId) {
            default: {
                sString = REG_SENSOR_DVL_NTK_FOM_0;
                break;
            }
            case 1: {
                sString = REG_SENSOR_DVL_NTK_FOM_1;
                break;
            }
            case 2: {
                sString = REG_SENSOR_DVL_NTK_FOM_2;
                break;
            }
            case 3: {
                sString = REG_SENSOR_DVL_NTK_FOM_3;
            }
        }
        this.DvlNtk_FOMAxis[_AxisId] = _FOM;
        this.prefs.putDouble(sString, this.DvlNtk_FOMAxis[_AxisId]);
    }

    public double Get_DvlNtkFOM(int _AxisId) {
        return this.DvlNtk_FOMAxis[_AxisId];
    }

    public void Set_DvlNtkDT1(int _AxisId, double _DT1) {
        String sString;
        this.DvlNtk_DT1Axis[_AxisId] = _DT1;
        switch (_AxisId) {
            default: {
                sString = REG_SENSOR_DVL_NTK_DT1_0;
                break;
            }
            case 1: {
                sString = REG_SENSOR_DVL_NTK_DT1_1;
                break;
            }
            case 2: {
                sString = REG_SENSOR_DVL_NTK_DT1_2;
                break;
            }
            case 3: {
                sString = REG_SENSOR_DVL_NTK_DT1_3;
            }
        }
        this.prefs.putDouble(sString, this.DvlNtk_DT1Axis[_AxisId]);
    }

    public double Get_DvlNtkDT1(int _AxisId) {
        return this.DvlNtk_DT1Axis[_AxisId];
    }

    public void Set_DvlNtkDT2(int _AxisId, double _DT2) {
        String sString;
        this.DvlNtk_DT2Axis[_AxisId] = _DT2;
        switch (_AxisId) {
            default: {
                sString = REG_SENSOR_DVL_NTK_DT2_0;
                break;
            }
            case 1: {
                sString = REG_SENSOR_DVL_NTK_DT2_1;
                break;
            }
            case 2: {
                sString = REG_SENSOR_DVL_NTK_DT2_2;
                break;
            }
            case 3: {
                sString = REG_SENSOR_DVL_NTK_DT2_3;
            }
        }
        this.prefs.putDouble(sString, this.DvlNtk_DT2Axis[_AxisId]);
    }

    public double Get_DvlNtkDT2(int _AxisId) {
        return this.DvlNtk_DT2Axis[_AxisId];
    }
}

