/*
 * Decompiled with CFR 0.152.
 */
package SimulatorPackage;

import EncoderPackage.ProtocolEncoder;
import EncoderPackage.Protocol_AHRS_120_Encoder;
import EncoderPackage.Protocol_APOS_PSIMLBP_Encoder;
import EncoderPackage.Protocol_APOS_PSIMSSB_Encoder;
import EncoderPackage.Protocol_AUVG3000_Encoder;
import EncoderPackage.Protocol_BAE_Encoder;
import EncoderPackage.Protocol_DCN_STD_LOCH_Encoder;
import EncoderPackage.Protocol_DCN_STD_NAV1_Encoder;
import EncoderPackage.Protocol_DVL_Commands_Encoder;
import EncoderPackage.Protocol_DVL_VBW_Encoder;
import EncoderPackage.Protocol_EIVA_Encoder;
import EncoderPackage.Protocol_EXT_SENSOR_BIN_Encoder;
import EncoderPackage.Protocol_GPS_Encoder;
import EncoderPackage.Protocol_GRAVIMETRY_Encoder;
import EncoderPackage.Protocol_GSM_3000_Encoder;
import EncoderPackage.Protocol_HEXAPOD_Encoder;
import EncoderPackage.Protocol_INRMC_Encoder;
import EncoderPackage.Protocol_IXBLUE_STD_BIN_Encoder;
import EncoderPackage.Protocol_IXSEA_AUV_Encoder;
import EncoderPackage.Protocol_IXSEA_USBL_INS_Encoder;
import EncoderPackage.Protocol_MICRO_SVT_P_Encoder;
import EncoderPackage.Protocol_MINI_SVS_Encoder;
import EncoderPackage.Protocol_Minifog_Gps_Msg_Encoder;
import EncoderPackage.Protocol_NORTEK_DF21_22_Encoder;
import EncoderPackage.Protocol_None_Encoder;
import EncoderPackage.Protocol_ODOMETER_Encoder;
import EncoderPackage.Protocol_PAROSCIENTIFIC_Encoder;
import EncoderPackage.Protocol_POSIDONIA_Encoder;
import EncoderPackage.Protocol_PRESSURE_SENSOR_Encoder;
import EncoderPackage.Protocol_RAMSES_POSTPRO_Encoder;
import EncoderPackage.Protocol_RDI_PD0_Encoder;
import EncoderPackage.Protocol_RDI_PD3_Encoder;
import EncoderPackage.Protocol_RDI_PD4_Encoder;
import EncoderPackage.Protocol_RDI_PD6_Encoder;
import EncoderPackage.Protocol_SBE37_Encoder;
import EncoderPackage.Protocol_SBE49_Encoder;
import EncoderPackage.Protocol_SEAKING_700_Encoder;
import EncoderPackage.Protocol_SOC_AUTOSUB_Encoder;
import EncoderPackage.Protocol_SVP70_Encoder;
import EncoderPackage.Protocol_SVX2_Encoder;
import EncoderPackage.Protocol_TERPS8000_Encoder;
import EncoderPackage.Protocol_TRS_AHRS_Encoder;
import EncoderPackage.Protocol_USBL_BOX_POSTPRO_Encoder;
import EncoderPackage.Protocol_USBL_LBL_CTD_Encoder;
import EncoderPackage.Protocol_VBW_VHW_Encoder;
import InfosPackage.ExternalSensorInfo;
import InfosPackage.OutputFlowInfo;
import InfosPackage.SimulatorInfo;
import SimulatorPackage.Protocols_List;
import SimulatorPackage.SimulatorDisplay;
import SimulatorPackage.SimulatorManager;
import SimulatorPackage.SimulatorScrambler;
import Tools.ConvertTool;
import Tools.JTextFieldFilter;
import Tools.LightPanel;
import Tools.TimeTool;
import gnu.io.CommPortIdentifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SimulatorFrame
extends JFrame {
    private static SimulatorManager Manager = null;
    SimulatorInfo Info;
    Timer ManagerTimer = null;
    public static SimulatorDisplay Display = null;
    public static LightPanel Light = null;
    private Protocols_List Proto_List;
    private ProtocolEncoder[] OutputEncoder;
    Boolean IsInitialized = false;
    Boolean IsDisplayEnabled = false;
    int PaneIndexPrec = 14;
    JButton[] jButton_ConnectOutputList;
    JCheckBox[] jCheckBoxFrameEnableList;
    JCheckBox[] jCheckBoxOptionsList;
    private static final int TAB_OUTPUT = 0;
    private static final int TAB_PROTO = 1;
    private static final int TAB_GPS = 2;
    private static final int TAB_DVL = 3;
    private static final int TAB_DVL_NTK = 4;
    private static final int TAB_USBL = 5;
    private static final int TAB_LBL = 6;
    private static final int TAB_DEPTH = 7;
    private static final int TAB_EMLOG = 8;
    private static final int TAB_CTD = 9;
    private static final int TAB_GRAVI = 10;
    private static final int TAB_PLATFORM = 11;
    private static final int TAB_DMI = 12;
    private static final int TAB_STIM = 13;
    private static final int TAB_CONTROL = 14;
    public static final int MESSAGE_OUTPUT = 0;
    public static final int VOYANT_OUTPUT = 0;
    public static JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton13;
    private JButton jButton14;
    private JButton jButton15;
    private JButton jButton16;
    public static JButton jButton2;
    public static JButton jButton3;
    public static JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    public static JButton jButton_ConnectOutput1;
    public static JButton jButton_ConnectOutput2;
    public static JButton jButton_ConnectOutput3;
    public static JButton jButton_ConnectOutput4;
    public static JButton jButton_ConnectOutput5;
    public static JButton jButton_ConnectOutput6;
    public static JButton jButton_ConnectOutput7;
    public static JButton jButton_InitDisplay;
    public static JCheckBox jCheckBoxActivateSimStim;
    public static JCheckBox jCheckBox_CTDValidity;
    public static JCheckBox jCheckBox_CompensatedData;
    public static JCheckBox jCheckBox_DEPTHValidity;
    public static JCheckBox jCheckBox_DMIValidity;
    public static JCheckBox jCheckBox_DVLBTValidity;
    public static JCheckBox jCheckBox_DVLWTValidity;
    public static JCheckBox jCheckBox_GPSValidity;
    public static JCheckBox jCheckBox_GraviValidity;
    public static JCheckBox jCheckBox_LBLValidity;
    public static JCheckBox jCheckBox_LochEmValidity;
    public static JCheckBox jCheckBox_Option1;
    public static JCheckBox jCheckBox_Option2;
    public static JCheckBox jCheckBox_Option3;
    public static JCheckBox jCheckBox_Option4;
    public static JCheckBox jCheckBox_Option5;
    public static JCheckBox jCheckBox_Option6;
    public static JCheckBox jCheckBox_Scambling_On;
    public static JCheckBox jCheckBox_Scramble_AddChar;
    public static JCheckBox jCheckBox_Scramble_AddField;
    public static JCheckBox jCheckBox_Scramble_ReplaceChar;
    public static JCheckBox jCheckBox_Scramble_SuppressChar;
    public static JCheckBox jCheckBox_Scramble_SuppressField;
    public static JCheckBox jCheckBox_TrameXXEnable;
    public static JCheckBox jCheckBox_TrameXXEnable1;
    public static JCheckBox jCheckBox_TrameXXEnable10;
    public static JCheckBox jCheckBox_TrameXXEnable11;
    public static JCheckBox jCheckBox_TrameXXEnable12;
    public static JCheckBox jCheckBox_TrameXXEnable13;
    public static JCheckBox jCheckBox_TrameXXEnable14;
    public static JCheckBox jCheckBox_TrameXXEnable15;
    public static JCheckBox jCheckBox_TrameXXEnable16;
    public static JCheckBox jCheckBox_TrameXXEnable17;
    public static JCheckBox jCheckBox_TrameXXEnable2;
    public static JCheckBox jCheckBox_TrameXXEnable3;
    public static JCheckBox jCheckBox_TrameXXEnable4;
    public static JCheckBox jCheckBox_TrameXXEnable5;
    public static JCheckBox jCheckBox_TrameXXEnable6;
    public static JCheckBox jCheckBox_TrameXXEnable7;
    public static JCheckBox jCheckBox_TrameXXEnable8;
    public static JCheckBox jCheckBox_TrameXXEnable9;
    public static JCheckBox jCheckBox_USBLValidity;
    public static JComboBox<String> jCmbBoxDT1Axis;
    public static JComboBox<String> jCmbBoxDT1Beam;
    public static JComboBox<String> jCmbBoxDT2Axis;
    public static JComboBox<String> jCmbBoxDT2Beam;
    public static JComboBox<String> jCmbBoxDistanceBeam;
    public static JComboBox<String> jCmbBoxFOMAxis;
    public static JComboBox<String> jCmbBoxFOMBeam;
    public static JComboBox<String> jCmbBoxTimeVelEstAxis;
    public static JComboBox<String> jCmbBoxTimeVelEstBeam;
    public static JComboBox<String> jCmbBoxVelocityAxis;
    public static JComboBox<String> jCmbBoxVelocityBeam;
    public static JComboBox<String> jComboBox1;
    public static JComboBox<String> jComboBox2;
    private JComboBox jComboBox_CoordinateVelocities;
    public static JComboBox jComboBox_DVLId;
    public static JComboBox jComboBox_EMLOGId;
    public static JComboBox jComboBox_EthConnectionType;
    public static JComboBox jComboBox_GPSId;
    public static JComboBox jComboBox_GPSQuality;
    public static JComboBox jComboBox_LBLId;
    public static JComboBox jComboBox_OperatingMode;
    public static JComboBox jComboBox_OuputId;
    public static JComboBox jComboBox_OutputBaudrate;
    public static JComboBox jComboBox_OutputConnType;
    public static JComboBox jComboBox_OutputDVLId;
    public static JComboBox jComboBox_OutputDataBits;
    public static JComboBox jComboBox_OutputDisplayId;
    public static JComboBox jComboBox_OutputEMLOGId;
    public static JComboBox jComboBox_OutputGPSId;
    public static JComboBox jComboBox_OutputLBLId;
    public static JComboBox jComboBox_OutputParity;
    public static JComboBox jComboBox_OutputProto;
    public static JComboBox jComboBox_OutputRSPort;
    public static JComboBox jComboBox_OutputRate;
    public static JComboBox jComboBox_OutputStopBits;
    public static JComboBox jComboBox_OutputUSBLId;
    public static JComboBox jComboBox_ProtocolParams_OutputId;
    public static JComboBox jComboBox_USBLId;
    public static JCheckBox jDvlBottomTrackUsed;
    public static JTextField jDvlNortekDT1;
    public static JTextField jDvlNortekDT2;
    public static JTextField jDvlNortekDistanceBeam;
    public static JTextField jDvlNortekFOM;
    public static JSlider jDvlNortekNbOfBeam;
    public static JTextField jDvlNortekPressure;
    public static JTextField jDvlNortekSerialNumber;
    public static JTextField jDvlNortekSpdOfSound;
    private JLabel jDvlNortekTemperature;
    public static JTextField jDvlNortekTimeVelEst;
    public static JTextField jDvlNortekVelocity;
    public static JCheckBox jDvlWaterTrackUsed;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel100;
    private JLabel jLabel101;
    private JLabel jLabel102;
    private JLabel jLabel103;
    private JLabel jLabel104;
    private JLabel jLabel105;
    private JLabel jLabel106;
    private JLabel jLabel107;
    private JLabel jLabel108;
    private JLabel jLabel109;
    private JLabel jLabel11;
    private JLabel jLabel110;
    private JLabel jLabel111;
    private JLabel jLabel112;
    private JLabel jLabel113;
    private JLabel jLabel114;
    private JLabel jLabel115;
    private JLabel jLabel116;
    private JLabel jLabel117;
    private JLabel jLabel118;
    private JLabel jLabel119;
    private JLabel jLabel12;
    private JLabel jLabel120;
    private JLabel jLabel121;
    private JLabel jLabel123;
    private JLabel jLabel124;
    private JLabel jLabel125;
    private JLabel jLabel126;
    private JLabel jLabel127;
    private JLabel jLabel128;
    private JLabel jLabel129;
    private JLabel jLabel13;
    private JLabel jLabel130;
    private JLabel jLabel131;
    private JLabel jLabel132;
    private JLabel jLabel133;
    private JLabel jLabel134;
    private JLabel jLabel135;
    private JLabel jLabel136;
    private JLabel jLabel137;
    private JLabel jLabel138;
    private JLabel jLabel139;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel4;
    private JLabel jLabel40;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel52;
    private JLabel jLabel53;
    private JLabel jLabel54;
    private JLabel jLabel55;
    private JLabel jLabel56;
    private JLabel jLabel57;
    private JLabel jLabel58;
    private JLabel jLabel59;
    private JLabel jLabel6;
    private JLabel jLabel60;
    private JLabel jLabel61;
    private JLabel jLabel62;
    private JLabel jLabel63;
    private JLabel jLabel64;
    private JLabel jLabel65;
    private JLabel jLabel66;
    private JLabel jLabel67;
    private JLabel jLabel68;
    private JLabel jLabel69;
    private JLabel jLabel7;
    private JLabel jLabel70;
    private JLabel jLabel71;
    private JLabel jLabel72;
    private JLabel jLabel73;
    private JLabel jLabel74;
    private JLabel jLabel75;
    private JLabel jLabel76;
    private JLabel jLabel77;
    private JLabel jLabel78;
    private JLabel jLabel79;
    private JLabel jLabel8;
    private JLabel jLabel80;
    private JLabel jLabel81;
    private JLabel jLabel82;
    private JLabel jLabel83;
    private JLabel jLabel84;
    private JLabel jLabel85;
    private JLabel jLabel86;
    private JLabel jLabel87;
    private JLabel jLabel88;
    private JLabel jLabel89;
    private JLabel jLabel9;
    private JLabel jLabel90;
    private JLabel jLabel91;
    private JLabel jLabel92;
    private JLabel jLabel93;
    private JLabel jLabel94;
    private JLabel jLabel95;
    private JLabel jLabel96;
    private JLabel jLabel97;
    private JLabel jLabel98;
    private JLabel jLabel99;
    private JLabel jLabel_ConnType;
    public static JLabel jLabel_DVLP1;
    public static JLabel jLabel_DVLP2;
    public static JLabel jLabel_DVLP3;
    public static JLabel jLabel_DVLmisalignment14;
    public static JLabel jLabel_DVLmisalignment15;
    public static JLabel jLabel_DVLmisalignment16;
    public static JLabel jLabel_DVLmisalignment17;
    public static JLabel jLabel_DisplayTime;
    private JLabel jLabel_Info1;
    private JLabel jLabel_Info10;
    private JLabel jLabel_Info11;
    private JLabel jLabel_Info12;
    private JLabel jLabel_Info13;
    private JLabel jLabel_Info14;
    private JLabel jLabel_Info2;
    private JLabel jLabel_Info3;
    private JLabel jLabel_Info4;
    private JLabel jLabel_Info5;
    private JLabel jLabel_Info6;
    private JLabel jLabel_Info7;
    private JLabel jLabel_Info8;
    private JLabel jLabel_Info9;
    public static JLabel jLabel_InfoOuput1;
    public static JLabel jLabel_InfoOuput2;
    public static JLabel jLabel_InfoOuput3;
    public static JLabel jLabel_InfoOuput4;
    public static JLabel jLabel_InfoOuput5;
    public static JLabel jLabel_InfoOuput6;
    public static JLabel jLabel_InfoOuput7;
    public static JLabel jLabel_InfoOuputInterface1;
    public static JLabel jLabel_InfoOuputInterface2;
    public static JLabel jLabel_InfoOuputInterface3;
    public static JLabel jLabel_InfoOuputInterface4;
    public static JLabel jLabel_InfoOuputInterface5;
    public static JLabel jLabel_InfoOuputInterface6;
    public static JLabel jLabel_InfoOuputInterface7;
    public static JLabel jLabel_Output1State;
    public static JLabel jLabel_Output2State;
    public static JLabel jLabel_Output3State;
    public static JLabel jLabel_Output4State;
    public static JLabel jLabel_Output5State;
    public static JLabel jLabel_Output6State;
    public static JLabel jLabel_Output7State;
    public static JLabel jLabel_OutputBaudrate;
    public static JLabel jLabel_OutputConnectionType;
    public static JLabel jLabel_OutputDatabits;
    public static JLabel jLabel_OutputIPAdress;
    public static JLabel jLabel_OutputId;
    public static JLabel jLabel_OutputId1;
    public static JLabel jLabel_OutputParity;
    public static JLabel jLabel_OutputPortIP;
    public static JLabel jLabel_OutputPortRS;
    public static JLabel jLabel_OutputRate;
    public static JLabel jLabel_OutputRateCustomLabel;
    public static JLabel jLabel_OutputStopBits;
    public static JLabel jLabel_Proto;
    public static JLabel jLabel_ProtocolId;
    public static JLabel jLabel_ProtocoleName;
    public static JLabel jLabel_Scramble_AddChar_Label;
    public static JLabel jLabel_Scramble_AddChar_Nb;
    public static JLabel jLabel_Scramble_AddField_Label;
    public static JLabel jLabel_Scramble_AddField_Nb;
    public static JLabel jLabel_Scramble_ReplaceChar_Label;
    public static JLabel jLabel_Scramble_ReplaceChar_Nb;
    public static JLabel jLabel_Scramble_SuppressChar_Label;
    public static JLabel jLabel_Scramble_SuppressChar_Nb;
    public static JLabel jLabel_Scramble_SuppressField_Label;
    public static JLabel jLabel_Scramble_SuppressField_Nb;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel18;
    private JPanel jPanel19;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel22;
    private JPanel jPanel23;
    private JPanel jPanel24;
    private JPanel jPanel25;
    private JPanel jPanel26;
    private JPanel jPanel3;
    public static JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    public static JPanel jPanel9;
    public static JPanel jPanel_CTD_Datas;
    public static JPanel jPanel_Chevron;
    public static JPanel jPanel_DEPTH_Datas;
    public static JPanel jPanel_DMI_Datas;
    public static JPanel jPanel_DMI_Datas1;
    public static JPanel jPanel_DVL_BTDatas;
    public static JPanel jPanel_DVL_Id;
    public static JPanel jPanel_DVL_WTDatas;
    public static JPanel jPanel_EMLog_Id;
    public static JPanel jPanel_EMLog_Speeds;
    public static JPanel jPanel_GPSSPeed;
    public static JPanel jPanel_GPS_Id;
    public static JPanel jPanel_GPS_Position;
    public static JPanel jPanel_GRAVI_Datas;
    public static JPanel jPanel_GRAVI_Datas1;
    public static JPanel jPanel_Info;
    public static JPanel jPanel_LBL_Datas;
    public static JPanel jPanel_LBL_Id;
    public static JPanel jPanel_OuputFlow;
    public static JPanel jPanel_OuputRate;
    public static JPanel jPanel_OutPutEthernet;
    public static JPanel jPanel_OutputSerial;
    public static JPanel jPanel_ProtoSelection;
    public static JPanel jPanel_USBL_Datas;
    public static JPanel jPanel_USBL_Id;
    public static JPanel jPanel_Voyants;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    public static JSlider jSlider_Scramble_AddChar;
    public static JSlider jSlider_Scramble_AddField;
    public static JSlider jSlider_Scramble_ReplaceChar;
    public static JSlider jSlider_Scramble_SuppressChar;
    public static JSlider jSlider_Scramble_SuppressField;
    public static JTabbedPane jTabbedPane_Main;
    public static JTextArea jTextArea_OutputDisplay;
    public static JTextField jTextField10;
    public static JTextField jTextField12;
    public static JTextField jTextField17;
    public static JTextField jTextField3;
    public static JTextField jTextField5;
    public static JTextField jTextField7;
    public static JTextField jTextField8;
    public static JTextField jTextField9;
    public static JTextField jTextField_CTDConductivity;
    public static JTextField jTextField_CTDDepth;
    public static JTextField jTextField_CTDPressure;
    public static JTextField jTextField_CTDSalinity;
    public static JTextField jTextField_CTDSoundSpeed;
    public static JTextField jTextField_CTDTemperature;
    public static JTextField jTextField_DEPTHDepth;
    public static JTextField jTextField_DEPTHDepthStd;
    public static JTextField jTextField_DEPTHLatency;
    public static JTextField jTextField_DEPTH_Pressure;
    public static JTextField jTextField_DMIPulseCount;
    public static JTextField jTextField_DVLBT_Altitude;
    public static JTextField jTextField_DVLBT_Latency;
    public static JTextField jTextField_DVLBT_SoundSpeed;
    public static JTextField jTextField_DVLBT_XS1Speed;
    public static JTextField jTextField_DVLBT_XS1SpeedStd;
    public static JTextField jTextField_DVLBT_XS2Speed;
    public static JTextField jTextField_DVLBT_XS2SpeedStd;
    public static JTextField jTextField_DVLBT_XS3Speed;
    public static JTextField jTextField_DVLBT_XS3SpeedStd;
    public static JTextField jTextField_DVLWT_Altitude;
    public static JTextField jTextField_DVLWT_Latency;
    public static JTextField jTextField_DVLWT_SoundSpeed;
    public static JTextField jTextField_DVLWT_XS1Speed;
    public static JTextField jTextField_DVLWT_XS1SpeedStd;
    public static JTextField jTextField_DVLWT_XS2Speed;
    public static JTextField jTextField_DVLWT_XS2SpeedStd;
    public static JTextField jTextField_DVLWT_XS3Speed;
    public static JTextField jTextField_DVLWT_XS3SpeedStd;
    public static JTextField jTextField_Depth_SoundSpeed;
    public static JTextField jTextField_Depth_Temperature;
    public static JTextField jTextField_GPSAltitude;
    public static JTextField jTextField_GPSAltitudeStd;
    public static JTextField jTextField_GPSCourse;
    public static JTextField jTextField_GPSEllipseAngle;
    public static JTextField jTextField_GPSEllipseMajorAxis;
    public static JTextField jTextField_GPSEllipseMinorAxis;
    public static JTextField jTextField_GPSGeoidalSep;
    public static JTextField jTextField_GPSLatLongCov;
    public static JTextField jTextField_GPSLatency;
    public static JTextField jTextField_GPSLatitude;
    public static JTextField jTextField_GPSLatitudeStd;
    public static JTextField jTextField_GPSLongitude;
    public static JTextField jTextField_GPSLongitudeStd;
    public static JTextField jTextField_GPSSpeed;
    public static JTextField jTextField_Gravi_Eta;
    public static JTextField jTextField_Gravi_Lat;
    public static JTextField jTextField_Gravi_Long;
    public static JTextField jTextField_Gravi_Norm;
    public static JTextField jTextField_Gravi_Xi;
    public static JTextField jTextField_LBLBeaconCode;
    public static JTextField jTextField_LBLDepth;
    public static JTextField jTextField_LBLLatency;
    public static JTextField jTextField_LBLLatitude;
    public static JTextField jTextField_LBLLongitude;
    public static JTextField jTextField_LBLRange;
    public static JTextField jTextField_LBLRangeStd;
    public static JTextField jTextField_LogEM_LongGroundSpeed;
    public static JTextField jTextField_LogEM_LongWaterSpeed;
    public static JTextField jTextField_LogEM_LongWaterSpeedStd;
    public static JTextField jTextField_LogEM_TransGroundSpeed;
    public static JTextField jTextField_LogEM_TransWaterSpeed;
    public static JTextField jTextField_OutputIPAdress1;
    public static JTextField jTextField_OutputIPAdress2;
    public static JTextField jTextField_OutputIPAdress3;
    public static JTextField jTextField_OutputIPAdress4;
    public static JTextField jTextField_OutputIPPort;
    public static JTextField jTextField_OutputRateCustom;
    public static JTextField jTextField_Platform_OrientX;
    public static JTextField jTextField_Platform_OrientY;
    public static JTextField jTextField_Platform_OrientZ;
    public static JTextField jTextField_Platform_PosX;
    public static JTextField jTextField_Platform_PosY;
    public static JTextField jTextField_Platform_PosZ;
    public static JTextField jTextField_Platform_Status;
    public static JTextField jTextField_StimAccelX;
    public static JTextField jTextField_StimAccelY;
    public static JTextField jTextField_StimAccelZ;
    public static JTextField jTextField_StimAltiRef;
    public static JTextField jTextField_StimAltitude;
    public static JTextField jTextField_StimHeading;
    public static JTextField jTextField_StimLatitude;
    public static JTextField jTextField_StimLongitude;
    public static JTextField jTextField_StimPitch;
    public static JTextField jTextField_StimRoll;
    public static JTextField jTextField_StimRotRateX;
    public static JTextField jTextField_StimRotRateY;
    public static JTextField jTextField_StimRotRateZ;
    public static JTextField jTextField_StimSpeedEast;
    public static JTextField jTextField_StimSpeedNorth;
    public static JTextField jTextField_StimSpeedUp;
    public static JTextField jTextField_USBLBeaconCodeID;
    public static JTextField jTextField_USBLBeaconNumID;
    public static JTextField jTextField_USBLDepth;
    public static JTextField jTextField_USBLDepthStd;
    public static JTextField jTextField_USBLLatLongCov;
    public static JTextField jTextField_USBLLatency;
    public static JTextField jTextField_USBLLatitude;
    public static JTextField jTextField_USBLLatitudeStd;
    public static JTextField jTextField_USBLLongitude;
    public static JTextField jTextField_USBLLongitudeStd;
    public static JTextField jTextField_USBLMajorAxis;
    public static JTextField jTextField_USBLMajorAxisDir;
    public static JTextField jTextField_USBLMinorAxis;
    public static JTextField jTextField_USBLUTMEst;
    public static JTextField jTextField_USBLUTMNord;
    public static JTextField jTextField_USBLUTMZone;
    public static JToggleButton jToggleButton_StartDisplay;

    public SimulatorFrame(String _Revision, String _Date) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SimulatorFrame.CheckSerialDll();
        this.initComponents();
        this.initComponentsLists();
        this.setTitle("iXBlue - Generic Sensor Simulator  (R\u00e9v: " + _Revision + " - " + _Date + ")");
        this.setIconImage(new ImageIcon("./images/chevron.png").getImage());
        this.setResizable(false);
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension Screensize = kit.getScreenSize();
        this.setLocation(Screensize.width / 2 - this.getWidth() / 2, Screensize.height / 2 - this.getHeight() / 2 - 10);
        JLabel image = new JLabel(new ImageIcon("./images/chevron.png"));
        jPanel_Chevron.setLayout(new BorderLayout());
        jPanel_Chevron.add((Component)image, "Center");
        this.Info = new SimulatorInfo();
        this.Proto_List = new Protocols_List(100);
        this.Proto_List.Add_Protocol(new Protocol_None_Encoder("None", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_AHRS_120_Encoder("AHRS_120", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_TRS_AHRS_Encoder("AHRS_S10", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_APOS_PSIMLBP_Encoder("APOS_PSIMLBP", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_APOS_PSIMSSB_Encoder("APOS_PSIMSSB", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_AUVG3000_Encoder("AUVG3000", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_BAE_Encoder("BAE", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_DCN_STD_LOCH_Encoder("DCN_STD_LOCH", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_DCN_STD_NAV1_Encoder("DCN_STD_NAV1", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_DVL_Commands_Encoder("DVL_COMMANDS", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_DVL_VBW_Encoder("DVL_VBW", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_EIVA_Encoder("EIVA", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_VBW_VHW_Encoder("EMLOG_VBW_VHW", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_EXT_SENSOR_BIN_Encoder("EXT_SENSOR_BIN", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_GPS_Encoder("GPS", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_GSM_3000_Encoder("GSM_3000", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_GRAVIMETRY_Encoder("GRAVIMETRY_DOV_CORR", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_HEXAPOD_Encoder("HEXAPOD", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_INRMC_Encoder("INRMC", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_IXSEA_AUV_Encoder("IXSEA_AUV", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_IXBLUE_STD_BIN_Encoder("IXBLUE_STD_BIN", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_IXSEA_USBL_INS_Encoder("IXSEA_USBL_INS", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_MINI_SVS_Encoder("MINI_SVS", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_MICRO_SVT_P_Encoder("MICRO_SVT_P", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_ODOMETER_Encoder("ODOMETER", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_PAROSCIENTIFIC_Encoder("PAROSCIENTIFIC", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_POSIDONIA_Encoder("POSIDONIA", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_PRESSURE_SENSOR_Encoder("PRESSURE_SENSOR", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_RAMSES_POSTPRO_Encoder("RAMSES_POSTPRO", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_RDI_PD0_Encoder("RDI_PD0", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_RDI_PD3_Encoder("RDI_PD3", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_RDI_PD4_Encoder("RDI_PD4", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_RDI_PD6_Encoder("RDI_PD6", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_SBE37_Encoder("SBE_37_SI", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_SEAKING_700_Encoder("SEAKING_700", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_SBE49_Encoder("SBE49", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_SOC_AUTOSUB_Encoder("SOC_AUTOSUB", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_SVP70_Encoder("SVP70", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_SVX2_Encoder("SVX2", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_USBL_BOX_POSTPRO_Encoder("USBL_BOX_POSTPRO", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_USBL_LBL_CTD_Encoder("USBL_LBL_CTD", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_Minifog_Gps_Msg_Encoder("MINIFOG_GPS_MSG", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_TERPS8000_Encoder("TERPS8000", this.Info));
        this.Proto_List.Add_Protocol(new Protocol_NORTEK_DF21_22_Encoder("NORTEK_DF21/22", this.Info));
        this.OutputEncoder = new ProtocolEncoder[7];
        Display = new SimulatorDisplay(jTextArea_OutputDisplay, 1000);
        Display.Init();
        Light = new LightPanel(jPanel_Voyants);
        Manager = new SimulatorManager(this.Info, this);
        Manager.start();
        SimulatorFrame.Manager.Scramblers = new SimulatorScrambler[7];
        SimulatorFrame.Manager.Scramblers[0] = new SimulatorScrambler(jCheckBox_Scramble_ReplaceChar, jSlider_Scramble_ReplaceChar, jLabel_Scramble_ReplaceChar_Nb, jLabel_Scramble_ReplaceChar_Label, SimulatorScrambler.ScramblingType.REPLACE_CHAR);
        SimulatorFrame.Manager.Scramblers[1] = new SimulatorScrambler(jCheckBox_Scramble_SuppressChar, jSlider_Scramble_SuppressChar, jLabel_Scramble_SuppressChar_Nb, jLabel_Scramble_SuppressChar_Label, SimulatorScrambler.ScramblingType.SUPPRESS_CHAR);
        SimulatorFrame.Manager.Scramblers[2] = new SimulatorScrambler(jCheckBox_Scramble_AddChar, jSlider_Scramble_AddChar, jLabel_Scramble_AddChar_Nb, jLabel_Scramble_AddChar_Label, SimulatorScrambler.ScramblingType.INSERT_CHAR);
        SimulatorFrame.Manager.Scramblers[3] = new SimulatorScrambler(jCheckBox_Scramble_SuppressField, jSlider_Scramble_SuppressField, jLabel_Scramble_SuppressField_Nb, jLabel_Scramble_SuppressField_Label, SimulatorScrambler.ScramblingType.SUPPRESS_FIELD);
        SimulatorFrame.Manager.Scramblers[4] = new SimulatorScrambler(jCheckBox_Scramble_AddField, jSlider_Scramble_AddField, jLabel_Scramble_AddField_Nb, jLabel_Scramble_AddField_Label, SimulatorScrambler.ScramblingType.INSERT_FIELD);
        SimulatorFrame.Manager.Scramblers[5] = new SimulatorScrambler(jCheckBox_Scramble_AddField, jSlider_Scramble_AddField, jLabel_Scramble_AddField_Nb, jLabel_Scramble_AddField_Label, SimulatorScrambler.ScramblingType.INSERT_FIELD);
        SimulatorFrame.Manager.Scramblers[6] = new SimulatorScrambler(jCheckBox_Scramble_AddField, jSlider_Scramble_AddField, jLabel_Scramble_AddField_Nb, jLabel_Scramble_AddField_Label, SimulatorScrambler.ScramblingType.INSERT_FIELD);
        this.ConstructOuputPanel();
        this.UpdateOutputParametersPanel();
        this.ConstructScramblingPanel();
        this.Construct_GPS_Panel();
        this.Construct_LBL_Panel();
        this.Construct_USBL_Panel();
        this.Construct_EMLOG_Panel();
        this.Construct_DVL_Panel();
        this.ConstructProtocolsParamsPanel();
        this.UpdateProtocolsParamsPanel();
        this.UpdateControlPanel();
        this.ConstructDisplayPanel();
        this.Update_GPS_Panel();
        this.Update_DVL_Panel();
        this.Update_USBL_Panel();
        this.Update_LBL_Panel();
        this.Update_EMLOG_Panel();
        this.Update_DEPTH_Panel();
        this.Update_CTD_Panel();
        this.Update_GRAVI_Panel();
        this.Update_DMI_Panel();
        this.Update_PLATFORM_Panel();
        jTabbedPane_Main.setSelectedIndex(14);
        this.ManagerTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.UpdateOutputParametersInfos();
                SimulatorFrame.this.UpdateProtocolsParamsInfos();
                SimulatorFrame.this.Update_GPS_Infos();
                SimulatorFrame.this.Update_DVL_Infos();
                SimulatorFrame.this.Update_USBL_Infos();
                SimulatorFrame.this.Update_LBL_Infos();
                SimulatorFrame.this.Update_EMLOG_Infos();
                SimulatorFrame.this.Update_DEPTH_Infos();
                SimulatorFrame.this.Update_CTD_Infos();
                SimulatorFrame.this.Update_GRAVI_Infos();
                SimulatorFrame.this.Update_DMI_Infos();
                SimulatorFrame.this.Update_PLATFORM_Infos();
                jLabel_DisplayTime.setText(new TimeTool().Get_DisplayTime());
            }
        });
        this.ManagerTimer.start();
        this.IsInitialized = true;
        this.setDefaultCloseOperation(3);
    }

    private static void CheckSerialDll() {
        int i;
        int libpath_nb = 0;
        boolean RxTxSerial_found = false;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String OSArch = System.getProperty("os.arch");
        String SunDataModel = System.getProperty("sun.arch.data.model");
        SimulatorFrame.AddDirToJavaLibPath(System.getProperty("user.dir") + "\\lib" + (SunDataModel.contains("64") ? "\\64" : "\\32"));
        String[] Config = System.getProperty("java.library.path").toString().split(";");
        String[] ConfigValid = new String[100];
        for (String t : Config) {
            File f;
            if (!(t.contains("Java") | t.contains("lib")) || !(f = new File(t)).exists()) continue;
            ConfigValid[libpath_nb++] = t;
        }
        System.out.println("System Properties:");
        System.out.println("os.arch: " + OSArch);
        System.out.println("sun.arch.data.model: " + SunDataModel);
        System.out.println("java.library.path:");
        for (i = 0; i < libpath_nb; ++i) {
            System.out.println(ConfigValid[i]);
        }
        System.out.println("\n");
        if (libpath_nb != 0) {
            for (i = 0; i < libpath_nb; ++i) {
                File f = new File(ConfigValid[i] + "\\rxtxSerial.dll");
                if (!f.exists()) continue;
                RxTxSerial_found = true;
            }
            if (!RxTxSerial_found) {
                String Message = "\nUnable to detect \"rxtxSerial.dll\" file used to control Serial ports.\n \nLibrary shall be located in:\n" + System.getProperty("user.dir") + "\\lib" + (SunDataModel.contains("64") ? "\\64" : "\\32") + "\n\nFor information:\n - OS architecture is " + (OSArch.contains("64") ? "64" : "32") + "-bit\n - Java platform is " + (SunDataModel.contains("64") ? "64" : "32") + "-bit\n\n";
                JOptionPane.showMessageDialog(null, Message, "iXBlue Generic Simulator", 2);
                System.exit(0);
            }
        }
    }

    public static void AddDirToJavaLibPath(String s) {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            for (int i = 0; i < paths.length; ++i) {
                if (!s.equals(paths[i])) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = s;
            field.set(null, tmp);
            System.setProperty("java.library.path", System.getProperty("java.library.path") + File.pathSeparator + s);
            System.out.println(s);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public void ConstructOuputPanel() {
        int Output_Id = 0;
        for (Output_Id = 1; Output_Id <= 7; ++Output_Id) {
            jComboBox_OuputId.addItem("Output " + Integer.toString(Output_Id));
        }
        int Proto_Id = 0;
        while (this.Proto_List.IsAvailable(Proto_Id)) {
            jComboBox_OutputProto.addItem(this.Proto_List.GetProtocolNameById(Proto_Id));
            ++Proto_Id;
        }
        jComboBox_OutputConnType.addItem("None");
        jComboBox_OutputConnType.addItem("Ethernet");
        jComboBox_OutputConnType.addItem("Serial");
        jComboBox_OutputRate.addItem("0.1Hz (10s)");
        jComboBox_OutputRate.addItem("0.2Hz (5s)");
        jComboBox_OutputRate.addItem("0.5Hz (2s)");
        jComboBox_OutputRate.addItem("1Hz (1s)");
        jComboBox_OutputRate.addItem("2Hz (500ms)");
        jComboBox_OutputRate.addItem("5Hz (200ms)");
        jComboBox_OutputRate.addItem("10Hz (100ms)");
        jComboBox_OutputRate.addItem("Custom");
        jTextField_OutputRateCustom.setDocument(new JTextFieldFilter("-+0123456789.", 5, 20000));
        jComboBox_EthConnectionType.addItem("TCP Client");
        jComboBox_EthConnectionType.addItem("TCP Server");
        jComboBox_EthConnectionType.addItem("UDP");
        jComboBox_EthConnectionType.addItem("UDP MultiCast");
        jTextField_OutputIPAdress1.setDocument(new JTextFieldFilter("-+0123456789.", 3, 255));
        jTextField_OutputIPAdress2.setDocument(new JTextFieldFilter("-+0123456789.", 3, 255));
        jTextField_OutputIPAdress3.setDocument(new JTextFieldFilter("-+0123456789.", 3, 255));
        jTextField_OutputIPAdress4.setDocument(new JTextFieldFilter("-+0123456789.", 3, 255));
        jTextField_OutputIPPort.setDocument(new JTextFieldFilter("-+0123456789.", 5, 65535));
        int PortNumber = 0;
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            ++PortNumber;
            CommPortIdentifier Port_Dispo = (CommPortIdentifier)portList.nextElement();
            if (!Port_Dispo.getName().contains("COM")) continue;
            jComboBox_OutputRSPort.addItem(Port_Dispo.getName());
        }
        if (PortNumber == 0 || jComboBox_OutputRSPort.getItemCount() == 0) {
            jComboBox_OutputRSPort.addItem("NONE");
        }
        jComboBox_OutputBaudrate.addItem("600");
        jComboBox_OutputBaudrate.addItem("1200");
        jComboBox_OutputBaudrate.addItem("2400");
        jComboBox_OutputBaudrate.addItem("4800");
        jComboBox_OutputBaudrate.addItem("9600");
        jComboBox_OutputBaudrate.addItem("19200");
        jComboBox_OutputBaudrate.addItem("38400");
        jComboBox_OutputBaudrate.addItem("57600");
        jComboBox_OutputBaudrate.addItem("115200");
        jComboBox_OutputBaudrate.addItem("230400");
        jComboBox_OutputBaudrate.addItem("460800");
        jComboBox_OutputDataBits.addItem("7 bits");
        jComboBox_OutputDataBits.addItem("8 bits");
        jComboBox_OutputParity.addItem("No Parity");
        jComboBox_OutputParity.addItem("Even");
        jComboBox_OutputParity.addItem("Odd");
        jComboBox_OutputStopBits.addItem("0 bit");
        jComboBox_OutputStopBits.addItem("0.5 bit");
        jComboBox_OutputStopBits.addItem("1 bit");
        jComboBox_OutputStopBits.addItem("2 bits");
    }

    public void UpdateOutputParametersPanel() {
        int Output_Index = jComboBox_OuputId.getSelectedIndex();
        if (Output_Index > 7) {
            return;
        }
        OutputFlowInfo OutInfo = this.Info.OutputInfo[Output_Index];
        this.SetjComboSelectedIndex(jComboBox_OutputConnType, OutInfo.GetFlowType());
        this.SetjComboSelectedIndex(jComboBox_OutputProto, OutInfo.GetProtocole());
        this.SetjComboSelectedIndex(jComboBox_OutputRate, OutInfo.GetRate());
        jTextField_OutputRateCustom.setText(Integer.toString(OutInfo.GetRateCustom()));
        this.SetjComboSelectedIndex(jComboBox_EthConnectionType, OutInfo.GetEthernetConnType());
        String[] IP = OutInfo.GetEthernetIPAdress().split("\\.");
        jTextField_OutputIPAdress1.setText(IP[0]);
        jTextField_OutputIPAdress2.setText(IP[1]);
        jTextField_OutputIPAdress3.setText(IP[2]);
        jTextField_OutputIPAdress4.setText(IP[3]);
        jTextField_OutputIPPort.setText(OutInfo.GetEthernetIPPort());
        this.SetjComboSelectedIndex(jComboBox_OutputRSPort, OutInfo.GetSerialPort());
        this.SetjComboSelectedIndex(jComboBox_OutputBaudrate, OutInfo.GetBaudrate());
        this.SetjComboSelectedIndex(jComboBox_OutputDataBits, OutInfo.GetDataBits());
        this.SetjComboSelectedIndex(jComboBox_OutputParity, OutInfo.GetParity());
        this.SetjComboSelectedIndex(jComboBox_OutputStopBits, OutInfo.GetStopBits());
        jCheckBox_Scambling_On.setSelected(OutInfo.GetScrambling());
    }

    public void UpdateOutputParametersInfos() {
        int Output_Index = jComboBox_OuputId.getSelectedIndex();
        if (Output_Index > 7) {
            return;
        }
        OutputFlowInfo OutputInfo = this.Info.OutputInfo[Output_Index];
        if (jTextField_OutputIPAdress1.getText().equalsIgnoreCase("")) {
            jTextField_OutputIPAdress1.setText("0");
        }
        if (jTextField_OutputIPAdress2.getText().equalsIgnoreCase("")) {
            jTextField_OutputIPAdress2.setText("0");
        }
        if (jTextField_OutputIPAdress3.getText().equalsIgnoreCase("")) {
            jTextField_OutputIPAdress3.setText("0");
        }
        if (jTextField_OutputIPAdress4.getText().equalsIgnoreCase("")) {
            jTextField_OutputIPAdress4.setText("0");
        }
        if (jTextField_OutputIPPort.getText().equalsIgnoreCase("")) {
            jTextField_OutputIPPort.setText("0");
        }
        OutputInfo.SetOutputParams(jComboBox_OutputConnType.getSelectedIndex(), jComboBox_OutputProto.getSelectedIndex(), jComboBox_OutputRate.getSelectedIndex(), Integer.parseInt(jTextField_OutputRateCustom.getText()), jComboBox_EthConnectionType.getSelectedIndex(), jTextField_OutputIPAdress1.getText() + "." + jTextField_OutputIPAdress2.getText() + "." + jTextField_OutputIPAdress3.getText() + "." + jTextField_OutputIPAdress4.getText(), jTextField_OutputIPPort.getText(), jComboBox_OutputRSPort.getSelectedItem().toString(), jComboBox_OutputBaudrate.getSelectedIndex(), jComboBox_OutputDataBits.getSelectedIndex(), jComboBox_OutputParity.getSelectedIndex(), jComboBox_OutputStopBits.getSelectedIndex(), jCheckBox_Scambling_On.isSelected());
    }

    void Update_OutputParam_Visibility() {
        boolean OutputEnabled = false;
        int OutputId = jComboBox_OuputId.getSelectedIndex();
        OutputEnabled = SimulatorFrame.Manager.OutputManager[OutputId].IsStarted != true && jComboBox_OutputProto.getSelectedIndex() != 0;
        if (!OutputEnabled) {
            this.Set_OutputFlowParameters_Enable(false);
            this.Set_OutputEthernetConnection_Enable(false);
            this.Set_OutputSerialConnection_Enable(false);
            jComboBox_OutputProto.setEnabled(SimulatorFrame.Manager.OutputManager[OutputId].IsStarted != true);
        } else {
            this.Set_OutputFlowParameters_Enable(true);
            this.Set_OutputEthernetConnection_Enable(jComboBox_OutputConnType.getSelectedIndex() == 1);
            this.Set_OutputSerialConnection_Enable(jComboBox_OutputConnType.getSelectedIndex() == 2);
            jComboBox_OutputProto.setEnabled(true);
        }
        this.Set_OutputRateParameters_Enable(jComboBox_OutputProto.getSelectedIndex() != 0);
    }

    void Set_OutputFlowParameters_Enable(boolean set_unset) {
        this.DisableEnableAllPanelComponents(jPanel_OuputFlow, set_unset);
        jPanel_OuputFlow.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Flow Parameters", 0, 0, new Font("Tahoma", 1, 11), set_unset ? Color.black : Color.GRAY));
    }

    void Set_OutputRateParameters_Enable(boolean set_unset) {
        this.DisableEnableAllPanelComponents(jPanel_OuputRate, set_unset);
        jPanel_OuputRate.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rate Parameters", 0, 0, new Font("Tahoma", 1, 11), set_unset ? Color.black : Color.GRAY));
        if (set_unset) {
            boolean Custom_Rate = jComboBox_OutputRate.getSelectedIndex() == 7;
            jTextField_OutputRateCustom.setEnabled(Custom_Rate);
            jLabel_OutputRateCustomLabel.setEnabled(Custom_Rate);
        }
    }

    void Set_OutputEthernetConnection_Enable(boolean set_unset) {
        this.DisableEnableAllPanelComponents(jPanel_OutPutEthernet, set_unset);
        jPanel_OutPutEthernet.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Ethernet Parameters", 0, 0, new Font("Tahoma", 1, 11), set_unset ? Color.black : Color.GRAY));
        if (set_unset && jComboBox_EthConnectionType.getSelectedItem().toString().contains("Server")) {
            jTextField_OutputIPAdress1.setForeground(Color.GRAY);
            jTextField_OutputIPAdress1.setEnabled(false);
            jTextField_OutputIPAdress2.setForeground(Color.GRAY);
            jTextField_OutputIPAdress2.setEnabled(false);
            jTextField_OutputIPAdress3.setForeground(Color.GRAY);
            jTextField_OutputIPAdress3.setEnabled(false);
            jTextField_OutputIPAdress4.setForeground(Color.GRAY);
            jTextField_OutputIPAdress4.setEnabled(false);
        }
    }

    void Set_OutputSerialConnection_Enable(boolean set_unset) {
        this.DisableEnableAllPanelComponents(jPanel_OutputSerial, set_unset);
        jPanel_OutputSerial.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Serial Parameters", 0, 0, new Font("Tahoma", 1, 11), set_unset ? Color.black : Color.GRAY));
    }

    public void ConstructProtocolsParamsPanel() {
        int Output_Id = 0;
        for (Output_Id = 1; Output_Id <= 7; ++Output_Id) {
            jComboBox_ProtocolParams_OutputId.addItem("Output " + Integer.toString(Output_Id));
        }
        for (int i = 0; i < 4; ++i) {
            jComboBox_OutputGPSId.addItem(Integer.toString(i + 1));
            jComboBox_OutputLBLId.addItem(Integer.toString(i + 1));
            jComboBox_OutputDVLId.addItem(Integer.toString(i + 1));
            jComboBox_OutputUSBLId.addItem(Integer.toString(i + 1));
            jComboBox_OutputEMLOGId.addItem(Integer.toString(i + 1));
        }
        String all = "1->".concat(Integer.toString(4));
        jComboBox_OutputGPSId.addItem(all);
        jComboBox_OutputLBLId.addItem(all);
        jComboBox_OutputDVLId.addItem(all);
        jComboBox_OutputUSBLId.addItem(all);
        jComboBox_OutputEMLOGId.addItem(all);
    }

    public void UpdateProtocolsParamsPanel() {
        int i;
        int OutputId = jComboBox_ProtocolParams_OutputId.getSelectedIndex();
        int ProtoId = this.Info.OutputInfo[OutputId].GetProtocole();
        jLabel_ProtocoleName.setText(this.Proto_List.GetProtocolNameById(ProtoId));
        ProtocolEncoder ProtoEncoder = this.Proto_List.GetEncoderById(ProtoId);
        for (i = 0; i < 18; ++i) {
            this.jCheckBoxFrameEnableList[i].setEnabled(false);
            this.jCheckBoxFrameEnableList[i].setSelected(false);
            this.jCheckBoxFrameEnableList[i].setText("Not Used");
        }
        for (i = 0; i < ProtoEncoder.GetEncoderFramesNumber(); ++i) {
            this.jCheckBoxFrameEnableList[i].setEnabled(true);
            this.jCheckBoxFrameEnableList[i].setSelected(ProtoEncoder.GetEncoderFrameEnable(i, OutputId));
            this.jCheckBoxFrameEnableList[i].setText(ProtoEncoder.GetEncoderFrameName(i));
        }
        for (i = 0; i < 6; ++i) {
            this.jCheckBoxOptionsList[i].setEnabled(false);
            this.jCheckBoxOptionsList[i].setSelected(false);
            this.jCheckBoxOptionsList[i].setText("Not Used");
        }
        for (i = 0; i < ProtoEncoder.GetEncoderOptionsNumber(); ++i) {
            this.jCheckBoxOptionsList[i].setEnabled(true);
            this.jCheckBoxOptionsList[i].setSelected(ProtoEncoder.GetEncoderOptionEnable(i, OutputId));
            this.jCheckBoxOptionsList[i].setText(ProtoEncoder.GetEncoderOptionName(i));
        }
        this.SetjComboSelectedIndex(jComboBox_OutputGPSId, this.Info.OutputInfo[OutputId].Get_SelectedSensorId(0));
        this.SetjComboSelectedIndex(jComboBox_OutputUSBLId, this.Info.OutputInfo[OutputId].Get_SelectedSensorId(2));
        this.SetjComboSelectedIndex(jComboBox_OutputLBLId, this.Info.OutputInfo[OutputId].Get_SelectedSensorId(3));
        this.SetjComboSelectedIndex(jComboBox_OutputDVLId, this.Info.OutputInfo[OutputId].Get_SelectedSensorId(1));
        this.SetjComboSelectedIndex(jComboBox_OutputEMLOGId, this.Info.OutputInfo[OutputId].Get_SelectedSensorId(5));
    }

    public void UpdateProtocolsParamsInfos() {
        int i;
        int i2;
        int OutputId = jComboBox_ProtocolParams_OutputId.getSelectedIndex();
        int ProtoId = this.Info.OutputInfo[OutputId].GetProtocole();
        ProtocolEncoder ProtoEncoder = this.Proto_List.GetEncoderById(ProtoId);
        boolean[] FrameEnabled = new boolean[18];
        for (i2 = 0; i2 < 18; ++i2) {
            FrameEnabled[i2] = false;
        }
        for (i2 = 0; i2 < ProtoEncoder.GetEncoderFramesNumber(); ++i2) {
            FrameEnabled[i2] = this.jCheckBoxFrameEnableList[i2].isSelected();
        }
        boolean[] OptionEnabled = new boolean[6];
        for (i = 0; i < 6; ++i) {
            OptionEnabled[i] = false;
        }
        for (i = 0; i < ProtoEncoder.GetEncoderOptionsNumber(); ++i) {
            OptionEnabled[i] = this.jCheckBoxOptionsList[i].isSelected();
        }
        ProtoEncoder.SetEncoderFramesEnabled(FrameEnabled, OutputId);
        ProtoEncoder.SetEncoderOptionsEnabled(OptionEnabled, OutputId);
        this.Info.OutputInfo[OutputId].Set_SensorId(jComboBox_OutputGPSId.getSelectedIndex(), jComboBox_OutputUSBLId.getSelectedIndex(), jComboBox_OutputLBLId.getSelectedIndex(), jComboBox_OutputEMLOGId.getSelectedIndex(), jComboBox_OutputDVLId.getSelectedIndex());
    }

    public void DisableEnableAllPanelComponents(JPanel panel, boolean enable) {
        Component[] c = panel.getComponents();
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            c[i].setForeground(enable ? Color.black : Color.GRAY);
            c[i].setEnabled(enable);
        }
    }

    public void SetjComboSelectedIndex(JComboBox _ComboBox, int Selected_Item) {
        if (_ComboBox.getItemCount() != 0) {
            if (Selected_Item < _ComboBox.getItemCount()) {
                _ComboBox.setSelectedIndex(Selected_Item);
            } else {
                _ComboBox.setSelectedIndex(0);
            }
        }
    }

    public void SetjComboSelectedIndex(JComboBox _ComboBox, String Selected_Item) {
        if (_ComboBox.getItemCount() != 0) {
            for (int i = 0; i < _ComboBox.getItemCount(); ++i) {
                if (!_ComboBox.getItemAt(i).toString().equalsIgnoreCase(Selected_Item)) continue;
                _ComboBox.setSelectedItem(Selected_Item);
            }
        }
    }

    void UpdateControlPanel() {
        jLabel_InfoOuput1.setText(this.Info.OutputInfo[0].GetFlow_ProtocolInfo(this.Proto_List));
        jLabel_InfoOuput2.setText(this.Info.OutputInfo[1].GetFlow_ProtocolInfo(this.Proto_List));
        jLabel_InfoOuput3.setText(this.Info.OutputInfo[2].GetFlow_ProtocolInfo(this.Proto_List));
        jLabel_InfoOuput4.setText(this.Info.OutputInfo[3].GetFlow_ProtocolInfo(this.Proto_List));
        jLabel_InfoOuput5.setText(this.Info.OutputInfo[4].GetFlow_ProtocolInfo(this.Proto_List));
        jLabel_InfoOuput6.setText(this.Info.OutputInfo[5].GetFlow_ProtocolInfo(this.Proto_List));
        jLabel_InfoOuput7.setText(this.Info.OutputInfo[6].GetFlow_ProtocolInfo(this.Proto_List));
        jLabel_InfoOuputInterface1.setText(this.Info.OutputInfo[0].GetFlow_InterfaceInfo(this.Proto_List));
        jLabel_InfoOuputInterface2.setText(this.Info.OutputInfo[1].GetFlow_InterfaceInfo(this.Proto_List));
        jLabel_InfoOuputInterface3.setText(this.Info.OutputInfo[2].GetFlow_InterfaceInfo(this.Proto_List));
        jLabel_InfoOuputInterface4.setText(this.Info.OutputInfo[3].GetFlow_InterfaceInfo(this.Proto_List));
        jLabel_InfoOuputInterface5.setText(this.Info.OutputInfo[4].GetFlow_InterfaceInfo(this.Proto_List));
        jLabel_InfoOuputInterface6.setText(this.Info.OutputInfo[5].GetFlow_InterfaceInfo(this.Proto_List));
        jLabel_InfoOuputInterface7.setText(this.Info.OutputInfo[6].GetFlow_InterfaceInfo(this.Proto_List));
        jLabel_InfoOuput1.setForeground(this.Info.OutputInfo[0].GetFlowInfoColor());
        jLabel_InfoOuput2.setForeground(this.Info.OutputInfo[1].GetFlowInfoColor());
        jLabel_InfoOuput3.setForeground(this.Info.OutputInfo[2].GetFlowInfoColor());
        jLabel_InfoOuput4.setForeground(this.Info.OutputInfo[3].GetFlowInfoColor());
        jLabel_InfoOuput5.setForeground(this.Info.OutputInfo[4].GetFlowInfoColor());
        jLabel_InfoOuput6.setForeground(this.Info.OutputInfo[5].GetFlowInfoColor());
        jLabel_InfoOuput7.setForeground(this.Info.OutputInfo[6].GetFlowInfoColor());
        jLabel_InfoOuputInterface1.setForeground(this.Info.OutputInfo[0].GetFlowInfoColor());
        jLabel_InfoOuputInterface2.setForeground(this.Info.OutputInfo[1].GetFlowInfoColor());
        jLabel_InfoOuputInterface3.setForeground(this.Info.OutputInfo[2].GetFlowInfoColor());
        jLabel_InfoOuputInterface4.setForeground(this.Info.OutputInfo[3].GetFlowInfoColor());
        jLabel_InfoOuputInterface5.setForeground(this.Info.OutputInfo[4].GetFlowInfoColor());
        jLabel_InfoOuputInterface6.setForeground(this.Info.OutputInfo[5].GetFlowInfoColor());
        jLabel_InfoOuputInterface7.setForeground(this.Info.OutputInfo[6].GetFlowInfoColor());
        for (int OutputId = 0; OutputId < 7; ++OutputId) {
            if (SimulatorFrame.Manager.OutputManager[OutputId].IsStarted.booleanValue()) {
                this.jButton_ConnectOutputList[OutputId].setText("Disconnect");
            } else {
                this.jButton_ConnectOutputList[OutputId].setText("Connect");
            }
            if (this.Info.OutputInfo[OutputId].GetFlowEnabled() == 1) {
                this.jButton_ConnectOutputList[OutputId].setEnabled(true);
                continue;
            }
            this.jButton_ConnectOutputList[OutputId].setEnabled(false);
        }
    }

    public static void SetMessage(int Type2, String _Message, Color _Color) {
        switch (Type2) {
            case 0: {
                jLabel_Output1State.setText(_Message);
                jLabel_Output1State.setForeground(_Color);
                break;
            }
            case 1: {
                jLabel_Output2State.setText(_Message);
                jLabel_Output2State.setForeground(_Color);
                break;
            }
            case 2: {
                jLabel_Output3State.setText(_Message);
                jLabel_Output3State.setForeground(_Color);
                break;
            }
            case 3: {
                jLabel_Output4State.setText(_Message);
                jLabel_Output4State.setForeground(_Color);
                break;
            }
            case 4: {
                jLabel_Output5State.setText(_Message);
                jLabel_Output5State.setForeground(_Color);
                break;
            }
            case 5: {
                jLabel_Output6State.setText(_Message);
                jLabel_Output6State.setForeground(_Color);
                break;
            }
            case 6: {
                jLabel_Output7State.setText(_Message);
                jLabel_Output7State.setForeground(_Color);
            }
        }
    }

    public void ConstructDisplayPanel() {
        int Output_Id = 0;
        for (Output_Id = 1; Output_Id <= 7; ++Output_Id) {
            jComboBox_OutputDisplayId.addItem("Output " + Integer.toString(Output_Id));
        }
    }

    public void ConstructScramblingPanel() {
        int ScrambleMax = 10;
        jSlider_Scramble_AddChar.setMaximum(ScrambleMax);
        jSlider_Scramble_SuppressChar.setMaximum(ScrambleMax);
        jSlider_Scramble_ReplaceChar.setMaximum(ScrambleMax);
        jSlider_Scramble_AddField.setMaximum(ScrambleMax);
        jSlider_Scramble_SuppressField.setMaximum(ScrambleMax);
    }

    public void Construct_GPS_Panel() {
        for (int i = 0; i < 4; ++i) {
            jComboBox_GPSId.addItem("GPS " + Integer.toString(i + 1));
        }
        jComboBox_GPSQuality.addItem("NA");
        jComboBox_GPSQuality.addItem("Natural");
        jComboBox_GPSQuality.addItem("Differential");
        jComboBox_GPSQuality.addItem("Military");
        jComboBox_GPSQuality.addItem("RTK");
        jComboBox_GPSQuality.addItem("Float RTK");
        jComboBox_GPSQuality.addItem("Other");
        jComboBox_OperatingMode.addItem("Autonomous");
        jComboBox_OperatingMode.addItem("Differential ");
        jComboBox_OperatingMode.addItem("Estimated");
        jComboBox_OperatingMode.addItem("Manual");
        jComboBox_OperatingMode.addItem("Simulator");
        jComboBox_OperatingMode.addItem("Not valid");
    }

    public void Update_SIMSTIM_Panel() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[10][0];
        jTextField_StimHeading.setText(Double.toString(Sensor.Get_Heading(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_StimRoll.setText(Double.toString(Sensor.Get_Roll(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_StimPitch.setText(Double.toString(Sensor.Get_Pitch(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_StimLatitude.setText(Double.toString(Sensor.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_StimLongitude.setText(Double.toString(Sensor.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_StimAltitude.setText(Double.toString(Sensor.Get_Altitude(ConvertTool.UNITS.UNITE_M)));
        jTextField_StimAltiRef.setText(Integer.toString(Sensor.Get_AltitudeReference()));
        jTextField_StimSpeedNorth.setText(Double.toString(Sensor.Get_Speed_North(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_StimSpeedEast.setText(Double.toString(Sensor.Get_Speed_East(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_StimSpeedUp.setText(Double.toString(Sensor.Get_Speed_Up(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_StimRotRateX.setText(Double.toString(Sensor.Get_RotationRate_X(ConvertTool.UNITS.UNITE_DEGREE_PER_S)));
        jTextField_StimRotRateY.setText(Double.toString(Sensor.Get_RotationRate_Y(ConvertTool.UNITS.UNITE_DEGREE_PER_S)));
        jTextField_StimRotRateZ.setText(Double.toString(Sensor.Get_RotationRate_Z(ConvertTool.UNITS.UNITE_DEGREE_PER_S)));
        jTextField_StimAccelX.setText(Double.toString(Sensor.Get_Acceleration_X(ConvertTool.UNITS.UNITE_M_S2)));
        jTextField_StimAccelY.setText(Double.toString(Sensor.Get_Acceleration_Y(ConvertTool.UNITS.UNITE_M_S2)));
        jTextField_StimAccelZ.setText(Double.toString(Sensor.Get_Acceleration_Z(ConvertTool.UNITS.UNITE_M_S2)));
    }

    public void Update_GPS_Panel() {
        int GPS_ID = jComboBox_GPSId.getSelectedIndex();
        ExternalSensorInfo Sensor = this.Info.ExtInfo[0][GPS_ID];
        if (Sensor.Get_Validity() == 1) {
            jCheckBox_GPSValidity.setSelected(true);
        } else {
            jCheckBox_GPSValidity.setSelected(false);
        }
        this.SetjComboSelectedIndex(jComboBox_GPSQuality, Sensor.Get_Quality());
        this.SetjComboSelectedIndex(jComboBox_OperatingMode, Sensor.Get_OperatingMode());
        jTextField_GPSLatitude.setText(Double.toString(Sensor.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_GPSLongitude.setText(Double.toString(Sensor.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_GPSAltitude.setText(Double.toString(Sensor.Get_Altitude(ConvertTool.UNITS.UNITE_M)));
        jTextField_GPSLatitudeStd.setText(Double.toString(Sensor.Get_LatitudeStd(ConvertTool.UNITS.UNITE_M)));
        jTextField_GPSLongitudeStd.setText(Double.toString(Sensor.Get_LongitudeStd(ConvertTool.UNITS.UNITE_M)));
        jTextField_GPSAltitudeStd.setText(Double.toString(Sensor.Get_AltitudeStd(ConvertTool.UNITS.UNITE_M)));
        jTextField_GPSLatLongCov.setText(Double.toString(Sensor.Get_LatLongCov(ConvertTool.UNITS.UNITE_M)));
        jTextField_GPSLatency.setText(Double.toString(Sensor.Get_Latency(ConvertTool.UNITS.UNITE_S)));
        jTextField_GPSGeoidalSep.setText(Double.toString(Sensor.Get_GeoidalSep(ConvertTool.UNITS.UNITE_M)));
        jTextField_GPSCourse.setText(Double.toString(Sensor.Get_Course(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_GPSSpeed.setText(Double.toString(Sensor.Get_Speed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_GPSEllipseMajorAxis.setText(Double.toString(Sensor.Get_EllipseMajorAxis(ConvertTool.UNITS.UNITE_M)));
        jTextField_GPSEllipseMinorAxis.setText(Double.toString(Sensor.Get_EllipseMinorAxis(ConvertTool.UNITS.UNITE_M)));
        jTextField_GPSEllipseAngle.setText(Double.toString(Sensor.Get_EllipseAngle(ConvertTool.UNITS.UNITE_DEGREE)));
    }

    public void Update_GPS_Infos() {
        int GPS_ID = jComboBox_GPSId.getSelectedIndex();
        ExternalSensorInfo Sensor = this.Info.ExtInfo[0][GPS_ID];
        if (jCheckBox_GPSValidity.isSelected()) {
            Sensor.Set_Validity(1);
        } else {
            Sensor.Set_Validity(0);
        }
        Sensor.Set_Quality(jComboBox_GPSQuality.getSelectedIndex());
        Sensor.Set_OperatingMode(jComboBox_OperatingMode.getSelectedIndex());
        Sensor.Set_Latitude(Double.parseDouble(jTextField_GPSLatitude.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Longitude(Double.parseDouble(jTextField_GPSLongitude.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Altitude(Double.parseDouble(jTextField_GPSAltitude.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_LatitudeStd(Double.parseDouble(jTextField_GPSLatitudeStd.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_LongitudeStd(Double.parseDouble(jTextField_GPSLongitudeStd.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_AltitudeStd(Double.parseDouble(jTextField_GPSAltitudeStd.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_LatLongCov(Double.parseDouble(jTextField_GPSLatLongCov.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_Latency(Double.parseDouble(jTextField_GPSLatency.getText()), ConvertTool.UNITS.UNITE_S);
        Sensor.Set_GeoidalSep(Double.parseDouble(jTextField_GPSGeoidalSep.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_Course(Double.parseDouble(jTextField_GPSCourse.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Speed(Double.parseDouble(jTextField_GPSSpeed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_EllipseMajorAxis(Double.parseDouble(jTextField_GPSEllipseMajorAxis.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_EllipseMinorAxis(Double.parseDouble(jTextField_GPSEllipseMinorAxis.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_EllipseAngle(Double.parseDouble(jTextField_GPSEllipseAngle.getText()), ConvertTool.UNITS.UNITE_DEGREE);
    }

    public void Construct_DEPTH_Panel() {
    }

    public void Update_DEPTH_Panel() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[4][0];
        if (Sensor.Get_CompensatedData() >= 1) {
            jCheckBox_CompensatedData.setSelected(false);
        } else {
            jCheckBox_CompensatedData.setSelected(true);
        }
        if (Sensor.Get_Validity() == 1) {
            jCheckBox_DEPTHValidity.setSelected(true);
        } else {
            jCheckBox_DEPTHValidity.setSelected(false);
        }
        jTextField_DEPTHDepth.setText(Double.toString(Sensor.Get_Depth(ConvertTool.UNITS.UNITE_M)));
        jTextField_DEPTHDepthStd.setText(Double.toString(Sensor.Get_DepthStd(ConvertTool.UNITS.UNITE_M)));
        jTextField_DEPTH_Pressure.setText(Double.toString(Sensor.Get_Latency(ConvertTool.UNITS.UNITE_S)));
        jTextField_Depth_SoundSpeed.setText(Double.toString(Sensor.Get_SoundSpeed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DEPTH_Pressure.setText(Double.toString(Sensor.Get_Pressure(ConvertTool.UNITS.UNITE_DBAR)));
        jTextField_Depth_Temperature.setText(Double.toString(Sensor.Get_Temperature(ConvertTool.UNITS.UNITE_DEGCEL)));
    }

    public void Update_DEPTH_Infos() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[4][0];
        if (jCheckBox_CompensatedData.isSelected()) {
            Sensor.Set_CompensatedData(0);
        } else {
            Sensor.Set_CompensatedData(1);
        }
        if (jCheckBox_DEPTHValidity.isSelected()) {
            Sensor.Set_Validity(1);
        } else {
            Sensor.Set_Validity(0);
        }
        Sensor.Set_Depth(Double.parseDouble(jTextField_DEPTHDepth.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_DepthStd(Double.parseDouble(jTextField_DEPTHDepthStd.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_Latency(Double.parseDouble(jTextField_DEPTHLatency.getText()), ConvertTool.UNITS.UNITE_S);
        Sensor.Set_SoundSpeed(Double.parseDouble(jTextField_Depth_SoundSpeed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_Pressure(Double.parseDouble(jTextField_DEPTH_Pressure.getText()), ConvertTool.UNITS.UNITE_DBAR);
        Sensor.Set_Temperature(Double.parseDouble(jTextField_Depth_Temperature.getText()), ConvertTool.UNITS.UNITE_DEGCEL);
    }

    public void Construct_DVL_Panel() {
        for (int i = 0; i < 4; ++i) {
            jComboBox_DVLId.addItem("DVL " + Integer.toString(i + 1));
        }
    }

    public void Update_DVL_Panel() {
        int DVL_ID = jComboBox_DVLId.getSelectedIndex();
        ExternalSensorInfo Sensor = this.Info.ExtInfo[1][DVL_ID];
        if (Sensor.Get_BT_Validity() == 1) {
            jCheckBox_DVLBTValidity.setSelected(true);
        } else {
            jCheckBox_DVLBTValidity.setSelected(false);
        }
        jTextField_DVLBT_XS1Speed.setText(Double.toString(Sensor.Get_BT_XS1Speed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLBT_XS2Speed.setText(Double.toString(Sensor.Get_BT_XS2Speed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLBT_XS3Speed.setText(Double.toString(Sensor.Get_BT_XS3Speed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLBT_XS1SpeedStd.setText(Double.toString(Sensor.Get_BT_XS1SpeedStd(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLBT_XS2SpeedStd.setText(Double.toString(Sensor.Get_BT_XS2SpeedStd(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLBT_XS3SpeedStd.setText(Double.toString(Sensor.Get_BT_XS3SpeedStd(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLBT_SoundSpeed.setText(Double.toString(Sensor.Get_BT_SoundSpeed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLBT_Altitude.setText(Double.toString(Sensor.Get_BT_Altitude(ConvertTool.UNITS.UNITE_M)));
        jTextField_DVLBT_Latency.setText(Double.toString(Sensor.Get_BT_Latency(ConvertTool.UNITS.UNITE_S)));
        if (Sensor.Get_WT_Validity() == 1) {
            jCheckBox_DVLWTValidity.setSelected(true);
        } else {
            jCheckBox_DVLWTValidity.setSelected(false);
        }
        jTextField_DVLWT_XS1Speed.setText(Double.toString(Sensor.Get_WT_XS1Speed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLWT_XS2Speed.setText(Double.toString(Sensor.Get_WT_XS2Speed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLWT_XS3Speed.setText(Double.toString(Sensor.Get_WT_XS3Speed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLWT_XS1SpeedStd.setText(Double.toString(Sensor.Get_WT_XS1SpeedStd(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLWT_XS2SpeedStd.setText(Double.toString(Sensor.Get_WT_XS2SpeedStd(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLWT_XS3SpeedStd.setText(Double.toString(Sensor.Get_WT_XS3SpeedStd(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLWT_SoundSpeed.setText(Double.toString(Sensor.Get_WT_SoundSpeed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_DVLWT_Altitude.setText(Double.toString(Sensor.Get_WT_Altitude(ConvertTool.UNITS.UNITE_M)));
        jTextField_DVLWT_Latency.setText(Double.toString(Sensor.Get_WT_Latency(ConvertTool.UNITS.UNITE_S)));
    }

    public void Update_DVL_Infos() {
        int DVL_ID = jComboBox_DVLId.getSelectedIndex();
        ExternalSensorInfo Sensor = this.Info.ExtInfo[1][DVL_ID];
        if (jCheckBox_DVLBTValidity.isSelected()) {
            Sensor.Set_BT_Validity(1);
        } else {
            Sensor.Set_BT_Validity(0);
        }
        Sensor.Set_CoordinateVelocities(this.jComboBox_CoordinateVelocities.getSelectedIndex());
        Sensor.Set_BT_XS1Speed(Double.parseDouble(jTextField_DVLBT_XS1Speed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_BT_XS2Speed(Double.parseDouble(jTextField_DVLBT_XS2Speed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_BT_XS3Speed(Double.parseDouble(jTextField_DVLBT_XS3Speed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_BT_XS1SpeedStd(Double.parseDouble(jTextField_DVLBT_XS1SpeedStd.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_BT_XS2SpeedStd(Double.parseDouble(jTextField_DVLBT_XS2SpeedStd.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_BT_XS3SpeedStd(Double.parseDouble(jTextField_DVLBT_XS3SpeedStd.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_BT_SoundSpeed(Double.parseDouble(jTextField_DVLBT_SoundSpeed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_BT_Altitude(Double.parseDouble(jTextField_DVLBT_Altitude.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_BT_Latency(Double.parseDouble(jTextField_DVLBT_Latency.getText()), ConvertTool.UNITS.UNITE_S);
        if (jCheckBox_DVLWTValidity.isSelected()) {
            Sensor.Set_WT_Validity(1);
        } else {
            Sensor.Set_WT_Validity(0);
        }
        Sensor.Set_WT_XS1Speed(Double.parseDouble(jTextField_DVLWT_XS1Speed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_WT_XS2Speed(Double.parseDouble(jTextField_DVLWT_XS2Speed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_WT_XS3Speed(Double.parseDouble(jTextField_DVLWT_XS3Speed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_WT_XS1SpeedStd(Double.parseDouble(jTextField_DVLWT_XS1SpeedStd.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_WT_XS2SpeedStd(Double.parseDouble(jTextField_DVLWT_XS2SpeedStd.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_WT_XS3SpeedStd(Double.parseDouble(jTextField_DVLWT_XS3SpeedStd.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_WT_SoundSpeed(Double.parseDouble(jTextField_DVLWT_SoundSpeed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_WT_Altitude(Double.parseDouble(jTextField_DVLWT_Altitude.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_WT_Latency(Double.parseDouble(jTextField_DVLWT_Latency.getText()), ConvertTool.UNITS.UNITE_S);
    }

    public void Construct_LBL_Panel() {
        for (int i = 0; i < 4; ++i) {
            jComboBox_LBLId.addItem("LBL " + Integer.toString(i + 1));
        }
        jTextField_LBLBeaconCode.setDocument(new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-+0123456789.", 3, 0));
    }

    public void Update_LBL_Panel() {
        int LBL_ID = jComboBox_LBLId.getSelectedIndex();
        ExternalSensorInfo Sensor = this.Info.ExtInfo[3][LBL_ID];
        if (Sensor.Get_Validity() == 1) {
            jCheckBox_LBLValidity.setSelected(true);
        } else {
            jCheckBox_LBLValidity.setSelected(false);
        }
        jTextField_LBLLatitude.setText(Double.toString(Sensor.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_LBLLongitude.setText(Double.toString(Sensor.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_LBLDepth.setText(Double.toString(Sensor.Get_Depth(ConvertTool.UNITS.UNITE_M)));
        jTextField_LBLRange.setText(Double.toString(Sensor.Get_Range(ConvertTool.UNITS.UNITE_M)));
        jTextField_LBLRangeStd.setText(Double.toString(Sensor.Get_RangeStd(ConvertTool.UNITS.UNITE_M)));
        jTextField_LBLLatency.setText(Double.toString(Sensor.Get_Latency(ConvertTool.UNITS.UNITE_S)));
        jTextField_LBLBeaconCode.setText(Sensor.Get_BeaconCodeId());
    }

    public void Update_LBL_Infos() {
        int LBL_ID = jComboBox_LBLId.getSelectedIndex();
        ExternalSensorInfo Sensor = this.Info.ExtInfo[3][LBL_ID];
        if (jCheckBox_LBLValidity.isSelected()) {
            Sensor.Set_Validity(1);
        } else {
            Sensor.Set_Validity(0);
        }
        Sensor.Set_Latitude(Double.parseDouble(jTextField_LBLLatitude.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Longitude(Double.parseDouble(jTextField_LBLLongitude.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Depth(Double.parseDouble(jTextField_LBLDepth.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_Range(Double.parseDouble(jTextField_LBLRange.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_RangeStd(Double.parseDouble(jTextField_LBLRangeStd.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_Latency(Double.parseDouble(jTextField_LBLLatency.getText()), ConvertTool.UNITS.UNITE_S);
        Sensor.Set_BeaconCodeId(jTextField_LBLBeaconCode.getText());
    }

    public void Construct_USBL_Panel() {
        for (int i = 0; i < 4; ++i) {
            jComboBox_USBLId.addItem("USBL " + Integer.toString(i + 1));
        }
        jTextField_USBLBeaconCodeID.setDocument(new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-+0123456789.", 3, 0));
        jTextField_USBLBeaconNumID.setDocument(new JTextFieldFilter("-+0123456789.", 5, 32768));
    }

    public void Update_USBL_Panel() {
        int USBL_ID = jComboBox_USBLId.getSelectedIndex();
        ExternalSensorInfo Sensor = this.Info.ExtInfo[2][USBL_ID];
        if (Sensor.Get_Validity() == 1) {
            jCheckBox_USBLValidity.setSelected(true);
        } else {
            jCheckBox_USBLValidity.setSelected(false);
        }
        jTextField_USBLLatitude.setText(Double.toString(Sensor.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_USBLLongitude.setText(Double.toString(Sensor.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_USBLUTMEst.setText(Double.toString(Sensor.Get_UTM_East(ConvertTool.UNITS.UNITE_M)));
        jTextField_USBLUTMNord.setText(Double.toString(Sensor.Get_UTM_North(ConvertTool.UNITS.UNITE_M)));
        jTextField_USBLUTMZone.setText(Sensor.Get_UTM_Zone());
        jTextField_USBLDepth.setText(Double.toString(Sensor.Get_Depth(ConvertTool.UNITS.UNITE_M)));
        jTextField_USBLLatitudeStd.setText(Double.toString(Sensor.Get_LatitudeStd(ConvertTool.UNITS.UNITE_M)));
        jTextField_USBLLongitudeStd.setText(Double.toString(Sensor.Get_LongitudeStd(ConvertTool.UNITS.UNITE_M)));
        jTextField_USBLDepthStd.setText(Double.toString(Sensor.Get_DepthStd(ConvertTool.UNITS.UNITE_M)));
        jTextField_USBLLatLongCov.setText(Double.toString(Sensor.Get_LatLongCov(ConvertTool.UNITS.UNITE_M)));
        jTextField_USBLLatency.setText(Double.toString(Sensor.Get_Latency(ConvertTool.UNITS.UNITE_S)));
        jTextField_USBLBeaconCodeID.setText(Sensor.Get_BeaconCodeId());
        jTextField_USBLBeaconNumID.setText(Integer.toString(Sensor.Get_BeaconNumId()));
        jTextField_USBLMajorAxis.setText(Double.toString(Sensor.Get_EllipseMajorAxis(ConvertTool.UNITS.UNITE_M)));
        jTextField_USBLMinorAxis.setText(Double.toString(Sensor.Get_EllipseMinorAxis(ConvertTool.UNITS.UNITE_M)));
        jTextField_USBLMajorAxisDir.setText(Double.toString(Sensor.Get_EllipseAngle(ConvertTool.UNITS.UNITE_DEGREE)));
    }

    public void Update_USBL_Infos() {
        int USBL_ID = jComboBox_USBLId.getSelectedIndex();
        ExternalSensorInfo Sensor = this.Info.ExtInfo[2][USBL_ID];
        if (jCheckBox_USBLValidity.isSelected()) {
            Sensor.Set_Validity(1);
        } else {
            Sensor.Set_Validity(0);
        }
        Sensor.Set_Latitude(Double.parseDouble(jTextField_USBLLatitude.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Longitude(Double.parseDouble(jTextField_USBLLongitude.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_UTM_East(Double.parseDouble(jTextField_USBLUTMEst.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_UTM_North(Double.parseDouble(jTextField_USBLUTMNord.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_UTM_Zone(jTextField_USBLUTMZone.getText());
        Sensor.Set_Depth(Double.parseDouble(jTextField_USBLDepth.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_LatitudeStd(Double.parseDouble(jTextField_USBLLatitudeStd.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_LongitudeStd(Double.parseDouble(jTextField_USBLLongitudeStd.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_DepthStd(Double.parseDouble(jTextField_USBLDepthStd.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_LatLongCov(Double.parseDouble(jTextField_USBLLatLongCov.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_Latency(Double.parseDouble(jTextField_USBLLatency.getText()), ConvertTool.UNITS.UNITE_S);
        Sensor.Set_BeaconCodeId(jTextField_USBLBeaconCodeID.getText());
        Sensor.Set_BeaconNumId(Integer.parseInt(jTextField_USBLBeaconNumID.getText()));
        Sensor.Set_EllipseMajorAxis(Double.parseDouble(jTextField_USBLMajorAxis.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_EllipseMinorAxis(Double.parseDouble(jTextField_USBLMinorAxis.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_EllipseAngle(Double.parseDouble(jTextField_USBLMajorAxisDir.getText()), ConvertTool.UNITS.UNITE_DEGREE);
    }

    public void Update_CTD_Panel() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[6][0];
        if (Sensor.Get_Validity() == 1) {
            jCheckBox_CTDValidity.setSelected(true);
        } else {
            jCheckBox_CTDValidity.setSelected(false);
        }
        jTextField_CTDConductivity.setText(Double.toString(Sensor.Get_Conductivity(ConvertTool.UNITS.UNITE_S_m)));
        jTextField_CTDPressure.setText(Double.toString(Sensor.Get_Pressure(ConvertTool.UNITS.UNITE_DBAR)));
        jTextField_CTDTemperature.setText(Double.toString(Sensor.Get_Temperature(ConvertTool.UNITS.UNITE_DEGCEL)));
        jTextField_CTDSalinity.setText(Double.toString(Sensor.Get_Salinity(ConvertTool.UNITS.UNITE_PSU)));
        jTextField_CTDDepth.setText(Double.toString(Sensor.Get_Depth(ConvertTool.UNITS.UNITE_M)));
        jTextField_CTDSoundSpeed.setText(Double.toString(Sensor.Get_SoundSpeed(ConvertTool.UNITS.UNITE_M_S)));
    }

    public void Update_CTD_Infos() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[6][0];
        if (jCheckBox_CTDValidity.isSelected()) {
            Sensor.Set_Validity(1);
        } else {
            Sensor.Set_Validity(0);
        }
        Sensor.Set_Conductivity(Double.parseDouble(jTextField_CTDConductivity.getText()), ConvertTool.UNITS.UNITE_S_m);
        Sensor.Set_Pressure(Double.parseDouble(jTextField_CTDPressure.getText()), ConvertTool.UNITS.UNITE_DBAR);
        Sensor.Set_Temperature(Double.parseDouble(jTextField_CTDTemperature.getText()), ConvertTool.UNITS.UNITE_DEGCEL);
        Sensor.Set_Salinity(Double.parseDouble(jTextField_CTDSalinity.getText()), ConvertTool.UNITS.UNITE_PSU);
        Sensor.Set_Depth(Double.parseDouble(jTextField_CTDDepth.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_SoundSpeed(Double.parseDouble(jTextField_CTDSoundSpeed.getText()), ConvertTool.UNITS.UNITE_M_S);
    }

    public void Update_GRAVI_Panel() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[7][0];
        if (Sensor.Get_Validity() == 1) {
            jCheckBox_GraviValidity.setSelected(true);
        } else {
            jCheckBox_GraviValidity.setSelected(false);
        }
        jTextField_Gravi_Lat.setText(Double.toString(Sensor.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_Gravi_Long.setText(Double.toString(Sensor.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_Gravi_Xi.setText(Double.toString(Sensor.Get_Deflection_Xi(ConvertTool.UNITS.UNITE_SEC_ARC)));
        jTextField_Gravi_Eta.setText(Double.toString(Sensor.Get_Deflection_Eta(ConvertTool.UNITS.UNITE_SEC_ARC)));
        jTextField_Gravi_Norm.setText(Double.toString(Sensor.Get_Deviation_Norm(ConvertTool.UNITS.UNITE_MILLIGAL)));
    }

    public void Update_GRAVI_Infos() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[7][0];
        if (jCheckBox_GraviValidity.isSelected()) {
            Sensor.Set_Validity(1);
        } else {
            Sensor.Set_Validity(0);
        }
        Sensor.Set_Latitude(Double.parseDouble(jTextField_Gravi_Lat.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Longitude(Double.parseDouble(jTextField_Gravi_Long.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Deflection_Xi(Double.parseDouble(jTextField_Gravi_Xi.getText()), ConvertTool.UNITS.UNITE_SEC_ARC);
        Sensor.Set_Deflection_Eta(Double.parseDouble(jTextField_Gravi_Eta.getText()), ConvertTool.UNITS.UNITE_SEC_ARC);
        Sensor.Set_Deviation_Norm(Double.parseDouble(jTextField_Gravi_Norm.getText()), ConvertTool.UNITS.UNITE_MILLIGAL);
    }

    public void Update_PLATFORM_Panel() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[8][0];
        jTextField_Platform_PosX.setText(Double.toString(Sensor.Get_Pos(0, ConvertTool.UNITS.UNITE_M)));
        jTextField_Platform_PosY.setText(Double.toString(Sensor.Get_Pos(1, ConvertTool.UNITS.UNITE_M)));
        jTextField_Platform_PosZ.setText(Double.toString(Sensor.Get_Pos(2, ConvertTool.UNITS.UNITE_M)));
        jTextField_Platform_OrientX.setText(Double.toString(Sensor.Get_Orient(0, ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_Platform_OrientY.setText(Double.toString(Sensor.Get_Orient(1, ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_Platform_OrientZ.setText(Double.toString(Sensor.Get_Orient(2, ConvertTool.UNITS.UNITE_DEGREE)));
        jTextField_Platform_Status.setText(Integer.toString(Sensor.Get_Status()));
    }

    public void Update_PLATFORM_Infos() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[8][0];
        Sensor.Set_Pos(0, Double.parseDouble(jTextField_Platform_PosX.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_Pos(1, Double.parseDouble(jTextField_Platform_PosY.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_Pos(2, Double.parseDouble(jTextField_Platform_PosZ.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_Orient(0, Double.parseDouble(jTextField_Platform_OrientX.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Orient(1, Double.parseDouble(jTextField_Platform_OrientY.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Orient(2, Double.parseDouble(jTextField_Platform_OrientZ.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Status(Integer.parseInt(jTextField_Platform_Status.getText()));
    }

    public void Construct_EMLOG_Panel() {
        for (int i = 0; i < 4; ++i) {
            jComboBox_EMLOGId.addItem("EMLOG " + Integer.toString(i + 1));
        }
    }

    public void Update_EMLOG_Panel() {
        int EMLOG_ID = jComboBox_EMLOGId.getSelectedIndex();
        ExternalSensorInfo Sensor = this.Info.ExtInfo[5][EMLOG_ID];
        if (Sensor.Get_Validity() == 1) {
            jCheckBox_LochEmValidity.setSelected(true);
        } else {
            jCheckBox_LochEmValidity.setSelected(false);
        }
        jTextField_LogEM_LongWaterSpeed.setText(Double.toString(Sensor.Get_LongWaterSpeed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_LogEM_LongWaterSpeedStd.setText(Double.toString(Sensor.Get_LongWaterSpeedStd(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_LogEM_TransWaterSpeed.setText(Double.toString(Sensor.Get_TransWaterSpeed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_LogEM_LongGroundSpeed.setText(Double.toString(Sensor.Get_LongGroundSpeed(ConvertTool.UNITS.UNITE_M_S)));
        jTextField_LogEM_TransGroundSpeed.setText(Double.toString(Sensor.Get_TransGroundSpeed(ConvertTool.UNITS.UNITE_M_S)));
    }

    public void Update_EMLOG_Infos() {
        int EMLOG_ID = jComboBox_EMLOGId.getSelectedIndex();
        ExternalSensorInfo Sensor = this.Info.ExtInfo[5][EMLOG_ID];
        if (jCheckBox_LochEmValidity.isSelected()) {
            Sensor.Set_Validity(1);
        } else {
            Sensor.Set_Validity(0);
        }
        Sensor.Set_LongWaterSpeed(Double.parseDouble(jTextField_LogEM_LongWaterSpeed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_LongWaterSpeedStd(Double.parseDouble(jTextField_LogEM_LongWaterSpeedStd.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_TransWaterSpeed(Double.parseDouble(jTextField_LogEM_TransWaterSpeed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_LongGroundSpeed(Double.parseDouble(jTextField_LogEM_LongGroundSpeed.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_TransGroundSpeed(Double.parseDouble(jTextField_LogEM_TransGroundSpeed.getText()), ConvertTool.UNITS.UNITE_M_S);
    }

    public void Update_DMI_Panel() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[9][0];
        if (Sensor.Get_Validity() == 1) {
            jCheckBox_DMIValidity.setSelected(true);
        } else {
            jCheckBox_DMIValidity.setSelected(false);
        }
        jTextField_DMIPulseCount.setText(Double.toString(Sensor.Get_PulseCount()));
    }

    public void Update_DMI_Infos() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[9][0];
        if (jCheckBox_DMIValidity.isSelected()) {
            Sensor.Set_Validity(1);
        } else {
            Sensor.Set_Validity(0);
        }
        Sensor.Set_PulseCount(Double.parseDouble(jTextField_DMIPulseCount.getText()));
    }

    public void Update_SIMSTIM_Infos() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[10][0];
        Sensor.Set_Heading(Double.parseDouble(jTextField_StimHeading.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Roll(Double.parseDouble(jTextField_StimRoll.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Pitch(Double.parseDouble(jTextField_StimPitch.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Latitude(Double.parseDouble(jTextField_StimLatitude.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Longitude(Double.parseDouble(jTextField_StimLongitude.getText()), ConvertTool.UNITS.UNITE_DEGREE);
        Sensor.Set_Altitude(Double.parseDouble(jTextField_StimAltitude.getText()), ConvertTool.UNITS.UNITE_M);
        Sensor.Set_AltitudeReference(Integer.parseInt(jTextField_StimAltiRef.getText()));
        Sensor.Set_Speed_North(Double.parseDouble(jTextField_StimSpeedNorth.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_Speed_East(Double.parseDouble(jTextField_StimSpeedEast.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_Speed_Up(Double.parseDouble(jTextField_StimSpeedUp.getText()), ConvertTool.UNITS.UNITE_M_S);
        Sensor.Set_RotationRate_X(Double.parseDouble(jTextField_StimRotRateX.getText()), ConvertTool.UNITS.UNITE_DEGREE_PER_S);
        Sensor.Set_RotationRate_Y(Double.parseDouble(jTextField_StimRotRateY.getText()), ConvertTool.UNITS.UNITE_DEGREE_PER_S);
        Sensor.Set_RotationRate_Z(Double.parseDouble(jTextField_StimRotRateZ.getText()), ConvertTool.UNITS.UNITE_DEGREE_PER_S);
        Sensor.Set_Acceleration_X(Double.parseDouble(jTextField_StimAccelX.getText()), ConvertTool.UNITS.UNITE_M_S2);
        Sensor.Set_Acceleration_Y(Double.parseDouble(jTextField_StimAccelY.getText()), ConvertTool.UNITS.UNITE_M_S2);
        Sensor.Set_Acceleration_Z(Double.parseDouble(jTextField_StimAccelZ.getText()), ConvertTool.UNITS.UNITE_M_S2);
    }

    private void ManageDVLNortekCheckboxes(int iDvlId) {
        if (iDvlId == 0) {
            jDvlBottomTrackUsed.setSelected(true);
            jDvlWaterTrackUsed.setSelected(false);
        }
        if (iDvlId == 1) {
            jDvlBottomTrackUsed.setSelected(false);
            jDvlWaterTrackUsed.setSelected(true);
        }
    }

    public void Update_DVL_NTK_Infos() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[11][0];
        Sensor.Set_DvlNtkId(jDvlBottomTrackUsed.isSelected() ? 27 : 29);
        Sensor.Set_DvlNtkNbOfBeams(jDvlNortekNbOfBeam.getValue());
        if (jDvlNortekSpdOfSound.getText().isEmpty()) {
            jDvlNortekSpdOfSound.setText("1500.0");
        }
        Sensor.Set_SoundSpeed(Double.parseDouble(jDvlNortekSpdOfSound.getText()), ConvertTool.UNITS.UNITE_M_S);
        if (jDvlNortekPressure.getText().isEmpty()) {
            jDvlNortekPressure.setText("1.0");
        }
        Sensor.Set_Pressure(Double.parseDouble(jDvlNortekPressure.getText()), ConvertTool.UNITS.UNITE_DBAR);
    }

    public void Update_DVL_NTK_Panel() {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[11][0];
        if (Sensor.Get_DvlNtkId() == 27) {
            this.ManageDVLNortekCheckboxes(0);
        } else {
            this.ManageDVLNortekCheckboxes(1);
        }
        jDvlNortekNbOfBeam.setValue(Sensor.Get_DvlNtkNbOfBeams());
        jDvlNortekSpdOfSound.setText(String.valueOf(Sensor.Get_SoundSpeed(ConvertTool.UNITS.UNITE_M_S)));
        jDvlNortekPressure.setText(String.valueOf(Sensor.Get_Pressure(ConvertTool.UNITS.UNITE_DBAR)));
        jDvlNortekDistanceBeam.setText(String.valueOf(Sensor.Get_DvlNtkDistanceBeam(jCmbBoxDistanceBeam.getSelectedIndex())));
        jDvlNortekVelocity.setText(String.valueOf(Sensor.Get_DvlNtkVelocity(jCmbBoxVelocityAxis.getSelectedIndex())));
        jDvlNortekFOM.setText(String.valueOf(Sensor.Get_DvlNtkFOM(jCmbBoxFOMAxis.getSelectedIndex())));
        jDvlNortekDT1.setText(String.valueOf(Sensor.Get_DvlNtkDT1(jCmbBoxDT1Axis.getSelectedIndex())));
        jDvlNortekDT2.setText(String.valueOf(Sensor.Get_DvlNtkDT2(jCmbBoxDT2Axis.getSelectedIndex())));
    }

    /*
     * Opcode count of 13917 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.jButton8 = new JButton();
        this.jPanel7 = new JPanel();
        jTabbedPane_Main = new JTabbedPane();
        this.jPanel5 = new JPanel();
        this.jPanel8 = new JPanel();
        jLabel_OutputId = new JLabel();
        jComboBox_OuputId = new JComboBox();
        jLabel_Proto = new JLabel();
        jComboBox_OutputProto = new JComboBox();
        jCheckBox_Scambling_On = new JCheckBox();
        jPanel_OutPutEthernet = new JPanel();
        jLabel_OutputConnectionType = new JLabel();
        jComboBox_EthConnectionType = new JComboBox();
        jLabel_OutputIPAdress = new JLabel();
        jLabel_OutputPortIP = new JLabel();
        jTextField_OutputIPPort = new JTextField();
        jTextField_OutputIPAdress1 = new JTextField();
        jLabel_DVLP1 = new JLabel();
        jTextField_OutputIPAdress2 = new JTextField();
        jLabel_DVLP2 = new JLabel();
        jTextField_OutputIPAdress3 = new JTextField();
        jLabel_DVLP3 = new JLabel();
        jTextField_OutputIPAdress4 = new JTextField();
        jPanel_OutputSerial = new JPanel();
        jLabel_OutputPortRS = new JLabel();
        jLabel_OutputBaudrate = new JLabel();
        jComboBox_OutputRSPort = new JComboBox();
        jComboBox_OutputBaudrate = new JComboBox();
        jComboBox_OutputStopBits = new JComboBox();
        jLabel_OutputStopBits = new JLabel();
        jLabel_OutputParity = new JLabel();
        jComboBox_OutputParity = new JComboBox();
        jLabel_OutputDatabits = new JLabel();
        jComboBox_OutputDataBits = new JComboBox();
        jPanel_OuputFlow = new JPanel();
        this.jLabel_ConnType = new JLabel();
        jComboBox_OutputConnType = new JComboBox();
        jPanel_OuputRate = new JPanel();
        jLabel_OutputRate = new JLabel();
        jComboBox_OutputRate = new JComboBox();
        jTextField_OutputRateCustom = new JTextField();
        jLabel_OutputRateCustomLabel = new JLabel();
        this.jPanel1 = new JPanel();
        jPanel_ProtoSelection = new JPanel();
        jLabel_ProtocolId = new JLabel();
        jComboBox_ProtocolParams_OutputId = new JComboBox();
        this.jLabel15 = new JLabel();
        jComboBox_OutputGPSId = new JComboBox();
        jComboBox_OutputLBLId = new JComboBox();
        this.jLabel16 = new JLabel();
        jComboBox_OutputUSBLId = new JComboBox();
        this.jLabel17 = new JLabel();
        jLabel_ProtocoleName = new JLabel();
        this.jLabel23 = new JLabel();
        jComboBox_OutputEMLOGId = new JComboBox();
        this.jLabel84 = new JLabel();
        jComboBox_OutputDVLId = new JComboBox();
        this.jPanel2 = new JPanel();
        jCheckBox_TrameXXEnable = new JCheckBox();
        jCheckBox_TrameXXEnable1 = new JCheckBox();
        jCheckBox_TrameXXEnable3 = new JCheckBox();
        jCheckBox_TrameXXEnable2 = new JCheckBox();
        jCheckBox_TrameXXEnable4 = new JCheckBox();
        jCheckBox_TrameXXEnable5 = new JCheckBox();
        jCheckBox_TrameXXEnable6 = new JCheckBox();
        jCheckBox_TrameXXEnable7 = new JCheckBox();
        jCheckBox_TrameXXEnable8 = new JCheckBox();
        jCheckBox_TrameXXEnable9 = new JCheckBox();
        jCheckBox_TrameXXEnable10 = new JCheckBox();
        jCheckBox_TrameXXEnable11 = new JCheckBox();
        jCheckBox_TrameXXEnable12 = new JCheckBox();
        jCheckBox_TrameXXEnable13 = new JCheckBox();
        jCheckBox_TrameXXEnable14 = new JCheckBox();
        jCheckBox_TrameXXEnable15 = new JCheckBox();
        jCheckBox_TrameXXEnable16 = new JCheckBox();
        jCheckBox_TrameXXEnable17 = new JCheckBox();
        this.jPanel24 = new JPanel();
        jCheckBox_Option1 = new JCheckBox();
        jCheckBox_Option2 = new JCheckBox();
        jCheckBox_Option3 = new JCheckBox();
        jCheckBox_Option4 = new JCheckBox();
        jCheckBox_Option5 = new JCheckBox();
        jCheckBox_Option6 = new JCheckBox();
        this.jPanel6 = new JPanel();
        jPanel_GPS_Position = new JPanel();
        this.jLabel6 = new JLabel();
        jTextField_GPSLatitude = new JTextField();
        this.jLabel9 = new JLabel();
        jTextField_GPSLatitudeStd = new JTextField();
        this.jLabel25 = new JLabel();
        jComboBox_GPSQuality = new JComboBox();
        this.jLabel7 = new JLabel();
        jTextField_GPSLongitude = new JTextField();
        this.jLabel10 = new JLabel();
        jTextField_GPSLongitudeStd = new JTextField();
        this.jLabel26 = new JLabel();
        jTextField_GPSLatency = new JTextField();
        this.jLabel8 = new JLabel();
        jTextField_GPSAltitude = new JTextField();
        this.jLabel11 = new JLabel();
        jTextField_GPSAltitudeStd = new JTextField();
        this.jLabel27 = new JLabel();
        jTextField_GPSGeoidalSep = new JTextField();
        jCheckBox_GPSValidity = new JCheckBox();
        jTextField_GPSEllipseMajorAxis = new JTextField();
        jTextField_GPSEllipseMinorAxis = new JTextField();
        jTextField_GPSEllipseAngle = new JTextField();
        this.jLabel24 = new JLabel();
        this.jLabel95 = new JLabel();
        this.jLabel91 = new JLabel();
        this.jLabel99 = new JLabel();
        jTextField_GPSLatLongCov = new JTextField();
        jPanel_GPSSPeed = new JPanel();
        this.jLabel71 = new JLabel();
        jTextField_GPSCourse = new JTextField();
        this.jLabel72 = new JLabel();
        jTextField_GPSSpeed = new JTextField();
        this.jLabel76 = new JLabel();
        jComboBox_OperatingMode = new JComboBox();
        jPanel_GPS_Id = new JPanel();
        jComboBox_GPSId = new JComboBox();
        this.jLabel12 = new JLabel();
        this.jPanel10 = new JPanel();
        jPanel_DVL_BTDatas = new JPanel();
        this.jLabel41 = new JLabel();
        jTextField_DVLBT_XS1Speed = new JTextField();
        this.jLabel45 = new JLabel();
        jTextField_DVLBT_XS1SpeedStd = new JTextField();
        this.jLabel47 = new JLabel();
        jTextField_DVLBT_SoundSpeed = new JTextField();
        this.jLabel49 = new JLabel();
        jTextField_DVLBT_XS2Speed = new JTextField();
        this.jLabel50 = new JLabel();
        jTextField_DVLBT_XS2SpeedStd = new JTextField();
        this.jLabel51 = new JLabel();
        jTextField_DVLBT_Altitude = new JTextField();
        this.jLabel52 = new JLabel();
        jTextField_DVLBT_XS3Speed = new JTextField();
        this.jLabel53 = new JLabel();
        jTextField_DVLBT_XS3SpeedStd = new JTextField();
        this.jLabel54 = new JLabel();
        jTextField_DVLBT_Latency = new JTextField();
        jCheckBox_DVLBTValidity = new JCheckBox();
        jPanel_DVL_WTDatas = new JPanel();
        this.jLabel48 = new JLabel();
        jTextField_DVLWT_XS1Speed = new JTextField();
        this.jLabel55 = new JLabel();
        jTextField_DVLWT_XS1SpeedStd = new JTextField();
        this.jLabel56 = new JLabel();
        jTextField_DVLWT_SoundSpeed = new JTextField();
        this.jLabel57 = new JLabel();
        jTextField_DVLWT_XS2Speed = new JTextField();
        this.jLabel58 = new JLabel();
        jTextField_DVLWT_XS2SpeedStd = new JTextField();
        this.jLabel59 = new JLabel();
        jTextField_DVLWT_Altitude = new JTextField();
        this.jLabel60 = new JLabel();
        jTextField_DVLWT_XS3Speed = new JTextField();
        this.jLabel61 = new JLabel();
        jTextField_DVLWT_XS3SpeedStd = new JTextField();
        this.jLabel62 = new JLabel();
        jTextField_DVLWT_Latency = new JTextField();
        jCheckBox_DVLWTValidity = new JCheckBox();
        jPanel_DVL_Id = new JPanel();
        jComboBox_DVLId = new JComboBox();
        this.jLabel96 = new JLabel();
        this.jComboBox_CoordinateVelocities = new JComboBox();
        this.jLabel100 = new JLabel();
        this.jPanel26 = new JPanel();
        jDvlBottomTrackUsed = new JCheckBox();
        jDvlWaterTrackUsed = new JCheckBox();
        this.jLabel119 = new JLabel();
        jDvlNortekNbOfBeam = new JSlider();
        this.jLabel120 = new JLabel();
        jDvlNortekSerialNumber = new JTextField();
        this.jLabel121 = new JLabel();
        jDvlNortekSpdOfSound = new JTextField();
        this.jDvlNortekTemperature = new JLabel();
        jTextField3 = new JTextField();
        this.jLabel123 = new JLabel();
        jDvlNortekPressure = new JTextField();
        jCmbBoxVelocityBeam = new JComboBox();
        jTextField5 = new JTextField();
        jCmbBoxDistanceBeam = new JComboBox();
        jDvlNortekDistanceBeam = new JTextField();
        this.jLabel124 = new JLabel();
        this.jLabel125 = new JLabel();
        this.jLabel126 = new JLabel();
        this.jLabel127 = new JLabel();
        jCmbBoxFOMBeam = new JComboBox();
        jTextField7 = new JTextField();
        this.jLabel128 = new JLabel();
        jCmbBoxDT1Beam = new JComboBox();
        jTextField8 = new JTextField();
        this.jLabel129 = new JLabel();
        jCmbBoxDT2Beam = new JComboBox();
        jTextField9 = new JTextField();
        this.jLabel130 = new JLabel();
        jCmbBoxTimeVelEstBeam = new JComboBox();
        jTextField10 = new JTextField();
        this.jLabel131 = new JLabel();
        this.jLabel132 = new JLabel();
        jCmbBoxVelocityAxis = new JComboBox();
        jDvlNortekVelocity = new JTextField();
        jDvlNortekFOM = new JTextField();
        jCmbBoxFOMAxis = new JComboBox();
        jCmbBoxDT1Axis = new JComboBox();
        jDvlNortekDT1 = new JTextField();
        jCmbBoxDT2Axis = new JComboBox();
        jDvlNortekDT2 = new JTextField();
        jCmbBoxTimeVelEstAxis = new JComboBox();
        jDvlNortekTimeVelEst = new JTextField();
        this.jLabel133 = new JLabel();
        this.jLabel135 = new JLabel();
        this.jLabel136 = new JLabel();
        this.jLabel137 = new JLabel();
        this.jLabel138 = new JLabel();
        this.jLabel134 = new JLabel();
        this.jLabel139 = new JLabel();
        jComboBox1 = new JComboBox();
        jComboBox2 = new JComboBox();
        jButton1 = new JButton();
        jButton2 = new JButton();
        jButton3 = new JButton();
        jButton4 = new JButton();
        jTextField12 = new JTextField();
        jTextField17 = new JTextField();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jButton11 = new JButton();
        this.jButton12 = new JButton();
        this.jButton13 = new JButton();
        this.jButton14 = new JButton();
        this.jButton15 = new JButton();
        this.jButton16 = new JButton();
        this.jPanel11 = new JPanel();
        jPanel_USBL_Id = new JPanel();
        jComboBox_USBLId = new JComboBox();
        this.jLabel13 = new JLabel();
        jPanel_USBL_Datas = new JPanel();
        jLabel_DVLmisalignment14 = new JLabel();
        jTextField_USBLBeaconCodeID = new JTextField();
        jCheckBox_USBLValidity = new JCheckBox();
        this.jLabel31 = new JLabel();
        jTextField_USBLLatitude = new JTextField();
        this.jLabel32 = new JLabel();
        jTextField_USBLLatitudeStd = new JTextField();
        this.jLabel33 = new JLabel();
        jTextField_USBLLatLongCov = new JTextField();
        this.jLabel34 = new JLabel();
        jTextField_USBLLongitude = new JTextField();
        this.jLabel35 = new JLabel();
        jTextField_USBLLongitudeStd = new JTextField();
        this.jLabel36 = new JLabel();
        jTextField_USBLLatency = new JTextField();
        jTextField_USBLDepthStd = new JTextField();
        this.jLabel37 = new JLabel();
        jTextField_USBLDepth = new JTextField();
        this.jLabel38 = new JLabel();
        this.jLabel65 = new JLabel();
        jTextField_USBLMajorAxis = new JTextField();
        this.jLabel68 = new JLabel();
        jTextField_USBLMinorAxis = new JTextField();
        jLabel_DVLmisalignment16 = new JLabel();
        jTextField_USBLMajorAxisDir = new JTextField();
        jLabel_DVLmisalignment17 = new JLabel();
        jTextField_USBLBeaconNumID = new JTextField();
        this.jLabel92 = new JLabel();
        this.jLabel93 = new JLabel();
        this.jLabel94 = new JLabel();
        jTextField_USBLUTMZone = new JTextField();
        jTextField_USBLUTMNord = new JTextField();
        jTextField_USBLUTMEst = new JTextField();
        this.jPanel12 = new JPanel();
        jPanel_LBL_Id = new JPanel();
        jComboBox_LBLId = new JComboBox();
        this.jLabel14 = new JLabel();
        jPanel_LBL_Datas = new JPanel();
        jLabel_DVLmisalignment15 = new JLabel();
        jTextField_LBLBeaconCode = new JTextField();
        jCheckBox_LBLValidity = new JCheckBox();
        this.jLabel39 = new JLabel();
        jTextField_LBLLatitude = new JTextField();
        this.jLabel40 = new JLabel();
        jTextField_LBLRange = new JTextField();
        this.jLabel42 = new JLabel();
        jTextField_LBLLongitude = new JTextField();
        this.jLabel43 = new JLabel();
        jTextField_LBLRangeStd = new JTextField();
        this.jLabel44 = new JLabel();
        jTextField_LBLLatency = new JTextField();
        jTextField_LBLDepth = new JTextField();
        this.jLabel46 = new JLabel();
        this.jPanel13 = new JPanel();
        jPanel_DEPTH_Datas = new JPanel();
        this.jLabel28 = new JLabel();
        jTextField_DEPTHDepth = new JTextField();
        this.jLabel29 = new JLabel();
        jTextField_DEPTHDepthStd = new JTextField();
        jCheckBox_DEPTHValidity = new JCheckBox();
        this.jLabel30 = new JLabel();
        jTextField_DEPTH_Pressure = new JTextField();
        this.jLabel73 = new JLabel();
        jTextField_Depth_SoundSpeed = new JTextField();
        jTextField_Depth_Temperature = new JTextField();
        this.jLabel74 = new JLabel();
        this.jLabel75 = new JLabel();
        jTextField_DEPTHLatency = new JTextField();
        this.jLabel83 = new JLabel();
        jCheckBox_CompensatedData = new JCheckBox();
        this.jPanel14 = new JPanel();
        jPanel_EMLog_Speeds = new JPanel();
        this.jLabel18 = new JLabel();
        jTextField_LogEM_LongWaterSpeed = new JTextField();
        jTextField_LogEM_TransWaterSpeed = new JTextField();
        this.jLabel19 = new JLabel();
        jTextField_LogEM_TransGroundSpeed = new JTextField();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        jTextField_LogEM_LongGroundSpeed = new JTextField();
        jCheckBox_LochEmValidity = new JCheckBox();
        this.jLabel97 = new JLabel();
        jTextField_LogEM_LongWaterSpeedStd = new JTextField();
        jPanel_EMLog_Id = new JPanel();
        jComboBox_EMLOGId = new JComboBox();
        this.jLabel22 = new JLabel();
        this.jPanel15 = new JPanel();
        jPanel_CTD_Datas = new JPanel();
        this.jLabel63 = new JLabel();
        jTextField_CTDConductivity = new JTextField();
        this.jLabel64 = new JLabel();
        jTextField_CTDDepth = new JTextField();
        this.jLabel66 = new JLabel();
        jTextField_CTDTemperature = new JTextField();
        this.jLabel67 = new JLabel();
        jTextField_CTDSalinity = new JTextField();
        this.jLabel69 = new JLabel();
        jTextField_CTDPressure = new JTextField();
        this.jLabel70 = new JLabel();
        jTextField_CTDSoundSpeed = new JTextField();
        jCheckBox_CTDValidity = new JCheckBox();
        this.jPanel19 = new JPanel();
        jPanel_GRAVI_Datas = new JPanel();
        this.jLabel77 = new JLabel();
        jTextField_Gravi_Xi = new JTextField();
        this.jLabel79 = new JLabel();
        jTextField_Gravi_Eta = new JTextField();
        this.jLabel81 = new JLabel();
        jTextField_Gravi_Norm = new JTextField();
        jCheckBox_GraviValidity = new JCheckBox();
        this.jLabel78 = new JLabel();
        this.jLabel80 = new JLabel();
        jTextField_Gravi_Long = new JTextField();
        jTextField_Gravi_Lat = new JTextField();
        this.jPanel20 = new JPanel();
        jPanel_GRAVI_Datas1 = new JPanel();
        this.jLabel85 = new JLabel();
        jTextField_Platform_PosX = new JTextField();
        this.jLabel87 = new JLabel();
        jTextField_Platform_PosY = new JTextField();
        this.jLabel88 = new JLabel();
        jTextField_Platform_PosZ = new JTextField();
        this.jLabel86 = new JLabel();
        jTextField_Platform_OrientX = new JTextField();
        jTextField_Platform_OrientY = new JTextField();
        this.jLabel89 = new JLabel();
        this.jLabel90 = new JLabel();
        jTextField_Platform_OrientZ = new JTextField();
        this.jLabel82 = new JLabel();
        jTextField_Platform_Status = new JTextField();
        this.jPanel21 = new JPanel();
        jPanel_DMI_Datas = new JPanel();
        this.jLabel98 = new JLabel();
        jTextField_DMIPulseCount = new JTextField();
        jCheckBox_DMIValidity = new JCheckBox();
        this.jPanel25 = new JPanel();
        jPanel_DMI_Datas1 = new JPanel();
        this.jLabel101 = new JLabel();
        jTextField_StimHeading = new JTextField();
        this.jLabel104 = new JLabel();
        this.jLabel105 = new JLabel();
        jTextField_StimLongitude = new JTextField();
        jTextField_StimLatitude = new JTextField();
        this.jLabel106 = new JLabel();
        jTextField_StimRoll = new JTextField();
        this.jLabel107 = new JLabel();
        jTextField_StimPitch = new JTextField();
        this.jLabel108 = new JLabel();
        jTextField_StimAltitude = new JTextField();
        this.jLabel109 = new JLabel();
        jTextField_StimAccelX = new JTextField();
        this.jLabel110 = new JLabel();
        jTextField_StimAccelY = new JTextField();
        this.jLabel111 = new JLabel();
        jTextField_StimAccelZ = new JTextField();
        this.jLabel112 = new JLabel();
        jTextField_StimRotRateZ = new JTextField();
        jTextField_StimRotRateY = new JTextField();
        this.jLabel113 = new JLabel();
        this.jLabel114 = new JLabel();
        jTextField_StimRotRateX = new JTextField();
        this.jLabel115 = new JLabel();
        this.jLabel116 = new JLabel();
        this.jLabel117 = new JLabel();
        jTextField_StimSpeedUp = new JTextField();
        jTextField_StimSpeedEast = new JTextField();
        jTextField_StimSpeedNorth = new JTextField();
        jCheckBoxActivateSimStim = new JCheckBox();
        this.jLabel118 = new JLabel();
        jTextField_StimAltiRef = new JTextField();
        jPanel4 = new JPanel();
        jPanel_Info = new JPanel();
        this.jLabel_Info1 = new JLabel();
        this.jLabel_Info2 = new JLabel();
        this.jLabel_Info3 = new JLabel();
        this.jLabel_Info4 = new JLabel();
        jLabel_InfoOuput1 = new JLabel();
        jLabel_InfoOuput3 = new JLabel();
        jLabel_InfoOuput4 = new JLabel();
        this.jLabel_Info5 = new JLabel();
        jLabel_InfoOuput2 = new JLabel();
        jLabel_InfoOuput5 = new JLabel();
        jPanel_Chevron = new JPanel();
        jLabel_InfoOuputInterface1 = new JLabel();
        jLabel_InfoOuputInterface2 = new JLabel();
        jLabel_InfoOuputInterface3 = new JLabel();
        jLabel_InfoOuputInterface4 = new JLabel();
        jLabel_InfoOuputInterface5 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        jLabel_DisplayTime = new JLabel();
        this.jLabel_Info11 = new JLabel();
        jLabel_InfoOuput6 = new JLabel();
        this.jLabel102 = new JLabel();
        jLabel_InfoOuputInterface6 = new JLabel();
        this.jLabel_Info12 = new JLabel();
        jLabel_InfoOuput7 = new JLabel();
        this.jLabel103 = new JLabel();
        jLabel_InfoOuputInterface7 = new JLabel();
        jPanel9 = new JPanel();
        jPanel_Voyants = new JPanel();
        this.jLabel_Info6 = new JLabel();
        this.jLabel_Info7 = new JLabel();
        this.jLabel_Info8 = new JLabel();
        this.jLabel_Info9 = new JLabel();
        this.jLabel_Info10 = new JLabel();
        jLabel_Output2State = new JLabel();
        jLabel_Output1State = new JLabel();
        jLabel_Output3State = new JLabel();
        jLabel_Output5State = new JLabel();
        jLabel_Output4State = new JLabel();
        this.jLabel_Info13 = new JLabel();
        jLabel_Output6State = new JLabel();
        this.jLabel_Info14 = new JLabel();
        jLabel_Output7State = new JLabel();
        this.jPanel3 = new JPanel();
        jButton_ConnectOutput1 = new JButton();
        jButton_ConnectOutput2 = new JButton();
        jButton_ConnectOutput3 = new JButton();
        jButton_ConnectOutput5 = new JButton();
        jButton_ConnectOutput4 = new JButton();
        jButton_ConnectOutput6 = new JButton();
        jButton_ConnectOutput7 = new JButton();
        this.jPanel16 = new JPanel();
        this.jPanel17 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        jTextArea_OutputDisplay = new JTextArea();
        this.jPanel18 = new JPanel();
        jLabel_OutputId1 = new JLabel();
        jComboBox_OutputDisplayId = new JComboBox();
        jToggleButton_StartDisplay = new JToggleButton();
        jButton_InitDisplay = new JButton();
        this.jPanel22 = new JPanel();
        this.jPanel23 = new JPanel();
        jCheckBox_Scramble_ReplaceChar = new JCheckBox();
        jCheckBox_Scramble_SuppressChar = new JCheckBox();
        jCheckBox_Scramble_AddChar = new JCheckBox();
        jCheckBox_Scramble_SuppressField = new JCheckBox();
        jCheckBox_Scramble_AddField = new JCheckBox();
        jSlider_Scramble_ReplaceChar = new JSlider();
        jLabel_Scramble_ReplaceChar_Nb = new JLabel();
        jLabel_Scramble_ReplaceChar_Label = new JLabel();
        jSlider_Scramble_SuppressChar = new JSlider();
        jLabel_Scramble_SuppressChar_Nb = new JLabel();
        jLabel_Scramble_SuppressChar_Label = new JLabel();
        jSlider_Scramble_AddChar = new JSlider();
        jLabel_Scramble_AddChar_Nb = new JLabel();
        jLabel_Scramble_AddChar_Label = new JLabel();
        jSlider_Scramble_SuppressField = new JSlider();
        jLabel_Scramble_SuppressField_Nb = new JLabel();
        jLabel_Scramble_SuppressField_Label = new JLabel();
        jSlider_Scramble_AddField = new JSlider();
        jLabel_Scramble_AddField_Nb = new JLabel();
        jLabel_Scramble_AddField_Label = new JLabel();
        this.jButton8.setText("Save");
        this.setDefaultCloseOperation(3);
        this.jPanel7.setPreferredSize(new Dimension(937, 365));
        jTabbedPane_Main.setFont(new Font("Tahoma", 1, 11));
        jTabbedPane_Main.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimulatorFrame.this.jTabbedPane_MainStateChanged(evt);
            }
        });
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Selection", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_OutputId.setText("Output:");
        jComboBox_OuputId.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SimulatorFrame.this.jComboBox_OuputIdPopupMenuWillBecomeVisible(evt);
            }
        });
        jComboBox_OuputId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_OuputIdActionPerformed(evt);
            }
        });
        jLabel_Proto.setText("Protocol:");
        jComboBox_OutputProto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_OutputProtoActionPerformed(evt);
            }
        });
        jCheckBox_Scambling_On.setText("Scrambling ON");
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(jLabel_OutputId).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jComboBox_OuputId, -2, 110, -2).addGap(65, 65, 65).addComponent(jLabel_Proto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComboBox_OutputProto, -2, 210, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jCheckBox_Scambling_On, -2, 142, -2).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_OutputId).addComponent(jComboBox_OuputId, -2, -1, -2).addComponent(jLabel_Proto).addComponent(jComboBox_OutputProto, -2, -1, -2).addComponent(jCheckBox_Scambling_On)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_OutPutEthernet.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Ethernet Parameters", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_OutputConnectionType.setText("Connection Type:");
        jComboBox_EthConnectionType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_EthConnectionTypeActionPerformed(evt);
            }
        });
        jLabel_OutputIPAdress.setText("IP Adress:");
        jLabel_OutputPortIP.setText("Port:");
        jTextField_OutputIPPort.setHorizontalAlignment(0);
        jTextField_OutputIPAdress1.setHorizontalAlignment(0);
        jLabel_DVLP1.setText(".");
        jTextField_OutputIPAdress2.setHorizontalAlignment(0);
        jLabel_DVLP2.setText(".");
        jTextField_OutputIPAdress3.setHorizontalAlignment(0);
        jLabel_DVLP3.setText(".");
        jTextField_OutputIPAdress4.setHorizontalAlignment(0);
        GroupLayout jPanel_OutPutEthernetLayout = new GroupLayout(jPanel_OutPutEthernet);
        jPanel_OutPutEthernet.setLayout(jPanel_OutPutEthernetLayout);
        jPanel_OutPutEthernetLayout.setHorizontalGroup(jPanel_OutPutEthernetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_OutPutEthernetLayout.createSequentialGroup().addContainerGap().addComponent(jLabel_OutputConnectionType).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jComboBox_EthConnectionType, -2, 110, -2).addGap(77, 77, 77).addComponent(jLabel_OutputIPAdress, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_OutputIPAdress1, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_DVLP1).addGap(2, 2, 2).addComponent(jTextField_OutputIPAdress2, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_DVLP2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_OutputIPAdress3, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_DVLP3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_OutputIPAdress4, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jLabel_OutputPortIP, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_OutputIPPort, -2, 46, -2).addGap(76, 76, 76)));
        jPanel_OutPutEthernetLayout.setVerticalGroup(jPanel_OutPutEthernetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_OutPutEthernetLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_OutPutEthernetLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_OutputConnectionType).addComponent(jComboBox_EthConnectionType, -2, -1, -2).addComponent(jTextField_OutputIPAdress1, -2, -1, -2).addComponent(jLabel_DVLP1).addComponent(jTextField_OutputIPAdress2, -2, -1, -2).addComponent(jLabel_DVLP2).addComponent(jTextField_OutputIPAdress3, -2, -1, -2).addComponent(jLabel_DVLP3).addComponent(jTextField_OutputIPAdress4, -2, -1, -2).addComponent(jTextField_OutputIPPort, -2, -1, -2).addComponent(jLabel_OutputPortIP).addComponent(jLabel_OutputIPAdress)).addContainerGap(14, Short.MAX_VALUE)));
        jPanel_OutputSerial.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Serial Parameters", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_OutputPortRS.setText("Port:");
        jLabel_OutputBaudrate.setText("Baudrate:");
        jLabel_OutputStopBits.setText("Stop bits:");
        jLabel_OutputParity.setText("Parity:");
        jLabel_OutputDatabits.setText("DataBits:");
        GroupLayout jPanel_OutputSerialLayout = new GroupLayout(jPanel_OutputSerial);
        jPanel_OutputSerial.setLayout(jPanel_OutputSerialLayout);
        jPanel_OutputSerialLayout.setHorizontalGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_OutputSerialLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_OutputSerialLayout.createSequentialGroup().addComponent(jLabel_OutputBaudrate, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jComboBox_OutputBaudrate, -2, 74, -2)).addGroup(jPanel_OutputSerialLayout.createSequentialGroup().addComponent(jLabel_OutputPortRS, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jComboBox_OutputRSPort, -2, 75, -2))).addGap(65, 65, 65).addGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jLabel_OutputParity, -1, -1, Short.MAX_VALUE).addComponent(jLabel_OutputDatabits, -1, 63, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jComboBox_OutputDataBits, 0, 86, Short.MAX_VALUE).addComponent(jComboBox_OutputParity, 0, -1, Short.MAX_VALUE)).addGap(65, 65, 65).addComponent(jLabel_OutputStopBits, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jComboBox_OutputStopBits, -2, 69, -2).addContainerGap(144, Short.MAX_VALUE)));
        jPanel_OutputSerialLayout.setVerticalGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_OutputSerialLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_OutputPortRS).addComponent(jComboBox_OutputRSPort, -2, -1, -2)).addGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel_OutputDatabits).addGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_OutputStopBits).addComponent(jComboBox_OutputStopBits, -2, -1, -2)).addComponent(jComboBox_OutputDataBits, -2, -1, -2))).addGap(10, 10, 10).addGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_OutputParity).addComponent(jComboBox_OutputParity, -2, -1, -2)).addGroup(jPanel_OutputSerialLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_OutputBaudrate).addComponent(jComboBox_OutputBaudrate, -2, -1, -2))).addContainerGap(22, Short.MAX_VALUE)));
        jPanel_OuputFlow.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Flow Parameters", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel_ConnType.setText("Flow Type:");
        jComboBox_OutputConnType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_OutputConnTypeActionPerformed(evt);
            }
        });
        GroupLayout jPanel_OuputFlowLayout = new GroupLayout(jPanel_OuputFlow);
        jPanel_OuputFlow.setLayout(jPanel_OuputFlowLayout);
        jPanel_OuputFlowLayout.setHorizontalGroup(jPanel_OuputFlowLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_OuputFlowLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel_ConnType).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jComboBox_OutputConnType, -2, 86, -2).addContainerGap(139, Short.MAX_VALUE)));
        jPanel_OuputFlowLayout.setVerticalGroup(jPanel_OuputFlowLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_OuputFlowLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_OuputFlowLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_ConnType).addComponent(jComboBox_OutputConnType, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_OuputRate.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rate Parameters", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_OutputRate.setText("Rate:");
        jComboBox_OutputRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_OutputRateActionPerformed(evt);
            }
        });
        jTextField_OutputRateCustom.setHorizontalAlignment(0);
        jTextField_OutputRateCustom.setText("0");
        jLabel_OutputRateCustomLabel.setText("Custom(ms):");
        GroupLayout jPanel_OuputRateLayout = new GroupLayout(jPanel_OuputRate);
        jPanel_OuputRate.setLayout(jPanel_OuputRateLayout);
        jPanel_OuputRateLayout.setHorizontalGroup(jPanel_OuputRateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_OuputRateLayout.createSequentialGroup().addContainerGap().addComponent(jLabel_OutputRate).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jComboBox_OutputRate, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jLabel_OutputRateCustomLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jTextField_OutputRateCustom, -2, 69, -2).addGap(58, 58, 58)));
        jPanel_OuputRateLayout.setVerticalGroup(jPanel_OuputRateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_OuputRateLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel_OuputRateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jComboBox_OutputRate, -2, -1, -2).addComponent(jLabel_OutputRate).addComponent(jTextField_OutputRateCustom, -2, -1, -2).addComponent(jLabel_OutputRateCustomLabel)).addContainerGap()));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(jPanel_OutPutEthernet, -1, -1, Short.MAX_VALUE).addGroup(jPanel5Layout.createSequentialGroup().addComponent(jPanel_OuputFlow, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_OuputRate, -1, -1, Short.MAX_VALUE)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(jPanel_OutputSerial, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel_OuputFlow, -2, -1, -2).addComponent(jPanel_OuputRate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_OutPutEthernet, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_OutputSerial, -2, -1, -2).addContainerGap(156, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("Outputs", this.jPanel5);
        jPanel_ProtoSelection.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Parameters", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_ProtocolId.setText("Output:");
        jComboBox_ProtocolParams_OutputId.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SimulatorFrame.this.jComboBox_ProtocolParams_OutputIdPopupMenuWillBecomeVisible(evt);
            }
        });
        jComboBox_ProtocolParams_OutputId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_ProtocolParams_OutputIdActionPerformed(evt);
            }
        });
        this.jLabel15.setText("GPS Id:");
        this.jLabel16.setText("LBL Id:");
        this.jLabel17.setText("USBL Id:");
        jLabel_ProtocoleName.setText("None");
        this.jLabel23.setText("EMLOG Id:");
        this.jLabel84.setText("DVL Id:");
        GroupLayout jPanel_ProtoSelectionLayout = new GroupLayout(jPanel_ProtoSelection);
        jPanel_ProtoSelection.setLayout(jPanel_ProtoSelectionLayout);
        jPanel_ProtoSelectionLayout.setHorizontalGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ProtoSelectionLayout.createSequentialGroup().addContainerGap().addComponent(jLabel_ProtocolId, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jComboBox_ProtocolParams_OutputId, 0, 107, Short.MAX_VALUE).addComponent(jLabel_ProtocoleName, -1, -1, Short.MAX_VALUE)).addGap(113, 113, 113).addGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, -2, 69, -2).addComponent(this.jLabel17, -2, 54, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jComboBox_OutputUSBLId, 0, -1, Short.MAX_VALUE).addComponent(jComboBox_OutputGPSId, -2, 51, -2)).addGap(49, 49, 49).addGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel23, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel16, GroupLayout.Alignment.TRAILING, -2, 51, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jComboBox_OutputLBLId, 0, -1, Short.MAX_VALUE).addComponent(jComboBox_OutputEMLOGId, -2, 51, -2)).addGap(43, 43, 43).addComponent(this.jLabel84).addGap(18, 18, 18).addComponent(jComboBox_OutputDVLId, -2, 49, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_ProtoSelectionLayout.setVerticalGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ProtoSelectionLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ProtoSelectionLayout.createSequentialGroup().addGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(jComboBox_OutputGPSId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(jComboBox_OutputUSBLId, -2, -1, -2))).addGroup(jPanel_ProtoSelectionLayout.createSequentialGroup().addGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(jComboBox_OutputLBLId, -2, -1, -2).addComponent(jComboBox_OutputDVLId, -2, -1, -2).addComponent(this.jLabel84)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel23).addComponent(jComboBox_OutputEMLOGId, -2, -1, -2))).addGroup(jPanel_ProtoSelectionLayout.createSequentialGroup().addGroup(jPanel_ProtoSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_ProtocolId).addComponent(jComboBox_ProtocolParams_OutputId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel_ProtocoleName))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Protocol Frames", 0, 0, new Font("Tahoma", 1, 11)));
        jCheckBox_TrameXXEnable.setText("Trame XXX");
        jCheckBox_TrameXXEnable1.setText("Trame XXX");
        jCheckBox_TrameXXEnable3.setText("Trame XXX");
        jCheckBox_TrameXXEnable2.setText("Trame XXX");
        jCheckBox_TrameXXEnable4.setText("Trame XXX");
        jCheckBox_TrameXXEnable5.setText("Trame XXX");
        jCheckBox_TrameXXEnable6.setText("Trame XXX");
        jCheckBox_TrameXXEnable7.setText("Trame XXX");
        jCheckBox_TrameXXEnable8.setText("Trame XXX");
        jCheckBox_TrameXXEnable9.setText("Trame XXX");
        jCheckBox_TrameXXEnable10.setText("Trame XXX");
        jCheckBox_TrameXXEnable11.setText("Trame XXX");
        jCheckBox_TrameXXEnable12.setText("Trame XXX");
        jCheckBox_TrameXXEnable13.setText("Trame XXX");
        jCheckBox_TrameXXEnable14.setText("Trame XXX");
        jCheckBox_TrameXXEnable15.setText("Trame XXX");
        jCheckBox_TrameXXEnable16.setText("Trame XXX");
        jCheckBox_TrameXXEnable17.setText("Trame XXX");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(14, 14, 14).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jCheckBox_TrameXXEnable4, GroupLayout.Alignment.LEADING, -1, 133, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable5, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jCheckBox_TrameXXEnable10, GroupLayout.Alignment.LEADING, -1, 133, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable9, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable8, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable7, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable11, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jCheckBox_TrameXXEnable16, GroupLayout.Alignment.LEADING, -1, 132, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable15, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable14, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable13, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable12, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jCheckBox_TrameXXEnable17, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(jCheckBox_TrameXXEnable12).addGap(26, 26, 26).addComponent(jCheckBox_TrameXXEnable14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_TrameXXEnable15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_TrameXXEnable16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_TrameXXEnable17)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCheckBox_TrameXXEnable).addComponent(jCheckBox_TrameXXEnable6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCheckBox_TrameXXEnable7).addComponent(jCheckBox_TrameXXEnable13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_TrameXXEnable8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_TrameXXEnable9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_TrameXXEnable10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_TrameXXEnable11)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(jCheckBox_TrameXXEnable1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_TrameXXEnable2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_TrameXXEnable3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_TrameXXEnable4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_TrameXXEnable5))))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel24.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Protocol Options", 0, 0, new Font("Tahoma", 1, 11)));
        jCheckBox_Option1.setText("Option XXX");
        jCheckBox_Option2.setText("Option XXX");
        jCheckBox_Option3.setText("Option XXX");
        jCheckBox_Option4.setText("Option XXX");
        jCheckBox_Option5.setText("Option XXX");
        jCheckBox_Option6.setText("Option XXX");
        GroupLayout jPanel24Layout = new GroupLayout(this.jPanel24);
        this.jPanel24.setLayout(jPanel24Layout);
        jPanel24Layout.setHorizontalGroup(jPanel24Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel24Layout.createSequentialGroup().addGap(17, 17, 17).addGroup(jPanel24Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jCheckBox_Option6, -2, 132, -2).addComponent(jCheckBox_Option5, -2, 132, -2).addComponent(jCheckBox_Option4, -2, 132, -2).addComponent(jCheckBox_Option3, -2, 132, -2).addComponent(jCheckBox_Option2, -2, 132, -2).addComponent(jCheckBox_Option1, -2, 132, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel24Layout.setVerticalGroup(jPanel24Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel24Layout.createSequentialGroup().addContainerGap().addComponent(jCheckBox_Option1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_Option2, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_Option3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_Option4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_Option5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_Option6).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel_ProtoSelection, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel24, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_ProtoSelection, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel24, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jTabbedPane_Main.addTab("Protocols", this.jPanel1);
        jPanel_GPS_Position.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor Position ", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel6.setText("Latitude (deg):");
        jTextField_GPSLatitude.setHorizontalAlignment(0);
        jTextField_GPSLatitude.setPreferredSize(new Dimension(24, 22));
        this.jLabel9.setText("Lat. Std (m):");
        jTextField_GPSLatitudeStd.setHorizontalAlignment(0);
        this.jLabel25.setText("GPS Quality:");
        jComboBox_GPSQuality.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SimulatorFrame.this.jComboBox_GPSQualityPopupMenuWillBecomeVisible(evt);
            }
        });
        jComboBox_GPSQuality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_GPSQualityActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Longitude (deg):");
        jTextField_GPSLongitude.setHorizontalAlignment(0);
        this.jLabel10.setText("Long. Std (m):");
        jTextField_GPSLongitudeStd.setHorizontalAlignment(0);
        this.jLabel26.setText("Latency (s):");
        this.jLabel26.setPreferredSize(new Dimension(85, 16));
        jTextField_GPSLatency.setHorizontalAlignment(0);
        this.jLabel8.setText("Altitude (m):");
        jTextField_GPSAltitude.setHorizontalAlignment(0);
        this.jLabel11.setText("Alt. Std (m):");
        jTextField_GPSAltitudeStd.setHorizontalAlignment(0);
        this.jLabel27.setText("GeoidalSep (m):");
        jTextField_GPSGeoidalSep.setHorizontalAlignment(0);
        jCheckBox_GPSValidity.setText("Validity flag");
        jCheckBox_GPSValidity.setAutoscrolls(true);
        jTextField_GPSEllipseMajorAxis.setHorizontalAlignment(0);
        jTextField_GPSEllipseMinorAxis.setHorizontalAlignment(0);
        jTextField_GPSEllipseAngle.setHorizontalAlignment(0);
        this.jLabel24.setText("SD Semi-major Ax. (m):");
        this.jLabel95.setText("SD Semi-minor Ax. (m):");
        this.jLabel91.setText("Semi-major Axis Dir. (\u00b0):");
        this.jLabel99.setText("Lati/Long cov. (m) :");
        jTextField_GPSLatLongCov.setHorizontalAlignment(0);
        jTextField_GPSLatLongCov.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jTextField_GPSLatLongCovActionPerformed(evt);
            }
        });
        GroupLayout jPanel_GPS_PositionLayout = new GroupLayout(jPanel_GPS_Position);
        jPanel_GPS_Position.setLayout(jPanel_GPS_PositionLayout);
        jPanel_GPS_PositionLayout.setHorizontalGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addComponent(this.jLabel25)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_GPSAltitude, -1, 260, Short.MAX_VALUE).addComponent(jTextField_GPSLongitude).addComponent(jTextField_GPSLatitude, -1, 260, Short.MAX_VALUE)).addGap(15, 15, 15)).addComponent(jComboBox_GPSQuality, 0, 275, Short.MAX_VALUE)).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel11, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel10, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jTextField_GPSLongitudeStd, GroupLayout.Alignment.LEADING).addComponent(jTextField_GPSLatitudeStd, GroupLayout.Alignment.LEADING, -1, 50, Short.MAX_VALUE).addComponent(jTextField_GPSAltitudeStd)).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addComponent(this.jLabel24, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, jPanel_GPS_PositionLayout.createSequentialGroup().addComponent(this.jLabel91, -1, -1, Short.MAX_VALUE).addGap(4, 4, 4)))).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel95, -2, 146, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jTextField_GPSEllipseMajorAxis, -1, 50, Short.MAX_VALUE).addComponent(jTextField_GPSEllipseMinorAxis).addComponent(jTextField_GPSEllipseAngle)).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel99, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel26, -1, -1, Short.MAX_VALUE))).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel27, -2, 94, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_GPSGeoidalSep, GroupLayout.Alignment.TRAILING, -2, 60, -2).addComponent(jTextField_GPSLatency, -2, 60, -2).addComponent(jTextField_GPSLatLongCov, GroupLayout.Alignment.TRAILING, -2, 60, -2))).addComponent(jCheckBox_GPSValidity)).addGap(19, 19, 19)));
        jPanel_GPS_PositionLayout.setVerticalGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel6).addComponent(this.jLabel9).addComponent(jTextField_GPSLatitude, -2, -1, -2).addComponent(jTextField_GPSLatitudeStd, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel7).addComponent(jTextField_GPSLongitude, -2, -1, -2).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_GPSLongitudeStd, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.jLabel95)))).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addGap(28, 28, 28).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_GPSEllipseMinorAxis, -2, -1, -2).addComponent(this.jLabel27)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(jTextField_GPSAltitude, -2, -1, -2).addComponent(this.jLabel11).addComponent(jTextField_GPSAltitudeStd, -2, -1, -2))).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel24).addComponent(jTextField_GPSEllipseMajorAxis, -2, -1, -2)).addGap(34, 34, 34).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_GPSEllipseAngle, -2, -1, -2).addComponent(this.jLabel91)))).addGroup(jPanel_GPS_PositionLayout.createSequentialGroup().addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel26, -2, -1, -2).addComponent(jTextField_GPSLatency, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_GPSGeoidalSep, -2, -1, -2).addGap(5, 5, 5).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel99).addComponent(jTextField_GPSLatLongCov, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GPS_PositionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jComboBox_GPSQuality, -2, -1, -2).addComponent(this.jLabel25).addComponent(jCheckBox_GPSValidity)).addContainerGap(12, Short.MAX_VALUE)));
        jPanel_GPSSPeed.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor Speed ", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel71.setText("Course (deg):");
        jTextField_GPSCourse.setHorizontalAlignment(0);
        jTextField_GPSCourse.setText("48.80");
        jTextField_GPSCourse.setPreferredSize(new Dimension(24, 22));
        this.jLabel72.setText("Speed (m/s):");
        jTextField_GPSSpeed.setHorizontalAlignment(0);
        jTextField_GPSSpeed.setText("0.0");
        this.jLabel76.setText("Operating Mode:");
        jComboBox_OperatingMode.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SimulatorFrame.this.jComboBox_OperatingModePopupMenuWillBecomeVisible(evt);
            }
        });
        jComboBox_OperatingMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_OperatingModeActionPerformed(evt);
            }
        });
        GroupLayout jPanel_GPSSPeedLayout = new GroupLayout(jPanel_GPSSPeed);
        jPanel_GPSSPeed.setLayout(jPanel_GPSSPeedLayout);
        jPanel_GPSSPeedLayout.setHorizontalGroup(jPanel_GPSSPeedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GPSSPeedLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel71, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_GPSCourse, -2, 49, -2).addGap(48, 48, 48).addComponent(this.jLabel72, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_GPSSpeed, -1, 308, Short.MAX_VALUE).addGap(46, 46, 46).addComponent(this.jLabel76).addGap(24, 24, 24).addComponent(jComboBox_OperatingMode, -2, 103, -2).addGap(87, 87, 87)));
        jPanel_GPSSPeedLayout.setVerticalGroup(jPanel_GPSSPeedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GPSSPeedLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_GPSSPeedLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel71).addComponent(this.jLabel72).addComponent(jTextField_GPSCourse, -2, -1, -2).addComponent(jTextField_GPSSpeed, -2, -1, -2).addGroup(jPanel_GPSSPeedLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jComboBox_OperatingMode, -2, -1, -2).addComponent(this.jLabel76))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_GPS_Id.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor Id", 0, 0, new Font("Tahoma", 1, 11)));
        jComboBox_GPSId.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SimulatorFrame.this.jComboBox_GPSIdPopupMenuWillBecomeVisible(evt);
            }
        });
        jComboBox_GPSId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_GPSIdActionPerformed(evt);
            }
        });
        this.jLabel12.setText("GPS Id:");
        GroupLayout jPanel_GPS_IdLayout = new GroupLayout(jPanel_GPS_Id);
        jPanel_GPS_Id.setLayout(jPanel_GPS_IdLayout);
        jPanel_GPS_IdLayout.setHorizontalGroup(jPanel_GPS_IdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GPS_IdLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel12, -2, 65, -2).addGap(18, 18, 18).addComponent(jComboBox_GPSId, -2, 84, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_GPS_IdLayout.setVerticalGroup(jPanel_GPS_IdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GPS_IdLayout.createSequentialGroup().addGroup(jPanel_GPS_IdLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(jComboBox_GPSId, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel_GPSSPeed, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jPanel_GPS_Position, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jPanel_GPS_Id, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_GPS_Id, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_GPS_Position, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_GPSSPeed, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jTabbedPane_Main.addTab("GPS", this.jPanel6);
        jPanel_DVL_BTDatas.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor bottom-track datas", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel41.setText("XS1 speed or BT Velocity(m/s):");
        jTextField_DVLBT_XS1Speed.setHorizontalAlignment(0);
        jTextField_DVLBT_XS1Speed.setText("48.80");
        jTextField_DVLBT_XS1Speed.setPreferredSize(new Dimension(24, 22));
        this.jLabel45.setText("XS1 speed std (m/s):");
        jTextField_DVLBT_XS1SpeedStd.setHorizontalAlignment(0);
        jTextField_DVLBT_XS1SpeedStd.setText("0.0");
        this.jLabel47.setText("Speed of sound (m/s):");
        jTextField_DVLBT_SoundSpeed.setHorizontalAlignment(0);
        jTextField_DVLBT_SoundSpeed.setText("0.0");
        this.jLabel49.setText("XS2 speed (m/s):");
        jTextField_DVLBT_XS2Speed.setHorizontalAlignment(0);
        jTextField_DVLBT_XS2Speed.setText("2.0");
        jTextField_DVLBT_XS2Speed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jTextField_DVLBT_XS2SpeedActionPerformed(evt);
            }
        });
        this.jLabel50.setText("XS2 speed std (m/s):");
        jTextField_DVLBT_XS2SpeedStd.setHorizontalAlignment(0);
        jTextField_DVLBT_XS2SpeedStd.setText("0.0");
        this.jLabel51.setText("Altitude/Range (m):");
        this.jLabel51.setPreferredSize(new Dimension(85, 16));
        jTextField_DVLBT_Altitude.setHorizontalAlignment(0);
        jTextField_DVLBT_Altitude.setText("0.0");
        this.jLabel52.setText("XS3 speed (m/s):");
        jTextField_DVLBT_XS3Speed.setHorizontalAlignment(0);
        jTextField_DVLBT_XS3Speed.setText("0.0");
        this.jLabel53.setText("XS3 speed std (m/s):");
        jTextField_DVLBT_XS3SpeedStd.setHorizontalAlignment(0);
        jTextField_DVLBT_XS3SpeedStd.setText("0.0");
        this.jLabel54.setText("Latency or Time of Validity (s):");
        jTextField_DVLBT_Latency.setHorizontalAlignment(0);
        jTextField_DVLBT_Latency.setText("0.0");
        jCheckBox_DVLBTValidity.setText("Validity flag");
        jCheckBox_DVLBTValidity.setAutoscrolls(true);
        GroupLayout jPanel_DVL_BTDatasLayout = new GroupLayout(jPanel_DVL_BTDatas);
        jPanel_DVL_BTDatas.setLayout(jPanel_DVL_BTDatasLayout);
        jPanel_DVL_BTDatasLayout.setHorizontalGroup(jPanel_DVL_BTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_DVL_BTDatasLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_DVL_BTDatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel41, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel52, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel49, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DVL_BTDatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jTextField_DVLBT_XS2Speed, GroupLayout.Alignment.LEADING, -1, 50, Short.MAX_VALUE).addComponent(jTextField_DVLBT_XS1Speed, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jTextField_DVLBT_XS3Speed)).addGap(25, 25, 25).addGroup(jPanel_DVL_BTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel45).addComponent(this.jLabel50).addComponent(this.jLabel53)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DVL_BTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jTextField_DVLBT_XS1SpeedStd, GroupLayout.Alignment.TRAILING).addComponent(jTextField_DVLBT_XS2SpeedStd, GroupLayout.Alignment.TRAILING, -1, 51, Short.MAX_VALUE).addComponent(jTextField_DVLBT_XS3SpeedStd)).addGap(25, 25, 25).addGroup(jPanel_DVL_BTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel54).addComponent(this.jLabel47, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel51, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel_DVL_BTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jTextField_DVLBT_Latency).addComponent(jTextField_DVLBT_Altitude).addComponent(jTextField_DVLBT_SoundSpeed, -2, 51, -2)).addGap(24, 24, 24).addComponent(jCheckBox_DVLBTValidity).addContainerGap(17, Short.MAX_VALUE)));
        jPanel_DVL_BTDatasLayout.setVerticalGroup(jPanel_DVL_BTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DVL_BTDatasLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel_DVL_BTDatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel41).addComponent(this.jLabel45).addComponent(jTextField_DVLBT_XS1SpeedStd, -2, -1, -2).addComponent(jTextField_DVLBT_XS1Speed, -2, -1, -2).addComponent(this.jLabel47).addComponent(jTextField_DVLBT_SoundSpeed, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DVL_BTDatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel49).addComponent(jTextField_DVLBT_XS2Speed, -2, -1, -2).addComponent(this.jLabel50).addComponent(jTextField_DVLBT_XS2SpeedStd, -2, -1, -2).addComponent(this.jLabel51, -2, -1, -2).addComponent(jTextField_DVLBT_Altitude, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DVL_BTDatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel52).addComponent(jTextField_DVLBT_XS3Speed, -2, -1, -2).addComponent(this.jLabel53).addComponent(jTextField_DVLBT_XS3SpeedStd, -2, -1, -2).addComponent(this.jLabel54).addComponent(jTextField_DVLBT_Latency, -2, -1, -2).addComponent(jCheckBox_DVLBTValidity)).addGap(23, 23, 23)));
        jPanel_DVL_WTDatas.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor water-track datas", 0, 0, new Font("Tahoma", 1, 11)));
        jPanel_DVL_WTDatas.setPreferredSize(new Dimension(675, 167));
        this.jLabel48.setText("XS1 speed or WT Velocity (m/s):");
        jTextField_DVLWT_XS1Speed.setHorizontalAlignment(0);
        jTextField_DVLWT_XS1Speed.setText("48.80");
        jTextField_DVLWT_XS1Speed.setPreferredSize(new Dimension(24, 22));
        this.jLabel55.setText("XS1 speed std (m/s):");
        jTextField_DVLWT_XS1SpeedStd.setHorizontalAlignment(0);
        jTextField_DVLWT_XS1SpeedStd.setText("0.0");
        this.jLabel56.setText("Speed of sound (m/s):");
        jTextField_DVLWT_SoundSpeed.setHorizontalAlignment(0);
        jTextField_DVLWT_SoundSpeed.setText("0.0");
        this.jLabel57.setText("XS2 speed (m/s):");
        jTextField_DVLWT_XS2Speed.setHorizontalAlignment(0);
        jTextField_DVLWT_XS2Speed.setText("2.0");
        this.jLabel58.setText("XS2 speed std (m/s):");
        jTextField_DVLWT_XS2SpeedStd.setHorizontalAlignment(0);
        jTextField_DVLWT_XS2SpeedStd.setText("0.0");
        this.jLabel59.setText("Altitude (m):");
        this.jLabel59.setPreferredSize(new Dimension(85, 16));
        jTextField_DVLWT_Altitude.setHorizontalAlignment(0);
        jTextField_DVLWT_Altitude.setText("0.0");
        this.jLabel60.setText("XS3 speed (m/s):");
        jTextField_DVLWT_XS3Speed.setHorizontalAlignment(0);
        jTextField_DVLWT_XS3Speed.setText("0.0");
        this.jLabel61.setText("XS3 speed std (m/s):");
        jTextField_DVLWT_XS3SpeedStd.setHorizontalAlignment(0);
        jTextField_DVLWT_XS3SpeedStd.setText("0.0");
        this.jLabel62.setText("Latency or Time of Validity (s):");
        jTextField_DVLWT_Latency.setHorizontalAlignment(0);
        jTextField_DVLWT_Latency.setText("0.0");
        jCheckBox_DVLWTValidity.setText("Validity flag");
        jCheckBox_DVLWTValidity.setAutoscrolls(true);
        GroupLayout jPanel_DVL_WTDatasLayout = new GroupLayout(jPanel_DVL_WTDatas);
        jPanel_DVL_WTDatas.setLayout(jPanel_DVL_WTDatasLayout);
        jPanel_DVL_WTDatasLayout.setHorizontalGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_DVL_WTDatasLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel48).addGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel60, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel57, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jTextField_DVLWT_XS3Speed).addComponent(jTextField_DVLWT_XS2Speed).addComponent(jTextField_DVLWT_XS1Speed, -1, 49, Short.MAX_VALUE)).addGap(25, 25, 25).addGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel55).addComponent(this.jLabel58).addComponent(this.jLabel61)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jTextField_DVLWT_XS1SpeedStd, GroupLayout.Alignment.TRAILING).addComponent(jTextField_DVLWT_XS2SpeedStd, GroupLayout.Alignment.TRAILING).addComponent(jTextField_DVLWT_XS3SpeedStd, -2, 51, -2)).addGap(25, 25, 25).addGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel56).addComponent(this.jLabel59, -2, -1, -2).addComponent(this.jLabel62)).addGap(18, 18, 18).addGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jTextField_DVLWT_Latency).addComponent(jTextField_DVLWT_Altitude).addComponent(jTextField_DVLWT_SoundSpeed, -1, 51, Short.MAX_VALUE)).addGap(24, 24, 24).addComponent(jCheckBox_DVLWTValidity).addContainerGap()));
        jPanel_DVL_WTDatasLayout.setVerticalGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DVL_WTDatasLayout.createSequentialGroup().addContainerGap(23, Short.MAX_VALUE).addGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel48).addComponent(jTextField_DVLWT_XS1Speed, -2, -1, -2).addComponent(this.jLabel55).addComponent(jTextField_DVLWT_XS1SpeedStd, -2, -1, -2).addComponent(this.jLabel56).addComponent(jTextField_DVLWT_SoundSpeed, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel57).addComponent(jTextField_DVLWT_XS2Speed, -2, -1, -2).addComponent(this.jLabel58).addComponent(jTextField_DVLWT_XS2SpeedStd, -2, -1, -2).addComponent(this.jLabel59, -2, -1, -2).addComponent(jTextField_DVLWT_Altitude, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DVL_WTDatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel60).addComponent(jTextField_DVLWT_XS3Speed, -2, -1, -2).addComponent(this.jLabel61).addComponent(jTextField_DVLWT_XS3SpeedStd, -2, -1, -2).addComponent(this.jLabel62).addComponent(jTextField_DVLWT_Latency, -2, -1, -2).addComponent(jCheckBox_DVLWTValidity))));
        jPanel_DVL_Id.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor Id", 0, 0, new Font("Tahoma", 1, 11)));
        jComboBox_DVLId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_DVLIdActionPerformed(evt);
            }
        });
        this.jLabel96.setText("DVL Id:");
        this.jComboBox_CoordinateVelocities.setModel(new DefaultComboBoxModel<String>(new String[]{"Beam", "Instrument", "Ship"}));
        this.jComboBox_CoordinateVelocities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_CoordinateVelocitiesActionPerformed(evt);
            }
        });
        this.jLabel100.setText("Coordinate Velocities:");
        GroupLayout jPanel_DVL_IdLayout = new GroupLayout(jPanel_DVL_Id);
        jPanel_DVL_Id.setLayout(jPanel_DVL_IdLayout);
        jPanel_DVL_IdLayout.setHorizontalGroup(jPanel_DVL_IdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DVL_IdLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel96, -2, 65, -2).addGap(18, 18, 18).addComponent(jComboBox_DVLId, -2, 84, -2).addGap(49, 49, 49).addComponent(this.jLabel100).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox_CoordinateVelocities, -2, -1, -2).addContainerGap(412, Short.MAX_VALUE)));
        jPanel_DVL_IdLayout.setVerticalGroup(jPanel_DVL_IdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DVL_IdLayout.createSequentialGroup().addGroup(jPanel_DVL_IdLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel96).addComponent(jComboBox_DVLId, -2, -1, -2).addComponent(this.jComboBox_CoordinateVelocities, -2, -1, -2).addComponent(this.jLabel100)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jPanel_DVL_Id, -1, -1, Short.MAX_VALUE).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jPanel_DVL_BTDatas, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jPanel_DVL_WTDatas, GroupLayout.Alignment.LEADING, -1, 878, Short.MAX_VALUE))).addContainerGap(97, Short.MAX_VALUE)));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_DVL_Id, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_DVL_BTDatas, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_DVL_WTDatas, -2, 127, -2).addContainerGap(178, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("DVL", this.jPanel10);
        jDvlBottomTrackUsed.setSelected(true);
        jDvlBottomTrackUsed.setText("DVL Bottom Track");
        jDvlBottomTrackUsed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jDvlBottomTrackUsedActionPerformed(evt);
            }
        });
        jDvlWaterTrackUsed.setText("DVL Water Track");
        jDvlWaterTrackUsed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jDvlWaterTrackUsedActionPerformed(evt);
            }
        });
        this.jLabel119.setText("Number of Beams used");
        jDvlNortekNbOfBeam.setMajorTickSpacing(1);
        jDvlNortekNbOfBeam.setMaximum(4);
        jDvlNortekNbOfBeam.setPaintLabels(true);
        this.jLabel120.setText("Serial Number");
        jDvlNortekSerialNumber.setText("0");
        jDvlNortekSerialNumber.setEnabled(false);
        this.jLabel121.setText("Speed of Sound");
        jDvlNortekSpdOfSound.setText("1500");
        jDvlNortekSpdOfSound.setToolTipText("");
        this.jDvlNortekTemperature.setText("Temperature");
        jTextField3.setText("20");
        jTextField3.setEnabled(false);
        this.jLabel123.setText("Pressure");
        jDvlNortekPressure.setText("10");
        jCmbBoxVelocityBeam.setModel(new DefaultComboBoxModel<String>(new String[]{"Velocity Beam #0", "Velocity Beam #1", "Velocity Beam #2", "Velocity Beam #3"}));
        jCmbBoxVelocityBeam.setEnabled(false);
        jTextField5.setText("0");
        jTextField5.setEnabled(false);
        jCmbBoxDistanceBeam.setModel(new DefaultComboBoxModel<String>(new String[]{"Distance Beam #0", "Distance Beam #1", "Distance Beam #2", "Distance Beam #3"}));
        jCmbBoxDistanceBeam.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SimulatorFrame.this.jCmbBoxDistanceBeamItemStateChanged(evt);
            }
        });
        jDvlNortekDistanceBeam.setText("0");
        this.jLabel124.setText("m");
        this.jLabel125.setText("m/s");
        this.jLabel126.setText("\u00b0C");
        this.jLabel127.setText("bar");
        jCmbBoxFOMBeam.setModel(new DefaultComboBoxModel<String>(new String[]{"FOM Beam #0", "FOM Beam #1", "FOM Beam #2", "FOM Beam #3"}));
        jCmbBoxFOMBeam.setEnabled(false);
        jTextField7.setText("0");
        jTextField7.setEnabled(false);
        this.jLabel128.setText("m/s");
        jCmbBoxDT1Beam.setModel(new DefaultComboBoxModel<String>(new String[]{"DT1 Beam #0", "DT1 Beam #1", "DT1 Beam #2", "DT1 Beam #3"}));
        jCmbBoxDT1Beam.setEnabled(false);
        jTextField8.setText("0");
        jTextField8.setEnabled(false);
        this.jLabel129.setText("s");
        jCmbBoxDT2Beam.setModel(new DefaultComboBoxModel<String>(new String[]{"DT2 Beam #0", "DT2 Beam #1", "DT2 Beam #2", "DT2 Beam #3"}));
        jCmbBoxDT2Beam.setEnabled(false);
        jTextField9.setText("0");
        jTextField9.setEnabled(false);
        this.jLabel130.setText("s");
        jCmbBoxTimeVelEstBeam.setModel(new DefaultComboBoxModel<String>(new String[]{"Time Vel Est Beam #0", "Time Vel Est Beam #1", "Time Vel Est Beam #2", "Time Vel Est Beam #3"}));
        jCmbBoxTimeVelEstBeam.setEnabled(false);
        jTextField10.setText("0");
        jTextField10.setEnabled(false);
        this.jLabel131.setText("s");
        this.jLabel132.setText("m/s");
        jCmbBoxVelocityAxis.setModel(new DefaultComboBoxModel<String>(new String[]{"Velocity X", "Velocity Y", "Velocity Z1", "Velocity Z2"}));
        jCmbBoxVelocityAxis.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SimulatorFrame.this.jCmbBoxVelocityAxisItemStateChanged(evt);
            }
        });
        jDvlNortekVelocity.setText("0");
        jDvlNortekFOM.setText("0");
        jCmbBoxFOMAxis.setModel(new DefaultComboBoxModel<String>(new String[]{"FOM X", "FOM Y", "FOM Z1", "FOM Z2"}));
        jCmbBoxFOMAxis.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SimulatorFrame.this.jCmbBoxFOMAxisItemStateChanged(evt);
            }
        });
        jCmbBoxDT1Axis.setModel(new DefaultComboBoxModel<String>(new String[]{"DT1 X", "DT1 Y", "DT1 Z1", "DT1 Z2"}));
        jCmbBoxDT1Axis.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SimulatorFrame.this.jCmbBoxDT1AxisItemStateChanged(evt);
            }
        });
        jDvlNortekDT1.setText("0");
        jCmbBoxDT2Axis.setModel(new DefaultComboBoxModel<String>(new String[]{"DT2 X", "DT2 Y", "DT2 Z1", "DT2 Z2"}));
        jCmbBoxDT2Axis.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SimulatorFrame.this.jCmbBoxDT2AxisItemStateChanged(evt);
            }
        });
        jDvlNortekDT2.setText("0");
        jCmbBoxTimeVelEstAxis.setModel(new DefaultComboBoxModel<String>(new String[]{"Time Vel Est X", "Time Vel Est Y", "Time Vel Est Z1", "Time Vel Est Z2"}));
        jCmbBoxTimeVelEstAxis.setEnabled(false);
        jDvlNortekTimeVelEst.setText("0");
        jDvlNortekTimeVelEst.setEnabled(false);
        this.jLabel133.setText("m/s");
        this.jLabel135.setText("m/s");
        this.jLabel136.setText("s");
        this.jLabel137.setText("s");
        this.jLabel138.setText("s");
        this.jLabel134.setText("Error");
        this.jLabel139.setText("Status");
        jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        jComboBox1.setEnabled(false);
        jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        jComboBox2.setEnabled(false);
        jButton1.setText("+");
        jButton1.setEnabled(false);
        jButton2.setText("-");
        jButton2.setEnabled(false);
        jButton3.setText("+");
        jButton3.setEnabled(false);
        jButton4.setText("-");
        jButton4.setEnabled(false);
        jTextField12.setText("0");
        jTextField12.setEnabled(false);
        jTextField17.setText("0");
        jTextField17.setEnabled(false);
        this.jButton5.setText("Save");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton6.setText("Save");
        this.jButton6.setEnabled(false);
        this.jButton7.setText("Save");
        this.jButton7.setEnabled(false);
        this.jButton9.setText("Save");
        this.jButton9.setEnabled(false);
        this.jButton10.setText("Save");
        this.jButton10.setEnabled(false);
        this.jButton11.setText("Save");
        this.jButton11.setEnabled(false);
        this.jButton12.setText("Save");
        this.jButton12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton12ActionPerformed(evt);
            }
        });
        this.jButton13.setText("Save");
        this.jButton13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton13ActionPerformed(evt);
            }
        });
        this.jButton14.setText("Save");
        this.jButton14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton14ActionPerformed(evt);
            }
        });
        this.jButton15.setText("Save");
        this.jButton15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton15ActionPerformed(evt);
            }
        });
        this.jButton16.setText("Save");
        this.jButton16.setEnabled(false);
        GroupLayout jPanel26Layout = new GroupLayout(this.jPanel26);
        this.jPanel26.setLayout(jPanel26Layout);
        jPanel26Layout.setHorizontalGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel26Layout.createSequentialGroup().addContainerGap().addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jCmbBoxTimeVelEstBeam, 0, -1, Short.MAX_VALUE).addComponent(jCmbBoxDT2Beam, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(jCmbBoxDT1Beam, 0, -1, Short.MAX_VALUE).addComponent(jCmbBoxFOMBeam, 0, -1, Short.MAX_VALUE).addComponent(jCmbBoxDistanceBeam, 0, -1, Short.MAX_VALUE).addComponent(jCmbBoxVelocityBeam, 0, -1, Short.MAX_VALUE).addComponent(this.jLabel123, -1, -1, Short.MAX_VALUE).addComponent(this.jDvlNortekTemperature, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel121, -1, -1, Short.MAX_VALUE).addComponent(jDvlBottomTrackUsed, GroupLayout.Alignment.LEADING).addComponent(this.jLabel119, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel120, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(27, 27, 27).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jDvlWaterTrackUsed).addComponent(jTextField9).addComponent(jTextField8).addComponent(jTextField7).addComponent(jDvlNortekDistanceBeam).addComponent(jTextField5).addComponent(jDvlNortekPressure).addComponent(jTextField3).addComponent(jDvlNortekSpdOfSound, -1, 150, Short.MAX_VALUE).addComponent(jDvlNortekSerialNumber).addComponent(jDvlNortekNbOfBeam, -2, 0, Short.MAX_VALUE).addComponent(jTextField10)).addGap(2, 2, 2).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel26Layout.createSequentialGroup().addComponent(this.jLabel128).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton6, -1, -1, Short.MAX_VALUE)).addGroup(jPanel26Layout.createSequentialGroup().addComponent(this.jLabel129).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton7)).addGroup(jPanel26Layout.createSequentialGroup().addComponent(this.jLabel130).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton9)).addGroup(jPanel26Layout.createSequentialGroup().addComponent(this.jLabel131).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton10)).addGroup(jPanel26Layout.createSequentialGroup().addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel125).addComponent(this.jLabel126).addComponent(this.jLabel127).addGroup(jPanel26Layout.createSequentialGroup().addComponent(this.jLabel132).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton11))).addGap(0, 0, Short.MAX_VALUE))).addGroup(jPanel26Layout.createSequentialGroup().addComponent(this.jLabel124).addGap(23, 23, 23).addComponent(this.jButton5))).addGap(102, 102, 102).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel26Layout.createSequentialGroup().addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel134, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel139, -2, 82, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField12, -2, 164, -2).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel26Layout.createSequentialGroup().addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jComboBox2, 0, -1, Short.MAX_VALUE).addComponent(jTextField17, -2, 164, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton3, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton4, -2, 41, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel26Layout.createSequentialGroup().addComponent(jComboBox1, -2, 164, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton2, -2, 41, -2).addGap(90, 90, 90))))).addGroup(jPanel26Layout.createSequentialGroup().addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jCmbBoxTimeVelEstAxis, 0, -1, Short.MAX_VALUE).addComponent(jCmbBoxDT2Axis, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(jCmbBoxDT1Axis, 0, -1, Short.MAX_VALUE).addComponent(jCmbBoxFOMAxis, 0, -1, Short.MAX_VALUE).addComponent(jCmbBoxVelocityAxis, -2, 155, -2)).addGap(27, 27, 27).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jDvlNortekDT2, GroupLayout.Alignment.LEADING).addComponent(jDvlNortekDT1, GroupLayout.Alignment.LEADING).addComponent(jDvlNortekFOM, GroupLayout.Alignment.LEADING).addComponent(jDvlNortekVelocity, GroupLayout.Alignment.LEADING).addComponent(jDvlNortekTimeVelEst, -2, 150, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel26Layout.createSequentialGroup().addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel137, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel136, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel138, -1, -1, Short.MAX_VALUE)).addGap(12, 12, 12).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton16, -1, -1, Short.MAX_VALUE).addComponent(this.jButton14, -1, -1, Short.MAX_VALUE).addComponent(this.jButton15, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel26Layout.createSequentialGroup().addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel133, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel135, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton12, -1, -1, Short.MAX_VALUE).addComponent(this.jButton13, -1, -1, Short.MAX_VALUE)))).addContainerGap()))));
        jPanel26Layout.setVerticalGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel26Layout.createSequentialGroup().addContainerGap().addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel26Layout.createSequentialGroup().addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jDvlBottomTrackUsed).addComponent(jDvlWaterTrackUsed)).addGap(13, 13, 13).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel120).addComponent(jDvlNortekSerialNumber, -2, -1, -2)).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel26Layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jLabel119)).addGroup(jPanel26Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jDvlNortekNbOfBeam, -2, -1, -2))).addGap(18, 18, 18).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel127, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, jPanel26Layout.createSequentialGroup().addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jDvlNortekSpdOfSound, -2, -1, -2).addComponent(this.jLabel121).addComponent(this.jLabel125)).addGap(18, 18, 18).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDvlNortekTemperature).addComponent(jTextField3, -2, -1, -2).addComponent(this.jLabel126)).addGap(18, 18, 18).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel123).addComponent(jDvlNortekPressure, -2, -1, -2)))).addGap(18, 18, 18).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCmbBoxVelocityBeam, -2, -1, -2).addComponent(jTextField5, -2, -1, -2).addComponent(this.jLabel132).addComponent(this.jButton11)).addGap(18, 18, 18).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCmbBoxDistanceBeam, -2, -1, -2).addComponent(jDvlNortekDistanceBeam, -2, -1, -2).addComponent(this.jLabel124).addComponent(this.jButton5)).addGap(18, 18, 18).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCmbBoxFOMBeam, -2, -1, -2).addComponent(jTextField7, -2, -1, -2).addComponent(this.jLabel128).addComponent(this.jButton6).addComponent(jCmbBoxDT1Axis, -2, -1, -2).addComponent(jDvlNortekDT1, -2, -1, -2).addComponent(this.jLabel136).addComponent(this.jButton14)).addGap(18, 18, 18).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCmbBoxDT1Beam, -2, -1, -2).addComponent(jTextField8, -2, -1, -2).addComponent(this.jLabel129).addComponent(this.jButton7).addComponent(jCmbBoxDT2Axis, -2, -1, -2).addComponent(jDvlNortekDT2, -2, -1, -2).addComponent(this.jLabel137).addComponent(this.jButton15)).addGap(18, 18, 18)).addGroup(GroupLayout.Alignment.TRAILING, jPanel26Layout.createSequentialGroup().addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel134).addComponent(jComboBox1, -2, -1, -2).addComponent(jButton1).addComponent(jButton2)).addGap(18, 18, 18).addComponent(jTextField12, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jComboBox2, -2, -1, -2).addComponent(this.jLabel139).addComponent(jButton3).addComponent(jButton4)).addGap(18, 18, 18).addComponent(jTextField17, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCmbBoxVelocityAxis, -2, -1, -2).addComponent(jDvlNortekVelocity, -2, -1, -2).addComponent(this.jLabel133).addComponent(this.jButton12)).addGap(18, 18, 18).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCmbBoxFOMAxis, -2, -1, -2).addComponent(jDvlNortekFOM, -2, -1, -2).addComponent(this.jLabel135).addComponent(this.jButton13)).addGap(104, 104, 104))).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCmbBoxDT2Beam, -2, -1, -2).addComponent(jTextField9, -2, -1, -2).addComponent(this.jLabel130).addComponent(this.jButton9)).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCmbBoxTimeVelEstAxis, -2, -1, -2).addComponent(jDvlNortekTimeVelEst, -2, -1, -2)).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel138).addComponent(this.jButton16))).addGap(18, 18, 18).addGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCmbBoxTimeVelEstBeam, -2, -1, -2).addComponent(jTextField10, -2, -1, -2).addComponent(this.jLabel131).addComponent(this.jButton10)).addContainerGap(-1, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("DVL NORTEK", this.jPanel26);
        jPanel_USBL_Id.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor Id", 0, 0, new Font("Tahoma", 1, 11)));
        jComboBox_USBLId.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SimulatorFrame.this.jComboBox_USBLIdPopupMenuWillBecomeVisible(evt);
            }
        });
        jComboBox_USBLId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_USBLIdActionPerformed(evt);
            }
        });
        this.jLabel13.setText("USBL Id:");
        GroupLayout jPanel_USBL_IdLayout = new GroupLayout(jPanel_USBL_Id);
        jPanel_USBL_Id.setLayout(jPanel_USBL_IdLayout);
        jPanel_USBL_IdLayout.setHorizontalGroup(jPanel_USBL_IdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_USBL_IdLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel13, -2, 65, -2).addGap(18, 18, 18).addComponent(jComboBox_USBLId, -2, 84, -2).addContainerGap(772, Short.MAX_VALUE)));
        jPanel_USBL_IdLayout.setVerticalGroup(jPanel_USBL_IdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_USBL_IdLayout.createSequentialGroup().addGroup(jPanel_USBL_IdLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(jComboBox_USBLId, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_USBL_Datas.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor Datas", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_DVLmisalignment14.setText("Beacon Code ID :");
        jTextField_USBLBeaconCodeID.setHorizontalAlignment(0);
        jTextField_USBLBeaconCodeID.setText("0");
        jTextField_USBLBeaconCodeID.setDoubleBuffered(true);
        jCheckBox_USBLValidity.setText("Validity flag");
        this.jLabel31.setText("Latitude (deg):");
        jTextField_USBLLatitude.setHorizontalAlignment(0);
        jTextField_USBLLatitude.setText("48.80");
        jTextField_USBLLatitude.setPreferredSize(new Dimension(24, 22));
        jTextField_USBLLatitude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jTextField_USBLLatitudeActionPerformed(evt);
            }
        });
        this.jLabel32.setText("Lat. Std (m):");
        jTextField_USBLLatitudeStd.setHorizontalAlignment(0);
        jTextField_USBLLatitudeStd.setText("0.0");
        this.jLabel33.setText("Lati/Long cov. (m) :");
        jTextField_USBLLatLongCov.setHorizontalAlignment(0);
        jTextField_USBLLatLongCov.setText("0.0");
        this.jLabel34.setText("Longitude (deg):");
        jTextField_USBLLongitude.setHorizontalAlignment(0);
        jTextField_USBLLongitude.setText("2.0");
        this.jLabel35.setText("Long. Std (m):");
        jTextField_USBLLongitudeStd.setHorizontalAlignment(0);
        jTextField_USBLLongitudeStd.setText("0.0");
        this.jLabel36.setText("Latency (s) :");
        this.jLabel36.setPreferredSize(new Dimension(85, 16));
        jTextField_USBLLatency.setHorizontalAlignment(0);
        jTextField_USBLLatency.setText("0.0");
        jTextField_USBLDepthStd.setHorizontalAlignment(0);
        jTextField_USBLDepthStd.setText("0.0");
        this.jLabel37.setText("Depth Std (m):");
        jTextField_USBLDepth.setHorizontalAlignment(0);
        jTextField_USBLDepth.setText("0.0");
        this.jLabel38.setText("Depth (m):");
        this.jLabel65.setText("SD Semi-major Ax. (m):");
        jTextField_USBLMajorAxis.setHorizontalAlignment(0);
        jTextField_USBLMajorAxis.setText("0.0");
        jTextField_USBLMajorAxis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jTextField_USBLMajorAxisActionPerformed(evt);
            }
        });
        this.jLabel68.setText("SD Semi-minor Ax. (m):");
        jTextField_USBLMinorAxis.setHorizontalAlignment(0);
        jTextField_USBLMinorAxis.setText("0.0");
        jLabel_DVLmisalignment16.setText("Semi-major Axis Dir. (\u00b0):");
        jTextField_USBLMajorAxisDir.setHorizontalAlignment(0);
        jTextField_USBLMajorAxisDir.setText("0.0");
        jTextField_USBLMajorAxisDir.setDoubleBuffered(true);
        jLabel_DVLmisalignment17.setText("Beacon Number ID :");
        jTextField_USBLBeaconNumID.setHorizontalAlignment(0);
        jTextField_USBLBeaconNumID.setText("0");
        jTextField_USBLBeaconNumID.setDoubleBuffered(true);
        this.jLabel92.setText("UTM Est (m):");
        this.jLabel93.setText("UTM Nord (m):");
        this.jLabel94.setText("UTM Zone:");
        jTextField_USBLUTMZone.setHorizontalAlignment(0);
        jTextField_USBLUTMZone.setText("U32");
        jTextField_USBLUTMNord.setHorizontalAlignment(0);
        jTextField_USBLUTMNord.setText("0.0");
        jTextField_USBLUTMEst.setHorizontalAlignment(0);
        jTextField_USBLUTMEst.setText("0.0");
        jTextField_USBLUTMEst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jTextField_USBLUTMEstActionPerformed(evt);
            }
        });
        GroupLayout jPanel_USBL_DatasLayout = new GroupLayout(jPanel_USBL_Datas);
        jPanel_USBL_Datas.setLayout(jPanel_USBL_DatasLayout);
        jPanel_USBL_DatasLayout.setHorizontalGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_USBL_DatasLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_USBL_DatasLayout.createSequentialGroup().addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel31, GroupLayout.Alignment.LEADING).addComponent(this.jLabel34, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel38, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jTextField_USBLLongitude, -1, 50, Short.MAX_VALUE).addComponent(jTextField_USBLLatitude, -1, -1, Short.MAX_VALUE).addComponent(jTextField_USBLDepth)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel37).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel32, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel35, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jTextField_USBLLongitudeStd, GroupLayout.Alignment.TRAILING).addComponent(jTextField_USBLDepthStd).addComponent(jTextField_USBLLatitudeStd, -2, 62, -2))).addGroup(jPanel_USBL_DatasLayout.createSequentialGroup().addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel93, -1, 105, Short.MAX_VALUE).addComponent(this.jLabel92, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel94, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jTextField_USBLUTMNord, GroupLayout.Alignment.LEADING).addComponent(jTextField_USBLUTMEst, GroupLayout.Alignment.LEADING, -1, 114, Short.MAX_VALUE)).addComponent(jTextField_USBLUTMZone, -2, 57, -2)).addGap(0, 0, Short.MAX_VALUE))).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_USBL_DatasLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jLabel_DVLmisalignment16, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel68, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel65, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jTextField_USBLMinorAxis, GroupLayout.Alignment.LEADING, -1, 57, Short.MAX_VALUE).addComponent(jTextField_USBLMajorAxisDir).addComponent(jTextField_USBLMajorAxis)).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_USBL_DatasLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_USBL_DatasLayout.createSequentialGroup().addComponent(this.jLabel33, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_USBLLatLongCov, -2, 55, -2)).addGroup(jPanel_USBL_DatasLayout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jLabel36, -2, 94, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jTextField_USBLLatency, -2, 55, -2)).addGroup(jPanel_USBL_DatasLayout.createSequentialGroup().addComponent(jLabel_DVLmisalignment14, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_USBLBeaconCodeID, -2, 55, -2)))).addGroup(GroupLayout.Alignment.TRAILING, jPanel_USBL_DatasLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(jLabel_DVLmisalignment17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_USBLBeaconNumID, -2, 55, -2)))).addGroup(GroupLayout.Alignment.TRAILING, jPanel_USBL_DatasLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jCheckBox_USBLValidity))).addContainerGap()));
        jPanel_USBL_DatasLayout.setVerticalGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_USBL_DatasLayout.createSequentialGroup().addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_USBL_DatasLayout.createSequentialGroup().addGap(16, 16, 16).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel31).addComponent(jTextField_USBLLatitude, -2, -1, -2).addComponent(this.jLabel32).addComponent(jTextField_USBLLatitudeStd, -2, -1, -2).addComponent(this.jLabel65).addComponent(jTextField_USBLMajorAxis, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel35).addComponent(jTextField_USBLLongitudeStd, -2, -1, -2).addComponent(this.jLabel68).addComponent(jTextField_USBLMinorAxis, -2, -1, -2).addComponent(this.jLabel36, -2, -1, -2).addComponent(jTextField_USBLLatency, -2, -1, -2)).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel34).addComponent(jTextField_USBLLongitude, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel38).addComponent(jTextField_USBLDepth, -2, -1, -2).addComponent(this.jLabel37).addComponent(jTextField_USBLDepthStd, -2, -1, -2).addComponent(jLabel_DVLmisalignment16).addComponent(jTextField_USBLMajorAxisDir, -2, -1, -2).addComponent(jLabel_DVLmisalignment14).addComponent(jTextField_USBLBeaconCodeID, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel92).addComponent(jTextField_USBLUTMEst, -2, -1, -2).addComponent(jLabel_DVLmisalignment17).addComponent(jTextField_USBLBeaconNumID, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel93).addComponent(jTextField_USBLUTMNord, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel94).addComponent(jTextField_USBLUTMZone, -2, -1, -2).addComponent(jCheckBox_USBLValidity))).addGroup(jPanel_USBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_USBL_DatasLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jLabel33)).addGroup(GroupLayout.Alignment.TRAILING, jPanel_USBL_DatasLayout.createSequentialGroup().addContainerGap().addComponent(jTextField_USBLLatLongCov, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_USBL_Id, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_USBL_Datas, -1, -1, Short.MAX_VALUE).addContainerGap())));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_USBL_Id, -2, -1, -2).addContainerGap(442, Short.MAX_VALUE)).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addGap(71, 71, 71).addComponent(jPanel_USBL_Datas, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE))));
        jTabbedPane_Main.addTab("USBL", this.jPanel11);
        jPanel_LBL_Id.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor Id", 0, 0, new Font("Tahoma", 1, 11)));
        jComboBox_LBLId.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SimulatorFrame.this.jComboBox_LBLIdPopupMenuWillBecomeVisible(evt);
            }
        });
        jComboBox_LBLId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_LBLIdActionPerformed(evt);
            }
        });
        this.jLabel14.setText("LBL Id:");
        GroupLayout jPanel_LBL_IdLayout = new GroupLayout(jPanel_LBL_Id);
        jPanel_LBL_Id.setLayout(jPanel_LBL_IdLayout);
        jPanel_LBL_IdLayout.setHorizontalGroup(jPanel_LBL_IdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_LBL_IdLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel14, -2, 65, -2).addGap(18, 18, 18).addComponent(jComboBox_LBLId, -2, 84, -2).addContainerGap(772, Short.MAX_VALUE)));
        jPanel_LBL_IdLayout.setVerticalGroup(jPanel_LBL_IdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_LBL_IdLayout.createSequentialGroup().addGroup(jPanel_LBL_IdLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(jComboBox_LBLId, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_LBL_Datas.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor Datas", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_DVLmisalignment15.setText("Beacon code:");
        jTextField_LBLBeaconCode.setHorizontalAlignment(0);
        jTextField_LBLBeaconCode.setText("0");
        jCheckBox_LBLValidity.setText("Validity flag");
        this.jLabel39.setText("Latitude (deg):");
        jTextField_LBLLatitude.setHorizontalAlignment(0);
        jTextField_LBLLatitude.setText("48.80");
        jTextField_LBLLatitude.setPreferredSize(new Dimension(24, 22));
        this.jLabel40.setText("Range (m):");
        jTextField_LBLRange.setHorizontalAlignment(0);
        jTextField_LBLRange.setText("0.0");
        this.jLabel42.setText("Longitude (deg):");
        jTextField_LBLLongitude.setHorizontalAlignment(0);
        jTextField_LBLLongitude.setText("2.0");
        this.jLabel43.setText("Range Std (m):");
        jTextField_LBLRangeStd.setHorizontalAlignment(0);
        jTextField_LBLRangeStd.setText("0.0");
        this.jLabel44.setText("Latency (s):");
        this.jLabel44.setPreferredSize(new Dimension(85, 16));
        jTextField_LBLLatency.setHorizontalAlignment(0);
        jTextField_LBLLatency.setText("0.0");
        jTextField_LBLDepth.setHorizontalAlignment(0);
        jTextField_LBLDepth.setText("0.0");
        this.jLabel46.setText("Depth (m):");
        GroupLayout jPanel_LBL_DatasLayout = new GroupLayout(jPanel_LBL_Datas);
        jPanel_LBL_Datas.setLayout(jPanel_LBL_DatasLayout);
        jPanel_LBL_DatasLayout.setHorizontalGroup(jPanel_LBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_LBL_DatasLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_LBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel39).addComponent(this.jLabel42).addComponent(this.jLabel46, -1, 212, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_LBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_LBLLongitude, -1, 191, Short.MAX_VALUE).addComponent(jTextField_LBLDepth).addComponent(jTextField_LBLLatitude, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel_LBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel40).addComponent(this.jLabel43).addComponent(jLabel_DVLmisalignment15)).addGap(16, 16, 16).addGroup(jPanel_LBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jTextField_LBLBeaconCode).addComponent(jTextField_LBLRangeStd, GroupLayout.Alignment.TRAILING).addComponent(jTextField_LBLRange, -2, 61, -2)).addGroup(jPanel_LBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_LBL_DatasLayout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jLabel44, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_LBLLatency, -2, 46, -2).addGap(188, 188, 188)).addGroup(GroupLayout.Alignment.TRAILING, jPanel_LBL_DatasLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_LBLValidity).addContainerGap()))));
        jPanel_LBL_DatasLayout.setVerticalGroup(jPanel_LBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_LBL_DatasLayout.createSequentialGroup().addGap(16, 16, 16).addGroup(jPanel_LBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel39).addComponent(jTextField_LBLLatitude, -2, -1, -2).addComponent(this.jLabel40).addComponent(jTextField_LBLRange, -2, -1, -2).addComponent(this.jLabel44, -2, -1, -2).addComponent(jTextField_LBLLatency, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_LBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel42).addComponent(jTextField_LBLLongitude, -2, -1, -2).addComponent(this.jLabel43).addComponent(jTextField_LBLRangeStd, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_LBL_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel46).addComponent(jTextField_LBLDepth, -2, -1, -2).addComponent(jLabel_DVLmisalignment15).addComponent(jTextField_LBLBeaconCode, -2, -1, -2)).addContainerGap(19, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel_LBL_DatasLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(jCheckBox_LBLValidity).addContainerGap()));
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_LBL_Id, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_LBL_Datas, -1, -1, Short.MAX_VALUE).addContainerGap())));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_LBL_Id, -2, -1, -2).addContainerGap(442, Short.MAX_VALUE)).addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addGap(77, 77, 77).addComponent(jPanel_LBL_Datas, -2, -1, -2).addContainerGap(298, Short.MAX_VALUE))));
        jTabbedPane_Main.addTab("LBL", this.jPanel12);
        jPanel_DEPTH_Datas.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor Datas", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel28.setText("Depth (m):");
        this.jLabel28.setPreferredSize(new Dimension(85, 16));
        jTextField_DEPTHDepth.setHorizontalAlignment(0);
        jTextField_DEPTHDepth.setText("0.0");
        jTextField_DEPTHDepth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jTextField_DEPTHDepthActionPerformed(evt);
            }
        });
        this.jLabel29.setText("Depth Std (m):");
        jTextField_DEPTHDepthStd.setHorizontalAlignment(0);
        jTextField_DEPTHDepthStd.setText("0.0");
        jCheckBox_DEPTHValidity.setText("Validity flag");
        jCheckBox_DEPTHValidity.setAutoscrolls(true);
        this.jLabel30.setText("Pressure (dBar):");
        this.jLabel30.setPreferredSize(new Dimension(85, 16));
        jTextField_DEPTH_Pressure.setHorizontalAlignment(0);
        jTextField_DEPTH_Pressure.setText("0.0");
        this.jLabel73.setText("Temperature (\u00b0C):");
        jTextField_Depth_SoundSpeed.setHorizontalAlignment(0);
        jTextField_Depth_SoundSpeed.setText("0.0");
        jTextField_Depth_Temperature.setHorizontalAlignment(0);
        jTextField_Depth_Temperature.setText("0.0");
        this.jLabel74.setText("Speed of sound (m/s):");
        this.jLabel75.setText("Latency (s):");
        this.jLabel75.setPreferredSize(new Dimension(85, 16));
        jTextField_DEPTHLatency.setHorizontalAlignment(0);
        jTextField_DEPTHLatency.setText("0.0");
        this.jLabel83.setText("Compensated Data");
        GroupLayout jPanel_DEPTH_DatasLayout = new GroupLayout(jPanel_DEPTH_Datas);
        jPanel_DEPTH_Datas.setLayout(jPanel_DEPTH_DatasLayout);
        jPanel_DEPTH_DatasLayout.setHorizontalGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DEPTH_DatasLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DEPTH_DatasLayout.createSequentialGroup().addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel28, -1, 330, Short.MAX_VALUE).addComponent(this.jLabel30, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel75, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jTextField_DEPTH_Pressure, -2, 57, -2).addComponent(jTextField_DEPTHDepth, -2, 57, -2)).addComponent(jTextField_DEPTHLatency, GroupLayout.Alignment.TRAILING, -2, 57, -2))).addGroup(jPanel_DEPTH_DatasLayout.createSequentialGroup().addComponent(this.jLabel83, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_CompensatedData, -2, 21, -2).addGap(9, 9, 9))).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DEPTH_DatasLayout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.jLabel29).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_DEPTHDepthStd, -2, 52, -2).addGap(54, 54, 54).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel73, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel74, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jTextField_Depth_Temperature).addComponent(jTextField_Depth_SoundSpeed, -1, 62, Short.MAX_VALUE)).addGap(116, 116, 116)).addGroup(GroupLayout.Alignment.TRAILING, jPanel_DEPTH_DatasLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jCheckBox_DEPTHValidity).addContainerGap()))));
        jPanel_DEPTH_DatasLayout.setVerticalGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_DEPTH_DatasLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jCheckBox_CompensatedData).addGroup(jPanel_DEPTH_DatasLayout.createSequentialGroup().addComponent(this.jLabel83, -2, 21, -2).addGap(5, 5, 5).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DEPTH_DatasLayout.createSequentialGroup().addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_DEPTHDepthStd, -2, -1, -2).addComponent(this.jLabel29)).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_DEPTHDepth, -2, -1, -2).addComponent(this.jLabel28, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_DEPTH_Pressure, -2, -1, -2).addComponent(this.jLabel30, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_DEPTHLatency, -2, -1, -2).addComponent(this.jLabel75, -2, -1, -2))).addGroup(jPanel_DEPTH_DatasLayout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel_DEPTH_DatasLayout.createSequentialGroup().addGroup(jPanel_DEPTH_DatasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel73).addComponent(jTextField_Depth_Temperature, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_Depth_SoundSpeed, -2, -1, -2)).addComponent(this.jLabel74)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jCheckBox_DEPTHValidity))))).addGap(5, 5, 5)));
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_DEPTH_Datas, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_DEPTH_Datas, -2, -1, -2).addContainerGap(353, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("Depth", this.jPanel13);
        jPanel_EMLog_Speeds.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Speeds", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel18.setText("Long Water Speed (m/s):");
        jTextField_LogEM_LongWaterSpeed.setHorizontalAlignment(0);
        jTextField_LogEM_LongWaterSpeed.setText("0.0");
        jTextField_LogEM_TransWaterSpeed.setHorizontalAlignment(0);
        jTextField_LogEM_TransWaterSpeed.setText("0.0");
        jTextField_LogEM_TransWaterSpeed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jTextField_LogEM_TransWaterSpeedActionPerformed(evt);
            }
        });
        this.jLabel19.setText("Trans Water Speed (m/s):");
        jTextField_LogEM_TransGroundSpeed.setHorizontalAlignment(0);
        jTextField_LogEM_TransGroundSpeed.setText("0.0");
        this.jLabel20.setText("Trans Ground Speed (m/s):");
        this.jLabel21.setText("Long Ground Speed (m/s):");
        jTextField_LogEM_LongGroundSpeed.setHorizontalAlignment(0);
        jTextField_LogEM_LongGroundSpeed.setText("0.0");
        jCheckBox_LochEmValidity.setText("Validity flag");
        jCheckBox_LochEmValidity.setAutoscrolls(true);
        this.jLabel97.setText("Long Water Speed Std (m/s):");
        jTextField_LogEM_LongWaterSpeedStd.setHorizontalAlignment(0);
        jTextField_LogEM_LongWaterSpeedStd.setText("0.0");
        GroupLayout jPanel_EMLog_SpeedsLayout = new GroupLayout(jPanel_EMLog_Speeds);
        jPanel_EMLog_Speeds.setLayout(jPanel_EMLog_SpeedsLayout);
        jPanel_EMLog_SpeedsLayout.setHorizontalGroup(jPanel_EMLog_SpeedsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_EMLog_SpeedsLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_EMLog_SpeedsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel97, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel19, -1, -1, Short.MAX_VALUE).addGroup(jPanel_EMLog_SpeedsLayout.createSequentialGroup().addComponent(this.jLabel18, -2, 173, -2).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel_EMLog_SpeedsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_EMLog_SpeedsLayout.createSequentialGroup().addGroup(jPanel_EMLog_SpeedsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_LogEM_TransWaterSpeed, -2, 72, -2).addComponent(jTextField_LogEM_LongWaterSpeed, -2, 72, -2)).addGap(55, 55, 55).addGroup(jPanel_EMLog_SpeedsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel20, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel21, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_EMLog_SpeedsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_LogEM_TransGroundSpeed, -2, 65, -2).addComponent(jTextField_LogEM_LongGroundSpeed, -2, 66, -2))).addGroup(jPanel_EMLog_SpeedsLayout.createSequentialGroup().addComponent(jTextField_LogEM_LongWaterSpeedStd, -2, 72, -2).addGap(370, 370, 370).addComponent(jCheckBox_LochEmValidity))).addContainerGap()));
        jPanel_EMLog_SpeedsLayout.setVerticalGroup(jPanel_EMLog_SpeedsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_EMLog_SpeedsLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_EMLog_SpeedsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_LogEM_LongWaterSpeed, -2, -1, -2).addComponent(this.jLabel21).addComponent(jTextField_LogEM_LongGroundSpeed, -2, -1, -2).addComponent(this.jLabel18)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_EMLog_SpeedsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_LogEM_TransWaterSpeed, -2, -1, -2).addComponent(this.jLabel20).addComponent(jTextField_LogEM_TransGroundSpeed, -2, -1, -2).addComponent(this.jLabel19)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_EMLog_SpeedsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_LogEM_LongWaterSpeedStd, -2, -1, -2).addComponent(this.jLabel97)).addContainerGap(22, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel_EMLog_SpeedsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(jCheckBox_LochEmValidity).addContainerGap()));
        jPanel_EMLog_Id.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor Id", 0, 0, new Font("Tahoma", 1, 11)));
        jComboBox_EMLOGId.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SimulatorFrame.this.jComboBox_EMLOGIdPopupMenuWillBecomeVisible(evt);
            }
        });
        jComboBox_EMLOGId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_EMLOGIdActionPerformed(evt);
            }
        });
        this.jLabel22.setText("EMLOG Id:");
        GroupLayout jPanel_EMLog_IdLayout = new GroupLayout(jPanel_EMLog_Id);
        jPanel_EMLog_Id.setLayout(jPanel_EMLog_IdLayout);
        jPanel_EMLog_IdLayout.setHorizontalGroup(jPanel_EMLog_IdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_EMLog_IdLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel22, -2, 65, -2).addGap(18, 18, 18).addComponent(jComboBox_EMLOGId, -2, 84, -2).addContainerGap(772, Short.MAX_VALUE)));
        jPanel_EMLog_IdLayout.setVerticalGroup(jPanel_EMLog_IdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_EMLog_IdLayout.createSequentialGroup().addGroup(jPanel_EMLog_IdLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel22).addComponent(jComboBox_EMLOGId, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel14Layout = new GroupLayout(this.jPanel14);
        this.jPanel14.setLayout(jPanel14Layout);
        jPanel14Layout.setHorizontalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addContainerGap().addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel_EMLog_Id, -1, -1, Short.MAX_VALUE).addComponent(jPanel_EMLog_Speeds, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel14Layout.setVerticalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_EMLog_Id, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel_EMLog_Speeds, -2, -1, -2).addContainerGap(286, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("EMLog", this.jPanel14);
        jPanel_CTD_Datas.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor datas", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel63.setText("Conductivity (S/m):");
        jTextField_CTDConductivity.setHorizontalAlignment(0);
        jTextField_CTDConductivity.setText("48.80");
        jTextField_CTDConductivity.setPreferredSize(new Dimension(24, 22));
        this.jLabel64.setText("Depth (m):");
        jTextField_CTDDepth.setHorizontalAlignment(0);
        jTextField_CTDDepth.setText("0.0");
        this.jLabel66.setText("Temperature (\u00b0C):");
        jTextField_CTDTemperature.setHorizontalAlignment(0);
        jTextField_CTDTemperature.setText("2.0");
        this.jLabel67.setText("Salinity (psu):");
        jTextField_CTDSalinity.setHorizontalAlignment(0);
        jTextField_CTDSalinity.setText("0.0");
        this.jLabel69.setText("Pressure (dBars):");
        jTextField_CTDPressure.setHorizontalAlignment(0);
        jTextField_CTDPressure.setText("0.0");
        this.jLabel70.setText("Sound velocity (m/s):");
        jTextField_CTDSoundSpeed.setHorizontalAlignment(0);
        jTextField_CTDSoundSpeed.setText("0.0");
        jCheckBox_CTDValidity.setText("Validity flag");
        jCheckBox_CTDValidity.setAutoscrolls(true);
        GroupLayout jPanel_CTD_DatasLayout = new GroupLayout(jPanel_CTD_Datas);
        jPanel_CTD_Datas.setLayout(jPanel_CTD_DatasLayout);
        jPanel_CTD_DatasLayout.setHorizontalGroup(jPanel_CTD_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_CTD_DatasLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_CTD_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel63).addGroup(jPanel_CTD_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel69, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel66, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_CTD_DatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jTextField_CTDTemperature, GroupLayout.Alignment.LEADING).addComponent(jTextField_CTDConductivity, GroupLayout.Alignment.LEADING, -1, 49, Short.MAX_VALUE).addComponent(jTextField_CTDPressure)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 265, Short.MAX_VALUE).addGroup(jPanel_CTD_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel64).addComponent(this.jLabel67).addComponent(this.jLabel70)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_CTD_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jTextField_CTDDepth, GroupLayout.Alignment.TRAILING).addComponent(jTextField_CTDSalinity, GroupLayout.Alignment.TRAILING, -1, 51, Short.MAX_VALUE).addComponent(jTextField_CTDSoundSpeed)).addGap(220, 220, 220).addComponent(jCheckBox_CTDValidity).addContainerGap()));
        jPanel_CTD_DatasLayout.setVerticalGroup(jPanel_CTD_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_CTD_DatasLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel_CTD_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel63).addComponent(this.jLabel64).addComponent(jTextField_CTDDepth, -2, -1, -2).addComponent(jTextField_CTDConductivity, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_CTD_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel66).addComponent(jTextField_CTDTemperature, -2, -1, -2).addComponent(this.jLabel67).addComponent(jTextField_CTDSalinity, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_CTD_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_CTD_DatasLayout.createSequentialGroup().addGroup(jPanel_CTD_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel69).addComponent(jTextField_CTDPressure, -2, -1, -2).addComponent(this.jLabel70).addComponent(jTextField_CTDSoundSpeed, -2, -1, -2)).addGap(32, 32, 32)).addGroup(GroupLayout.Alignment.TRAILING, jPanel_CTD_DatasLayout.createSequentialGroup().addComponent(jCheckBox_CTDValidity).addGap(21, 21, 21)))));
        GroupLayout jPanel15Layout = new GroupLayout(this.jPanel15);
        this.jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_CTD_Datas, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel15Layout.setVerticalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_CTD_Datas, -2, 123, -2).addContainerGap(376, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("CTD", this.jPanel15);
        jPanel_GRAVI_Datas.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor datas", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel77.setText("Deflection Xi (''):");
        jTextField_Gravi_Xi.setHorizontalAlignment(0);
        jTextField_Gravi_Xi.setText("0.1");
        this.jLabel79.setText("Deflection Yi (''):");
        jTextField_Gravi_Eta.setHorizontalAlignment(0);
        jTextField_Gravi_Eta.setText("0.2");
        this.jLabel81.setText("Norm Err (milliGal):");
        jTextField_Gravi_Norm.setHorizontalAlignment(0);
        jTextField_Gravi_Norm.setText("100");
        jCheckBox_GraviValidity.setText("Validity flag");
        jCheckBox_GraviValidity.setAutoscrolls(true);
        this.jLabel78.setText("Latitude (deg):");
        this.jLabel80.setText("Longitude (deg):");
        jTextField_Gravi_Long.setHorizontalAlignment(0);
        jTextField_Gravi_Long.setText("2.0");
        jTextField_Gravi_Lat.setHorizontalAlignment(0);
        jTextField_Gravi_Lat.setText("48.80");
        jTextField_Gravi_Lat.setPreferredSize(new Dimension(24, 22));
        GroupLayout jPanel_GRAVI_DatasLayout = new GroupLayout(jPanel_GRAVI_Datas);
        jPanel_GRAVI_Datas.setLayout(jPanel_GRAVI_DatasLayout);
        jPanel_GRAVI_DatasLayout.setHorizontalGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_GRAVI_DatasLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel78).addComponent(this.jLabel80, -1, 283, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jTextField_Gravi_Lat, -1, 80, Short.MAX_VALUE).addComponent(jTextField_Gravi_Long)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel77).addComponent(this.jLabel81, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel79, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jTextField_Gravi_Eta, GroupLayout.Alignment.LEADING).addComponent(jTextField_Gravi_Xi, GroupLayout.Alignment.LEADING).addComponent(jTextField_Gravi_Norm, GroupLayout.Alignment.LEADING, -2, 49, -2)).addGap(283, 283, 283).addComponent(jCheckBox_GraviValidity).addContainerGap()));
        jPanel_GRAVI_DatasLayout.setVerticalGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GRAVI_DatasLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GRAVI_DatasLayout.createSequentialGroup().addGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel78).addComponent(jTextField_Gravi_Lat, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel80).addComponent(jTextField_Gravi_Long, -2, -1, -2))).addGroup(jPanel_GRAVI_DatasLayout.createSequentialGroup().addGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel77).addComponent(jTextField_Gravi_Xi, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_Gravi_Eta, -2, -1, -2).addComponent(this.jLabel79)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GRAVI_DatasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel81).addComponent(jTextField_Gravi_Norm, -2, -1, -2).addComponent(jCheckBox_GraviValidity)))).addGap(7, 7, Short.MAX_VALUE)));
        GroupLayout jPanel19Layout = new GroupLayout(this.jPanel19);
        this.jPanel19.setLayout(jPanel19Layout);
        jPanel19Layout.setHorizontalGroup(jPanel19Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel19Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_GRAVI_Datas, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel19Layout.setVerticalGroup(jPanel19Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel19Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_GRAVI_Datas, -2, -1, -2).addContainerGap(375, Short.MAX_VALUE)));
        jPanel_GRAVI_Datas.getAccessibleContext().setAccessibleName("Gravimetry Datas");
        jTabbedPane_Main.addTab("DOV", this.jPanel19);
        jPanel_GRAVI_Datas1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor datas", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel85.setText("Position X (m):");
        jTextField_Platform_PosX.setHorizontalAlignment(0);
        jTextField_Platform_PosX.setText("0.0");
        this.jLabel87.setText("Position Y (m):");
        jTextField_Platform_PosY.setHorizontalAlignment(0);
        jTextField_Platform_PosY.setText("0.0");
        this.jLabel88.setText("Position Z (m):");
        jTextField_Platform_PosZ.setHorizontalAlignment(0);
        jTextField_Platform_PosZ.setText("0.0");
        this.jLabel86.setText("Orient X (deg):");
        jTextField_Platform_OrientX.setHorizontalAlignment(0);
        jTextField_Platform_OrientX.setText("0.0");
        jTextField_Platform_OrientY.setHorizontalAlignment(0);
        jTextField_Platform_OrientY.setText("0.0");
        this.jLabel89.setText("Orient Y (deg):");
        this.jLabel90.setText("Orient Z (deg):");
        jTextField_Platform_OrientZ.setHorizontalAlignment(0);
        jTextField_Platform_OrientZ.setText("0.0");
        this.jLabel82.setText("Status:");
        jTextField_Platform_Status.setHorizontalAlignment(0);
        jTextField_Platform_Status.setText("0000");
        jTextField_Platform_Status.setPreferredSize(new Dimension(24, 22));
        GroupLayout jPanel_GRAVI_Datas1Layout = new GroupLayout(jPanel_GRAVI_Datas1);
        jPanel_GRAVI_Datas1.setLayout(jPanel_GRAVI_Datas1Layout);
        jPanel_GRAVI_Datas1Layout.setHorizontalGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GRAVI_Datas1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel87).addComponent(this.jLabel85).addComponent(this.jLabel88)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jTextField_Platform_PosY, GroupLayout.Alignment.LEADING).addComponent(jTextField_Platform_PosX, GroupLayout.Alignment.LEADING, -1, 62, Short.MAX_VALUE).addComponent(jTextField_Platform_PosZ)).addGap(79, 79, 79).addGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel86).addComponent(this.jLabel89).addComponent(this.jLabel90)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jTextField_Platform_OrientY).addComponent(jTextField_Platform_OrientX).addComponent(jTextField_Platform_OrientZ, -2, 57, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 270, Short.MAX_VALUE).addComponent(this.jLabel82, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_Platform_Status, -2, 55, -2).addGap(162, 162, 162)));
        jPanel_GRAVI_Datas1Layout.setVerticalGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GRAVI_Datas1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GRAVI_Datas1Layout.createSequentialGroup().addGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel85).addComponent(jTextField_Platform_PosX, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel87).addComponent(jTextField_Platform_PosY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel88).addComponent(jTextField_Platform_PosZ, -2, -1, -2))).addGroup(jPanel_GRAVI_Datas1Layout.createSequentialGroup().addGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel86).addComponent(jTextField_Platform_OrientX, -2, -1, -2).addComponent(this.jLabel82).addComponent(jTextField_Platform_Status, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel89).addComponent(jTextField_Platform_OrientY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GRAVI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel90).addComponent(jTextField_Platform_OrientZ, -2, -1, -2)))).addContainerGap(22, Short.MAX_VALUE)));
        GroupLayout jPanel20Layout = new GroupLayout(this.jPanel20);
        this.jPanel20.setLayout(jPanel20Layout);
        jPanel20Layout.setHorizontalGroup(jPanel20Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel20Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_GRAVI_Datas1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel20Layout.setVerticalGroup(jPanel20Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel20Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_GRAVI_Datas1, -2, -1, -2).addContainerGap(362, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("Platform", this.jPanel20);
        jPanel_DMI_Datas.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor datas", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel98.setText("Pulse count :");
        jTextField_DMIPulseCount.setHorizontalAlignment(0);
        jTextField_DMIPulseCount.setText("145");
        jTextField_DMIPulseCount.setPreferredSize(new Dimension(24, 22));
        jCheckBox_DMIValidity.setText("Validity flag");
        jCheckBox_DMIValidity.setAutoscrolls(true);
        GroupLayout jPanel_DMI_DatasLayout = new GroupLayout(jPanel_DMI_Datas);
        jPanel_DMI_Datas.setLayout(jPanel_DMI_DatasLayout);
        jPanel_DMI_DatasLayout.setHorizontalGroup(jPanel_DMI_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_DMI_DatasLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel98).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_DMIPulseCount, -2, 49, -2).addGap(44, 44, 44).addComponent(jCheckBox_DMIValidity).addContainerGap(672, Short.MAX_VALUE)));
        jPanel_DMI_DatasLayout.setVerticalGroup(jPanel_DMI_DatasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DMI_DatasLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel_DMI_DatasLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel98).addComponent(jTextField_DMIPulseCount, -2, -1, -2).addComponent(jCheckBox_DMIValidity)).addGap(83, 83, 83)));
        GroupLayout jPanel21Layout = new GroupLayout(this.jPanel21);
        this.jPanel21.setLayout(jPanel21Layout);
        jPanel21Layout.setHorizontalGroup(jPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel21Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_DMI_Datas, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel21Layout.setVerticalGroup(jPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel21Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_DMI_Datas, -2, 77, -2).addContainerGap(422, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("DMI", this.jPanel21);
        jPanel_DMI_Datas1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sensor datas", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel101.setText("Heading (deg):");
        jTextField_StimHeading.setHorizontalAlignment(0);
        jTextField_StimHeading.setText("0");
        jTextField_StimHeading.setPreferredSize(new Dimension(24, 22));
        this.jLabel104.setText("Latitude (deg):");
        this.jLabel105.setText("Longitude (deg):");
        jTextField_StimLongitude.setHorizontalAlignment(0);
        jTextField_StimLongitude.setText("2.0");
        jTextField_StimLatitude.setHorizontalAlignment(0);
        jTextField_StimLatitude.setText("48.80");
        jTextField_StimLatitude.setPreferredSize(new Dimension(24, 22));
        this.jLabel106.setText("Roll (deg):");
        jTextField_StimRoll.setHorizontalAlignment(0);
        jTextField_StimRoll.setText("0");
        jTextField_StimRoll.setPreferredSize(new Dimension(24, 22));
        this.jLabel107.setText("Pitch (deg):");
        jTextField_StimPitch.setHorizontalAlignment(0);
        jTextField_StimPitch.setText("0");
        jTextField_StimPitch.setPreferredSize(new Dimension(24, 22));
        this.jLabel108.setText("Altitude (m):");
        jTextField_StimAltitude.setHorizontalAlignment(0);
        jTextField_StimAltitude.setText("0");
        this.jLabel109.setText("Acc X (m/s\u00b2):");
        jTextField_StimAccelX.setHorizontalAlignment(0);
        jTextField_StimAccelX.setText("0");
        jTextField_StimAccelX.setPreferredSize(new Dimension(24, 22));
        this.jLabel110.setText("Acc Y (m/s\u00b2):");
        jTextField_StimAccelY.setHorizontalAlignment(0);
        jTextField_StimAccelY.setText("0");
        jTextField_StimAccelY.setPreferredSize(new Dimension(24, 22));
        this.jLabel111.setText("Acc Z (m/s\u00b2):");
        jTextField_StimAccelZ.setHorizontalAlignment(0);
        jTextField_StimAccelZ.setText("0");
        jTextField_StimAccelZ.setPreferredSize(new Dimension(24, 22));
        this.jLabel112.setText("Rotation rate Z (deg/s):");
        jTextField_StimRotRateZ.setHorizontalAlignment(0);
        jTextField_StimRotRateZ.setText("0");
        jTextField_StimRotRateY.setHorizontalAlignment(0);
        jTextField_StimRotRateY.setText("0");
        this.jLabel113.setText("Rotation rate Y (deg/s):");
        this.jLabel114.setText("Rotation rate X (deg/s):");
        jTextField_StimRotRateX.setHorizontalAlignment(0);
        jTextField_StimRotRateX.setText("0");
        jTextField_StimRotRateX.setPreferredSize(new Dimension(24, 22));
        this.jLabel115.setText("Speed North (m/s):");
        this.jLabel116.setText("Speed East (m/s):");
        this.jLabel117.setText("Speed Up (m/s):");
        jTextField_StimSpeedUp.setHorizontalAlignment(0);
        jTextField_StimSpeedUp.setText("0");
        jTextField_StimSpeedUp.setPreferredSize(new Dimension(24, 22));
        jTextField_StimSpeedEast.setHorizontalAlignment(0);
        jTextField_StimSpeedEast.setText("0");
        jTextField_StimSpeedEast.setPreferredSize(new Dimension(24, 22));
        jTextField_StimSpeedNorth.setHorizontalAlignment(0);
        jTextField_StimSpeedNorth.setText("0");
        jTextField_StimSpeedNorth.setPreferredSize(new Dimension(24, 22));
        jTextField_StimSpeedNorth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jTextField_StimSpeedNorthActionPerformed(evt);
            }
        });
        jCheckBoxActivateSimStim.setText("Activate Simulator / Stimulator");
        this.jLabel118.setText("Altitude reference");
        jTextField_StimAltiRef.setHorizontalAlignment(0);
        jTextField_StimAltiRef.setText("0");
        jTextField_StimAltiRef.setPreferredSize(new Dimension(24, 22));
        GroupLayout jPanel_DMI_Datas1Layout = new GroupLayout(jPanel_DMI_Datas1);
        jPanel_DMI_Datas1.setLayout(jPanel_DMI_Datas1Layout);
        jPanel_DMI_Datas1Layout.setHorizontalGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addComponent(jCheckBoxActivateSimStim).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel107, -1, 316, Short.MAX_VALUE).addComponent(this.jLabel106, -1, -1, Short.MAX_VALUE)).addGap(101, 101, 101)).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel110, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel109, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel111, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_StimAccelY, -2, 49, -2).addComponent(jTextField_StimAccelX, -2, 49, -2).addComponent(jTextField_StimAccelZ, -2, 49, -2))).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addComponent(this.jLabel101).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_StimRoll, -2, 49, -2).addComponent(jTextField_StimHeading, -2, 49, -2).addComponent(jTextField_StimPitch, -2, 49, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel108, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel105, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel104, -2, 98, -2)).addComponent(this.jLabel114).addComponent(this.jLabel113, -2, 137, -2).addComponent(this.jLabel112, -2, 137, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_StimRotRateY, -2, 80, -2).addComponent(jTextField_StimRotRateZ, -2, 80, -2).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_StimLongitude, -2, 80, -2).addComponent(jTextField_StimLatitude, -2, 80, -2).addComponent(jTextField_StimAltitude, GroupLayout.Alignment.TRAILING, -2, 80, -2)).addComponent(jTextField_StimRotRateX, -2, 80, -2)).addGap(59, 59, 59).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addComponent(this.jLabel115).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_StimSpeedNorth, -2, 49, -2)).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel117, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel116, GroupLayout.Alignment.LEADING, -1, 112, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_StimSpeedEast, -2, 49, -2).addComponent(jTextField_StimSpeedUp, -2, 49, -2))).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addComponent(this.jLabel118, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTextField_StimAltiRef, -2, 49, -2))).addGap(68, 68, 68)))));
        jPanel_DMI_Datas1Layout.setVerticalGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel104).addComponent(jTextField_StimLatitude, -2, -1, -2).addComponent(this.jLabel115).addComponent(jTextField_StimSpeedNorth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel105).addComponent(jTextField_StimLongitude, -2, -1, -2).addComponent(this.jLabel116).addComponent(jTextField_StimSpeedEast, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel108).addComponent(jTextField_StimAltitude, -2, -1, -2).addComponent(this.jLabel117).addComponent(jTextField_StimSpeedUp, -2, -1, -2)).addGap(28, 28, 28).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel118).addComponent(jTextField_StimAltiRef, -2, -1, -2)).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel114).addComponent(jTextField_StimRotRateX, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel113).addComponent(jTextField_StimRotRateY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField_StimRotRateZ, -2, -1, -2).addComponent(this.jLabel112))).addGroup(jPanel_DMI_Datas1Layout.createSequentialGroup().addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel101).addComponent(jTextField_StimHeading, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel106).addComponent(jTextField_StimRoll, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel107).addComponent(jTextField_StimPitch, -2, -1, -2)).addGap(28, 28, 28).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel109).addComponent(jTextField_StimAccelX, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_StimAccelY, -2, -1, -2).addComponent(this.jLabel110)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_DMI_Datas1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jTextField_StimAccelZ, -2, -1, -2).addComponent(this.jLabel111)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 55, Short.MAX_VALUE).addComponent(jCheckBoxActivateSimStim)));
        GroupLayout jPanel25Layout = new GroupLayout(this.jPanel25);
        this.jPanel25.setLayout(jPanel25Layout);
        jPanel25Layout.setHorizontalGroup(jPanel25Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel25Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_DMI_Datas1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel25Layout.setVerticalGroup(jPanel25Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel25Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_DMI_Datas1, -2, -1, -2).addContainerGap(196, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("SIMSTIM", this.jPanel25);
        jPanel4.setPreferredSize(new Dimension(768, 700));
        jPanel_Info.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Ouputs Info", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel_Info1.setText("Output 1:");
        this.jLabel_Info2.setText("Output 3:");
        this.jLabel_Info3.setText("Output 4:");
        this.jLabel_Info4.setText("Output 5:");
        jLabel_InfoOuput1.setText("[none]");
        jLabel_InfoOuput3.setText("[none]");
        jLabel_InfoOuput4.setText("[none]");
        this.jLabel_Info5.setText("Output 2:");
        jLabel_InfoOuput2.setText("[none]");
        jLabel_InfoOuput5.setText("[none]");
        GroupLayout jPanel_ChevronLayout = new GroupLayout(jPanel_Chevron);
        jPanel_Chevron.setLayout(jPanel_ChevronLayout);
        jPanel_ChevronLayout.setHorizontalGroup(jPanel_ChevronLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 76, Short.MAX_VALUE));
        jPanel_ChevronLayout.setVerticalGroup(jPanel_ChevronLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 69, Short.MAX_VALUE));
        jLabel_InfoOuputInterface1.setText("[none]");
        jLabel_InfoOuputInterface2.setText("[none]");
        jLabel_InfoOuputInterface3.setText("[none]");
        jLabel_InfoOuputInterface4.setText("[none]");
        jLabel_InfoOuputInterface5.setText("[none]");
        this.jLabel1.setText("-");
        this.jLabel2.setText("-");
        this.jLabel3.setText("-");
        this.jLabel4.setText("-");
        this.jLabel5.setText("-");
        jLabel_DisplayTime.setFont(new Font("Tahoma", 1, 11));
        jLabel_DisplayTime.setHorizontalAlignment(0);
        jLabel_DisplayTime.setText("00/00/00 - 00:00:00");
        this.jLabel_Info11.setText("Output 6:");
        jLabel_InfoOuput6.setText("[none]");
        this.jLabel102.setText("-");
        jLabel_InfoOuputInterface6.setText("[none]");
        this.jLabel_Info12.setText("Output 7:");
        jLabel_InfoOuput7.setText("[none]");
        this.jLabel103.setText("-");
        jLabel_InfoOuputInterface7.setText("[none]");
        GroupLayout jPanel_InfoLayout = new GroupLayout(jPanel_Info);
        jPanel_Info.setLayout(jPanel_InfoLayout);
        jPanel_InfoLayout.setHorizontalGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_InfoLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel_Info12, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info11, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info1, -1, -1, Short.MAX_VALUE)).addGap(23, 23, 23).addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jLabel_InfoOuput7, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoOuput6, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoOuput5, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoOuput4, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoOuput3, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoOuput2, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoOuput1, -1, 141, Short.MAX_VALUE)).addGap(35, 35, 35).addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel_InfoLayout.createSequentialGroup().addComponent(this.jLabel103, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel_InfoOuputInterface7, -1, 260, Short.MAX_VALUE)).addGroup(jPanel_InfoLayout.createSequentialGroup().addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -2, 9, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jLabel_InfoOuputInterface5, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoOuputInterface4, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoOuputInterface3, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoOuputInterface2, -1, -1, Short.MAX_VALUE).addComponent(jLabel_InfoOuputInterface1, -1, 260, Short.MAX_VALUE))).addGroup(jPanel_InfoLayout.createSequentialGroup().addComponent(this.jLabel102, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel_InfoOuputInterface6, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 254, Short.MAX_VALUE).addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel_DisplayTime).addGroup(jPanel_InfoLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(jPanel_Chevron, -2, -1, -2))).addGap(38, 38, 38)));
        jPanel_InfoLayout.setVerticalGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_InfoLayout.createSequentialGroup().addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_InfoLayout.createSequentialGroup().addComponent(jLabel_DisplayTime).addGap(18, 18, 18).addComponent(jPanel_Chevron, -2, -1, -2)).addGroup(jPanel_InfoLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_InfoLayout.createSequentialGroup().addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_InfoLayout.createSequentialGroup().addComponent(this.jLabel_Info1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_Info5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_Info2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_Info3)).addGroup(jPanel_InfoLayout.createSequentialGroup().addComponent(jLabel_InfoOuput1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_InfoOuput2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_InfoOuput3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_InfoOuput4))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Info4).addComponent(jLabel_InfoOuput5))).addGroup(jPanel_InfoLayout.createSequentialGroup().addComponent(jLabel_InfoOuputInterface1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_InfoOuputInterface2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_InfoOuputInterface3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_InfoOuputInterface4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_InfoOuputInterface5)).addGroup(jPanel_InfoLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel5))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Info11).addComponent(jLabel_InfoOuput6)).addComponent(jLabel_InfoOuputInterface6).addComponent(this.jLabel102)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_InfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Info12).addComponent(jLabel_InfoOuput7)).addComponent(jLabel_InfoOuputInterface7).addComponent(this.jLabel103)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Outputs State", 0, 0, new Font("Tahoma", 1, 11)));
        jPanel_Voyants.setPreferredSize(new Dimension(16, 16));
        GroupLayout jPanel_VoyantsLayout = new GroupLayout(jPanel_Voyants);
        jPanel_Voyants.setLayout(jPanel_VoyantsLayout);
        jPanel_VoyantsLayout.setHorizontalGroup(jPanel_VoyantsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        jPanel_VoyantsLayout.setVerticalGroup(jPanel_VoyantsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jLabel_Info6.setText("Output 5:");
        this.jLabel_Info7.setText("Output 4:");
        this.jLabel_Info8.setText("Output 3:");
        this.jLabel_Info9.setText("Output 2:");
        this.jLabel_Info10.setText("Output 1:");
        jLabel_Output2State.setText("Idle");
        jLabel_Output1State.setText("Idle");
        jLabel_Output3State.setText("Idle");
        jLabel_Output5State.setText("Idle");
        jLabel_Output4State.setText("Idle");
        this.jLabel_Info13.setText("Output 6:");
        jLabel_Output6State.setText("Idle");
        this.jLabel_Info14.setText("Output 7:");
        jLabel_Output7State.setText("Idle");
        GroupLayout jPanel9Layout = new GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel_Info14, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info13, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info10, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info7, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_Info9, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addGap(26, 26, 26).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel_Output2State, -1, 569, Short.MAX_VALUE).addComponent(jLabel_Output3State, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Output4State, -1, -1, Short.MAX_VALUE).addGroup(jPanel9Layout.createSequentialGroup().addComponent(jLabel_Output1State, -2, 284, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(jLabel_Output5State, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Output7State, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Output6State, -1, -1, Short.MAX_VALUE)).addGap(26, 26, 26).addComponent(jPanel_Voyants, -2, 23, -2).addGap(31, 31, 31)));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel_Voyants, -1, 154, Short.MAX_VALUE).addGroup(jPanel9Layout.createSequentialGroup().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel_Info10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_Info9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_Info8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_Info7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_Info6)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(jLabel_Output1State).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(jLabel_Output3State)).addComponent(jLabel_Output2State)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_Output4State).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_Output5State))).addGap(7, 7, 7).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Info13).addComponent(jLabel_Output6State)).addGap(7, 7, 7).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Info14).addComponent(jLabel_Output7State)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Connection", 0, 0, new Font("Tahoma", 1, 11)));
        jButton_ConnectOutput1.setText("Connect");
        jButton_ConnectOutput1.setMargin(new Insets(1, 10, 1, 10));
        jButton_ConnectOutput1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton_ConnectOutput1ActionPerformed(evt);
            }
        });
        jButton_ConnectOutput2.setText("Connect");
        jButton_ConnectOutput2.setMargin(new Insets(1, 10, 1, 10));
        jButton_ConnectOutput2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton_ConnectOutput2ActionPerformed(evt);
            }
        });
        jButton_ConnectOutput3.setText("Connect");
        jButton_ConnectOutput3.setMargin(new Insets(1, 10, 1, 10));
        jButton_ConnectOutput3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton_ConnectOutput3ActionPerformed(evt);
            }
        });
        jButton_ConnectOutput5.setText("Connect");
        jButton_ConnectOutput5.setMargin(new Insets(1, 10, 1, 10));
        jButton_ConnectOutput5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton_ConnectOutput5ActionPerformed(evt);
            }
        });
        jButton_ConnectOutput4.setText("Connect");
        jButton_ConnectOutput4.setMargin(new Insets(1, 10, 1, 10));
        jButton_ConnectOutput4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton_ConnectOutput4ActionPerformed(evt);
            }
        });
        jButton_ConnectOutput6.setText("Connect");
        jButton_ConnectOutput6.setMargin(new Insets(1, 10, 1, 10));
        jButton_ConnectOutput6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton_ConnectOutput6ActionPerformed(evt);
            }
        });
        jButton_ConnectOutput7.setText("Connect");
        jButton_ConnectOutput7.setMargin(new Insets(1, 10, 1, 10));
        jButton_ConnectOutput7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton_ConnectOutput7ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(24, 24, 24).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jButton_ConnectOutput7, -2, 144, -2).addComponent(jButton_ConnectOutput6, -2, 144, -2).addComponent(jButton_ConnectOutput1, -2, 144, -2).addComponent(jButton_ConnectOutput2, -2, 144, -2).addComponent(jButton_ConnectOutput3, -2, 144, -2).addComponent(jButton_ConnectOutput4, -2, 144, -2).addComponent(jButton_ConnectOutput5, -2, 144, -2)).addContainerGap(23, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(jButton_ConnectOutput1, -2, 16, -2).addGap(7, 7, 7).addComponent(jButton_ConnectOutput2, -2, 16, -2).addGap(7, 7, 7).addComponent(jButton_ConnectOutput3, -2, 16, -2).addGap(7, 7, 7).addComponent(jButton_ConnectOutput4, -2, 16, -2).addGap(7, 7, 7).addComponent(jButton_ConnectOutput5, -2, 16, -2).addGap(7, 7, 7).addComponent(jButton_ConnectOutput6, -2, 16, -2).addGap(7, 7, 7).addComponent(jButton_ConnectOutput7, -2, 16, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jButton_ConnectOutput1.getAccessibleContext().setAccessibleName("Connect All");
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel_Info, -1, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(jPanel9, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(jPanel_Info, -2, 193, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jPanel9, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap(97, Short.MAX_VALUE)));
        jTabbedPane_Main.addTab("Control", jPanel4);
        this.jPanel17.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Datas", 0, 0, new Font("Tahoma", 1, 11)));
        jTextArea_OutputDisplay.setColumns(20);
        jTextArea_OutputDisplay.setEditable(false);
        jTextArea_OutputDisplay.setFont(new Font("Tahoma", 0, 11));
        jTextArea_OutputDisplay.setRows(5);
        this.jScrollPane1.setViewportView(jTextArea_OutputDisplay);
        GroupLayout jPanel17Layout = new GroupLayout(this.jPanel17);
        this.jPanel17.setLayout(jPanel17Layout);
        jPanel17Layout.setHorizontalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel17Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 927, Short.MAX_VALUE).addContainerGap()));
        jPanel17Layout.setVerticalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel17Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 358, Short.MAX_VALUE).addContainerGap()));
        this.jPanel18.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Selection", 0, 0, new Font("Tahoma", 1, 11)));
        jLabel_OutputId1.setText("Output:");
        jComboBox_OutputDisplayId.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SimulatorFrame.this.jComboBox_OutputDisplayIdPopupMenuWillBecomeVisible(evt);
            }
        });
        jComboBox_OutputDisplayId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jComboBox_OutputDisplayIdActionPerformed(evt);
            }
        });
        jToggleButton_StartDisplay.setText("Enable");
        jToggleButton_StartDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jToggleButton_StartDisplayActionPerformed(evt);
            }
        });
        jButton_InitDisplay.setText("Init");
        jButton_InitDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jButton_InitDisplayActionPerformed(evt);
            }
        });
        GroupLayout jPanel18Layout = new GroupLayout(this.jPanel18);
        this.jPanel18.setLayout(jPanel18Layout);
        jPanel18Layout.setHorizontalGroup(jPanel18Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel18Layout.createSequentialGroup().addContainerGap().addComponent(jLabel_OutputId1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jComboBox_OutputDisplayId, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 525, Short.MAX_VALUE).addComponent(jToggleButton_StartDisplay, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton_InitDisplay, -2, 117, -2).addContainerGap()));
        jPanel18Layout.setVerticalGroup(jPanel18Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel18Layout.createSequentialGroup().addContainerGap().addGroup(jPanel18Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel_OutputId1).addComponent(jComboBox_OutputDisplayId, -2, -1, -2).addComponent(jToggleButton_StartDisplay).addComponent(jButton_InitDisplay)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel16Layout = new GroupLayout(this.jPanel16);
        this.jPanel16.setLayout(jPanel16Layout);
        jPanel16Layout.setHorizontalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel16Layout.createSequentialGroup().addContainerGap().addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel17, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel18, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel16Layout.setVerticalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel16Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel18, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel17, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jTabbedPane_Main.addTab("Display", this.jPanel16);
        this.jPanel23.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Scrambling Option", 0, 0, new Font("Tahoma", 1, 11)));
        jCheckBox_Scramble_ReplaceChar.setText("Replace characters randomly");
        jCheckBox_Scramble_ReplaceChar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jCheckBox_Scramble_ActionPerformed(evt);
            }
        });
        jCheckBox_Scramble_SuppressChar.setText("Suppress characters randomly");
        jCheckBox_Scramble_SuppressChar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jCheckBox_Scramble_ActionPerformed(evt);
            }
        });
        jCheckBox_Scramble_AddChar.setText("Add characters randomly");
        jCheckBox_Scramble_AddChar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jCheckBox_Scramble_ActionPerformed(evt);
            }
        });
        jCheckBox_Scramble_SuppressField.setText("Suppress fields randomly");
        jCheckBox_Scramble_SuppressField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jCheckBox_Scramble_ActionPerformed(evt);
            }
        });
        jCheckBox_Scramble_AddField.setText("Add fields randomly");
        jCheckBox_Scramble_AddField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorFrame.this.jCheckBox_Scramble_ActionPerformed(evt);
            }
        });
        jSlider_Scramble_ReplaceChar.setMaximum(3);
        jSlider_Scramble_ReplaceChar.setMinimum(1);
        jSlider_Scramble_ReplaceChar.setValue(1);
        jSlider_Scramble_ReplaceChar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimulatorFrame.this.jSlider_Scramble_StateChanged(evt);
            }
        });
        jLabel_Scramble_ReplaceChar_Nb.setText("1");
        jLabel_Scramble_ReplaceChar_Label.setText("character(s)");
        jSlider_Scramble_SuppressChar.setMaximum(3);
        jSlider_Scramble_SuppressChar.setMinimum(1);
        jSlider_Scramble_SuppressChar.setValue(1);
        jSlider_Scramble_SuppressChar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimulatorFrame.this.jSlider_Scramble_StateChanged(evt);
            }
        });
        jLabel_Scramble_SuppressChar_Nb.setText("1");
        jLabel_Scramble_SuppressChar_Label.setText("character(s)");
        jSlider_Scramble_AddChar.setMaximum(3);
        jSlider_Scramble_AddChar.setMinimum(1);
        jSlider_Scramble_AddChar.setValue(1);
        jSlider_Scramble_AddChar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimulatorFrame.this.jSlider_Scramble_StateChanged(evt);
            }
        });
        jLabel_Scramble_AddChar_Nb.setText("1");
        jLabel_Scramble_AddChar_Label.setText("character(s)");
        jSlider_Scramble_SuppressField.setMaximum(3);
        jSlider_Scramble_SuppressField.setMinimum(1);
        jSlider_Scramble_SuppressField.setValue(1);
        jSlider_Scramble_SuppressField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimulatorFrame.this.jSlider_Scramble_StateChanged(evt);
            }
        });
        jLabel_Scramble_SuppressField_Nb.setText("1");
        jLabel_Scramble_SuppressField_Label.setText("field(s)");
        jSlider_Scramble_AddField.setMaximum(3);
        jSlider_Scramble_AddField.setMinimum(1);
        jSlider_Scramble_AddField.setValue(1);
        jSlider_Scramble_AddField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimulatorFrame.this.jSlider_Scramble_StateChanged(evt);
            }
        });
        jLabel_Scramble_AddField_Nb.setText("1");
        jLabel_Scramble_AddField_Label.setText("field(s)");
        GroupLayout jPanel23Layout = new GroupLayout(this.jPanel23);
        this.jPanel23.setLayout(jPanel23Layout);
        jPanel23Layout.setHorizontalGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel23Layout.createSequentialGroup().addContainerGap().addGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel23Layout.createSequentialGroup().addComponent(jCheckBox_Scramble_ReplaceChar, -2, 223, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jSlider_Scramble_ReplaceChar, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel_Scramble_ReplaceChar_Nb, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_Scramble_ReplaceChar_Label)).addGroup(jPanel23Layout.createSequentialGroup().addComponent(jCheckBox_Scramble_SuppressChar, -2, 223, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jSlider_Scramble_SuppressChar, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel_Scramble_SuppressChar_Nb, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_Scramble_SuppressChar_Label)).addGroup(jPanel23Layout.createSequentialGroup().addComponent(jCheckBox_Scramble_AddChar, -2, 223, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jSlider_Scramble_AddChar, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel_Scramble_AddChar_Nb, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_Scramble_AddChar_Label)).addGroup(jPanel23Layout.createSequentialGroup().addComponent(jCheckBox_Scramble_SuppressField, -2, 223, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jSlider_Scramble_SuppressField, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel_Scramble_SuppressField_Nb, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_Scramble_SuppressField_Label)).addGroup(jPanel23Layout.createSequentialGroup().addComponent(jCheckBox_Scramble_AddField, -2, 223, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jSlider_Scramble_AddField, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel_Scramble_AddField_Nb, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel_Scramble_AddField_Label))).addContainerGap(529, Short.MAX_VALUE)));
        jPanel23Layout.setVerticalGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel23Layout.createSequentialGroup().addContainerGap().addGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel23Layout.createSequentialGroup().addGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel23Layout.createSequentialGroup().addGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel23Layout.createSequentialGroup().addGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jCheckBox_Scramble_ReplaceChar, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(jSlider_Scramble_ReplaceChar, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Scramble_ReplaceChar_Nb, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Scramble_ReplaceChar_Label, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jCheckBox_Scramble_SuppressChar)).addGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jSlider_Scramble_SuppressChar, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Scramble_SuppressChar_Nb, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Scramble_SuppressChar_Label, -2, 23, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jCheckBox_Scramble_AddChar)).addGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jSlider_Scramble_AddChar, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Scramble_AddChar_Nb, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Scramble_AddChar_Label, -2, 23, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jCheckBox_Scramble_SuppressField)).addGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jSlider_Scramble_SuppressField, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Scramble_SuppressField_Nb, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Scramble_SuppressField_Label, -2, 23, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jCheckBox_Scramble_AddField).addGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jSlider_Scramble_AddField, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Scramble_AddField_Nb, -1, -1, Short.MAX_VALUE).addComponent(jLabel_Scramble_AddField_Label, -2, 23, -2))).addContainerGap(294, Short.MAX_VALUE)));
        GroupLayout jPanel22Layout = new GroupLayout(this.jPanel22);
        this.jPanel22.setLayout(jPanel22Layout);
        jPanel22Layout.setHorizontalGroup(jPanel22Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel22Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel23, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel22Layout.setVerticalGroup(jPanel22Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel22Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel23, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jTabbedPane_Main.addTab("Scrambling", this.jPanel22);
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(jTabbedPane_Main).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(jTabbedPane_Main, -1, 540, Short.MAX_VALUE).addContainerGap()));
        jTabbedPane_Main.getAccessibleContext().setAccessibleName("  Speed Input  ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel7, -1, 1016, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel7, -1, 566, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jTabbedPane_MainStateChanged(ChangeEvent evt) {
        if (this.isVisible()) {
            this.UpdateOutputParametersInfos();
            this.UpdateProtocolsParamsInfos();
            this.Update_OutputParam_Visibility();
            this.UpdateControlPanel();
            switch (this.PaneIndexPrec) {
                case 2: {
                    this.Update_GPS_Infos();
                    break;
                }
                case 3: {
                    this.Update_DVL_Infos();
                    break;
                }
                case 4: {
                    this.Update_DVL_NTK_Infos();
                    break;
                }
                case 6: {
                    this.Update_LBL_Infos();
                    break;
                }
                case 5: {
                    this.Update_USBL_Infos();
                    break;
                }
                case 8: {
                    this.Update_EMLOG_Infos();
                    break;
                }
                case 7: {
                    this.Update_DEPTH_Infos();
                    break;
                }
                case 9: {
                    this.Update_CTD_Infos();
                    break;
                }
                case 12: {
                    this.Update_DMI_Infos();
                    break;
                }
                case 10: {
                    this.Update_GRAVI_Infos();
                    break;
                }
                case 11: {
                    this.Update_PLATFORM_Infos();
                    break;
                }
                case 13: {
                    this.Update_SIMSTIM_Infos();
                    break;
                }
            }
            switch (jTabbedPane_Main.getSelectedIndex()) {
                case 2: {
                    this.Update_GPS_Panel();
                    break;
                }
                case 3: {
                    this.Update_DVL_Panel();
                    break;
                }
                case 4: {
                    this.Update_DVL_NTK_Panel();
                    break;
                }
                case 6: {
                    this.Update_LBL_Panel();
                    break;
                }
                case 5: {
                    this.Update_USBL_Panel();
                    break;
                }
                case 8: {
                    this.Update_EMLOG_Panel();
                    break;
                }
                case 7: {
                    this.Update_DEPTH_Panel();
                    break;
                }
                case 9: {
                    this.Update_CTD_Panel();
                    break;
                }
                case 12: {
                    this.Update_DMI_Panel();
                    break;
                }
                case 10: {
                    this.Update_GRAVI_Panel();
                    break;
                }
                case 11: {
                    this.Update_PLATFORM_Panel();
                    break;
                }
                case 1: {
                    this.UpdateProtocolsParamsPanel();
                    break;
                }
                case 0: {
                    this.UpdateOutputParametersPanel();
                    break;
                }
                case 13: {
                    this.Update_SIMSTIM_Panel();
                    break;
                }
            }
        }
        this.PaneIndexPrec = jTabbedPane_Main.getSelectedIndex();
    }

    private void jButton_ConnectOutput1ActionPerformed(ActionEvent evt) {
        this.Connect_Disconnect(0);
    }

    private void jComboBox_EthConnectionTypeActionPerformed(ActionEvent evt) {
        this.Update_OutputParam_Visibility();
    }

    private void jComboBox_OuputIdActionPerformed(ActionEvent evt) {
        if (!this.IsInitialized.booleanValue()) {
            return;
        }
        this.UpdateOutputParametersPanel();
        this.Update_OutputParam_Visibility();
    }

    private void jComboBox_OutputConnTypeActionPerformed(ActionEvent evt) {
        this.Update_OutputParam_Visibility();
    }

    private void jComboBox_OuputIdPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.UpdateOutputParametersInfos();
    }

    private void jComboBox_ProtocolParams_OutputIdActionPerformed(ActionEvent evt) {
        this.UpdateProtocolsParamsPanel();
    }

    private void jComboBox_ProtocolParams_OutputIdPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.UpdateProtocolsParamsInfos();
    }

    private void jButton_ConnectOutput2ActionPerformed(ActionEvent evt) {
        this.Connect_Disconnect(1);
    }

    private void jButton_ConnectOutput3ActionPerformed(ActionEvent evt) {
        this.Connect_Disconnect(2);
    }

    private void jButton_ConnectOutput5ActionPerformed(ActionEvent evt) {
        this.Connect_Disconnect(4);
    }

    private void jButton_ConnectOutput4ActionPerformed(ActionEvent evt) {
        this.Connect_Disconnect(3);
    }

    private void jComboBox_OutputProtoActionPerformed(ActionEvent evt) {
        this.Update_OutputParam_Visibility();
    }

    private void jComboBox_GPSIdActionPerformed(ActionEvent evt) {
        this.Update_GPS_Panel();
    }

    private void jComboBox_GPSIdPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.Update_GPS_Infos();
    }

    private void jComboBox_USBLIdPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.Update_USBL_Infos();
    }

    private void jComboBox_USBLIdActionPerformed(ActionEvent evt) {
        this.Update_USBL_Panel();
    }

    private void jComboBox_LBLIdPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.Update_LBL_Infos();
    }

    private void jComboBox_LBLIdActionPerformed(ActionEvent evt) {
        this.Update_LBL_Panel();
    }

    private void jComboBox_EMLOGIdPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.Update_EMLOG_Infos();
    }

    private void jComboBox_EMLOGIdActionPerformed(ActionEvent evt) {
        this.Update_EMLOG_Panel();
    }

    private void jComboBox_GPSQualityPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
    }

    private void jComboBox_GPSQualityActionPerformed(ActionEvent evt) {
    }

    private void jTextField_DEPTHDepthActionPerformed(ActionEvent evt) {
    }

    private void jTextField_USBLLatitudeActionPerformed(ActionEvent evt) {
    }

    private void jTextField_USBLMajorAxisActionPerformed(ActionEvent evt) {
    }

    private void jComboBox_OutputRateActionPerformed(ActionEvent evt) {
        this.Update_OutputParam_Visibility();
    }

    private void jComboBox_OutputDisplayIdPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
    }

    private void jComboBox_OutputDisplayIdActionPerformed(ActionEvent evt) {
        Display.SetOutputId(jComboBox_OutputDisplayId.getSelectedIndex() + 1);
    }

    private void jToggleButton_StartDisplayActionPerformed(ActionEvent evt) {
        if (!this.IsDisplayEnabled.booleanValue()) {
            Display.Start();
            jToggleButton_StartDisplay.setText("Disable");
            this.IsDisplayEnabled = true;
        } else {
            Display.Stop();
            jToggleButton_StartDisplay.setText("Enable");
            this.IsDisplayEnabled = false;
        }
    }

    private void jButton_InitDisplayActionPerformed(ActionEvent evt) {
        Display.Init();
    }

    private void jComboBox_OperatingModePopupMenuWillBecomeVisible(PopupMenuEvent evt) {
    }

    private void jComboBox_OperatingModeActionPerformed(ActionEvent evt) {
    }

    private void jTextField_USBLBeaconCodeIDActionPerformed(ActionEvent evt) {
    }

    private void jTextField_CTDTemperatureActionPerformed(ActionEvent evt) {
    }

    private void jTextField_DVLBT_XS2SpeedActionPerformed(ActionEvent evt) {
    }

    private void jCheckBox_Scramble_ActionPerformed(ActionEvent evt) {
        for (int i = 0; i < SimulatorFrame.Manager.Scramblers[0].GetScramblerNb(); ++i) {
            SimulatorFrame.Manager.Scramblers[i].UpdateDisplay();
        }
    }

    private void jSlider_Scramble_StateChanged(ChangeEvent evt) {
        for (int i = 0; i < SimulatorFrame.Manager.Scramblers[0].GetScramblerNb(); ++i) {
            SimulatorFrame.Manager.Scramblers[i].UpdateDisplay();
        }
    }

    private void jTextField_USBLUTMEstActionPerformed(ActionEvent evt) {
    }

    private void jComboBox_DVLIdActionPerformed(ActionEvent evt) {
        this.Update_DVL_Panel();
    }

    private void jTextField_GPSLatLongCovActionPerformed(ActionEvent evt) {
    }

    private void jComboBox_CoordinateVelocitiesActionPerformed(ActionEvent evt) {
    }

    private void jButton_ConnectOutput6ActionPerformed(ActionEvent evt) {
        this.Connect_Disconnect(5);
    }

    private void jButton_ConnectOutput7ActionPerformed(ActionEvent evt) {
        this.Connect_Disconnect(6);
    }

    private void jTextField_LogEM_TransWaterSpeedActionPerformed(ActionEvent evt) {
    }

    private void jTextField_StimSpeedNorthActionPerformed(ActionEvent evt) {
    }

    private void jDvlWaterTrackUsedActionPerformed(ActionEvent evt) {
        this.ManageDVLNortekCheckboxes(1);
    }

    private void jDvlBottomTrackUsedActionPerformed(ActionEvent evt) {
        this.ManageDVLNortekCheckboxes(0);
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[11][0];
        if (jDvlNortekDistanceBeam.getText().isEmpty()) {
            jDvlNortekDistanceBeam.setText("0.0");
        }
        Sensor.Set_DvlNtkDistanceBeam(jCmbBoxDistanceBeam.getSelectedIndex(), Double.parseDouble(jDvlNortekDistanceBeam.getText()));
    }

    private void jCmbBoxDistanceBeamItemStateChanged(ItemEvent evt) {
        this.Update_DVL_NTK_Panel();
    }

    private void jButton12ActionPerformed(ActionEvent evt) {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[11][0];
        if (jDvlNortekVelocity.getText().isEmpty()) {
            jDvlNortekVelocity.setText("0.0");
        }
        Sensor.Set_DvlNtkVelocity(jCmbBoxVelocityAxis.getSelectedIndex(), Double.parseDouble(jDvlNortekVelocity.getText()));
    }

    private void jButton13ActionPerformed(ActionEvent evt) {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[11][0];
        if (jDvlNortekFOM.getText().isEmpty()) {
            jDvlNortekFOM.setText("0.0");
        }
        Sensor.Set_DvlNtkFOM(jCmbBoxFOMAxis.getSelectedIndex(), Double.parseDouble(jDvlNortekFOM.getText()));
    }

    private void jButton14ActionPerformed(ActionEvent evt) {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[11][0];
        if (jDvlNortekDT1.getText().isEmpty()) {
            jDvlNortekDT1.setText("0.0");
        }
        Sensor.Set_DvlNtkDT1(jCmbBoxDT1Axis.getSelectedIndex(), Double.parseDouble(jDvlNortekDT1.getText()));
    }

    private void jButton15ActionPerformed(ActionEvent evt) {
        ExternalSensorInfo Sensor = this.Info.ExtInfo[11][0];
        if (jDvlNortekDT2.getText().isEmpty()) {
            jDvlNortekDT2.setText("0.0");
        }
        Sensor.Set_DvlNtkDT2(jCmbBoxDT2Axis.getSelectedIndex(), Double.parseDouble(jDvlNortekDT2.getText()));
    }

    private void jCmbBoxVelocityAxisItemStateChanged(ItemEvent evt) {
        this.Update_DVL_NTK_Panel();
    }

    private void jCmbBoxFOMAxisItemStateChanged(ItemEvent evt) {
        this.Update_DVL_NTK_Panel();
    }

    private void jCmbBoxDT1AxisItemStateChanged(ItemEvent evt) {
        this.Update_DVL_NTK_Panel();
    }

    private void jCmbBoxDT2AxisItemStateChanged(ItemEvent evt) {
        this.Update_DVL_NTK_Panel();
    }

    public void Start_Manager(int OutputId) {
        this.OutputEncoder[OutputId] = this.Proto_List.GetEncoderById(this.Info.OutputInfo[OutputId].GetProtocole());
        Manager.Start(OutputId, this.OutputEncoder[OutputId]);
    }

    public void Stop_Manager(int OutputId) {
        Manager.Stop(OutputId);
    }

    public void Connect_Disconnect(int OutputId) {
        JButton Button = null;
        switch (OutputId) {
            case 0: {
                Button = jButton_ConnectOutput1;
                break;
            }
            case 1: {
                Button = jButton_ConnectOutput2;
                break;
            }
            case 2: {
                Button = jButton_ConnectOutput3;
                break;
            }
            case 3: {
                Button = jButton_ConnectOutput4;
                break;
            }
            case 4: {
                Button = jButton_ConnectOutput5;
                break;
            }
            case 5: {
                Button = jButton_ConnectOutput6;
                break;
            }
            case 6: {
                Button = jButton_ConnectOutput7;
            }
        }
        if (SimulatorFrame.Manager.OutputManager[OutputId].IsStarted.booleanValue()) {
            this.Stop_Manager(OutputId);
        } else {
            this.Start_Manager(OutputId);
        }
        this.UpdateControlPanel();
    }

    private void initComponentsLists() {
        this.jButton_ConnectOutputList = new JButton[7];
        this.jButton_ConnectOutputList[0] = jButton_ConnectOutput1;
        this.jButton_ConnectOutputList[1] = jButton_ConnectOutput2;
        this.jButton_ConnectOutputList[2] = jButton_ConnectOutput3;
        this.jButton_ConnectOutputList[3] = jButton_ConnectOutput4;
        this.jButton_ConnectOutputList[4] = jButton_ConnectOutput5;
        this.jButton_ConnectOutputList[5] = jButton_ConnectOutput6;
        this.jButton_ConnectOutputList[6] = jButton_ConnectOutput7;
        this.jCheckBoxFrameEnableList = new JCheckBox[18];
        this.jCheckBoxFrameEnableList[0] = jCheckBox_TrameXXEnable;
        this.jCheckBoxFrameEnableList[1] = jCheckBox_TrameXXEnable1;
        this.jCheckBoxFrameEnableList[2] = jCheckBox_TrameXXEnable2;
        this.jCheckBoxFrameEnableList[3] = jCheckBox_TrameXXEnable3;
        this.jCheckBoxFrameEnableList[4] = jCheckBox_TrameXXEnable4;
        this.jCheckBoxFrameEnableList[5] = jCheckBox_TrameXXEnable5;
        this.jCheckBoxFrameEnableList[6] = jCheckBox_TrameXXEnable6;
        this.jCheckBoxFrameEnableList[7] = jCheckBox_TrameXXEnable7;
        this.jCheckBoxFrameEnableList[8] = jCheckBox_TrameXXEnable8;
        this.jCheckBoxFrameEnableList[9] = jCheckBox_TrameXXEnable9;
        this.jCheckBoxFrameEnableList[10] = jCheckBox_TrameXXEnable10;
        this.jCheckBoxFrameEnableList[11] = jCheckBox_TrameXXEnable11;
        this.jCheckBoxFrameEnableList[12] = jCheckBox_TrameXXEnable12;
        this.jCheckBoxFrameEnableList[13] = jCheckBox_TrameXXEnable13;
        this.jCheckBoxFrameEnableList[14] = jCheckBox_TrameXXEnable14;
        this.jCheckBoxFrameEnableList[15] = jCheckBox_TrameXXEnable15;
        this.jCheckBoxFrameEnableList[16] = jCheckBox_TrameXXEnable16;
        this.jCheckBoxFrameEnableList[17] = jCheckBox_TrameXXEnable17;
        this.jCheckBoxOptionsList = new JCheckBox[6];
        this.jCheckBoxOptionsList[0] = jCheckBox_Option1;
        this.jCheckBoxOptionsList[1] = jCheckBox_Option2;
        this.jCheckBoxOptionsList[2] = jCheckBox_Option3;
        this.jCheckBoxOptionsList[3] = jCheckBox_Option4;
        this.jCheckBoxOptionsList[4] = jCheckBox_Option5;
        this.jCheckBoxOptionsList[5] = jCheckBox_Option6;
    }
}

