/*
 * Decompiled with CFR 0.152.
 */
package SimulatorPackage;

import EncoderPackage.ProtocolEncoder;
import FlowReaderWriterPackage.FlowReaderWriter;
import InfosPackage.OutputFlowInfo;
import InfosPackage.SimulatorInfo;
import SimulatorPackage.SimulatorFrame;
import SimulatorPackage.SimulatorScrambler;
import SimulatorPackage.SimulatorWriterManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class SimulatorManager
extends Thread {
    int Manager_State = 0;
    Timer ManagerTimer = null;
    SimulatorInfo Info;
    public SimulatorWriterManager[] OutputManager = null;
    private ProtocolEncoder[] OutputEncoder = null;
    SimulatorScrambler[] Scramblers;
    SimulatorFrame Frame = null;
    private static final int IDLE_STATE = 0;

    public SimulatorManager(SimulatorInfo _SimulatorInfo, SimulatorFrame _SimulatorFrame) {
        this.Info = _SimulatorInfo;
        this.Frame = _SimulatorFrame;
        this.OutputEncoder = new ProtocolEncoder[7];
        this.OutputManager = new SimulatorWriterManager[7];
        for (int i = 0; i < 7; ++i) {
            this.OutputManager[i] = new SimulatorWriterManager(this.Info.OutputInfo[i], i);
        }
        this.ManagerTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorManager.this.UpdateInformationMessagesandLights();
            }
        });
        this.ManagerTimer.start();
    }

    public void Start(int OutputId, ProtocolEncoder OutEncoder) {
        this.OutputEncoder[OutputId] = OutEncoder;
        this.OutputManager[OutputId].Start(this.OutputEncoder[OutputId], this.Scramblers);
        this.SetState(0);
    }

    public void Stop(int OutputId) {
        this.OutputManager[OutputId].Stop();
        this.SetState(0);
    }

    private void SetState(int State2) {
        this.Manager_State = State2;
    }

    private int GetState() {
        return this.Manager_State;
    }

    @Override
    public void run() {
        while (true) {
            switch (this.GetState()) {
                case 0: {
                    break;
                }
                default: {
                    this.SetState(0);
                }
            }
            try {
                SimulatorManager.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SimulatorManager.yield();
        }
    }

    public void UpdateInformationMessagesandLights() {
        for (int i = 0; i < 7; ++i) {
            this.SetLight(0 + i + 1, this.OutputManager[i].GetFlow(), this.Info.OutputInfo[i]);
            SimulatorFrame.SetMessage(0 + i, this.OutputManager[i].GetFlowState(), this.OutputManager[i].GetFlowStateColor());
        }
    }

    public void SetLight(int Light_Id, FlowReaderWriter Flow, OutputFlowInfo Info) {
        if (Flow == null || Info.GetFlowEnabled() == 0) {
            SimulatorFrame.Light.SetLedColor(Light_Id, 0);
        } else {
            SimulatorFrame.Light.SetLedColor(Light_Id, Flow.IsFlowOpened() ? 1 : 2);
        }
    }
}

