/*
 * Decompiled with CFR 0.152.
 */
package SimulatorPackage;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;

public final class SimulatorScrambler {
    private JCheckBox jActivationCheckbox;
    private JSlider jParamSlider;
    private JLabel jParamText;
    private JLabel jParamlabel;
    private ScramblingType Type;
    private static int iScramblerNb = 0;
    private byte[] data;
    private int lenght;

    public SimulatorScrambler(JCheckBox activated, JSlider slider, JLabel numbertext, JLabel labeltext, ScramblingType Type2) {
        this.jActivationCheckbox = activated;
        this.jParamSlider = slider;
        this.jParamText = numbertext;
        this.jParamlabel = labeltext;
        this.Type = Type2;
        ++iScramblerNb;
        this.UpdateDisplay();
    }

    public void UpdateDisplay() {
        if (!this.jActivationCheckbox.isSelected()) {
            this.jParamSlider.setEnabled(false);
            this.jParamText.setEnabled(false);
            this.jParamlabel.setEnabled(false);
        } else {
            this.jParamSlider.setEnabled(true);
            this.jParamText.setEnabled(true);
            this.jParamlabel.setEnabled(true);
            this.jParamText.setText(Integer.toString(this.jParamSlider.getValue()));
        }
    }

    public int GetScramblerNb() {
        return iScramblerNb;
    }

    public void SetInputData(String data, int lenght) {
        this.data = new byte[1024];
        for (int i = 0; i < lenght; ++i) {
            this.data[i] = (byte)data.charAt(i);
        }
        this.lenght = lenght;
    }

    public void SetInputData(byte[] data, int lenght) {
        this.data = data;
        this.lenght = lenght;
    }

    public byte[] Get_ScrambledData() {
        return this.data;
    }

    public int Get_ScrambledLenght() {
        return this.lenght;
    }

    public int Scramble() {
        if (!this.jActivationCheckbox.isSelected()) {
            return 0;
        }
        double d = Math.random();
        if (d < 0.3) {
            return 0;
        }
        block7: for (int l = 0; l < this.jParamSlider.getValue(); ++l) {
            int r = this.Get_RandomIndex();
            char c = this.Get_RandomChar();
            int v = this.GetRandomCommaIndex();
            switch (this.Type) {
                case REPLACE_CHAR: {
                    this.data[r] = (byte)c;
                    continue block7;
                }
                case SUPPRESS_CHAR: {
                    this.SuppressChar(r);
                    continue block7;
                }
                case INSERT_CHAR: {
                    this.AddChar(r, c);
                    continue block7;
                }
                case SUPPRESS_FIELD: {
                    if (v < 0) continue block7;
                    this.SuppressField(v);
                    continue block7;
                }
                case INSERT_FIELD: {
                    if (v < 0) continue block7;
                    this.AddField(v);
                }
            }
        }
        return 0;
    }

    private int Get_RandomIndex() {
        return (int)(Math.random() * (double)(this.lenght - 1));
    }

    private char Get_RandomChar() {
        int rnd = (int)(Math.random() * 52.0);
        int base = rnd < 26 ? 65 : 97;
        return (char)(base + rnd % 26);
    }

    private void SuppressChar(int index) {
        for (int i = index; i <= this.lenght - 2; ++i) {
            this.data[i] = this.data[i + 1];
        }
        --this.lenght;
    }

    private void AddChar(int index, char c) {
        for (int i = this.lenght; i >= index + 1; --i) {
            this.data[i] = this.data[i - 1];
        }
        this.data[index] = (byte)c;
        ++this.lenght;
    }

    private int GetRandomCommaIndex() {
        int n = 0;
        int m = 0;
        int[] ind = new int[256];
        for (int i = 0; i < this.lenght; ++i) {
            if (this.data[i] != 44) continue;
            ind[n] = i;
            ++n;
        }
        if (n <= 1) {
            return -1;
        }
        m = (int)(Math.random() * (double)(n - 1));
        return ind[m];
    }

    private void SuppressField(int r) {
        while (this.data[r + 1] != 44) {
            this.SuppressChar(r + 1);
        }
    }

    private void AddField(int r) {
        this.AddChar(r + 1, ',');
        this.AddChar(r + 1, this.Get_RandomChar());
        this.AddChar(r + 1, this.Get_RandomChar());
    }

    public static enum ScramblingType {
        REPLACE_CHAR,
        SUPPRESS_CHAR,
        INSERT_CHAR,
        SUPPRESS_FIELD,
        INSERT_FIELD;

    }
}

