/*
 * Decompiled with CFR 0.152.
 */
package Tools;

public class Binary_EncodeTool {
    int Endian = 1;
    byte[] Frame = new byte[1048];
    int Lenght = 0;
    public static final int ENCODER_FRAME_LENGTH = 1048;
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;

    public void Initialize(int _Endian) {
        this.Endian = _Endian;
        this.Lenght = 0;
    }

    public void Add2BytesChecksum() {
        int CHK = 0;
        int toto = 0;
        for (int i = 0; i < this.Lenght; ++i) {
            toto = this.Frame[i] & 0xFF;
            CHK += toto;
        }
        this.Short_to_2UINT8(CHK);
    }

    public void Add2BytesChecksumNortekDf21_22(int _init, int _start_byte, int _end_byte, int _position) {
        int CHK = _init;
        int toto = 0;
        int size = _end_byte - _start_byte;
        int size_half = size / 2;
        boolean IsLast8bit = false;
        if (size % 2 != 0) {
            IsLast8bit = true;
        }
        int j = _start_byte;
        for (int i = 0; i < size_half; ++i) {
            toto = this.Frame[j] & 0xFF;
            CHK += (toto |= (this.Frame[j + 1] & 0xFF) << 8 & 0xFFFF);
            j += 2;
        }
        if (IsLast8bit) {
            toto = (this.Frame[size - 1] & 0xFF) << 8 & 0xFFFF;
            CHK += toto;
        }
        this.Short_to_2UINT8(CHK, _position);
    }

    public void Add4BytesChecksum() {
        int CHK = 0;
        int toto = 0;
        for (int i = 0; i < this.Lenght; ++i) {
            toto = this.Frame[i] & 0xFF;
            CHK += toto;
        }
        this.DWord_to_4UINT8(CHK);
    }

    public void Add1ByteChecksum() {
        int CHK = 0;
        int tmp = 0;
        for (int i = 0; i < this.Lenght; ++i) {
            tmp = this.Frame[i] & 0xFF;
            CHK += tmp;
        }
        this.Byte_to_1UINT8(CHK);
    }

    public void Add8bitsXORChecksum_On2Bytes(int iFirstByteNumber, int iLastByteNumber) {
        byte CHK = 0;
        for (int i = iFirstByteNumber; i < iLastByteNumber; ++i) {
            CHK = (byte)(CHK ^ this.Frame[i]);
        }
        this.Byte_to_1UINT8(0);
        this.Byte_to_1UINT8(CHK);
    }

    public void Add8bitsXORChecksum_On1Bytes(int iFirstByteNumber, int iLastByteNumber) {
        int CHK = 0;
        for (int i = iFirstByteNumber; i < iLastByteNumber; ++i) {
            CHK = (byte)(CHK ^ this.Frame[i]);
        }
        this.Byte_to_1UINT8(CHK);
    }

    public void Add2ChecksumChar(int iFirstByteNumber, int iLastByteNumber) {
        int cChk = 0;
        for (int i = iFirstByteNumber; i < iLastByteNumber; ++i) {
            cChk = (char)(cChk + this.Frame[i]);
        }
        char cChk1 = (char)(cChk >> 4 & 0xF);
        cChk1 = cChk1 >= '\n' ? (char)(cChk1 + 55) : (char)(cChk1 + 48);
        char cChk2 = (char)(cChk & 0xF);
        cChk2 = cChk2 >= '\n' ? (char)(cChk2 + 55) : (char)(cChk2 + 48);
        this.Byte_to_1UINT8(cChk1);
        this.Byte_to_1UINT8(cChk2);
    }

    public byte[] GetBinaryFrame() {
        return this.Frame;
    }

    public int GetBinaryFrameLenght() {
        return this.Lenght;
    }

    public void AddPadding(int padding, int nb) {
        for (int i = 0; i < nb; ++i) {
            this.Byte_to_1UINT8(padding);
        }
    }

    public void Byte_to_1UINT8(double d_val) {
        this.Byte_to_1UINT8((int)d_val);
    }

    public void Byte_to_1UINT8(int b_val) {
        this.Frame[this.Lenght++] = (byte)(b_val & 0xFF);
    }

    public void Word_to_2UINT8(int i_val) {
        this.Short_to_2UINT8(i_val);
    }

    public void Short_to_2UINT8(double d_val) {
        this.Short_to_2UINT8((int)d_val);
    }

    public void Short_to_2UINT8(int i_val) {
        byte[] array = Binary_EncodeTool.intToByteArray(i_val);
        if (this.Endian == 1) {
            for (int i = 0; i < 2; ++i) {
                this.Frame[this.Lenght++] = array[2 + i];
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                this.Frame[this.Lenght++] = array[2 + (1 - i)];
            }
        }
    }

    public void Short_to_2UINT8(int i_val, int _position) {
        byte[] array = Binary_EncodeTool.intToByteArray(i_val);
        int pos = _position;
        if (this.Endian == 1) {
            for (int i = 0; i < 2; ++i) {
                this.Frame[_position] = array[2 + i];
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                this.Frame[pos] = array[2 + (1 - i)];
                ++pos;
            }
        }
    }

    public void DWord_to_4UINT8(long l_val) {
        this.Long_to_4UINT8(l_val);
    }

    public void Long_to_4UINT8(double d_val) {
        this.Long_to_4UINT8((long)d_val);
    }

    public void Long_to_4UINT8(long l_val) {
        byte[] array = Binary_EncodeTool.longToByteArray(l_val);
        if (this.Endian == 1) {
            for (int i = 0; i < 4; ++i) {
                this.Frame[this.Lenght++] = array[4 + i];
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                this.Frame[this.Lenght++] = array[4 + (3 - i)];
            }
        }
    }

    public void Long_to_3UINT8(long l_val) {
        byte[] array = Binary_EncodeTool.longToByteArray(l_val);
        if (this.Endian == 1) {
            for (int i = 0; i < 3; ++i) {
                this.Frame[this.Lenght++] = array[5 + i];
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                this.Frame[this.Lenght++] = array[5 + (2 - i)];
            }
        }
    }

    public void Float_to_4UINT8(double d_val) {
        this.Float_to_4UINT8((float)d_val);
    }

    public void Float_to_4UINT8(float f_val) {
        int raw_int = Float.floatToRawIntBits(f_val);
        byte[] array = Binary_EncodeTool.intToByteArray(raw_int);
        if (this.Endian == 1) {
            for (int i = 0; i < 4; ++i) {
                this.Frame[this.Lenght++] = array[i];
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                this.Frame[this.Lenght++] = array[3 - i];
            }
        }
    }

    public void Float_to_3UINT8(double d_val) {
        this.Float_to_3UINT8((float)d_val);
    }

    public void Float_to_3UINT8(float f_val) {
        int raw_int = Float.floatToRawIntBits(f_val);
        byte[] array = Binary_EncodeTool.intToByteArray(raw_int);
        if (this.Endian == 1) {
            for (int i = 0; i < 3; ++i) {
                this.Frame[this.Lenght++] = array[i];
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                this.Frame[this.Lenght++] = array[2 - i];
            }
        }
    }

    public void Double_to_8UINT8(double d_val) {
        long raw_long = Double.doubleToRawLongBits(d_val);
        byte[] array = Binary_EncodeTool.longToByteArray(raw_long);
        if (this.Endian == 1) {
            for (int i = 0; i < 8; ++i) {
                this.Frame[this.Lenght++] = array[i];
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                this.Frame[this.Lenght++] = array[7 - i];
            }
        }
    }

    public static byte[] intToByteArray(int param) {
        byte[] result = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (result.length - 1 - i) * 8;
            result[i] = (byte)(param >>> offset & 0xFF);
        }
        return result;
    }

    public static byte[] longToByteArray(long param) {
        byte[] result = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int offset = (result.length - 1 - i) * 8;
            result[i] = (byte)(param >>> offset & 0xFFL);
        }
        return result;
    }
}

