/*
 * Decompiled with CFR 0.152.
 */
package Tools;

public class ConvertTool {
    public float TruncFloat(float f, int precision) {
        int n = (int)((double)f * Math.pow(10.0, precision));
        return (float)((double)n / Math.pow(10.0, precision));
    }

    public double TruncDouble(double f, int precision) {
        int n = (int)(f * Math.pow(10.0, precision));
        return (double)n / Math.pow(10.0, precision);
    }

    public double unite2deg(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_RADIAN) {
            return this.Rad2Deg(mes);
        }
        return mes;
    }

    public double deg2unite(double deg, UNITS unite) {
        if (unite == UNITS.UNITE_RADIAN) {
            return this.Deg2Rad(deg);
        }
        return deg;
    }

    public double unite2MS(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_KM_H) {
            return this.KMH2MS(mes);
        }
        if (unite == UNITS.UNITE_M_S) {
            return mes;
        }
        if (unite == UNITS.UNITE_KNOTS) {
            return this.KNOTS2MS(mes);
        }
        return 0.0;
    }

    public double MS2unite(double ms, UNITS unite) {
        if (unite == UNITS.UNITE_KM_H) {
            return this.MSH2KMH(ms);
        }
        if (unite == UNITS.UNITE_M_S) {
            return ms;
        }
        if (unite == UNITS.UNITE_MM_S) {
            return this.M2MM(ms);
        }
        if (unite == UNITS.UNITE_CM_S) {
            return this.M2CM(ms);
        }
        if (unite == UNITS.UNITE_KNOTS) {
            return this.MS2KNOTS(ms);
        }
        if (unite == UNITS.UNITE_FEET_S) {
            return this.MS2FEETS(ms);
        }
        return 0.0;
    }

    public double unite2m(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_MM) {
            return this.MM2M(mes);
        }
        if (unite == UNITS.UNITE_CM) {
            return this.CM2M(mes);
        }
        if (unite == UNITS.UNITE_DM) {
            return this.DM2M(mes);
        }
        return mes;
    }

    public double m2unite(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_MM) {
            return this.M2MM(mes);
        }
        if (unite == UNITS.UNITE_CM) {
            return this.M2CM(mes);
        }
        if (unite == UNITS.UNITE_DM) {
            return this.M2DM(mes);
        }
        if (unite == UNITS.UNITE_M2) {
            return this.M2M2(mes);
        }
        if (unite == UNITS.UNITE_FEET) {
            return this.M2FEET(mes);
        }
        return mes;
    }

    public double unite2us(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_S) {
            return this.S2US(mes);
        }
        if (unite == UNITS.UNITE_MS) {
            return this.MS2US(mes);
        }
        if (unite == UNITS.UNITE_100US) {
            return this._100US2US(mes);
        }
        return mes;
    }

    public double us2unite(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_S) {
            return this.US2S(mes);
        }
        if (unite == UNITS.UNITE_MS) {
            return this.US2MS(mes);
        }
        if (unite == UNITS.UNITE_100US) {
            return this.US2100US(mes);
        }
        return mes;
    }

    public double unite2s_m(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_S_m) {
            return mes;
        }
        return 0.0;
    }

    public double s_m2unite(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_S_m) {
            return mes;
        }
        return 0.0;
    }

    public double unite2psu(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_PSU) {
            return mes;
        }
        return 0.0;
    }

    public double psu2unite(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_PSU) {
            return mes;
        }
        return 0.0;
    }

    public double unite2dbar(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_DBAR) {
            return mes;
        }
        if (unite == UNITS.UNITE_PASCAL) {
            return mes / 100000.0 * 10.0;
        }
        if (unite == UNITS.UNITE_PSI) {
            return mes * 0.6894757 - 10.1325;
        }
        return 0.0;
    }

    public double dbar2unite(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_DBAR) {
            return mes;
        }
        if (unite == UNITS.UNITE_PASCAL) {
            return mes / 10.0 * 100000.0;
        }
        if (unite == UNITS.UNITE_PSI) {
            return (mes + 10.1325) / 0.6894757;
        }
        return 0.0;
    }

    public double unite2degcel(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_DEGCEL) {
            return mes;
        }
        return 0.0;
    }

    public double degcel2unite(double mes, UNITS unite) {
        if (unite == UNITS.UNITE_DEGCEL) {
            return mes;
        }
        return 0.0;
    }

    public double Rad2Deg(double rad) {
        return rad / Math.PI * 180.0;
    }

    public double Deg2Rad(double deg) {
        return deg / 180.0 * Math.PI;
    }

    public double MSH2KMH(double ms) {
        return ms * 3600.0 / 1000.0;
    }

    public double KMH2MS(double kmh) {
        return kmh * 1000.0 / 3600.0;
    }

    public double KNOTS2MS(double knots) {
        return knots * 0.5144444444444445;
    }

    public double MS2KNOTS(double ms) {
        return ms * 1.9438444924406046;
    }

    public double MS2FEETS(double ms) {
        return ms * 3.2808399;
    }

    public double KMH2KNOTS(double kmh) {
        return this.MS2KNOTS(this.KMH2MS(kmh));
    }

    public double KNOTS2KMH(double knots) {
        return this.MSH2KMH(this.KNOTS2MS(knots));
    }

    public double M2CM(double m) {
        return 100.0 * m;
    }

    public double M2DM(double m) {
        return 10.0 * m;
    }

    public double CM2M(double cm) {
        return cm / 100.0;
    }

    public double DM2M(double dm) {
        return dm / 10.0;
    }

    public double M2MM(double m) {
        return 1000.0 * m;
    }

    public double MM2M(double mm) {
        return mm / 1000.0;
    }

    public double M2M2(double m) {
        return Math.pow(m, 2.0);
    }

    public double M2FEET(double m) {
        return m * 3.2808399;
    }

    public double S2US(double s) {
        return 1000000.0 * s;
    }

    public double S2MS(double s) {
        return 1000.0 * s;
    }

    public double S2100US(double s) {
        return 10000.0 * s;
    }

    public double US2S(double us) {
        return us / 1000000.0;
    }

    public double US2MS(double us) {
        return us / 1000.0;
    }

    public double MS2US(double ms) {
        return 1000.0 * ms;
    }

    public double US2100US(double us) {
        return us / 100.0;
    }

    public double _100US2US(double us) {
        return 100.0 * us;
    }

    public static enum UNITS {
        UNITE_DEGREE,
        UNITE_RADIAN,
        UNITE_SEC_ARC,
        UNITE_KM_H,
        UNITE_M_S,
        UNITE_KNOTS,
        UNITE_MM_S,
        UNITE_CM_S,
        UNITE_FEET_S,
        UNITE_M,
        UNITE_CM,
        UNITE_DM,
        UNITE_MM,
        UNITE_M2,
        UNITE_FEET,
        UNITE_US,
        UNITE_MS,
        UNITE_100US,
        UNITE_S,
        UNITE_S_m,
        UNITE_PSU,
        UNITE_DBAR,
        UNITE_PASCAL,
        UNITE_PSI,
        UNITE_DEGCEL,
        UNITE_MILLIGAL,
        UNITE_DEGREE_PER_S,
        UNITE_M_S2;

    }
}

