/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class LightPanel
extends JPanel {
    GroupLayout LightPanel_Layout;
    JPanel LightPanel;
    int[] Led_Colors = new int[7];
    public static final int GREY = 0;
    public static final int GREEN = 1;
    public static final int RED = 2;
    public static final int RADIUS = 7;
    public static final int NB_LED = 7;

    public LightPanel(JPanel _LightPanel) {
        this.LightPanel = _LightPanel;
        this.setPreferredSize(new Dimension(14, 14));
        this.setBackground(new Color(236, 233, 216));
        this.LightPanel_Layout = new GroupLayout(this.LightPanel);
        this.LightPanel.setLayout(this.LightPanel_Layout);
        this.LightPanel_Layout.setHorizontalGroup(this.LightPanel_Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this));
        this.LightPanel_Layout.setVerticalGroup(this.LightPanel_Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this));
        this.UpdateLightPanel();
    }

    public void SetLedColor(int Led_Id, int Color_Id) {
        if (Led_Id > 7) {
            return;
        }
        this.Led_Colors[Led_Id - 1] = Color_Id;
        this.UpdateLightPanel();
    }

    public void UpdateLightPanel() {
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        block5: for (int Led_Id = 1; Led_Id <= 7; ++Led_Id) {
            switch (this.Led_Colors[Led_Id - 1]) {
                case 0: {
                    this.greyled(g, Led_Id);
                    continue block5;
                }
                case 1: {
                    this.greenled(g, Led_Id);
                    continue block5;
                }
                case 2: {
                    this.redled(g, Led_Id);
                    continue block5;
                }
                default: {
                    this.greyled(g, Led_Id);
                }
            }
        }
    }

    public void greyled(Graphics g, int n) {
        this.led(g, n, 204, 204, 204);
    }

    public void greenled(Graphics g, int n) {
        this.led(g, n, 102, 255, 102);
    }

    public void redled(Graphics g, int n) {
        this.led(g, n, 255, 102, 102);
    }

    public void led(Graphics g, int n, int r, int v, int b) {
        g.setColor(new Color(r, v, b));
        this.drawfillCircle(g, 7, 7 + 23 * (n - 1), 7);
        g.setColor(new Color(r - 50, v - 50, b - 50));
        this.drawCircle(g, 7, 7 + 23 * (n - 1), 7);
        this.drawCircle(g, 7, 7 + 23 * (n - 1), 5);
    }

    public void drawfillCircle(Graphics g, int xCenter, int yCenter, int r) {
        g.fillOval(xCenter - r, yCenter - r, 2 * r, 2 * r);
    }

    public void drawCircle(Graphics g, int xCenter, int yCenter, int r) {
        g.drawOval(xCenter - r, yCenter - r, 2 * r, 2 * r);
    }
}

