/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import InfosPackage.ExternalSensorInfo;
import InfosPackage.OutputFlowInfo;
import InfosPackage.SimulatorInfo;
import Tools.ASCII_EncodeTool;
import Tools.Binary_EncodeTool;
import Tools.ConvertTool;
import Tools.TimeTool;
import java.util.prefs.Preferences;

public class ProtocolEncoder {
    Preferences prefs;
    public byte[] Encoded_Binary_Frame;
    public int Encoded_Binary_Frame_Lenght;
    public String Encoded_ASCII_Frame;
    public int Encoded_ASCII_Frame_Lenght;
    public boolean FrameAvailable = false;
    int Protocol_Type;
    String Protocol_Name;
    int Output_Id;
    String[] EncoderFramesNames;
    boolean[][] EncoderFramesEnabled;
    String[] EncoderOptionsNames;
    boolean[][] EncoderOptionsEnabled;
    SimulatorInfo Info;
    ExternalSensorInfo GPS_Info;
    ExternalSensorInfo DVL_Info;
    ExternalSensorInfo USBL_Info;
    ExternalSensorInfo LBL_Info;
    ExternalSensorInfo CTD_Info;
    ExternalSensorInfo DEPTH_Info;
    ExternalSensorInfo EMLOG_Info;
    ExternalSensorInfo GRAVI_Info;
    ExternalSensorInfo DMI_Info;
    ExternalSensorInfo PLATFORM_Info;
    ExternalSensorInfo SIMSTIM_Info;
    ExternalSensorInfo DVLNTK_Info;
    ConvertTool ConvTool = null;
    ASCII_EncodeTool ASCIITool = null;
    Binary_EncodeTool BINTool = null;
    public TimeTool TIMETool = null;
    public static final char BINARY = '\u0000';
    public static final char ASCII = '\u0001';
    public static final char NONE = '\u0002';
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    public static final int DECODER_BUFF_SIZE = 4048;
    public static final int ENCODER_FRAMES_NB = 18;
    public static final int ENCODER_OPTIONS_NB = 6;
    private static final String REG_TELEGRAM = "telegram";
    private static final String REG_OPTION = "option";

    public ProtocolEncoder(String _ProtoName) {
        int i;
        this.Protocol_Name = _ProtoName;
        this.Encoded_Binary_Frame = new byte[4048];
        this.Encoded_Binary_Frame_Lenght = 0;
        this.Encoded_ASCII_Frame = "";
        this.Encoded_ASCII_Frame_Lenght = 0;
        this.FrameAvailable = false;
        this.EncoderFramesNames = new String[18];
        for (i = 0; i < 18; ++i) {
            this.EncoderFramesNames[i] = "";
        }
        this.EncoderFramesEnabled = new boolean[7][18];
        this.EncoderOptionsNames = new String[6];
        for (i = 0; i < 6; ++i) {
            this.EncoderOptionsNames[i] = "";
        }
        this.EncoderOptionsEnabled = new boolean[7][6];
        this.ConvTool = new ConvertTool();
        this.ASCIITool = new ASCII_EncodeTool();
        this.BINTool = new Binary_EncodeTool();
        this.TIMETool = new TimeTool();
        this.prefs = Preferences.userRoot().node("ixsea/genericsimulator/protocols/" + this.Protocol_Name.toLowerCase());
    }

    public void Init(String Proto_Name, int Proto_Type, SimulatorInfo _Info) {
        int OutputId;
        this.Protocol_Name = Proto_Name;
        this.Protocol_Type = Proto_Type;
        for (OutputId = 0; OutputId < 7; ++OutputId) {
            for (int TelegramId = 0; TelegramId < 18; ++TelegramId) {
                this.EncoderFramesEnabled[OutputId][TelegramId] = this.prefs.getInt(REG_TELEGRAM + Integer.toString(OutputId) + Integer.toString(TelegramId), 1) != 0;
            }
        }
        for (OutputId = 0; OutputId < 7; ++OutputId) {
            for (int OptionId = 0; OptionId < 6; ++OptionId) {
                this.EncoderOptionsEnabled[OutputId][OptionId] = this.prefs.getInt(REG_OPTION + Integer.toString(OutputId) + Integer.toString(OptionId), 1) != 0;
            }
        }
        this.Info = _Info;
        this.EncodeFrameInit();
    }

    public String GetProtocolName() {
        return this.Protocol_Name;
    }

    public int GetProtoType() {
        return this.Protocol_Type;
    }

    public void SetEncoderFramesEnabled(boolean[] FrameEnabled, int OutputId) {
        for (int i = 0; i < 18; ++i) {
            this.EncoderFramesEnabled[OutputId][i] = FrameEnabled[i];
            this.prefs.putInt(REG_TELEGRAM + Integer.toString(OutputId) + Integer.toString(i), FrameEnabled[i] ? 1 : 0);
        }
    }

    public int GetEncoderFramesNumber() {
        int Frame_Nb = 0;
        for (String s : this.EncoderFramesNames) {
            if (s.equalsIgnoreCase("")) break;
            ++Frame_Nb;
        }
        return Frame_Nb;
    }

    public String GetEncoderFrameName(int FrameId) {
        return this.EncoderFramesNames[FrameId];
    }

    public boolean GetEncoderFrameEnable(int FrameId, int OutputId) {
        return this.EncoderFramesEnabled[OutputId][FrameId];
    }

    public void SetEncoderOptionsEnabled(boolean[] OptionEnabled, int OutputId) {
        for (int i = 0; i < 6; ++i) {
            this.EncoderOptionsEnabled[OutputId][i] = OptionEnabled[i];
            this.prefs.putInt(REG_OPTION + Integer.toString(OutputId) + Integer.toString(i), OptionEnabled[i] ? 1 : 0);
        }
    }

    public int GetEncoderOptionsNumber() {
        int Options_Nb = 0;
        for (String s : this.EncoderOptionsNames) {
            if (s.equalsIgnoreCase("")) break;
            ++Options_Nb;
        }
        return Options_Nb;
    }

    public String GetEncoderOptionName(int OptionId) {
        return this.EncoderOptionsNames[OptionId];
    }

    public boolean GetEncoderOptionEnable(int OptionId, int OutputId) {
        return this.EncoderOptionsEnabled[OutputId][OptionId];
    }

    public byte[] GetEncodedBinaryFrame() {
        return this.Encoded_Binary_Frame;
    }

    public int GetEncodedBinaryFrameLenght() {
        return this.Encoded_Binary_Frame_Lenght;
    }

    public String GetEncodedASCIIFrame() {
        return this.Encoded_ASCII_Frame;
    }

    public int GetEncodedASCIIFrameLenght() {
        return this.Encoded_ASCII_Frame_Lenght;
    }

    public void EncodeFrameInit() {
        this.Encoded_ASCII_Frame = "";
        this.Encoded_ASCII_Frame_Lenght = 0;
        this.Encoded_Binary_Frame_Lenght = 0;
        this.FrameAvailable = false;
    }

    public void EncodeFrameSetReady(String TmpASCIIFrame) {
        this.Encoded_ASCII_Frame = this.Encoded_ASCII_Frame + TmpASCIIFrame;
        this.Encoded_ASCII_Frame_Lenght += TmpASCIIFrame.length();
        for (int i = 0; i < this.Encoded_ASCII_Frame_Lenght; ++i) {
            this.Encoded_Binary_Frame[i] = (byte)this.Encoded_ASCII_Frame.charAt(i);
        }
        this.Encoded_Binary_Frame_Lenght = this.Encoded_ASCII_Frame_Lenght;
        this.FrameAvailable = true;
    }

    public void EncodeFrameSetReady(byte[] TmpBinaryFrame, int Lenght) {
        for (int i = 0; i < Lenght; ++i) {
            this.Encoded_Binary_Frame[this.Encoded_Binary_Frame_Lenght + i] = TmpBinaryFrame[i];
        }
        this.Encoded_Binary_Frame_Lenght += Lenght;
        this.FrameAvailable = true;
    }

    public boolean EncodeFrameIsAvailable() {
        return this.FrameAvailable;
    }

    public void SampleTime() {
        this.TIMETool.SampleTime();
    }

    public final void EncodeFrameFeTry(int OutputId) {
        this.Output_Id = OutputId;
        OutputFlowInfo _OutInfo = this.Info.OutputInfo[OutputId];
        this.GPS_Info = this.Info.ExtInfo[0][_OutInfo.Get_CurrentSensorId(0, 1)];
        this.DVL_Info = this.Info.ExtInfo[1][_OutInfo.Get_CurrentSensorId(1, 1)];
        this.USBL_Info = this.Info.ExtInfo[2][_OutInfo.Get_CurrentSensorId(2, 1)];
        this.LBL_Info = this.Info.ExtInfo[3][_OutInfo.Get_CurrentSensorId(3, 1)];
        this.CTD_Info = this.Info.ExtInfo[6][_OutInfo.Get_CurrentSensorId(6, 1)];
        this.DEPTH_Info = this.Info.ExtInfo[4][_OutInfo.Get_CurrentSensorId(4, 1)];
        this.EMLOG_Info = this.Info.ExtInfo[5][_OutInfo.Get_CurrentSensorId(5, 1)];
        this.GRAVI_Info = this.Info.ExtInfo[7][_OutInfo.Get_CurrentSensorId(7)];
        this.DMI_Info = this.Info.ExtInfo[9][_OutInfo.Get_CurrentSensorId(9, 1)];
        this.PLATFORM_Info = this.Info.ExtInfo[8][_OutInfo.Get_CurrentSensorId(8)];
        this.SIMSTIM_Info = this.Info.ExtInfo[10][_OutInfo.Get_CurrentSensorId(10)];
        this.DVLNTK_Info = this.Info.ExtInfo[11][_OutInfo.Get_CurrentSensorId(11)];
        this.EncodeFrameFe(OutputId);
    }

    public void EncodeFrameFe(int OutputId) {
    }

    public final void EncodeFrame1HzTry(int OutputId) {
        this.Output_Id = OutputId;
        OutputFlowInfo _OutInfo = this.Info.OutputInfo[OutputId];
        this.GPS_Info = this.Info.ExtInfo[0][_OutInfo.Get_CurrentSensorId(0, 1)];
        this.DVL_Info = this.Info.ExtInfo[1][_OutInfo.Get_CurrentSensorId(1, 1)];
        this.USBL_Info = this.Info.ExtInfo[2][_OutInfo.Get_CurrentSensorId(2, 1)];
        this.LBL_Info = this.Info.ExtInfo[3][_OutInfo.Get_CurrentSensorId(3, 1)];
        this.CTD_Info = this.Info.ExtInfo[6][_OutInfo.Get_CurrentSensorId(6, 1)];
        this.DEPTH_Info = this.Info.ExtInfo[4][_OutInfo.Get_CurrentSensorId(4, 1)];
        this.EMLOG_Info = this.Info.ExtInfo[5][_OutInfo.Get_CurrentSensorId(5, 1)];
        this.GRAVI_Info = this.Info.ExtInfo[7][_OutInfo.Get_CurrentSensorId(7)];
        this.PLATFORM_Info = this.Info.ExtInfo[8][_OutInfo.Get_CurrentSensorId(8)];
        this.ASCIITool.Initialize();
        this.BINTool.Initialize(1);
        this.EncodeFrame1Hz(OutputId);
    }

    public void EncodeFrame1Hz(int OutputId) {
    }
}

