/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import Tools.ASCII_EncodeTool;
import Tools.ConvertTool;

public class Protocol_AHRS_120_Encoder
extends ProtocolEncoder {
    private static final int GPRMC_TELEGRAM_INDEX = 0;
    private static final int SHORT_TELEGRAM_INDEX = 1;

    public Protocol_AHRS_120_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 1, _Info);
        this.EncoderFramesNames[0] = "GPRMC";
        this.EncoderFramesNames[1] = "SHORT Sentence";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        double Latitude;
        if (this.GetEncoderFrameEnable(0, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$GPRMC,");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetHours(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMinutes(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.FloatToASCII(this.TIMETool.GetSeconds(), 2, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat(this.GPS_Info.Get_Validity() == 1 ? "A," : "V,");
            Latitude = this.GPS_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Latitude < 0.0) {
                Latitude = -Latitude;
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",S,");
            } else {
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",N,");
            }
            double Longitude = this.GPS_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Longitude < 0.0) {
                Longitude = -Longitude;
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",W,");
            } else {
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",E,");
            }
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Speed(ConvertTool.UNITS.UNITE_KNOTS), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Course(ConvertTool.UNITS.UNITE_DEGREE), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetDayInMonth(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMonthInYear(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetYear() - 2000, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Course(ConvertTool.UNITS.UNITE_DEGREE), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",E");
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
        if (this.GetEncoderFrameEnable(1, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$");
            Latitude = this.GPS_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE);
            this.ASCIITool.Concat(Latitude >= 0.0 ? "N," : "S,");
            this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(",");
            this.ASCIITool.IntegerToASCII((int)this.GPS_Info.Get_Speed(ConvertTool.UNITS.UNITE_KNOTS), 2, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat("*\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
    }

    @Override
    public void EncodeFrame1Hz(int OutputId) {
    }
}

