/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import Tools.ASCII_EncodeTool;
import Tools.ConvertTool;

public class Protocol_INRMC_Encoder
extends ProtocolEncoder {
    private static final int INRMC_TELEGRAM_INDEX = 0;

    public Protocol_INRMC_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 1, _Info);
        this.EncoderFramesNames[0] = "INRMC Telegram";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        if (this.GetEncoderFrameEnable(0, OutputId)) {
            this.ASCIITool.Initialize();
            this.ASCIITool.Concat("$INRMC,");
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat(this.GPS_Info.Get_Validity() == 1 ? "A," : "V,");
            double Latitude = this.GPS_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Latitude < 0.0) {
                Latitude = -Latitude;
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",S,");
            } else {
                this.ASCIITool.IntegerToASCII((int)Latitude, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Latitude - (double)((int)Latitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",N,");
            }
            double Longitude = this.GPS_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE);
            if (Longitude < 0.0) {
                Longitude = -Longitude;
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",W,");
            } else {
                this.ASCIITool.IntegerToASCII((int)Longitude, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.FloatToASCII(60.0 * (Longitude - (double)((int)Longitude)), 2, 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(",E,");
            }
            this.ASCIITool.FloatToASCII(this.GPS_Info.Get_Speed(ConvertTool.UNITS.UNITE_KNOTS), 0, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat(",,");
            switch (this.GPS_Info.Get_OperatingMode()) {
                case 0: {
                    this.ASCIITool.Concat("A");
                    break;
                }
                case 1: {
                    this.ASCIITool.Concat("D");
                    break;
                }
                case 2: {
                    this.ASCIITool.Concat("E");
                    break;
                }
                case 3: {
                    this.ASCIITool.Concat("M");
                    break;
                }
                case 4: {
                    this.ASCIITool.Concat("N");
                    break;
                }
                default: {
                    this.ASCIITool.Concat("N");
                }
            }
            this.ASCIITool.NMEAChecksum();
            this.ASCIITool.Concat("\r\n");
            this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
        }
    }

    @Override
    public void EncodeFrame1Hz(int OutputId) {
    }
}

