/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import Tools.ConvertTool;

public class Protocol_IXSEA_AUV_Encoder
extends ProtocolEncoder {
    private static final int GPS_TELEGRAM = 0;
    private static final int UTC_TELEGRAM = 1;
    private static final int USBL_TELEGRAM = 2;
    private static final int DEPTH_TELEGRAM = 3;
    private static final int LBL_TELEGRAM = 4;
    private static final int BT_TELEGRAM = 5;
    private static final int WT_TELEGRAM = 6;

    public Protocol_IXSEA_AUV_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 0, _Info);
        this.EncoderFramesNames[0] = "GPS Telegram";
        this.EncoderFramesNames[1] = "UTC Telegram";
        this.EncoderFramesNames[2] = "USBL Telegram";
        this.EncoderFramesNames[3] = "DEPTH Telegram";
        this.EncoderFramesNames[4] = "LBL Telegram";
        this.EncoderFramesNames[5] = "Ground Speed Telegram";
        this.EncoderFramesNames[6] = "Water Speed Telegram";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        int i;
        if (this.GetEncoderFrameEnable(0, OutputId)) {
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(36);
            this.BINTool.Byte_to_1UINT8(48);
            if (this.Info.OutputInfo[OutputId].Get_CurrentSensorId(0) < 2) {
                this.BINTool.Byte_to_1UINT8(this.Info.OutputInfo[OutputId].Get_CurrentSensorId(0) + 1);
            } else {
                this.BINTool.Byte_to_1UINT8(3);
            }
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.DWord_to_4UINT8((long)this.TIMETool.GetTime_100US());
            this.BINTool.Byte_to_1UINT8(this.GPS_Info.Get_Quality());
            this.BINTool.Long_to_4UINT8((long)(this.GPS_Info.Get_Latitude(ConvertTool.UNITS.UNITE_RADIAN) / Math.PI * Math.pow(2.0, 31.0)));
            this.BINTool.Long_to_4UINT8((long)(this.GPS_Info.Get_Longitude(ConvertTool.UNITS.UNITE_RADIAN) / Math.PI * Math.pow(2.0, 31.0)));
            this.BINTool.Float_to_4UINT8(this.GPS_Info.Get_Altitude(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.GPS_Info.Get_LatitudeStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.GPS_Info.Get_LongitudeStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.GPS_Info.Get_AltitudeStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Byte_to_1UINT8(this.GPS_Info.Get_Validity());
            this.BINTool.Float_to_4UINT8(this.GPS_Info.Get_LatLongCov(ConvertTool.UNITS.UNITE_M2));
            this.BINTool.Float_to_4UINT8(this.GPS_Info.Get_Latency(ConvertTool.UNITS.UNITE_S));
            this.BINTool.Float_to_4UINT8(this.GPS_Info.Get_GeoidalSep(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Add2BytesChecksum();
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
        if (this.GetEncoderFrameEnable(1, OutputId)) {
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(36);
            this.BINTool.Byte_to_1UINT8(14);
            this.BINTool.Byte_to_1UINT8(4);
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.DWord_to_4UINT8((long)this.TIMETool.GetTime_100US());
            this.BINTool.Byte_to_1UINT8(this.TIMETool.GetDayInMonth());
            this.BINTool.Byte_to_1UINT8(this.TIMETool.GetMonthInYear());
            this.BINTool.Word_to_2UINT8(this.TIMETool.GetYear() - 2000);
            this.BINTool.Add2BytesChecksum();
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
        if (this.GetEncoderFrameEnable(2, OutputId)) {
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(36);
            this.BINTool.Byte_to_1UINT8(49);
            this.BINTool.Byte_to_1UINT8(5);
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.DWord_to_4UINT8((long)this.TIMETool.GetTime_100US());
            for (i = 0; i < 6; ++i) {
                if (i < this.USBL_Info.Get_BeaconCodeId().length()) {
                    this.BINTool.Byte_to_1UINT8((byte)this.USBL_Info.Get_BeaconCodeId().charAt(i));
                    continue;
                }
                this.BINTool.Byte_to_1UINT8(0);
            }
            this.BINTool.Long_to_4UINT8((long)(this.USBL_Info.Get_Latitude(ConvertTool.UNITS.UNITE_RADIAN) / Math.PI * Math.pow(2.0, 31.0)));
            this.BINTool.Long_to_4UINT8((long)(this.USBL_Info.Get_Longitude(ConvertTool.UNITS.UNITE_RADIAN) / Math.PI * Math.pow(2.0, 31.0)));
            this.BINTool.Float_to_4UINT8(this.USBL_Info.Get_Latency(ConvertTool.UNITS.UNITE_S));
            this.BINTool.Float_to_4UINT8(this.USBL_Info.Get_Depth(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.USBL_Info.Get_LatitudeStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.USBL_Info.Get_LongitudeStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.USBL_Info.Get_LatLongCov(ConvertTool.UNITS.UNITE_M2));
            this.BINTool.Float_to_4UINT8(this.USBL_Info.Get_DepthStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Byte_to_1UINT8(this.USBL_Info.Get_Validity());
            this.BINTool.Add2BytesChecksum();
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
        if (this.GetEncoderFrameEnable(3, OutputId)) {
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(36);
            this.BINTool.Byte_to_1UINT8(23);
            this.BINTool.Byte_to_1UINT8(6);
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.DWord_to_4UINT8((long)this.TIMETool.GetTime_100US());
            this.BINTool.Float_to_4UINT8(this.DEPTH_Info.Get_Depth(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.DEPTH_Info.Get_DepthStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Byte_to_1UINT8(this.DEPTH_Info.Get_Validity());
            this.BINTool.Float_to_4UINT8(this.DEPTH_Info.Get_Latency(ConvertTool.UNITS.UNITE_S));
            this.BINTool.Add2BytesChecksum();
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
        if (this.GetEncoderFrameEnable(4, OutputId)) {
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(36);
            this.BINTool.Byte_to_1UINT8(41);
            this.BINTool.Byte_to_1UINT8(7);
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.DWord_to_4UINT8((long)this.TIMETool.GetTime_100US());
            for (i = 0; i < 6; ++i) {
                if (i < this.LBL_Info.Get_BeaconCodeId().length()) {
                    this.BINTool.Byte_to_1UINT8((byte)this.LBL_Info.Get_BeaconCodeId().charAt(i));
                    continue;
                }
                this.BINTool.Byte_to_1UINT8(0);
            }
            this.BINTool.Long_to_4UINT8((long)(this.LBL_Info.Get_Latitude(ConvertTool.UNITS.UNITE_RADIAN) / Math.PI * Math.pow(2.0, 31.0)));
            this.BINTool.Long_to_4UINT8((long)(this.LBL_Info.Get_Longitude(ConvertTool.UNITS.UNITE_RADIAN) / Math.PI * Math.pow(2.0, 31.0)));
            this.BINTool.Float_to_4UINT8(-this.LBL_Info.Get_Depth(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.LBL_Info.Get_Range(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.LBL_Info.Get_Latency(ConvertTool.UNITS.UNITE_S));
            this.BINTool.Float_to_4UINT8(this.LBL_Info.Get_RangeStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Byte_to_1UINT8(this.LBL_Info.Get_Validity());
            this.BINTool.Add2BytesChecksum();
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
        if (this.GetEncoderFrameEnable(5, OutputId)) {
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(36);
            this.BINTool.Byte_to_1UINT8(51);
            this.BINTool.Byte_to_1UINT8(8);
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.DWord_to_4UINT8((long)this.TIMETool.GetTime_100US());
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_BT_XS1Speed(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_BT_XS2Speed(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_BT_XS3Speed(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_BT_SoundSpeed(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.CTD_Info.Get_SoundSpeed(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_BT_Altitude(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_BT_XS1SpeedStd(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_BT_XS2SpeedStd(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_BT_XS3SpeedStd(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Byte_to_1UINT8(this.DVL_Info.Get_BT_Validity());
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_BT_Latency(ConvertTool.UNITS.UNITE_S));
            this.BINTool.Add2BytesChecksum();
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
        if (this.GetEncoderFrameEnable(6, OutputId)) {
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(36);
            this.BINTool.Byte_to_1UINT8(51);
            this.BINTool.Byte_to_1UINT8(9);
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.DWord_to_4UINT8((long)this.TIMETool.GetTime_100US());
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_WT_XS1Speed(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_WT_XS2Speed(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_WT_XS3Speed(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_WT_SoundSpeed(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.CTD_Info.Get_SoundSpeed(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_WT_Altitude(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_WT_XS1SpeedStd(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_WT_XS2SpeedStd(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_WT_XS3SpeedStd(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Byte_to_1UINT8(this.DVL_Info.Get_WT_Validity());
            this.BINTool.Float_to_4UINT8(this.DVL_Info.Get_WT_Latency(ConvertTool.UNITS.UNITE_S));
            this.BINTool.Add2BytesChecksum();
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
    }

    @Override
    public void EncodeFrame1Hz(int OutputId) {
        if (this.GetEncoderFrameEnable(1, OutputId)) {
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(36);
            this.BINTool.Byte_to_1UINT8(14);
            this.BINTool.Byte_to_1UINT8(4);
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.DWord_to_4UINT8((long)this.TIMETool.GetTime_100US());
            this.BINTool.Byte_to_1UINT8(this.TIMETool.GetDayInMonth());
            this.BINTool.Byte_to_1UINT8(this.TIMETool.GetMonthInYear());
            this.BINTool.Word_to_2UINT8(this.TIMETool.GetYear());
            this.BINTool.Add2BytesChecksum();
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
    }
}

