/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import Tools.ConvertTool;

public class Protocol_RAMSES_POSTPRO_Encoder
extends ProtocolEncoder {
    private static final int BEACON_POS = 0;
    private static final int BEACON_RANGE = 1;
    private static final int CTD = 2;

    public Protocol_RAMSES_POSTPRO_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 0, _Info);
        this.EncoderFramesNames[0] = "Beacon slam position";
        this.EncoderFramesNames[1] = "Beacon slant range";
        this.EncoderFramesNames[2] = "Sound velocity & pressure";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        if (this.GetEncoderFrameEnable(0, OutputId)) {
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(36);
            this.BINTool.Byte_to_1UINT8(44);
            this.BINTool.Byte_to_1UINT8(52);
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.DWord_to_4UINT8(this.TIMETool.GetCurrentEpochTime());
            this.BINTool.DWord_to_4UINT8(0L);
            this.BINTool.Byte_to_1UINT8(0);
            this.BINTool.Long_to_4UINT8((long)(this.USBL_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE) / 180.0 * Math.pow(2.0, 31.0)));
            this.BINTool.Long_to_4UINT8((long)(this.USBL_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE) / 180.0 * Math.pow(2.0, 31.0)));
            this.BINTool.Float_to_4UINT8(this.USBL_Info.Get_Depth(ConvertTool.UNITS.UNITE_M));
            if (this.USBL_Info.Get_Validity() == 1) {
                this.BINTool.Byte_to_1UINT8(3);
            } else {
                this.BINTool.Byte_to_1UINT8(0);
            }
            this.BINTool.Float_to_4UINT8(this.USBL_Info.Get_LatitudeStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.USBL_Info.Get_LongitudeStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.USBL_Info.Get_DepthStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.USBL_Info.Get_LatLongCov(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Add2BytesChecksum();
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
        if (this.GetEncoderFrameEnable(1, OutputId)) {
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(36);
            this.BINTool.Byte_to_1UINT8(42);
            this.BINTool.Byte_to_1UINT8(53);
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.DWord_to_4UINT8(this.TIMETool.GetCurrentEpochTime());
            this.BINTool.DWord_to_4UINT8(0L);
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.Byte_to_1UINT8(0);
            this.BINTool.Byte_to_1UINT8(0);
            this.BINTool.Long_to_4UINT8((long)(this.LBL_Info.Get_Latitude(ConvertTool.UNITS.UNITE_DEGREE) / 180.0 * Math.pow(2.0, 31.0)));
            this.BINTool.Long_to_4UINT8((long)(this.LBL_Info.Get_Longitude(ConvertTool.UNITS.UNITE_DEGREE) / 180.0 * Math.pow(2.0, 31.0)));
            this.BINTool.Float_to_4UINT8(this.LBL_Info.Get_Depth(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.LBL_Info.Get_Range(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8(this.LBL_Info.Get_RangeStd(ConvertTool.UNITS.UNITE_M));
            this.BINTool.Float_to_4UINT8((long)this.LBL_Info.Get_Latency(ConvertTool.UNITS.UNITE_S));
            if (this.LBL_Info.Get_Validity() == 1) {
                this.BINTool.Byte_to_1UINT8(4);
            } else {
                this.BINTool.Byte_to_1UINT8(0);
            }
            this.BINTool.Add2BytesChecksum();
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
        if (this.GetEncoderFrameEnable(2, OutputId)) {
            this.BINTool.Initialize(1);
            this.BINTool.Byte_to_1UINT8(36);
            this.BINTool.Byte_to_1UINT8(31);
            this.BINTool.Byte_to_1UINT8(55);
            this.BINTool.Byte_to_1UINT8(1);
            this.BINTool.DWord_to_4UINT8(this.TIMETool.GetCurrentEpochTime());
            this.BINTool.DWord_to_4UINT8(0L);
            this.BINTool.Byte_to_1UINT8(0);
            this.BINTool.Float_to_4UINT8(0.0);
            this.BINTool.Float_to_4UINT8(this.CTD_Info.Get_Pressure(ConvertTool.UNITS.UNITE_DBAR));
            this.BINTool.Float_to_4UINT8(0.0);
            this.BINTool.Float_to_4UINT8(this.CTD_Info.Get_SoundSpeed(ConvertTool.UNITS.UNITE_M_S));
            this.BINTool.Add2BytesChecksum();
            this.EncodeFrameSetReady(this.BINTool.GetBinaryFrame(), this.BINTool.GetBinaryFrameLenght());
        }
    }

    @Override
    public void EncodeFrame1Hz(int OutputId) {
    }
}

