/*
 * Decompiled with CFR 0.152.
 */
package EncoderPackage;

import EncoderPackage.ProtocolEncoder;
import InfosPackage.SimulatorInfo;
import Tools.ASCII_EncodeTool;
import Tools.ConvertTool;

public class Protocol_SBE37_Encoder
extends ProtocolEncoder {
    private static final int FORMAT1_TELEGRAM_INDEX = 0;
    private static final int FORMAT2_TELEGRAM_INDEX = 1;
    private static final int FORMAT3_TELEGRAM_INDEX = 2;
    private static final int FORMAT4_TELEGRAM_INDEX = 3;

    public Protocol_SBE37_Encoder(String ProtoName, SimulatorInfo _Info) {
        super(ProtoName);
        super.Init(ProtoName, 1, _Info);
        this.EncoderFramesNames[0] = "Format 1";
        this.EncoderFramesNames[1] = "Format 2";
        this.EncoderFramesNames[2] = "Format 3";
        this.EncoderFramesNames[3] = "Format 4";
    }

    @Override
    public void EncodeFrameFe(int OutputId) {
        for (int i = 0; i <= 3; ++i) {
            if (!this.GetEncoderFrameEnable(i, OutputId)) continue;
            this.Generate_Formats(i);
        }
    }

    @Override
    public void EncodeFrame1Hz(int OutputId) {
    }

    private void Generate_Formats(int OutputFormat) {
        this.ASCIITool.Initialize();
        this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Temperature(ConvertTool.UNITS.UNITE_DEGCEL), 3, 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
        this.ASCIITool.Concat(",");
        this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Conductivity(ConvertTool.UNITS.UNITE_S_m), 3, 5, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
        this.ASCIITool.Concat(",");
        this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Pressure(ConvertTool.UNITS.UNITE_DBAR), 4, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
        if (OutputFormat == 0 || OutputFormat == 1 || OutputFormat == 2) {
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Depth(ConvertTool.UNITS.UNITE_M), 3, 5, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_Salinity(ConvertTool.UNITS.UNITE_PSU), 3, 4, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
            this.ASCIITool.Concat(",");
            this.ASCIITool.FloatToASCII(this.CTD_Info.Get_SoundSpeed(ConvertTool.UNITS.UNITE_M_S), 4, 3, ASCII_EncodeTool.SIGNS.SIGN_MINUS);
        }
        if (OutputFormat == 0 || OutputFormat == 1) {
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat("000.0000,");
            if (OutputFormat == 0) {
                this.ASCIITool.IntegerToASCII(this.TIMETool.GetDayInMonth(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(" ");
                this.ASCIITool.IntegerToASCII(this.TIMETool.GetMonthInYear(), 3, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat(" ");
                this.ASCIITool.IntegerToASCII(this.TIMETool.GetYear(), 4, ASCII_EncodeTool.SIGNS.SIGN_NO);
            } else {
                this.ASCIITool.IntegerToASCII(this.TIMETool.GetMonthInYear(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat("-");
                this.ASCIITool.IntegerToASCII(this.TIMETool.GetDayInMonth(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
                this.ASCIITool.Concat("-");
                this.ASCIITool.IntegerToASCII(this.TIMETool.GetYear(), 4, ASCII_EncodeTool.SIGNS.SIGN_NO);
            }
            this.ASCIITool.Concat(",");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetHours(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(":");
            this.ASCIITool.IntegerToASCII(this.TIMETool.GetMinutes(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
            this.ASCIITool.Concat(":");
            this.ASCIITool.IntegerToASCII((int)this.TIMETool.GetSeconds(), 2, ASCII_EncodeTool.SIGNS.SIGN_NO);
        } else if (OutputFormat == 2) {
            this.ASCIITool.Concat(",");
            this.ASCIITool.Concat("N,N,N");
        }
        this.ASCIITool.Concat("\r\n");
        this.EncodeFrameSetReady(this.ASCIITool.GetASCIIFrame());
    }
}

