/*
 * Decompiled with CFR 0.152.
 */
package FlowReaderWriterPackage;

import FlowReaderWriterPackage.FlowReaderWriter;
import InfosPackage.OutputFlowInfo;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FlowSerialReaderWriter
extends FlowReaderWriter {
    private CommPortIdentifier portId = null;
    private SerialPort port = null;

    public FlowSerialReaderWriter(OutputFlowInfo _FlowInfo) {
        super.FlowReaderWriter(_FlowInfo);
    }

    @Override
    public int TryConnect() {
        String Nom_Port = this.Info.GetSerialPort();
        try {
            this.portId = CommPortIdentifier.getPortIdentifier(Nom_Port);
        }
        catch (NoSuchPortException ex) {
            return 1;
        }
        try {
            this.port = (SerialPort)this.portId.open("Simulator", 3);
        }
        catch (PortInUseException ex) {
            return 1;
        }
        try {
            int Parity;
            int Stopbits;
            int Databits;
            int Baudrate;
            this.port.setFlowControlMode(0);
            switch (this.Info.GetBaudrate()) {
                case 0: {
                    Baudrate = 600;
                    break;
                }
                case 1: {
                    Baudrate = 1200;
                    break;
                }
                case 2: {
                    Baudrate = 2400;
                    break;
                }
                case 3: {
                    Baudrate = 4800;
                    break;
                }
                case 4: {
                    Baudrate = 9600;
                    break;
                }
                case 5: {
                    Baudrate = 19200;
                    break;
                }
                case 6: {
                    Baudrate = 38400;
                    break;
                }
                case 7: {
                    Baudrate = 57600;
                    break;
                }
                case 8: {
                    Baudrate = 115200;
                    break;
                }
                case 9: {
                    Baudrate = 230400;
                    break;
                }
                case 10: {
                    Baudrate = 460800;
                    break;
                }
                default: {
                    Baudrate = 9600;
                }
            }
            switch (this.Info.GetDataBits()) {
                case 0: {
                    Databits = 7;
                    break;
                }
                case 1: {
                    Databits = 8;
                    break;
                }
                default: {
                    Databits = 8;
                }
            }
            switch (this.Info.GetStopBits()) {
                case 2: {
                    Stopbits = 1;
                    break;
                }
                case 3: {
                    Stopbits = 2;
                    break;
                }
                default: {
                    Stopbits = 1;
                }
            }
            switch (this.Info.GetParity()) {
                case 0: {
                    Parity = 0;
                    break;
                }
                case 1: {
                    Parity = 2;
                    break;
                }
                case 2: {
                    Parity = 1;
                    break;
                }
                default: {
                    Parity = 0;
                }
            }
            this.port.setSerialPortParams(Baudrate, Databits, Stopbits, Parity);
        }
        catch (UnsupportedCommOperationException ex) {
            return 1;
        }
        try {
            this._InputStream = this.port.getInputStream();
            this._BufferedInputStream = new BufferedInputStream(this._InputStream);
            this._DataInputStream = new DataInputStream(this._BufferedInputStream);
            this._OutputStream = this.port.getOutputStream();
            this._BufferedOutputStream = new BufferedOutputStream(this._OutputStream);
            this._DataOutputStream = new DataOutputStream(this._BufferedOutputStream);
        }
        catch (IOException e) {
            return 1;
        }
        this.port.notifyOnDataAvailable(true);
        return 0;
    }

    @Override
    public int TryDisconnect() {
        if (this.port != null) {
            this.port.close();
        }
        this.port = null;
        return 1;
    }

    @Override
    public int FlowWrite(byte[] Bytes_Write, int Lenght) {
        int Nb_Bytes = 0;
        try {
            this._OutputStream.write(Bytes_Write, 0, Lenght);
            Nb_Bytes = Lenght;
        }
        catch (Exception e) {
            Nb_Bytes = -1;
            System.out.println("FlowWrite: Write Exception");
        }
        return Nb_Bytes;
    }
}

