/*
 * Decompiled with CFR 0.152.
 */
package InfosPackage;

import SimulatorPackage.Protocols_List;
import java.awt.Color;
import java.util.prefs.Preferences;

public class OutputFlowInfo {
    Preferences prefs;
    int FlowId = 0;
    int FlowType = 0;
    int Protocole = 0;
    int Rate = 3;
    int Rate_Custom = 100;
    int EthConnType = 0;
    String IPAdress = new String("192.168.36.122");
    String IPPort = new String("8100");
    String RSPort = new String("COM1");
    int Baudrate_Id = 4;
    int Databits_Id = 1;
    int Parity_Id = 0;
    int StopBits_Id = 0;
    boolean Scrambling_ON = false;
    int[] Sensor_Ids;
    int[] Sensor_CurrentId;
    int SentFrameNb1Hz = 0;
    int SentFrameNbFe = 0;
    public static final int SIMU_MODE_DISABLED = 0;
    public static final int SIMU_MODE_ENABLED = 1;
    public static final int FLOW_NONE = 0;
    public static final int ETHERNET_FLOW = 1;
    public static final int SERIAL_FLOW = 2;
    public static final int FLOW_ENABLE = 1;
    public static final int FLOW_DISABLE = 0;
    public static final int BAUDRATE_600 = 0;
    public static final int BAUDRATE_1200 = 1;
    public static final int BAUDRATE_2400 = 2;
    public static final int BAUDRATE_4800 = 3;
    public static final int BAUDRATE_9600 = 4;
    public static final int BAUDRATE_19200 = 5;
    public static final int BAUDRATE_38400 = 6;
    public static final int BAUDRATE_57600 = 7;
    public static final int BAUDRATE_115200 = 8;
    public static final int BAUDRATE_230400 = 9;
    public static final int BAUDRATE_460800 = 10;
    public static final int DATABITS_7 = 0;
    public static final int DATABITS_8 = 1;
    public static final int Parity_NONE = 0;
    public static final int Parity_EVEN = 1;
    public static final int Parity_ODD = 2;
    public static final int StopBit_None = 0;
    public static final int StopBit_05 = 1;
    public static final int StopBit_1 = 2;
    public static final int StopBit_2 = 3;
    public static final int TCP_CLIENT = 0;
    public static final int TCP_SERVEUR = 1;
    public static final int UDP = 2;
    public static final int UDP_MULTICAST = 3;
    public static final int RATE_01HZ = 0;
    public static final int RATE_02HZ = 1;
    public static final int RATE_05HZ = 2;
    public static final int RATE_1HZ = 3;
    public static final int RATE_2HZ = 4;
    public static final int RATE_5HZ = 5;
    public static final int RATE_10HZ = 6;
    public static final int RATE_CUSTOM = 7;
    private static final String REG_OUT_FLOW_TYPE = "outputflowtype";
    private static final String REG_OUT_PROTO_ID = "outputprotocole";
    private static final String REG_OUT_RATE = "outputrate";
    private static final String REG_OUT_RATE_CUSTOM = "outputratecustom";
    private static final String REG_OUT_ETHCONNTYPE = "ethoutconntype";
    private static final String REG_OUT_IPADRESS = "ethoutipadress";
    private static final String REG_OUT_IPPORT = "ethoutipport";
    private static final String REG_OUT_SERIALPORT = "seroutport";
    private static final String REG_OUT_BAUDRATE = "seroutbaudrate";
    private static final String REG_OUT_DATABITS = "seroutdatabits";
    private static final String REG_OUT_PARITY = "seroutparity";
    private static final String REG_OUT_STOPBITS = "seroutstop";
    private static final String REG_OUT_GPS_ID = "gpsid";
    private static final String REG_OUT_USBL_ID = "usblid";
    private static final String REG_OUT_LBL_ID = "lblid";
    private static final String REG_OUT_EMLOG_ID = "emlogid";
    private static final String REG_OUT_DVL_ID = "dvlid";

    public OutputFlowInfo(int _FlowId) {
        this.FlowId = _FlowId;
        this.Sensor_Ids = new int[12];
        this.Sensor_CurrentId = new int[12];
        this.prefs = Preferences.userRoot().node("ixsea/genericsimulator/outputs/" + Integer.toString(this.FlowId));
        this.SetFlowType(this.prefs.getInt(REG_OUT_FLOW_TYPE, 0));
        this.SetProtocole(this.prefs.getInt(REG_OUT_PROTO_ID, 0), this.prefs.getInt(REG_OUT_RATE, 3), this.prefs.getInt(REG_OUT_RATE_CUSTOM, 100));
        this.SetEthernetParam(this.prefs.getInt(REG_OUT_ETHCONNTYPE, 0), this.prefs.get(REG_OUT_IPADRESS, "192.168.36.12" + Integer.toString(this.FlowId)), this.prefs.get(REG_OUT_IPPORT, "812" + Integer.toString(this.FlowId)));
        this.SetSerialParam(this.prefs.get(REG_OUT_SERIALPORT, "COM1"), this.prefs.getInt(REG_OUT_BAUDRATE, 5), this.prefs.getInt(REG_OUT_DATABITS, 1), this.prefs.getInt(REG_OUT_PARITY, 0), this.prefs.getInt(REG_OUT_STOPBITS, 2));
        this.Set_SensorId(this.prefs.getInt(REG_OUT_GPS_ID, 0), this.prefs.getInt(REG_OUT_USBL_ID, 0), this.prefs.getInt(REG_OUT_LBL_ID, 0), this.prefs.getInt(REG_OUT_EMLOG_ID, 0), this.prefs.getInt(REG_OUT_DVL_ID, 0));
        this.Sensor_CurrentId[0] = 0;
        this.Sensor_CurrentId[2] = 0;
        this.Sensor_CurrentId[3] = 0;
        this.Sensor_CurrentId[5] = 0;
        this.Sensor_CurrentId[1] = 0;
        this.Sensor_CurrentId[6] = 0;
        this.Sensor_CurrentId[4] = 0;
        this.Sensor_CurrentId[7] = 0;
        this.Sensor_CurrentId[8] = 0;
    }

    public void SetOutputParams(int FlowType, int ProtocoleId, int Rate, int Rate_Custom, int EthConnType, String IP, String Port, String RSPort, int Baudrate, int Databits, int Parity, int Stopbits, boolean Scrambling) {
        this.SetFlowType(FlowType);
        this.SetProtocole(ProtocoleId, Rate, Rate_Custom);
        this.SetEthernetParam(EthConnType, IP, Port);
        this.SetSerialParam(RSPort, Baudrate, Databits, Parity, Stopbits);
        this.SetScrambling(Scrambling);
    }

    public void SetFlowType(int _FlowType) {
        this.FlowType = _FlowType;
        this.prefs.putInt(REG_OUT_FLOW_TYPE, _FlowType);
    }

    public int GetFlowType() {
        return this.FlowType;
    }

    public int GetFlowEnabled() {
        if (this.FlowType == 0 || this.Protocole == 0) {
            return 0;
        }
        return 1;
    }

    public void SetProtocole(int _Protocole, int _Rate, int _Rate_Custom) {
        this.Protocole = _Protocole;
        this.Rate = _Rate;
        this.Rate_Custom = _Rate_Custom;
        this.prefs.putInt(REG_OUT_PROTO_ID, _Protocole);
        this.prefs.putInt(REG_OUT_RATE, _Rate);
        this.prefs.putInt(REG_OUT_RATE_CUSTOM, _Rate_Custom);
    }

    public int GetProtocole() {
        return this.Protocole;
    }

    public int GetRate() {
        return this.Rate;
    }

    public int GetRateCustom() {
        return this.Rate_Custom;
    }

    public int GetRate_ms() {
        switch (this.Rate) {
            case 0: {
                return 10000;
            }
            case 1: {
                return 5000;
            }
            case 2: {
                return 2000;
            }
            case 3: {
                return 1000;
            }
            case 4: {
                return 500;
            }
            case 5: {
                return 200;
            }
            case 6: {
                return 100;
            }
            case 7: {
                return this.Rate_Custom;
            }
        }
        return 1000;
    }

    public void SetEthernetParam(int _EthConnType, String _IPAdress, String _IPPort) {
        this.EthConnType = _EthConnType;
        this.IPAdress = _IPAdress;
        this.IPPort = _IPPort;
        this.prefs.putInt(REG_OUT_ETHCONNTYPE, _EthConnType);
        this.prefs.put(REG_OUT_IPADRESS, _IPAdress);
        this.prefs.put(REG_OUT_IPPORT, _IPPort);
    }

    public int GetEthernetConnType() {
        return this.EthConnType;
    }

    public String GetEthernetIPAdress() {
        return this.IPAdress;
    }

    public String GetEthernetIPPort() {
        return this.IPPort;
    }

    public void SetSerialParam(String _RSPort, int _Baudrate, int _DataBits, int _Parity, int _StopBits) {
        this.RSPort = _RSPort;
        this.Baudrate_Id = _Baudrate;
        this.Databits_Id = _DataBits;
        this.Parity_Id = _Parity;
        this.StopBits_Id = _StopBits;
        this.prefs.put(REG_OUT_SERIALPORT, _RSPort);
        this.prefs.putInt(REG_OUT_BAUDRATE, _Baudrate);
        this.prefs.putInt(REG_OUT_DATABITS, _DataBits);
        this.prefs.putInt(REG_OUT_PARITY, _Parity);
        this.prefs.putInt(REG_OUT_STOPBITS, _StopBits);
    }

    public String GetSerialPort() {
        return this.RSPort;
    }

    public int GetBaudrate() {
        return this.Baudrate_Id;
    }

    public int GetDataBits() {
        return this.Databits_Id;
    }

    public int GetParity() {
        return this.Parity_Id;
    }

    public int GetStopBits() {
        return this.StopBits_Id;
    }

    public void SetScrambling(boolean Scrambling) {
        this.Scrambling_ON = Scrambling;
    }

    public boolean GetScrambling() {
        return this.Scrambling_ON;
    }

    public void Set_SensorId(int _GPS_Id, int _USBL_Id, int _LBL_Id, int _EMLOG_Id, int _DVL_Id) {
        this.Sensor_Ids[0] = _GPS_Id;
        this.Sensor_Ids[2] = _USBL_Id;
        this.Sensor_Ids[3] = _LBL_Id;
        this.Sensor_Ids[5] = _EMLOG_Id;
        this.Sensor_Ids[1] = _DVL_Id;
        this.Sensor_Ids[6] = 0;
        this.Sensor_Ids[4] = 0;
        this.Sensor_Ids[7] = 0;
        this.Sensor_Ids[8] = 0;
        this.prefs.putInt(REG_OUT_GPS_ID, _GPS_Id);
        this.prefs.putInt(REG_OUT_USBL_ID, _USBL_Id);
        this.prefs.putInt(REG_OUT_LBL_ID, _LBL_Id);
        this.prefs.putInt(REG_OUT_EMLOG_ID, _EMLOG_Id);
        this.prefs.putInt(REG_OUT_DVL_ID, _DVL_Id);
    }

    public int Get_SelectedSensorId(int Sensor_Type) {
        return this.Sensor_Ids[Sensor_Type];
    }

    public int Get_CurrentSensorId(int Sensor_Type) {
        return this.Get_CurrentSensorId(Sensor_Type, 0);
    }

    public int Get_CurrentSensorId(int Sensor_Type, int update_index) {
        if (this.Sensor_Ids[Sensor_Type] < 4) {
            return this.Sensor_Ids[Sensor_Type];
        }
        if (update_index == 1) {
            int n = Sensor_Type;
            this.Sensor_CurrentId[n] = this.Sensor_CurrentId[n] + 1;
            if (this.Sensor_CurrentId[n] >= 4) {
                this.Sensor_CurrentId[Sensor_Type] = 0;
            }
        }
        return this.Sensor_CurrentId[Sensor_Type];
    }

    public String GetFlow_ProtocolInfo(Protocols_List Proto_List) {
        String Info = new String("");
        if (this.GetFlowEnabled() == 0) {
            Info = Info + "Disabled";
        } else {
            Info = Info + Proto_List.GetProtocolNameById(this.Protocole);
            Info = Info + " - ";
            switch (this.Rate) {
                case 0: {
                    Info = Info + "0.1Hz (10s)";
                    break;
                }
                case 1: {
                    Info = Info + "0.2Hz (5s)";
                    break;
                }
                case 2: {
                    Info = Info + "0.5Hz (2s)";
                    break;
                }
                case 3: {
                    Info = Info + "1Hz (1s)";
                    break;
                }
                case 4: {
                    Info = Info + "2Hz (500ms)";
                    break;
                }
                case 5: {
                    Info = Info + "5Hz (200ms)";
                    break;
                }
                case 6: {
                    Info = Info + "10Hz (100ms)";
                    break;
                }
                case 7: {
                    Info = Info + "Custom: " + Integer.toString(this.Rate_Custom) + "ms";
                    break;
                }
                default: {
                    Info = Info + "undefined";
                }
            }
        }
        return Info;
    }

    public String GetFlow_InterfaceInfo(Protocols_List Proto_List) {
        String Info = new String("");
        if (this.GetFlowEnabled() == 0) {
            Info = Info + "None";
        } else {
            switch (this.FlowType) {
                case 0: {
                    Info = Info + "None";
                    break;
                }
                case 1: {
                    Info = Info + "Ethernet  [";
                    switch (this.EthConnType) {
                        case 0: {
                            Info = Info + " TCP Client";
                            break;
                        }
                        case 1: {
                            Info = Info + " TCP Serveur";
                            break;
                        }
                        case 2: {
                            Info = Info + " UDP";
                            break;
                        }
                        case 3: {
                            Info = Info + " UDP MultiCast";
                            break;
                        }
                        default: {
                            Info = Info + "undefined";
                        }
                    }
                    if (this.EthConnType != 1) {
                        Info = Info + " - ";
                        Info = Info + this.IPAdress;
                    }
                    Info = Info + " - ";
                    Info = Info + this.IPPort;
                    Info = Info + " ]";
                    break;
                }
                case 2: {
                    Info = Info + "Serial  [ ";
                    Info = Info + this.RSPort;
                    Info = Info + " - ";
                    switch (this.Baudrate_Id) {
                        case 0: {
                            Info = Info + " 600";
                            break;
                        }
                        case 1: {
                            Info = Info + " 1200";
                            break;
                        }
                        case 2: {
                            Info = Info + " 2400";
                            break;
                        }
                        case 3: {
                            Info = Info + " 4800";
                            break;
                        }
                        case 4: {
                            Info = Info + " 9600";
                            break;
                        }
                        case 5: {
                            Info = Info + " 19200";
                            break;
                        }
                        case 6: {
                            Info = Info + " 38400";
                            break;
                        }
                        case 7: {
                            Info = Info + " 57600";
                            break;
                        }
                        case 8: {
                            Info = Info + " 115200";
                            break;
                        }
                        case 9: {
                            Info = Info + " 230400";
                            break;
                        }
                        case 10: {
                            Info = Info + " 460800";
                            break;
                        }
                        default: {
                            Info = Info + "undefined";
                        }
                    }
                    Info = Info + " - ";
                    switch (this.Databits_Id) {
                        case 0: {
                            Info = Info + "7";
                            break;
                        }
                        case 1: {
                            Info = Info + "8";
                            break;
                        }
                        default: {
                            Info = Info + "undefined";
                        }
                    }
                    Info = Info + " - ";
                    switch (this.Parity_Id) {
                        case 1: {
                            Info = Info + "Even";
                            break;
                        }
                        case 2: {
                            Info = Info + "Odd";
                            break;
                        }
                        case 0: {
                            Info = Info + "No";
                            break;
                        }
                        default: {
                            Info = Info + "undefined";
                        }
                    }
                    Info = Info + " - ";
                    switch (this.StopBits_Id) {
                        case 1: {
                            Info = Info + "0.5";
                            break;
                        }
                        case 2: {
                            Info = Info + "1";
                            break;
                        }
                        case 3: {
                            Info = Info + "2";
                            break;
                        }
                        case 0: {
                            Info = Info + "None";
                            break;
                        }
                        default: {
                            Info = Info + "undefined";
                        }
                    }
                    Info = Info + " ]";
                }
            }
        }
        return Info;
    }

    public Color GetFlowInfoColor() {
        if (this.GetFlowEnabled() == 0) {
            return Color.BLACK;
        }
        return Color.BLUE;
    }

    public void InitNbFrameSent() {
        this.SentFrameNb1Hz = 0;
        this.SentFrameNbFe = 0;
    }

    public void IncNbFrameSent1Hz() {
        ++this.SentFrameNb1Hz;
    }

    public void IncNbFrameSentFe() {
        ++this.SentFrameNbFe;
    }

    public String GetNbFrameSentStr() {
        return Integer.toString(this.SentFrameNbFe) + " Packets Sent";
    }
}

