/*
 * Decompiled with CFR 0.152.
 */
package SimulatorPackage;

import javax.swing.JTextArea;

public class SimulatorDisplay {
    private JTextArea DisplayArea = new JTextArea();
    private String DisplayText = new String("");
    private int OutputId = 0;
    private boolean Enable = false;
    private int MaxSize = 0;

    public SimulatorDisplay(JTextArea _DisplayArea, int _MaxSize) {
        this.DisplayArea = _DisplayArea;
        this.MaxSize = _MaxSize;
    }

    public void Init() {
        this.DisplayText = "";
        this.Update();
    }

    public void SetOutputId(int _OutputId) {
        this.OutputId = _OutputId;
        this.Init();
    }

    public void Start() {
        this.Init();
        this.Enable = true;
    }

    public void Stop() {
        this.Enable = false;
    }

    public void AddFrame(int Output_Id, String Frame2) {
        if (!this.Enable) {
            return;
        }
        if (this.OutputId != Output_Id) {
            return;
        }
        if (Frame2.equalsIgnoreCase("") || Frame2.length() < 2) {
            return;
        }
        this.DisplayText = Frame2.contains("\r\n") || Frame2.contains("\n") || Frame2.contains("\r\n") ? this.DisplayText + Frame2 : this.DisplayText + Frame2 + "\r\n";
        this.ResizeText();
        this.Update();
    }

    public void AddFrame(int Output_Id, byte[] Frame2, int Lenght) {
        if (!this.Enable) {
            return;
        }
        if (this.OutputId != Output_Id) {
            return;
        }
        this.DisplayText = this.DisplayText + new String(Frame2, 0, Lenght);
        this.ResizeText();
        this.Update();
    }

    private void ResizeText() {
        int i = 0;
        boolean CR_found = false;
        if (this.DisplayText.length() > this.MaxSize) {
            this.DisplayText = this.DisplayText.substring(this.DisplayText.length() - this.MaxSize);
            for (i = 0; i < this.DisplayText.length(); ++i) {
                if (this.DisplayText.charAt(i) != '\r') continue;
                CR_found = true;
                break;
            }
            if (CR_found && i < this.DisplayText.length() - 2) {
                this.DisplayText = this.DisplayText.substring(i);
            }
        }
    }

    public void Update() {
        this.DisplayArea.setText(this.DisplayText.substring(0, Math.max(this.DisplayText.length() - 2, 0)));
    }
}

