/*
 * Decompiled with CFR 0.152.
 */
package SimulatorPackage;

import EncoderPackage.ProtocolEncoder;
import FlowReaderWriterPackage.FlowEthernetReaderWriter;
import FlowReaderWriterPackage.FlowReaderWriter;
import FlowReaderWriterPackage.FlowSerialReaderWriter;
import InfosPackage.OutputFlowInfo;
import SimulatorPackage.SimulatorFrame;
import SimulatorPackage.SimulatorScrambler;
import Tools.TimeTool;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class SimulatorWriterManager
extends Thread {
    int Manager_State = 0;
    Timer ManagerTimer = null;
    OutputFlowInfo OutputFlowInfos;
    SimulatorScrambler[] Scramblers;
    private float Seconds = 0.0f;
    private float Seconds_fe = 0.0f;
    private float Seconds_f1hz = 0.0f;
    boolean F1Hz_Done = false;
    private int Send_Frame = 0;
    private FlowEthernetReaderWriter OutputEthernetWriter = null;
    private FlowSerialReaderWriter OutputSerialWriter = null;
    private FlowReaderWriter OutputFlowWriter = null;
    private ProtocolEncoder OutputEncoder = null;
    Boolean IsStarted = false;
    TimeTool TIMETool;
    SimulatorFrame Frame = null;
    int Id = 0;
    int ret = 0;
    private static final int TIMER_PERIOD = 50;
    private static final int OUTPUT_PRECISION = 25;
    private static final int IDLE_STATE = 0;
    private static final int CONNECTION_STATE = 1;
    private static final int WRITING_STATE = 2;
    private static final int DISCONNECTION_STATE = 4;
    private static final int RECONNECTION_STATE = 5;

    public SimulatorWriterManager(OutputFlowInfo _FlowInfo, final int Id) {
        this.OutputFlowInfos = _FlowInfo;
        this.Id = Id;
        this.OutputEthernetWriter = new FlowEthernetReaderWriter(this.OutputFlowInfos);
        this.OutputSerialWriter = new FlowSerialReaderWriter(this.OutputFlowInfos);
        this.TIMETool = new TimeTool();
        this.ManagerTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (SimulatorWriterManager.this.GetState() == 2) {
                    SimulatorWriterManager.this.OutputEncoder.SampleTime();
                    SimulatorWriterManager.this.Seconds = ((SimulatorWriterManager)SimulatorWriterManager.this).OutputEncoder.TIMETool.GetSeconds();
                    if ((SimulatorWriterManager.this.Seconds - (float)((int)SimulatorWriterManager.this.Seconds)) * 1000.0f >= 0.0f && (SimulatorWriterManager.this.Seconds - (float)((int)SimulatorWriterManager.this.Seconds)) * 1000.0f < 500.0f && !SimulatorWriterManager.this.F1Hz_Done) {
                        SimulatorWriterManager.this.F1Hz_Done = true;
                        SimulatorWriterManager.this.OutputEncoder.EncodeFrame1HzTry(Id);
                        SimulatorWriterManager.this.OutputFlowInfos.IncNbFrameSent1Hz();
                    }
                    if ((SimulatorWriterManager.this.Seconds - (float)((int)SimulatorWriterManager.this.Seconds)) * 1000.0f >= 500.0f) {
                        SimulatorWriterManager.this.F1Hz_Done = false;
                    }
                    double Seconds_fe_diff = SimulatorWriterManager.this.Seconds - SimulatorWriterManager.this.Seconds_fe;
                    Seconds_fe_diff = (Seconds_fe_diff + 60.0) % 60.0;
                    Seconds_fe_diff *= 1000.0;
                    if ((Seconds_fe_diff += 25.0) >= (double)SimulatorWriterManager.this.OutputFlowInfos.GetRate_ms()) {
                        SimulatorWriterManager.this.Seconds_fe = SimulatorWriterManager.this.Seconds;
                        SimulatorWriterManager.this.OutputEncoder.EncodeFrameFeTry(Id);
                        SimulatorWriterManager.this.OutputFlowInfos.IncNbFrameSentFe();
                    }
                    if (SimulatorWriterManager.this.OutputEncoder.EncodeFrameIsAvailable()) {
                        int ScramblersNb = SimulatorWriterManager.this.Scramblers[0].GetScramblerNb();
                        SimulatorWriterManager.this.Scramblers[0].SetInputData(SimulatorWriterManager.this.OutputEncoder.GetEncodedBinaryFrame(), SimulatorWriterManager.this.OutputEncoder.GetEncodedBinaryFrameLenght());
                        for (int i = 0; i < ScramblersNb; ++i) {
                            if (i != 0) {
                                SimulatorWriterManager.this.Scramblers[i].SetInputData(SimulatorWriterManager.this.Scramblers[i - 1].Get_ScrambledData(), SimulatorWriterManager.this.Scramblers[i - 1].Get_ScrambledLenght());
                            }
                            if (!SimulatorWriterManager.this.OutputFlowInfos.GetScrambling()) continue;
                            SimulatorWriterManager.this.Scramblers[i].Scramble();
                        }
                        SimulatorWriterManager.this.ret = SimulatorWriterManager.this.OutputFlowWriter.FlowWriteTry(SimulatorWriterManager.this.Scramblers[ScramblersNb - 1].Get_ScrambledData(), SimulatorWriterManager.this.Scramblers[ScramblersNb - 1].Get_ScrambledLenght());
                        SimulatorFrame.Display.AddFrame(Id + 1, SimulatorWriterManager.this.Scramblers[ScramblersNb - 1].Get_ScrambledData(), SimulatorWriterManager.this.Scramblers[ScramblersNb - 1].Get_ScrambledLenght());
                    }
                    SimulatorWriterManager.this.OutputEncoder.EncodeFrameInit();
                    if (SimulatorWriterManager.this.ret < 0) {
                        SimulatorWriterManager.this.OutputFlowInfos.InitNbFrameSent();
                        SimulatorWriterManager.this.SetState(5);
                    }
                }
            }
        });
        this.ManagerTimer.start();
        this.start();
    }

    public void Start(ProtocolEncoder _OutputEncoder, SimulatorScrambler[] Scramblers) {
        this.OutputEncoder = _OutputEncoder;
        this.OutputEncoder.EncodeFrameInit();
        this.Scramblers = Scramblers;
        switch (this.OutputFlowInfos.GetFlowType()) {
            case 2: {
                this.OutputFlowWriter = this.OutputSerialWriter;
                break;
            }
            default: {
                this.OutputFlowWriter = this.OutputEthernetWriter;
            }
        }
        this.OutputFlowInfos.InitNbFrameSent();
        this.IsStarted = true;
        this.SetState(1);
    }

    public void Stop() {
        this.IsStarted = false;
        this.SetState(4);
    }

    public FlowReaderWriter GetFlow() {
        return this.OutputFlowWriter;
    }

    public boolean IsStarted() {
        return this.IsStarted;
    }

    private void SetState(int State2) {
        this.Manager_State = State2;
    }

    private int GetState() {
        return this.Manager_State;
    }

    @Override
    public void run() {
        int Connection_Result = 1;
        while (true) {
            switch (this.GetState()) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.OutputFlowInfos.GetFlowEnabled() == 0) {
                        this.SetState(0);
                        break;
                    }
                    Connection_Result = this.OutputFlowWriter.FlowOpen();
                    if (Connection_Result != 0) break;
                    this.SetState(2);
                    break;
                }
                case 2: {
                    if (this.Send_Frame != 1) break;
                    this.Send_Frame = 0;
                    break;
                }
                case 5: {
                    this.OutputFlowWriter.FlowClose();
                    this.SetState(1);
                    break;
                }
                case 4: {
                    this.OutputFlowWriter.FlowClose();
                    this.SetState(0);
                    break;
                }
                default: {
                    this.SetState(4);
                }
            }
            try {
                SimulatorWriterManager.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SimulatorWriterManager.yield();
        }
    }

    public String GetFlowState() {
        String state = new String("");
        if (this.OutputFlowWriter == null || this.OutputFlowInfos.GetFlowEnabled() == 0 || this.GetState() == 0) {
            state = state + "Idle";
        } else if (this.OutputFlowWriter.IsFlowOpened()) {
            switch (this.OutputFlowInfos.GetFlowType()) {
                case 2: {
                    state = state + "Port opened";
                    break;
                }
                case 1: {
                    state = state + "Connected";
                    break;
                }
                default: {
                    state = state + "None";
                }
            }
            state = state + " - ";
            state = state + " [ " + this.OutputFlowInfos.GetNbFrameSentStr() + " ]";
        } else {
            switch (this.OutputFlowInfos.GetFlowType()) {
                case 2: {
                    state = state + "Trying to open port";
                    break;
                }
                case 1: {
                    switch (this.OutputFlowInfos.GetEthernetConnType()) {
                        case 0: {
                            state = state + "Trying to connect";
                            break;
                        }
                        case 1: {
                            state = state + "Waiting for connection";
                            break;
                        }
                        case 2: {
                            state = state + "Trying to open socket";
                            break;
                        }
                        case 3: {
                            state = state + "Trying to open socket";
                        }
                    }
                    break;
                }
                default: {
                    state = state + "None";
                }
            }
        }
        return state;
    }

    public Color GetFlowStateColor() {
        if (this.OutputFlowWriter == null || this.OutputFlowInfos.GetFlowEnabled() == 0) {
            return Color.BLACK;
        }
        if (this.OutputFlowWriter.IsFlowOpened()) {
            return Color.BLUE;
        }
        return Color.RED;
    }
}

