/*
 * Decompiled with CFR 0.152.
 */
package FlowWriters;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import javax.swing.Timer;

public class FlowFileWriter {
    String FileName = "";
    String UsableFileName = "";
    String CurrentFileName = "";
    int FileNum = 0;
    int SegFileNum = 1;
    long MaxSize = 0L;
    long lCurrentLogSize = 0L;
    long lTotalLogSize = 0L;
    boolean IsHeaderLineWritten = false;
    Timer xTimer = null;
    int MaxTime = 0;
    int iCurrentLogTime = 0;
    int iTotalLogTime = 0;
    OutputStream _FileOutputStream;
    BufferedOutputStream _BufferedOutputStream;
    DataOutputStream _DataOutputStream;
    FileChannel _Filechannel = null;
    public static final int CONNECTED = 0;
    public static final int DISCONNECTED = 1;

    public FlowFileWriter(String _FileName, int MaxSize, int MaxTime) {
        this.FileName = _FileName;
        this.SetUsableFileName();
        this.SegFileNum = 1;
        this.InitLogSizeManagement(MaxSize);
        this.InitLogTimeManagement(MaxTime);
        this.UpdateFileName();
        this.FlowOpen();
    }

    public String GetFileName() {
        return this.FileName;
    }

    public long GetMaxSize() {
        return this.MaxSize;
    }

    public int GetMaxTime() {
        return this.MaxTime;
    }

    public String GetFileNumExtension() {
        if (this.GetMaxSize() != 0L || this.GetMaxTime() != 0) {
            return "" + (this.FileNum != 0 ? Integer.valueOf(this.FileNum) : "") + "_" + this.SegFileNum;
        }
        return "" + (this.FileNum != 0 ? Integer.valueOf(this.FileNum) : "");
    }

    public int FlowOpen() {
        try {
            this._FileOutputStream = new FileOutputStream(this.GetCurrentFileName());
            this._BufferedOutputStream = new BufferedOutputStream(this._FileOutputStream);
            this._DataOutputStream = new DataOutputStream(this._BufferedOutputStream);
            this._DataOutputStream.flush();
            this.InitCurrentLogSize();
            this.InitCurrentLogTime();
            this.setIsHeaderLineWritten(false);
            return 0;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return 1;
        }
    }

    public int FlowWrite(String Frame) {
        if (this._DataOutputStream == null) {
            return 1;
        }
        if (Frame.equalsIgnoreCase("") || Frame.length() <= 3) {
            return 0;
        }
        try {
            this._DataOutputStream.write(Frame.getBytes());
            this._DataOutputStream.write("\r\n".getBytes());
            this._DataOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.UpdateLogSize(Frame.length());
        this.CreateNewFile();
        return 0;
    }

    public int FlowWrite(byte[] Frame, int Lenght) {
        if (this._DataOutputStream == null) {
            return 1;
        }
        if (Lenght <= 3) {
            return 0;
        }
        try {
            this._DataOutputStream.write(Frame, 0, Lenght);
            this._DataOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.UpdateLogSize(Lenght);
        this.CreateNewFile();
        return 0;
    }

    public int FlowClose() {
        try {
            if (this._Filechannel != null) {
                this._Filechannel.close();
            }
            if (this._FileOutputStream != null) {
                this._FileOutputStream.close();
            }
            this._Filechannel = null;
            this._FileOutputStream = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 1;
    }

    private void CreateNewFile() {
        boolean NewFileNeeded = false;
        if (this.GetMaxTime() > 0 && this.GetCurrentLogTime() > this.GetMaxTime()) {
            NewFileNeeded = true;
        }
        if (this.GetMaxSize() > 0L && this.GetCurrentLogSize() > this.GetMaxSize()) {
            NewFileNeeded = true;
        }
        if (NewFileNeeded) {
            this.FlowClose();
            this.UpdateFileName();
            this.FlowOpen();
        }
    }

    private int SetUsableFileName() {
        File f;
        String _UsableFileName = new String("");
        String _UsableFileExtension = new String("");
        String _SegFileExtension = new String("");
        int UsableFileNum = 0;
        if (this.FileName.contains(".log")) {
            _UsableFileName = this.FileName.replace(".log", "");
            _UsableFileExtension = ".log";
        } else if (this.FileName.contains(".txt")) {
            _UsableFileName = this.FileName.replace(".txt", "");
            _UsableFileExtension = ".txt";
        }
        _SegFileExtension = this.GetMaxSize() != 0L || this.GetMaxTime() != 0 ? "_1" : "";
        for (UsableFileNum = 0; UsableFileNum < 1000 && (f = new File(_UsableFileName + (UsableFileNum != 0 ? Integer.valueOf(UsableFileNum) : "") + _SegFileExtension + _UsableFileExtension)).exists(); ++UsableFileNum) {
        }
        if (UsableFileNum < 1000) {
            this.UsableFileName = _UsableFileName + (UsableFileNum != 0 ? Integer.valueOf(UsableFileNum) : "") + _UsableFileExtension;
            this.FileNum = UsableFileNum;
            return 0;
        }
        return -1;
    }

    private void UpdateFileName() {
        if (this.GetMaxSize() == 0L && this.GetMaxTime() == 0) {
            this.CurrentFileName = this.UsableFileName;
        } else {
            if (this.UsableFileName.contains(".log")) {
                this.CurrentFileName = this.UsableFileName.replace(".log", "_" + this.SegFileNum + ".log");
            } else if (this.UsableFileName.contains(".txt")) {
                this.CurrentFileName = this.UsableFileName.replace(".txt", "_" + this.SegFileNum + ".txt");
            }
            ++this.SegFileNum;
        }
    }

    public String GetCurrentFileName() {
        return this.CurrentFileName;
    }

    public int GetCurrentFileNumber() {
        return this.SegFileNum;
    }

    private void InitLogSizeManagement(int MaxSize) {
        this.lCurrentLogSize = 0L;
        this.lTotalLogSize = 0L;
        this.MaxSize = MaxSize * 1024 * 1024;
    }

    private void UpdateLogSize(long Lenght) {
        this.lCurrentLogSize += Lenght;
        this.lTotalLogSize += Lenght;
    }

    private void InitCurrentLogSize() {
        this.lCurrentLogSize = 0L;
    }

    public long GetCurrentLogSize() {
        return this.lCurrentLogSize;
    }

    public long GetCurrentLogSizeinMo() {
        return this.lCurrentLogSize / 1024L / 1024L;
    }

    public long GetTotalLogSize() {
        return this.lTotalLogSize;
    }

    public long GetTotalLogSizeinMo() {
        return this.lTotalLogSize / 1024L / 1024L;
    }

    private void InitLogTimeManagement(int MaxTime) {
        this.iCurrentLogTime = 0;
        this.iTotalLogTime = 0;
        this.MaxTime = MaxTime;
        this.xTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlowFileWriter.this.UpdateLogTime(1);
            }
        });
        this.xTimer.start();
    }

    private void UpdateLogTime(int Time) {
        this.iCurrentLogTime += Time;
        this.iTotalLogTime += Time;
    }

    private void InitCurrentLogTime() {
        this.iCurrentLogTime = 0;
    }

    public int GetCurrentLogTime() {
        return this.iCurrentLogTime;
    }

    public int GetTotalLogTime() {
        return this.iTotalLogTime;
    }

    public void setIsHeaderLineWritten(boolean done) {
        this.IsHeaderLineWritten = done;
    }

    public boolean getIsHeaderLineWritten() {
        return this.IsHeaderLineWritten;
    }
}

