/*
 * Decompiled with CFR 0.152.
 */
package LoggerDecoder;

import LoggerDecoder.LogInfo;
import LoggerDecoder.LoggerDecoderFrame;

public class Decoder {
    private int Protocole_Type;
    private int[] Telegram_Length;
    private int Telegram_Nb;
    private int UsedBlkId;
    private boolean HeaderPartFound;
    private boolean isImplemented = true;
    private byte[][] Start_Frame;
    private int Start_Length;
    private boolean[][] FoundStartByte;
    private boolean FullHeaderFound;
    private int[] Size_Index;
    private int[] Size_Type;
    private int[] Size_Endianness;
    private int Read_Index;
    private int Frame_Available;
    private int Nb_Bytes_Read;
    public boolean FirstFrame = true;
    protected LogInfo Info;
    public byte[] Bytes_Frame;
    public int Bytes_Frame_Lenght;
    public String ASCII_Frame;
    public String InterpretedFrame;
    public static final int MAXNB_FRAMES_DFT = 1;
    private String[] InterpretedFrameList = new String[1];
    private int InterpretedFrameList_Nb = 0;
    public static final int MAXNB_TELEGRAM = 30;
    public static final int MAXNB_SYNCHRO_BYTES = 10;
    public static final char BINARY = '\u0000';
    public static final char ASCII = '\u0001';
    public static final char NONE = '\u0002';
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    public static final int SIZE_8BITS = 0;
    public static final int SIZE_16BITS = 1;
    public static final int DECODER_BUFF_SIZE = 1024;
    public int period = 1;

    public Decoder() {
        this.InitialInit();
    }

    public Decoder(LogInfo _Info) {
        this.InitialInit();
        this.Info = _Info;
    }

    private void InitialInit() {
        this.Bytes_Frame = new byte[1024];
        this.InterpretedFrame = "";
        this.InterpretedFrameList_Nb = 0;
        this.Start_Frame = new byte[30][10];
        this.Telegram_Length = new int[30];
        this.FoundStartByte = new boolean[30][10];
        this.Size_Index = new int[30];
        this.Size_Type = new int[30];
        this.Size_Endianness = new int[30];
        for (int i = 0; i < 30; ++i) {
            this.Size_Index[i] = 65535;
            this.Size_Type[i] = 0;
        }
        this.Telegram_Nb = 0;
    }

    public void SetUseOn() {
        for (int i = 0; i < 1; ++i) {
            this.InterpretedFrameList[i] = new String();
        }
    }

    public void DecodeInit(int Proto_Type, int Telegram_Length, byte[] Start, int Start_Length) {
        this.Protocole_Type = Proto_Type;
        this.Start_Length = Start_Length;
        this.Telegram_Length[this.Telegram_Nb] = Telegram_Length >= 1024 ? 1024 : Telegram_Length;
        for (int i = 0; i < Start_Length; ++i) {
            this.Start_Frame[this.Telegram_Nb][i] = Start[i];
            this.FoundStartByte[this.Telegram_Nb][i] = false;
        }
        if (this.Telegram_Nb < 30) {
            ++this.Telegram_Nb;
        }
        this.Reinit();
    }

    public void DecodeInit(int Proto_Type, int Lenght, byte[] Start, int Start_Lenght, int Size_Index, int Size_Type, int Size_Endianness) {
        this.Size_Index[this.Telegram_Nb] = Size_Index;
        this.Size_Type[this.Telegram_Nb] = Size_Type;
        this.Size_Endianness[this.Telegram_Nb] = Size_Endianness;
        this.DecodeInit(Proto_Type, Lenght, Start, Start_Lenght);
    }

    public void Reinit(LogInfo _Info) {
        this.Info = _Info;
        this.Reinit();
    }

    public void Reinit() {
        this.Read_Index = 0;
        this.Frame_Available = 0;
        this.Bytes_Frame_Lenght = 0;
        this.Nb_Bytes_Read = 0;
        this.FirstFrame = true;
        this.ReInitialize_SpecificParameters();
    }

    public void ReInitialize_SpecificParameters() {
    }

    public int GetProtoType() {
        return this.Protocole_Type;
    }

    public void SetCurvePlotImplementation(boolean isImplemented) {
        this.isImplemented = isImplemented;
    }

    public boolean GetCurvePlotImplementation() {
        return this.isImplemented;
    }

    public void SetMaximumFramesNumber(int Nb) {
        this.InterpretedFrameList = new String[Nb];
    }

    public int SplitFrame(byte[] Input, int Nb_Bytes) {
        int i = 0;
        if (this.Frame_Available == 1) {
            this.Frame_Available = 0;
            this.Bytes_Frame_Lenght = 0;
        }
        this.Nb_Bytes_Read = 0;
        block0 : switch (this.Protocole_Type) {
            case 0: {
                for (i = 0; i < Nb_Bytes; ++i) {
                    ++this.Nb_Bytes_Read;
                    if (this.Read_Index < this.Start_Length) {
                        this.HeaderPartFound = false;
                        for (int BlkId = 0; BlkId < this.Telegram_Nb; ++BlkId) {
                            int n;
                            if (Input[i] != this.Start_Frame[BlkId][this.Read_Index]) continue;
                            if (this.Read_Index == 0) {
                                for (n = 0; n < this.Start_Length; ++n) {
                                    this.FoundStartByte[BlkId][n] = false;
                                }
                            }
                            this.FoundStartByte[BlkId][this.Read_Index] = true;
                            this.Bytes_Frame[this.Read_Index] = Input[i];
                            this.HeaderPartFound = true;
                            if (this.Read_Index != this.Start_Length - 1) continue;
                            this.FullHeaderFound = true;
                            for (n = 0; n < this.Start_Length; ++n) {
                                if (this.FoundStartByte[BlkId][n]) continue;
                                this.FullHeaderFound = false;
                            }
                            if (!this.FullHeaderFound) continue;
                            this.UsedBlkId = BlkId;
                            for (int blk = 0; blk < this.Telegram_Nb; ++blk) {
                                for (int n2 = 0; n2 < this.Start_Length; ++n2) {
                                    this.FoundStartByte[blk][n2] = false;
                                }
                            }
                        }
                        if (!this.HeaderPartFound) {
                            System.out.println("Lost: " + Integer.toHexString(new Integer(Input[i])));
                            this.Read_Index = 0;
                            continue;
                        }
                        ++this.Read_Index;
                        continue;
                    }
                    if (this.Read_Index == this.Size_Index[this.UsedBlkId]) {
                        if (this.Size_Type[this.UsedBlkId] == 0) {
                            this.Telegram_Length[this.UsedBlkId] = Input[i] & 0xFF;
                        } else if (this.Size_Type[this.UsedBlkId] == 1) {
                            this.Telegram_Length[this.UsedBlkId] = this.Size_Endianness[this.UsedBlkId] == 1 ? (Input[i] & 0xFF) << 8 : Input[i] & 0xFF;
                        }
                    }
                    if (this.Read_Index == this.Size_Index[this.UsedBlkId] + 1 && this.Size_Type[this.UsedBlkId] == 1) {
                        if (this.Size_Endianness[this.UsedBlkId] == 1) {
                            int n = this.UsedBlkId;
                            this.Telegram_Length[n] = this.Telegram_Length[n] | Input[i] & 0xFF;
                        } else {
                            int n = this.UsedBlkId;
                            this.Telegram_Length[n] = this.Telegram_Length[n] | (Input[i] & 0xFF) << 8;
                        }
                    }
                    if (this.Read_Index < 1024) {
                        this.Bytes_Frame[this.Read_Index++] = Input[i];
                    }
                    if (this.Read_Index != this.Telegram_Length[this.UsedBlkId]) continue;
                    this.Bytes_Frame_Lenght = this.Read_Index;
                    this.Frame_Available = 1;
                    this.Read_Index = 0;
                    break block0;
                }
                break;
            }
            case 1: {
                for (i = 0; i < Nb_Bytes; ++i) {
                    ++this.Nb_Bytes_Read;
                    if (Input[i] == 10 || Input[i] == 13) {
                        if (this.Read_Index > 0) {
                            this.Bytes_Frame[this.Read_Index++] = 13;
                            this.Bytes_Frame[this.Read_Index++] = 10;
                            this.ASCII_Frame = new String(this.Bytes_Frame);
                            this.Bytes_Frame_Lenght = this.Read_Index;
                            this.Frame_Available = 1;
                            this.Read_Index = 0;
                            break block0;
                        }
                    } else {
                        this.Bytes_Frame[this.Read_Index++] = Input[i];
                    }
                    if (this.Read_Index < 1023) continue;
                    this.Read_Index = 0;
                }
                break;
            }
            case 2: {
                for (i = 0; i < Nb_Bytes; ++i) {
                    ++this.Nb_Bytes_Read;
                    this.Bytes_Frame[this.Read_Index++] = Input[i];
                }
                this.Bytes_Frame_Lenght = this.Read_Index;
                this.Frame_Available = 1;
                this.Read_Index = 0;
            }
        }
        return this.Frame_Available == 1 ? this.Nb_Bytes_Read : 0;
    }

    public byte[] GetSplittedFrame() {
        return this.Bytes_Frame;
    }

    public int GetSplittedFrameLenght() {
        return this.Bytes_Frame_Lenght;
    }

    public int InterpretFrameTry(byte[] Splitted_Frame, int Lenght) {
        this.InterpretedFrame = "";
        return this.InterpretFrame(Splitted_Frame, Lenght);
    }

    public int InterpretFrame(byte[] Splitted_Frame, int Lenght) {
        return 0;
    }

    public void InterpretedFrame_ResetList() {
        this.InterpretedFrameList_Nb = 0;
    }

    public void InterpretedFrame_AddToList(String Frame) {
        this.InterpretedFrameList[this.InterpretedFrameList_Nb++] = Frame;
    }

    public String GetInterpretedFrame(int Id) {
        return this.InterpretedFrameList[Id];
    }

    public int GetInterpretedFrameNb() {
        return this.InterpretedFrameList_Nb;
    }

    public String GetFileHeading() {
        return "";
    }

    public int Convert_4Bytes_to_SignedInt(byte[] data, int index, int Endian) {
        int i = 0;
        int accum = 0;
        for (int shiftBy = 24; shiftBy >= 0; shiftBy -= 8) {
            accum |= (data[i + index] & 0xFF) << (Endian == 1 ? shiftBy : 24 - shiftBy);
            ++i;
        }
        return accum;
    }

    public long Convert_8Bytes_to_SignedInt(byte[] data, int index, int Endian) {
        int i = 0;
        long accum = 0L;
        for (int shiftBy = 56; shiftBy >= 0; shiftBy -= 8) {
            accum |= ((long)data[i + index] & 0xFFL) << (Endian == 1 ? shiftBy : 56 - shiftBy);
            ++i;
        }
        return accum;
    }

    public long Convert_5Bytes_to_SignedInt(byte[] data, int index, int Endian) {
        int i = 0;
        long accum = 0L;
        for (int shiftBy = 32; shiftBy >= 0; shiftBy -= 8) {
            accum |= ((long)data[i + index] & 0xFFL) << (Endian == 1 ? shiftBy : 32 - shiftBy);
            ++i;
        }
        return accum;
    }

    public int Convert_2Bytes_to_SignedInt(byte[] data, int index, int Endian) {
        int i = 0;
        int accum = 0;
        for (int shiftBy = 8; shiftBy >= 0; shiftBy -= 8) {
            accum |= (data[i + index] & 0xFF) << (Endian == 1 ? shiftBy : 8 - shiftBy);
            ++i;
        }
        return accum >= 32768 ? accum - 65536 : accum;
    }

    public int Convert_2Bytes_to_UnsignedInt(byte[] data, int index, int Endian) {
        int i = 0;
        int accum = 0;
        for (int shiftBy = 8; shiftBy >= 0; shiftBy -= 8) {
            accum |= (data[i + index] & 0xFF) << (Endian == 1 ? shiftBy : 8 - shiftBy);
            ++i;
        }
        return accum;
    }

    public int Convert_3Bytes_to_UnsignedInt(byte[] data, int index, int Endian) {
        int i = 0;
        int accum = 0;
        for (int shiftBy = 16; shiftBy >= 0; shiftBy -= 8) {
            accum |= (data[i + index] & 0xFF) << (Endian == 1 ? shiftBy : 16 - shiftBy);
            ++i;
        }
        return accum;
    }

    public int Convert_3Bytes_to_SignedInt(byte[] data, int index, int Endian) {
        int i = 0;
        int accum = 0;
        for (int shiftBy = 16; shiftBy >= 0; shiftBy -= 8) {
            accum |= (data[i + index] & 0xFF) << (Endian == 1 ? shiftBy : 16 - shiftBy);
            ++i;
        }
        return accum >= 0x800000 ? accum - 0x1000000 : accum;
    }

    public long Convert_4Bytes_to_UnsignedInt(byte[] data, int index, int Endian) {
        int i = 0;
        long accum = 0L;
        for (int shiftBy = 24; shiftBy >= 0; shiftBy -= 8) {
            accum |= ((long)data[i + index] & 0xFFL) << (Endian == 1 ? shiftBy : 24 - shiftBy);
            ++i;
        }
        return accum;
    }

    public long Convert_5Bytes_to_UnsignedInt(byte[] data, int index, int Endian) {
        int i = 0;
        long accum = 0L;
        for (int shiftBy = 32; shiftBy >= 0; shiftBy -= 8) {
            accum |= ((long)data[i + index] & 0xFFL) << (Endian == 1 ? shiftBy : 8 - shiftBy);
            ++i;
        }
        return accum;
    }

    public long Convert_6Bytes_to_UnsignedInt(byte[] data, int index, int Endian) {
        int i = 0;
        long accum = 0L;
        for (int shiftBy = 40; shiftBy >= 0; shiftBy -= 8) {
            accum |= ((long)data[i + index] & 0xFFL) << (Endian == 1 ? shiftBy : 8 - shiftBy);
            ++i;
        }
        return accum;
    }

    public long Convert_8Bytes_to_UnsignedInt(byte[] data, int index, int Endian) {
        int i = 0;
        long accum = 0L;
        for (int shiftBy = 56; shiftBy >= 0; shiftBy -= 8) {
            accum |= ((long)data[i + index] & 0xFFL) << (Endian == 1 ? shiftBy : 56 - shiftBy);
            ++i;
        }
        return accum;
    }

    public int Convert_1Byte_to_SignedInt(byte[] data, int index, int Endian) {
        int accum = 0;
        accum = data[index] & 0xFF;
        return accum >= 128 ? accum - 256 : accum;
    }

    public int Convert_1Byte_to_UnsignedInt(byte[] data, int index, int Endian) {
        return data[index] & 0xFF;
    }

    public float Convert_2Bytes_to_Float(byte[] data, int index, int Endian) {
        int i = 0;
        int accum = 0;
        for (int shiftBy = 8; shiftBy >= 0; shiftBy -= 8) {
            accum |= (data[i + index] & 0xFF) << (Endian == 1 ? shiftBy : 8 - shiftBy);
            ++i;
        }
        return Float.intBitsToFloat(accum);
    }

    public float Convert_4Bytes_to_Float(byte[] data, int index, int Endian) {
        int i = 0;
        int accum = 0;
        for (int shiftBy = 24; shiftBy >= 0; shiftBy -= 8) {
            accum |= (data[i + index] & 0xFF) << (Endian == 1 ? shiftBy : 24 - shiftBy);
            ++i;
        }
        return Float.intBitsToFloat(accum);
    }

    public double Convert_8Bytes_to_Double(byte[] data, int index, int Endian) {
        int i = 0;
        long accum = 0L;
        for (int shiftBy = 56; shiftBy >= 0; shiftBy -= 8) {
            accum |= ((long)data[i + index] & 0xFFL) << (Endian == 1 ? shiftBy : 56 - shiftBy);
            ++i;
        }
        return Double.longBitsToDouble(accum);
    }

    public double Convert_8Bytes_Q1548_to_Double(byte[] data, int index, int Endian) {
        byte[] intPart_data = new byte[2];
        byte[] decPart_data = new byte[6];
        if (Endian != 1) {
            intPart_data[0] = data[7 + index];
            intPart_data[1] = data[6 + index];
            decPart_data[0] = data[5 + index];
            decPart_data[1] = data[4 + index];
            decPart_data[2] = data[3 + index];
            decPart_data[3] = data[2 + index];
            decPart_data[4] = data[1 + index];
            decPart_data[5] = data[0 + index];
        } else {
            intPart_data[0] = data[0 + index];
            intPart_data[1] = data[1 + index];
            decPart_data[0] = data[2 + index];
            decPart_data[1] = data[3 + index];
            decPart_data[2] = data[4 + index];
            decPart_data[3] = data[5 + index];
            decPart_data[4] = data[6 + index];
            decPart_data[5] = data[7 + index];
        }
        int intPart = this.Convert_2Bytes_to_SignedInt(intPart_data, 0, 1);
        long decPart = this.Convert_6Bytes_to_UnsignedInt(decPart_data, 0, 1);
        double tmp = (double)intPart + (double)decPart / Math.pow(2.0, 48.0);
        return tmp;
    }

    public String InterpretIntegerAsInt(int _data) {
        return Integer.toString(_data).concat(this.Info.GetSeparator());
    }

    public String InterpretIntegerAsHex(int _data) {
        return Integer.toHexString(_data).concat(this.Info.GetSeparator()).toUpperCase();
    }

    public String InterpretIntegerAsBin(int _data) {
        if (LoggerDecoderFrame.IsStdDecoding.booleanValue()) {
            return Integer.toBinaryString(_data);
        }
        return Integer.toBinaryString(_data).concat(this.Info.GetSeparator());
    }

    public String InterpretLongAsLong(long _data) {
        return Long.toString(_data).concat(this.Info.GetSeparator());
    }

    public String InterpretLongAsHex(long _data) {
        return Long.toHexString(_data).concat(this.Info.GetSeparator()).toUpperCase();
    }

    public String InterpretLongAsBin(long _data) {
        return Long.toBinaryString(_data).concat(this.Info.GetSeparator());
    }

    public String InterpretDouble(double _data) {
        return Double.toString(_data).concat(this.Info.GetSeparator());
    }

    public String InterpretDouble(double _data, int _data_id_OR_precision) {
        if (_data_id_OR_precision < 16) {
            return Double.toString(this.TruncDouble(_data, _data_id_OR_precision)).concat(this.Info.GetSeparator());
        }
        return Double.toString(this.TruncDouble(_data, this.Info.GetPrecisionWithDataId(_data_id_OR_precision))).concat(this.Info.GetSeparator());
    }

    public String InterpretFloat(float _data) {
        return Float.toString(_data).concat(this.Info.GetSeparator());
    }

    public String InterpretFloat(float _data, int _data_id_OR_precision) {
        if (_data_id_OR_precision < 16) {
            return Float.toString(this.TruncFloat(_data, _data_id_OR_precision)).concat(this.Info.GetSeparator());
        }
        return Float.toString(this.TruncFloat(_data, this.Info.GetPrecisionWithDataId(_data_id_OR_precision))).concat(this.Info.GetSeparator());
    }

    public String InterpretString(String _str) {
        return _str + this.Info.GetSeparator();
    }

    public float TruncFloat(float f, int precision) {
        double augmentation = Math.pow(10.0, precision);
        return (float)((double)((long)((double)f * augmentation)) / augmentation);
    }

    public double TruncDouble(double f, int precision) {
        double augmentation = Math.pow(10.0, precision);
        return (double)((long)(f * augmentation)) / augmentation;
    }

    public float RoundFloat(float f, int precision) {
        double augmentation = Math.pow(10.0, precision);
        return (float)((double)Math.round((double)f * augmentation) / augmentation);
    }

    public double RoundDouble(double f, int precision) {
        double augmentation = Math.pow(10.0, precision);
        return (double)Math.round(f * augmentation) / augmentation;
    }

    public int Compute_CRC16_CCITT(byte[] ByteArray, int FirstByteIndex, int LastByteIndex) {
        int crc = 65535;
        int polynom = 4129;
        for (int n = FirstByteIndex; n <= LastByteIndex; ++n) {
            byte b = ByteArray[n];
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= polynom;
            }
        }
        return crc &= 0xFFFF;
    }

    public int Compute_CRC16_CCITT_R(byte[] ByteArray, int FirstByteIndex, int LastByteIndex, int initialValue) {
        int crc = initialValue;
        int polynom = 33800;
        for (int p = FirstByteIndex; p <= LastByteIndex; ++p) {
            crc ^= ByteArray[p] & 0xFF;
            for (int i = 0; i < 8; ++i) {
                if ((crc & 1) != 0) {
                    crc = crc >> 1 ^ polynom;
                    continue;
                }
                crc >>= 1;
            }
        }
        int data = crc ^= 0xFFFFFFFF;
        crc = crc << 8 | data >> 8 & 0xFF;
        return crc &= 0xFFFF;
    }

    public boolean NmeaChkMatches(String sFrame_no_crlf) {
        int chk_tmp = 0;
        String sChk_out = "";
        String[] s = sFrame_no_crlf.split("\\*");
        if (s.length == 2) {
            String sFrame_in = s[0];
            String sChk_in = s[1];
            for (int i = 1; i < sFrame_in.length(); ++i) {
                chk_tmp ^= sFrame_in.charAt(i) & 0xFF & 0xFF;
            }
            if (chk_tmp <= 15) {
                sChk_out = "0";
            }
            sChk_out = sChk_out + Integer.toHexString(chk_tmp).toUpperCase();
            return sChk_out.contentEquals(sChk_in);
        }
        return false;
    }
}

