/*
 * Decompiled with CFR 0.152.
 */
package LoggerDecoder;

import FlowReaders.FlowEthernetReader;
import FlowReaders.FlowFileReader;
import FlowReaders.FlowReader;
import FlowReaders.FlowSerialReader;
import FlowWriters.Decimer;
import FlowWriters.FlowFileWriter;
import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LogInfo;
import LoggerDecoder.LoggerDecoderFrame;
import Tools.jFreeChart_XY;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Timer;

public class FlowReadManager
extends Thread {
    int Manager_State = 0;
    boolean LogEnable = false;
    Timer ManagerTimer = null;
    long TotalRecTime_ms = 0L;
    long TotalRecSize_o = 0L;
    int Cptr_TO_Read = 0;
    int ToolMode = 1;
    LogInfo Info;
    private FlowFileReader FileReader;
    private FlowEthernetReader EthernetReader;
    private FlowSerialReader SerialReader;
    private FlowReader Flow = null;
    private FlowFileWriter InputLogWriter = null;
    private FlowFileWriter DecodLogWriter = null;
    private Decimer InputLogDecimer = null;
    private Decimer DecodLogDecimer = null;
    private Decoder Decod = null;
    int DecodedFrameNb = 0;
    int DecodedErrorNb = 0;
    private Encoder Encod = null;
    public static jFreeChart_XY Current_Chart;
    public static boolean initCurve;
    public static boolean jComboBox_Curve_Param_Filled;
    LoggerDecoderFrame LogFrame = null;
    private long[] temps = new long[]{0L, 0L, 0L};
    public static int point;
    int Zero_Cptr = 0;
    private static final int IDLE_STATE = 0;
    private static final int CONNECTION_STATE = 1;
    private static final int READING_STATE = 2;
    private static final int DISCONNECTION_STATE = 3;
    public static final int VOYANT_CONNEXION = 1;
    public static final int VOYANT_RECEPTION = 2;
    public static final int VOYANT_LOGGING = 3;
    public static final int VOYANT_DECODING = 4;
    public static final int TIME_OUT_READ = 10;
    public static final char STEP_PERIOD = '\u03e8';
    public static int cnt_calc;
    public static boolean freq_calculated;
    public static final int VISIBLE_MODE = 1;
    public static final int UNVISIBLE_MODE = 0;

    public FlowReadManager(LogInfo _LogInfo, LoggerDecoderFrame _LogFrame) {
        this.Info = _LogInfo;
        this.LogFrame = _LogFrame;
        this.FileReader = new FlowFileReader(this.Info);
        this.EthernetReader = new FlowEthernetReader(this.Info);
        this.SerialReader = new FlowSerialReader(this.Info);
        this.InputLogDecimer = new Decimer(this.Info.GetLogDecimFreqValue(0), this.Info.GetLogDecimRatioValue(0));
        this.DecodLogDecimer = new Decimer(this.Info.GetLogDecimFreqValue(1), this.Info.GetLogDecimRatioValue(1));
        this.ManagerTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (FlowReadManager.this.GetState() == 0) {
                    FlowReadManager.this.InitDataRecTime();
                } else {
                    FlowReadManager.this.UpdateDataRecTime(500L);
                }
                FlowReadManager.this.UpdateInformationMessagesandLights();
                FlowReadManager.this.LogFrame.Display.DisplayUpdate();
            }
        });
        this.ManagerTimer.start();
    }

    public void Start(Decoder Current_Decoder, Encoder Encod, int _Mode) {
        this.Decod = Current_Decoder;
        this.Decod.SetUseOn();
        this.Decod.Reinit(this.Info);
        this.Encod = Encod;
        this.ToolMode = _Mode;
        switch (LoggerDecoderFrame.jComboBox_SelectView.getSelectedIndex()) {
            case 0: {
                this.LogFrame.Display.DisplaySetType(0);
                this.LogFrame.Display.DisplaySetHeadFrame("");
                break;
            }
            case 1: {
                this.LogFrame.Display.DisplaySetType(1);
                this.LogFrame.Display.DisplaySetHeadFrame(this.Decod.GetFileHeading());
            }
        }
        switch (this.Info.GetFlowType()) {
            case 1: {
                this.Flow = this.FileReader;
                break;
            }
            case 2: {
                this.Flow = this.EthernetReader;
                break;
            }
            case 3: {
                this.Flow = this.SerialReader;
                break;
            }
        }
        this.ReInit();
        this.SetState(1);
    }

    public void ReInit() {
        this.InitDataRecSize();
        this.InitDataRecTime();
        this.DecodedFrameNb = 0;
        this.DecodedErrorNb = 0;
        this.LogFrame.Display.DisplayInit();
        this.UpdateInformationMessagesandLights();
        this.InputLogDecimer.InitDecimer(this.Info.GetLogDecimFreqValue(0), this.Info.GetLogDecimRatioValue(0));
        this.DecodLogDecimer.InitDecimer(this.Info.GetLogDecimFreqValue(1), this.Info.GetLogDecimRatioValue(1));
    }

    public void Stop() {
        this.SetState(3);
    }

    public void SetLogEnable(boolean _LogEnable) {
        if (_LogEnable && !this.LogEnable) {
            this.InputLogWriter = this.Info.IsInputLogEnable(0) ? new FlowFileWriter(this.Info.GetLogFileName(0), this.Info.GetLogSegmentSize(0), this.Info.GetLogSegmentTime(0)) : null;
            this.DecodLogWriter = this.Info.IsInputLogEnable(1) ? new FlowFileWriter(this.Info.GetLogFileName(1), this.Info.GetLogSegmentSize(1), this.Info.GetLogSegmentTime(1)) : null;
            this.LogEnable = true;
        } else {
            if (this.InputLogWriter != null) {
                this.InputLogWriter.FlowClose();
            }
            this.InputLogWriter = null;
            if (this.DecodLogWriter != null) {
                this.DecodLogWriter.FlowClose();
            }
            this.DecodLogWriter = null;
            this.LogEnable = false;
        }
    }

    private void SetState(int State2) {
        this.Manager_State = State2;
    }

    private int GetState() {
        return this.Manager_State;
    }

    @Override
    public void run() {
        int Connection_Result = 1;
        int Nb_Bytes = 0;
        byte[] Bytes_Frame = new byte[1024];
        int Nb_Bytes_Decoded = 0;
        double[] var_abscisse = new double[86400];
        block12: while (true) {
            switch (this.GetState()) {
                case 0: {
                    try {
                        FlowReadManager.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue block12;
                }
                case 1: {
                    Connection_Result = this.Flow.FlowOpen();
                    if (Connection_Result == 0) {
                        this.SetState(2);
                    }
                    if (this.Info.GetFlowType() != 1 || Connection_Result != 1) continue block12;
                    this.SetState(3);
                    continue block12;
                }
                case 2: {
                    Nb_Bytes = this.Flow.FlowRead(Bytes_Frame);
                    if (Nb_Bytes < 0) {
                        this.SetState(3);
                        continue block12;
                    }
                    if (Nb_Bytes != 0) {
                        this.Cptr_TO_Read = 10;
                        this.UpdateDataRecSize(Nb_Bytes);
                        int b = 0;
                        while (b < Nb_Bytes) {
                            int n = b++;
                            Bytes_Frame[n] = (byte)(Bytes_Frame[n] & 0xFF);
                        }
                        Date DisplayDate = new Date();
                        SimpleDateFormat DateFormat2 = new SimpleDateFormat("dd/MM/yy  HH:mm:ss");
                        block14: while (true) {
                            int i;
                            if ((Nb_Bytes_Decoded = this.Decod.SplitFrame(Bytes_Frame, Nb_Bytes)) == 0) continue block12;
                            if (this.InputLogDecimer.Decimate() == 0) {
                                this.LogFrame.Display.DisplayAddFrame(this.Decod.GetSplittedFrame(), this.Decod.GetSplittedFrameLenght(), 0);
                                if (this.LogEnable && this.InputLogWriter != null) {
                                    this.InputLogWriter.FlowWrite(this.Decod.GetSplittedFrame(), this.Decod.GetSplittedFrameLenght());
                                }
                            }
                            if (this.DecodLogDecimer.Decimate() == 0) {
                                ++this.DecodedFrameNb;
                                if (this.Decod.InterpretFrameTry(this.Decod.GetSplittedFrame(), this.Decod.GetSplittedFrameLenght()) > 0) {
                                    ++this.DecodedErrorNb;
                                }
                                if (this.ToolMode == 1) {
                                    for (i = 0; i < this.Decod.GetInterpretedFrameNb(); ++i) {
                                        this.LogFrame.Display.DisplayAddFrame(this.Decod.GetInterpretedFrame(i), 1);
                                    }
                                }
                                if (LoggerDecoderFrame.FrameReady && this.ToolMode == 1) {
                                    if (initCurve) {
                                        this.Init_Curves_Tracer_Interface();
                                        initCurve = false;
                                    }
                                    if (LoggerDecoderFrame.trace_start) {
                                        int ind_ordonnee = Encoder.Param_List.getIndexParam(LoggerDecoderFrame.jComboBox_Curve_Param.getSelectedItem().toString());
                                        int ind_abscisse = Encoder.Param_List.getIndexParam(LoggerDecoderFrame.jComboBox_Curve_Param_abscisse.getSelectedItem().toString());
                                        if (!Encoder.Param_List.getParam(ind_ordonnee).isEmpty()) {
                                            double substract_value;
                                            if (Encoder.Param_List.getParam(ind_abscisse).getName().matches("NBR_POINT")) {
                                                Encoder.Param_List.getParam(ind_abscisse).setValue(point);
                                            }
                                            try {
                                                substract_value = new Double(LoggerDecoderFrame.jTextField_substract_value.getText());
                                            }
                                            catch (NumberFormatException e) {
                                                substract_value = new Double("0");
                                                LoggerDecoderFrame.jTextField_substract_value.setText("0");
                                            }
                                            double var_ordonnee = Encoder.Param_List.getParam(ind_ordonnee).doubleValue();
                                            String origineString_Y_Unit = Encoder.Param_List.getParam(ind_ordonnee).getStringUnit();
                                            String toString_Y_Unit = LoggerDecoderFrame.jComboBox_Y_units.getSelectedItem().toString();
                                            int idType_Y_Unit = Encoder.Param_List.getParam(ind_ordonnee).getIdTypeUnit();
                                            var_ordonnee = this.Encod.getConv().convert(var_ordonnee, origineString_Y_Unit, toString_Y_Unit, idType_Y_Unit, LoggerDecoderFrame.jComboBoxBoardType.getSelectedIndex());
                                            var_abscisse[FlowReadManager.point - 1] = Encoder.Param_List.getParam(ind_abscisse).doubleValue();
                                            String origineString_X_Unit = Encoder.Param_List.getParam(ind_abscisse).getStringUnit();
                                            String toString_X_Unit = LoggerDecoderFrame.jComboBox_X_units.getSelectedItem().toString();
                                            int idType_X_Unit = Encoder.Param_List.getParam(ind_abscisse).getIdTypeUnit();
                                            var_abscisse[FlowReadManager.point - 1] = this.Encod.getConv().convert(var_abscisse[point - 1], origineString_X_Unit, toString_X_Unit, idType_X_Unit, LoggerDecoderFrame.jComboBoxBoardType.getSelectedIndex());
                                            Current_Chart.addvalue(0, var_abscisse[point - 1], var_ordonnee - substract_value);
                                            if (LoggerDecoderFrame.jCheckBox_glissant.isSelected()) {
                                                double min;
                                                double max = var_abscisse[point - 1];
                                                try {
                                                    min = var_abscisse[point - 1 - LoggerDecoderFrame.fenetre];
                                                }
                                                catch (ArrayIndexOutOfBoundsException e) {
                                                    min = var_abscisse[0];
                                                }
                                                if (min >= max) {
                                                    max = min + 10.0;
                                                }
                                                Current_Chart.setXaxis(null, min, max, LoggerDecoderFrame.fenetre / 10);
                                            }
                                            ++point;
                                        }
                                    }
                                }
                                if (this.DecodLogWriter != null) {
                                    if (LoggerDecoderFrame.IsStdDecoding.booleanValue()) {
                                        if (LoggerDecoderFrame.FrameReady) {
                                            int i2;
                                            if (!this.DecodLogWriter.getIsHeaderLineWritten()) {
                                                String headerLine = "";
                                                for (i2 = 1; i2 < Encoder.Param_List.size(); ++i2) {
                                                    if (!Encoder.Param_List.getParam(i2).isDataAvailable()) continue;
                                                    headerLine = headerLine + Encoder.Param_List.getParam(i2).getName() + (Encoder.Param_List.getParam(i2).getStringUnit().matches("") ? "" : "_") + Encoder.Param_List.getParam(i2).getStringUnit() + "\t";
                                                }
                                                this.DecodLogWriter.setIsHeaderLineWritten(true);
                                                this.DecodLogWriter.FlowWrite(headerLine);
                                            }
                                            String Rebuild_Frame = "";
                                            for (i2 = 1; i2 < Encoder.Param_List.size(); ++i2) {
                                                if (!Encoder.Param_List.getParam(i2).isDataAvailable()) continue;
                                                Rebuild_Frame = Rebuild_Frame + Encoder.Param_List.getParam(i2).getStringValue();
                                                Rebuild_Frame = Rebuild_Frame + "\t";
                                            }
                                            this.DecodLogWriter.FlowWrite(Rebuild_Frame);
                                        }
                                    } else {
                                        if (!this.DecodLogWriter.getIsHeaderLineWritten()) {
                                            this.DecodLogWriter.setIsHeaderLineWritten(true);
                                            this.DecodLogWriter.FlowWrite("Protocol Logger/Decoder v" + this.Info.getRevision() + " - " + this.Info.getRevisionDate() + "\n" + this.Decod.GetFileHeading());
                                        }
                                        for (i = 0; i < this.Decod.GetInterpretedFrameNb(); ++i) {
                                            this.DecodLogWriter.FlowWrite(this.Decod.GetInterpretedFrame(i));
                                        }
                                    }
                                }
                                LoggerDecoderFrame.FrameReady = false;
                                this.Decod.InterpretedFrame_ResetList();
                            }
                            Nb_Bytes -= Nb_Bytes_Decoded;
                            i = 0;
                            while (true) {
                                if (i >= Nb_Bytes) continue block14;
                                Bytes_Frame[i] = Bytes_Frame[i + Nb_Bytes_Decoded];
                                ++i;
                            }
                            break;
                        }
                    }
                    if (this.Info.GetFlowType() != 1) continue block12;
                    this.SetState(3);
                    continue block12;
                }
                case 3: {
                    this.SetLogEnable(false);
                    Connection_Result = this.Flow.FlowClose();
                    if (Connection_Result == 1) {
                        this.SetState(0);
                    }
                    this.LogFrame.Stop_Manager(1);
                    continue block12;
                }
            }
            this.SetState(3);
        }
    }

    void Init_Curves_Tracer_Interface() {
        String message;
        LoggerDecoderFrame.jComboBox_Curve_Param.removeAllItems();
        LoggerDecoderFrame.jComboBox_Curve_Param_abscisse.removeAllItems();
        int ini = 0;
        LoggerDecoderFrame.jLabel_Name_Protocole.setText("Protocol : " + LoggerDecoderFrame.jComboBox_Protocol.getSelectedItem().toString());
        if (!Encoder.Param_List.getParam(0).getName().matches("NONE")) {
            LoggerDecoderFrame.jComboBox_Curve_Param_abscisse.addItem(Encoder.Param_List.getParam(0).getName());
            ini = 1;
            LoggerDecoderFrame.jToggleButton_Start.setEnabled(true);
            LoggerDecoderFrame.jComboBox_Curve_Param.setEnabled(true);
            LoggerDecoderFrame.jComboBox_Curve_Param_abscisse.setEnabled(true);
            LoggerDecoderFrame.jButton_Curves_Reinit.setEnabled(true);
            LoggerDecoderFrame.jCheckBox_Automatic_Scale.setEnabled(true);
            LoggerDecoderFrame.jTextField_substract_value.setEnabled(true);
            message = "Click On Start";
        } else {
            LoggerDecoderFrame.jToggleButton_Start.setEnabled(false);
            LoggerDecoderFrame.jComboBox_Curve_Param.setEnabled(false);
            LoggerDecoderFrame.jComboBox_Curve_Param_abscisse.setEnabled(false);
            LoggerDecoderFrame.jButton_Curves_Reinit.setEnabled(false);
            LoggerDecoderFrame.jCheckBox_Automatic_Scale.setEnabled(false);
            LoggerDecoderFrame.jTextField_substract_value.setEnabled(false);
            message = "Protocol Not Implemented";
        }
        for (int i = ini; i < Encoder.Param_List.size(); ++i) {
            if (!(Encoder.Param_List.getParam(i).isDataAvailable() & Encoder.Param_List.getParam(i).isDrawable())) continue;
            LoggerDecoderFrame.jComboBox_Curve_Param.addItem(Encoder.Param_List.getParam(i).getName());
            LoggerDecoderFrame.jComboBox_Curve_Param_abscisse.addItem(Encoder.Param_List.getParam(i).getName());
        }
        if (LoggerDecoderFrame.IsConnected.booleanValue()) {
            int i;
            String[] Chart_Legend = new String[4];
            Chart_Legend[0] = LoggerDecoderFrame.jComboBox_Curve_Param.getSelectedItem().toString();
            String yAxisLabel = Encoder.Param_List.getParam(LoggerDecoderFrame.jComboBox_Curve_Param.getSelectedItem().toString()).getStringUnit();
            String xAxisLabel = Encoder.Param_List.getParam(LoggerDecoderFrame.jComboBox_Curve_Param_abscisse.getSelectedItem().toString()).getStringUnit();
            for (i = 0; i < LoggerDecoderFrame.jComboBox_Y_units.getItemCount(); ++i) {
                if (!LoggerDecoderFrame.jComboBox_Y_units.getItemAt(i).toString().matches(yAxisLabel)) continue;
                LoggerDecoderFrame.jComboBox_Y_units.setSelectedIndex(i);
            }
            for (i = 0; i < LoggerDecoderFrame.jComboBox_X_units.getItemCount(); ++i) {
                if (!LoggerDecoderFrame.jComboBox_X_units.getItemAt(i).toString().matches(xAxisLabel)) continue;
                LoggerDecoderFrame.jComboBox_X_units.setSelectedIndex(i);
            }
            Current_Chart = new jFreeChart_XY("Graph", 1, Chart_Legend, xAxisLabel, yAxisLabel);
            Current_Chart.setTitle("", new Font("Tahoma", 2, 11));
            Current_Chart.setMessageCurve(message);
            Current_Chart.setYaxisRange(0.0, 1.0, 0.1);
            Current_Chart.setChartPanel(LoggerDecoderFrame.jPanel_Chart);
            Current_Chart.viewChart(LoggerDecoderFrame.jPanel_Chart);
        }
    }

    public void UpdateInformationMessagesandLights() {
        String Message = "";
        switch (this.GetState()) {
            case 1: {
                switch (this.Info.GetFlowType()) {
                    case 1: {
                        Message = "Trying To Open File";
                        break;
                    }
                    case 2: {
                        switch (this.Info.GetEthernetConnType()) {
                            case 0: {
                                Message = "Trying To Connect";
                                break;
                            }
                            case 1: {
                                Message = "Waiting for Connection";
                                break;
                            }
                            case 2: {
                                Message = "Trying To Open Socket";
                                break;
                            }
                            case 3: {
                                Message = "Trying To Join Group";
                            }
                        }
                        break;
                    }
                    case 3: {
                        Message = "Trying To Open COM";
                    }
                }
                LoggerDecoderFrame.SetMessage(0, Message, Color.BLUE);
                this.LogFrame.Light.SetLedColor(1, 2);
                break;
            }
            case 2: {
                switch (this.Info.GetFlowType()) {
                    case 1: {
                        Message = "File Opened";
                        break;
                    }
                    case 2: {
                        Message = "Connected";
                        break;
                    }
                    case 3: {
                        Message = "Port Opened";
                    }
                }
                LoggerDecoderFrame.SetMessage(0, Message, Color.BLUE);
                this.LogFrame.Light.SetLedColor(1, 1);
                break;
            }
            case 0: 
            case 3: {
                switch (this.Info.GetFlowType()) {
                    case 1: {
                        Message = "File Closed";
                        break;
                    }
                    case 2: {
                        Message = "Disconnected";
                        break;
                    }
                    case 3: {
                        Message = "Port Closed";
                        break;
                    }
                    case 0: {
                        Message = "Idle";
                    }
                }
                if (this.Info.GetFlowType() == 0) {
                    LoggerDecoderFrame.SetMessage(0, Message, Color.BLACK);
                } else {
                    LoggerDecoderFrame.SetMessage(0, Message, Color.BLUE);
                }
                this.LogFrame.Light.SetLedColor(1, 0);
            }
        }
        switch (this.GetState()) {
            case 1: 
            case 2: {
                LoggerDecoderFrame.SetMessage(1, this.ConvertSizeToString(this.GetDataRecSize()) + "  in  " + this.ConvertTimeToString(this.GetDataRecTime_ins()) + " s", Color.BLUE);
                if (this.Cptr_TO_Read > 0) {
                    --this.Cptr_TO_Read;
                    this.LogFrame.Light.SetLedColor(2, 1);
                    break;
                }
                this.LogFrame.Light.SetLedColor(2, 2);
                break;
            }
            case 0: 
            case 3: {
                LoggerDecoderFrame.SetMessage(1, "Idle", Color.BLACK);
                this.LogFrame.Light.SetLedColor(2, 0);
            }
        }
        switch (this.GetState()) {
            case 1: 
            case 2: {
                if (this.InputLogWriter == null && this.DecodLogWriter == null) {
                    Message = "No Log";
                    LoggerDecoderFrame.SetMessage(2, Message, Color.BLACK);
                    this.LogFrame.Light.SetLedColor(3, 0);
                    break;
                }
                Message = "";
                Message = Message + "In: " + (this.InputLogWriter != null ? this.ConvertSizeToString(this.InputLogWriter.GetTotalLogSize()) : "No");
                Message = Message + " - ";
                Message = Message + "Dec: " + (this.DecodLogWriter != null ? this.ConvertSizeToString(this.DecodLogWriter.GetTotalLogSize()) : "No");
                LoggerDecoderFrame.SetMessage(2, Message, Color.BLUE);
                if (this.GetState() == 2) {
                    this.LogFrame.Light.SetLedColor(3, 1);
                    break;
                }
                this.LogFrame.Light.SetLedColor(3, 0);
                break;
            }
            case 0: 
            case 3: {
                LoggerDecoderFrame.SetMessage(2, "Idle", Color.BLACK);
                this.LogFrame.Light.SetLedColor(3, 0);
            }
        }
        switch (this.GetState()) {
            case 1: 
            case 2: {
                if (this.Info.GetProtocolId() == 0 || this.Decod.GetProtoType() == 2) {
                    Message = "No Decoding";
                    LoggerDecoderFrame.SetMessage(3, Message, Color.BLACK);
                    this.LogFrame.Light.SetLedColor(4, 0);
                    break;
                }
                Message = "";
                Message = Message + Integer.toString(this.DecodedFrameNb) + " Frames - " + Integer.toString(this.DecodedErrorNb) + " Errors";
                LoggerDecoderFrame.SetMessage(3, Message, Color.BLUE);
                if (this.GetState() == 2 && this.DecodedFrameNb != 0) {
                    this.LogFrame.Light.SetLedColor(4, 1);
                    break;
                }
                if (this.DecodedFrameNb == 0) {
                    this.LogFrame.Light.SetLedColor(4, 2);
                    break;
                }
                this.LogFrame.Light.SetLedColor(4, 2);
                break;
            }
            case 0: 
            case 3: {
                LoggerDecoderFrame.SetMessage(3, "Idle", Color.BLACK);
                this.LogFrame.Light.SetLedColor(4, 0);
            }
        }
    }

    public void InitDataRecSize() {
        this.TotalRecSize_o = 0L;
        this.Cptr_TO_Read = 0;
    }

    public void UpdateDataRecSize(int RecSize) {
        this.TotalRecSize_o += (long)RecSize;
    }

    public long GetDataRecSize() {
        return this.TotalRecSize_o;
    }

    public String ConvertSizeToString(long Size) {
        int Ko = (int)(Size / 1024L);
        int Mo = Ko / 1000;
        Ko %= 1024;
        if (Mo == 0) {
            return Integer.toString(Ko) + " Ko";
        }
        if (Ko < 10) {
            return Long.toString(Mo) + ".00" + Integer.toString(Ko) + " Mo";
        }
        if (Ko < 100) {
            return Long.toString(Mo) + ".0" + Integer.toString(Ko) + " Mo";
        }
        return Long.toString(Mo) + "." + Integer.toString(Ko) + " Mo";
    }

    public void InitDataRecTime() {
        this.TotalRecTime_ms = 0L;
    }

    public void UpdateDataRecTime(long RecTime) {
        this.TotalRecTime_ms += RecTime;
    }

    public int GetDataRecTime_ins() {
        return (int)(this.TotalRecTime_ms / 1000L);
    }

    public String ConvertTimeToString(long Size) {
        String Time = "";
        int s = (int)(this.TotalRecTime_ms / 1000L);
        int h = s / 3600;
        int m = (s %= 3600) / 60;
        Time = Time + (h < 10 ? "0" + Integer.toString(h) : Integer.toString(h)) + ":";
        Time = Time + (m < 10 ? "0" + Integer.toString(m) : Integer.toString(m)) + ":";
        Time = Time + (s < 10 ? "0" + Integer.toString(s) : Integer.toString(s %= 60));
        return Time;
    }

    static {
        initCurve = true;
        jComboBox_Curve_Param_Filled = false;
        point = 1;
        cnt_calc = 0;
        freq_calculated = false;
    }
}

