/*
 * Decompiled with CFR 0.152.
 */
package LoggerDecoder;

import LoggerDecoder.LoggerDecoderFrame;
import LoggerDecoder.LoggerDecoderReducedFrame;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Main {
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    public static LoggerDecoderFrame MyDecodFrame;
    public static LoggerDecoderReducedFrame MyReducedDecodFrame;

    public static void main(String[] args) throws CloneNotSupportedException, IOException {
        String _Rev = "1.115";
        String _Date = "03/03/2021";
        System.out.println("\n\nLoggerDecoder R" + _Rev);
        System.out.println("Copyright \u00a9 2018 - IXBLUE, All rights reserved.\n");
        Main.CheckSerialDll();
        boolean _Log_Request = false;
        boolean _Dec_Request = false;
        boolean _StdDec_Request = false;
        String _DecoderName = "";
        String _OutputDecodedFile = "";
        String _InputFileToBeDecoded = "";
        String _OutputLoggedFile = "";
        String _Frequency = "100";
        String _Duration = "";
        String _EthernetPort = "";
        String _Mode = "";
        String _IPAddress = "";
        String _SerialPort = "";
        String _BaudRate = "";
        String _DataBits = "";
        String _Parity = "";
        String _StopBits = "";
        Pattern p_ethernetport = Pattern.compile("\\d\\d\\d\\d");
        Pattern p_mode = Pattern.compile("[0-3]");
        Pattern p_ipaddress = Pattern.compile(IPADDRESS_PATTERN);
        Pattern p_serialport = Pattern.compile("COM(\\d+)");
        Pattern p_baudrate = Pattern.compile("[0-9]|1[0-1]");
        Pattern p_databits = Pattern.compile("[0-1]");
        Pattern p_parity = Pattern.compile("[0-2]");
        Pattern p_stopbits = Pattern.compile("[0-3]");
        if (args.length == 0) {
            MyDecodFrame = new LoggerDecoderFrame(_Rev, _Date);
            MyDecodFrame.setVisible(true);
        } else if (args.length == 3 && !args[0].substring(0, 0).contains("-")) {
            _DecoderName = args[0];
            _OutputDecodedFile = args[2];
            _InputFileToBeDecoded = args[1];
            MyDecodFrame = new LoggerDecoderFrame(_Rev, _Date, _DecoderName, _InputFileToBeDecoded, _OutputDecodedFile, _StdDec_Request, _Frequency);
            MyDecodFrame.setVisible(false);
        } else {
            block18: for (int n = 0; n < args.length; ++n) {
                switch (args[n]) {
                    case "-d": {
                        if (n + 2 < args.length) {
                            _DecoderName = args[n + 1];
                            _OutputDecodedFile = args[n + 2];
                        } else {
                            Main.OpenUsageFile();
                        }
                        _Dec_Request = true;
                        continue block18;
                    }
                    case "-l": {
                        if (n + 3 < args.length) {
                            _DecoderName = args[n + 1];
                            _Duration = args[n + 2];
                            _OutputLoggedFile = args[n + 3];
                        } else {
                            Main.OpenUsageFile();
                        }
                        _Log_Request = true;
                        continue block18;
                    }
                    case "-n": {
                        _StdDec_Request = true;
                        continue block18;
                    }
                    case "-e": {
                        if (n + 3 < args.length && Main.Validate(args[n + 1], p_ethernetport) && Main.Validate(args[n + 2], p_mode) && Main.Validate(args[n + 3], p_ipaddress)) {
                            _EthernetPort = args[n + 1];
                            _Mode = args[n + 2];
                            _IPAddress = args[n + 3];
                            continue block18;
                        }
                        Main.OpenUsageFile();
                        continue block18;
                    }
                    case "-s": {
                        if (n + 5 < args.length && Main.Validate(args[n + 1], p_serialport) && Main.Validate(args[n + 2], p_baudrate) && Main.Validate(args[n + 3], p_databits) && Main.Validate(args[n + 4], p_parity) && Main.Validate(args[n + 5], p_stopbits)) {
                            _SerialPort = args[n + 1];
                            _BaudRate = args[n + 2];
                            _DataBits = args[n + 3];
                            _Parity = args[n + 4];
                            _StopBits = args[n + 5];
                            continue block18;
                        }
                        Main.OpenUsageFile();
                        continue block18;
                    }
                    case "-Hz": {
                        if (n + 1 < args.length) {
                            _Frequency = args[n + 1];
                            continue block18;
                        }
                        Main.OpenUsageFile();
                        continue block18;
                    }
                    case "-f": {
                        if (n + 1 < args.length) {
                            _InputFileToBeDecoded = args[n + 1];
                            continue block18;
                        }
                        Main.OpenUsageFile();
                        continue block18;
                    }
                }
            }
            if (!_Log_Request && !_Dec_Request) {
                Main.OpenUsageFile();
            }
            if (_Log_Request) {
                if (_Dec_Request || _StdDec_Request || !_InputFileToBeDecoded.isEmpty() || _EthernetPort.isEmpty() && _SerialPort.isEmpty() || !_EthernetPort.isEmpty() && !_SerialPort.isEmpty()) {
                    Main.OpenUsageFile();
                }
                if (!_EthernetPort.isEmpty()) {
                    MyDecodFrame = new LoggerDecoderFrame(_Rev, _Date, _DecoderName, _Duration, _OutputLoggedFile, _EthernetPort, _Mode, _IPAddress);
                }
                if (!_SerialPort.isEmpty()) {
                    MyDecodFrame = new LoggerDecoderFrame(_Rev, _Date, _DecoderName, _Duration, _OutputLoggedFile, _SerialPort, _BaudRate, _DataBits, _Parity, _StopBits);
                }
            }
            if (_Dec_Request) {
                if (_Log_Request || _InputFileToBeDecoded.isEmpty() || !_EthernetPort.isEmpty() || !_SerialPort.isEmpty()) {
                    Main.OpenUsageFile();
                }
                MyDecodFrame = new LoggerDecoderFrame(_Rev, _Date, _DecoderName, _InputFileToBeDecoded, _OutputDecodedFile, _StdDec_Request, _Frequency);
            }
        }
    }

    private static void CheckSerialDll() throws IOException {
        int i;
        int libpath_nb = 0;
        boolean RxTxSerial_found = false;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String OSArch = System.getProperty("os.arch");
        String SunDataModel = System.getProperty("sun.arch.data.model");
        Main.AddDirToJavaLibPath(System.getProperty("user.dir") + "\\lib" + (SunDataModel.contains("64") ? "\\64" : "\\32"));
        String[] Config = System.getProperty("java.library.path").toString().split(";");
        String[] ConfigValid = new String[100];
        for (String t : Config) {
            File f;
            if (!(t.contains("Java") | t.contains("lib")) || !(f = new File(t)).exists()) continue;
            ConfigValid[libpath_nb++] = t;
        }
        System.out.println("System Properties:");
        System.out.println("os.arch: " + OSArch);
        System.out.println("sun.arch.data.model: " + SunDataModel);
        System.out.println("java.library.path:");
        for (i = 0; i < libpath_nb; ++i) {
            System.out.println(ConfigValid[i]);
        }
        System.out.println("\n");
        if (libpath_nb != 0) {
            for (i = 0; i < libpath_nb; ++i) {
                File f = new File(ConfigValid[i] + "\\rxtxSerial.dll");
                if (!f.exists()) continue;
                RxTxSerial_found = true;
            }
            if (!RxTxSerial_found) {
                String Message = "\nUnable to detect \"rxtxSerial.dll\" file used to control Serial ports.\n \nLibrary shall be located in:\n" + System.getProperty("user.dir") + "\\lib" + (SunDataModel.contains("64") ? "\\64" : "\\32") + "\n\nFor information:\n - OS architecture is " + (OSArch.contains("64") ? "64" : "32") + "-bit\n - Java platform is " + (SunDataModel.contains("64") ? "64" : "32") + "-bit\n\n";
                JOptionPane.showMessageDialog(null, Message, "iXBlue LoggerDecoder", 2);
                System.exit(0);
            }
        }
    }

    public static void AddDirToJavaLibPath(String s) throws IOException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            for (int i = 0; i < paths.length; ++i) {
                if (!s.equals(paths[i])) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = s;
            field.set(null, tmp);
            System.setProperty("java.library.path", System.getProperty("java.library.path") + File.pathSeparator + s);
            System.out.println(s);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Failed to get field handle to set library path");
        }
    }

    private static void OpenUsageFile() {
        try {
            File pdfUsageFile = new File("M-SP-POP-279-D LoggerDecoder commad line usage.pdf");
            if (pdfUsageFile.exists()) {
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().open(pdfUsageFile);
                } else {
                    System.out.println("Awt Desktop is not supported!");
                }
            } else {
                System.out.println("\n\rContact iXBlue Support to get the LoggerDecoder command line USAGE file.\n\r");
            }
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean Validate(String str, Pattern p) {
        Matcher matcher = p.matcher(str);
        return matcher.matches();
    }
}

