/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;

public class AIPOV_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;

    public AIPOV_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        ++this.current_line;
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error" + sFrame_no_crlf);
            return -1;
        }
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!params[0].contentEquals("$AIPOV")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Header error" + sFrame_no_crlf);
            return -1;
        }
        if (params.length != 23) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_tpt4(params[1])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " UTC Time format error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_ns_fpt3(params[2])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_ns_fpt3(params[13])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Altitude format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_ns_fpt3(params[20])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " True course format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt3(params[3])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll SD format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt3(params[4])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt3(params[5])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV1 Rotation Rate format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt3(params[6])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV2 Rotation Rate format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt3(params[7])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV3 Rotation Rate format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt3(params[14])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " North Speed format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt3(params[15])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " East Speed format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt3(params[16])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Vertical Speed format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt3(params[17])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV1 Speed format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt3(params[18])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV2 Speed format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt3(params[19])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV3 Speed format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt2(params[8])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV1 Acceleration format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt2(params[9])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV2 Acceleration format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt2(params[10])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " XV3 Acceleration format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_f2pt8(params[11])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Latitude format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_f3pt8(params[12])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Longitude format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_hexa8(params[21])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Status format error:" + sFrame_no_crlf);
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(100, Float.valueOf(new Double(params[1]).floatValue()), 34);
            this.Encod.setValue(103, Float.valueOf(new Double(params[2]).floatValue()), 1);
            this.Encod.setValue(104, Float.valueOf(new Double(params[3]).floatValue()), 1);
            this.Encod.setValue(105, Float.valueOf(-new Double(params[4]).floatValue()), 1);
            this.Encod.setValue(114, Float.valueOf(new Double(params[5]).floatValue()), 51);
            this.Encod.setValue(115, Float.valueOf(-new Double(params[6]).floatValue()), 51);
            this.Encod.setValue(116, Float.valueOf(-new Double(params[7]).floatValue()), 51);
            this.Encod.setValue(121, Float.valueOf(new Double(params[8]).floatValue()), 43);
            this.Encod.setValue(122, Float.valueOf(-new Double(params[9]).floatValue()), 43);
            this.Encod.setValue(123, Float.valueOf(-new Double(params[10]).floatValue()), 43);
            this.Encod.setValue(124, new Double(params[11]), 1);
            this.Encod.setValue(125, new Double(params[12]), 1);
            this.Encod.setValue(126, Float.valueOf(new Double(params[13]).floatValue()), 11);
            this.Encod.setValue(136, Float.valueOf(new Double(params[14]).floatValue()), 21);
            this.Encod.setValue(137, Float.valueOf(new Double(params[15]).floatValue()), 21);
            this.Encod.setValue(138, Float.valueOf(-new Double(params[16]).floatValue()), 21);
            this.Encod.setValue(133, Float.valueOf(new Double(params[17]).floatValue()), 21);
            this.Encod.setValue(134, Float.valueOf(-new Double(params[18]).floatValue()), 21);
            this.Encod.setValue(135, Float.valueOf(-new Double(params[19]).floatValue()), 21);
            this.Encod.setValue(147, Float.valueOf(new Double(params[20]).floatValue()), 1);
            this.Encod.setValue(610, params[21], 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(sFrame_no_crlf);
        return 0;
    }
}

